/*
   File: ebase_lexicon.h
   Stores a lexicon (by which we mean a set of vocabularies with their
   feature space of nonterminals, actual affix values and fact tables).
   Note that this does include the encoding of the runtime type system,
   affix domains and affix value constants.

   Copyright 2012 Marc Seutter
 
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: ebase_lexicon.h,v 1.5 2012/07/27 09:30:22 marcs Exp $"
*/
#ifndef IncEbaseLexicon
#define IncEbaseLexicon

/* libdcg includes */
#include <dcg.h>
#include <dcg_binfile.h>
#include <dcg_plist.h>

/* Export Lexicon as an opaque struct pointer with access routines */
typedef struct lexicon_rec *Lexicon;
#define lexicon_nil ((Lexicon) NULL)

/* Reading and freeing of a lexicon */
void ebs_read_lexicon (char *dirname, char *grammar_name, Lexicon *ret_lex);
void ebs_detach_lexicon (Lexicon *lex);

/* Access routines on specific parts */
int_list ebs_get_entries_from_entry_nr (Lexicon lex, int entry_nr);

#endif /* IncEbaseLexicon */
