/*
   File: ebase_hash.h
   Simple collection of hash functions

   Copyright (C) 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: ebase_hash.h,v 1.1 2012/04/21 16:22:44 marcs Exp $"
*/
#ifndef IncEbaseHash
#define IncEbaseHash

/* Libdcg(2) includes */
#include <dcg.h>
#include <dcg_plist.h>

int ebs_hash_int (int nr, int hsize);
int ebs_hash_real (double nr, int hsize);
unsigned int ebs_hash_continued_text (char *s, unsigned int value);
unsigned int ebs_hash_continued_int (int k, unsigned int value);
int ebs_hash_text (char *s, int hsize);
int ebs_hash_search_key (int_list key, int hsize);

#endif /* IncEbaseHash */
