/*
   File: ebase_fact_table.c
   Stores a fact table (by which we mean the datastructure through which
   facts can be entered with their appropriate information) for later
   retrieval. Since the number of individual facts in a fact table may
   easily be of the order of one million, the fact table is stored as
   a hash table. The triple database is stored is an implicit extra fact
   table whose resultant lookup directly results in a frequency instead
   of an entry list index.

   Copyright 2012 Marc Seutter
 
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: ebase_fact_table.c,v 1.2 2012/07/27 09:30:22 marcs Exp $"
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

/* System includes */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* libdcg includes */
#include <dcg_error.h>
#include <dcg_alloc.h>

/* local includes */
#include "ebase_input.h"
#include "ebase_vocabulary.h"
#include "ebase_lexicon.h"
#include "ebase_lexicon_impl.h"
#include "ebase_fact_table.h"

int ebs_lookup_critical_text (Lexicon lexicon, char *text)
{ Vocabulary rt_criticals = lexicon -> rt_criticals;
  int *entry = ebs_lookup_in_vocabulary (rt_criticals, text);
  if (entry == NULL) return (0);
  return (*entry);
}
