/*
   File: options.h
   Defines flags and parameters of the eag3 lexicon generator

   Copyright (C) 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: options.h,v 1.4 2012/03/21 15:23:30 marcs Exp $"
*/
#ifndef IncOptions
#define IncOptions

/* libdcg and local includes */
#include <dcg.h>
#include <dcg_string.h>

/* exported flags */
extern int lexgen_forced;
extern int generate_info;

/* Source file names */
extern string lexicon_fname;
extern string source_name;
extern string info_fname;
extern string base_gname;
extern string dir_name;

/* Hash sizes */
extern int affix_hash_size;
extern int call_hash_size;
extern int fact_hash_size;

/* exported routines */
void init_options ();
void parse_command_line (int argc, char **argv);

#endif /* IncOptions */
