/*
   File: lexer.h
   Lexical analyzer for Lexicon, Fact and Triple files

   Copyright 2012 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: lexer.h,v 1.4 2012/06/08 13:49:28 marcs Exp $"
*/
#ifndef IncLexer
#define IncLexer

/* Define the kind of files we can lex */
typedef enum file_kind_tag { lexicon, fact, triple, translations } file_kind;
char *suffix_from_file_kind (file_kind kind);

/* Exported actions */
void parse_error (char *format, ...);
void parse_warning (char *format,...);
int try_open_lexer_file (char *base_name, file_kind kind);
void close_lexer_file ();

/* Lexing actions */
void lexer_read_line ();
void may_skip_white_space ();
int is_eof ();
int is_end ();
void should_be_eof ();
int is_eoln ();
void should_be_eoln ();
void skip_eoln ();
int is_char (char ch);
void should_be_char (char ch);

int is_comment ();
int is_unsigned_number (int *ret_nr);
void should_be_unsigned_number (int *ret_nr);
int is_signed_number (int *ret_nr);
void may_be_signed_number (int *ret_nr);
int is_real_number (real *ret_nr);
int is_affix_terminal (char **rname);
int is_affix_nonterminal (char **rname);
int is_name_part (char **rname);
void should_be_name_part (char **rname);
int is_relation (char **rname);
void should_be_relation (char **rname);
int is_quoted_character (int *ret_nr);
int is_string (char **str);
void should_be_string (char **str);
int is_string_with_expansion (char **str);
void should_be_string_with_expansion (char **str);
int is_word_form (char **wform, int *ret_marker, int empty_ok);

#endif /* IncLexer */
