/*
   File: calls.h
   Identifies nonterminals and collects all calls

   Copyright (C) 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: calls.h,v 1.2 2012/04/06 08:42:39 marcs Exp $"
*/
#ifndef IncCalls
#define IncCalls

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>

/* Encoding of formals */
#define ERROR_FORMAL -1
#define ENCODE_DOMAIN_FORMAL(x) (-2-(x))

/* Nonterminal identification */
void prepare_nonterminals ();
int try_identify_nonterminal (string_list name_parts, int_list formals);
int enter_call (int nont_id, int_list actuals);

#endif /* IncCalls */
