/*
   File: affix_values.h
   Collects all used actual affix values

   Copyright (C) 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: affix_values.h,v 1.4 2012/03/21 15:23:30 marcs Exp $"
*/
#ifndef IncAffixValues
#define IncAffixValues

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>

/* The three elements that can occur in an actual parameter */
#define TYPE_UNKNOWN 0
#define TYPE_ELEMENT 1
#define TYPE_AFFIX_NONTERMINAL 2
#define TYPE_MARKER 3

/*
   During preparation, all lattice affix terminals, nonterminals
   and type markers are entered (as well as some typing administration
*/
void prepare_affix_values ();
int int_formal ();
int real_formal ();
int text_formal ();

/*
   Following preparation, actual affix values may be recognized
   by the following two routines, returning
   kind:    element	| affix nonterminal | marker
   type_nr: domain      | type nr	    | type nr
   elt_nr:  element nr  | -1		    | alt nr
*/
int lookup_value_string (char *str, int *kind, int *type_nr, int *elt_nr);
int lookup_value_string_list (string_list list, int *kind, int *type_nr, int *elt_nr);

/* Collection of unique affix values */
int collect_actual_parameter (affix_value value);
int collect_critical_parameter (char *crit);

/* Statistics */
void report_affix_values ();

#endif /* IncAffixValues */
