/*
   File: rule_tree.h
   Defines a symbol table for rule rules implemented as a binary tree.

   Copyright (C) 2008 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: rule_tree.h,v 1.5 2011/09/07 10:09:44 marcs Exp $"
*/
#ifndef IncRuleTree
#define IncRuleTree

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>
#include <dcg_alloc.h>
#include <dcg_string.h>
#include <dcg_dump.h>

/* local includes */
#include "eag_ds.h"

/* introduce type and nil definitions */
typedef struct rule_tree_rec *rule_tree;
struct rule_tree_rec
	{ string_list tag;
	  int arity;
	  rdecl_list rdefs;
	  rule_tree left;
	  rule_tree right;
	};
#define rule_tree_nil ((rule_tree) NULL)

/* introduce necessary routines and shorthands */
#define new_rule_tree() rule_tree_nil
#define attach_rule_tree(orig) (rule_tree) dcg_attach ((char *) orig)
#define att_rule_tree(orig) (void) dcg_attach ((char *) orig)
void detach_rule_tree (rule_tree *optr);
#define det_rule_tree(optr) detach_rule_tree(optr)
#define equal_rule_tree(a,b) ((a) == (b))

/* supplementary routines and shorthands */
#define est_rule_tree(x) MAXWIDTH
void ppp_rule_tree (FILE *f, int horiz, int ind, rule_tree old);
#define pp_rule_tree(f,x) ppp_rule_tree (f,0,0,x)
void save_rule_tree (FILE *f, rule_tree old);
int load_rule_tree (FILE *f, rule_tree *x);

/* specific routines and shorthands */
rdecl_list enter_rule_tree (rule_tree *root, string_list tag, int arity);
rdecl_list lookup_rule_tree (rule_tree root, string_list tag, int arity);

#endif /* IncRuleTree */
