/*
   File: rti_writer.c
   Writes the runtime information file needed to run the grammar

   Copyright (C) 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: rti_writer.c,v 1.6 2012/12/26 15:43:07 marcs Exp $"
*/

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>
#include <dcg_error.h>

/* libeagbase includes */
#include <ebase_version.h>

/* Local includes */
#include "eag_ds.h"
#include "options.h"
#include "globals.h"
#include "rti_writer.h"

/*
   The runtime information file is a binary encoded file containing 
   all necessary information that must be passed from the compiler
   to the runtime system with the exception of the information that
   is passed through lexicon generator (among which is the runtime
   type system). The runtime information file encompasses:

   1) Pragmats for the runtime system
   2) List of all runtime nonterminals
   3) List of all runtime affix constants used in the code
   4) Director sets 

*/
static BinFile open_runtime_information_file ()
{ char *fname = dcg_new_fmtd_string ("%s.%s", base_gname, RTI_SUFFIX);
  BinFile bf = dcg_bin_fopen_path (dir_name, fname, "w", 1);
  dcg_detach ((void **) &fname);
  return (bf);
}

static void save_pragmats (BinFile bf)
{ save_int (bf, input_mode_option);
  save_int (bf, partial_parse_option);
  save_int (bf, hybrid_parsing_option);
  save_int (bf, code_tracing);
  save_int (bf, code_negative_memoization);
  save_int (bf, nr_neg_memos);
  save_int (bf, code_positive_memoization);
}

#define RTI_KIND "Runtime Information"
void write_runtime_information_file ()
{ BinFile bf = open_runtime_information_file ();
  dcg_bin_save_header (bf, "EAG3", RTI_KIND, EAG3_VERSION);
  save_pragmats (bf);
  save_rt_nont_list (bf, all_rt_nonts);
  save_ext_nont_list (bf, all_ext_nonts);
  save_affix_value_list (bf, all_affix_constants);
  dcg_bin_save_eof (bf);
  dcg_bin_fclose (&bf);
}
