/*
   File: options.h
   Defines flags and parameters of the eag3 compiler
   It also specifies some compiler defaults

   Copyright (C) 2008-2013 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: options.h,v 1.18 2013/03/13 10:08:24 marcs Exp $"
*/
#ifndef IncOptions
#define IncOptions

/* libdcg and local includes */
#include <dcg.h>
#include <dcg_string.h>
#include <dcg_plist.h>

/* exported flags and pragmats */
extern int agfl_compatible;
extern int generate_c_only;
extern int code_negative_memoization;
extern int code_positive_memoization;
extern int code_stack_checks;
extern int code_for_debug;
extern int code_tracing;
extern int parse_only;
extern int no_code;
extern int strict;

/* exported codegen flags */
extern int td_parser;
extern int lc_parser;
extern int lr_parser;

/* exported debug flags */
extern int dump_parser;
extern int dump_checker;
extern int dump_intermed;
extern int dump_flow;
extern int dump_affix_rules;
extern int dump_rules;
extern int dump_lexemes;
extern int dump_lattices;
extern int dump_properties;
extern int dump_properties_tree;

/* exported search path */
extern string_list grammar_search_path;

/* Source file names */
extern string dir_name;
extern string base_gname;
extern string source_name;

/* exported names */
extern string output_fname;

/* other exported strings */
extern string variants_option;

/* exported routines */
void init_options ();
void parse_command_line (int argc, char **argv);

#endif /* IncOptions */
