/*
   File: lexer.h
   Defines the lexical analyzer for EAG3

   Copyright (C) 2008 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: lexer.h,v 1.6 2011/11/30 14:11:23 marcs Exp $"
*/
#ifndef IncLexer
#define IncLexer

/* libdcg includes */
#include <dcg.h>
#include <dcg_plist.h>

/* exported actions */
void should_be_keyword (string sy);
void should_be_symbol (string sy);
void should_be_module_name (string *mname);
void should_be_affix_name (string *aname);
void should_be_bold_name (string *bname);
void should_be_relation_name (string *rname);
void should_be_affix_variable_name (string *aname);
void should_be_text_constant (string *text);
void should_be_integer_number (int *inum);
int ahead_special_affix_terminal ();
int ahead_symbol (string sy);
int ahead_dot_number ();
int is_predefs_spec ();
int is_keyword (string key);
int is_symbol (string sy);
int is_pragmat ();
int is_module_name (string *mname);
int is_name_part (string *part);
int is_bold_name (string *bname);
int is_relation_name (string *rname);
int is_affix_name (string *aname);
int is_affix_terminal (string *aname);
int is_affix_variable_name (string *aname);
int is_number (int *kind, int *inum, real *rnum);
int is_text_constant (string *text);

/* Special check in parser */
int valid_affix_nonterminal_name (string_list ids);
int valid_affix_nonterminal_part (string is);

/*
  Lexer position interface
*/ 
void dump_lexical_buffer ();
void get_erroneous_name (string *rname);
void get_current_filename (string *rfname);
void get_current_position (int *rline, int *rcol);
int end_of_file ();
void init_lexer (FILE *fd, char *fname, int predef_flag);
void finish_lexer ();

#endif /* IncLexer */
