/*
   File: globals.h
   Defines and holds the global datastructures and variables of the EAG3 compiler

   Copyright (C) 2010 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: globals.h,v 1.26 2012/12/26 15:43:07 marcs Exp $
*/
#ifndef IncGlobals
#define IncGlobals

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>
#include <dcg_string.h>

/* local includes */
#include "eag_ds.h"

/* Special file suffixes */
#define BLI_SUFFIX "bli"
#define RTI_SUFFIX "rti"

/* List of all grammars */
extern grammar_list all_grammars;
extern grammar root_grammar;
extern rule root_rule;

/* List of all affix rule definitions */
extern affix_rule_list all_affix_rules;

/* List of all syntax rule definitions */
extern rule_list all_syntax_rules;
extern rule_list all_quasi_rules;

/* List of all elements in the finite lattices */
extern element_list all_elements;

/* List of all lattice superdomains */
extern domain_list all_domains;

/* Construction of the runtime administration */
extern rt_domain_list all_rt_domains;
extern rt_type_list all_rt_types;

/* Lists of all lexica, fact tables and triple databases */
extern string_list all_lexica;
extern string_list all_fact_tables;
extern string_list all_triple_databases;

/* Lists of all csets, terminals and compiled regexps */
extern cset_list all_csets;
extern terminal_list all_terminals;
extern nfa_list all_regexp_nfas;

/* List of all lexicon/fact nonterminals */
extern int nr_facts;
extern lex_nont_list all_lex_nonts;

/* List of all runtime nonterminals and reverse mapping for externals */
extern rt_nont_list all_rt_nonts;
extern ext_nont_list all_ext_nonts;

/* List of all constant affix values for affix nodes */
extern affix_value_list all_affix_constants;

/* More runtime information */
extern int nr_neg_memos;

/*
   List of all pragmats/global vars
   Usual encoding for text options
	        | null    | "\0" | non empty text | usual default
   white space  | default | off  | actual value   | "\n\t\r "
   separators	| default | off  | actual value   | off
   encoding	| default |      | actual value   |
   radix        | default |      | actual value   |

   Translations use two variables for xport
*/

/* Text options */
extern string white_space_option;
extern string separators_option;
extern string encoding_option;
extern string radix_option;
extern int empty_white_space_option;

/* Integer options */
/* The following constants must move to the rts when appropriate */
extern int input_mode_option;
extern int partial_parse_option;
extern int closed_triple_db_option;
extern int long_dependency_delimiters_option;
extern int hyphen_convention_option;
extern int hybrid_parsing_option;
extern int translate_option;
extern int utf8_processing;

/* Associated values */
extern string translate_fname;
extern int_list white_spaces;
extern int_list separators;

/* List of all invisible nonterminals */
extern invisible_nonterminal_list all_invisible_nonterminals;

/* Initialisation */
void init_globals ();

#endif /* IncGlobals */
