/*
   File: globals.c
   Copyright (C) 2010-2011 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: globals.c,v 1.24 2012/12/26 15:43:06 marcs Exp $"
*/

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>
#include <dcg_string.h>

/* libebase includes */
#include <ebase_input.h>

/* local includes */
#include "eag_ds.h"
#include "globals.h"

/* List of all grammars */
grammar_list all_grammars;
grammar root_grammar;
rule root_rule;

/* List of all affix rule definitions */
affix_rule_list all_affix_rules;

/* List of all syntax rule definitions */
rule_list all_syntax_rules;
rule_list all_quasi_rules;

/* List of all elements in the finite lattices */
element_list all_elements;

/* List of all lattice superdomains */
domain_list all_domains;

/* Construction of the runtime types */
rt_domain_list all_rt_domains;
rt_type_list all_rt_types;

/* Lists of all lexica, fact tables and triple databases */
string_list all_lexica;
string_list all_fact_tables;
string_list all_triple_databases;

/* Lists of all csets, terminals and regexps */
cset_list all_csets;
terminal_list all_terminals;
nfa_list all_regexp_nfas;

/* List of all lexicon/fact nonterminals with their typing */
int nr_facts;
lex_nont_list all_lex_nonts;

/* List of all runtime nonterminals and reverse mapping for externals */
rt_nont_list all_rt_nonts;
ext_nont_list all_ext_nonts;

/* List of all constant affix values for affix nodes */
affix_value_list all_affix_constants;

/* More runtime information */
int nr_neg_memos;

/* List of all pragmats/global vars */
/* Text options */
string separators_option;
string white_space_option;
string encoding_option;
string radix_option;
int empty_white_space_option;

/* Boolean/Integer options */
int input_mode_option; 
int partial_parse_option;
int closed_triple_db_option;
int long_dependency_delimiters_option;
int hyphen_convention_option;
int hybrid_parsing_option;
int translate_option;
int utf8_processing;

/* Additional variables */
string translate_fname;
int_list white_spaces;
int_list separators;

/* List of all invisible nonterminals */
invisible_nonterminal_list all_invisible_nonterminals;

/* Initialisation */
#define INIT_NR_OF_AFFIX_RULES 256
#define INIT_NR_OF_ELEMENTS 64
#define INIT_NR_OF_DOMAINS 16
#define INIT_NR_OF_RULES 1024
#define INIT_NR_OF_QUASI_RULES 16
#define INIT_NR_OF_CSETS 32
#define INIT_NR_OF_TERMINALS 128
#define INIT_NR_OF_LEX_NONTS 128
#define INIT_NR_OF_REGEXP_NFAS 128
#define INIT_NR_OF_CONSTANTS 128
void init_globals ()
{ /* Initialize data structures */
  all_invisible_nonterminals = new_invisible_nonterminal_list ();
  all_affix_rules = init_affix_rule_list (INIT_NR_OF_AFFIX_RULES);
  all_syntax_rules = init_rule_list (INIT_NR_OF_RULES);
  all_quasi_rules = init_rule_list (INIT_NR_OF_QUASI_RULES);
  all_elements = init_element_list (INIT_NR_OF_ELEMENTS);
  all_domains = init_domain_list (INIT_NR_OF_DOMAINS);
  all_rt_domains = init_rt_domain_list (INIT_NR_OF_DOMAINS);
  all_rt_types = init_rt_type_list (INIT_NR_OF_AFFIX_RULES);
  all_csets = init_cset_list (INIT_NR_OF_CSETS);
  all_terminals = init_terminal_list (INIT_NR_OF_TERMINALS);
  all_regexp_nfas = init_nfa_list (INIT_NR_OF_REGEXP_NFAS);
  all_lex_nonts = init_lex_nont_list (INIT_NR_OF_LEX_NONTS);
  all_rt_nonts = init_rt_nont_list (INIT_NR_OF_RULES);
  all_ext_nonts = init_ext_nont_list (INIT_NR_OF_RULES);
  all_affix_constants = init_affix_value_list (INIT_NR_OF_CONSTANTS);
  nr_facts = 0;
  all_grammars = new_grammar_list ();
  root_grammar = grammar_nil;
  root_rule = rule_nil;

  /* Initialize lexicon input lists */
  all_lexica = new_string_list ();
  all_fact_tables = new_string_list ();
  all_triple_databases = new_string_list ();

  /* Runtime information */
  nr_neg_memos = 0;

  /* Initialize options to default values */
  translate_option = TranslationsDefault;
  translate_fname = new_string ("");
  separators_option = string_nil;
  white_space_option = string_nil;
  encoding_option = string_nil;
  radix_option = string_nil;
  empty_white_space_option = 0;

  input_mode_option = LineInputMode;
  partial_parse_option = 0;
  closed_triple_db_option = 0;
  long_dependency_delimiters_option = 0;
  hyphen_convention_option = 0;
  hybrid_parsing_option = 0;
  utf8_processing = 0;
}
