/*
   File: flow.c
   Determines the internal and globel affix flow within rules to determine
   which rules can be cached for the purpose of best first parsing. As a
   side effect it will mark those rules that always produce empty, but
   which are not dependent upon input affixes (i.e. semi predicates).

   Copyright (C) 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: flow.c,v 1.4 2012/12/05 14:11:49 marcs Exp $"
*/

/* standard includes */
#include <stdio.h>
#include <string.h>

/* libdcg includes */
#include <dcg.h>
#include <dcg_alloc.h>
#include <dcg_error.h>
#include <dcg_string.h>

/* libeagbase includes */
#include <ebase_ds.h>

/* local includes */
#include "eag_ds.h"
#include "options.h"
#include "globals.h"
#include "flow.h"

/*
   For the moment flow analysis only decides the difference
   between semipredicates and predicates
*/
static void check_if_rule_is_semipredicate (rule srule)
{ dir_list dirs = srule -> rspec -> dirs;
  int ix;
  if (srule -> rspec -> rtype != r_predicate)
    dcg_internal_error ("check_if_rule_is_semipredicate");

  /* If one of the positions is an inherited one, rule is a predicate */
  for (ix = 0; ix < dirs -> size; ix++)
    if (dirs -> array[ix] == d_inherited)
      return;

  /* No inherited affixes: become a semipredicate */
  srule -> rspec -> rtype = r_semipredicate;
}

static void determine_semipredicates ()
{ int ix;
  for (ix = 0; ix < all_syntax_rules -> size; ix++)
    { rule srule = all_syntax_rules -> array[ix];
      if (srule -> empty == e_always_produces_empty)
	check_if_rule_is_semipredicate (srule);
    };
}

void do_flow_analysis ()
{ dcg_warning (0, "   determining affix flow...");
  determine_semipredicates ();
}
