/*
   File: element_tree.h
   Defines a symbol table for lattice elements implemented as a binary tree.

   Copyright (C) 2011 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: element_tree.h,v 1.2 2011/09/07 10:09:44 marcs Exp $"
*/
#ifndef IncElementTree
#define IncElementTree

/* standard includes */
#include <stdio.h>

/* libdcg includes */
#include <dcg.h>
#include <dcg_alloc.h>
#include <dcg_string.h>
#include <dcg_dump.h>

/* local includes */
#include "eag_ds.h"

/* introduce type and nil definitions */
typedef struct element_tree_rec *element_tree;
struct element_tree_rec
	{ string tag;
	  element def;
	  element_tree left;
	  element_tree right;
	};
#define element_tree_nil ((element_tree) NULL)

/* introduce necessary routines and shorthands */
#define new_element_tree() element_tree_nil
#define attach_element_tree(orig) (element_tree) dcg_attach ((char *) orig)
#define att_element_tree(orig) (void) dcg_attach ((char *) orig)
void detach_element_tree (element_tree *optr);
#define det_element_tree(optr) detach_element_tree(optr)
#define equal_element_tree(a,b) ((a) == (b))

/* supplementary routines and shorthands */
#define est_element_tree(x) MAXWIDTH
void ppp_element_tree (FILE *f, int horiz, int ind, element_tree old);
#define pp_element_tree(f,x) ppp_element_tree (f,0,0,x)
void save_element_tree (FILE *f, element_tree old);
int load_element_tree (FILE *f, element_tree *x);

/* specific routines and shorthands */
element_tree enter_element_tree (element_tree *root, string ename);
element lookup_element_tree (element_tree root, string ename);

#endif /* IncElementTree */
