/*
   File: element_tree.c
   Defines a symbol table for lattice elements implemented as a binary tree.

   Copyright (C) 2011 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: element_tree.c,v 1.3 2011/09/21 09:39:20 marcs Exp $"
*/

/* standard includes */
#include <stdio.h>
#include <string.h>

/* support lib includes */
#include <dcg.h>
#include <dcg_alloc.h>
#include <dcg_string.h>
#include <dcg_dump.h>

/* local includes */
#include "eag_ds.h"
#include "element_tree.h"

/* introduce necessary routines and shorthands */
void detach_element_tree (element_tree *optr)
{ element_tree old = (element_tree) dcg_predetach ((void **) optr);
  if (old == element_tree_nil) return;
  detach_string (&old -> tag);
  detach_element_tree (&old -> left);
  detach_element_tree (&old -> right);
  dcg_detach ((void **) &old);
};

/* supplementary routines and shorthands */
static void my_ppp_element_tree (FILE *f, int ind, element_tree old)
{ if (old == element_tree_nil) return;
  my_ppp_element_tree (f, ind + 2, old -> left);
  pppdelim (f, 0, ind, '<');
  ppp_string (f, 1, ind + 2, old -> tag);
  pppdelim (f, 0, ind, ',');
  ppp_element (f, 0, ind + 2, old -> def);
  pppdelim (f, 0, ind, '>');
  my_ppp_element_tree (f, ind + 2, old -> right);
};

void ppp_element_tree (FILE *f, int horiz, int ind, element_tree old)
{ pppdelim (f, 0, ind, '{');
  my_ppp_element_tree (f, ind + 2, old);
  pppdelim (f, 0, ind, '}');
};

void save_element_tree (FILE *f, element_tree old)
{
};

int load_element_tree (FILE *f, element_tree *x)
{ return (0);
};

/* specific routines and shorthands */
element_tree enter_element_tree (element_tree *root, string ename)
{ element_tree *ptr = root;
  element_tree new;
  while (*ptr != element_tree_nil)
    { element_tree current = *ptr;
      int cond = strcmp (ename, current -> tag);
      if (cond < 0) ptr = &current -> left;
      else if (cond > 0) ptr = &current -> right;
      else /* Found element, return the old definition */
	return (current);
    };

  new = (element_tree) dcg_malloc (sizeof (struct element_tree_rec));
  new -> tag = attach_string (ename);
  new -> def = element_nil;
  new -> left = element_tree_nil;
  new -> right = element_tree_nil;
  *ptr = new;
  return (new);
};

element lookup_element_tree (element_tree root, string ename)
{ element_tree ptr = root;
  while (ptr != element_tree_nil)
    { int cond = strcmp (ename, ptr -> tag);
      if (cond < 0) ptr = ptr -> left;
      else if (cond > 0) ptr = ptr -> right;
      else /* Found right element */ 
	return (ptr -> def);
    };
  return (element_nil);
};
