/*
   File: eag_ds.h
   Generated on Sat Apr 13 13:25:13 2013
*/
#ifndef IncEag_ds
#define IncEag_ds

/* standard includes */
#include <stdio.h>

/* support lib includes */
#include <dcg.h>
#include <dcg_alloc.h>
#include <dcg_string.h>
#include <dcg_binfile.h>

/* Introduce record type definitions */
typedef struct str_grammar *grammar;
typedef struct str_prule *prule;
typedef struct str_plhs *plhs;
typedef struct str_rule *rule;
typedef struct str_spec *spec;
typedef struct str_rdecl *rdecl;
typedef struct str_variable *variable;
typedef struct str_definition *definition;
typedef struct str_fpar *fpar;
typedef struct str_group *group;
typedef struct str_alternative *alternative;
typedef struct str_fwo_group *fwo_group;
typedef struct str_member *member;
typedef struct str_apar *apar;
typedef struct str_confrontation *confrontation;
typedef struct str_res_conf *res_conf;
typedef struct str_affix_term *affix_term;
typedef struct str_trans_member *trans_member;
typedef struct str_hyb_op *hyb_op;
typedef struct str_affix_rule *affix_rule;
typedef struct str_affix_alternative *affix_alternative;
typedef struct str_affix_element *affix_element;
typedef struct str_invisible_nonterminal *invisible_nonterminal;
typedef struct str_element *element;
typedef struct str_domain *domain;
typedef struct str_regexp *regexp;
typedef struct str_name *name;
typedef struct str_call_solution *call_solution;
typedef struct str_madm *madm;

/* Introduce type_list definitions */
typedef struct str_grammar_list *grammar_list;
typedef struct str_prule_list *prule_list;
typedef struct str_plhs_list *plhs_list;
typedef struct str_rule_list *rule_list;
typedef struct str_rdecl_list *rdecl_list;
typedef struct str_variable_list *variable_list;
typedef struct str_definition_list *definition_list;
typedef struct str_fpar_list *fpar_list;
typedef struct str_dir_list *dir_list;
typedef struct str_alternative_list *alternative_list;
typedef struct str_fwo_group_list *fwo_group_list;
typedef struct str_member_list *member_list;
typedef struct str_apar_list *apar_list;
typedef struct str_confrontation_list *confrontation_list;
typedef struct str_res_conf_list *res_conf_list;
typedef struct str_affix_term_list *affix_term_list;
typedef struct str_trans_member_list *trans_member_list;
typedef struct str_affix_rule_list *affix_rule_list;
typedef struct str_affix_alternative_list *affix_alternative_list;
typedef struct str_affix_element_list *affix_element_list;
typedef struct str_invisible_nonterminal_list *invisible_nonterminal_list;
typedef struct str_element_list *element_list;
typedef struct str_domain_list *domain_list;
typedef struct str_regexp_list *regexp_list;
typedef struct str_name_list *name_list;
typedef struct str_call_solution_list *call_solution_list;
typedef struct str_madm_list *madm_list;

/* Introduce enumeration types */
typedef enum
{ r_syntax, r_terminal, r_lex
} rule_layer;

typedef enum
{ r_unknown, r_rule, r_option,
  r_predicate, r_semipredicate
} rule_type;

typedef enum
{ r_normal, r_lexicon, r_fact,
  r_external
} rule_kind;

typedef enum
{ d_unknown, d_inherited, d_derived,
  d_transient, d_static, d_regexp
} dir;

typedef enum
{ g_none, g_comma, g_plus
} glue;

typedef enum
{ undetermined, equal, unequal,
  restrict, assign, bidir_assign,
  arith_equal
} guard_type;

typedef enum
{ c_success, c_failure, c_abort,
  c_exit
} control_op;

typedef enum
{ e_unknown, e_may_produce_empty, e_always_produces_empty,
  e_never_produces_empty
} nullability;

typedef enum
{ arule_unknown, arule_error, arule_int,
  arule_real, arule_text, arule_lattice,
  arule_tree, arule_any
} arule_kind;

/* Include imported defs */
#include <dcg_plist.h>
#include <ebase_ds.h>

/* Introduce record nils */
#define grammar_nil ((grammar) NULL)
#define prule_nil ((prule) NULL)
#define plhs_nil ((plhs) NULL)
#define rule_nil ((rule) NULL)
#define spec_nil ((spec) NULL)
#define rdecl_nil ((rdecl) NULL)
#define variable_nil ((variable) NULL)
#define definition_nil ((definition) NULL)
#define fpar_nil ((fpar) NULL)
#define group_nil ((group) NULL)
#define alternative_nil ((alternative) NULL)
#define fwo_group_nil ((fwo_group) NULL)
#define member_nil ((member) NULL)
#define apar_nil ((apar) NULL)
#define confrontation_nil ((confrontation) NULL)
#define res_conf_nil ((res_conf) NULL)
#define affix_term_nil ((affix_term) NULL)
#define trans_member_nil ((trans_member) NULL)
#define hyb_op_nil ((hyb_op) NULL)
#define affix_rule_nil ((affix_rule) NULL)
#define affix_alternative_nil ((affix_alternative) NULL)
#define affix_element_nil ((affix_element) NULL)
#define invisible_nonterminal_nil ((invisible_nonterminal) NULL)
#define element_nil ((element) NULL)
#define domain_nil ((domain) NULL)
#define regexp_nil ((regexp) NULL)
#define name_nil ((name) NULL)
#define call_solution_nil ((call_solution) NULL)
#define madm_nil ((madm) NULL)

/* Introduce type_list nils */
#define grammar_list_nil ((grammar_list) NULL)
#define prule_list_nil ((prule_list) NULL)
#define plhs_list_nil ((plhs_list) NULL)
#define rule_list_nil ((rule_list) NULL)
#define rdecl_list_nil ((rdecl_list) NULL)
#define variable_list_nil ((variable_list) NULL)
#define definition_list_nil ((definition_list) NULL)
#define fpar_list_nil ((fpar_list) NULL)
#define dir_list_nil ((dir_list) NULL)
#define alternative_list_nil ((alternative_list) NULL)
#define fwo_group_list_nil ((fwo_group_list) NULL)
#define member_list_nil ((member_list) NULL)
#define apar_list_nil ((apar_list) NULL)
#define confrontation_list_nil ((confrontation_list) NULL)
#define res_conf_list_nil ((res_conf_list) NULL)
#define affix_term_list_nil ((affix_term_list) NULL)
#define trans_member_list_nil ((trans_member_list) NULL)
#define affix_rule_list_nil ((affix_rule_list) NULL)
#define affix_alternative_list_nil ((affix_alternative_list) NULL)
#define affix_element_list_nil ((affix_element_list) NULL)
#define invisible_nonterminal_list_nil ((invisible_nonterminal_list) NULL)
#define element_list_nil ((element_list) NULL)
#define domain_list_nil ((domain_list) NULL)
#define regexp_list_nil ((regexp_list) NULL)
#define name_list_nil ((name_list) NULL)
#define call_solution_list_nil ((call_solution_list) NULL)
#define madm_list_nil ((madm_list) NULL)

/* Introduce enumeration nils */
#define rule_layer_nil ((rule_layer) 0)
#define rule_type_nil ((rule_type) 0)
#define rule_kind_nil ((rule_kind) 0)
#define dir_nil ((dir) 0)
#define glue_nil ((glue) 0)
#define guard_type_nil ((guard_type) 0)
#define control_op_nil ((control_op) 0)
#define nullability_nil ((nullability) 0)
#define arule_kind_nil ((arule_kind) 0)

/* introduce constructors */
#define Ext_prule u.ue_Ext_prule
#define Quasi_prule u.ue_Quasi_prule
#define Proto_rule u.ue_Proto_rule
#define Pspec u.ue_Pspec
#define Pstart u.ue_Pstart
#define Ext_rule u.ue_Ext_rule
#define Quasi_rule u.ue_Quasi_rule
#define Defs u.ue_Defs
#define Anonymous_option u.ue_Anonymous_option
#define Anonymous_group u.ue_Anonymous_group
#define Single u.ue_Single
#define Fwo u.ue_Fwo
#define Call u.ue_Call
#define Guard u.ue_Guard
#define Term u.ue_Term
#define Quasi u.ue_Quasi
#define Op u.ue_Op
#define Group u.ue_Group
#define Option u.ue_Option
#define Res_guard u.ue_Res_guard
#define Res_call u.ue_Res_call
#define Res_term u.ue_Res_term
#define Terminal u.ue_Terminal
#define Dyop u.ue_Dyop
#define Monop u.ue_Monop
#define Enclosed u.ue_Enclosed
#define Ast u.ue_Ast
#define Concat u.ue_Concat
#define Int u.ue_Int
#define Real u.ue_Real
#define Text u.ue_Text
#define Regexp u.ue_Regexp
#define Var u.ue_Var
#define Tcall u.ue_Tcall
#define Tquasi u.ue_Tquasi
#define Tgroup u.ue_Tgroup
#define Toption u.ue_Toption
#define Ttext u.ue_Ttext
#define Tvar u.ue_Tvar
#define Thybrid u.ue_Thybrid
#define Hyb_sqr_open u.ue_Hyb_sqr_open
#define Hyb_sqr_close u.ue_Hyb_sqr_close
#define Hyb_curl_open u.ue_Hyb_curl_open
#define Hyb_curl_close u.ue_Hyb_curl_close
#define Hyb_bar u.ue_Hyb_bar
#define Hyb_rel_left u.ue_Hyb_rel_left
#define Hyb_rel_right u.ue_Hyb_rel_right
#define Affix_synonym u.ue_Affix_synonym
#define Affix_alts u.ue_Affix_alts
#define Affix_prim u.ue_Affix_prim
#define Affix_sequence u.ue_Affix_sequence
#define Affix_concat u.ue_Affix_concat
#define Affix_union u.ue_Affix_union
#define Affix_partition u.ue_Affix_partition
#define Affix_single u.ue_Affix_single
#define Affix_empty u.ue_Affix_empty
#define Affix_var u.ue_Affix_var
#define Affix_term u.ue_Affix_term
#define Affix_text u.ue_Affix_text
#define Affix_inum u.ue_Affix_inum
#define Affix_rnum u.ue_Affix_rnum
#define Regexp_or u.ue_Regexp_or
#define Regexp_concat u.ue_Regexp_concat
#define Regexp_star u.ue_Regexp_star
#define Regexp_plus u.ue_Regexp_plus
#define Regexp_opt u.ue_Regexp_opt
#define Regexp_cset u.ue_Regexp_cset
#define Regexp_char u.ue_Regexp_char
#define Regexp_anychar u.ue_Regexp_anychar
#define Regexp_whitespace u.ue_Regexp_whitespace
#define Regexp_nonwhitespace u.ue_Regexp_nonwhitespace
#define Regexp_empty u.ue_Regexp_empty
#define Rule_adm u.ue_Rule_adm
#define Member_adm u.ue_Member_adm

/* Introduce constructor tags */
typedef enum en_tags_prule
{ TAGExt_prule,
  TAGQuasi_prule,
  TAGProto_rule,
  TAGPspec,
  TAGPstart
} tags_prule;

typedef enum en_tags_rule
{ TAGExt_rule,
  TAGQuasi_rule,
  TAGDefs,
  TAGAnonymous_option,
  TAGAnonymous_group
} tags_rule;

typedef enum en_tags_fwo_group
{ TAGSingle,
  TAGFwo
} tags_fwo_group;

typedef enum en_tags_member
{ TAGCall,
  TAGGuard,
  TAGTerm,
  TAGQuasi,
  TAGOp,
  TAGGroup,
  TAGOption,
  TAGRes_guard,
  TAGRes_call,
  TAGRes_term
} tags_member;

typedef enum en_tags_affix_term
{ TAGTerminal,
  TAGDyop,
  TAGMonop,
  TAGEnclosed,
  TAGAst,
  TAGConcat,
  TAGInt,
  TAGReal,
  TAGText,
  TAGRegexp,
  TAGVar
} tags_affix_term;

typedef enum en_tags_trans_member
{ TAGTcall,
  TAGTquasi,
  TAGTgroup,
  TAGToption,
  TAGTtext,
  TAGTvar,
  TAGThybrid
} tags_trans_member;

typedef enum en_tags_hyb_op
{ TAGHyb_sqr_open,
  TAGHyb_sqr_close,
  TAGHyb_curl_open,
  TAGHyb_curl_close,
  TAGHyb_bar,
  TAGHyb_rel_left,
  TAGHyb_rel_right
} tags_hyb_op;

typedef enum en_tags_affix_rule
{ TAGAffix_synonym,
  TAGAffix_alts,
  TAGAffix_prim
} tags_affix_rule;

typedef enum en_tags_affix_alternative
{ TAGAffix_sequence,
  TAGAffix_concat,
  TAGAffix_union,
  TAGAffix_partition,
  TAGAffix_single,
  TAGAffix_empty
} tags_affix_alternative;

typedef enum en_tags_affix_element
{ TAGAffix_var,
  TAGAffix_term,
  TAGAffix_text,
  TAGAffix_inum,
  TAGAffix_rnum
} tags_affix_element;

typedef enum en_tags_regexp
{ TAGRegexp_or,
  TAGRegexp_concat,
  TAGRegexp_star,
  TAGRegexp_plus,
  TAGRegexp_opt,
  TAGRegexp_cset,
  TAGRegexp_char,
  TAGRegexp_anychar,
  TAGRegexp_whitespace,
  TAGRegexp_nonwhitespace,
  TAGRegexp_empty
} tags_regexp;

typedef enum en_tags_madm
{ TAGRule_adm,
  TAGMember_adm
} tags_madm;

/* Introduce structure for constructor Ext_prule */
typedef struct str_Ext_prule
{ string ename;
} C_Ext_prule;

/* Introduce structure for constructor Quasi_prule */
typedef struct str_Quasi_prule
{ string rname;
} C_Quasi_prule;

/* Introduce structure for constructor Proto_rule */
typedef struct str_Proto_rule
{ group grp;
} C_Proto_rule;

/* Introduce structure for constructor Ext_rule */
typedef struct str_Ext_rule
{ string ename;
} C_Ext_rule;

/* Introduce structure for constructor Quasi_rule */
typedef struct str_Quasi_rule
{ string rname;
} C_Quasi_rule;

/* Introduce structure for constructor Defs */
typedef struct str_Defs
{ definition_list defs;
} C_Defs;

/* Introduce structure for constructor Anonymous_option */
typedef struct str_Anonymous_option
{ group grp;
  spec anc_spec;
  definition def;
  member call;
} C_Anonymous_option;

/* Introduce structure for constructor Anonymous_group */
typedef struct str_Anonymous_group
{ group grp;
  spec anc_spec;
  definition def;
  member call;
} C_Anonymous_group;

/* Introduce structure for constructor Single */
typedef struct str_Single
{ member mem;
} C_Single;

/* Introduce structure for constructor Fwo */
typedef struct str_Fwo
{ member_list mems;
} C_Fwo;

/* Introduce structure for constructor Call */
typedef struct str_Call
{ string_list rname_parts;
  int_list rname_chars;
  apar_list apars;
} C_Call;

/* Introduce structure for constructor Guard */
typedef struct str_Guard
{ confrontation_list confs;
} C_Guard;

/* Introduce structure for constructor Term */
typedef struct str_Term
{ string text;
  apar par;
} C_Term;

/* Introduce structure for constructor Quasi */
typedef struct str_Quasi
{ string_list qname_parts;
  int_list qname_chars;
  apar_list args;
} C_Quasi;

/* Introduce structure for constructor Op */
typedef struct str_Op
{ control_op op;
  int gnr;
} C_Op;

/* Introduce structure for constructor Group */
typedef struct str_Group
{ group grp;
} C_Group;

/* Introduce structure for constructor Option */
typedef struct str_Option
{ group grp;
} C_Option;

/* Introduce structure for constructor Res_guard */
typedef struct str_Res_guard
{ res_conf_list rconfs;
} C_Res_guard;

/* Introduce structure for constructor Res_call */
typedef struct str_Res_call
{ rule rdef;
  affix_term_list args;
  dir_list adirs;
} C_Res_call;

/* Introduce structure for constructor Res_term */
typedef struct str_Res_term
{ string text;
  int termnr;
  int is_regexp;
  dir adir;
  affix_term arg;
} C_Res_term;

/* Introduce structure for constructor Terminal */
typedef struct str_Terminal
{ string marker;
  element edef;
} C_Terminal;

/* Introduce structure for constructor Dyop */
typedef struct str_Dyop
{ operator dop;
  affix_term arg1;
  affix_term arg2;
} C_Dyop;

/* Introduce structure for constructor Monop */
typedef struct str_Monop
{ operator mop;
  affix_term arg;
} C_Monop;

/* Introduce structure for constructor Enclosed */
typedef struct str_Enclosed
{ affix_term_list terms;
} C_Enclosed;

/* Introduce structure for constructor Ast */
typedef struct str_Ast
{ affix_term_list terms;
  int altnr;
} C_Ast;

/* Introduce structure for constructor Concat */
typedef struct str_Concat
{ affix_term_list terms;
} C_Concat;

/* Introduce structure for constructor Int */
typedef struct str_Int
{ int num;
} C_Int;

/* Introduce structure for constructor Real */
typedef struct str_Real
{ real num;
} C_Real;

/* Introduce structure for constructor Text */
typedef struct str_Text
{ string txt;
} C_Text;

/* Introduce structure for constructor Regexp */
typedef struct str_Regexp
{ string text;
  int termnr;
} C_Regexp;

/* Introduce structure for constructor Var */
typedef struct str_Var
{ string aname;
  variable vdef;
} C_Var;

/* Introduce structure for constructor Tcall */
typedef struct str_Tcall
{ string_list cname;
  int nr;
  member cdef;
} C_Tcall;

/* Introduce structure for constructor Tquasi */
typedef struct str_Tquasi
{ string qname;
  int nr;
  member qdef;
} C_Tquasi;

/* Introduce structure for constructor Tgroup */
typedef struct str_Tgroup
{ int nr;
  member gdef;
} C_Tgroup;

/* Introduce structure for constructor Toption */
typedef struct str_Toption
{ int nr;
  member odef;
} C_Toption;

/* Introduce structure for constructor Ttext */
typedef struct str_Ttext
{ string text;
} C_Ttext;

/* Introduce structure for constructor Tvar */
typedef struct str_Tvar
{ string aname;
  variable vdef;
} C_Tvar;

/* Introduce structure for constructor Thybrid */
typedef struct str_Thybrid
{ hyb_op op;
} C_Thybrid;

/* Introduce structure for constructor Hyb_rel_left */
typedef struct str_Hyb_rel_left
{ string rname;
} C_Hyb_rel_left;

/* Introduce structure for constructor Hyb_rel_right */
typedef struct str_Hyb_rel_right
{ string rname;
} C_Hyb_rel_right;

/* Introduce structure for constructor Affix_synonym */
typedef struct str_Affix_synonym
{ string syn;
  affix_rule syndef;
} C_Affix_synonym;

/* Introduce structure for constructor Affix_alts */
typedef struct str_Affix_alts
{ affix_alternative_list alts;
  int enumerable;
} C_Affix_alts;

/* Introduce structure for constructor Affix_var */
typedef struct str_Affix_var
{ string vname;
  affix_rule vdef;
} C_Affix_var;

/* Introduce structure for constructor Affix_term */
typedef struct str_Affix_term
{ string tname;
  element edef;
} C_Affix_term;

/* Introduce structure for constructor Affix_text */
typedef struct str_Affix_text
{ string text;
  int termnr;
  int is_regexp;
} C_Affix_text;

/* Introduce structure for constructor Affix_inum */
typedef struct str_Affix_inum
{ int ival;
} C_Affix_inum;

/* Introduce structure for constructor Affix_rnum */
typedef struct str_Affix_rnum
{ real rval;
} C_Affix_rnum;

/* Introduce structure for constructor Regexp_or */
typedef struct str_Regexp_or
{ regexp_list subs;
} C_Regexp_or;

/* Introduce structure for constructor Regexp_concat */
typedef struct str_Regexp_concat
{ regexp_list subs;
} C_Regexp_concat;

/* Introduce structure for constructor Regexp_star */
typedef struct str_Regexp_star
{ regexp sub;
} C_Regexp_star;

/* Introduce structure for constructor Regexp_plus */
typedef struct str_Regexp_plus
{ regexp sub;
} C_Regexp_plus;

/* Introduce structure for constructor Regexp_opt */
typedef struct str_Regexp_opt
{ regexp sub;
} C_Regexp_opt;

/* Introduce structure for constructor Regexp_cset */
typedef struct str_Regexp_cset
{ int cs;
} C_Regexp_cset;

/* Introduce structure for constructor Regexp_char */
typedef struct str_Regexp_char
{ int ch;
} C_Regexp_char;

/* Introduce structure for constructor Rule_adm */
typedef struct str_Rule_adm
{ affix_term_list terms;
  int iptr;
  affix_rule goal;
  int complete;
} C_Rule_adm;

/* Introduce structure for constructor Member_adm */
typedef struct str_Member_adm
{ affix_rule arule;
  int alt_nr;
  int mem_nr;
} C_Member_adm;

/* Introduce structure of type grammar */
struct str_grammar
{ string fname;
  string gname;
  string_list uses;
  string_list lexica;
  string_list fact_tables;
  string_list triple_databases;
  prule_list exp_prules;
  prule_list prules;
  affix_rule_list arules;
  member root_call;
  int gnr;
};

/* Introduce structure of type prule */
struct str_prule
{ int gnr;
  rule drule;
  plhs lhs;
  tags_prule tag;
  union uni_prule
    { C_Ext_prule ue_Ext_prule;
      C_Quasi_prule ue_Quasi_prule;
      C_Proto_rule ue_Proto_rule;
    } u;
};

/* Introduce structure of type plhs */
struct str_plhs
{ int line;
  int col;
  rule_layer rlayer;
  rule_kind rkind;
  rule_type rtype;
  string_list rname_parts;
  int_list rname_chars;
  fpar_list lhs_pars;
};

/* Introduce structure of type rule */
struct str_rule
{ int rnr;
  nullability empty;
  int npred;
  int reachable;
  int codable;
  trans_pair_list first;
  trans_pair_list follow;
  int goalnr;
  spec rspec;
  tags_rule tag;
  union uni_rule
    { C_Ext_rule ue_Ext_rule;
      C_Quasi_rule ue_Quasi_rule;
      C_Defs ue_Defs;
      C_Anonymous_option ue_Anonymous_option;
      C_Anonymous_group ue_Anonymous_group;
    } u;
};

/* Introduce structure of type spec */
struct str_spec
{ rule_layer rlayer;
  rule_kind rkind;
  rule_type rtype;
  string_list rname_parts;
  int_list rname_chars;
  affix_rule_list rsig;
  dir_list dirs;
  string concat_name;
  string canonic_name;
  rule drule;
  prule pr;
  int lnr;
};

/* Introduce structure of type rdecl */
struct str_rdecl
{ affix_rule_list rsig;
  rule rdef;
};

/* Introduce structure of type variable */
struct str_variable
{ string vname;
  int vnr;
  affix_rule adef;
  int cnr;
};

/* Introduce structure of type definition */
struct str_definition
{ fpar_list lhs_pars;
  variable_list locals;
  group grp;
  prule pr;
};

/* Introduce structure of type fpar */
struct str_fpar
{ int line;
  int col;
  dir fdir;
  affix_term_list fexp;
  affix_rule adef;
  int err;
};

/* Introduce structure of type group */
struct str_group
{ alternative_list alts;
};

/* Introduce structure of type alternative */
struct str_alternative
{ int line;
  int col;
  real freq;
  fwo_group_list members;
  int commited;
  trans_member_list trans;
  int empty;
  trans_pair_list first;
};

/* Introduce structure of type fwo_group */
struct str_fwo_group
{ glue gl;
  int empty;
  tags_fwo_group tag;
  union uni_fwo_group
    { C_Single ue_Single;
      C_Fwo ue_Fwo;
    } u;
};

/* Introduce structure of type member */
struct str_member
{ int line;
  int col;
  nullability empty;
  trans_pair first;
  tags_member tag;
  union uni_member
    { C_Call ue_Call;
      C_Guard ue_Guard;
      C_Term ue_Term;
      C_Quasi ue_Quasi;
      C_Op ue_Op;
      C_Group ue_Group;
      C_Option ue_Option;
      C_Res_guard ue_Res_guard;
      C_Res_call ue_Res_call;
      C_Res_term ue_Res_term;
    } u;
};

/* Introduce structure of type apar */
struct str_apar
{ dir adir;
  affix_term_list aexp;
  affix_rule adef;
};

/* Introduce structure of type confrontation */
struct str_confrontation
{ int line;
  int col;
  guard_type typ;
  affix_term_list lhs;
  affix_term_list rhs;
};

/* Introduce structure of type res_conf */
struct str_res_conf
{ guard_type typ;
  affix_term lhs;
  affix_term rhs;
};

/* Introduce structure of type affix_term */
struct str_affix_term
{ int line;
  int col;
  affix_rule adef;
  affix_value value;
  tags_affix_term tag;
  union uni_affix_term
    { C_Terminal ue_Terminal;
      C_Dyop ue_Dyop;
      C_Monop ue_Monop;
      C_Enclosed ue_Enclosed;
      C_Ast ue_Ast;
      C_Concat ue_Concat;
      C_Int ue_Int;
      C_Real ue_Real;
      C_Text ue_Text;
      C_Regexp ue_Regexp;
      C_Var ue_Var;
    } u;
};

/* Introduce structure of type trans_member */
struct str_trans_member
{ int line;
  int col;
  glue gl;
  tags_trans_member tag;
  union uni_trans_member
    { C_Tcall ue_Tcall;
      C_Tquasi ue_Tquasi;
      C_Tgroup ue_Tgroup;
      C_Toption ue_Toption;
      C_Ttext ue_Ttext;
      C_Tvar ue_Tvar;
      C_Thybrid ue_Thybrid;
    } u;
};

/* Introduce structure of type hyb_op */
struct str_hyb_op
{ tags_hyb_op tag;
  union uni_hyb_op
    { C_Hyb_rel_left ue_Hyb_rel_left;
      C_Hyb_rel_right ue_Hyb_rel_right;
    } u;
};

/* Introduce structure of type affix_rule */
struct str_affix_rule
{ int line;
  int col;
  string aname;
  int anr;
  int gnr;
  int_list lc_nrs;
  arule_kind kind;
  domain dom;
  nullability empty;
  affix_value value;
  int npred;
  int reachable;
  tags_affix_rule tag;
  union uni_affix_rule
    { C_Affix_synonym ue_Affix_synonym;
      C_Affix_alts ue_Affix_alts;
    } u;
};

/* Introduce structure of type affix_alternative */
struct str_affix_alternative
{ affix_element_list elems;
  int empty;
  tags_affix_alternative tag;
  union uni_affix_alternative
    { 
    } u;
};

/* Introduce structure of type affix_element */
struct str_affix_element
{ int line;
  int col;
  nullability empty;
  tags_affix_element tag;
  union uni_affix_element
    { C_Affix_var ue_Affix_var;
      C_Affix_term ue_Affix_term;
      C_Affix_text ue_Affix_text;
      C_Affix_inum ue_Affix_inum;
      C_Affix_rnum ue_Affix_rnum;
    } u;
};

/* Introduce structure of type invisible_nonterminal */
struct str_invisible_nonterminal
{ string fname;
  int line;
  int col;
  string_list name;
  int arity;
};

/* Introduce structure of type element */
struct str_element
{ string name;
  int enr;
  domain dom;
  int log_value;
  affix_value value;
};

/* Introduce structure of type domain */
struct str_domain
{ int_list elts;
  int dnr;
  int width;
};

/* Introduce structure of type regexp */
struct str_regexp
{ tags_regexp tag;
  union uni_regexp
    { C_Regexp_or ue_Regexp_or;
      C_Regexp_concat ue_Regexp_concat;
      C_Regexp_star ue_Regexp_star;
      C_Regexp_plus ue_Regexp_plus;
      C_Regexp_opt ue_Regexp_opt;
      C_Regexp_cset ue_Regexp_cset;
      C_Regexp_char ue_Regexp_char;
    } u;
};

/* Introduce structure of type name */
struct str_name
{ int line;
  int col;
  string_list id;
};

/* Introduce structure of type call_solution */
struct str_call_solution
{ rule rdef;
  affix_term_list apars;
  int nr_matches;
};

/* Introduce structure of type madm */
struct str_madm
{ tags_madm tag;
  union uni_madm
    { C_Rule_adm ue_Rule_adm;
      C_Member_adm ue_Member_adm;
    } u;
};

/* Introduce structure of type grammar_list */
struct str_grammar_list
{ int size;
  int room;
  grammar *array;
};

/* Introduce structure of type prule_list */
struct str_prule_list
{ int size;
  int room;
  prule *array;
};

/* Introduce structure of type plhs_list */
struct str_plhs_list
{ int size;
  int room;
  plhs *array;
};

/* Introduce structure of type rule_list */
struct str_rule_list
{ int size;
  int room;
  rule *array;
};

/* Introduce structure of type rdecl_list */
struct str_rdecl_list
{ int size;
  int room;
  rdecl *array;
};

/* Introduce structure of type variable_list */
struct str_variable_list
{ int size;
  int room;
  variable *array;
};

/* Introduce structure of type definition_list */
struct str_definition_list
{ int size;
  int room;
  definition *array;
};

/* Introduce structure of type fpar_list */
struct str_fpar_list
{ int size;
  int room;
  fpar *array;
};

/* Introduce structure of type dir_list */
struct str_dir_list
{ int size;
  int room;
  dir *array;
};

/* Introduce structure of type alternative_list */
struct str_alternative_list
{ int size;
  int room;
  alternative *array;
};

/* Introduce structure of type fwo_group_list */
struct str_fwo_group_list
{ int size;
  int room;
  fwo_group *array;
};

/* Introduce structure of type member_list */
struct str_member_list
{ int size;
  int room;
  member *array;
};

/* Introduce structure of type apar_list */
struct str_apar_list
{ int size;
  int room;
  apar *array;
};

/* Introduce structure of type confrontation_list */
struct str_confrontation_list
{ int size;
  int room;
  confrontation *array;
};

/* Introduce structure of type res_conf_list */
struct str_res_conf_list
{ int size;
  int room;
  res_conf *array;
};

/* Introduce structure of type affix_term_list */
struct str_affix_term_list
{ int size;
  int room;
  affix_term *array;
};

/* Introduce structure of type trans_member_list */
struct str_trans_member_list
{ int size;
  int room;
  trans_member *array;
};

/* Introduce structure of type affix_rule_list */
struct str_affix_rule_list
{ int size;
  int room;
  affix_rule *array;
};

/* Introduce structure of type affix_alternative_list */
struct str_affix_alternative_list
{ int size;
  int room;
  affix_alternative *array;
};

/* Introduce structure of type affix_element_list */
struct str_affix_element_list
{ int size;
  int room;
  affix_element *array;
};

/* Introduce structure of type invisible_nonterminal_list */
struct str_invisible_nonterminal_list
{ int size;
  int room;
  invisible_nonterminal *array;
};

/* Introduce structure of type element_list */
struct str_element_list
{ int size;
  int room;
  element *array;
};

/* Introduce structure of type domain_list */
struct str_domain_list
{ int size;
  int room;
  domain *array;
};

/* Introduce structure of type regexp_list */
struct str_regexp_list
{ int size;
  int room;
  regexp *array;
};

/* Introduce structure of type name_list */
struct str_name_list
{ int size;
  int room;
  name *array;
};

/* Introduce structure of type call_solution_list */
struct str_call_solution_list
{ int size;
  int room;
  call_solution *array;
};

/* Introduce structure of type madm_list */
struct str_madm_list
{ int size;
  int room;
  madm *array;
};

/* Introduce list allocation routines */
grammar_list init_grammar_list (int room);
prule_list init_prule_list (int room);
plhs_list init_plhs_list (int room);
rule_list init_rule_list (int room);
rdecl_list init_rdecl_list (int room);
variable_list init_variable_list (int room);
definition_list init_definition_list (int room);
fpar_list init_fpar_list (int room);
dir_list init_dir_list (int room);
alternative_list init_alternative_list (int room);
fwo_group_list init_fwo_group_list (int room);
member_list init_member_list (int room);
apar_list init_apar_list (int room);
confrontation_list init_confrontation_list (int room);
res_conf_list init_res_conf_list (int room);
affix_term_list init_affix_term_list (int room);
trans_member_list init_trans_member_list (int room);
affix_rule_list init_affix_rule_list (int room);
affix_alternative_list init_affix_alternative_list (int room);
affix_element_list init_affix_element_list (int room);
invisible_nonterminal_list init_invisible_nonterminal_list (int room);
element_list init_element_list (int room);
domain_list init_domain_list (int room);
regexp_list init_regexp_list (int room);
name_list init_name_list (int room);
call_solution_list init_call_solution_list (int room);
madm_list init_madm_list (int room);

/* Introduce room allocation routines */
void room_grammar_list (grammar_list l, int room);
void room_prule_list (prule_list l, int room);
void room_plhs_list (plhs_list l, int room);
void room_rule_list (rule_list l, int room);
void room_rdecl_list (rdecl_list l, int room);
void room_variable_list (variable_list l, int room);
void room_definition_list (definition_list l, int room);
void room_fpar_list (fpar_list l, int room);
void room_dir_list (dir_list l, int room);
void room_alternative_list (alternative_list l, int room);
void room_fwo_group_list (fwo_group_list l, int room);
void room_member_list (member_list l, int room);
void room_apar_list (apar_list l, int room);
void room_confrontation_list (confrontation_list l, int room);
void room_res_conf_list (res_conf_list l, int room);
void room_affix_term_list (affix_term_list l, int room);
void room_trans_member_list (trans_member_list l, int room);
void room_affix_rule_list (affix_rule_list l, int room);
void room_affix_alternative_list (affix_alternative_list l, int room);
void room_affix_element_list (affix_element_list l, int room);
void room_invisible_nonterminal_list (invisible_nonterminal_list l, int room);
void room_element_list (element_list l, int room);
void room_domain_list (domain_list l, int room);
void room_regexp_list (regexp_list l, int room);
void room_name_list (name_list l, int room);
void room_call_solution_list (call_solution_list l, int room);
void room_madm_list (madm_list l, int room);

/* Introduce list allocation shorthands */
#define new_grammar_list() init_grammar_list(2)
#define new_prule_list() init_prule_list(2)
#define new_plhs_list() init_plhs_list(2)
#define new_rule_list() init_rule_list(2)
#define new_rdecl_list() init_rdecl_list(2)
#define new_variable_list() init_variable_list(2)
#define new_definition_list() init_definition_list(2)
#define new_fpar_list() init_fpar_list(2)
#define new_dir_list() init_dir_list(2)
#define new_alternative_list() init_alternative_list(2)
#define new_fwo_group_list() init_fwo_group_list(2)
#define new_member_list() init_member_list(2)
#define new_apar_list() init_apar_list(2)
#define new_confrontation_list() init_confrontation_list(2)
#define new_res_conf_list() init_res_conf_list(2)
#define new_affix_term_list() init_affix_term_list(2)
#define new_trans_member_list() init_trans_member_list(2)
#define new_affix_rule_list() init_affix_rule_list(2)
#define new_affix_alternative_list() init_affix_alternative_list(2)
#define new_affix_element_list() init_affix_element_list(2)
#define new_invisible_nonterminal_list() init_invisible_nonterminal_list(2)
#define new_element_list() init_element_list(2)
#define new_domain_list() init_domain_list(2)
#define new_regexp_list() init_regexp_list(2)
#define new_name_list() init_name_list(2)
#define new_call_solution_list() init_call_solution_list(2)
#define new_madm_list() init_madm_list(2)

/* Introduce type allocation routines */
grammar new_grammar (string fname, string gname, string_list uses, string_list lexica, string_list fact_tables, string_list triple_databases, prule_list exp_prules, prule_list prules, affix_rule_list arules, member root_call);
prule new_Ext_prule (plhs lhs,
		string ename);
prule new_Quasi_prule (plhs lhs,
		string rname);
prule new_Proto_rule (plhs lhs,
		group grp);
prule new_Pspec (plhs lhs);
prule new_Pstart (plhs lhs);
plhs new_plhs (int line, int col, rule_layer rlayer, rule_kind rkind, rule_type rtype, string_list rname_parts, int_list rname_chars, fpar_list lhs_pars);
rule new_Ext_rule (spec rspec,
		string ename);
rule new_Quasi_rule (spec rspec,
		string rname);
rule new_Defs (spec rspec,
		definition_list defs);
rule new_Anonymous_option (spec rspec,
		group grp);
rule new_Anonymous_group (spec rspec,
		group grp);
spec new_spec (rule_layer rlayer, rule_kind rkind, rule_type rtype, string_list rname_parts, int_list rname_chars, affix_rule_list rsig, dir_list dirs);
rdecl new_rdecl ();
variable new_variable (string vname);
definition new_definition (fpar_list lhs_pars, variable_list locals, group grp);
fpar new_fpar (int line, int col, dir fdir, affix_term_list fexp);
group new_group (alternative_list alts);
alternative new_alternative (int line, int col, real freq, fwo_group_list members, int commited, trans_member_list trans);
fwo_group new_Single (glue gl,
		member mem);
fwo_group new_Fwo (glue gl,
		member_list mems);
member new_Call (int line, int col,
		string_list rname_parts, int_list rname_chars, apar_list apars);
member new_Guard (int line, int col,
		confrontation_list confs);
member new_Term (int line, int col,
		string text, apar par);
member new_Quasi (int line, int col,
		string_list qname_parts, int_list qname_chars, apar_list args);
member new_Op (int line, int col,
		control_op op);
member new_Group (int line, int col,
		group grp);
member new_Option (int line, int col,
		group grp);
member new_Res_guard (int line, int col,
		res_conf_list rconfs);
member new_Res_call (int line, int col,
		affix_term_list args, dir_list adirs);
member new_Res_term (int line, int col,
		string text, dir adir, affix_term arg);
apar new_apar (dir adir, affix_term_list aexp);
confrontation new_confrontation (int line, int col, guard_type typ, affix_term_list lhs, affix_term_list rhs);
res_conf new_res_conf (guard_type typ, affix_term lhs, affix_term rhs);
affix_term new_Terminal (int line, int col,
		string marker);
affix_term new_Dyop (int line, int col,
		operator dop, affix_term arg1, affix_term arg2);
affix_term new_Monop (int line, int col,
		operator mop, affix_term arg);
affix_term new_Enclosed (int line, int col,
		affix_term_list terms);
affix_term new_Ast (int line, int col,
		affix_term_list terms, int altnr);
affix_term new_Concat (int line, int col,
		affix_term_list terms);
affix_term new_Int (int line, int col,
		int num);
affix_term new_Real (int line, int col,
		real num);
affix_term new_Text (int line, int col,
		string txt);
affix_term new_Regexp (int line, int col,
		string text);
affix_term new_Var (int line, int col,
		string aname);
trans_member new_Tcall (int line, int col, glue gl,
		string_list cname, int nr);
trans_member new_Tquasi (int line, int col, glue gl,
		string qname, int nr);
trans_member new_Tgroup (int line, int col, glue gl,
		int nr);
trans_member new_Toption (int line, int col, glue gl,
		int nr);
trans_member new_Ttext (int line, int col, glue gl,
		string text);
trans_member new_Tvar (int line, int col, glue gl,
		string aname);
trans_member new_Thybrid (int line, int col, glue gl,
		hyb_op op);
hyb_op new_Hyb_sqr_open ();
hyb_op new_Hyb_sqr_close ();
hyb_op new_Hyb_curl_open ();
hyb_op new_Hyb_curl_close ();
hyb_op new_Hyb_bar ();
hyb_op new_Hyb_rel_left (string rname);
hyb_op new_Hyb_rel_right (string rname);
affix_rule new_Affix_synonym (int line, int col, string aname,
		string syn);
affix_rule new_Affix_alts (int line, int col, string aname,
		affix_alternative_list alts);
affix_rule new_Affix_prim (int line, int col, string aname);
affix_alternative new_Affix_sequence (affix_element_list elems);
affix_alternative new_Affix_concat (affix_element_list elems);
affix_alternative new_Affix_union (affix_element_list elems);
affix_alternative new_Affix_partition (affix_element_list elems);
affix_alternative new_Affix_single (affix_element_list elems);
affix_alternative new_Affix_empty (affix_element_list elems);
affix_element new_Affix_var (int line, int col,
		string vname);
affix_element new_Affix_term (int line, int col,
		string tname);
affix_element new_Affix_text (int line, int col,
		string text);
affix_element new_Affix_inum (int line, int col,
		int ival);
affix_element new_Affix_rnum (int line, int col,
		real rval);
invisible_nonterminal new_invisible_nonterminal (string fname, int line, int col, string_list name, int arity);
element new_element (string name);
domain new_domain (int_list elts);
regexp new_Regexp_or (regexp_list subs);
regexp new_Regexp_concat (regexp_list subs);
regexp new_Regexp_star (regexp sub);
regexp new_Regexp_plus (regexp sub);
regexp new_Regexp_opt (regexp sub);
regexp new_Regexp_cset (int cs);
regexp new_Regexp_char (int ch);
regexp new_Regexp_anychar ();
regexp new_Regexp_whitespace ();
regexp new_Regexp_nonwhitespace ();
regexp new_Regexp_empty ();
name new_name (int line, int col, string_list id);
call_solution new_call_solution (affix_term_list apars, int nr_matches);
madm new_Rule_adm ();
madm new_Member_adm (int alt_nr, int mem_nr);

/* Introduce attaching of types */
#define attach_grammar(orig)(grammar) dcg_attach ((char *) orig)
#define att_grammar(orig)(void) dcg_attach ((char *) orig)
#define attach_prule(orig)(prule) dcg_attach ((char *) orig)
#define att_prule(orig)(void) dcg_attach ((char *) orig)
#define attach_plhs(orig)(plhs) dcg_attach ((char *) orig)
#define att_plhs(orig)(void) dcg_attach ((char *) orig)
#define attach_rule(orig)(rule) dcg_attach ((char *) orig)
#define att_rule(orig)(void) dcg_attach ((char *) orig)
#define attach_spec(orig)(spec) dcg_attach ((char *) orig)
#define att_spec(orig)(void) dcg_attach ((char *) orig)
#define attach_rule_layer(orig) (orig)
#define att_rule_layer(orig)
#define attach_rule_type(orig) (orig)
#define att_rule_type(orig)
#define attach_rule_kind(orig) (orig)
#define att_rule_kind(orig)
#define attach_rdecl(orig)(rdecl) dcg_attach ((char *) orig)
#define att_rdecl(orig)(void) dcg_attach ((char *) orig)
#define attach_variable(orig)(variable) dcg_attach ((char *) orig)
#define att_variable(orig)(void) dcg_attach ((char *) orig)
#define attach_definition(orig)(definition) dcg_attach ((char *) orig)
#define att_definition(orig)(void) dcg_attach ((char *) orig)
#define attach_fpar(orig)(fpar) dcg_attach ((char *) orig)
#define att_fpar(orig)(void) dcg_attach ((char *) orig)
#define attach_dir(orig) (orig)
#define att_dir(orig)
#define attach_group(orig)(group) dcg_attach ((char *) orig)
#define att_group(orig)(void) dcg_attach ((char *) orig)
#define attach_alternative(orig)(alternative) dcg_attach ((char *) orig)
#define att_alternative(orig)(void) dcg_attach ((char *) orig)
#define attach_fwo_group(orig)(fwo_group) dcg_attach ((char *) orig)
#define att_fwo_group(orig)(void) dcg_attach ((char *) orig)
#define attach_glue(orig) (orig)
#define att_glue(orig)
#define attach_member(orig)(member) dcg_attach ((char *) orig)
#define att_member(orig)(void) dcg_attach ((char *) orig)
#define attach_apar(orig)(apar) dcg_attach ((char *) orig)
#define att_apar(orig)(void) dcg_attach ((char *) orig)
#define attach_confrontation(orig)(confrontation) dcg_attach ((char *) orig)
#define att_confrontation(orig)(void) dcg_attach ((char *) orig)
#define attach_res_conf(orig)(res_conf) dcg_attach ((char *) orig)
#define att_res_conf(orig)(void) dcg_attach ((char *) orig)
#define attach_guard_type(orig) (orig)
#define att_guard_type(orig)
#define attach_control_op(orig) (orig)
#define att_control_op(orig)
#define attach_affix_term(orig)(affix_term) dcg_attach ((char *) orig)
#define att_affix_term(orig)(void) dcg_attach ((char *) orig)
#define attach_trans_member(orig)(trans_member) dcg_attach ((char *) orig)
#define att_trans_member(orig)(void) dcg_attach ((char *) orig)
#define attach_hyb_op(orig)(hyb_op) dcg_attach ((char *) orig)
#define att_hyb_op(orig)(void) dcg_attach ((char *) orig)
#define attach_affix_rule(orig)(affix_rule) dcg_attach ((char *) orig)
#define att_affix_rule(orig)(void) dcg_attach ((char *) orig)
#define attach_affix_alternative(orig)(affix_alternative) dcg_attach ((char *) orig)
#define att_affix_alternative(orig)(void) dcg_attach ((char *) orig)
#define attach_affix_element(orig)(affix_element) dcg_attach ((char *) orig)
#define att_affix_element(orig)(void) dcg_attach ((char *) orig)
#define attach_nullability(orig) (orig)
#define att_nullability(orig)
#define attach_arule_kind(orig) (orig)
#define att_arule_kind(orig)
#define attach_invisible_nonterminal(orig)(invisible_nonterminal) dcg_attach ((char *) orig)
#define att_invisible_nonterminal(orig)(void) dcg_attach ((char *) orig)
#define attach_element(orig)(element) dcg_attach ((char *) orig)
#define att_element(orig)(void) dcg_attach ((char *) orig)
#define attach_domain(orig)(domain) dcg_attach ((char *) orig)
#define att_domain(orig)(void) dcg_attach ((char *) orig)
#define attach_regexp(orig)(regexp) dcg_attach ((char *) orig)
#define att_regexp(orig)(void) dcg_attach ((char *) orig)
#define attach_name(orig)(name) dcg_attach ((char *) orig)
#define att_name(orig)(void) dcg_attach ((char *) orig)
#define attach_call_solution(orig)(call_solution) dcg_attach ((char *) orig)
#define att_call_solution(orig)(void) dcg_attach ((char *) orig)
#define attach_madm(orig)(madm) dcg_attach ((char *) orig)
#define att_madm(orig)(void) dcg_attach ((char *) orig)

/* Introduce attaching of lists */
#define attach_grammar_list(orig) (grammar_list) dcg_attach ((char *) orig)
#define att_grammar_list(orig) (void) dcg_attach ((char *) orig)
#define attach_prule_list(orig) (prule_list) dcg_attach ((char *) orig)
#define att_prule_list(orig) (void) dcg_attach ((char *) orig)
#define attach_plhs_list(orig) (plhs_list) dcg_attach ((char *) orig)
#define att_plhs_list(orig) (void) dcg_attach ((char *) orig)
#define attach_rule_list(orig) (rule_list) dcg_attach ((char *) orig)
#define att_rule_list(orig) (void) dcg_attach ((char *) orig)
#define attach_rdecl_list(orig) (rdecl_list) dcg_attach ((char *) orig)
#define att_rdecl_list(orig) (void) dcg_attach ((char *) orig)
#define attach_variable_list(orig) (variable_list) dcg_attach ((char *) orig)
#define att_variable_list(orig) (void) dcg_attach ((char *) orig)
#define attach_definition_list(orig) (definition_list) dcg_attach ((char *) orig)
#define att_definition_list(orig) (void) dcg_attach ((char *) orig)
#define attach_fpar_list(orig) (fpar_list) dcg_attach ((char *) orig)
#define att_fpar_list(orig) (void) dcg_attach ((char *) orig)
#define attach_dir_list(orig) (dir_list) dcg_attach ((char *) orig)
#define att_dir_list(orig) (void) dcg_attach ((char *) orig)
#define attach_alternative_list(orig) (alternative_list) dcg_attach ((char *) orig)
#define att_alternative_list(orig) (void) dcg_attach ((char *) orig)
#define attach_fwo_group_list(orig) (fwo_group_list) dcg_attach ((char *) orig)
#define att_fwo_group_list(orig) (void) dcg_attach ((char *) orig)
#define attach_member_list(orig) (member_list) dcg_attach ((char *) orig)
#define att_member_list(orig) (void) dcg_attach ((char *) orig)
#define attach_apar_list(orig) (apar_list) dcg_attach ((char *) orig)
#define att_apar_list(orig) (void) dcg_attach ((char *) orig)
#define attach_confrontation_list(orig) (confrontation_list) dcg_attach ((char *) orig)
#define att_confrontation_list(orig) (void) dcg_attach ((char *) orig)
#define attach_res_conf_list(orig) (res_conf_list) dcg_attach ((char *) orig)
#define att_res_conf_list(orig) (void) dcg_attach ((char *) orig)
#define attach_affix_term_list(orig) (affix_term_list) dcg_attach ((char *) orig)
#define att_affix_term_list(orig) (void) dcg_attach ((char *) orig)
#define attach_trans_member_list(orig) (trans_member_list) dcg_attach ((char *) orig)
#define att_trans_member_list(orig) (void) dcg_attach ((char *) orig)
#define attach_affix_rule_list(orig) (affix_rule_list) dcg_attach ((char *) orig)
#define att_affix_rule_list(orig) (void) dcg_attach ((char *) orig)
#define attach_affix_alternative_list(orig) (affix_alternative_list) dcg_attach ((char *) orig)
#define att_affix_alternative_list(orig) (void) dcg_attach ((char *) orig)
#define attach_affix_element_list(orig) (affix_element_list) dcg_attach ((char *) orig)
#define att_affix_element_list(orig) (void) dcg_attach ((char *) orig)
#define attach_invisible_nonterminal_list(orig) (invisible_nonterminal_list) dcg_attach ((char *) orig)
#define att_invisible_nonterminal_list(orig) (void) dcg_attach ((char *) orig)
#define attach_element_list(orig) (element_list) dcg_attach ((char *) orig)
#define att_element_list(orig) (void) dcg_attach ((char *) orig)
#define attach_domain_list(orig) (domain_list) dcg_attach ((char *) orig)
#define att_domain_list(orig) (void) dcg_attach ((char *) orig)
#define attach_regexp_list(orig) (regexp_list) dcg_attach ((char *) orig)
#define att_regexp_list(orig) (void) dcg_attach ((char *) orig)
#define attach_name_list(orig) (name_list) dcg_attach ((char *) orig)
#define att_name_list(orig) (void) dcg_attach ((char *) orig)
#define attach_call_solution_list(orig) (call_solution_list) dcg_attach ((char *) orig)
#define att_call_solution_list(orig) (void) dcg_attach ((char *) orig)
#define attach_madm_list(orig) (madm_list) dcg_attach ((char *) orig)
#define att_madm_list(orig) (void) dcg_attach ((char *) orig)

/* Introduce detaching of enumeration types */
#define detach_rule_layer(old)
#define det_rule_layer(old)
#define detach_rule_type(old)
#define det_rule_type(old)
#define detach_rule_kind(old)
#define det_rule_kind(old)
#define detach_dir(old)
#define det_dir(old)
#define detach_glue(old)
#define det_glue(old)
#define detach_guard_type(old)
#define det_guard_type(old)
#define detach_control_op(old)
#define det_control_op(old)
#define detach_nullability(old)
#define det_nullability(old)
#define detach_arule_kind(old)
#define det_arule_kind(old)

/* Introduce detaching of record types */
void detach_grammar (grammar *optr);
#define det_grammar(optr) detach_grammar(optr)
void detach_prule (prule *optr);
#define det_prule(optr) detach_prule(optr)
void detach_plhs (plhs *optr);
#define det_plhs(optr) detach_plhs(optr)
void detach_rule (rule *optr);
#define det_rule(optr) detach_rule(optr)
void detach_spec (spec *optr);
#define det_spec(optr) detach_spec(optr)
void detach_rdecl (rdecl *optr);
#define det_rdecl(optr) detach_rdecl(optr)
void detach_variable (variable *optr);
#define det_variable(optr) detach_variable(optr)
void detach_definition (definition *optr);
#define det_definition(optr) detach_definition(optr)
void detach_fpar (fpar *optr);
#define det_fpar(optr) detach_fpar(optr)
void detach_group (group *optr);
#define det_group(optr) detach_group(optr)
void detach_alternative (alternative *optr);
#define det_alternative(optr) detach_alternative(optr)
void detach_fwo_group (fwo_group *optr);
#define det_fwo_group(optr) detach_fwo_group(optr)
void detach_member (member *optr);
#define det_member(optr) detach_member(optr)
void detach_apar (apar *optr);
#define det_apar(optr) detach_apar(optr)
void detach_confrontation (confrontation *optr);
#define det_confrontation(optr) detach_confrontation(optr)
void detach_res_conf (res_conf *optr);
#define det_res_conf(optr) detach_res_conf(optr)
void detach_affix_term (affix_term *optr);
#define det_affix_term(optr) detach_affix_term(optr)
void detach_trans_member (trans_member *optr);
#define det_trans_member(optr) detach_trans_member(optr)
void detach_hyb_op (hyb_op *optr);
#define det_hyb_op(optr) detach_hyb_op(optr)
void detach_affix_rule (affix_rule *optr);
#define det_affix_rule(optr) detach_affix_rule(optr)
void detach_affix_alternative (affix_alternative *optr);
#define det_affix_alternative(optr) detach_affix_alternative(optr)
void detach_affix_element (affix_element *optr);
#define det_affix_element(optr) detach_affix_element(optr)
void detach_invisible_nonterminal (invisible_nonterminal *optr);
#define det_invisible_nonterminal(optr) detach_invisible_nonterminal(optr)
void detach_element (element *optr);
#define det_element(optr) detach_element(optr)
void detach_domain (domain *optr);
#define det_domain(optr) detach_domain(optr)
void detach_regexp (regexp *optr);
#define det_regexp(optr) detach_regexp(optr)
void detach_name (name *optr);
#define det_name(optr) detach_name(optr)
void detach_call_solution (call_solution *optr);
#define det_call_solution(optr) detach_call_solution(optr)
void detach_madm (madm *optr);
#define det_madm(optr) detach_madm(optr)

/* Introduce detaching of lists */
void detach_grammar_list (grammar_list *lp);
void detach_prule_list (prule_list *lp);
void detach_plhs_list (plhs_list *lp);
void detach_rule_list (rule_list *lp);
void detach_rdecl_list (rdecl_list *lp);
void detach_variable_list (variable_list *lp);
void detach_definition_list (definition_list *lp);
void detach_fpar_list (fpar_list *lp);
void detach_dir_list (dir_list *lp);
void detach_alternative_list (alternative_list *lp);
void detach_fwo_group_list (fwo_group_list *lp);
void detach_member_list (member_list *lp);
void detach_apar_list (apar_list *lp);
void detach_confrontation_list (confrontation_list *lp);
void detach_res_conf_list (res_conf_list *lp);
void detach_affix_term_list (affix_term_list *lp);
void detach_trans_member_list (trans_member_list *lp);
void detach_affix_rule_list (affix_rule_list *lp);
void detach_affix_alternative_list (affix_alternative_list *lp);
void detach_affix_element_list (affix_element_list *lp);
void detach_invisible_nonterminal_list (invisible_nonterminal_list *lp);
void detach_element_list (element_list *lp);
void detach_domain_list (domain_list *lp);
void detach_regexp_list (regexp_list *lp);
void detach_name_list (name_list *lp);
void detach_call_solution_list (call_solution_list *lp);
void detach_madm_list (madm_list *lp);

/* Introduce nonrecursive detaching of lists */
void nonrec_detach_grammar_list (grammar_list *lp);
void nonrec_detach_prule_list (prule_list *lp);
void nonrec_detach_plhs_list (plhs_list *lp);
void nonrec_detach_rule_list (rule_list *lp);
void nonrec_detach_rdecl_list (rdecl_list *lp);
void nonrec_detach_variable_list (variable_list *lp);
void nonrec_detach_definition_list (definition_list *lp);
void nonrec_detach_fpar_list (fpar_list *lp);
void nonrec_detach_dir_list (dir_list *lp);
void nonrec_detach_alternative_list (alternative_list *lp);
void nonrec_detach_fwo_group_list (fwo_group_list *lp);
void nonrec_detach_member_list (member_list *lp);
void nonrec_detach_apar_list (apar_list *lp);
void nonrec_detach_confrontation_list (confrontation_list *lp);
void nonrec_detach_res_conf_list (res_conf_list *lp);
void nonrec_detach_affix_term_list (affix_term_list *lp);
void nonrec_detach_trans_member_list (trans_member_list *lp);
void nonrec_detach_affix_rule_list (affix_rule_list *lp);
void nonrec_detach_affix_alternative_list (affix_alternative_list *lp);
void nonrec_detach_affix_element_list (affix_element_list *lp);
void nonrec_detach_invisible_nonterminal_list (invisible_nonterminal_list *lp);
void nonrec_detach_element_list (element_list *lp);
void nonrec_detach_domain_list (domain_list *lp);
void nonrec_detach_regexp_list (regexp_list *lp);
void nonrec_detach_name_list (name_list *lp);
void nonrec_detach_call_solution_list (call_solution_list *lp);
void nonrec_detach_madm_list (madm_list *lp);

/* Introduce list append routines */
grammar_list append_grammar_list (grammar_list l, grammar el);
prule_list append_prule_list (prule_list l, prule el);
plhs_list append_plhs_list (plhs_list l, plhs el);
rule_list append_rule_list (rule_list l, rule el);
rdecl_list append_rdecl_list (rdecl_list l, rdecl el);
variable_list append_variable_list (variable_list l, variable el);
definition_list append_definition_list (definition_list l, definition el);
fpar_list append_fpar_list (fpar_list l, fpar el);
dir_list append_dir_list (dir_list l, dir el);
alternative_list append_alternative_list (alternative_list l, alternative el);
fwo_group_list append_fwo_group_list (fwo_group_list l, fwo_group el);
member_list append_member_list (member_list l, member el);
apar_list append_apar_list (apar_list l, apar el);
confrontation_list append_confrontation_list (confrontation_list l, confrontation el);
res_conf_list append_res_conf_list (res_conf_list l, res_conf el);
affix_term_list append_affix_term_list (affix_term_list l, affix_term el);
trans_member_list append_trans_member_list (trans_member_list l, trans_member el);
affix_rule_list append_affix_rule_list (affix_rule_list l, affix_rule el);
affix_alternative_list append_affix_alternative_list (affix_alternative_list l, affix_alternative el);
affix_element_list append_affix_element_list (affix_element_list l, affix_element el);
invisible_nonterminal_list append_invisible_nonterminal_list (invisible_nonterminal_list l, invisible_nonterminal el);
element_list append_element_list (element_list l, element el);
domain_list append_domain_list (domain_list l, domain el);
regexp_list append_regexp_list (regexp_list l, regexp el);
name_list append_name_list (name_list l, name el);
call_solution_list append_call_solution_list (call_solution_list l, call_solution el);
madm_list append_madm_list (madm_list l, madm el);

/* Introduce void shorthands for list append routines */
#define app_grammar_list(l,el) (void) append_grammar_list (l,el)
#define app_prule_list(l,el) (void) append_prule_list (l,el)
#define app_plhs_list(l,el) (void) append_plhs_list (l,el)
#define app_rule_list(l,el) (void) append_rule_list (l,el)
#define app_rdecl_list(l,el) (void) append_rdecl_list (l,el)
#define app_variable_list(l,el) (void) append_variable_list (l,el)
#define app_definition_list(l,el) (void) append_definition_list (l,el)
#define app_fpar_list(l,el) (void) append_fpar_list (l,el)
#define app_dir_list(l,el) (void) append_dir_list (l,el)
#define app_alternative_list(l,el) (void) append_alternative_list (l,el)
#define app_fwo_group_list(l,el) (void) append_fwo_group_list (l,el)
#define app_member_list(l,el) (void) append_member_list (l,el)
#define app_apar_list(l,el) (void) append_apar_list (l,el)
#define app_confrontation_list(l,el) (void) append_confrontation_list (l,el)
#define app_res_conf_list(l,el) (void) append_res_conf_list (l,el)
#define app_affix_term_list(l,el) (void) append_affix_term_list (l,el)
#define app_trans_member_list(l,el) (void) append_trans_member_list (l,el)
#define app_affix_rule_list(l,el) (void) append_affix_rule_list (l,el)
#define app_affix_alternative_list(l,el) (void) append_affix_alternative_list (l,el)
#define app_affix_element_list(l,el) (void) append_affix_element_list (l,el)
#define app_invisible_nonterminal_list(l,el) (void) append_invisible_nonterminal_list (l,el)
#define app_element_list(l,el) (void) append_element_list (l,el)
#define app_domain_list(l,el) (void) append_domain_list (l,el)
#define app_regexp_list(l,el) (void) append_regexp_list (l,el)
#define app_name_list(l,el) (void) append_name_list (l,el)
#define app_call_solution_list(l,el) (void) append_call_solution_list (l,el)
#define app_madm_list(l,el) (void) append_madm_list (l,el)

/* Introduce list concat routines */
grammar_list concat_grammar_list (grammar_list l1, grammar_list l2);
prule_list concat_prule_list (prule_list l1, prule_list l2);
plhs_list concat_plhs_list (plhs_list l1, plhs_list l2);
rule_list concat_rule_list (rule_list l1, rule_list l2);
rdecl_list concat_rdecl_list (rdecl_list l1, rdecl_list l2);
variable_list concat_variable_list (variable_list l1, variable_list l2);
definition_list concat_definition_list (definition_list l1, definition_list l2);
fpar_list concat_fpar_list (fpar_list l1, fpar_list l2);
dir_list concat_dir_list (dir_list l1, dir_list l2);
alternative_list concat_alternative_list (alternative_list l1, alternative_list l2);
fwo_group_list concat_fwo_group_list (fwo_group_list l1, fwo_group_list l2);
member_list concat_member_list (member_list l1, member_list l2);
apar_list concat_apar_list (apar_list l1, apar_list l2);
confrontation_list concat_confrontation_list (confrontation_list l1, confrontation_list l2);
res_conf_list concat_res_conf_list (res_conf_list l1, res_conf_list l2);
affix_term_list concat_affix_term_list (affix_term_list l1, affix_term_list l2);
trans_member_list concat_trans_member_list (trans_member_list l1, trans_member_list l2);
affix_rule_list concat_affix_rule_list (affix_rule_list l1, affix_rule_list l2);
affix_alternative_list concat_affix_alternative_list (affix_alternative_list l1, affix_alternative_list l2);
affix_element_list concat_affix_element_list (affix_element_list l1, affix_element_list l2);
invisible_nonterminal_list concat_invisible_nonterminal_list (invisible_nonterminal_list l1, invisible_nonterminal_list l2);
element_list concat_element_list (element_list l1, element_list l2);
domain_list concat_domain_list (domain_list l1, domain_list l2);
regexp_list concat_regexp_list (regexp_list l1, regexp_list l2);
name_list concat_name_list (name_list l1, name_list l2);
call_solution_list concat_call_solution_list (call_solution_list l1, call_solution_list l2);
madm_list concat_madm_list (madm_list l1, madm_list l2);

/* Introduce void shorthands for list concat routines */
#define conc_grammar_list(l1,l2) (void) concat_grammar_list (l1,l2)
#define conc_prule_list(l1,l2) (void) concat_prule_list (l1,l2)
#define conc_plhs_list(l1,l2) (void) concat_plhs_list (l1,l2)
#define conc_rule_list(l1,l2) (void) concat_rule_list (l1,l2)
#define conc_rdecl_list(l1,l2) (void) concat_rdecl_list (l1,l2)
#define conc_variable_list(l1,l2) (void) concat_variable_list (l1,l2)
#define conc_definition_list(l1,l2) (void) concat_definition_list (l1,l2)
#define conc_fpar_list(l1,l2) (void) concat_fpar_list (l1,l2)
#define conc_dir_list(l1,l2) (void) concat_dir_list (l1,l2)
#define conc_alternative_list(l1,l2) (void) concat_alternative_list (l1,l2)
#define conc_fwo_group_list(l1,l2) (void) concat_fwo_group_list (l1,l2)
#define conc_member_list(l1,l2) (void) concat_member_list (l1,l2)
#define conc_apar_list(l1,l2) (void) concat_apar_list (l1,l2)
#define conc_confrontation_list(l1,l2) (void) concat_confrontation_list (l1,l2)
#define conc_res_conf_list(l1,l2) (void) concat_res_conf_list (l1,l2)
#define conc_affix_term_list(l1,l2) (void) concat_affix_term_list (l1,l2)
#define conc_trans_member_list(l1,l2) (void) concat_trans_member_list (l1,l2)
#define conc_affix_rule_list(l1,l2) (void) concat_affix_rule_list (l1,l2)
#define conc_affix_alternative_list(l1,l2) (void) concat_affix_alternative_list (l1,l2)
#define conc_affix_element_list(l1,l2) (void) concat_affix_element_list (l1,l2)
#define conc_invisible_nonterminal_list(l1,l2) (void) concat_invisible_nonterminal_list (l1,l2)
#define conc_element_list(l1,l2) (void) concat_element_list (l1,l2)
#define conc_domain_list(l1,l2) (void) concat_domain_list (l1,l2)
#define conc_regexp_list(l1,l2) (void) concat_regexp_list (l1,l2)
#define conc_name_list(l1,l2) (void) concat_name_list (l1,l2)
#define conc_call_solution_list(l1,l2) (void) concat_call_solution_list (l1,l2)
#define conc_madm_list(l1,l2) (void) concat_madm_list (l1,l2)

/* Introduce list insertion routines */
grammar_list insert_grammar_list (grammar_list l, int pos, grammar el);
prule_list insert_prule_list (prule_list l, int pos, prule el);
plhs_list insert_plhs_list (plhs_list l, int pos, plhs el);
rule_list insert_rule_list (rule_list l, int pos, rule el);
rdecl_list insert_rdecl_list (rdecl_list l, int pos, rdecl el);
variable_list insert_variable_list (variable_list l, int pos, variable el);
definition_list insert_definition_list (definition_list l, int pos, definition el);
fpar_list insert_fpar_list (fpar_list l, int pos, fpar el);
dir_list insert_dir_list (dir_list l, int pos, dir el);
alternative_list insert_alternative_list (alternative_list l, int pos, alternative el);
fwo_group_list insert_fwo_group_list (fwo_group_list l, int pos, fwo_group el);
member_list insert_member_list (member_list l, int pos, member el);
apar_list insert_apar_list (apar_list l, int pos, apar el);
confrontation_list insert_confrontation_list (confrontation_list l, int pos, confrontation el);
res_conf_list insert_res_conf_list (res_conf_list l, int pos, res_conf el);
affix_term_list insert_affix_term_list (affix_term_list l, int pos, affix_term el);
trans_member_list insert_trans_member_list (trans_member_list l, int pos, trans_member el);
affix_rule_list insert_affix_rule_list (affix_rule_list l, int pos, affix_rule el);
affix_alternative_list insert_affix_alternative_list (affix_alternative_list l, int pos, affix_alternative el);
affix_element_list insert_affix_element_list (affix_element_list l, int pos, affix_element el);
invisible_nonterminal_list insert_invisible_nonterminal_list (invisible_nonterminal_list l, int pos, invisible_nonterminal el);
element_list insert_element_list (element_list l, int pos, element el);
domain_list insert_domain_list (domain_list l, int pos, domain el);
regexp_list insert_regexp_list (regexp_list l, int pos, regexp el);
name_list insert_name_list (name_list l, int pos, name el);
call_solution_list insert_call_solution_list (call_solution_list l, int pos, call_solution el);
madm_list insert_madm_list (madm_list l, int pos, madm el);

/* Introduce void shorthands for list insertion routines */
#define ins_grammar_list(l,pos,el) (void) insert_grammar_list (l,pos,el)
#define ins_prule_list(l,pos,el) (void) insert_prule_list (l,pos,el)
#define ins_plhs_list(l,pos,el) (void) insert_plhs_list (l,pos,el)
#define ins_rule_list(l,pos,el) (void) insert_rule_list (l,pos,el)
#define ins_rdecl_list(l,pos,el) (void) insert_rdecl_list (l,pos,el)
#define ins_variable_list(l,pos,el) (void) insert_variable_list (l,pos,el)
#define ins_definition_list(l,pos,el) (void) insert_definition_list (l,pos,el)
#define ins_fpar_list(l,pos,el) (void) insert_fpar_list (l,pos,el)
#define ins_dir_list(l,pos,el) (void) insert_dir_list (l,pos,el)
#define ins_alternative_list(l,pos,el) (void) insert_alternative_list (l,pos,el)
#define ins_fwo_group_list(l,pos,el) (void) insert_fwo_group_list (l,pos,el)
#define ins_member_list(l,pos,el) (void) insert_member_list (l,pos,el)
#define ins_apar_list(l,pos,el) (void) insert_apar_list (l,pos,el)
#define ins_confrontation_list(l,pos,el) (void) insert_confrontation_list (l,pos,el)
#define ins_res_conf_list(l,pos,el) (void) insert_res_conf_list (l,pos,el)
#define ins_affix_term_list(l,pos,el) (void) insert_affix_term_list (l,pos,el)
#define ins_trans_member_list(l,pos,el) (void) insert_trans_member_list (l,pos,el)
#define ins_affix_rule_list(l,pos,el) (void) insert_affix_rule_list (l,pos,el)
#define ins_affix_alternative_list(l,pos,el) (void) insert_affix_alternative_list (l,pos,el)
#define ins_affix_element_list(l,pos,el) (void) insert_affix_element_list (l,pos,el)
#define ins_invisible_nonterminal_list(l,pos,el) (void) insert_invisible_nonterminal_list (l,pos,el)
#define ins_element_list(l,pos,el) (void) insert_element_list (l,pos,el)
#define ins_domain_list(l,pos,el) (void) insert_domain_list (l,pos,el)
#define ins_regexp_list(l,pos,el) (void) insert_regexp_list (l,pos,el)
#define ins_name_list(l,pos,el) (void) insert_name_list (l,pos,el)
#define ins_call_solution_list(l,pos,el) (void) insert_call_solution_list (l,pos,el)
#define ins_madm_list(l,pos,el) (void) insert_madm_list (l,pos,el)

/* Introduce list deletion routines */
grammar_list delete_grammar_list (grammar_list l, int pos);
prule_list delete_prule_list (prule_list l, int pos);
plhs_list delete_plhs_list (plhs_list l, int pos);
rule_list delete_rule_list (rule_list l, int pos);
rdecl_list delete_rdecl_list (rdecl_list l, int pos);
variable_list delete_variable_list (variable_list l, int pos);
definition_list delete_definition_list (definition_list l, int pos);
fpar_list delete_fpar_list (fpar_list l, int pos);
dir_list delete_dir_list (dir_list l, int pos);
alternative_list delete_alternative_list (alternative_list l, int pos);
fwo_group_list delete_fwo_group_list (fwo_group_list l, int pos);
member_list delete_member_list (member_list l, int pos);
apar_list delete_apar_list (apar_list l, int pos);
confrontation_list delete_confrontation_list (confrontation_list l, int pos);
res_conf_list delete_res_conf_list (res_conf_list l, int pos);
affix_term_list delete_affix_term_list (affix_term_list l, int pos);
trans_member_list delete_trans_member_list (trans_member_list l, int pos);
affix_rule_list delete_affix_rule_list (affix_rule_list l, int pos);
affix_alternative_list delete_affix_alternative_list (affix_alternative_list l, int pos);
affix_element_list delete_affix_element_list (affix_element_list l, int pos);
invisible_nonterminal_list delete_invisible_nonterminal_list (invisible_nonterminal_list l, int pos);
element_list delete_element_list (element_list l, int pos);
domain_list delete_domain_list (domain_list l, int pos);
regexp_list delete_regexp_list (regexp_list l, int pos);
name_list delete_name_list (name_list l, int pos);
call_solution_list delete_call_solution_list (call_solution_list l, int pos);
madm_list delete_madm_list (madm_list l, int pos);

/* Introduce void shorthands for list deletion routines */
#define del_grammar_list(l,pos) (void) delete_grammar_list (l,pos)
#define del_prule_list(l,pos) (void) delete_prule_list (l,pos)
#define del_plhs_list(l,pos) (void) delete_plhs_list (l,pos)
#define del_rule_list(l,pos) (void) delete_rule_list (l,pos)
#define del_rdecl_list(l,pos) (void) delete_rdecl_list (l,pos)
#define del_variable_list(l,pos) (void) delete_variable_list (l,pos)
#define del_definition_list(l,pos) (void) delete_definition_list (l,pos)
#define del_fpar_list(l,pos) (void) delete_fpar_list (l,pos)
#define del_dir_list(l,pos) (void) delete_dir_list (l,pos)
#define del_alternative_list(l,pos) (void) delete_alternative_list (l,pos)
#define del_fwo_group_list(l,pos) (void) delete_fwo_group_list (l,pos)
#define del_member_list(l,pos) (void) delete_member_list (l,pos)
#define del_apar_list(l,pos) (void) delete_apar_list (l,pos)
#define del_confrontation_list(l,pos) (void) delete_confrontation_list (l,pos)
#define del_res_conf_list(l,pos) (void) delete_res_conf_list (l,pos)
#define del_affix_term_list(l,pos) (void) delete_affix_term_list (l,pos)
#define del_trans_member_list(l,pos) (void) delete_trans_member_list (l,pos)
#define del_affix_rule_list(l,pos) (void) delete_affix_rule_list (l,pos)
#define del_affix_alternative_list(l,pos) (void) delete_affix_alternative_list (l,pos)
#define del_affix_element_list(l,pos) (void) delete_affix_element_list (l,pos)
#define del_invisible_nonterminal_list(l,pos) (void) delete_invisible_nonterminal_list (l,pos)
#define del_element_list(l,pos) (void) delete_element_list (l,pos)
#define del_domain_list(l,pos) (void) delete_domain_list (l,pos)
#define del_regexp_list(l,pos) (void) delete_regexp_list (l,pos)
#define del_name_list(l,pos) (void) delete_name_list (l,pos)
#define del_call_solution_list(l,pos) (void) delete_call_solution_list (l,pos)
#define del_madm_list(l,pos) (void) delete_madm_list (l,pos)

/* Equality test for types */
int cmp_grammar (grammar a, grammar b);
int cmp_prule (prule a, prule b);
int cmp_plhs (plhs a, plhs b);
int cmp_rule (rule a, rule b);
int cmp_spec (spec a, spec b);
#define cmp_rule_layer(a,b) (cmp_int ((int)(a),(int)(b)))
#define cmp_rule_type(a,b) (cmp_int ((int)(a),(int)(b)))
#define cmp_rule_kind(a,b) (cmp_int ((int)(a),(int)(b)))
int cmp_rdecl (rdecl a, rdecl b);
int cmp_variable (variable a, variable b);
int cmp_definition (definition a, definition b);
int cmp_fpar (fpar a, fpar b);
#define cmp_dir(a,b) (cmp_int ((int)(a),(int)(b)))
int cmp_group (group a, group b);
int cmp_alternative (alternative a, alternative b);
int cmp_fwo_group (fwo_group a, fwo_group b);
#define cmp_glue(a,b) (cmp_int ((int)(a),(int)(b)))
int cmp_member (member a, member b);
int cmp_apar (apar a, apar b);
int cmp_confrontation (confrontation a, confrontation b);
int cmp_res_conf (res_conf a, res_conf b);
#define cmp_guard_type(a,b) (cmp_int ((int)(a),(int)(b)))
#define cmp_control_op(a,b) (cmp_int ((int)(a),(int)(b)))
int cmp_affix_term (affix_term a, affix_term b);
int cmp_trans_member (trans_member a, trans_member b);
int cmp_hyb_op (hyb_op a, hyb_op b);
int cmp_affix_rule (affix_rule a, affix_rule b);
int cmp_affix_alternative (affix_alternative a, affix_alternative b);
int cmp_affix_element (affix_element a, affix_element b);
#define cmp_nullability(a,b) (cmp_int ((int)(a),(int)(b)))
#define cmp_arule_kind(a,b) (cmp_int ((int)(a),(int)(b)))
int cmp_invisible_nonterminal (invisible_nonterminal a, invisible_nonterminal b);
int cmp_element (element a, element b);
int cmp_domain (domain a, domain b);
int cmp_regexp (regexp a, regexp b);
int cmp_name (name a, name b);
int cmp_call_solution (call_solution a, call_solution b);
int cmp_madm (madm a, madm b);

/* Comparison tests for lists */
int cmp_grammar_list (grammar_list a, grammar_list b);
int cmp_prule_list (prule_list a, prule_list b);
int cmp_plhs_list (plhs_list a, plhs_list b);
int cmp_rule_list (rule_list a, rule_list b);
int cmp_rdecl_list (rdecl_list a, rdecl_list b);
int cmp_variable_list (variable_list a, variable_list b);
int cmp_definition_list (definition_list a, definition_list b);
int cmp_fpar_list (fpar_list a, fpar_list b);
int cmp_dir_list (dir_list a, dir_list b);
int cmp_alternative_list (alternative_list a, alternative_list b);
int cmp_fwo_group_list (fwo_group_list a, fwo_group_list b);
int cmp_member_list (member_list a, member_list b);
int cmp_apar_list (apar_list a, apar_list b);
int cmp_confrontation_list (confrontation_list a, confrontation_list b);
int cmp_res_conf_list (res_conf_list a, res_conf_list b);
int cmp_affix_term_list (affix_term_list a, affix_term_list b);
int cmp_trans_member_list (trans_member_list a, trans_member_list b);
int cmp_affix_rule_list (affix_rule_list a, affix_rule_list b);
int cmp_affix_alternative_list (affix_alternative_list a, affix_alternative_list b);
int cmp_affix_element_list (affix_element_list a, affix_element_list b);
int cmp_invisible_nonterminal_list (invisible_nonterminal_list a, invisible_nonterminal_list b);
int cmp_element_list (element_list a, element_list b);
int cmp_domain_list (domain_list a, domain_list b);
int cmp_regexp_list (regexp_list a, regexp_list b);
int cmp_name_list (name_list a, name_list b);
int cmp_call_solution_list (call_solution_list a, call_solution_list b);
int cmp_madm_list (madm_list a, madm_list b);

/* Equality shorthands for types */
#define equal_grammar(a,b) !cmp_grammar ((a),(b))
#define equal_prule(a,b) !cmp_prule ((a),(b))
#define equal_plhs(a,b) !cmp_plhs ((a),(b))
#define equal_rule(a,b) !cmp_rule ((a),(b))
#define equal_spec(a,b) !cmp_spec ((a),(b))
#define equal_rule_layer(a,b) !cmp_rule_layer ((a),(b))
#define equal_rule_type(a,b) !cmp_rule_type ((a),(b))
#define equal_rule_kind(a,b) !cmp_rule_kind ((a),(b))
#define equal_rdecl(a,b) !cmp_rdecl ((a),(b))
#define equal_variable(a,b) !cmp_variable ((a),(b))
#define equal_definition(a,b) !cmp_definition ((a),(b))
#define equal_fpar(a,b) !cmp_fpar ((a),(b))
#define equal_dir(a,b) !cmp_dir ((a),(b))
#define equal_group(a,b) !cmp_group ((a),(b))
#define equal_alternative(a,b) !cmp_alternative ((a),(b))
#define equal_fwo_group(a,b) !cmp_fwo_group ((a),(b))
#define equal_glue(a,b) !cmp_glue ((a),(b))
#define equal_member(a,b) !cmp_member ((a),(b))
#define equal_apar(a,b) !cmp_apar ((a),(b))
#define equal_confrontation(a,b) !cmp_confrontation ((a),(b))
#define equal_res_conf(a,b) !cmp_res_conf ((a),(b))
#define equal_guard_type(a,b) !cmp_guard_type ((a),(b))
#define equal_control_op(a,b) !cmp_control_op ((a),(b))
#define equal_affix_term(a,b) !cmp_affix_term ((a),(b))
#define equal_trans_member(a,b) !cmp_trans_member ((a),(b))
#define equal_hyb_op(a,b) !cmp_hyb_op ((a),(b))
#define equal_affix_rule(a,b) !cmp_affix_rule ((a),(b))
#define equal_affix_alternative(a,b) !cmp_affix_alternative ((a),(b))
#define equal_affix_element(a,b) !cmp_affix_element ((a),(b))
#define equal_nullability(a,b) !cmp_nullability ((a),(b))
#define equal_arule_kind(a,b) !cmp_arule_kind ((a),(b))
#define equal_invisible_nonterminal(a,b) !cmp_invisible_nonterminal ((a),(b))
#define equal_element(a,b) !cmp_element ((a),(b))
#define equal_domain(a,b) !cmp_domain ((a),(b))
#define equal_regexp(a,b) !cmp_regexp ((a),(b))
#define equal_name(a,b) !cmp_name ((a),(b))
#define equal_call_solution(a,b) !cmp_call_solution ((a),(b))
#define equal_madm(a,b) !cmp_madm ((a),(b))

/* Equality shorthands for lists */
#define equal_grammar_list(a,b) !cmp_grammar_list((a),(b))
#define equal_prule_list(a,b) !cmp_prule_list((a),(b))
#define equal_plhs_list(a,b) !cmp_plhs_list((a),(b))
#define equal_rule_list(a,b) !cmp_rule_list((a),(b))
#define equal_rdecl_list(a,b) !cmp_rdecl_list((a),(b))
#define equal_variable_list(a,b) !cmp_variable_list((a),(b))
#define equal_definition_list(a,b) !cmp_definition_list((a),(b))
#define equal_fpar_list(a,b) !cmp_fpar_list((a),(b))
#define equal_dir_list(a,b) !cmp_dir_list((a),(b))
#define equal_alternative_list(a,b) !cmp_alternative_list((a),(b))
#define equal_fwo_group_list(a,b) !cmp_fwo_group_list((a),(b))
#define equal_member_list(a,b) !cmp_member_list((a),(b))
#define equal_apar_list(a,b) !cmp_apar_list((a),(b))
#define equal_confrontation_list(a,b) !cmp_confrontation_list((a),(b))
#define equal_res_conf_list(a,b) !cmp_res_conf_list((a),(b))
#define equal_affix_term_list(a,b) !cmp_affix_term_list((a),(b))
#define equal_trans_member_list(a,b) !cmp_trans_member_list((a),(b))
#define equal_affix_rule_list(a,b) !cmp_affix_rule_list((a),(b))
#define equal_affix_alternative_list(a,b) !cmp_affix_alternative_list((a),(b))
#define equal_affix_element_list(a,b) !cmp_affix_element_list((a),(b))
#define equal_invisible_nonterminal_list(a,b) !cmp_invisible_nonterminal_list((a),(b))
#define equal_element_list(a,b) !cmp_element_list((a),(b))
#define equal_domain_list(a,b) !cmp_domain_list((a),(b))
#define equal_regexp_list(a,b) !cmp_regexp_list((a),(b))
#define equal_name_list(a,b) !cmp_name_list((a),(b))
#define equal_call_solution_list(a,b) !cmp_call_solution_list((a),(b))
#define equal_madm_list(a,b) !cmp_madm_list((a),(b))

/* Estimating printing of types */
int est_grammar (grammar old);
int est_prule (prule old);
int est_plhs (plhs old);
int est_rule (rule old);
int est_spec (spec old);
int est_rule_layer (rule_layer old);
int est_rule_type (rule_type old);
int est_rule_kind (rule_kind old);
int est_rdecl (rdecl old);
int est_variable (variable old);
int est_definition (definition old);
int est_fpar (fpar old);
int est_dir (dir old);
int est_group (group old);
int est_alternative (alternative old);
int est_fwo_group (fwo_group old);
int est_glue (glue old);
int est_member (member old);
int est_apar (apar old);
int est_confrontation (confrontation old);
int est_res_conf (res_conf old);
int est_guard_type (guard_type old);
int est_control_op (control_op old);
int est_affix_term (affix_term old);
int est_trans_member (trans_member old);
int est_hyb_op (hyb_op old);
int est_affix_rule (affix_rule old);
int est_affix_alternative (affix_alternative old);
int est_affix_element (affix_element old);
int est_nullability (nullability old);
int est_arule_kind (arule_kind old);
int est_invisible_nonterminal (invisible_nonterminal old);
int est_element (element old);
int est_domain (domain old);
int est_regexp (regexp old);
int est_name (name old);
int est_call_solution (call_solution old);
int est_madm (madm old);

/* Estimate printing of lists */
int est_grammar_list (grammar_list old);
int est_prule_list (prule_list old);
int est_plhs_list (plhs_list old);
int est_rule_list (rule_list old);
int est_rdecl_list (rdecl_list old);
int est_variable_list (variable_list old);
int est_definition_list (definition_list old);
int est_fpar_list (fpar_list old);
int est_dir_list (dir_list old);
int est_alternative_list (alternative_list old);
int est_fwo_group_list (fwo_group_list old);
int est_member_list (member_list old);
int est_apar_list (apar_list old);
int est_confrontation_list (confrontation_list old);
int est_res_conf_list (res_conf_list old);
int est_affix_term_list (affix_term_list old);
int est_trans_member_list (trans_member_list old);
int est_affix_rule_list (affix_rule_list old);
int est_affix_alternative_list (affix_alternative_list old);
int est_affix_element_list (affix_element_list old);
int est_invisible_nonterminal_list (invisible_nonterminal_list old);
int est_element_list (element_list old);
int est_domain_list (domain_list old);
int est_regexp_list (regexp_list old);
int est_name_list (name_list old);
int est_call_solution_list (call_solution_list old);
int est_madm_list (madm_list old);

void ppp_grammar (FILE *f, int horiz, int ind, grammar old);
void ppp_prule (FILE *f, int horiz, int ind, prule old);
void ppp_plhs (FILE *f, int horiz, int ind, plhs old);
void ppp_rule (FILE *f, int horiz, int ind, rule old);
void ppp_spec (FILE *f, int horiz, int ind, spec old);
void ppp_rule_layer (FILE *f, int horiz, int ind, rule_layer old);
void ppp_rule_type (FILE *f, int horiz, int ind, rule_type old);
void ppp_rule_kind (FILE *f, int horiz, int ind, rule_kind old);
void ppp_rdecl (FILE *f, int horiz, int ind, rdecl old);
void ppp_variable (FILE *f, int horiz, int ind, variable old);
void ppp_definition (FILE *f, int horiz, int ind, definition old);
void ppp_fpar (FILE *f, int horiz, int ind, fpar old);
void ppp_dir (FILE *f, int horiz, int ind, dir old);
void ppp_group (FILE *f, int horiz, int ind, group old);
void ppp_alternative (FILE *f, int horiz, int ind, alternative old);
void ppp_fwo_group (FILE *f, int horiz, int ind, fwo_group old);
void ppp_glue (FILE *f, int horiz, int ind, glue old);
void ppp_member (FILE *f, int horiz, int ind, member old);
void ppp_apar (FILE *f, int horiz, int ind, apar old);
void ppp_confrontation (FILE *f, int horiz, int ind, confrontation old);
void ppp_res_conf (FILE *f, int horiz, int ind, res_conf old);
void ppp_guard_type (FILE *f, int horiz, int ind, guard_type old);
void ppp_control_op (FILE *f, int horiz, int ind, control_op old);
void ppp_affix_term (FILE *f, int horiz, int ind, affix_term old);
void ppp_trans_member (FILE *f, int horiz, int ind, trans_member old);
void ppp_hyb_op (FILE *f, int horiz, int ind, hyb_op old);
void ppp_affix_rule (FILE *f, int horiz, int ind, affix_rule old);
void ppp_affix_alternative (FILE *f, int horiz, int ind, affix_alternative old);
void ppp_affix_element (FILE *f, int horiz, int ind, affix_element old);
void ppp_nullability (FILE *f, int horiz, int ind, nullability old);
void ppp_arule_kind (FILE *f, int horiz, int ind, arule_kind old);
void ppp_invisible_nonterminal (FILE *f, int horiz, int ind, invisible_nonterminal old);
void ppp_element (FILE *f, int horiz, int ind, element old);
void ppp_domain (FILE *f, int horiz, int ind, domain old);
void ppp_regexp (FILE *f, int horiz, int ind, regexp old);
void ppp_name (FILE *f, int horiz, int ind, name old);
void ppp_call_solution (FILE *f, int horiz, int ind, call_solution old);
void ppp_madm (FILE *f, int horiz, int ind, madm old);

/* Introduce pretty printing of lists */
void ppp_grammar_list (FILE *f, int horiz, int ind, grammar_list old);
void ppp_prule_list (FILE *f, int horiz, int ind, prule_list old);
void ppp_plhs_list (FILE *f, int horiz, int ind, plhs_list old);
void ppp_rule_list (FILE *f, int horiz, int ind, rule_list old);
void ppp_rdecl_list (FILE *f, int horiz, int ind, rdecl_list old);
void ppp_variable_list (FILE *f, int horiz, int ind, variable_list old);
void ppp_definition_list (FILE *f, int horiz, int ind, definition_list old);
void ppp_fpar_list (FILE *f, int horiz, int ind, fpar_list old);
void ppp_dir_list (FILE *f, int horiz, int ind, dir_list old);
void ppp_alternative_list (FILE *f, int horiz, int ind, alternative_list old);
void ppp_fwo_group_list (FILE *f, int horiz, int ind, fwo_group_list old);
void ppp_member_list (FILE *f, int horiz, int ind, member_list old);
void ppp_apar_list (FILE *f, int horiz, int ind, apar_list old);
void ppp_confrontation_list (FILE *f, int horiz, int ind, confrontation_list old);
void ppp_res_conf_list (FILE *f, int horiz, int ind, res_conf_list old);
void ppp_affix_term_list (FILE *f, int horiz, int ind, affix_term_list old);
void ppp_trans_member_list (FILE *f, int horiz, int ind, trans_member_list old);
void ppp_affix_rule_list (FILE *f, int horiz, int ind, affix_rule_list old);
void ppp_affix_alternative_list (FILE *f, int horiz, int ind, affix_alternative_list old);
void ppp_affix_element_list (FILE *f, int horiz, int ind, affix_element_list old);
void ppp_invisible_nonterminal_list (FILE *f, int horiz, int ind, invisible_nonterminal_list old);
void ppp_element_list (FILE *f, int horiz, int ind, element_list old);
void ppp_domain_list (FILE *f, int horiz, int ind, domain_list old);
void ppp_regexp_list (FILE *f, int horiz, int ind, regexp_list old);
void ppp_name_list (FILE *f, int horiz, int ind, name_list old);
void ppp_call_solution_list (FILE *f, int horiz, int ind, call_solution_list old);
void ppp_madm_list (FILE *f, int horiz, int ind, madm_list old);

/* Introduce pretty printing shorthands */
#define pp_grammar(f,x) ppp_grammar (f,0,0,x)
#define pp_prule(f,x) ppp_prule (f,0,0,x)
#define pp_plhs(f,x) ppp_plhs (f,0,0,x)
#define pp_rule(f,x) ppp_rule (f,0,0,x)
#define pp_spec(f,x) ppp_spec (f,0,0,x)
#define pp_rule_layer(f,x) ppp_rule_layer (f,0,0,x)
#define pp_rule_type(f,x) ppp_rule_type (f,0,0,x)
#define pp_rule_kind(f,x) ppp_rule_kind (f,0,0,x)
#define pp_rdecl(f,x) ppp_rdecl (f,0,0,x)
#define pp_variable(f,x) ppp_variable (f,0,0,x)
#define pp_definition(f,x) ppp_definition (f,0,0,x)
#define pp_fpar(f,x) ppp_fpar (f,0,0,x)
#define pp_dir(f,x) ppp_dir (f,0,0,x)
#define pp_group(f,x) ppp_group (f,0,0,x)
#define pp_alternative(f,x) ppp_alternative (f,0,0,x)
#define pp_fwo_group(f,x) ppp_fwo_group (f,0,0,x)
#define pp_glue(f,x) ppp_glue (f,0,0,x)
#define pp_member(f,x) ppp_member (f,0,0,x)
#define pp_apar(f,x) ppp_apar (f,0,0,x)
#define pp_confrontation(f,x) ppp_confrontation (f,0,0,x)
#define pp_res_conf(f,x) ppp_res_conf (f,0,0,x)
#define pp_guard_type(f,x) ppp_guard_type (f,0,0,x)
#define pp_control_op(f,x) ppp_control_op (f,0,0,x)
#define pp_affix_term(f,x) ppp_affix_term (f,0,0,x)
#define pp_trans_member(f,x) ppp_trans_member (f,0,0,x)
#define pp_hyb_op(f,x) ppp_hyb_op (f,0,0,x)
#define pp_affix_rule(f,x) ppp_affix_rule (f,0,0,x)
#define pp_affix_alternative(f,x) ppp_affix_alternative (f,0,0,x)
#define pp_affix_element(f,x) ppp_affix_element (f,0,0,x)
#define pp_nullability(f,x) ppp_nullability (f,0,0,x)
#define pp_arule_kind(f,x) ppp_arule_kind (f,0,0,x)
#define pp_invisible_nonterminal(f,x) ppp_invisible_nonterminal (f,0,0,x)
#define pp_element(f,x) ppp_element (f,0,0,x)
#define pp_domain(f,x) ppp_domain (f,0,0,x)
#define pp_regexp(f,x) ppp_regexp (f,0,0,x)
#define pp_name(f,x) ppp_name (f,0,0,x)
#define pp_call_solution(f,x) ppp_call_solution (f,0,0,x)
#define pp_madm(f,x) ppp_madm (f,0,0,x)

/* Introduce pretty printing shorthands for lists */
#define pp_grammar_list(f,x) ppp_grammar_list (f,0,0,x)
#define pp_prule_list(f,x) ppp_prule_list (f,0,0,x)
#define pp_plhs_list(f,x) ppp_plhs_list (f,0,0,x)
#define pp_rule_list(f,x) ppp_rule_list (f,0,0,x)
#define pp_rdecl_list(f,x) ppp_rdecl_list (f,0,0,x)
#define pp_variable_list(f,x) ppp_variable_list (f,0,0,x)
#define pp_definition_list(f,x) ppp_definition_list (f,0,0,x)
#define pp_fpar_list(f,x) ppp_fpar_list (f,0,0,x)
#define pp_dir_list(f,x) ppp_dir_list (f,0,0,x)
#define pp_alternative_list(f,x) ppp_alternative_list (f,0,0,x)
#define pp_fwo_group_list(f,x) ppp_fwo_group_list (f,0,0,x)
#define pp_member_list(f,x) ppp_member_list (f,0,0,x)
#define pp_apar_list(f,x) ppp_apar_list (f,0,0,x)
#define pp_confrontation_list(f,x) ppp_confrontation_list (f,0,0,x)
#define pp_res_conf_list(f,x) ppp_res_conf_list (f,0,0,x)
#define pp_affix_term_list(f,x) ppp_affix_term_list (f,0,0,x)
#define pp_trans_member_list(f,x) ppp_trans_member_list (f,0,0,x)
#define pp_affix_rule_list(f,x) ppp_affix_rule_list (f,0,0,x)
#define pp_affix_alternative_list(f,x) ppp_affix_alternative_list (f,0,0,x)
#define pp_affix_element_list(f,x) ppp_affix_element_list (f,0,0,x)
#define pp_invisible_nonterminal_list(f,x) ppp_invisible_nonterminal_list (f,0,0,x)
#define pp_element_list(f,x) ppp_element_list (f,0,0,x)
#define pp_domain_list(f,x) ppp_domain_list (f,0,0,x)
#define pp_regexp_list(f,x) ppp_regexp_list (f,0,0,x)
#define pp_name_list(f,x) ppp_name_list (f,0,0,x)
#define pp_call_solution_list(f,x) ppp_call_solution_list (f,0,0,x)
#define pp_madm_list(f,x) ppp_madm_list (f,0,0,x)

/* Introduce saving of types */
#define save_rule_layer(bf,x) save_char(bf, (char) x)
#define save_rule_type(bf,x) save_char(bf, (char) x)
#define save_rule_kind(bf,x) save_char(bf, (char) x)
#define save_dir(bf,x) save_char(bf, (char) x)
#define save_glue(bf,x) save_char(bf, (char) x)
#define save_guard_type(bf,x) save_char(bf, (char) x)
#define save_control_op(bf,x) save_char(bf, (char) x)
#define save_nullability(bf,x) save_char(bf, (char) x)
#define save_arule_kind(bf,x) save_char(bf, (char) x)
void save_grammar (BinFile bf, grammar old);
void save_prule (BinFile bf, prule old);
void save_plhs (BinFile bf, plhs old);
void save_rule (BinFile bf, rule old);
void save_spec (BinFile bf, spec old);
void save_rdecl (BinFile bf, rdecl old);
void save_variable (BinFile bf, variable old);
void save_definition (BinFile bf, definition old);
void save_fpar (BinFile bf, fpar old);
void save_group (BinFile bf, group old);
void save_alternative (BinFile bf, alternative old);
void save_fwo_group (BinFile bf, fwo_group old);
void save_member (BinFile bf, member old);
void save_apar (BinFile bf, apar old);
void save_confrontation (BinFile bf, confrontation old);
void save_res_conf (BinFile bf, res_conf old);
void save_affix_term (BinFile bf, affix_term old);
void save_trans_member (BinFile bf, trans_member old);
void save_hyb_op (BinFile bf, hyb_op old);
void save_affix_rule (BinFile bf, affix_rule old);
void save_affix_alternative (BinFile bf, affix_alternative old);
void save_affix_element (BinFile bf, affix_element old);
void save_invisible_nonterminal (BinFile bf, invisible_nonterminal old);
void save_element (BinFile bf, element old);
void save_domain (BinFile bf, domain old);
void save_regexp (BinFile bf, regexp old);
void save_name (BinFile bf, name old);
void save_call_solution (BinFile bf, call_solution old);
void save_madm (BinFile bf, madm old);

/* Introduce saving of lists */
void save_grammar_list (BinFile bf, grammar_list l);
void save_prule_list (BinFile bf, prule_list l);
void save_plhs_list (BinFile bf, plhs_list l);
void save_rule_list (BinFile bf, rule_list l);
void save_rdecl_list (BinFile bf, rdecl_list l);
void save_variable_list (BinFile bf, variable_list l);
void save_definition_list (BinFile bf, definition_list l);
void save_fpar_list (BinFile bf, fpar_list l);
void save_dir_list (BinFile bf, dir_list l);
void save_alternative_list (BinFile bf, alternative_list l);
void save_fwo_group_list (BinFile bf, fwo_group_list l);
void save_member_list (BinFile bf, member_list l);
void save_apar_list (BinFile bf, apar_list l);
void save_confrontation_list (BinFile bf, confrontation_list l);
void save_res_conf_list (BinFile bf, res_conf_list l);
void save_affix_term_list (BinFile bf, affix_term_list l);
void save_trans_member_list (BinFile bf, trans_member_list l);
void save_affix_rule_list (BinFile bf, affix_rule_list l);
void save_affix_alternative_list (BinFile bf, affix_alternative_list l);
void save_affix_element_list (BinFile bf, affix_element_list l);
void save_invisible_nonterminal_list (BinFile bf, invisible_nonterminal_list l);
void save_element_list (BinFile bf, element_list l);
void save_domain_list (BinFile bf, domain_list l);
void save_regexp_list (BinFile bf, regexp_list l);
void save_name_list (BinFile bf, name_list l);
void save_call_solution_list (BinFile bf, call_solution_list l);
void save_madm_list (BinFile bf, madm_list l);

/* Introduce loading of types */
void load_grammar (BinFile bf, grammar *x);
void load_prule (BinFile bf, prule *x);
void load_plhs (BinFile bf, plhs *x);
void load_rule (BinFile bf, rule *x);
void load_spec (BinFile bf, spec *x);
void load_rule_layer (BinFile bf, rule_layer *x);
void load_rule_type (BinFile bf, rule_type *x);
void load_rule_kind (BinFile bf, rule_kind *x);
void load_rdecl (BinFile bf, rdecl *x);
void load_variable (BinFile bf, variable *x);
void load_definition (BinFile bf, definition *x);
void load_fpar (BinFile bf, fpar *x);
void load_dir (BinFile bf, dir *x);
void load_group (BinFile bf, group *x);
void load_alternative (BinFile bf, alternative *x);
void load_fwo_group (BinFile bf, fwo_group *x);
void load_glue (BinFile bf, glue *x);
void load_member (BinFile bf, member *x);
void load_apar (BinFile bf, apar *x);
void load_confrontation (BinFile bf, confrontation *x);
void load_res_conf (BinFile bf, res_conf *x);
void load_guard_type (BinFile bf, guard_type *x);
void load_control_op (BinFile bf, control_op *x);
void load_affix_term (BinFile bf, affix_term *x);
void load_trans_member (BinFile bf, trans_member *x);
void load_hyb_op (BinFile bf, hyb_op *x);
void load_affix_rule (BinFile bf, affix_rule *x);
void load_affix_alternative (BinFile bf, affix_alternative *x);
void load_affix_element (BinFile bf, affix_element *x);
void load_nullability (BinFile bf, nullability *x);
void load_arule_kind (BinFile bf, arule_kind *x);
void load_invisible_nonterminal (BinFile bf, invisible_nonterminal *x);
void load_element (BinFile bf, element *x);
void load_domain (BinFile bf, domain *x);
void load_regexp (BinFile bf, regexp *x);
void load_name (BinFile bf, name *x);
void load_call_solution (BinFile bf, call_solution *x);
void load_madm (BinFile bf, madm *x);

/* Introduce loading of lists */
void load_grammar_list (BinFile bf, grammar_list *l);
void load_prule_list (BinFile bf, prule_list *l);
void load_plhs_list (BinFile bf, plhs_list *l);
void load_rule_list (BinFile bf, rule_list *l);
void load_rdecl_list (BinFile bf, rdecl_list *l);
void load_variable_list (BinFile bf, variable_list *l);
void load_definition_list (BinFile bf, definition_list *l);
void load_fpar_list (BinFile bf, fpar_list *l);
void load_dir_list (BinFile bf, dir_list *l);
void load_alternative_list (BinFile bf, alternative_list *l);
void load_fwo_group_list (BinFile bf, fwo_group_list *l);
void load_member_list (BinFile bf, member_list *l);
void load_apar_list (BinFile bf, apar_list *l);
void load_confrontation_list (BinFile bf, confrontation_list *l);
void load_res_conf_list (BinFile bf, res_conf_list *l);
void load_affix_term_list (BinFile bf, affix_term_list *l);
void load_trans_member_list (BinFile bf, trans_member_list *l);
void load_affix_rule_list (BinFile bf, affix_rule_list *l);
void load_affix_alternative_list (BinFile bf, affix_alternative_list *l);
void load_affix_element_list (BinFile bf, affix_element_list *l);
void load_invisible_nonterminal_list (BinFile bf, invisible_nonterminal_list *l);
void load_element_list (BinFile bf, element_list *l);
void load_domain_list (BinFile bf, domain_list *l);
void load_regexp_list (BinFile bf, regexp_list *l);
void load_name_list (BinFile bf, name_list *l);
void load_call_solution_list (BinFile bf, call_solution_list *l);
void load_madm_list (BinFile bf, madm_list *l);

/* Introduce recursive duplication of types */
grammar rdup_grammar (grammar old);
prule rdup_prule (prule old);
plhs rdup_plhs (plhs old);
rule rdup_rule (rule old);
spec rdup_spec (spec old);
#define rdup_rule_layer(orig) (orig)
#define rdup_rule_type(orig) (orig)
#define rdup_rule_kind(orig) (orig)
rdecl rdup_rdecl (rdecl old);
variable rdup_variable (variable old);
definition rdup_definition (definition old);
fpar rdup_fpar (fpar old);
#define rdup_dir(orig) (orig)
group rdup_group (group old);
alternative rdup_alternative (alternative old);
fwo_group rdup_fwo_group (fwo_group old);
#define rdup_glue(orig) (orig)
member rdup_member (member old);
apar rdup_apar (apar old);
confrontation rdup_confrontation (confrontation old);
res_conf rdup_res_conf (res_conf old);
#define rdup_guard_type(orig) (orig)
#define rdup_control_op(orig) (orig)
affix_term rdup_affix_term (affix_term old);
trans_member rdup_trans_member (trans_member old);
hyb_op rdup_hyb_op (hyb_op old);
affix_rule rdup_affix_rule (affix_rule old);
affix_alternative rdup_affix_alternative (affix_alternative old);
affix_element rdup_affix_element (affix_element old);
#define rdup_nullability(orig) (orig)
#define rdup_arule_kind(orig) (orig)
invisible_nonterminal rdup_invisible_nonterminal (invisible_nonterminal old);
element rdup_element (element old);
domain rdup_domain (domain old);
regexp rdup_regexp (regexp old);
name rdup_name (name old);
call_solution rdup_call_solution (call_solution old);
madm rdup_madm (madm old);

/* Introduce recursive copying of lists */
grammar_list rdup_grammar_list (grammar_list old);
prule_list rdup_prule_list (prule_list old);
plhs_list rdup_plhs_list (plhs_list old);
rule_list rdup_rule_list (rule_list old);
rdecl_list rdup_rdecl_list (rdecl_list old);
variable_list rdup_variable_list (variable_list old);
definition_list rdup_definition_list (definition_list old);
fpar_list rdup_fpar_list (fpar_list old);
dir_list rdup_dir_list (dir_list old);
alternative_list rdup_alternative_list (alternative_list old);
fwo_group_list rdup_fwo_group_list (fwo_group_list old);
member_list rdup_member_list (member_list old);
apar_list rdup_apar_list (apar_list old);
confrontation_list rdup_confrontation_list (confrontation_list old);
res_conf_list rdup_res_conf_list (res_conf_list old);
affix_term_list rdup_affix_term_list (affix_term_list old);
trans_member_list rdup_trans_member_list (trans_member_list old);
affix_rule_list rdup_affix_rule_list (affix_rule_list old);
affix_alternative_list rdup_affix_alternative_list (affix_alternative_list old);
affix_element_list rdup_affix_element_list (affix_element_list old);
invisible_nonterminal_list rdup_invisible_nonterminal_list (invisible_nonterminal_list old);
element_list rdup_element_list (element_list old);
domain_list rdup_domain_list (domain_list old);
regexp_list rdup_regexp_list (regexp_list old);
name_list rdup_name_list (name_list old);
call_solution_list rdup_call_solution_list (call_solution_list old);
madm_list rdup_madm_list (madm_list old);

/* Introduce recursive refcount checking of types */
void check_not_freed_grammar (grammar curr);
void check_not_freed_prule (prule curr);
void check_not_freed_plhs (plhs curr);
void check_not_freed_rule (rule curr);
void check_not_freed_spec (spec curr);
#define check_not_freed_rule_layer(curr)
#define check_not_freed_rule_type(curr)
#define check_not_freed_rule_kind(curr)
void check_not_freed_rdecl (rdecl curr);
void check_not_freed_variable (variable curr);
void check_not_freed_definition (definition curr);
void check_not_freed_fpar (fpar curr);
#define check_not_freed_dir(curr)
void check_not_freed_group (group curr);
void check_not_freed_alternative (alternative curr);
void check_not_freed_fwo_group (fwo_group curr);
#define check_not_freed_glue(curr)
void check_not_freed_member (member curr);
void check_not_freed_apar (apar curr);
void check_not_freed_confrontation (confrontation curr);
void check_not_freed_res_conf (res_conf curr);
#define check_not_freed_guard_type(curr)
#define check_not_freed_control_op(curr)
void check_not_freed_affix_term (affix_term curr);
void check_not_freed_trans_member (trans_member curr);
void check_not_freed_hyb_op (hyb_op curr);
void check_not_freed_affix_rule (affix_rule curr);
void check_not_freed_affix_alternative (affix_alternative curr);
void check_not_freed_affix_element (affix_element curr);
#define check_not_freed_nullability(curr)
#define check_not_freed_arule_kind(curr)
void check_not_freed_invisible_nonterminal (invisible_nonterminal curr);
void check_not_freed_element (element curr);
void check_not_freed_domain (domain curr);
void check_not_freed_regexp (regexp curr);
void check_not_freed_name (name curr);
void check_not_freed_call_solution (call_solution curr);
void check_not_freed_madm (madm curr);

/* Introduce recursive refcount checking of lists */
void check_not_freed_grammar_list (grammar_list curr);
void check_not_freed_prule_list (prule_list curr);
void check_not_freed_plhs_list (plhs_list curr);
void check_not_freed_rule_list (rule_list curr);
void check_not_freed_rdecl_list (rdecl_list curr);
void check_not_freed_variable_list (variable_list curr);
void check_not_freed_definition_list (definition_list curr);
void check_not_freed_fpar_list (fpar_list curr);
void check_not_freed_dir_list (dir_list curr);
void check_not_freed_alternative_list (alternative_list curr);
void check_not_freed_fwo_group_list (fwo_group_list curr);
void check_not_freed_member_list (member_list curr);
void check_not_freed_apar_list (apar_list curr);
void check_not_freed_confrontation_list (confrontation_list curr);
void check_not_freed_res_conf_list (res_conf_list curr);
void check_not_freed_affix_term_list (affix_term_list curr);
void check_not_freed_trans_member_list (trans_member_list curr);
void check_not_freed_affix_rule_list (affix_rule_list curr);
void check_not_freed_affix_alternative_list (affix_alternative_list curr);
void check_not_freed_affix_element_list (affix_element_list curr);
void check_not_freed_invisible_nonterminal_list (invisible_nonterminal_list curr);
void check_not_freed_element_list (element_list curr);
void check_not_freed_domain_list (domain_list curr);
void check_not_freed_regexp_list (regexp_list curr);
void check_not_freed_name_list (name_list curr);
void check_not_freed_call_solution_list (call_solution_list curr);
void check_not_freed_madm_list (madm_list curr);

#endif /* IncEag_ds */
