/*
   File: eag_ds.c
   Generated on Sat Apr 13 13:25:13 2013
*/

/* standard includes */
#include <stdio.h>

/* support lib includes */
#include <dcg.h>
#include <dcg_error.h>
#include <dcg_alloc.h>
#include <dcg_string.h>
#include <dcg_dump.h>
#include <dcg_binfile.h>

/* local includes */
#include "eag_ds.h"

/* Allocate new grammar_list */
grammar_list init_grammar_list (int room)
{ grammar_list new = (grammar_list) dcg_malloc (sizeof (struct str_grammar_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (grammar *) dcg_calloc (safe_room, sizeof (grammar));
  return (new);
}

/* Allocate new prule_list */
prule_list init_prule_list (int room)
{ prule_list new = (prule_list) dcg_malloc (sizeof (struct str_prule_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (prule *) dcg_calloc (safe_room, sizeof (prule));
  return (new);
}

/* Allocate new plhs_list */
plhs_list init_plhs_list (int room)
{ plhs_list new = (plhs_list) dcg_malloc (sizeof (struct str_plhs_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (plhs *) dcg_calloc (safe_room, sizeof (plhs));
  return (new);
}

/* Allocate new rule_list */
rule_list init_rule_list (int room)
{ rule_list new = (rule_list) dcg_malloc (sizeof (struct str_rule_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (rule *) dcg_calloc (safe_room, sizeof (rule));
  return (new);
}

/* Allocate new rdecl_list */
rdecl_list init_rdecl_list (int room)
{ rdecl_list new = (rdecl_list) dcg_malloc (sizeof (struct str_rdecl_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (rdecl *) dcg_calloc (safe_room, sizeof (rdecl));
  return (new);
}

/* Allocate new variable_list */
variable_list init_variable_list (int room)
{ variable_list new = (variable_list) dcg_malloc (sizeof (struct str_variable_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (variable *) dcg_calloc (safe_room, sizeof (variable));
  return (new);
}

/* Allocate new definition_list */
definition_list init_definition_list (int room)
{ definition_list new = (definition_list) dcg_malloc (sizeof (struct str_definition_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (definition *) dcg_calloc (safe_room, sizeof (definition));
  return (new);
}

/* Allocate new fpar_list */
fpar_list init_fpar_list (int room)
{ fpar_list new = (fpar_list) dcg_malloc (sizeof (struct str_fpar_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (fpar *) dcg_calloc (safe_room, sizeof (fpar));
  return (new);
}

/* Allocate new dir_list */
dir_list init_dir_list (int room)
{ dir_list new = (dir_list) dcg_malloc (sizeof (struct str_dir_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (dir *) dcg_calloc (safe_room, sizeof (dir));
  return (new);
}

/* Allocate new alternative_list */
alternative_list init_alternative_list (int room)
{ alternative_list new = (alternative_list) dcg_malloc (sizeof (struct str_alternative_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (alternative *) dcg_calloc (safe_room, sizeof (alternative));
  return (new);
}

/* Allocate new fwo_group_list */
fwo_group_list init_fwo_group_list (int room)
{ fwo_group_list new = (fwo_group_list) dcg_malloc (sizeof (struct str_fwo_group_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (fwo_group *) dcg_calloc (safe_room, sizeof (fwo_group));
  return (new);
}

/* Allocate new member_list */
member_list init_member_list (int room)
{ member_list new = (member_list) dcg_malloc (sizeof (struct str_member_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (member *) dcg_calloc (safe_room, sizeof (member));
  return (new);
}

/* Allocate new apar_list */
apar_list init_apar_list (int room)
{ apar_list new = (apar_list) dcg_malloc (sizeof (struct str_apar_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (apar *) dcg_calloc (safe_room, sizeof (apar));
  return (new);
}

/* Allocate new confrontation_list */
confrontation_list init_confrontation_list (int room)
{ confrontation_list new = (confrontation_list) dcg_malloc (sizeof (struct str_confrontation_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (confrontation *) dcg_calloc (safe_room, sizeof (confrontation));
  return (new);
}

/* Allocate new res_conf_list */
res_conf_list init_res_conf_list (int room)
{ res_conf_list new = (res_conf_list) dcg_malloc (sizeof (struct str_res_conf_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (res_conf *) dcg_calloc (safe_room, sizeof (res_conf));
  return (new);
}

/* Allocate new affix_term_list */
affix_term_list init_affix_term_list (int room)
{ affix_term_list new = (affix_term_list) dcg_malloc (sizeof (struct str_affix_term_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (affix_term *) dcg_calloc (safe_room, sizeof (affix_term));
  return (new);
}

/* Allocate new trans_member_list */
trans_member_list init_trans_member_list (int room)
{ trans_member_list new = (trans_member_list) dcg_malloc (sizeof (struct str_trans_member_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (trans_member *) dcg_calloc (safe_room, sizeof (trans_member));
  return (new);
}

/* Allocate new affix_rule_list */
affix_rule_list init_affix_rule_list (int room)
{ affix_rule_list new = (affix_rule_list) dcg_malloc (sizeof (struct str_affix_rule_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (affix_rule *) dcg_calloc (safe_room, sizeof (affix_rule));
  return (new);
}

/* Allocate new affix_alternative_list */
affix_alternative_list init_affix_alternative_list (int room)
{ affix_alternative_list new = (affix_alternative_list) dcg_malloc (sizeof (struct str_affix_alternative_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (affix_alternative *) dcg_calloc (safe_room, sizeof (affix_alternative));
  return (new);
}

/* Allocate new affix_element_list */
affix_element_list init_affix_element_list (int room)
{ affix_element_list new = (affix_element_list) dcg_malloc (sizeof (struct str_affix_element_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (affix_element *) dcg_calloc (safe_room, sizeof (affix_element));
  return (new);
}

/* Allocate new invisible_nonterminal_list */
invisible_nonterminal_list init_invisible_nonterminal_list (int room)
{ invisible_nonterminal_list new = (invisible_nonterminal_list) dcg_malloc (sizeof (struct str_invisible_nonterminal_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (invisible_nonterminal *) dcg_calloc (safe_room, sizeof (invisible_nonterminal));
  return (new);
}

/* Allocate new element_list */
element_list init_element_list (int room)
{ element_list new = (element_list) dcg_malloc (sizeof (struct str_element_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (element *) dcg_calloc (safe_room, sizeof (element));
  return (new);
}

/* Allocate new domain_list */
domain_list init_domain_list (int room)
{ domain_list new = (domain_list) dcg_malloc (sizeof (struct str_domain_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (domain *) dcg_calloc (safe_room, sizeof (domain));
  return (new);
}

/* Allocate new regexp_list */
regexp_list init_regexp_list (int room)
{ regexp_list new = (regexp_list) dcg_malloc (sizeof (struct str_regexp_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (regexp *) dcg_calloc (safe_room, sizeof (regexp));
  return (new);
}

/* Allocate new name_list */
name_list init_name_list (int room)
{ name_list new = (name_list) dcg_malloc (sizeof (struct str_name_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (name *) dcg_calloc (safe_room, sizeof (name));
  return (new);
}

/* Allocate new call_solution_list */
call_solution_list init_call_solution_list (int room)
{ call_solution_list new = (call_solution_list) dcg_malloc (sizeof (struct str_call_solution_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (call_solution *) dcg_calloc (safe_room, sizeof (call_solution));
  return (new);
}

/* Allocate new madm_list */
madm_list init_madm_list (int room)
{ madm_list new = (madm_list) dcg_malloc (sizeof (struct str_madm_list));
  int safe_room = (room < 2)?2:room;
  new -> size = 0;
  new -> room = safe_room;
  new -> array = (madm *) dcg_calloc (safe_room, sizeof (madm));
  return (new);
}

/* Announce to use 'room' chunks for grammar_list */
void room_grammar_list (grammar_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (grammar));
  l -> room = room;
}

/* Announce to use 'room' chunks for prule_list */
void room_prule_list (prule_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (prule));
  l -> room = room;
}

/* Announce to use 'room' chunks for plhs_list */
void room_plhs_list (plhs_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (plhs));
  l -> room = room;
}

/* Announce to use 'room' chunks for rule_list */
void room_rule_list (rule_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (rule));
  l -> room = room;
}

/* Announce to use 'room' chunks for rdecl_list */
void room_rdecl_list (rdecl_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (rdecl));
  l -> room = room;
}

/* Announce to use 'room' chunks for variable_list */
void room_variable_list (variable_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (variable));
  l -> room = room;
}

/* Announce to use 'room' chunks for definition_list */
void room_definition_list (definition_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (definition));
  l -> room = room;
}

/* Announce to use 'room' chunks for fpar_list */
void room_fpar_list (fpar_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (fpar));
  l -> room = room;
}

/* Announce to use 'room' chunks for dir_list */
void room_dir_list (dir_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (dir));
  l -> room = room;
}

/* Announce to use 'room' chunks for alternative_list */
void room_alternative_list (alternative_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (alternative));
  l -> room = room;
}

/* Announce to use 'room' chunks for fwo_group_list */
void room_fwo_group_list (fwo_group_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (fwo_group));
  l -> room = room;
}

/* Announce to use 'room' chunks for member_list */
void room_member_list (member_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (member));
  l -> room = room;
}

/* Announce to use 'room' chunks for apar_list */
void room_apar_list (apar_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (apar));
  l -> room = room;
}

/* Announce to use 'room' chunks for confrontation_list */
void room_confrontation_list (confrontation_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (confrontation));
  l -> room = room;
}

/* Announce to use 'room' chunks for res_conf_list */
void room_res_conf_list (res_conf_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (res_conf));
  l -> room = room;
}

/* Announce to use 'room' chunks for affix_term_list */
void room_affix_term_list (affix_term_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (affix_term));
  l -> room = room;
}

/* Announce to use 'room' chunks for trans_member_list */
void room_trans_member_list (trans_member_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (trans_member));
  l -> room = room;
}

/* Announce to use 'room' chunks for affix_rule_list */
void room_affix_rule_list (affix_rule_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (affix_rule));
  l -> room = room;
}

/* Announce to use 'room' chunks for affix_alternative_list */
void room_affix_alternative_list (affix_alternative_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (affix_alternative));
  l -> room = room;
}

/* Announce to use 'room' chunks for affix_element_list */
void room_affix_element_list (affix_element_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (affix_element));
  l -> room = room;
}

/* Announce to use 'room' chunks for invisible_nonterminal_list */
void room_invisible_nonterminal_list (invisible_nonterminal_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (invisible_nonterminal));
  l -> room = room;
}

/* Announce to use 'room' chunks for element_list */
void room_element_list (element_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (element));
  l -> room = room;
}

/* Announce to use 'room' chunks for domain_list */
void room_domain_list (domain_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (domain));
  l -> room = room;
}

/* Announce to use 'room' chunks for regexp_list */
void room_regexp_list (regexp_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (regexp));
  l -> room = room;
}

/* Announce to use 'room' chunks for name_list */
void room_name_list (name_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (name));
  l -> room = room;
}

/* Announce to use 'room' chunks for call_solution_list */
void room_call_solution_list (call_solution_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (call_solution));
  l -> room = room;
}

/* Announce to use 'room' chunks for madm_list */
void room_madm_list (madm_list l, int room)
{ if (room <= l -> room) return;
  dcg_recalloc ((void **) &l -> array, room, sizeof (madm));
  l -> room = room;
}

/* Allocate new grammar record */
grammar new_grammar (string fname, string gname, string_list uses, string_list lexica, string_list fact_tables, string_list triple_databases, prule_list exp_prules, prule_list prules, affix_rule_list arules, member root_call)
{ grammar new = (grammar) dcg_malloc (sizeof (struct str_grammar));
  new -> fname = fname;
  new -> gname = gname;
  new -> uses = uses;
  new -> lexica = lexica;
  new -> fact_tables = fact_tables;
  new -> triple_databases = triple_databases;
  new -> exp_prules = exp_prules;
  new -> prules = prules;
  new -> arules = arules;
  new -> root_call = root_call;
  new -> gnr = int_nil;
  return (new);
};

/* Allocate new prule record for constructor Ext_prule */
prule new_Ext_prule (plhs lhs,
		string ename)
{ prule new = (prule) dcg_malloc (sizeof (struct str_prule));
  new -> gnr = int_nil;
  new -> drule = rule_nil;
  new -> lhs = lhs;
  new -> tag = TAGExt_prule;
  new -> Ext_prule.ename = ename;
  return (new);
}

/* Allocate new prule record for constructor Quasi_prule */
prule new_Quasi_prule (plhs lhs,
		string rname)
{ prule new = (prule) dcg_malloc (sizeof (struct str_prule));
  new -> gnr = int_nil;
  new -> drule = rule_nil;
  new -> lhs = lhs;
  new -> tag = TAGQuasi_prule;
  new -> Quasi_prule.rname = rname;
  return (new);
}

/* Allocate new prule record for constructor Proto_rule */
prule new_Proto_rule (plhs lhs,
		group grp)
{ prule new = (prule) dcg_malloc (sizeof (struct str_prule));
  new -> gnr = int_nil;
  new -> drule = rule_nil;
  new -> lhs = lhs;
  new -> tag = TAGProto_rule;
  new -> Proto_rule.grp = grp;
  return (new);
}

/* Allocate new prule record for constructor Pspec */
prule new_Pspec (plhs lhs)
{ prule new = (prule) dcg_malloc (sizeof (struct str_prule));
  new -> gnr = int_nil;
  new -> drule = rule_nil;
  new -> lhs = lhs;
  new -> tag = TAGPspec;
  return (new);
}

/* Allocate new prule record for constructor Pstart */
prule new_Pstart (plhs lhs)
{ prule new = (prule) dcg_malloc (sizeof (struct str_prule));
  new -> gnr = int_nil;
  new -> drule = rule_nil;
  new -> lhs = lhs;
  new -> tag = TAGPstart;
  return (new);
}

/* Allocate new plhs record */
plhs new_plhs (int line, int col, rule_layer rlayer, rule_kind rkind, rule_type rtype, string_list rname_parts, int_list rname_chars, fpar_list lhs_pars)
{ plhs new = (plhs) dcg_malloc (sizeof (struct str_plhs));
  new -> line = line;
  new -> col = col;
  new -> rlayer = rlayer;
  new -> rkind = rkind;
  new -> rtype = rtype;
  new -> rname_parts = rname_parts;
  new -> rname_chars = rname_chars;
  new -> lhs_pars = lhs_pars;
  return (new);
};

/* Allocate new rule record for constructor Ext_rule */
rule new_Ext_rule (spec rspec,
		string ename)
{ rule new = (rule) dcg_malloc (sizeof (struct str_rule));
  new -> rnr = int_nil;
  new -> empty = nullability_nil;
  new -> npred = int_nil;
  new -> reachable = int_nil;
  new -> codable = int_nil;
  new -> first = trans_pair_list_nil;
  new -> follow = trans_pair_list_nil;
  new -> goalnr = int_nil;
  new -> rspec = rspec;
  new -> tag = TAGExt_rule;
  new -> Ext_rule.ename = ename;
  return (new);
}

/* Allocate new rule record for constructor Quasi_rule */
rule new_Quasi_rule (spec rspec,
		string rname)
{ rule new = (rule) dcg_malloc (sizeof (struct str_rule));
  new -> rnr = int_nil;
  new -> empty = nullability_nil;
  new -> npred = int_nil;
  new -> reachable = int_nil;
  new -> codable = int_nil;
  new -> first = trans_pair_list_nil;
  new -> follow = trans_pair_list_nil;
  new -> goalnr = int_nil;
  new -> rspec = rspec;
  new -> tag = TAGQuasi_rule;
  new -> Quasi_rule.rname = rname;
  return (new);
}

/* Allocate new rule record for constructor Defs */
rule new_Defs (spec rspec,
		definition_list defs)
{ rule new = (rule) dcg_malloc (sizeof (struct str_rule));
  new -> rnr = int_nil;
  new -> empty = nullability_nil;
  new -> npred = int_nil;
  new -> reachable = int_nil;
  new -> codable = int_nil;
  new -> first = trans_pair_list_nil;
  new -> follow = trans_pair_list_nil;
  new -> goalnr = int_nil;
  new -> rspec = rspec;
  new -> tag = TAGDefs;
  new -> Defs.defs = defs;
  return (new);
}

/* Allocate new rule record for constructor Anonymous_option */
rule new_Anonymous_option (spec rspec,
		group grp)
{ rule new = (rule) dcg_malloc (sizeof (struct str_rule));
  new -> rnr = int_nil;
  new -> empty = nullability_nil;
  new -> npred = int_nil;
  new -> reachable = int_nil;
  new -> codable = int_nil;
  new -> first = trans_pair_list_nil;
  new -> follow = trans_pair_list_nil;
  new -> goalnr = int_nil;
  new -> rspec = rspec;
  new -> tag = TAGAnonymous_option;
  new -> Anonymous_option.grp = grp;
  new -> Anonymous_option.anc_spec = spec_nil;
  new -> Anonymous_option.def = definition_nil;
  new -> Anonymous_option.call = member_nil;
  return (new);
}

/* Allocate new rule record for constructor Anonymous_group */
rule new_Anonymous_group (spec rspec,
		group grp)
{ rule new = (rule) dcg_malloc (sizeof (struct str_rule));
  new -> rnr = int_nil;
  new -> empty = nullability_nil;
  new -> npred = int_nil;
  new -> reachable = int_nil;
  new -> codable = int_nil;
  new -> first = trans_pair_list_nil;
  new -> follow = trans_pair_list_nil;
  new -> goalnr = int_nil;
  new -> rspec = rspec;
  new -> tag = TAGAnonymous_group;
  new -> Anonymous_group.grp = grp;
  new -> Anonymous_group.anc_spec = spec_nil;
  new -> Anonymous_group.def = definition_nil;
  new -> Anonymous_group.call = member_nil;
  return (new);
}

/* Allocate new spec record */
spec new_spec (rule_layer rlayer, rule_kind rkind, rule_type rtype, string_list rname_parts, int_list rname_chars, affix_rule_list rsig, dir_list dirs)
{ spec new = (spec) dcg_malloc (sizeof (struct str_spec));
  new -> rlayer = rlayer;
  new -> rkind = rkind;
  new -> rtype = rtype;
  new -> rname_parts = rname_parts;
  new -> rname_chars = rname_chars;
  new -> rsig = rsig;
  new -> dirs = dirs;
  new -> concat_name = string_nil;
  new -> canonic_name = string_nil;
  new -> drule = rule_nil;
  new -> pr = prule_nil;
  new -> lnr = int_nil;
  return (new);
};

/* Allocate new rdecl record */
rdecl new_rdecl ()
{ rdecl new = (rdecl) dcg_malloc (sizeof (struct str_rdecl));
  new -> rsig = affix_rule_list_nil;
  new -> rdef = rule_nil;
  return (new);
};

/* Allocate new variable record */
variable new_variable (string vname)
{ variable new = (variable) dcg_malloc (sizeof (struct str_variable));
  new -> vname = vname;
  new -> vnr = int_nil;
  new -> adef = affix_rule_nil;
  new -> cnr = int_nil;
  return (new);
};

/* Allocate new definition record */
definition new_definition (fpar_list lhs_pars, variable_list locals, group grp)
{ definition new = (definition) dcg_malloc (sizeof (struct str_definition));
  new -> lhs_pars = lhs_pars;
  new -> locals = locals;
  new -> grp = grp;
  new -> pr = prule_nil;
  return (new);
};

/* Allocate new fpar record */
fpar new_fpar (int line, int col, dir fdir, affix_term_list fexp)
{ fpar new = (fpar) dcg_malloc (sizeof (struct str_fpar));
  new -> line = line;
  new -> col = col;
  new -> fdir = fdir;
  new -> fexp = fexp;
  new -> adef = affix_rule_nil;
  new -> err = int_nil;
  return (new);
};

/* Allocate new group record */
group new_group (alternative_list alts)
{ group new = (group) dcg_malloc (sizeof (struct str_group));
  new -> alts = alts;
  return (new);
};

/* Allocate new alternative record */
alternative new_alternative (int line, int col, real freq, fwo_group_list members, int commited, trans_member_list trans)
{ alternative new = (alternative) dcg_malloc (sizeof (struct str_alternative));
  new -> line = line;
  new -> col = col;
  new -> freq = freq;
  new -> members = members;
  new -> commited = commited;
  new -> trans = trans;
  new -> empty = int_nil;
  new -> first = trans_pair_list_nil;
  return (new);
};

/* Allocate new fwo_group record for constructor Single */
fwo_group new_Single (glue gl,
		member mem)
{ fwo_group new = (fwo_group) dcg_malloc (sizeof (struct str_fwo_group));
  new -> gl = gl;
  new -> empty = int_nil;
  new -> tag = TAGSingle;
  new -> Single.mem = mem;
  return (new);
}

/* Allocate new fwo_group record for constructor Fwo */
fwo_group new_Fwo (glue gl,
		member_list mems)
{ fwo_group new = (fwo_group) dcg_malloc (sizeof (struct str_fwo_group));
  new -> gl = gl;
  new -> empty = int_nil;
  new -> tag = TAGFwo;
  new -> Fwo.mems = mems;
  return (new);
}

/* Allocate new member record for constructor Call */
member new_Call (int line, int col,
		string_list rname_parts, int_list rname_chars, apar_list apars)
{ member new = (member) dcg_malloc (sizeof (struct str_member));
  new -> line = line;
  new -> col = col;
  new -> empty = nullability_nil;
  new -> first = trans_pair_nil;
  new -> tag = TAGCall;
  new -> Call.rname_parts = rname_parts;
  new -> Call.rname_chars = rname_chars;
  new -> Call.apars = apars;
  return (new);
}

/* Allocate new member record for constructor Guard */
member new_Guard (int line, int col,
		confrontation_list confs)
{ member new = (member) dcg_malloc (sizeof (struct str_member));
  new -> line = line;
  new -> col = col;
  new -> empty = nullability_nil;
  new -> first = trans_pair_nil;
  new -> tag = TAGGuard;
  new -> Guard.confs = confs;
  return (new);
}

/* Allocate new member record for constructor Term */
member new_Term (int line, int col,
		string text, apar par)
{ member new = (member) dcg_malloc (sizeof (struct str_member));
  new -> line = line;
  new -> col = col;
  new -> empty = nullability_nil;
  new -> first = trans_pair_nil;
  new -> tag = TAGTerm;
  new -> Term.text = text;
  new -> Term.par = par;
  return (new);
}

/* Allocate new member record for constructor Quasi */
member new_Quasi (int line, int col,
		string_list qname_parts, int_list qname_chars, apar_list args)
{ member new = (member) dcg_malloc (sizeof (struct str_member));
  new -> line = line;
  new -> col = col;
  new -> empty = nullability_nil;
  new -> first = trans_pair_nil;
  new -> tag = TAGQuasi;
  new -> Quasi.qname_parts = qname_parts;
  new -> Quasi.qname_chars = qname_chars;
  new -> Quasi.args = args;
  return (new);
}

/* Allocate new member record for constructor Op */
member new_Op (int line, int col,
		control_op op)
{ member new = (member) dcg_malloc (sizeof (struct str_member));
  new -> line = line;
  new -> col = col;
  new -> empty = nullability_nil;
  new -> first = trans_pair_nil;
  new -> tag = TAGOp;
  new -> Op.op = op;
  new -> Op.gnr = int_nil;
  return (new);
}

/* Allocate new member record for constructor Group */
member new_Group (int line, int col,
		group grp)
{ member new = (member) dcg_malloc (sizeof (struct str_member));
  new -> line = line;
  new -> col = col;
  new -> empty = nullability_nil;
  new -> first = trans_pair_nil;
  new -> tag = TAGGroup;
  new -> Group.grp = grp;
  return (new);
}

/* Allocate new member record for constructor Option */
member new_Option (int line, int col,
		group grp)
{ member new = (member) dcg_malloc (sizeof (struct str_member));
  new -> line = line;
  new -> col = col;
  new -> empty = nullability_nil;
  new -> first = trans_pair_nil;
  new -> tag = TAGOption;
  new -> Option.grp = grp;
  return (new);
}

/* Allocate new member record for constructor Res_guard */
member new_Res_guard (int line, int col,
		res_conf_list rconfs)
{ member new = (member) dcg_malloc (sizeof (struct str_member));
  new -> line = line;
  new -> col = col;
  new -> empty = nullability_nil;
  new -> first = trans_pair_nil;
  new -> tag = TAGRes_guard;
  new -> Res_guard.rconfs = rconfs;
  return (new);
}

/* Allocate new member record for constructor Res_call */
member new_Res_call (int line, int col,
		affix_term_list args, dir_list adirs)
{ member new = (member) dcg_malloc (sizeof (struct str_member));
  new -> line = line;
  new -> col = col;
  new -> empty = nullability_nil;
  new -> first = trans_pair_nil;
  new -> tag = TAGRes_call;
  new -> Res_call.rdef = rule_nil;
  new -> Res_call.args = args;
  new -> Res_call.adirs = adirs;
  return (new);
}

/* Allocate new member record for constructor Res_term */
member new_Res_term (int line, int col,
		string text, dir adir, affix_term arg)
{ member new = (member) dcg_malloc (sizeof (struct str_member));
  new -> line = line;
  new -> col = col;
  new -> empty = nullability_nil;
  new -> first = trans_pair_nil;
  new -> tag = TAGRes_term;
  new -> Res_term.text = text;
  new -> Res_term.termnr = int_nil;
  new -> Res_term.is_regexp = int_nil;
  new -> Res_term.adir = adir;
  new -> Res_term.arg = arg;
  return (new);
}

/* Allocate new apar record */
apar new_apar (dir adir, affix_term_list aexp)
{ apar new = (apar) dcg_malloc (sizeof (struct str_apar));
  new -> adir = adir;
  new -> aexp = aexp;
  new -> adef = affix_rule_nil;
  return (new);
};

/* Allocate new confrontation record */
confrontation new_confrontation (int line, int col, guard_type typ, affix_term_list lhs, affix_term_list rhs)
{ confrontation new = (confrontation) dcg_malloc (sizeof (struct str_confrontation));
  new -> line = line;
  new -> col = col;
  new -> typ = typ;
  new -> lhs = lhs;
  new -> rhs = rhs;
  return (new);
};

/* Allocate new res_conf record */
res_conf new_res_conf (guard_type typ, affix_term lhs, affix_term rhs)
{ res_conf new = (res_conf) dcg_malloc (sizeof (struct str_res_conf));
  new -> typ = typ;
  new -> lhs = lhs;
  new -> rhs = rhs;
  return (new);
};

/* Allocate new affix_term record for constructor Terminal */
affix_term new_Terminal (int line, int col,
		string marker)
{ affix_term new = (affix_term) dcg_malloc (sizeof (struct str_affix_term));
  new -> line = line;
  new -> col = col;
  new -> adef = affix_rule_nil;
  new -> value = affix_value_nil;
  new -> tag = TAGTerminal;
  new -> Terminal.marker = marker;
  new -> Terminal.edef = element_nil;
  return (new);
}

/* Allocate new affix_term record for constructor Dyop */
affix_term new_Dyop (int line, int col,
		operator dop, affix_term arg1, affix_term arg2)
{ affix_term new = (affix_term) dcg_malloc (sizeof (struct str_affix_term));
  new -> line = line;
  new -> col = col;
  new -> adef = affix_rule_nil;
  new -> value = affix_value_nil;
  new -> tag = TAGDyop;
  new -> Dyop.dop = dop;
  new -> Dyop.arg1 = arg1;
  new -> Dyop.arg2 = arg2;
  return (new);
}

/* Allocate new affix_term record for constructor Monop */
affix_term new_Monop (int line, int col,
		operator mop, affix_term arg)
{ affix_term new = (affix_term) dcg_malloc (sizeof (struct str_affix_term));
  new -> line = line;
  new -> col = col;
  new -> adef = affix_rule_nil;
  new -> value = affix_value_nil;
  new -> tag = TAGMonop;
  new -> Monop.mop = mop;
  new -> Monop.arg = arg;
  return (new);
}

/* Allocate new affix_term record for constructor Enclosed */
affix_term new_Enclosed (int line, int col,
		affix_term_list terms)
{ affix_term new = (affix_term) dcg_malloc (sizeof (struct str_affix_term));
  new -> line = line;
  new -> col = col;
  new -> adef = affix_rule_nil;
  new -> value = affix_value_nil;
  new -> tag = TAGEnclosed;
  new -> Enclosed.terms = terms;
  return (new);
}

/* Allocate new affix_term record for constructor Ast */
affix_term new_Ast (int line, int col,
		affix_term_list terms, int altnr)
{ affix_term new = (affix_term) dcg_malloc (sizeof (struct str_affix_term));
  new -> line = line;
  new -> col = col;
  new -> adef = affix_rule_nil;
  new -> value = affix_value_nil;
  new -> tag = TAGAst;
  new -> Ast.terms = terms;
  new -> Ast.altnr = altnr;
  return (new);
}

/* Allocate new affix_term record for constructor Concat */
affix_term new_Concat (int line, int col,
		affix_term_list terms)
{ affix_term new = (affix_term) dcg_malloc (sizeof (struct str_affix_term));
  new -> line = line;
  new -> col = col;
  new -> adef = affix_rule_nil;
  new -> value = affix_value_nil;
  new -> tag = TAGConcat;
  new -> Concat.terms = terms;
  return (new);
}

/* Allocate new affix_term record for constructor Int */
affix_term new_Int (int line, int col,
		int num)
{ affix_term new = (affix_term) dcg_malloc (sizeof (struct str_affix_term));
  new -> line = line;
  new -> col = col;
  new -> adef = affix_rule_nil;
  new -> value = affix_value_nil;
  new -> tag = TAGInt;
  new -> Int.num = num;
  return (new);
}

/* Allocate new affix_term record for constructor Real */
affix_term new_Real (int line, int col,
		real num)
{ affix_term new = (affix_term) dcg_malloc (sizeof (struct str_affix_term));
  new -> line = line;
  new -> col = col;
  new -> adef = affix_rule_nil;
  new -> value = affix_value_nil;
  new -> tag = TAGReal;
  new -> Real.num = num;
  return (new);
}

/* Allocate new affix_term record for constructor Text */
affix_term new_Text (int line, int col,
		string txt)
{ affix_term new = (affix_term) dcg_malloc (sizeof (struct str_affix_term));
  new -> line = line;
  new -> col = col;
  new -> adef = affix_rule_nil;
  new -> value = affix_value_nil;
  new -> tag = TAGText;
  new -> Text.txt = txt;
  return (new);
}

/* Allocate new affix_term record for constructor Regexp */
affix_term new_Regexp (int line, int col,
		string text)
{ affix_term new = (affix_term) dcg_malloc (sizeof (struct str_affix_term));
  new -> line = line;
  new -> col = col;
  new -> adef = affix_rule_nil;
  new -> value = affix_value_nil;
  new -> tag = TAGRegexp;
  new -> Regexp.text = text;
  new -> Regexp.termnr = int_nil;
  return (new);
}

/* Allocate new affix_term record for constructor Var */
affix_term new_Var (int line, int col,
		string aname)
{ affix_term new = (affix_term) dcg_malloc (sizeof (struct str_affix_term));
  new -> line = line;
  new -> col = col;
  new -> adef = affix_rule_nil;
  new -> value = affix_value_nil;
  new -> tag = TAGVar;
  new -> Var.aname = aname;
  new -> Var.vdef = variable_nil;
  return (new);
}

/* Allocate new trans_member record for constructor Tcall */
trans_member new_Tcall (int line, int col, glue gl,
		string_list cname, int nr)
{ trans_member new = (trans_member) dcg_malloc (sizeof (struct str_trans_member));
  new -> line = line;
  new -> col = col;
  new -> gl = gl;
  new -> tag = TAGTcall;
  new -> Tcall.cname = cname;
  new -> Tcall.nr = nr;
  new -> Tcall.cdef = member_nil;
  return (new);
}

/* Allocate new trans_member record for constructor Tquasi */
trans_member new_Tquasi (int line, int col, glue gl,
		string qname, int nr)
{ trans_member new = (trans_member) dcg_malloc (sizeof (struct str_trans_member));
  new -> line = line;
  new -> col = col;
  new -> gl = gl;
  new -> tag = TAGTquasi;
  new -> Tquasi.qname = qname;
  new -> Tquasi.nr = nr;
  new -> Tquasi.qdef = member_nil;
  return (new);
}

/* Allocate new trans_member record for constructor Tgroup */
trans_member new_Tgroup (int line, int col, glue gl,
		int nr)
{ trans_member new = (trans_member) dcg_malloc (sizeof (struct str_trans_member));
  new -> line = line;
  new -> col = col;
  new -> gl = gl;
  new -> tag = TAGTgroup;
  new -> Tgroup.nr = nr;
  new -> Tgroup.gdef = member_nil;
  return (new);
}

/* Allocate new trans_member record for constructor Toption */
trans_member new_Toption (int line, int col, glue gl,
		int nr)
{ trans_member new = (trans_member) dcg_malloc (sizeof (struct str_trans_member));
  new -> line = line;
  new -> col = col;
  new -> gl = gl;
  new -> tag = TAGToption;
  new -> Toption.nr = nr;
  new -> Toption.odef = member_nil;
  return (new);
}

/* Allocate new trans_member record for constructor Ttext */
trans_member new_Ttext (int line, int col, glue gl,
		string text)
{ trans_member new = (trans_member) dcg_malloc (sizeof (struct str_trans_member));
  new -> line = line;
  new -> col = col;
  new -> gl = gl;
  new -> tag = TAGTtext;
  new -> Ttext.text = text;
  return (new);
}

/* Allocate new trans_member record for constructor Tvar */
trans_member new_Tvar (int line, int col, glue gl,
		string aname)
{ trans_member new = (trans_member) dcg_malloc (sizeof (struct str_trans_member));
  new -> line = line;
  new -> col = col;
  new -> gl = gl;
  new -> tag = TAGTvar;
  new -> Tvar.aname = aname;
  new -> Tvar.vdef = variable_nil;
  return (new);
}

/* Allocate new trans_member record for constructor Thybrid */
trans_member new_Thybrid (int line, int col, glue gl,
		hyb_op op)
{ trans_member new = (trans_member) dcg_malloc (sizeof (struct str_trans_member));
  new -> line = line;
  new -> col = col;
  new -> gl = gl;
  new -> tag = TAGThybrid;
  new -> Thybrid.op = op;
  return (new);
}

/* Allocate new hyb_op record for constructor Hyb_sqr_open */
hyb_op new_Hyb_sqr_open ()
{ hyb_op new = (hyb_op) dcg_malloc (sizeof (struct str_hyb_op));
  new -> tag = TAGHyb_sqr_open;
  return (new);
}

/* Allocate new hyb_op record for constructor Hyb_sqr_close */
hyb_op new_Hyb_sqr_close ()
{ hyb_op new = (hyb_op) dcg_malloc (sizeof (struct str_hyb_op));
  new -> tag = TAGHyb_sqr_close;
  return (new);
}

/* Allocate new hyb_op record for constructor Hyb_curl_open */
hyb_op new_Hyb_curl_open ()
{ hyb_op new = (hyb_op) dcg_malloc (sizeof (struct str_hyb_op));
  new -> tag = TAGHyb_curl_open;
  return (new);
}

/* Allocate new hyb_op record for constructor Hyb_curl_close */
hyb_op new_Hyb_curl_close ()
{ hyb_op new = (hyb_op) dcg_malloc (sizeof (struct str_hyb_op));
  new -> tag = TAGHyb_curl_close;
  return (new);
}

/* Allocate new hyb_op record for constructor Hyb_bar */
hyb_op new_Hyb_bar ()
{ hyb_op new = (hyb_op) dcg_malloc (sizeof (struct str_hyb_op));
  new -> tag = TAGHyb_bar;
  return (new);
}

/* Allocate new hyb_op record for constructor Hyb_rel_left */
hyb_op new_Hyb_rel_left (string rname)
{ hyb_op new = (hyb_op) dcg_malloc (sizeof (struct str_hyb_op));
  new -> tag = TAGHyb_rel_left;
  new -> Hyb_rel_left.rname = rname;
  return (new);
}

/* Allocate new hyb_op record for constructor Hyb_rel_right */
hyb_op new_Hyb_rel_right (string rname)
{ hyb_op new = (hyb_op) dcg_malloc (sizeof (struct str_hyb_op));
  new -> tag = TAGHyb_rel_right;
  new -> Hyb_rel_right.rname = rname;
  return (new);
}

/* Allocate new affix_rule record for constructor Affix_synonym */
affix_rule new_Affix_synonym (int line, int col, string aname,
		string syn)
{ affix_rule new = (affix_rule) dcg_malloc (sizeof (struct str_affix_rule));
  new -> line = line;
  new -> col = col;
  new -> aname = aname;
  new -> anr = int_nil;
  new -> gnr = int_nil;
  new -> lc_nrs = int_list_nil;
  new -> kind = arule_kind_nil;
  new -> dom = domain_nil;
  new -> empty = nullability_nil;
  new -> value = affix_value_nil;
  new -> npred = int_nil;
  new -> reachable = int_nil;
  new -> tag = TAGAffix_synonym;
  new -> Affix_synonym.syn = syn;
  new -> Affix_synonym.syndef = affix_rule_nil;
  return (new);
}

/* Allocate new affix_rule record for constructor Affix_alts */
affix_rule new_Affix_alts (int line, int col, string aname,
		affix_alternative_list alts)
{ affix_rule new = (affix_rule) dcg_malloc (sizeof (struct str_affix_rule));
  new -> line = line;
  new -> col = col;
  new -> aname = aname;
  new -> anr = int_nil;
  new -> gnr = int_nil;
  new -> lc_nrs = int_list_nil;
  new -> kind = arule_kind_nil;
  new -> dom = domain_nil;
  new -> empty = nullability_nil;
  new -> value = affix_value_nil;
  new -> npred = int_nil;
  new -> reachable = int_nil;
  new -> tag = TAGAffix_alts;
  new -> Affix_alts.alts = alts;
  new -> Affix_alts.enumerable = int_nil;
  return (new);
}

/* Allocate new affix_rule record for constructor Affix_prim */
affix_rule new_Affix_prim (int line, int col, string aname)
{ affix_rule new = (affix_rule) dcg_malloc (sizeof (struct str_affix_rule));
  new -> line = line;
  new -> col = col;
  new -> aname = aname;
  new -> anr = int_nil;
  new -> gnr = int_nil;
  new -> lc_nrs = int_list_nil;
  new -> kind = arule_kind_nil;
  new -> dom = domain_nil;
  new -> empty = nullability_nil;
  new -> value = affix_value_nil;
  new -> npred = int_nil;
  new -> reachable = int_nil;
  new -> tag = TAGAffix_prim;
  return (new);
}

/* Allocate new affix_alternative record for constructor Affix_sequence */
affix_alternative new_Affix_sequence (affix_element_list elems)
{ affix_alternative new = (affix_alternative) dcg_malloc (sizeof (struct str_affix_alternative));
  new -> elems = elems;
  new -> empty = int_nil;
  new -> tag = TAGAffix_sequence;
  return (new);
}

/* Allocate new affix_alternative record for constructor Affix_concat */
affix_alternative new_Affix_concat (affix_element_list elems)
{ affix_alternative new = (affix_alternative) dcg_malloc (sizeof (struct str_affix_alternative));
  new -> elems = elems;
  new -> empty = int_nil;
  new -> tag = TAGAffix_concat;
  return (new);
}

/* Allocate new affix_alternative record for constructor Affix_union */
affix_alternative new_Affix_union (affix_element_list elems)
{ affix_alternative new = (affix_alternative) dcg_malloc (sizeof (struct str_affix_alternative));
  new -> elems = elems;
  new -> empty = int_nil;
  new -> tag = TAGAffix_union;
  return (new);
}

/* Allocate new affix_alternative record for constructor Affix_partition */
affix_alternative new_Affix_partition (affix_element_list elems)
{ affix_alternative new = (affix_alternative) dcg_malloc (sizeof (struct str_affix_alternative));
  new -> elems = elems;
  new -> empty = int_nil;
  new -> tag = TAGAffix_partition;
  return (new);
}

/* Allocate new affix_alternative record for constructor Affix_single */
affix_alternative new_Affix_single (affix_element_list elems)
{ affix_alternative new = (affix_alternative) dcg_malloc (sizeof (struct str_affix_alternative));
  new -> elems = elems;
  new -> empty = int_nil;
  new -> tag = TAGAffix_single;
  return (new);
}

/* Allocate new affix_alternative record for constructor Affix_empty */
affix_alternative new_Affix_empty (affix_element_list elems)
{ affix_alternative new = (affix_alternative) dcg_malloc (sizeof (struct str_affix_alternative));
  new -> elems = elems;
  new -> empty = int_nil;
  new -> tag = TAGAffix_empty;
  return (new);
}

/* Allocate new affix_element record for constructor Affix_var */
affix_element new_Affix_var (int line, int col,
		string vname)
{ affix_element new = (affix_element) dcg_malloc (sizeof (struct str_affix_element));
  new -> line = line;
  new -> col = col;
  new -> empty = nullability_nil;
  new -> tag = TAGAffix_var;
  new -> Affix_var.vname = vname;
  new -> Affix_var.vdef = affix_rule_nil;
  return (new);
}

/* Allocate new affix_element record for constructor Affix_term */
affix_element new_Affix_term (int line, int col,
		string tname)
{ affix_element new = (affix_element) dcg_malloc (sizeof (struct str_affix_element));
  new -> line = line;
  new -> col = col;
  new -> empty = nullability_nil;
  new -> tag = TAGAffix_term;
  new -> Affix_term.tname = tname;
  new -> Affix_term.edef = element_nil;
  return (new);
}

/* Allocate new affix_element record for constructor Affix_text */
affix_element new_Affix_text (int line, int col,
		string text)
{ affix_element new = (affix_element) dcg_malloc (sizeof (struct str_affix_element));
  new -> line = line;
  new -> col = col;
  new -> empty = nullability_nil;
  new -> tag = TAGAffix_text;
  new -> Affix_text.text = text;
  new -> Affix_text.termnr = int_nil;
  new -> Affix_text.is_regexp = int_nil;
  return (new);
}

/* Allocate new affix_element record for constructor Affix_inum */
affix_element new_Affix_inum (int line, int col,
		int ival)
{ affix_element new = (affix_element) dcg_malloc (sizeof (struct str_affix_element));
  new -> line = line;
  new -> col = col;
  new -> empty = nullability_nil;
  new -> tag = TAGAffix_inum;
  new -> Affix_inum.ival = ival;
  return (new);
}

/* Allocate new affix_element record for constructor Affix_rnum */
affix_element new_Affix_rnum (int line, int col,
		real rval)
{ affix_element new = (affix_element) dcg_malloc (sizeof (struct str_affix_element));
  new -> line = line;
  new -> col = col;
  new -> empty = nullability_nil;
  new -> tag = TAGAffix_rnum;
  new -> Affix_rnum.rval = rval;
  return (new);
}

/* Allocate new invisible_nonterminal record */
invisible_nonterminal new_invisible_nonterminal (string fname, int line, int col, string_list name, int arity)
{ invisible_nonterminal new = (invisible_nonterminal) dcg_malloc (sizeof (struct str_invisible_nonterminal));
  new -> fname = fname;
  new -> line = line;
  new -> col = col;
  new -> name = name;
  new -> arity = arity;
  return (new);
};

/* Allocate new element record */
element new_element (string name)
{ element new = (element) dcg_malloc (sizeof (struct str_element));
  new -> name = name;
  new -> enr = int_nil;
  new -> dom = domain_nil;
  new -> log_value = int_nil;
  new -> value = affix_value_nil;
  return (new);
};

/* Allocate new domain record */
domain new_domain (int_list elts)
{ domain new = (domain) dcg_malloc (sizeof (struct str_domain));
  new -> elts = elts;
  new -> dnr = int_nil;
  new -> width = int_nil;
  return (new);
};

/* Allocate new regexp record for constructor Regexp_or */
regexp new_Regexp_or (regexp_list subs)
{ regexp new = (regexp) dcg_malloc (sizeof (struct str_regexp));
  new -> tag = TAGRegexp_or;
  new -> Regexp_or.subs = subs;
  return (new);
}

/* Allocate new regexp record for constructor Regexp_concat */
regexp new_Regexp_concat (regexp_list subs)
{ regexp new = (regexp) dcg_malloc (sizeof (struct str_regexp));
  new -> tag = TAGRegexp_concat;
  new -> Regexp_concat.subs = subs;
  return (new);
}

/* Allocate new regexp record for constructor Regexp_star */
regexp new_Regexp_star (regexp sub)
{ regexp new = (regexp) dcg_malloc (sizeof (struct str_regexp));
  new -> tag = TAGRegexp_star;
  new -> Regexp_star.sub = sub;
  return (new);
}

/* Allocate new regexp record for constructor Regexp_plus */
regexp new_Regexp_plus (regexp sub)
{ regexp new = (regexp) dcg_malloc (sizeof (struct str_regexp));
  new -> tag = TAGRegexp_plus;
  new -> Regexp_plus.sub = sub;
  return (new);
}

/* Allocate new regexp record for constructor Regexp_opt */
regexp new_Regexp_opt (regexp sub)
{ regexp new = (regexp) dcg_malloc (sizeof (struct str_regexp));
  new -> tag = TAGRegexp_opt;
  new -> Regexp_opt.sub = sub;
  return (new);
}

/* Allocate new regexp record for constructor Regexp_cset */
regexp new_Regexp_cset (int cs)
{ regexp new = (regexp) dcg_malloc (sizeof (struct str_regexp));
  new -> tag = TAGRegexp_cset;
  new -> Regexp_cset.cs = cs;
  return (new);
}

/* Allocate new regexp record for constructor Regexp_char */
regexp new_Regexp_char (int ch)
{ regexp new = (regexp) dcg_malloc (sizeof (struct str_regexp));
  new -> tag = TAGRegexp_char;
  new -> Regexp_char.ch = ch;
  return (new);
}

/* Allocate new regexp record for constructor Regexp_anychar */
regexp new_Regexp_anychar ()
{ regexp new = (regexp) dcg_malloc (sizeof (struct str_regexp));
  new -> tag = TAGRegexp_anychar;
  return (new);
}

/* Allocate new regexp record for constructor Regexp_whitespace */
regexp new_Regexp_whitespace ()
{ regexp new = (regexp) dcg_malloc (sizeof (struct str_regexp));
  new -> tag = TAGRegexp_whitespace;
  return (new);
}

/* Allocate new regexp record for constructor Regexp_nonwhitespace */
regexp new_Regexp_nonwhitespace ()
{ regexp new = (regexp) dcg_malloc (sizeof (struct str_regexp));
  new -> tag = TAGRegexp_nonwhitespace;
  return (new);
}

/* Allocate new regexp record for constructor Regexp_empty */
regexp new_Regexp_empty ()
{ regexp new = (regexp) dcg_malloc (sizeof (struct str_regexp));
  new -> tag = TAGRegexp_empty;
  return (new);
}

/* Allocate new name record */
name new_name (int line, int col, string_list id)
{ name new = (name) dcg_malloc (sizeof (struct str_name));
  new -> line = line;
  new -> col = col;
  new -> id = id;
  return (new);
};

/* Allocate new call_solution record */
call_solution new_call_solution (affix_term_list apars, int nr_matches)
{ call_solution new = (call_solution) dcg_malloc (sizeof (struct str_call_solution));
  new -> rdef = rule_nil;
  new -> apars = apars;
  new -> nr_matches = nr_matches;
  return (new);
};

/* Allocate new madm record for constructor Rule_adm */
madm new_Rule_adm ()
{ madm new = (madm) dcg_malloc (sizeof (struct str_madm));
  new -> tag = TAGRule_adm;
  new -> Rule_adm.terms = affix_term_list_nil;
  new -> Rule_adm.iptr = int_nil;
  new -> Rule_adm.goal = affix_rule_nil;
  new -> Rule_adm.complete = int_nil;
  return (new);
}

/* Allocate new madm record for constructor Member_adm */
madm new_Member_adm (int alt_nr, int mem_nr)
{ madm new = (madm) dcg_malloc (sizeof (struct str_madm));
  new -> tag = TAGMember_adm;
  new -> Member_adm.arule = affix_rule_nil;
  new -> Member_adm.alt_nr = alt_nr;
  new -> Member_adm.mem_nr = mem_nr;
  return (new);
}

/* Recursively detach a grammar */
void detach_grammar (grammar *optr)
{ grammar old = (grammar) dcg_predetach ((void **) optr);
  if (old == grammar_nil) return;
  detach_string (&(old -> fname));
  detach_string (&(old -> gname));
  detach_string_list (&(old -> uses));
  detach_string_list (&(old -> lexica));
  detach_string_list (&(old -> fact_tables));
  detach_string_list (&(old -> triple_databases));
  detach_prule_list (&(old -> exp_prules));
  detach_prule_list (&(old -> prules));
  detach_affix_rule_list (&(old -> arules));
  detach_member (&(old -> root_call));
  dcg_detach ((void **) &old);
}

/* Recursively detach a prule */
void detach_prule (prule *optr)
{ prule old = (prule) dcg_predetach ((void **) optr);
  if (old == prule_nil) return;
  detach_plhs (&(old -> lhs));
  switch (old -> tag)
    { case TAGExt_prule:
	detach_string (&(old -> Ext_prule.ename));
	break;
      case TAGQuasi_prule:
	detach_string (&(old -> Quasi_prule.rname));
	break;
      case TAGProto_rule:
	detach_group (&(old -> Proto_rule.grp));
	break;
      case TAGPspec:
	break;
      case TAGPstart:
	break;
      default:
	dcg_bad_tag ((int) old -> tag, "detach_prule");
    };
  dcg_detach ((void **) &old);
}

/* Recursively detach a plhs */
void detach_plhs (plhs *optr)
{ plhs old = (plhs) dcg_predetach ((void **) optr);
  if (old == plhs_nil) return;
  detach_int (&(old -> line));
  detach_int (&(old -> col));
  detach_rule_layer (&(old -> rlayer));
  detach_rule_kind (&(old -> rkind));
  detach_rule_type (&(old -> rtype));
  detach_string_list (&(old -> rname_parts));
  detach_int_list (&(old -> rname_chars));
  detach_fpar_list (&(old -> lhs_pars));
  dcg_detach ((void **) &old);
}

/* Recursively detach a rule */
void detach_rule (rule *optr)
{ rule old = (rule) dcg_predetach ((void **) optr);
  if (old == rule_nil) return;
  detach_spec (&(old -> rspec));
  switch (old -> tag)
    { case TAGExt_rule:
	detach_string (&(old -> Ext_rule.ename));
	break;
      case TAGQuasi_rule:
	detach_string (&(old -> Quasi_rule.rname));
	break;
      case TAGDefs:
	detach_definition_list (&(old -> Defs.defs));
	break;
      case TAGAnonymous_option:
	detach_group (&(old -> Anonymous_option.grp));
	break;
      case TAGAnonymous_group:
	detach_group (&(old -> Anonymous_group.grp));
	break;
      default:
	dcg_bad_tag ((int) old -> tag, "detach_rule");
    };
  dcg_detach ((void **) &old);
}

/* Recursively detach a spec */
void detach_spec (spec *optr)
{ spec old = (spec) dcg_predetach ((void **) optr);
  if (old == spec_nil) return;
  detach_rule_layer (&(old -> rlayer));
  detach_rule_kind (&(old -> rkind));
  detach_rule_type (&(old -> rtype));
  detach_string_list (&(old -> rname_parts));
  detach_int_list (&(old -> rname_chars));
  detach_affix_rule_list (&(old -> rsig));
  detach_dir_list (&(old -> dirs));
  dcg_detach ((void **) &old);
}

/* Recursively detach a rdecl */
void detach_rdecl (rdecl *optr)
{ rdecl old = (rdecl) dcg_predetach ((void **) optr);
  if (old == rdecl_nil) return;
  dcg_detach ((void **) &old);
}

/* Recursively detach a variable */
void detach_variable (variable *optr)
{ variable old = (variable) dcg_predetach ((void **) optr);
  if (old == variable_nil) return;
  detach_string (&(old -> vname));
  dcg_detach ((void **) &old);
}

/* Recursively detach a definition */
void detach_definition (definition *optr)
{ definition old = (definition) dcg_predetach ((void **) optr);
  if (old == definition_nil) return;
  detach_fpar_list (&(old -> lhs_pars));
  detach_variable_list (&(old -> locals));
  detach_group (&(old -> grp));
  dcg_detach ((void **) &old);
}

/* Recursively detach a fpar */
void detach_fpar (fpar *optr)
{ fpar old = (fpar) dcg_predetach ((void **) optr);
  if (old == fpar_nil) return;
  detach_int (&(old -> line));
  detach_int (&(old -> col));
  detach_dir (&(old -> fdir));
  detach_affix_term_list (&(old -> fexp));
  dcg_detach ((void **) &old);
}

/* Recursively detach a group */
void detach_group (group *optr)
{ group old = (group) dcg_predetach ((void **) optr);
  if (old == group_nil) return;
  detach_alternative_list (&(old -> alts));
  dcg_detach ((void **) &old);
}

/* Recursively detach a alternative */
void detach_alternative (alternative *optr)
{ alternative old = (alternative) dcg_predetach ((void **) optr);
  if (old == alternative_nil) return;
  detach_int (&(old -> line));
  detach_int (&(old -> col));
  detach_real (&(old -> freq));
  detach_fwo_group_list (&(old -> members));
  detach_int (&(old -> commited));
  detach_trans_member_list (&(old -> trans));
  dcg_detach ((void **) &old);
}

/* Recursively detach a fwo_group */
void detach_fwo_group (fwo_group *optr)
{ fwo_group old = (fwo_group) dcg_predetach ((void **) optr);
  if (old == fwo_group_nil) return;
  detach_glue (&(old -> gl));
  switch (old -> tag)
    { case TAGSingle:
	detach_member (&(old -> Single.mem));
	break;
      case TAGFwo:
	detach_member_list (&(old -> Fwo.mems));
	break;
      default:
	dcg_bad_tag ((int) old -> tag, "detach_fwo_group");
    };
  dcg_detach ((void **) &old);
}

/* Recursively detach a member */
void detach_member (member *optr)
{ member old = (member) dcg_predetach ((void **) optr);
  if (old == member_nil) return;
  detach_int (&(old -> line));
  detach_int (&(old -> col));
  switch (old -> tag)
    { case TAGCall:
	detach_string_list (&(old -> Call.rname_parts));
	detach_int_list (&(old -> Call.rname_chars));
	detach_apar_list (&(old -> Call.apars));
	break;
      case TAGGuard:
	detach_confrontation_list (&(old -> Guard.confs));
	break;
      case TAGTerm:
	detach_string (&(old -> Term.text));
	detach_apar (&(old -> Term.par));
	break;
      case TAGQuasi:
	detach_string_list (&(old -> Quasi.qname_parts));
	detach_int_list (&(old -> Quasi.qname_chars));
	detach_apar_list (&(old -> Quasi.args));
	break;
      case TAGOp:
	detach_control_op (&(old -> Op.op));
	break;
      case TAGGroup:
	detach_group (&(old -> Group.grp));
	break;
      case TAGOption:
	detach_group (&(old -> Option.grp));
	break;
      case TAGRes_guard:
	detach_res_conf_list (&(old -> Res_guard.rconfs));
	break;
      case TAGRes_call:
	detach_affix_term_list (&(old -> Res_call.args));
	detach_dir_list (&(old -> Res_call.adirs));
	break;
      case TAGRes_term:
	detach_string (&(old -> Res_term.text));
	detach_dir (&(old -> Res_term.adir));
	detach_affix_term (&(old -> Res_term.arg));
	break;
      default:
	dcg_bad_tag ((int) old -> tag, "detach_member");
    };
  dcg_detach ((void **) &old);
}

/* Recursively detach a apar */
void detach_apar (apar *optr)
{ apar old = (apar) dcg_predetach ((void **) optr);
  if (old == apar_nil) return;
  detach_dir (&(old -> adir));
  detach_affix_term_list (&(old -> aexp));
  dcg_detach ((void **) &old);
}

/* Recursively detach a confrontation */
void detach_confrontation (confrontation *optr)
{ confrontation old = (confrontation) dcg_predetach ((void **) optr);
  if (old == confrontation_nil) return;
  detach_int (&(old -> line));
  detach_int (&(old -> col));
  detach_guard_type (&(old -> typ));
  detach_affix_term_list (&(old -> lhs));
  detach_affix_term_list (&(old -> rhs));
  dcg_detach ((void **) &old);
}

/* Recursively detach a res_conf */
void detach_res_conf (res_conf *optr)
{ res_conf old = (res_conf) dcg_predetach ((void **) optr);
  if (old == res_conf_nil) return;
  detach_guard_type (&(old -> typ));
  detach_affix_term (&(old -> lhs));
  detach_affix_term (&(old -> rhs));
  dcg_detach ((void **) &old);
}

/* Recursively detach a affix_term */
void detach_affix_term (affix_term *optr)
{ affix_term old = (affix_term) dcg_predetach ((void **) optr);
  if (old == affix_term_nil) return;
  detach_int (&(old -> line));
  detach_int (&(old -> col));
  switch (old -> tag)
    { case TAGTerminal:
	detach_string (&(old -> Terminal.marker));
	break;
      case TAGDyop:
	detach_operator (&(old -> Dyop.dop));
	detach_affix_term (&(old -> Dyop.arg1));
	detach_affix_term (&(old -> Dyop.arg2));
	break;
      case TAGMonop:
	detach_operator (&(old -> Monop.mop));
	detach_affix_term (&(old -> Monop.arg));
	break;
      case TAGEnclosed:
	detach_affix_term_list (&(old -> Enclosed.terms));
	break;
      case TAGAst:
	detach_affix_term_list (&(old -> Ast.terms));
	detach_int (&(old -> Ast.altnr));
	break;
      case TAGConcat:
	detach_affix_term_list (&(old -> Concat.terms));
	break;
      case TAGInt:
	detach_int (&(old -> Int.num));
	break;
      case TAGReal:
	detach_real (&(old -> Real.num));
	break;
      case TAGText:
	detach_string (&(old -> Text.txt));
	break;
      case TAGRegexp:
	detach_string (&(old -> Regexp.text));
	break;
      case TAGVar:
	detach_string (&(old -> Var.aname));
	break;
      default:
	dcg_bad_tag ((int) old -> tag, "detach_affix_term");
    };
  dcg_detach ((void **) &old);
}

/* Recursively detach a trans_member */
void detach_trans_member (trans_member *optr)
{ trans_member old = (trans_member) dcg_predetach ((void **) optr);
  if (old == trans_member_nil) return;
  detach_int (&(old -> line));
  detach_int (&(old -> col));
  detach_glue (&(old -> gl));
  switch (old -> tag)
    { case TAGTcall:
	detach_string_list (&(old -> Tcall.cname));
	detach_int (&(old -> Tcall.nr));
	break;
      case TAGTquasi:
	detach_string (&(old -> Tquasi.qname));
	detach_int (&(old -> Tquasi.nr));
	break;
      case TAGTgroup:
	detach_int (&(old -> Tgroup.nr));
	break;
      case TAGToption:
	detach_int (&(old -> Toption.nr));
	break;
      case TAGTtext:
	detach_string (&(old -> Ttext.text));
	break;
      case TAGTvar:
	detach_string (&(old -> Tvar.aname));
	break;
      case TAGThybrid:
	detach_hyb_op (&(old -> Thybrid.op));
	break;
      default:
	dcg_bad_tag ((int) old -> tag, "detach_trans_member");
    };
  dcg_detach ((void **) &old);
}

/* Recursively detach a hyb_op */
void detach_hyb_op (hyb_op *optr)
{ hyb_op old = (hyb_op) dcg_predetach ((void **) optr);
  if (old == hyb_op_nil) return;
  switch (old -> tag)
    { case TAGHyb_sqr_open:
	break;
      case TAGHyb_sqr_close:
	break;
      case TAGHyb_curl_open:
	break;
      case TAGHyb_curl_close:
	break;
      case TAGHyb_bar:
	break;
      case TAGHyb_rel_left:
	detach_string (&(old -> Hyb_rel_left.rname));
	break;
      case TAGHyb_rel_right:
	detach_string (&(old -> Hyb_rel_right.rname));
	break;
      default:
	dcg_bad_tag ((int) old -> tag, "detach_hyb_op");
    };
  dcg_detach ((void **) &old);
}

/* Recursively detach a affix_rule */
void detach_affix_rule (affix_rule *optr)
{ affix_rule old = (affix_rule) dcg_predetach ((void **) optr);
  if (old == affix_rule_nil) return;
  detach_int (&(old -> line));
  detach_int (&(old -> col));
  detach_string (&(old -> aname));
  switch (old -> tag)
    { case TAGAffix_synonym:
	detach_string (&(old -> Affix_synonym.syn));
	break;
      case TAGAffix_alts:
	detach_affix_alternative_list (&(old -> Affix_alts.alts));
	break;
      case TAGAffix_prim:
	break;
      default:
	dcg_bad_tag ((int) old -> tag, "detach_affix_rule");
    };
  dcg_detach ((void **) &old);
}

/* Recursively detach a affix_alternative */
void detach_affix_alternative (affix_alternative *optr)
{ affix_alternative old = (affix_alternative) dcg_predetach ((void **) optr);
  if (old == affix_alternative_nil) return;
  detach_affix_element_list (&(old -> elems));
  switch (old -> tag)
    { case TAGAffix_sequence:
	break;
      case TAGAffix_concat:
	break;
      case TAGAffix_union:
	break;
      case TAGAffix_partition:
	break;
      case TAGAffix_single:
	break;
      case TAGAffix_empty:
	break;
      default:
	dcg_bad_tag ((int) old -> tag, "detach_affix_alternative");
    };
  dcg_detach ((void **) &old);
}

/* Recursively detach a affix_element */
void detach_affix_element (affix_element *optr)
{ affix_element old = (affix_element) dcg_predetach ((void **) optr);
  if (old == affix_element_nil) return;
  detach_int (&(old -> line));
  detach_int (&(old -> col));
  switch (old -> tag)
    { case TAGAffix_var:
	detach_string (&(old -> Affix_var.vname));
	break;
      case TAGAffix_term:
	detach_string (&(old -> Affix_term.tname));
	break;
      case TAGAffix_text:
	detach_string (&(old -> Affix_text.text));
	break;
      case TAGAffix_inum:
	detach_int (&(old -> Affix_inum.ival));
	break;
      case TAGAffix_rnum:
	detach_real (&(old -> Affix_rnum.rval));
	break;
      default:
	dcg_bad_tag ((int) old -> tag, "detach_affix_element");
    };
  dcg_detach ((void **) &old);
}

/* Recursively detach a invisible_nonterminal */
void detach_invisible_nonterminal (invisible_nonterminal *optr)
{ invisible_nonterminal old = (invisible_nonterminal) dcg_predetach ((void **) optr);
  if (old == invisible_nonterminal_nil) return;
  detach_string (&(old -> fname));
  detach_int (&(old -> line));
  detach_int (&(old -> col));
  detach_string_list (&(old -> name));
  detach_int (&(old -> arity));
  dcg_detach ((void **) &old);
}

/* Recursively detach a element */
void detach_element (element *optr)
{ element old = (element) dcg_predetach ((void **) optr);
  if (old == element_nil) return;
  detach_string (&(old -> name));
  dcg_detach ((void **) &old);
}

/* Recursively detach a domain */
void detach_domain (domain *optr)
{ domain old = (domain) dcg_predetach ((void **) optr);
  if (old == domain_nil) return;
  detach_int_list (&(old -> elts));
  dcg_detach ((void **) &old);
}

/* Recursively detach a regexp */
void detach_regexp (regexp *optr)
{ regexp old = (regexp) dcg_predetach ((void **) optr);
  if (old == regexp_nil) return;
  switch (old -> tag)
    { case TAGRegexp_or:
	detach_regexp_list (&(old -> Regexp_or.subs));
	break;
      case TAGRegexp_concat:
	detach_regexp_list (&(old -> Regexp_concat.subs));
	break;
      case TAGRegexp_star:
	detach_regexp (&(old -> Regexp_star.sub));
	break;
      case TAGRegexp_plus:
	detach_regexp (&(old -> Regexp_plus.sub));
	break;
      case TAGRegexp_opt:
	detach_regexp (&(old -> Regexp_opt.sub));
	break;
      case TAGRegexp_cset:
	detach_int (&(old -> Regexp_cset.cs));
	break;
      case TAGRegexp_char:
	detach_int (&(old -> Regexp_char.ch));
	break;
      case TAGRegexp_anychar:
	break;
      case TAGRegexp_whitespace:
	break;
      case TAGRegexp_nonwhitespace:
	break;
      case TAGRegexp_empty:
	break;
      default:
	dcg_bad_tag ((int) old -> tag, "detach_regexp");
    };
  dcg_detach ((void **) &old);
}

/* Recursively detach a name */
void detach_name (name *optr)
{ name old = (name) dcg_predetach ((void **) optr);
  if (old == name_nil) return;
  detach_int (&(old -> line));
  detach_int (&(old -> col));
  detach_string_list (&(old -> id));
  dcg_detach ((void **) &old);
}

/* Recursively detach a call_solution */
void detach_call_solution (call_solution *optr)
{ call_solution old = (call_solution) dcg_predetach ((void **) optr);
  if (old == call_solution_nil) return;
  detach_affix_term_list (&(old -> apars));
  detach_int (&(old -> nr_matches));
  dcg_detach ((void **) &old);
}

/* Recursively detach a madm */
void detach_madm (madm *optr)
{ madm old = (madm) dcg_predetach ((void **) optr);
  if (old == madm_nil) return;
  switch (old -> tag)
    { case TAGRule_adm:
	break;
      case TAGMember_adm:
	detach_int (&(old -> Member_adm.alt_nr));
	detach_int (&(old -> Member_adm.mem_nr));
	break;
      default:
	dcg_bad_tag ((int) old -> tag, "detach_madm");
    };
  dcg_detach ((void **) &old);
}

/* Recursively detach a grammar_list */
void detach_grammar_list (grammar_list *lp)
{ int ix;
  grammar_list old = (grammar_list) dcg_predetach ((void **) lp);
  if (old == grammar_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_grammar (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a prule_list */
void detach_prule_list (prule_list *lp)
{ int ix;
  prule_list old = (prule_list) dcg_predetach ((void **) lp);
  if (old == prule_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_prule (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a plhs_list */
void detach_plhs_list (plhs_list *lp)
{ int ix;
  plhs_list old = (plhs_list) dcg_predetach ((void **) lp);
  if (old == plhs_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_plhs (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a rule_list */
void detach_rule_list (rule_list *lp)
{ int ix;
  rule_list old = (rule_list) dcg_predetach ((void **) lp);
  if (old == rule_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_rule (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a rdecl_list */
void detach_rdecl_list (rdecl_list *lp)
{ int ix;
  rdecl_list old = (rdecl_list) dcg_predetach ((void **) lp);
  if (old == rdecl_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_rdecl (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a variable_list */
void detach_variable_list (variable_list *lp)
{ int ix;
  variable_list old = (variable_list) dcg_predetach ((void **) lp);
  if (old == variable_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_variable (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a definition_list */
void detach_definition_list (definition_list *lp)
{ int ix;
  definition_list old = (definition_list) dcg_predetach ((void **) lp);
  if (old == definition_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_definition (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a fpar_list */
void detach_fpar_list (fpar_list *lp)
{ int ix;
  fpar_list old = (fpar_list) dcg_predetach ((void **) lp);
  if (old == fpar_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_fpar (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a dir_list */
void detach_dir_list (dir_list *lp)
{ int ix;
  dir_list old = (dir_list) dcg_predetach ((void **) lp);
  if (old == dir_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_dir (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a alternative_list */
void detach_alternative_list (alternative_list *lp)
{ int ix;
  alternative_list old = (alternative_list) dcg_predetach ((void **) lp);
  if (old == alternative_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_alternative (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a fwo_group_list */
void detach_fwo_group_list (fwo_group_list *lp)
{ int ix;
  fwo_group_list old = (fwo_group_list) dcg_predetach ((void **) lp);
  if (old == fwo_group_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_fwo_group (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a member_list */
void detach_member_list (member_list *lp)
{ int ix;
  member_list old = (member_list) dcg_predetach ((void **) lp);
  if (old == member_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_member (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a apar_list */
void detach_apar_list (apar_list *lp)
{ int ix;
  apar_list old = (apar_list) dcg_predetach ((void **) lp);
  if (old == apar_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_apar (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a confrontation_list */
void detach_confrontation_list (confrontation_list *lp)
{ int ix;
  confrontation_list old = (confrontation_list) dcg_predetach ((void **) lp);
  if (old == confrontation_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_confrontation (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a res_conf_list */
void detach_res_conf_list (res_conf_list *lp)
{ int ix;
  res_conf_list old = (res_conf_list) dcg_predetach ((void **) lp);
  if (old == res_conf_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_res_conf (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a affix_term_list */
void detach_affix_term_list (affix_term_list *lp)
{ int ix;
  affix_term_list old = (affix_term_list) dcg_predetach ((void **) lp);
  if (old == affix_term_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_affix_term (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a trans_member_list */
void detach_trans_member_list (trans_member_list *lp)
{ int ix;
  trans_member_list old = (trans_member_list) dcg_predetach ((void **) lp);
  if (old == trans_member_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_trans_member (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a affix_rule_list */
void detach_affix_rule_list (affix_rule_list *lp)
{ int ix;
  affix_rule_list old = (affix_rule_list) dcg_predetach ((void **) lp);
  if (old == affix_rule_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_affix_rule (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a affix_alternative_list */
void detach_affix_alternative_list (affix_alternative_list *lp)
{ int ix;
  affix_alternative_list old = (affix_alternative_list) dcg_predetach ((void **) lp);
  if (old == affix_alternative_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_affix_alternative (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a affix_element_list */
void detach_affix_element_list (affix_element_list *lp)
{ int ix;
  affix_element_list old = (affix_element_list) dcg_predetach ((void **) lp);
  if (old == affix_element_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_affix_element (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a invisible_nonterminal_list */
void detach_invisible_nonterminal_list (invisible_nonterminal_list *lp)
{ int ix;
  invisible_nonterminal_list old = (invisible_nonterminal_list) dcg_predetach ((void **) lp);
  if (old == invisible_nonterminal_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_invisible_nonterminal (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a element_list */
void detach_element_list (element_list *lp)
{ int ix;
  element_list old = (element_list) dcg_predetach ((void **) lp);
  if (old == element_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_element (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a domain_list */
void detach_domain_list (domain_list *lp)
{ int ix;
  domain_list old = (domain_list) dcg_predetach ((void **) lp);
  if (old == domain_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_domain (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a regexp_list */
void detach_regexp_list (regexp_list *lp)
{ int ix;
  regexp_list old = (regexp_list) dcg_predetach ((void **) lp);
  if (old == regexp_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_regexp (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a name_list */
void detach_name_list (name_list *lp)
{ int ix;
  name_list old = (name_list) dcg_predetach ((void **) lp);
  if (old == name_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_name (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a call_solution_list */
void detach_call_solution_list (call_solution_list *lp)
{ int ix;
  call_solution_list old = (call_solution_list) dcg_predetach ((void **) lp);
  if (old == call_solution_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_call_solution (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Recursively detach a madm_list */
void detach_madm_list (madm_list *lp)
{ int ix;
  madm_list old = (madm_list) dcg_predetach ((void **) lp);
  if (old == madm_list_nil) return;
  for (ix = 0; ix < old -> size; ix++)
    detach_madm (&(old -> array[ix]));
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a grammar_list without detaching elements */
void nonrec_detach_grammar_list (grammar_list *lp)
{ grammar_list old = (grammar_list) dcg_predetach ((void **) lp);
  if (old == grammar_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a prule_list without detaching elements */
void nonrec_detach_prule_list (prule_list *lp)
{ prule_list old = (prule_list) dcg_predetach ((void **) lp);
  if (old == prule_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a plhs_list without detaching elements */
void nonrec_detach_plhs_list (plhs_list *lp)
{ plhs_list old = (plhs_list) dcg_predetach ((void **) lp);
  if (old == plhs_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a rule_list without detaching elements */
void nonrec_detach_rule_list (rule_list *lp)
{ rule_list old = (rule_list) dcg_predetach ((void **) lp);
  if (old == rule_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a rdecl_list without detaching elements */
void nonrec_detach_rdecl_list (rdecl_list *lp)
{ rdecl_list old = (rdecl_list) dcg_predetach ((void **) lp);
  if (old == rdecl_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a variable_list without detaching elements */
void nonrec_detach_variable_list (variable_list *lp)
{ variable_list old = (variable_list) dcg_predetach ((void **) lp);
  if (old == variable_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a definition_list without detaching elements */
void nonrec_detach_definition_list (definition_list *lp)
{ definition_list old = (definition_list) dcg_predetach ((void **) lp);
  if (old == definition_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a fpar_list without detaching elements */
void nonrec_detach_fpar_list (fpar_list *lp)
{ fpar_list old = (fpar_list) dcg_predetach ((void **) lp);
  if (old == fpar_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a dir_list without detaching elements */
void nonrec_detach_dir_list (dir_list *lp)
{ dir_list old = (dir_list) dcg_predetach ((void **) lp);
  if (old == dir_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a alternative_list without detaching elements */
void nonrec_detach_alternative_list (alternative_list *lp)
{ alternative_list old = (alternative_list) dcg_predetach ((void **) lp);
  if (old == alternative_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a fwo_group_list without detaching elements */
void nonrec_detach_fwo_group_list (fwo_group_list *lp)
{ fwo_group_list old = (fwo_group_list) dcg_predetach ((void **) lp);
  if (old == fwo_group_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a member_list without detaching elements */
void nonrec_detach_member_list (member_list *lp)
{ member_list old = (member_list) dcg_predetach ((void **) lp);
  if (old == member_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a apar_list without detaching elements */
void nonrec_detach_apar_list (apar_list *lp)
{ apar_list old = (apar_list) dcg_predetach ((void **) lp);
  if (old == apar_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a confrontation_list without detaching elements */
void nonrec_detach_confrontation_list (confrontation_list *lp)
{ confrontation_list old = (confrontation_list) dcg_predetach ((void **) lp);
  if (old == confrontation_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a res_conf_list without detaching elements */
void nonrec_detach_res_conf_list (res_conf_list *lp)
{ res_conf_list old = (res_conf_list) dcg_predetach ((void **) lp);
  if (old == res_conf_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a affix_term_list without detaching elements */
void nonrec_detach_affix_term_list (affix_term_list *lp)
{ affix_term_list old = (affix_term_list) dcg_predetach ((void **) lp);
  if (old == affix_term_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a trans_member_list without detaching elements */
void nonrec_detach_trans_member_list (trans_member_list *lp)
{ trans_member_list old = (trans_member_list) dcg_predetach ((void **) lp);
  if (old == trans_member_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a affix_rule_list without detaching elements */
void nonrec_detach_affix_rule_list (affix_rule_list *lp)
{ affix_rule_list old = (affix_rule_list) dcg_predetach ((void **) lp);
  if (old == affix_rule_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a affix_alternative_list without detaching elements */
void nonrec_detach_affix_alternative_list (affix_alternative_list *lp)
{ affix_alternative_list old = (affix_alternative_list) dcg_predetach ((void **) lp);
  if (old == affix_alternative_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a affix_element_list without detaching elements */
void nonrec_detach_affix_element_list (affix_element_list *lp)
{ affix_element_list old = (affix_element_list) dcg_predetach ((void **) lp);
  if (old == affix_element_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a invisible_nonterminal_list without detaching elements */
void nonrec_detach_invisible_nonterminal_list (invisible_nonterminal_list *lp)
{ invisible_nonterminal_list old = (invisible_nonterminal_list) dcg_predetach ((void **) lp);
  if (old == invisible_nonterminal_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a element_list without detaching elements */
void nonrec_detach_element_list (element_list *lp)
{ element_list old = (element_list) dcg_predetach ((void **) lp);
  if (old == element_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a domain_list without detaching elements */
void nonrec_detach_domain_list (domain_list *lp)
{ domain_list old = (domain_list) dcg_predetach ((void **) lp);
  if (old == domain_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a regexp_list without detaching elements */
void nonrec_detach_regexp_list (regexp_list *lp)
{ regexp_list old = (regexp_list) dcg_predetach ((void **) lp);
  if (old == regexp_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a name_list without detaching elements */
void nonrec_detach_name_list (name_list *lp)
{ name_list old = (name_list) dcg_predetach ((void **) lp);
  if (old == name_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a call_solution_list without detaching elements */
void nonrec_detach_call_solution_list (call_solution_list *lp)
{ call_solution_list old = (call_solution_list) dcg_predetach ((void **) lp);
  if (old == call_solution_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Detach a madm_list without detaching elements */
void nonrec_detach_madm_list (madm_list *lp)
{ madm_list old = (madm_list) dcg_predetach ((void **) lp);
  if (old == madm_list_nil) return;
  dcg_detach ((void **) &(old -> array));
  dcg_detach ((void **) &old);
}

/* Append element to grammar_list */
grammar_list append_grammar_list (grammar_list l, grammar el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_grammar_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to prule_list */
prule_list append_prule_list (prule_list l, prule el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_prule_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to plhs_list */
plhs_list append_plhs_list (plhs_list l, plhs el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_plhs_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to rule_list */
rule_list append_rule_list (rule_list l, rule el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_rule_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to rdecl_list */
rdecl_list append_rdecl_list (rdecl_list l, rdecl el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_rdecl_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to variable_list */
variable_list append_variable_list (variable_list l, variable el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_variable_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to definition_list */
definition_list append_definition_list (definition_list l, definition el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_definition_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to fpar_list */
fpar_list append_fpar_list (fpar_list l, fpar el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_fpar_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to dir_list */
dir_list append_dir_list (dir_list l, dir el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_dir_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to alternative_list */
alternative_list append_alternative_list (alternative_list l, alternative el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_alternative_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to fwo_group_list */
fwo_group_list append_fwo_group_list (fwo_group_list l, fwo_group el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_fwo_group_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to member_list */
member_list append_member_list (member_list l, member el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_member_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to apar_list */
apar_list append_apar_list (apar_list l, apar el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_apar_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to confrontation_list */
confrontation_list append_confrontation_list (confrontation_list l, confrontation el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_confrontation_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to res_conf_list */
res_conf_list append_res_conf_list (res_conf_list l, res_conf el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_res_conf_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to affix_term_list */
affix_term_list append_affix_term_list (affix_term_list l, affix_term el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_affix_term_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to trans_member_list */
trans_member_list append_trans_member_list (trans_member_list l, trans_member el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_trans_member_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to affix_rule_list */
affix_rule_list append_affix_rule_list (affix_rule_list l, affix_rule el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_affix_rule_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to affix_alternative_list */
affix_alternative_list append_affix_alternative_list (affix_alternative_list l, affix_alternative el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_affix_alternative_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to affix_element_list */
affix_element_list append_affix_element_list (affix_element_list l, affix_element el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_affix_element_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to invisible_nonterminal_list */
invisible_nonterminal_list append_invisible_nonterminal_list (invisible_nonterminal_list l, invisible_nonterminal el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_invisible_nonterminal_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to element_list */
element_list append_element_list (element_list l, element el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_element_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to domain_list */
domain_list append_domain_list (domain_list l, domain el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_domain_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to regexp_list */
regexp_list append_regexp_list (regexp_list l, regexp el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_regexp_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to name_list */
name_list append_name_list (name_list l, name el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_name_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to call_solution_list */
call_solution_list append_call_solution_list (call_solution_list l, call_solution el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_call_solution_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Append element to madm_list */
madm_list append_madm_list (madm_list l, madm el)
{ dcg_cknonshared ((char *) l);
  if (l -> size == l -> room)
    room_madm_list (l, l -> size << 1);
  l -> array[l -> size] = el;
  l -> size++;
  return (l);
}

/* Concatenate two grammar_lists */
grammar_list concat_grammar_list (grammar_list l1, grammar_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_grammar_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two prule_lists */
prule_list concat_prule_list (prule_list l1, prule_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_prule_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two plhs_lists */
plhs_list concat_plhs_list (plhs_list l1, plhs_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_plhs_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two rule_lists */
rule_list concat_rule_list (rule_list l1, rule_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_rule_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two rdecl_lists */
rdecl_list concat_rdecl_list (rdecl_list l1, rdecl_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_rdecl_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two variable_lists */
variable_list concat_variable_list (variable_list l1, variable_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_variable_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two definition_lists */
definition_list concat_definition_list (definition_list l1, definition_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_definition_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two fpar_lists */
fpar_list concat_fpar_list (fpar_list l1, fpar_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_fpar_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two dir_lists */
dir_list concat_dir_list (dir_list l1, dir_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_dir_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two alternative_lists */
alternative_list concat_alternative_list (alternative_list l1, alternative_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_alternative_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two fwo_group_lists */
fwo_group_list concat_fwo_group_list (fwo_group_list l1, fwo_group_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_fwo_group_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two member_lists */
member_list concat_member_list (member_list l1, member_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_member_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two apar_lists */
apar_list concat_apar_list (apar_list l1, apar_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_apar_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two confrontation_lists */
confrontation_list concat_confrontation_list (confrontation_list l1, confrontation_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_confrontation_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two res_conf_lists */
res_conf_list concat_res_conf_list (res_conf_list l1, res_conf_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_res_conf_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two affix_term_lists */
affix_term_list concat_affix_term_list (affix_term_list l1, affix_term_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_affix_term_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two trans_member_lists */
trans_member_list concat_trans_member_list (trans_member_list l1, trans_member_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_trans_member_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two affix_rule_lists */
affix_rule_list concat_affix_rule_list (affix_rule_list l1, affix_rule_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_affix_rule_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two affix_alternative_lists */
affix_alternative_list concat_affix_alternative_list (affix_alternative_list l1, affix_alternative_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_affix_alternative_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two affix_element_lists */
affix_element_list concat_affix_element_list (affix_element_list l1, affix_element_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_affix_element_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two invisible_nonterminal_lists */
invisible_nonterminal_list concat_invisible_nonterminal_list (invisible_nonterminal_list l1, invisible_nonterminal_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_invisible_nonterminal_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two element_lists */
element_list concat_element_list (element_list l1, element_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_element_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two domain_lists */
domain_list concat_domain_list (domain_list l1, domain_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_domain_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two regexp_lists */
regexp_list concat_regexp_list (regexp_list l1, regexp_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_regexp_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two name_lists */
name_list concat_name_list (name_list l1, name_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_name_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two call_solution_lists */
call_solution_list concat_call_solution_list (call_solution_list l1, call_solution_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_call_solution_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Concatenate two madm_lists */
madm_list concat_madm_list (madm_list l1, madm_list l2)
{ int ix;
  dcg_cknonshared ((char *) l1);
  room_madm_list (l1, l1 -> size + l2 -> size);
  for (ix = 0; ix < l2 -> size; ix++)
    l1 -> array[l1 -> size + ix] = l2 -> array[ix];
  l1 -> size += l2 -> size;
  return (l1);
}

/* Insert element into grammar_list at pos 'pos' */
grammar_list insert_grammar_list (grammar_list l, int pos, grammar el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_grammar_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_grammar_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into prule_list at pos 'pos' */
prule_list insert_prule_list (prule_list l, int pos, prule el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_prule_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_prule_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into plhs_list at pos 'pos' */
plhs_list insert_plhs_list (plhs_list l, int pos, plhs el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_plhs_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_plhs_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into rule_list at pos 'pos' */
rule_list insert_rule_list (rule_list l, int pos, rule el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_rule_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_rule_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into rdecl_list at pos 'pos' */
rdecl_list insert_rdecl_list (rdecl_list l, int pos, rdecl el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_rdecl_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_rdecl_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into variable_list at pos 'pos' */
variable_list insert_variable_list (variable_list l, int pos, variable el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_variable_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_variable_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into definition_list at pos 'pos' */
definition_list insert_definition_list (definition_list l, int pos, definition el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_definition_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_definition_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into fpar_list at pos 'pos' */
fpar_list insert_fpar_list (fpar_list l, int pos, fpar el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_fpar_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_fpar_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into dir_list at pos 'pos' */
dir_list insert_dir_list (dir_list l, int pos, dir el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_dir_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_dir_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into alternative_list at pos 'pos' */
alternative_list insert_alternative_list (alternative_list l, int pos, alternative el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_alternative_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_alternative_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into fwo_group_list at pos 'pos' */
fwo_group_list insert_fwo_group_list (fwo_group_list l, int pos, fwo_group el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_fwo_group_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_fwo_group_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into member_list at pos 'pos' */
member_list insert_member_list (member_list l, int pos, member el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_member_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_member_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into apar_list at pos 'pos' */
apar_list insert_apar_list (apar_list l, int pos, apar el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_apar_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_apar_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into confrontation_list at pos 'pos' */
confrontation_list insert_confrontation_list (confrontation_list l, int pos, confrontation el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_confrontation_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_confrontation_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into res_conf_list at pos 'pos' */
res_conf_list insert_res_conf_list (res_conf_list l, int pos, res_conf el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_res_conf_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_res_conf_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into affix_term_list at pos 'pos' */
affix_term_list insert_affix_term_list (affix_term_list l, int pos, affix_term el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_affix_term_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_affix_term_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into trans_member_list at pos 'pos' */
trans_member_list insert_trans_member_list (trans_member_list l, int pos, trans_member el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_trans_member_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_trans_member_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into affix_rule_list at pos 'pos' */
affix_rule_list insert_affix_rule_list (affix_rule_list l, int pos, affix_rule el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_affix_rule_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_affix_rule_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into affix_alternative_list at pos 'pos' */
affix_alternative_list insert_affix_alternative_list (affix_alternative_list l, int pos, affix_alternative el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_affix_alternative_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_affix_alternative_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into affix_element_list at pos 'pos' */
affix_element_list insert_affix_element_list (affix_element_list l, int pos, affix_element el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_affix_element_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_affix_element_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into invisible_nonterminal_list at pos 'pos' */
invisible_nonterminal_list insert_invisible_nonterminal_list (invisible_nonterminal_list l, int pos, invisible_nonterminal el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_invisible_nonterminal_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_invisible_nonterminal_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into element_list at pos 'pos' */
element_list insert_element_list (element_list l, int pos, element el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_element_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_element_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into domain_list at pos 'pos' */
domain_list insert_domain_list (domain_list l, int pos, domain el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_domain_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_domain_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into regexp_list at pos 'pos' */
regexp_list insert_regexp_list (regexp_list l, int pos, regexp el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_regexp_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_regexp_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into name_list at pos 'pos' */
name_list insert_name_list (name_list l, int pos, name el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_name_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_name_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into call_solution_list at pos 'pos' */
call_solution_list insert_call_solution_list (call_solution_list l, int pos, call_solution el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_call_solution_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_call_solution_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Insert element into madm_list at pos 'pos' */
madm_list insert_madm_list (madm_list l, int pos, madm el)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos > l -> size))
    dcg_panic ("insert_madm_list: position %d out of range", pos);
  if (l -> size == l -> room)
    room_madm_list (l, l -> size << 1);
  for (ix = l -> size; pos < ix; ix--)
    l -> array[ix] = l -> array[ix-1];
  l -> array[pos] = el;
  l -> size++;
  return (l);
}

/* Delete element from grammar_list at pos 'pos' */
grammar_list delete_grammar_list (grammar_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_grammar_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from prule_list at pos 'pos' */
prule_list delete_prule_list (prule_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_prule_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from plhs_list at pos 'pos' */
plhs_list delete_plhs_list (plhs_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_plhs_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from rule_list at pos 'pos' */
rule_list delete_rule_list (rule_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_rule_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from rdecl_list at pos 'pos' */
rdecl_list delete_rdecl_list (rdecl_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_rdecl_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from variable_list at pos 'pos' */
variable_list delete_variable_list (variable_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_variable_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from definition_list at pos 'pos' */
definition_list delete_definition_list (definition_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_definition_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from fpar_list at pos 'pos' */
fpar_list delete_fpar_list (fpar_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_fpar_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from dir_list at pos 'pos' */
dir_list delete_dir_list (dir_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_dir_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from alternative_list at pos 'pos' */
alternative_list delete_alternative_list (alternative_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_alternative_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from fwo_group_list at pos 'pos' */
fwo_group_list delete_fwo_group_list (fwo_group_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_fwo_group_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from member_list at pos 'pos' */
member_list delete_member_list (member_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_member_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from apar_list at pos 'pos' */
apar_list delete_apar_list (apar_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_apar_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from confrontation_list at pos 'pos' */
confrontation_list delete_confrontation_list (confrontation_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_confrontation_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from res_conf_list at pos 'pos' */
res_conf_list delete_res_conf_list (res_conf_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_res_conf_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from affix_term_list at pos 'pos' */
affix_term_list delete_affix_term_list (affix_term_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_affix_term_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from trans_member_list at pos 'pos' */
trans_member_list delete_trans_member_list (trans_member_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_trans_member_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from affix_rule_list at pos 'pos' */
affix_rule_list delete_affix_rule_list (affix_rule_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_affix_rule_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from affix_alternative_list at pos 'pos' */
affix_alternative_list delete_affix_alternative_list (affix_alternative_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_affix_alternative_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from affix_element_list at pos 'pos' */
affix_element_list delete_affix_element_list (affix_element_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_affix_element_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from invisible_nonterminal_list at pos 'pos' */
invisible_nonterminal_list delete_invisible_nonterminal_list (invisible_nonterminal_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_invisible_nonterminal_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from element_list at pos 'pos' */
element_list delete_element_list (element_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_element_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from domain_list at pos 'pos' */
domain_list delete_domain_list (domain_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_domain_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from regexp_list at pos 'pos' */
regexp_list delete_regexp_list (regexp_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_regexp_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from name_list at pos 'pos' */
name_list delete_name_list (name_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_name_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from call_solution_list at pos 'pos' */
call_solution_list delete_call_solution_list (call_solution_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_call_solution_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Delete element from madm_list at pos 'pos' */
madm_list delete_madm_list (madm_list l, int pos)
{ int ix;
  dcg_cknonshared ((char *) l);
  if ((pos < 0) || (pos >= l -> size))
    dcg_panic ("delete_madm_list: position %d out of range", pos);
  for (ix = pos; ix < l -> size - 1; ix++)
    l -> array[ix] = l -> array[ix+1];
  l -> size--;
  return (l);
}

/* Comparison test for a grammar */
int cmp_grammar (grammar a, grammar b)
{ int s;
  if (a == b) return (0);
  if (a == grammar_nil) return (-1);
  if (b == grammar_nil) return (1);
  if ((s = cmp_string (a -> fname, b -> fname))) return (s);
  if ((s = cmp_string (a -> gname, b -> gname))) return (s);
  if ((s = cmp_string_list (a -> uses, b -> uses))) return (s);
  if ((s = cmp_string_list (a -> lexica, b -> lexica))) return (s);
  if ((s = cmp_string_list (a -> fact_tables, b -> fact_tables))) return (s);
  if ((s = cmp_string_list (a -> triple_databases, b -> triple_databases))) return (s);
  if ((s = cmp_prule_list (a -> exp_prules, b -> exp_prules))) return (s);
  if ((s = cmp_prule_list (a -> prules, b -> prules))) return (s);
  if ((s = cmp_affix_rule_list (a -> arules, b -> arules))) return (s);
  if ((s = cmp_member (a -> root_call, b -> root_call))) return (s);
  return (0);
}

/* Comparison test for a prule */
int cmp_prule (prule a, prule b)
{ int s;
  if (a == b) return (0);
  if (a == prule_nil) return (-1);
  if (b == prule_nil) return (1);
  if ((s = cmp_plhs (a -> lhs, b -> lhs))) return (s);
  if ((s = cmp_int ((int)(a -> tag), (int)(b -> tag)))) return (s);
  switch (a -> tag)
    { case TAGExt_prule:
	if ((s = cmp_string (a -> Ext_prule.ename, b -> Ext_prule.ename))) return (s);
	break;
      case TAGQuasi_prule:
	if ((s = cmp_string (a -> Quasi_prule.rname, b -> Quasi_prule.rname))) return (s);
	break;
      case TAGProto_rule:
	if ((s = cmp_group (a -> Proto_rule.grp, b -> Proto_rule.grp))) return (s);
	break;
      case TAGPspec:
	break;
      case TAGPstart:
	break;
      default:
	dcg_bad_tag (a -> tag, "cmp_prule");
    };
  return (0);
}

/* Comparison test for a plhs */
int cmp_plhs (plhs a, plhs b)
{ int s;
  if (a == b) return (0);
  if (a == plhs_nil) return (-1);
  if (b == plhs_nil) return (1);
  if ((s = cmp_int (a -> line, b -> line))) return (s);
  if ((s = cmp_int (a -> col, b -> col))) return (s);
  if ((s = cmp_rule_layer (a -> rlayer, b -> rlayer))) return (s);
  if ((s = cmp_rule_kind (a -> rkind, b -> rkind))) return (s);
  if ((s = cmp_rule_type (a -> rtype, b -> rtype))) return (s);
  if ((s = cmp_string_list (a -> rname_parts, b -> rname_parts))) return (s);
  if ((s = cmp_int_list (a -> rname_chars, b -> rname_chars))) return (s);
  if ((s = cmp_fpar_list (a -> lhs_pars, b -> lhs_pars))) return (s);
  return (0);
}

/* Comparison test for a rule */
int cmp_rule (rule a, rule b)
{ int s;
  if (a == b) return (0);
  if (a == rule_nil) return (-1);
  if (b == rule_nil) return (1);
  if ((s = cmp_spec (a -> rspec, b -> rspec))) return (s);
  if ((s = cmp_int ((int)(a -> tag), (int)(b -> tag)))) return (s);
  switch (a -> tag)
    { case TAGExt_rule:
	if ((s = cmp_string (a -> Ext_rule.ename, b -> Ext_rule.ename))) return (s);
	break;
      case TAGQuasi_rule:
	if ((s = cmp_string (a -> Quasi_rule.rname, b -> Quasi_rule.rname))) return (s);
	break;
      case TAGDefs:
	if ((s = cmp_definition_list (a -> Defs.defs, b -> Defs.defs))) return (s);
	break;
      case TAGAnonymous_option:
	if ((s = cmp_group (a -> Anonymous_option.grp, b -> Anonymous_option.grp))) return (s);
	break;
      case TAGAnonymous_group:
	if ((s = cmp_group (a -> Anonymous_group.grp, b -> Anonymous_group.grp))) return (s);
	break;
      default:
	dcg_bad_tag (a -> tag, "cmp_rule");
    };
  return (0);
}

/* Comparison test for a spec */
int cmp_spec (spec a, spec b)
{ int s;
  if (a == b) return (0);
  if (a == spec_nil) return (-1);
  if (b == spec_nil) return (1);
  if ((s = cmp_rule_layer (a -> rlayer, b -> rlayer))) return (s);
  if ((s = cmp_rule_kind (a -> rkind, b -> rkind))) return (s);
  if ((s = cmp_rule_type (a -> rtype, b -> rtype))) return (s);
  if ((s = cmp_string_list (a -> rname_parts, b -> rname_parts))) return (s);
  if ((s = cmp_int_list (a -> rname_chars, b -> rname_chars))) return (s);
  if ((s = cmp_affix_rule_list (a -> rsig, b -> rsig))) return (s);
  if ((s = cmp_dir_list (a -> dirs, b -> dirs))) return (s);
  return (0);
}

/* Comparison test for a rdecl */
int cmp_rdecl (rdecl a, rdecl b)
{ 
  if (a == b) return (0);
  if (a == rdecl_nil) return (-1);
  if (b == rdecl_nil) return (1);
  return (0);
}

/* Comparison test for a variable */
int cmp_variable (variable a, variable b)
{ int s;
  if (a == b) return (0);
  if (a == variable_nil) return (-1);
  if (b == variable_nil) return (1);
  if ((s = cmp_string (a -> vname, b -> vname))) return (s);
  return (0);
}

/* Comparison test for a definition */
int cmp_definition (definition a, definition b)
{ int s;
  if (a == b) return (0);
  if (a == definition_nil) return (-1);
  if (b == definition_nil) return (1);
  if ((s = cmp_fpar_list (a -> lhs_pars, b -> lhs_pars))) return (s);
  if ((s = cmp_variable_list (a -> locals, b -> locals))) return (s);
  if ((s = cmp_group (a -> grp, b -> grp))) return (s);
  return (0);
}

/* Comparison test for a fpar */
int cmp_fpar (fpar a, fpar b)
{ int s;
  if (a == b) return (0);
  if (a == fpar_nil) return (-1);
  if (b == fpar_nil) return (1);
  if ((s = cmp_int (a -> line, b -> line))) return (s);
  if ((s = cmp_int (a -> col, b -> col))) return (s);
  if ((s = cmp_dir (a -> fdir, b -> fdir))) return (s);
  if ((s = cmp_affix_term_list (a -> fexp, b -> fexp))) return (s);
  return (0);
}

/* Comparison test for a group */
int cmp_group (group a, group b)
{ int s;
  if (a == b) return (0);
  if (a == group_nil) return (-1);
  if (b == group_nil) return (1);
  if ((s = cmp_alternative_list (a -> alts, b -> alts))) return (s);
  return (0);
}

/* Comparison test for a alternative */
int cmp_alternative (alternative a, alternative b)
{ int s;
  if (a == b) return (0);
  if (a == alternative_nil) return (-1);
  if (b == alternative_nil) return (1);
  if ((s = cmp_int (a -> line, b -> line))) return (s);
  if ((s = cmp_int (a -> col, b -> col))) return (s);
  if ((s = cmp_real (a -> freq, b -> freq))) return (s);
  if ((s = cmp_fwo_group_list (a -> members, b -> members))) return (s);
  if ((s = cmp_int (a -> commited, b -> commited))) return (s);
  if ((s = cmp_trans_member_list (a -> trans, b -> trans))) return (s);
  return (0);
}

/* Comparison test for a fwo_group */
int cmp_fwo_group (fwo_group a, fwo_group b)
{ int s;
  if (a == b) return (0);
  if (a == fwo_group_nil) return (-1);
  if (b == fwo_group_nil) return (1);
  if ((s = cmp_glue (a -> gl, b -> gl))) return (s);
  if ((s = cmp_int ((int)(a -> tag), (int)(b -> tag)))) return (s);
  switch (a -> tag)
    { case TAGSingle:
	if ((s = cmp_member (a -> Single.mem, b -> Single.mem))) return (s);
	break;
      case TAGFwo:
	if ((s = cmp_member_list (a -> Fwo.mems, b -> Fwo.mems))) return (s);
	break;
      default:
	dcg_bad_tag (a -> tag, "cmp_fwo_group");
    };
  return (0);
}

/* Comparison test for a member */
int cmp_member (member a, member b)
{ int s;
  if (a == b) return (0);
  if (a == member_nil) return (-1);
  if (b == member_nil) return (1);
  if ((s = cmp_int (a -> line, b -> line))) return (s);
  if ((s = cmp_int (a -> col, b -> col))) return (s);
  if ((s = cmp_int ((int)(a -> tag), (int)(b -> tag)))) return (s);
  switch (a -> tag)
    { case TAGCall:
	if ((s = cmp_string_list (a -> Call.rname_parts, b -> Call.rname_parts))) return (s);
	if ((s = cmp_int_list (a -> Call.rname_chars, b -> Call.rname_chars))) return (s);
	if ((s = cmp_apar_list (a -> Call.apars, b -> Call.apars))) return (s);
	break;
      case TAGGuard:
	if ((s = cmp_confrontation_list (a -> Guard.confs, b -> Guard.confs))) return (s);
	break;
      case TAGTerm:
	if ((s = cmp_string (a -> Term.text, b -> Term.text))) return (s);
	if ((s = cmp_apar (a -> Term.par, b -> Term.par))) return (s);
	break;
      case TAGQuasi:
	if ((s = cmp_string_list (a -> Quasi.qname_parts, b -> Quasi.qname_parts))) return (s);
	if ((s = cmp_int_list (a -> Quasi.qname_chars, b -> Quasi.qname_chars))) return (s);
	if ((s = cmp_apar_list (a -> Quasi.args, b -> Quasi.args))) return (s);
	break;
      case TAGOp:
	if ((s = cmp_control_op (a -> Op.op, b -> Op.op))) return (s);
	break;
      case TAGGroup:
	if ((s = cmp_group (a -> Group.grp, b -> Group.grp))) return (s);
	break;
      case TAGOption:
	if ((s = cmp_group (a -> Option.grp, b -> Option.grp))) return (s);
	break;
      case TAGRes_guard:
	if ((s = cmp_res_conf_list (a -> Res_guard.rconfs, b -> Res_guard.rconfs))) return (s);
	break;
      case TAGRes_call:
	if ((s = cmp_affix_term_list (a -> Res_call.args, b -> Res_call.args))) return (s);
	if ((s = cmp_dir_list (a -> Res_call.adirs, b -> Res_call.adirs))) return (s);
	break;
      case TAGRes_term:
	if ((s = cmp_string (a -> Res_term.text, b -> Res_term.text))) return (s);
	if ((s = cmp_dir (a -> Res_term.adir, b -> Res_term.adir))) return (s);
	if ((s = cmp_affix_term (a -> Res_term.arg, b -> Res_term.arg))) return (s);
	break;
      default:
	dcg_bad_tag (a -> tag, "cmp_member");
    };
  return (0);
}

/* Comparison test for a apar */
int cmp_apar (apar a, apar b)
{ int s;
  if (a == b) return (0);
  if (a == apar_nil) return (-1);
  if (b == apar_nil) return (1);
  if ((s = cmp_dir (a -> adir, b -> adir))) return (s);
  if ((s = cmp_affix_term_list (a -> aexp, b -> aexp))) return (s);
  return (0);
}

/* Comparison test for a confrontation */
int cmp_confrontation (confrontation a, confrontation b)
{ int s;
  if (a == b) return (0);
  if (a == confrontation_nil) return (-1);
  if (b == confrontation_nil) return (1);
  if ((s = cmp_int (a -> line, b -> line))) return (s);
  if ((s = cmp_int (a -> col, b -> col))) return (s);
  if ((s = cmp_guard_type (a -> typ, b -> typ))) return (s);
  if ((s = cmp_affix_term_list (a -> lhs, b -> lhs))) return (s);
  if ((s = cmp_affix_term_list (a -> rhs, b -> rhs))) return (s);
  return (0);
}

/* Comparison test for a res_conf */
int cmp_res_conf (res_conf a, res_conf b)
{ int s;
  if (a == b) return (0);
  if (a == res_conf_nil) return (-1);
  if (b == res_conf_nil) return (1);
  if ((s = cmp_guard_type (a -> typ, b -> typ))) return (s);
  if ((s = cmp_affix_term (a -> lhs, b -> lhs))) return (s);
  if ((s = cmp_affix_term (a -> rhs, b -> rhs))) return (s);
  return (0);
}

/* Comparison test for a affix_term */
int cmp_affix_term (affix_term a, affix_term b)
{ int s;
  if (a == b) return (0);
  if (a == affix_term_nil) return (-1);
  if (b == affix_term_nil) return (1);
  if ((s = cmp_int (a -> line, b -> line))) return (s);
  if ((s = cmp_int (a -> col, b -> col))) return (s);
  if ((s = cmp_int ((int)(a -> tag), (int)(b -> tag)))) return (s);
  switch (a -> tag)
    { case TAGTerminal:
	if ((s = cmp_string (a -> Terminal.marker, b -> Terminal.marker))) return (s);
	break;
      case TAGDyop:
	if ((s = cmp_operator (a -> Dyop.dop, b -> Dyop.dop))) return (s);
	if ((s = cmp_affix_term (a -> Dyop.arg1, b -> Dyop.arg1))) return (s);
	if ((s = cmp_affix_term (a -> Dyop.arg2, b -> Dyop.arg2))) return (s);
	break;
      case TAGMonop:
	if ((s = cmp_operator (a -> Monop.mop, b -> Monop.mop))) return (s);
	if ((s = cmp_affix_term (a -> Monop.arg, b -> Monop.arg))) return (s);
	break;
      case TAGEnclosed:
	if ((s = cmp_affix_term_list (a -> Enclosed.terms, b -> Enclosed.terms))) return (s);
	break;
      case TAGAst:
	if ((s = cmp_affix_term_list (a -> Ast.terms, b -> Ast.terms))) return (s);
	if ((s = cmp_int (a -> Ast.altnr, b -> Ast.altnr))) return (s);
	break;
      case TAGConcat:
	if ((s = cmp_affix_term_list (a -> Concat.terms, b -> Concat.terms))) return (s);
	break;
      case TAGInt:
	if ((s = cmp_int (a -> Int.num, b -> Int.num))) return (s);
	break;
      case TAGReal:
	if ((s = cmp_real (a -> Real.num, b -> Real.num))) return (s);
	break;
      case TAGText:
	if ((s = cmp_string (a -> Text.txt, b -> Text.txt))) return (s);
	break;
      case TAGRegexp:
	if ((s = cmp_string (a -> Regexp.text, b -> Regexp.text))) return (s);
	break;
      case TAGVar:
	if ((s = cmp_string (a -> Var.aname, b -> Var.aname))) return (s);
	break;
      default:
	dcg_bad_tag (a -> tag, "cmp_affix_term");
    };
  return (0);
}

/* Comparison test for a trans_member */
int cmp_trans_member (trans_member a, trans_member b)
{ int s;
  if (a == b) return (0);
  if (a == trans_member_nil) return (-1);
  if (b == trans_member_nil) return (1);
  if ((s = cmp_int (a -> line, b -> line))) return (s);
  if ((s = cmp_int (a -> col, b -> col))) return (s);
  if ((s = cmp_glue (a -> gl, b -> gl))) return (s);
  if ((s = cmp_int ((int)(a -> tag), (int)(b -> tag)))) return (s);
  switch (a -> tag)
    { case TAGTcall:
	if ((s = cmp_string_list (a -> Tcall.cname, b -> Tcall.cname))) return (s);
	if ((s = cmp_int (a -> Tcall.nr, b -> Tcall.nr))) return (s);
	break;
      case TAGTquasi:
	if ((s = cmp_string (a -> Tquasi.qname, b -> Tquasi.qname))) return (s);
	if ((s = cmp_int (a -> Tquasi.nr, b -> Tquasi.nr))) return (s);
	break;
      case TAGTgroup:
	if ((s = cmp_int (a -> Tgroup.nr, b -> Tgroup.nr))) return (s);
	break;
      case TAGToption:
	if ((s = cmp_int (a -> Toption.nr, b -> Toption.nr))) return (s);
	break;
      case TAGTtext:
	if ((s = cmp_string (a -> Ttext.text, b -> Ttext.text))) return (s);
	break;
      case TAGTvar:
	if ((s = cmp_string (a -> Tvar.aname, b -> Tvar.aname))) return (s);
	break;
      case TAGThybrid:
	if ((s = cmp_hyb_op (a -> Thybrid.op, b -> Thybrid.op))) return (s);
	break;
      default:
	dcg_bad_tag (a -> tag, "cmp_trans_member");
    };
  return (0);
}

/* Comparison test for a hyb_op */
int cmp_hyb_op (hyb_op a, hyb_op b)
{ int s;
  if (a == b) return (0);
  if (a == hyb_op_nil) return (-1);
  if (b == hyb_op_nil) return (1);
  if ((s = cmp_int ((int)(a -> tag), (int)(b -> tag)))) return (s);
  switch (a -> tag)
    { case TAGHyb_sqr_open:
	break;
      case TAGHyb_sqr_close:
	break;
      case TAGHyb_curl_open:
	break;
      case TAGHyb_curl_close:
	break;
      case TAGHyb_bar:
	break;
      case TAGHyb_rel_left:
	if ((s = cmp_string (a -> Hyb_rel_left.rname, b -> Hyb_rel_left.rname))) return (s);
	break;
      case TAGHyb_rel_right:
	if ((s = cmp_string (a -> Hyb_rel_right.rname, b -> Hyb_rel_right.rname))) return (s);
	break;
      default:
	dcg_bad_tag (a -> tag, "cmp_hyb_op");
    };
  return (0);
}

/* Comparison test for a affix_rule */
int cmp_affix_rule (affix_rule a, affix_rule b)
{ int s;
  if (a == b) return (0);
  if (a == affix_rule_nil) return (-1);
  if (b == affix_rule_nil) return (1);
  if ((s = cmp_int (a -> line, b -> line))) return (s);
  if ((s = cmp_int (a -> col, b -> col))) return (s);
  if ((s = cmp_string (a -> aname, b -> aname))) return (s);
  if ((s = cmp_int ((int)(a -> tag), (int)(b -> tag)))) return (s);
  switch (a -> tag)
    { case TAGAffix_synonym:
	if ((s = cmp_string (a -> Affix_synonym.syn, b -> Affix_synonym.syn))) return (s);
	break;
      case TAGAffix_alts:
	if ((s = cmp_affix_alternative_list (a -> Affix_alts.alts, b -> Affix_alts.alts))) return (s);
	break;
      case TAGAffix_prim:
	break;
      default:
	dcg_bad_tag (a -> tag, "cmp_affix_rule");
    };
  return (0);
}

/* Comparison test for a affix_alternative */
int cmp_affix_alternative (affix_alternative a, affix_alternative b)
{ int s;
  if (a == b) return (0);
  if (a == affix_alternative_nil) return (-1);
  if (b == affix_alternative_nil) return (1);
  if ((s = cmp_affix_element_list (a -> elems, b -> elems))) return (s);
  if ((s = cmp_int ((int)(a -> tag), (int)(b -> tag)))) return (s);
  switch (a -> tag)
    { case TAGAffix_sequence:
	break;
      case TAGAffix_concat:
	break;
      case TAGAffix_union:
	break;
      case TAGAffix_partition:
	break;
      case TAGAffix_single:
	break;
      case TAGAffix_empty:
	break;
      default:
	dcg_bad_tag (a -> tag, "cmp_affix_alternative");
    };
  return (0);
}

/* Comparison test for a affix_element */
int cmp_affix_element (affix_element a, affix_element b)
{ int s;
  if (a == b) return (0);
  if (a == affix_element_nil) return (-1);
  if (b == affix_element_nil) return (1);
  if ((s = cmp_int (a -> line, b -> line))) return (s);
  if ((s = cmp_int (a -> col, b -> col))) return (s);
  if ((s = cmp_int ((int)(a -> tag), (int)(b -> tag)))) return (s);
  switch (a -> tag)
    { case TAGAffix_var:
	if ((s = cmp_string (a -> Affix_var.vname, b -> Affix_var.vname))) return (s);
	break;
      case TAGAffix_term:
	if ((s = cmp_string (a -> Affix_term.tname, b -> Affix_term.tname))) return (s);
	break;
      case TAGAffix_text:
	if ((s = cmp_string (a -> Affix_text.text, b -> Affix_text.text))) return (s);
	break;
      case TAGAffix_inum:
	if ((s = cmp_int (a -> Affix_inum.ival, b -> Affix_inum.ival))) return (s);
	break;
      case TAGAffix_rnum:
	if ((s = cmp_real (a -> Affix_rnum.rval, b -> Affix_rnum.rval))) return (s);
	break;
      default:
	dcg_bad_tag (a -> tag, "cmp_affix_element");
    };
  return (0);
}

/* Comparison test for a invisible_nonterminal */
int cmp_invisible_nonterminal (invisible_nonterminal a, invisible_nonterminal b)
{ int s;
  if (a == b) return (0);
  if (a == invisible_nonterminal_nil) return (-1);
  if (b == invisible_nonterminal_nil) return (1);
  if ((s = cmp_string (a -> fname, b -> fname))) return (s);
  if ((s = cmp_int (a -> line, b -> line))) return (s);
  if ((s = cmp_int (a -> col, b -> col))) return (s);
  if ((s = cmp_string_list (a -> name, b -> name))) return (s);
  if ((s = cmp_int (a -> arity, b -> arity))) return (s);
  return (0);
}

/* Comparison test for a element */
int cmp_element (element a, element b)
{ int s;
  if (a == b) return (0);
  if (a == element_nil) return (-1);
  if (b == element_nil) return (1);
  if ((s = cmp_string (a -> name, b -> name))) return (s);
  return (0);
}

/* Comparison test for a domain */
int cmp_domain (domain a, domain b)
{ int s;
  if (a == b) return (0);
  if (a == domain_nil) return (-1);
  if (b == domain_nil) return (1);
  if ((s = cmp_int_list (a -> elts, b -> elts))) return (s);
  return (0);
}

/* Comparison test for a regexp */
int cmp_regexp (regexp a, regexp b)
{ int s;
  if (a == b) return (0);
  if (a == regexp_nil) return (-1);
  if (b == regexp_nil) return (1);
  if ((s = cmp_int ((int)(a -> tag), (int)(b -> tag)))) return (s);
  switch (a -> tag)
    { case TAGRegexp_or:
	if ((s = cmp_regexp_list (a -> Regexp_or.subs, b -> Regexp_or.subs))) return (s);
	break;
      case TAGRegexp_concat:
	if ((s = cmp_regexp_list (a -> Regexp_concat.subs, b -> Regexp_concat.subs))) return (s);
	break;
      case TAGRegexp_star:
	if ((s = cmp_regexp (a -> Regexp_star.sub, b -> Regexp_star.sub))) return (s);
	break;
      case TAGRegexp_plus:
	if ((s = cmp_regexp (a -> Regexp_plus.sub, b -> Regexp_plus.sub))) return (s);
	break;
      case TAGRegexp_opt:
	if ((s = cmp_regexp (a -> Regexp_opt.sub, b -> Regexp_opt.sub))) return (s);
	break;
      case TAGRegexp_cset:
	if ((s = cmp_int (a -> Regexp_cset.cs, b -> Regexp_cset.cs))) return (s);
	break;
      case TAGRegexp_char:
	if ((s = cmp_int (a -> Regexp_char.ch, b -> Regexp_char.ch))) return (s);
	break;
      case TAGRegexp_anychar:
	break;
      case TAGRegexp_whitespace:
	break;
      case TAGRegexp_nonwhitespace:
	break;
      case TAGRegexp_empty:
	break;
      default:
	dcg_bad_tag (a -> tag, "cmp_regexp");
    };
  return (0);
}

/* Comparison test for a name */
int cmp_name (name a, name b)
{ int s;
  if (a == b) return (0);
  if (a == name_nil) return (-1);
  if (b == name_nil) return (1);
  if ((s = cmp_int (a -> line, b -> line))) return (s);
  if ((s = cmp_int (a -> col, b -> col))) return (s);
  if ((s = cmp_string_list (a -> id, b -> id))) return (s);
  return (0);
}

/* Comparison test for a call_solution */
int cmp_call_solution (call_solution a, call_solution b)
{ int s;
  if (a == b) return (0);
  if (a == call_solution_nil) return (-1);
  if (b == call_solution_nil) return (1);
  if ((s = cmp_affix_term_list (a -> apars, b -> apars))) return (s);
  if ((s = cmp_int (a -> nr_matches, b -> nr_matches))) return (s);
  return (0);
}

/* Comparison test for a madm */
int cmp_madm (madm a, madm b)
{ int s;
  if (a == b) return (0);
  if (a == madm_nil) return (-1);
  if (b == madm_nil) return (1);
  if ((s = cmp_int ((int)(a -> tag), (int)(b -> tag)))) return (s);
  switch (a -> tag)
    { case TAGRule_adm:
	break;
      case TAGMember_adm:
	if ((s = cmp_int (a -> Member_adm.alt_nr, b -> Member_adm.alt_nr))) return (s);
	if ((s = cmp_int (a -> Member_adm.mem_nr, b -> Member_adm.mem_nr))) return (s);
	break;
      default:
	dcg_bad_tag (a -> tag, "cmp_madm");
    };
  return (0);
}

/* Comparison test for a grammar_list */
int cmp_grammar_list (grammar_list a, grammar_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == grammar_list_nil) return (-1);
  if (b == grammar_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_grammar (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a prule_list */
int cmp_prule_list (prule_list a, prule_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == prule_list_nil) return (-1);
  if (b == prule_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_prule (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a plhs_list */
int cmp_plhs_list (plhs_list a, plhs_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == plhs_list_nil) return (-1);
  if (b == plhs_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_plhs (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a rule_list */
int cmp_rule_list (rule_list a, rule_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == rule_list_nil) return (-1);
  if (b == rule_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_rule (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a rdecl_list */
int cmp_rdecl_list (rdecl_list a, rdecl_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == rdecl_list_nil) return (-1);
  if (b == rdecl_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_rdecl (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a variable_list */
int cmp_variable_list (variable_list a, variable_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == variable_list_nil) return (-1);
  if (b == variable_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_variable (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a definition_list */
int cmp_definition_list (definition_list a, definition_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == definition_list_nil) return (-1);
  if (b == definition_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_definition (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a fpar_list */
int cmp_fpar_list (fpar_list a, fpar_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == fpar_list_nil) return (-1);
  if (b == fpar_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_fpar (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a dir_list */
int cmp_dir_list (dir_list a, dir_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == dir_list_nil) return (-1);
  if (b == dir_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_dir (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a alternative_list */
int cmp_alternative_list (alternative_list a, alternative_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == alternative_list_nil) return (-1);
  if (b == alternative_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_alternative (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a fwo_group_list */
int cmp_fwo_group_list (fwo_group_list a, fwo_group_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == fwo_group_list_nil) return (-1);
  if (b == fwo_group_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_fwo_group (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a member_list */
int cmp_member_list (member_list a, member_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == member_list_nil) return (-1);
  if (b == member_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_member (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a apar_list */
int cmp_apar_list (apar_list a, apar_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == apar_list_nil) return (-1);
  if (b == apar_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_apar (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a confrontation_list */
int cmp_confrontation_list (confrontation_list a, confrontation_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == confrontation_list_nil) return (-1);
  if (b == confrontation_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_confrontation (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a res_conf_list */
int cmp_res_conf_list (res_conf_list a, res_conf_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == res_conf_list_nil) return (-1);
  if (b == res_conf_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_res_conf (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a affix_term_list */
int cmp_affix_term_list (affix_term_list a, affix_term_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == affix_term_list_nil) return (-1);
  if (b == affix_term_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_affix_term (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a trans_member_list */
int cmp_trans_member_list (trans_member_list a, trans_member_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == trans_member_list_nil) return (-1);
  if (b == trans_member_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_trans_member (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a affix_rule_list */
int cmp_affix_rule_list (affix_rule_list a, affix_rule_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == affix_rule_list_nil) return (-1);
  if (b == affix_rule_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_affix_rule (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a affix_alternative_list */
int cmp_affix_alternative_list (affix_alternative_list a, affix_alternative_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == affix_alternative_list_nil) return (-1);
  if (b == affix_alternative_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_affix_alternative (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a affix_element_list */
int cmp_affix_element_list (affix_element_list a, affix_element_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == affix_element_list_nil) return (-1);
  if (b == affix_element_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_affix_element (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a invisible_nonterminal_list */
int cmp_invisible_nonterminal_list (invisible_nonterminal_list a, invisible_nonterminal_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == invisible_nonterminal_list_nil) return (-1);
  if (b == invisible_nonterminal_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_invisible_nonterminal (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a element_list */
int cmp_element_list (element_list a, element_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == element_list_nil) return (-1);
  if (b == element_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_element (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a domain_list */
int cmp_domain_list (domain_list a, domain_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == domain_list_nil) return (-1);
  if (b == domain_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_domain (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a regexp_list */
int cmp_regexp_list (regexp_list a, regexp_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == regexp_list_nil) return (-1);
  if (b == regexp_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_regexp (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a name_list */
int cmp_name_list (name_list a, name_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == name_list_nil) return (-1);
  if (b == name_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_name (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a call_solution_list */
int cmp_call_solution_list (call_solution_list a, call_solution_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == call_solution_list_nil) return (-1);
  if (b == call_solution_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_call_solution (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Comparison test for a madm_list */
int cmp_madm_list (madm_list a, madm_list b)
{ int ix, stat, size;
  if (a == b) return (0);
  if (a == madm_list_nil) return (-1);
  if (b == madm_list_nil) return (1);
  size = a -> size;
  if (b -> size < size) size = b -> size;
  for (ix = 0; ix < size; ix++)
    if ((stat = cmp_madm (a -> array[ix], b -> array[ix])))
      return (stat);
  return (cmp_int (a -> size, b -> size));
}

/* Estimate printing a grammar */
int est_grammar (grammar old)
{ int size = 0;
  if (old == grammar_nil) return (2);
  size += est_string (old -> fname) + 2;
  size += est_string (old -> gname) + 2;
  size += est_string_list (old -> uses) + 2;
  size += est_string_list (old -> lexica) + 2;
  size += est_string_list (old -> fact_tables) + 2;
  size += est_string_list (old -> triple_databases) + 2;
  size += est_prule_list (old -> exp_prules) + 2;
  size += est_prule_list (old -> prules) + 2;
  size += est_affix_rule_list (old -> arules) + 2;
  size += est_member (old -> root_call) + 2;
  size += PTRWIDTH;
  return (size + 2);
}

/* Estimate printing a prule */
int est_prule (prule old)
{ int size = 0;
  if (old == prule_nil) return (2);
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += est_plhs (old -> lhs) + 2;
  switch (old -> tag)
    { case TAGExt_prule:
	size += 11;
	size += est_string (old -> Ext_prule.ename) + 2;
	break;
      case TAGQuasi_prule:
	size += 13;
	size += est_string (old -> Quasi_prule.rname) + 2;
	break;
      case TAGProto_rule:
	size += 12;
	size += est_group (old -> Proto_rule.grp) + 2;
	break;
      case TAGPspec:
	size += 7;
	break;
      case TAGPstart:
	size += 8;
	break;
      default:
	dcg_bad_tag (old -> tag, "est_prule");
    };
  return (size + 2);
}

/* Estimate printing a plhs */
int est_plhs (plhs old)
{ int size = 0;
  if (old == plhs_nil) return (2);
  size += est_int (old -> line) + 2;
  size += est_int (old -> col) + 2;
  size += est_rule_layer (old -> rlayer) + 2;
  size += est_rule_kind (old -> rkind) + 2;
  size += est_rule_type (old -> rtype) + 2;
  size += est_string_list (old -> rname_parts) + 2;
  size += est_int_list (old -> rname_chars) + 2;
  size += est_fpar_list (old -> lhs_pars) + 2;
  return (size + 2);
}

/* Estimate printing a rule */
int est_rule (rule old)
{ int size = 0;
  if (old == rule_nil) return (2);
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += est_spec (old -> rspec) + 2;
  switch (old -> tag)
    { case TAGExt_rule:
	size += 10;
	size += est_string (old -> Ext_rule.ename) + 2;
	break;
      case TAGQuasi_rule:
	size += 12;
	size += est_string (old -> Quasi_rule.rname) + 2;
	break;
      case TAGDefs:
	size += 6;
	size += est_definition_list (old -> Defs.defs) + 2;
	break;
      case TAGAnonymous_option:
	size += 18;
	size += est_group (old -> Anonymous_option.grp) + 2;
	size += PTRWIDTH;
	size += PTRWIDTH;
	size += PTRWIDTH;
	break;
      case TAGAnonymous_group:
	size += 17;
	size += est_group (old -> Anonymous_group.grp) + 2;
	size += PTRWIDTH;
	size += PTRWIDTH;
	size += PTRWIDTH;
	break;
      default:
	dcg_bad_tag (old -> tag, "est_rule");
    };
  return (size + 2);
}

/* Estimate printing a spec */
int est_spec (spec old)
{ int size = 0;
  if (old == spec_nil) return (2);
  size += est_rule_layer (old -> rlayer) + 2;
  size += est_rule_kind (old -> rkind) + 2;
  size += est_rule_type (old -> rtype) + 2;
  size += est_string_list (old -> rname_parts) + 2;
  size += est_int_list (old -> rname_chars) + 2;
  size += est_affix_rule_list (old -> rsig) + 2;
  size += est_dir_list (old -> dirs) + 2;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  return (size + 2);
}

/* Estimate a rule_layer */
int est_rule_layer (rule_layer old)
{ switch (old)
    { case r_syntax: return (8);
      case r_terminal: return (10);
      case r_lex: return (5);
      default:
	dcg_bad_tag (old, "est_rule_layer");
    };
  return (0);
}

/* Estimate a rule_type */
int est_rule_type (rule_type old)
{ switch (old)
    { case r_unknown: return (9);
      case r_rule: return (6);
      case r_option: return (8);
      case r_predicate: return (11);
      case r_semipredicate: return (15);
      default:
	dcg_bad_tag (old, "est_rule_type");
    };
  return (0);
}

/* Estimate a rule_kind */
int est_rule_kind (rule_kind old)
{ switch (old)
    { case r_normal: return (8);
      case r_lexicon: return (9);
      case r_fact: return (6);
      case r_external: return (10);
      default:
	dcg_bad_tag (old, "est_rule_kind");
    };
  return (0);
}

/* Estimate printing a rdecl */
int est_rdecl (rdecl old)
{ int size = 0;
  if (old == rdecl_nil) return (2);
  size += PTRWIDTH;
  size += PTRWIDTH;
  return (size + 2);
}

/* Estimate printing a variable */
int est_variable (variable old)
{ int size = 0;
  if (old == variable_nil) return (2);
  size += est_string (old -> vname) + 2;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  return (size + 2);
}

/* Estimate printing a definition */
int est_definition (definition old)
{ int size = 0;
  if (old == definition_nil) return (2);
  size += est_fpar_list (old -> lhs_pars) + 2;
  size += est_variable_list (old -> locals) + 2;
  size += est_group (old -> grp) + 2;
  size += PTRWIDTH;
  return (size + 2);
}

/* Estimate printing a fpar */
int est_fpar (fpar old)
{ int size = 0;
  if (old == fpar_nil) return (2);
  size += est_int (old -> line) + 2;
  size += est_int (old -> col) + 2;
  size += est_dir (old -> fdir) + 2;
  size += est_affix_term_list (old -> fexp) + 2;
  size += PTRWIDTH;
  size += PTRWIDTH;
  return (size + 2);
}

/* Estimate a dir */
int est_dir (dir old)
{ switch (old)
    { case d_unknown: return (9);
      case d_inherited: return (11);
      case d_derived: return (9);
      case d_transient: return (11);
      case d_static: return (8);
      case d_regexp: return (8);
      default:
	dcg_bad_tag (old, "est_dir");
    };
  return (0);
}

/* Estimate printing a group */
int est_group (group old)
{ int size = 0;
  if (old == group_nil) return (2);
  size += est_alternative_list (old -> alts) + 2;
  return (size + 2);
}

/* Estimate printing a alternative */
int est_alternative (alternative old)
{ int size = 0;
  if (old == alternative_nil) return (2);
  size += est_int (old -> line) + 2;
  size += est_int (old -> col) + 2;
  size += est_real (old -> freq) + 2;
  size += est_fwo_group_list (old -> members) + 2;
  size += est_int (old -> commited) + 2;
  size += est_trans_member_list (old -> trans) + 2;
  size += PTRWIDTH;
  size += PTRWIDTH;
  return (size + 2);
}

/* Estimate printing a fwo_group */
int est_fwo_group (fwo_group old)
{ int size = 0;
  if (old == fwo_group_nil) return (2);
  size += est_glue (old -> gl) + 2;
  size += PTRWIDTH;
  switch (old -> tag)
    { case TAGSingle:
	size += 8;
	size += est_member (old -> Single.mem) + 2;
	break;
      case TAGFwo:
	size += 5;
	size += est_member_list (old -> Fwo.mems) + 2;
	break;
      default:
	dcg_bad_tag (old -> tag, "est_fwo_group");
    };
  return (size + 2);
}

/* Estimate a glue */
int est_glue (glue old)
{ switch (old)
    { case g_none: return (6);
      case g_comma: return (7);
      case g_plus: return (6);
      default:
	dcg_bad_tag (old, "est_glue");
    };
  return (0);
}

/* Estimate printing a member */
int est_member (member old)
{ int size = 0;
  if (old == member_nil) return (2);
  size += est_int (old -> line) + 2;
  size += est_int (old -> col) + 2;
  size += PTRWIDTH;
  size += PTRWIDTH;
  switch (old -> tag)
    { case TAGCall:
	size += 6;
	size += est_string_list (old -> Call.rname_parts) + 2;
	size += est_int_list (old -> Call.rname_chars) + 2;
	size += est_apar_list (old -> Call.apars) + 2;
	break;
      case TAGGuard:
	size += 7;
	size += est_confrontation_list (old -> Guard.confs) + 2;
	break;
      case TAGTerm:
	size += 6;
	size += est_string (old -> Term.text) + 2;
	size += est_apar (old -> Term.par) + 2;
	break;
      case TAGQuasi:
	size += 7;
	size += est_string_list (old -> Quasi.qname_parts) + 2;
	size += est_int_list (old -> Quasi.qname_chars) + 2;
	size += est_apar_list (old -> Quasi.args) + 2;
	break;
      case TAGOp:
	size += 4;
	size += est_control_op (old -> Op.op) + 2;
	size += PTRWIDTH;
	break;
      case TAGGroup:
	size += 7;
	size += est_group (old -> Group.grp) + 2;
	break;
      case TAGOption:
	size += 8;
	size += est_group (old -> Option.grp) + 2;
	break;
      case TAGRes_guard:
	size += 11;
	size += est_res_conf_list (old -> Res_guard.rconfs) + 2;
	break;
      case TAGRes_call:
	size += 10;
	size += PTRWIDTH;
	size += est_affix_term_list (old -> Res_call.args) + 2;
	size += est_dir_list (old -> Res_call.adirs) + 2;
	break;
      case TAGRes_term:
	size += 10;
	size += est_string (old -> Res_term.text) + 2;
	size += PTRWIDTH;
	size += PTRWIDTH;
	size += est_dir (old -> Res_term.adir) + 2;
	size += est_affix_term (old -> Res_term.arg) + 2;
	break;
      default:
	dcg_bad_tag (old -> tag, "est_member");
    };
  return (size + 2);
}

/* Estimate printing a apar */
int est_apar (apar old)
{ int size = 0;
  if (old == apar_nil) return (2);
  size += est_dir (old -> adir) + 2;
  size += est_affix_term_list (old -> aexp) + 2;
  size += PTRWIDTH;
  return (size + 2);
}

/* Estimate printing a confrontation */
int est_confrontation (confrontation old)
{ int size = 0;
  if (old == confrontation_nil) return (2);
  size += est_int (old -> line) + 2;
  size += est_int (old -> col) + 2;
  size += est_guard_type (old -> typ) + 2;
  size += est_affix_term_list (old -> lhs) + 2;
  size += est_affix_term_list (old -> rhs) + 2;
  return (size + 2);
}

/* Estimate printing a res_conf */
int est_res_conf (res_conf old)
{ int size = 0;
  if (old == res_conf_nil) return (2);
  size += est_guard_type (old -> typ) + 2;
  size += est_affix_term (old -> lhs) + 2;
  size += est_affix_term (old -> rhs) + 2;
  return (size + 2);
}

/* Estimate a guard_type */
int est_guard_type (guard_type old)
{ switch (old)
    { case undetermined: return (12);
      case equal: return (5);
      case unequal: return (7);
      case restrict: return (8);
      case assign: return (6);
      case bidir_assign: return (12);
      case arith_equal: return (11);
      default:
	dcg_bad_tag (old, "est_guard_type");
    };
  return (0);
}

/* Estimate a control_op */
int est_control_op (control_op old)
{ switch (old)
    { case c_success: return (9);
      case c_failure: return (9);
      case c_abort: return (7);
      case c_exit: return (6);
      default:
	dcg_bad_tag (old, "est_control_op");
    };
  return (0);
}

/* Estimate printing a affix_term */
int est_affix_term (affix_term old)
{ int size = 0;
  if (old == affix_term_nil) return (2);
  size += est_int (old -> line) + 2;
  size += est_int (old -> col) + 2;
  size += PTRWIDTH;
  size += PTRWIDTH;
  switch (old -> tag)
    { case TAGTerminal:
	size += 10;
	size += est_string (old -> Terminal.marker) + 2;
	size += PTRWIDTH;
	break;
      case TAGDyop:
	size += 6;
	size += est_operator (old -> Dyop.dop) + 2;
	size += est_affix_term (old -> Dyop.arg1) + 2;
	size += est_affix_term (old -> Dyop.arg2) + 2;
	break;
      case TAGMonop:
	size += 7;
	size += est_operator (old -> Monop.mop) + 2;
	size += est_affix_term (old -> Monop.arg) + 2;
	break;
      case TAGEnclosed:
	size += 10;
	size += est_affix_term_list (old -> Enclosed.terms) + 2;
	break;
      case TAGAst:
	size += 5;
	size += est_affix_term_list (old -> Ast.terms) + 2;
	size += est_int (old -> Ast.altnr) + 2;
	break;
      case TAGConcat:
	size += 8;
	size += est_affix_term_list (old -> Concat.terms) + 2;
	break;
      case TAGInt:
	size += 5;
	size += est_int (old -> Int.num) + 2;
	break;
      case TAGReal:
	size += 6;
	size += est_real (old -> Real.num) + 2;
	break;
      case TAGText:
	size += 6;
	size += est_string (old -> Text.txt) + 2;
	break;
      case TAGRegexp:
	size += 8;
	size += est_string (old -> Regexp.text) + 2;
	size += PTRWIDTH;
	break;
      case TAGVar:
	size += 5;
	size += est_string (old -> Var.aname) + 2;
	size += PTRWIDTH;
	break;
      default:
	dcg_bad_tag (old -> tag, "est_affix_term");
    };
  return (size + 2);
}

/* Estimate printing a trans_member */
int est_trans_member (trans_member old)
{ int size = 0;
  if (old == trans_member_nil) return (2);
  size += est_int (old -> line) + 2;
  size += est_int (old -> col) + 2;
  size += est_glue (old -> gl) + 2;
  switch (old -> tag)
    { case TAGTcall:
	size += 7;
	size += est_string_list (old -> Tcall.cname) + 2;
	size += est_int (old -> Tcall.nr) + 2;
	size += PTRWIDTH;
	break;
      case TAGTquasi:
	size += 8;
	size += est_string (old -> Tquasi.qname) + 2;
	size += est_int (old -> Tquasi.nr) + 2;
	size += PTRWIDTH;
	break;
      case TAGTgroup:
	size += 8;
	size += est_int (old -> Tgroup.nr) + 2;
	size += PTRWIDTH;
	break;
      case TAGToption:
	size += 9;
	size += est_int (old -> Toption.nr) + 2;
	size += PTRWIDTH;
	break;
      case TAGTtext:
	size += 7;
	size += est_string (old -> Ttext.text) + 2;
	break;
      case TAGTvar:
	size += 6;
	size += est_string (old -> Tvar.aname) + 2;
	size += PTRWIDTH;
	break;
      case TAGThybrid:
	size += 9;
	size += est_hyb_op (old -> Thybrid.op) + 2;
	break;
      default:
	dcg_bad_tag (old -> tag, "est_trans_member");
    };
  return (size + 2);
}

/* Estimate printing a hyb_op */
int est_hyb_op (hyb_op old)
{ int size = 0;
  if (old == hyb_op_nil) return (2);
  switch (old -> tag)
    { case TAGHyb_sqr_open:
	size += 14;
	break;
      case TAGHyb_sqr_close:
	size += 15;
	break;
      case TAGHyb_curl_open:
	size += 15;
	break;
      case TAGHyb_curl_close:
	size += 16;
	break;
      case TAGHyb_bar:
	size += 9;
	break;
      case TAGHyb_rel_left:
	size += 14;
	size += est_string (old -> Hyb_rel_left.rname) + 2;
	break;
      case TAGHyb_rel_right:
	size += 15;
	size += est_string (old -> Hyb_rel_right.rname) + 2;
	break;
      default:
	dcg_bad_tag (old -> tag, "est_hyb_op");
    };
  return (size + 2);
}

/* Estimate printing a affix_rule */
int est_affix_rule (affix_rule old)
{ int size = 0;
  if (old == affix_rule_nil) return (2);
  size += est_int (old -> line) + 2;
  size += est_int (old -> col) + 2;
  size += est_string (old -> aname) + 2;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  switch (old -> tag)
    { case TAGAffix_synonym:
	size += 15;
	size += est_string (old -> Affix_synonym.syn) + 2;
	size += PTRWIDTH;
	break;
      case TAGAffix_alts:
	size += 12;
	size += est_affix_alternative_list (old -> Affix_alts.alts) + 2;
	size += PTRWIDTH;
	break;
      case TAGAffix_prim:
	size += 12;
	break;
      default:
	dcg_bad_tag (old -> tag, "est_affix_rule");
    };
  return (size + 2);
}

/* Estimate printing a affix_alternative */
int est_affix_alternative (affix_alternative old)
{ int size = 0;
  if (old == affix_alternative_nil) return (2);
  size += est_affix_element_list (old -> elems) + 2;
  size += PTRWIDTH;
  switch (old -> tag)
    { case TAGAffix_sequence:
	size += 16;
	break;
      case TAGAffix_concat:
	size += 14;
	break;
      case TAGAffix_union:
	size += 13;
	break;
      case TAGAffix_partition:
	size += 17;
	break;
      case TAGAffix_single:
	size += 14;
	break;
      case TAGAffix_empty:
	size += 13;
	break;
      default:
	dcg_bad_tag (old -> tag, "est_affix_alternative");
    };
  return (size + 2);
}

/* Estimate printing a affix_element */
int est_affix_element (affix_element old)
{ int size = 0;
  if (old == affix_element_nil) return (2);
  size += est_int (old -> line) + 2;
  size += est_int (old -> col) + 2;
  size += PTRWIDTH;
  switch (old -> tag)
    { case TAGAffix_var:
	size += 11;
	size += est_string (old -> Affix_var.vname) + 2;
	size += PTRWIDTH;
	break;
      case TAGAffix_term:
	size += 12;
	size += est_string (old -> Affix_term.tname) + 2;
	size += PTRWIDTH;
	break;
      case TAGAffix_text:
	size += 12;
	size += est_string (old -> Affix_text.text) + 2;
	size += PTRWIDTH;
	size += PTRWIDTH;
	break;
      case TAGAffix_inum:
	size += 12;
	size += est_int (old -> Affix_inum.ival) + 2;
	break;
      case TAGAffix_rnum:
	size += 12;
	size += est_real (old -> Affix_rnum.rval) + 2;
	break;
      default:
	dcg_bad_tag (old -> tag, "est_affix_element");
    };
  return (size + 2);
}

/* Estimate a nullability */
int est_nullability (nullability old)
{ switch (old)
    { case e_unknown: return (9);
      case e_may_produce_empty: return (19);
      case e_always_produces_empty: return (23);
      case e_never_produces_empty: return (22);
      default:
	dcg_bad_tag (old, "est_nullability");
    };
  return (0);
}

/* Estimate a arule_kind */
int est_arule_kind (arule_kind old)
{ switch (old)
    { case arule_unknown: return (13);
      case arule_error: return (11);
      case arule_int: return (9);
      case arule_real: return (10);
      case arule_text: return (10);
      case arule_lattice: return (13);
      case arule_tree: return (10);
      case arule_any: return (9);
      default:
	dcg_bad_tag (old, "est_arule_kind");
    };
  return (0);
}

/* Estimate printing a invisible_nonterminal */
int est_invisible_nonterminal (invisible_nonterminal old)
{ int size = 0;
  if (old == invisible_nonterminal_nil) return (2);
  size += est_string (old -> fname) + 2;
  size += est_int (old -> line) + 2;
  size += est_int (old -> col) + 2;
  size += est_string_list (old -> name) + 2;
  size += est_int (old -> arity) + 2;
  return (size + 2);
}

/* Estimate printing a element */
int est_element (element old)
{ int size = 0;
  if (old == element_nil) return (2);
  size += est_string (old -> name) + 2;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  size += PTRWIDTH;
  return (size + 2);
}

/* Estimate printing a domain */
int est_domain (domain old)
{ int size = 0;
  if (old == domain_nil) return (2);
  size += est_int_list (old -> elts) + 2;
  size += PTRWIDTH;
  size += PTRWIDTH;
  return (size + 2);
}

/* Estimate printing a regexp */
int est_regexp (regexp old)
{ int size = 0;
  if (old == regexp_nil) return (2);
  switch (old -> tag)
    { case TAGRegexp_or:
	size += 11;
	size += est_regexp_list (old -> Regexp_or.subs) + 2;
	break;
      case TAGRegexp_concat:
	size += 15;
	size += est_regexp_list (old -> Regexp_concat.subs) + 2;
	break;
      case TAGRegexp_star:
	size += 13;
	size += est_regexp (old -> Regexp_star.sub) + 2;
	break;
      case TAGRegexp_plus:
	size += 13;
	size += est_regexp (old -> Regexp_plus.sub) + 2;
	break;
      case TAGRegexp_opt:
	size += 12;
	size += est_regexp (old -> Regexp_opt.sub) + 2;
	break;
      case TAGRegexp_cset:
	size += 13;
	size += est_int (old -> Regexp_cset.cs) + 2;
	break;
      case TAGRegexp_char:
	size += 13;
	size += est_int (old -> Regexp_char.ch) + 2;
	break;
      case TAGRegexp_anychar:
	size += 16;
	break;
      case TAGRegexp_whitespace:
	size += 19;
	break;
      case TAGRegexp_nonwhitespace:
	size += 22;
	break;
      case TAGRegexp_empty:
	size += 14;
	break;
      default:
	dcg_bad_tag (old -> tag, "est_regexp");
    };
  return (size + 2);
}

/* Estimate printing a name */
int est_name (name old)
{ int size = 0;
  if (old == name_nil) return (2);
  size += est_int (old -> line) + 2;
  size += est_int (old -> col) + 2;
  size += est_string_list (old -> id) + 2;
  return (size + 2);
}

/* Estimate printing a call_solution */
int est_call_solution (call_solution old)
{ int size = 0;
  if (old == call_solution_nil) return (2);
  size += PTRWIDTH;
  size += est_affix_term_list (old -> apars) + 2;
  size += est_int (old -> nr_matches) + 2;
  return (size + 2);
}

/* Estimate printing a madm */
int est_madm (madm old)
{ int size = 0;
  if (old == madm_nil) return (2);
  switch (old -> tag)
    { case TAGRule_adm:
	size += 10;
	size += PTRWIDTH;
	size += PTRWIDTH;
	size += PTRWIDTH;
	size += PTRWIDTH;
	break;
      case TAGMember_adm:
	size += 12;
	size += PTRWIDTH;
	size += est_int (old -> Member_adm.alt_nr) + 2;
	size += est_int (old -> Member_adm.mem_nr) + 2;
	break;
      default:
	dcg_bad_tag (old -> tag, "est_madm");
    };
  return (size + 2);
}

/* Estimate printing a grammar_list */
int est_grammar_list (grammar_list old)
{ int ix;
  int size = 0;
  if (old == grammar_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_grammar (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a prule_list */
int est_prule_list (prule_list old)
{ int ix;
  int size = 0;
  if (old == prule_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_prule (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a plhs_list */
int est_plhs_list (plhs_list old)
{ int ix;
  int size = 0;
  if (old == plhs_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_plhs (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a rule_list */
int est_rule_list (rule_list old)
{ int ix;
  int size = 0;
  if (old == rule_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_rule (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a rdecl_list */
int est_rdecl_list (rdecl_list old)
{ int ix;
  int size = 0;
  if (old == rdecl_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_rdecl (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a variable_list */
int est_variable_list (variable_list old)
{ int ix;
  int size = 0;
  if (old == variable_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_variable (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a definition_list */
int est_definition_list (definition_list old)
{ int ix;
  int size = 0;
  if (old == definition_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_definition (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a fpar_list */
int est_fpar_list (fpar_list old)
{ int ix;
  int size = 0;
  if (old == fpar_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_fpar (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a dir_list */
int est_dir_list (dir_list old)
{ int ix;
  int size = 0;
  if (old == dir_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_dir (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a alternative_list */
int est_alternative_list (alternative_list old)
{ int ix;
  int size = 0;
  if (old == alternative_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_alternative (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a fwo_group_list */
int est_fwo_group_list (fwo_group_list old)
{ int ix;
  int size = 0;
  if (old == fwo_group_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_fwo_group (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a member_list */
int est_member_list (member_list old)
{ int ix;
  int size = 0;
  if (old == member_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_member (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a apar_list */
int est_apar_list (apar_list old)
{ int ix;
  int size = 0;
  if (old == apar_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_apar (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a confrontation_list */
int est_confrontation_list (confrontation_list old)
{ int ix;
  int size = 0;
  if (old == confrontation_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_confrontation (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a res_conf_list */
int est_res_conf_list (res_conf_list old)
{ int ix;
  int size = 0;
  if (old == res_conf_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_res_conf (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a affix_term_list */
int est_affix_term_list (affix_term_list old)
{ int ix;
  int size = 0;
  if (old == affix_term_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_affix_term (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a trans_member_list */
int est_trans_member_list (trans_member_list old)
{ int ix;
  int size = 0;
  if (old == trans_member_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_trans_member (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a affix_rule_list */
int est_affix_rule_list (affix_rule_list old)
{ int ix;
  int size = 0;
  if (old == affix_rule_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_affix_rule (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a affix_alternative_list */
int est_affix_alternative_list (affix_alternative_list old)
{ int ix;
  int size = 0;
  if (old == affix_alternative_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_affix_alternative (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a affix_element_list */
int est_affix_element_list (affix_element_list old)
{ int ix;
  int size = 0;
  if (old == affix_element_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_affix_element (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a invisible_nonterminal_list */
int est_invisible_nonterminal_list (invisible_nonterminal_list old)
{ int ix;
  int size = 0;
  if (old == invisible_nonterminal_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_invisible_nonterminal (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a element_list */
int est_element_list (element_list old)
{ int ix;
  int size = 0;
  if (old == element_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_element (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a domain_list */
int est_domain_list (domain_list old)
{ int ix;
  int size = 0;
  if (old == domain_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_domain (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a regexp_list */
int est_regexp_list (regexp_list old)
{ int ix;
  int size = 0;
  if (old == regexp_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_regexp (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a name_list */
int est_name_list (name_list old)
{ int ix;
  int size = 0;
  if (old == name_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_name (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a call_solution_list */
int est_call_solution_list (call_solution_list old)
{ int ix;
  int size = 0;
  if (old == call_solution_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_call_solution (old -> array[ix]) + 2;
  return (size + 2);
}

/* Estimate printing a madm_list */
int est_madm_list (madm_list old)
{ int ix;
  int size = 0;
  if (old == madm_list_nil) return (2);
  if (!old -> size) return (2);
  for (ix = 0; ix < old -> size; ix++)
    size += est_madm (old -> array[ix]) + 2;
  return (size + 2);
}

/* Pretty print a grammar */
void ppp_grammar (FILE *f, int horiz, int ind, grammar old)
{ int mhoriz;
  if (old == grammar_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_grammar (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_string (f, mhoriz, ind + 2, old -> fname);
  pppdelim (f, mhoriz, ind, ',');
  ppp_string (f, mhoriz, ind + 2, old -> gname);
  pppdelim (f, mhoriz, ind, ',');
  ppp_string_list (f, mhoriz, ind + 2, old -> uses);
  pppdelim (f, mhoriz, ind, ',');
  ppp_string_list (f, mhoriz, ind + 2, old -> lexica);
  pppdelim (f, mhoriz, ind, ',');
  ppp_string_list (f, mhoriz, ind + 2, old -> fact_tables);
  pppdelim (f, mhoriz, ind, ',');
  ppp_string_list (f, mhoriz, ind + 2, old -> triple_databases);
  pppdelim (f, mhoriz, ind, ',');
  ppp_prule_list (f, mhoriz, ind + 2, old -> exp_prules);
  pppdelim (f, mhoriz, ind, ',');
  ppp_prule_list (f, mhoriz, ind + 2, old -> prules);
  pppdelim (f, mhoriz, ind, ',');
  ppp_affix_rule_list (f, mhoriz, ind + 2, old -> arules);
  pppdelim (f, mhoriz, ind, ',');
  ppp_member (f, mhoriz, ind + 2, old -> root_call);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> gnr);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a prule */
void ppp_prule (FILE *f, int horiz, int ind, prule old)
{ int mhoriz;
  if (old == prule_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_prule (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> gnr);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> drule);
  pppdelim (f, mhoriz, ind, ',');
  ppp_plhs (f, mhoriz, ind + 2, old -> lhs);
  pppdelim (f, mhoriz, ind, ',');
  switch (old -> tag)
    { case TAGExt_prule:
	pppstring (f, "Ext_prule");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Ext_prule.ename);
	break;
      case TAGQuasi_prule:
	pppstring (f, "Quasi_prule");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Quasi_prule.rname);
	break;
      case TAGProto_rule:
	pppstring (f, "Proto_rule");
	pppdelim (f, mhoriz, ind, ',');
	ppp_group (f, mhoriz, ind + 2, old -> Proto_rule.grp);
	break;
      case TAGPspec:
	pppstring (f, "Pspec");
	break;
      case TAGPstart:
	pppstring (f, "Pstart");
	break;
      default:
	dcg_bad_tag (old -> tag, "ppp_prule");
    };
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a plhs */
void ppp_plhs (FILE *f, int horiz, int ind, plhs old)
{ int mhoriz;
  if (old == plhs_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_plhs (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> line);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> col);
  pppdelim (f, mhoriz, ind, ',');
  ppp_rule_layer (f, mhoriz, ind + 2, old -> rlayer);
  pppdelim (f, mhoriz, ind, ',');
  ppp_rule_kind (f, mhoriz, ind + 2, old -> rkind);
  pppdelim (f, mhoriz, ind, ',');
  ppp_rule_type (f, mhoriz, ind + 2, old -> rtype);
  pppdelim (f, mhoriz, ind, ',');
  ppp_string_list (f, mhoriz, ind + 2, old -> rname_parts);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int_list (f, mhoriz, ind + 2, old -> rname_chars);
  pppdelim (f, mhoriz, ind, ',');
  ppp_fpar_list (f, mhoriz, ind + 2, old -> lhs_pars);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a rule */
void ppp_rule (FILE *f, int horiz, int ind, rule old)
{ int mhoriz;
  if (old == rule_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_rule (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> rnr);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> empty);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> npred);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> reachable);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> codable);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> first);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> follow);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> goalnr);
  pppdelim (f, mhoriz, ind, ',');
  ppp_spec (f, mhoriz, ind + 2, old -> rspec);
  pppdelim (f, mhoriz, ind, ',');
  switch (old -> tag)
    { case TAGExt_rule:
	pppstring (f, "Ext_rule");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Ext_rule.ename);
	break;
      case TAGQuasi_rule:
	pppstring (f, "Quasi_rule");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Quasi_rule.rname);
	break;
      case TAGDefs:
	pppstring (f, "Defs");
	pppdelim (f, mhoriz, ind, ',');
	ppp_definition_list (f, mhoriz, ind + 2, old -> Defs.defs);
	break;
      case TAGAnonymous_option:
	pppstring (f, "Anonymous_option");
	pppdelim (f, mhoriz, ind, ',');
	ppp_group (f, mhoriz, ind + 2, old -> Anonymous_option.grp);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Anonymous_option.anc_spec);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Anonymous_option.def);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Anonymous_option.call);
	break;
      case TAGAnonymous_group:
	pppstring (f, "Anonymous_group");
	pppdelim (f, mhoriz, ind, ',');
	ppp_group (f, mhoriz, ind + 2, old -> Anonymous_group.grp);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Anonymous_group.anc_spec);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Anonymous_group.def);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Anonymous_group.call);
	break;
      default:
	dcg_bad_tag (old -> tag, "ppp_rule");
    };
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a spec */
void ppp_spec (FILE *f, int horiz, int ind, spec old)
{ int mhoriz;
  if (old == spec_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_spec (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_rule_layer (f, mhoriz, ind + 2, old -> rlayer);
  pppdelim (f, mhoriz, ind, ',');
  ppp_rule_kind (f, mhoriz, ind + 2, old -> rkind);
  pppdelim (f, mhoriz, ind, ',');
  ppp_rule_type (f, mhoriz, ind + 2, old -> rtype);
  pppdelim (f, mhoriz, ind, ',');
  ppp_string_list (f, mhoriz, ind + 2, old -> rname_parts);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int_list (f, mhoriz, ind + 2, old -> rname_chars);
  pppdelim (f, mhoriz, ind, ',');
  ppp_affix_rule_list (f, mhoriz, ind + 2, old -> rsig);
  pppdelim (f, mhoriz, ind, ',');
  ppp_dir_list (f, mhoriz, ind + 2, old -> dirs);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> concat_name);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> canonic_name);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> drule);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> pr);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> lnr);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a rule_layer */
void ppp_rule_layer (FILE *f, int horiz, int ind, rule_layer old)
{ switch (old)
     { case r_syntax:
	pppstring (f, "r_syntax");
	break;
       case r_terminal:
	pppstring (f, "r_terminal");
	break;
       case r_lex:
	pppstring (f, "r_lex");
	break;
      default:
	dcg_bad_tag (old, "ppp_rule_layer");
    };
}

/* Pretty print a rule_type */
void ppp_rule_type (FILE *f, int horiz, int ind, rule_type old)
{ switch (old)
     { case r_unknown:
	pppstring (f, "r_unknown");
	break;
       case r_rule:
	pppstring (f, "r_rule");
	break;
       case r_option:
	pppstring (f, "r_option");
	break;
       case r_predicate:
	pppstring (f, "r_predicate");
	break;
       case r_semipredicate:
	pppstring (f, "r_semipredicate");
	break;
      default:
	dcg_bad_tag (old, "ppp_rule_type");
    };
}

/* Pretty print a rule_kind */
void ppp_rule_kind (FILE *f, int horiz, int ind, rule_kind old)
{ switch (old)
     { case r_normal:
	pppstring (f, "r_normal");
	break;
       case r_lexicon:
	pppstring (f, "r_lexicon");
	break;
       case r_fact:
	pppstring (f, "r_fact");
	break;
       case r_external:
	pppstring (f, "r_external");
	break;
      default:
	dcg_bad_tag (old, "ppp_rule_kind");
    };
}

/* Pretty print a rdecl */
void ppp_rdecl (FILE *f, int horiz, int ind, rdecl old)
{ int mhoriz;
  if (old == rdecl_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_rdecl (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> rsig);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> rdef);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a variable */
void ppp_variable (FILE *f, int horiz, int ind, variable old)
{ int mhoriz;
  if (old == variable_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_variable (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_string (f, mhoriz, ind + 2, old -> vname);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> vnr);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> adef);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> cnr);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a definition */
void ppp_definition (FILE *f, int horiz, int ind, definition old)
{ int mhoriz;
  if (old == definition_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_definition (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_fpar_list (f, mhoriz, ind + 2, old -> lhs_pars);
  pppdelim (f, mhoriz, ind, ',');
  ppp_variable_list (f, mhoriz, ind + 2, old -> locals);
  pppdelim (f, mhoriz, ind, ',');
  ppp_group (f, mhoriz, ind + 2, old -> grp);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> pr);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a fpar */
void ppp_fpar (FILE *f, int horiz, int ind, fpar old)
{ int mhoriz;
  if (old == fpar_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_fpar (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> line);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> col);
  pppdelim (f, mhoriz, ind, ',');
  ppp_dir (f, mhoriz, ind + 2, old -> fdir);
  pppdelim (f, mhoriz, ind, ',');
  ppp_affix_term_list (f, mhoriz, ind + 2, old -> fexp);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> adef);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> err);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a dir */
void ppp_dir (FILE *f, int horiz, int ind, dir old)
{ switch (old)
     { case d_unknown:
	pppstring (f, "d_unknown");
	break;
       case d_inherited:
	pppstring (f, "d_inherited");
	break;
       case d_derived:
	pppstring (f, "d_derived");
	break;
       case d_transient:
	pppstring (f, "d_transient");
	break;
       case d_static:
	pppstring (f, "d_static");
	break;
       case d_regexp:
	pppstring (f, "d_regexp");
	break;
      default:
	dcg_bad_tag (old, "ppp_dir");
    };
}

/* Pretty print a group */
void ppp_group (FILE *f, int horiz, int ind, group old)
{ int mhoriz;
  if (old == group_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_group (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_alternative_list (f, mhoriz, ind + 2, old -> alts);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a alternative */
void ppp_alternative (FILE *f, int horiz, int ind, alternative old)
{ int mhoriz;
  if (old == alternative_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_alternative (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> line);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> col);
  pppdelim (f, mhoriz, ind, ',');
  ppp_real (f, mhoriz, ind + 2, old -> freq);
  pppdelim (f, mhoriz, ind, ',');
  ppp_fwo_group_list (f, mhoriz, ind + 2, old -> members);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> commited);
  pppdelim (f, mhoriz, ind, ',');
  ppp_trans_member_list (f, mhoriz, ind + 2, old -> trans);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> empty);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> first);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a fwo_group */
void ppp_fwo_group (FILE *f, int horiz, int ind, fwo_group old)
{ int mhoriz;
  if (old == fwo_group_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_fwo_group (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_glue (f, mhoriz, ind + 2, old -> gl);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> empty);
  pppdelim (f, mhoriz, ind, ',');
  switch (old -> tag)
    { case TAGSingle:
	pppstring (f, "Single");
	pppdelim (f, mhoriz, ind, ',');
	ppp_member (f, mhoriz, ind + 2, old -> Single.mem);
	break;
      case TAGFwo:
	pppstring (f, "Fwo");
	pppdelim (f, mhoriz, ind, ',');
	ppp_member_list (f, mhoriz, ind + 2, old -> Fwo.mems);
	break;
      default:
	dcg_bad_tag (old -> tag, "ppp_fwo_group");
    };
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a glue */
void ppp_glue (FILE *f, int horiz, int ind, glue old)
{ switch (old)
     { case g_none:
	pppstring (f, "g_none");
	break;
       case g_comma:
	pppstring (f, "g_comma");
	break;
       case g_plus:
	pppstring (f, "g_plus");
	break;
      default:
	dcg_bad_tag (old, "ppp_glue");
    };
}

/* Pretty print a member */
void ppp_member (FILE *f, int horiz, int ind, member old)
{ int mhoriz;
  if (old == member_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_member (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> line);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> col);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> empty);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> first);
  pppdelim (f, mhoriz, ind, ',');
  switch (old -> tag)
    { case TAGCall:
	pppstring (f, "Call");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string_list (f, mhoriz, ind + 2, old -> Call.rname_parts);
	pppdelim (f, mhoriz, ind, ',');
	ppp_int_list (f, mhoriz, ind + 2, old -> Call.rname_chars);
	pppdelim (f, mhoriz, ind, ',');
	ppp_apar_list (f, mhoriz, ind + 2, old -> Call.apars);
	break;
      case TAGGuard:
	pppstring (f, "Guard");
	pppdelim (f, mhoriz, ind, ',');
	ppp_confrontation_list (f, mhoriz, ind + 2, old -> Guard.confs);
	break;
      case TAGTerm:
	pppstring (f, "Term");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Term.text);
	pppdelim (f, mhoriz, ind, ',');
	ppp_apar (f, mhoriz, ind + 2, old -> Term.par);
	break;
      case TAGQuasi:
	pppstring (f, "Quasi");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string_list (f, mhoriz, ind + 2, old -> Quasi.qname_parts);
	pppdelim (f, mhoriz, ind, ',');
	ppp_int_list (f, mhoriz, ind + 2, old -> Quasi.qname_chars);
	pppdelim (f, mhoriz, ind, ',');
	ppp_apar_list (f, mhoriz, ind + 2, old -> Quasi.args);
	break;
      case TAGOp:
	pppstring (f, "Op");
	pppdelim (f, mhoriz, ind, ',');
	ppp_control_op (f, mhoriz, ind + 2, old -> Op.op);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Op.gnr);
	break;
      case TAGGroup:
	pppstring (f, "Group");
	pppdelim (f, mhoriz, ind, ',');
	ppp_group (f, mhoriz, ind + 2, old -> Group.grp);
	break;
      case TAGOption:
	pppstring (f, "Option");
	pppdelim (f, mhoriz, ind, ',');
	ppp_group (f, mhoriz, ind + 2, old -> Option.grp);
	break;
      case TAGRes_guard:
	pppstring (f, "Res_guard");
	pppdelim (f, mhoriz, ind, ',');
	ppp_res_conf_list (f, mhoriz, ind + 2, old -> Res_guard.rconfs);
	break;
      case TAGRes_call:
	pppstring (f, "Res_call");
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Res_call.rdef);
	pppdelim (f, mhoriz, ind, ',');
	ppp_affix_term_list (f, mhoriz, ind + 2, old -> Res_call.args);
	pppdelim (f, mhoriz, ind, ',');
	ppp_dir_list (f, mhoriz, ind + 2, old -> Res_call.adirs);
	break;
      case TAGRes_term:
	pppstring (f, "Res_term");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Res_term.text);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Res_term.termnr);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Res_term.is_regexp);
	pppdelim (f, mhoriz, ind, ',');
	ppp_dir (f, mhoriz, ind + 2, old -> Res_term.adir);
	pppdelim (f, mhoriz, ind, ',');
	ppp_affix_term (f, mhoriz, ind + 2, old -> Res_term.arg);
	break;
      default:
	dcg_bad_tag (old -> tag, "ppp_member");
    };
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a apar */
void ppp_apar (FILE *f, int horiz, int ind, apar old)
{ int mhoriz;
  if (old == apar_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_apar (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_dir (f, mhoriz, ind + 2, old -> adir);
  pppdelim (f, mhoriz, ind, ',');
  ppp_affix_term_list (f, mhoriz, ind + 2, old -> aexp);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> adef);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a confrontation */
void ppp_confrontation (FILE *f, int horiz, int ind, confrontation old)
{ int mhoriz;
  if (old == confrontation_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_confrontation (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> line);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> col);
  pppdelim (f, mhoriz, ind, ',');
  ppp_guard_type (f, mhoriz, ind + 2, old -> typ);
  pppdelim (f, mhoriz, ind, ',');
  ppp_affix_term_list (f, mhoriz, ind + 2, old -> lhs);
  pppdelim (f, mhoriz, ind, ',');
  ppp_affix_term_list (f, mhoriz, ind + 2, old -> rhs);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a res_conf */
void ppp_res_conf (FILE *f, int horiz, int ind, res_conf old)
{ int mhoriz;
  if (old == res_conf_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_res_conf (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_guard_type (f, mhoriz, ind + 2, old -> typ);
  pppdelim (f, mhoriz, ind, ',');
  ppp_affix_term (f, mhoriz, ind + 2, old -> lhs);
  pppdelim (f, mhoriz, ind, ',');
  ppp_affix_term (f, mhoriz, ind + 2, old -> rhs);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a guard_type */
void ppp_guard_type (FILE *f, int horiz, int ind, guard_type old)
{ switch (old)
     { case undetermined:
	pppstring (f, "undetermined");
	break;
       case equal:
	pppstring (f, "equal");
	break;
       case unequal:
	pppstring (f, "unequal");
	break;
       case restrict:
	pppstring (f, "restrict");
	break;
       case assign:
	pppstring (f, "assign");
	break;
       case bidir_assign:
	pppstring (f, "bidir_assign");
	break;
       case arith_equal:
	pppstring (f, "arith_equal");
	break;
      default:
	dcg_bad_tag (old, "ppp_guard_type");
    };
}

/* Pretty print a control_op */
void ppp_control_op (FILE *f, int horiz, int ind, control_op old)
{ switch (old)
     { case c_success:
	pppstring (f, "c_success");
	break;
       case c_failure:
	pppstring (f, "c_failure");
	break;
       case c_abort:
	pppstring (f, "c_abort");
	break;
       case c_exit:
	pppstring (f, "c_exit");
	break;
      default:
	dcg_bad_tag (old, "ppp_control_op");
    };
}

/* Pretty print a affix_term */
void ppp_affix_term (FILE *f, int horiz, int ind, affix_term old)
{ int mhoriz;
  if (old == affix_term_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_affix_term (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> line);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> col);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> adef);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> value);
  pppdelim (f, mhoriz, ind, ',');
  switch (old -> tag)
    { case TAGTerminal:
	pppstring (f, "Terminal");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Terminal.marker);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Terminal.edef);
	break;
      case TAGDyop:
	pppstring (f, "Dyop");
	pppdelim (f, mhoriz, ind, ',');
	ppp_operator (f, mhoriz, ind + 2, old -> Dyop.dop);
	pppdelim (f, mhoriz, ind, ',');
	ppp_affix_term (f, mhoriz, ind + 2, old -> Dyop.arg1);
	pppdelim (f, mhoriz, ind, ',');
	ppp_affix_term (f, mhoriz, ind + 2, old -> Dyop.arg2);
	break;
      case TAGMonop:
	pppstring (f, "Monop");
	pppdelim (f, mhoriz, ind, ',');
	ppp_operator (f, mhoriz, ind + 2, old -> Monop.mop);
	pppdelim (f, mhoriz, ind, ',');
	ppp_affix_term (f, mhoriz, ind + 2, old -> Monop.arg);
	break;
      case TAGEnclosed:
	pppstring (f, "Enclosed");
	pppdelim (f, mhoriz, ind, ',');
	ppp_affix_term_list (f, mhoriz, ind + 2, old -> Enclosed.terms);
	break;
      case TAGAst:
	pppstring (f, "Ast");
	pppdelim (f, mhoriz, ind, ',');
	ppp_affix_term_list (f, mhoriz, ind + 2, old -> Ast.terms);
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Ast.altnr);
	break;
      case TAGConcat:
	pppstring (f, "Concat");
	pppdelim (f, mhoriz, ind, ',');
	ppp_affix_term_list (f, mhoriz, ind + 2, old -> Concat.terms);
	break;
      case TAGInt:
	pppstring (f, "Int");
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Int.num);
	break;
      case TAGReal:
	pppstring (f, "Real");
	pppdelim (f, mhoriz, ind, ',');
	ppp_real (f, mhoriz, ind + 2, old -> Real.num);
	break;
      case TAGText:
	pppstring (f, "Text");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Text.txt);
	break;
      case TAGRegexp:
	pppstring (f, "Regexp");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Regexp.text);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Regexp.termnr);
	break;
      case TAGVar:
	pppstring (f, "Var");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Var.aname);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Var.vdef);
	break;
      default:
	dcg_bad_tag (old -> tag, "ppp_affix_term");
    };
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a trans_member */
void ppp_trans_member (FILE *f, int horiz, int ind, trans_member old)
{ int mhoriz;
  if (old == trans_member_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_trans_member (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> line);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> col);
  pppdelim (f, mhoriz, ind, ',');
  ppp_glue (f, mhoriz, ind + 2, old -> gl);
  pppdelim (f, mhoriz, ind, ',');
  switch (old -> tag)
    { case TAGTcall:
	pppstring (f, "Tcall");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string_list (f, mhoriz, ind + 2, old -> Tcall.cname);
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Tcall.nr);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Tcall.cdef);
	break;
      case TAGTquasi:
	pppstring (f, "Tquasi");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Tquasi.qname);
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Tquasi.nr);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Tquasi.qdef);
	break;
      case TAGTgroup:
	pppstring (f, "Tgroup");
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Tgroup.nr);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Tgroup.gdef);
	break;
      case TAGToption:
	pppstring (f, "Toption");
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Toption.nr);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Toption.odef);
	break;
      case TAGTtext:
	pppstring (f, "Ttext");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Ttext.text);
	break;
      case TAGTvar:
	pppstring (f, "Tvar");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Tvar.aname);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Tvar.vdef);
	break;
      case TAGThybrid:
	pppstring (f, "Thybrid");
	pppdelim (f, mhoriz, ind, ',');
	ppp_hyb_op (f, mhoriz, ind + 2, old -> Thybrid.op);
	break;
      default:
	dcg_bad_tag (old -> tag, "ppp_trans_member");
    };
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a hyb_op */
void ppp_hyb_op (FILE *f, int horiz, int ind, hyb_op old)
{ int mhoriz;
  if (old == hyb_op_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_hyb_op (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  switch (old -> tag)
    { case TAGHyb_sqr_open:
	pppstring (f, "Hyb_sqr_open");
	break;
      case TAGHyb_sqr_close:
	pppstring (f, "Hyb_sqr_close");
	break;
      case TAGHyb_curl_open:
	pppstring (f, "Hyb_curl_open");
	break;
      case TAGHyb_curl_close:
	pppstring (f, "Hyb_curl_close");
	break;
      case TAGHyb_bar:
	pppstring (f, "Hyb_bar");
	break;
      case TAGHyb_rel_left:
	pppstring (f, "Hyb_rel_left");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Hyb_rel_left.rname);
	break;
      case TAGHyb_rel_right:
	pppstring (f, "Hyb_rel_right");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Hyb_rel_right.rname);
	break;
      default:
	dcg_bad_tag (old -> tag, "ppp_hyb_op");
    };
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a affix_rule */
void ppp_affix_rule (FILE *f, int horiz, int ind, affix_rule old)
{ int mhoriz;
  if (old == affix_rule_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_affix_rule (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> line);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> col);
  pppdelim (f, mhoriz, ind, ',');
  ppp_string (f, mhoriz, ind + 2, old -> aname);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> anr);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> gnr);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> lc_nrs);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> kind);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> dom);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> empty);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> value);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> npred);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> reachable);
  pppdelim (f, mhoriz, ind, ',');
  switch (old -> tag)
    { case TAGAffix_synonym:
	pppstring (f, "Affix_synonym");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Affix_synonym.syn);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Affix_synonym.syndef);
	break;
      case TAGAffix_alts:
	pppstring (f, "Affix_alts");
	pppdelim (f, mhoriz, ind, ',');
	ppp_affix_alternative_list (f, mhoriz, ind + 2, old -> Affix_alts.alts);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Affix_alts.enumerable);
	break;
      case TAGAffix_prim:
	pppstring (f, "Affix_prim");
	break;
      default:
	dcg_bad_tag (old -> tag, "ppp_affix_rule");
    };
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a affix_alternative */
void ppp_affix_alternative (FILE *f, int horiz, int ind, affix_alternative old)
{ int mhoriz;
  if (old == affix_alternative_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_affix_alternative (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_affix_element_list (f, mhoriz, ind + 2, old -> elems);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> empty);
  pppdelim (f, mhoriz, ind, ',');
  switch (old -> tag)
    { case TAGAffix_sequence:
	pppstring (f, "Affix_sequence");
	break;
      case TAGAffix_concat:
	pppstring (f, "Affix_concat");
	break;
      case TAGAffix_union:
	pppstring (f, "Affix_union");
	break;
      case TAGAffix_partition:
	pppstring (f, "Affix_partition");
	break;
      case TAGAffix_single:
	pppstring (f, "Affix_single");
	break;
      case TAGAffix_empty:
	pppstring (f, "Affix_empty");
	break;
      default:
	dcg_bad_tag (old -> tag, "ppp_affix_alternative");
    };
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a affix_element */
void ppp_affix_element (FILE *f, int horiz, int ind, affix_element old)
{ int mhoriz;
  if (old == affix_element_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_affix_element (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> line);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> col);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> empty);
  pppdelim (f, mhoriz, ind, ',');
  switch (old -> tag)
    { case TAGAffix_var:
	pppstring (f, "Affix_var");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Affix_var.vname);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Affix_var.vdef);
	break;
      case TAGAffix_term:
	pppstring (f, "Affix_term");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Affix_term.tname);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Affix_term.edef);
	break;
      case TAGAffix_text:
	pppstring (f, "Affix_text");
	pppdelim (f, mhoriz, ind, ',');
	ppp_string (f, mhoriz, ind + 2, old -> Affix_text.text);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Affix_text.termnr);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Affix_text.is_regexp);
	break;
      case TAGAffix_inum:
	pppstring (f, "Affix_inum");
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Affix_inum.ival);
	break;
      case TAGAffix_rnum:
	pppstring (f, "Affix_rnum");
	pppdelim (f, mhoriz, ind, ',');
	ppp_real (f, mhoriz, ind + 2, old -> Affix_rnum.rval);
	break;
      default:
	dcg_bad_tag (old -> tag, "ppp_affix_element");
    };
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a nullability */
void ppp_nullability (FILE *f, int horiz, int ind, nullability old)
{ switch (old)
     { case e_unknown:
	pppstring (f, "e_unknown");
	break;
       case e_may_produce_empty:
	pppstring (f, "e_may_produce_empty");
	break;
       case e_always_produces_empty:
	pppstring (f, "e_always_produces_empty");
	break;
       case e_never_produces_empty:
	pppstring (f, "e_never_produces_empty");
	break;
      default:
	dcg_bad_tag (old, "ppp_nullability");
    };
}

/* Pretty print a arule_kind */
void ppp_arule_kind (FILE *f, int horiz, int ind, arule_kind old)
{ switch (old)
     { case arule_unknown:
	pppstring (f, "arule_unknown");
	break;
       case arule_error:
	pppstring (f, "arule_error");
	break;
       case arule_int:
	pppstring (f, "arule_int");
	break;
       case arule_real:
	pppstring (f, "arule_real");
	break;
       case arule_text:
	pppstring (f, "arule_text");
	break;
       case arule_lattice:
	pppstring (f, "arule_lattice");
	break;
       case arule_tree:
	pppstring (f, "arule_tree");
	break;
       case arule_any:
	pppstring (f, "arule_any");
	break;
      default:
	dcg_bad_tag (old, "ppp_arule_kind");
    };
}

/* Pretty print a invisible_nonterminal */
void ppp_invisible_nonterminal (FILE *f, int horiz, int ind, invisible_nonterminal old)
{ int mhoriz;
  if (old == invisible_nonterminal_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_invisible_nonterminal (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_string (f, mhoriz, ind + 2, old -> fname);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> line);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> col);
  pppdelim (f, mhoriz, ind, ',');
  ppp_string_list (f, mhoriz, ind + 2, old -> name);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> arity);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a element */
void ppp_element (FILE *f, int horiz, int ind, element old)
{ int mhoriz;
  if (old == element_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_element (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_string (f, mhoriz, ind + 2, old -> name);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> enr);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> dom);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> log_value);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> value);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a domain */
void ppp_domain (FILE *f, int horiz, int ind, domain old)
{ int mhoriz;
  if (old == domain_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_domain (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int_list (f, mhoriz, ind + 2, old -> elts);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> dnr);
  pppdelim (f, mhoriz, ind, ',');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> width);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a regexp */
void ppp_regexp (FILE *f, int horiz, int ind, regexp old)
{ int mhoriz;
  if (old == regexp_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_regexp (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  switch (old -> tag)
    { case TAGRegexp_or:
	pppstring (f, "Regexp_or");
	pppdelim (f, mhoriz, ind, ',');
	ppp_regexp_list (f, mhoriz, ind + 2, old -> Regexp_or.subs);
	break;
      case TAGRegexp_concat:
	pppstring (f, "Regexp_concat");
	pppdelim (f, mhoriz, ind, ',');
	ppp_regexp_list (f, mhoriz, ind + 2, old -> Regexp_concat.subs);
	break;
      case TAGRegexp_star:
	pppstring (f, "Regexp_star");
	pppdelim (f, mhoriz, ind, ',');
	ppp_regexp (f, mhoriz, ind + 2, old -> Regexp_star.sub);
	break;
      case TAGRegexp_plus:
	pppstring (f, "Regexp_plus");
	pppdelim (f, mhoriz, ind, ',');
	ppp_regexp (f, mhoriz, ind + 2, old -> Regexp_plus.sub);
	break;
      case TAGRegexp_opt:
	pppstring (f, "Regexp_opt");
	pppdelim (f, mhoriz, ind, ',');
	ppp_regexp (f, mhoriz, ind + 2, old -> Regexp_opt.sub);
	break;
      case TAGRegexp_cset:
	pppstring (f, "Regexp_cset");
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Regexp_cset.cs);
	break;
      case TAGRegexp_char:
	pppstring (f, "Regexp_char");
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Regexp_char.ch);
	break;
      case TAGRegexp_anychar:
	pppstring (f, "Regexp_anychar");
	break;
      case TAGRegexp_whitespace:
	pppstring (f, "Regexp_whitespace");
	break;
      case TAGRegexp_nonwhitespace:
	pppstring (f, "Regexp_nonwhitespace");
	break;
      case TAGRegexp_empty:
	pppstring (f, "Regexp_empty");
	break;
      default:
	dcg_bad_tag (old -> tag, "ppp_regexp");
    };
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a name */
void ppp_name (FILE *f, int horiz, int ind, name old)
{ int mhoriz;
  if (old == name_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_name (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_int (f, mhoriz, ind + 2, old -> line);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> col);
  pppdelim (f, mhoriz, ind, ',');
  ppp_string_list (f, mhoriz, ind + 2, old -> id);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a call_solution */
void ppp_call_solution (FILE *f, int horiz, int ind, call_solution old)
{ int mhoriz;
  if (old == call_solution_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_call_solution (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> rdef);
  pppdelim (f, mhoriz, ind, ',');
  ppp_affix_term_list (f, mhoriz, ind + 2, old -> apars);
  pppdelim (f, mhoriz, ind, ',');
  ppp_int (f, mhoriz, ind + 2, old -> nr_matches);
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a madm */
void ppp_madm (FILE *f, int horiz, int ind, madm old)
{ int mhoriz;
  if (old == madm_nil) { pppstring (f, "<>"); return; };
  mhoriz = horiz || (est_madm (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '(');
  switch (old -> tag)
    { case TAGRule_adm:
	pppstring (f, "Rule_adm");
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Rule_adm.terms);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Rule_adm.iptr);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Rule_adm.goal);
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Rule_adm.complete);
	break;
      case TAGMember_adm:
	pppstring (f, "Member_adm");
	pppdelim (f, mhoriz, ind, ',');
	ppp_vptr (f, mhoriz, ind + 2, (vptr) old -> Member_adm.arule);
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Member_adm.alt_nr);
	pppdelim (f, mhoriz, ind, ',');
	ppp_int (f, mhoriz, ind + 2, old -> Member_adm.mem_nr);
	break;
      default:
	dcg_bad_tag (old -> tag, "ppp_madm");
    };
  pppdelim (f, mhoriz, ind, ')');
}

/* Pretty print a grammar_list */
void ppp_grammar_list (FILE *f, int horiz, int ind, grammar_list old)
{ int ix, mhoriz;
  if (old == grammar_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_grammar_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_grammar (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a prule_list */
void ppp_prule_list (FILE *f, int horiz, int ind, prule_list old)
{ int ix, mhoriz;
  if (old == prule_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_prule_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_prule (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a plhs_list */
void ppp_plhs_list (FILE *f, int horiz, int ind, plhs_list old)
{ int ix, mhoriz;
  if (old == plhs_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_plhs_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_plhs (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a rule_list */
void ppp_rule_list (FILE *f, int horiz, int ind, rule_list old)
{ int ix, mhoriz;
  if (old == rule_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_rule_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_rule (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a rdecl_list */
void ppp_rdecl_list (FILE *f, int horiz, int ind, rdecl_list old)
{ int ix, mhoriz;
  if (old == rdecl_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_rdecl_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_rdecl (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a variable_list */
void ppp_variable_list (FILE *f, int horiz, int ind, variable_list old)
{ int ix, mhoriz;
  if (old == variable_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_variable_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_variable (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a definition_list */
void ppp_definition_list (FILE *f, int horiz, int ind, definition_list old)
{ int ix, mhoriz;
  if (old == definition_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_definition_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_definition (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a fpar_list */
void ppp_fpar_list (FILE *f, int horiz, int ind, fpar_list old)
{ int ix, mhoriz;
  if (old == fpar_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_fpar_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_fpar (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a dir_list */
void ppp_dir_list (FILE *f, int horiz, int ind, dir_list old)
{ int ix, mhoriz;
  if (old == dir_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_dir_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_dir (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a alternative_list */
void ppp_alternative_list (FILE *f, int horiz, int ind, alternative_list old)
{ int ix, mhoriz;
  if (old == alternative_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_alternative_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_alternative (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a fwo_group_list */
void ppp_fwo_group_list (FILE *f, int horiz, int ind, fwo_group_list old)
{ int ix, mhoriz;
  if (old == fwo_group_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_fwo_group_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_fwo_group (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a member_list */
void ppp_member_list (FILE *f, int horiz, int ind, member_list old)
{ int ix, mhoriz;
  if (old == member_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_member_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_member (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a apar_list */
void ppp_apar_list (FILE *f, int horiz, int ind, apar_list old)
{ int ix, mhoriz;
  if (old == apar_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_apar_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_apar (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a confrontation_list */
void ppp_confrontation_list (FILE *f, int horiz, int ind, confrontation_list old)
{ int ix, mhoriz;
  if (old == confrontation_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_confrontation_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_confrontation (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a res_conf_list */
void ppp_res_conf_list (FILE *f, int horiz, int ind, res_conf_list old)
{ int ix, mhoriz;
  if (old == res_conf_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_res_conf_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_res_conf (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a affix_term_list */
void ppp_affix_term_list (FILE *f, int horiz, int ind, affix_term_list old)
{ int ix, mhoriz;
  if (old == affix_term_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_affix_term_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_affix_term (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a trans_member_list */
void ppp_trans_member_list (FILE *f, int horiz, int ind, trans_member_list old)
{ int ix, mhoriz;
  if (old == trans_member_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_trans_member_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_trans_member (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a affix_rule_list */
void ppp_affix_rule_list (FILE *f, int horiz, int ind, affix_rule_list old)
{ int ix, mhoriz;
  if (old == affix_rule_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_affix_rule_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_affix_rule (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a affix_alternative_list */
void ppp_affix_alternative_list (FILE *f, int horiz, int ind, affix_alternative_list old)
{ int ix, mhoriz;
  if (old == affix_alternative_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_affix_alternative_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_affix_alternative (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a affix_element_list */
void ppp_affix_element_list (FILE *f, int horiz, int ind, affix_element_list old)
{ int ix, mhoriz;
  if (old == affix_element_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_affix_element_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_affix_element (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a invisible_nonterminal_list */
void ppp_invisible_nonterminal_list (FILE *f, int horiz, int ind, invisible_nonterminal_list old)
{ int ix, mhoriz;
  if (old == invisible_nonterminal_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_invisible_nonterminal_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_invisible_nonterminal (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a element_list */
void ppp_element_list (FILE *f, int horiz, int ind, element_list old)
{ int ix, mhoriz;
  if (old == element_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_element_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_element (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a domain_list */
void ppp_domain_list (FILE *f, int horiz, int ind, domain_list old)
{ int ix, mhoriz;
  if (old == domain_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_domain_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_domain (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a regexp_list */
void ppp_regexp_list (FILE *f, int horiz, int ind, regexp_list old)
{ int ix, mhoriz;
  if (old == regexp_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_regexp_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_regexp (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a name_list */
void ppp_name_list (FILE *f, int horiz, int ind, name_list old)
{ int ix, mhoriz;
  if (old == name_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_name_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_name (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a call_solution_list */
void ppp_call_solution_list (FILE *f, int horiz, int ind, call_solution_list old)
{ int ix, mhoriz;
  if (old == call_solution_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_call_solution_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_call_solution (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Pretty print a madm_list */
void ppp_madm_list (FILE *f, int horiz, int ind, madm_list old)
{ int ix, mhoriz;
  if (old == madm_list_nil) { pppstring (f, "<>"); return; };
  if (!old -> size) { pppstring (f, "[]"); return; };
  mhoriz = horiz || (est_madm_list (old) + ind < MAXWIDTH);
  pppdelim (f, mhoriz, ind, '[');
  for (ix = 0; ix < old -> size; ix++)
    { ppp_madm (f, mhoriz, ind + 2, old -> array[ix]);
      if (ix != old -> size - 1) pppdelim (f, mhoriz, ind, ',');
    };
  pppdelim (f, mhoriz, ind, ']');
}

/* Recursively save a grammar */
void save_grammar (BinFile bf, grammar old)
{ /* save fixed fields before variant ones */
  save_string (bf, old -> fname);
  save_string (bf, old -> gname);
  save_string_list (bf, old -> uses);
  save_string_list (bf, old -> lexica);
  save_string_list (bf, old -> fact_tables);
  save_string_list (bf, old -> triple_databases);
  save_prule_list (bf, old -> exp_prules);
  save_prule_list (bf, old -> prules);
  save_affix_rule_list (bf, old -> arules);
  save_member (bf, old -> root_call);
}

/* Recursively save a prule */
void save_prule (BinFile bf, prule old)
{ /* save fixed fields before variant ones */
  save_plhs (bf, old -> lhs);
  save_char (bf, (char) old -> tag);
  switch (old -> tag)
    { case TAGExt_prule:
	save_string (bf, old -> Ext_prule.ename);
	break;
      case TAGQuasi_prule:
	save_string (bf, old -> Quasi_prule.rname);
	break;
      case TAGProto_rule:
	save_group (bf, old -> Proto_rule.grp);
	break;
      case TAGPspec:
	break;
      case TAGPstart:
	break;
      default:
	dcg_bad_tag (old -> tag, "save_prule");
    };
}

/* Recursively save a plhs */
void save_plhs (BinFile bf, plhs old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> line);
  save_int (bf, old -> col);
  save_rule_layer (bf, old -> rlayer);
  save_rule_kind (bf, old -> rkind);
  save_rule_type (bf, old -> rtype);
  save_string_list (bf, old -> rname_parts);
  save_int_list (bf, old -> rname_chars);
  save_fpar_list (bf, old -> lhs_pars);
}

/* Recursively save a rule */
void save_rule (BinFile bf, rule old)
{ /* save fixed fields before variant ones */
  save_spec (bf, old -> rspec);
  save_char (bf, (char) old -> tag);
  switch (old -> tag)
    { case TAGExt_rule:
	save_string (bf, old -> Ext_rule.ename);
	break;
      case TAGQuasi_rule:
	save_string (bf, old -> Quasi_rule.rname);
	break;
      case TAGDefs:
	save_definition_list (bf, old -> Defs.defs);
	break;
      case TAGAnonymous_option:
	save_group (bf, old -> Anonymous_option.grp);
	break;
      case TAGAnonymous_group:
	save_group (bf, old -> Anonymous_group.grp);
	break;
      default:
	dcg_bad_tag (old -> tag, "save_rule");
    };
}

/* Recursively save a spec */
void save_spec (BinFile bf, spec old)
{ /* save fixed fields before variant ones */
  save_rule_layer (bf, old -> rlayer);
  save_rule_kind (bf, old -> rkind);
  save_rule_type (bf, old -> rtype);
  save_string_list (bf, old -> rname_parts);
  save_int_list (bf, old -> rname_chars);
  save_affix_rule_list (bf, old -> rsig);
  save_dir_list (bf, old -> dirs);
}

/* Recursively save a rdecl */
void save_rdecl (BinFile bf, rdecl old)
{ /* save fixed fields before variant ones */
}

/* Recursively save a variable */
void save_variable (BinFile bf, variable old)
{ /* save fixed fields before variant ones */
  save_string (bf, old -> vname);
}

/* Recursively save a definition */
void save_definition (BinFile bf, definition old)
{ /* save fixed fields before variant ones */
  save_fpar_list (bf, old -> lhs_pars);
  save_variable_list (bf, old -> locals);
  save_group (bf, old -> grp);
}

/* Recursively save a fpar */
void save_fpar (BinFile bf, fpar old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> line);
  save_int (bf, old -> col);
  save_dir (bf, old -> fdir);
  save_affix_term_list (bf, old -> fexp);
}

/* Recursively save a group */
void save_group (BinFile bf, group old)
{ /* save fixed fields before variant ones */
  save_alternative_list (bf, old -> alts);
}

/* Recursively save a alternative */
void save_alternative (BinFile bf, alternative old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> line);
  save_int (bf, old -> col);
  save_real (bf, old -> freq);
  save_fwo_group_list (bf, old -> members);
  save_int (bf, old -> commited);
  save_trans_member_list (bf, old -> trans);
}

/* Recursively save a fwo_group */
void save_fwo_group (BinFile bf, fwo_group old)
{ /* save fixed fields before variant ones */
  save_glue (bf, old -> gl);
  save_char (bf, (char) old -> tag);
  switch (old -> tag)
    { case TAGSingle:
	save_member (bf, old -> Single.mem);
	break;
      case TAGFwo:
	save_member_list (bf, old -> Fwo.mems);
	break;
      default:
	dcg_bad_tag (old -> tag, "save_fwo_group");
    };
}

/* Recursively save a member */
void save_member (BinFile bf, member old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> line);
  save_int (bf, old -> col);
  save_char (bf, (char) old -> tag);
  switch (old -> tag)
    { case TAGCall:
	save_string_list (bf, old -> Call.rname_parts);
	save_int_list (bf, old -> Call.rname_chars);
	save_apar_list (bf, old -> Call.apars);
	break;
      case TAGGuard:
	save_confrontation_list (bf, old -> Guard.confs);
	break;
      case TAGTerm:
	save_string (bf, old -> Term.text);
	save_apar (bf, old -> Term.par);
	break;
      case TAGQuasi:
	save_string_list (bf, old -> Quasi.qname_parts);
	save_int_list (bf, old -> Quasi.qname_chars);
	save_apar_list (bf, old -> Quasi.args);
	break;
      case TAGOp:
	save_control_op (bf, old -> Op.op);
	break;
      case TAGGroup:
	save_group (bf, old -> Group.grp);
	break;
      case TAGOption:
	save_group (bf, old -> Option.grp);
	break;
      case TAGRes_guard:
	save_res_conf_list (bf, old -> Res_guard.rconfs);
	break;
      case TAGRes_call:
	save_affix_term_list (bf, old -> Res_call.args);
	save_dir_list (bf, old -> Res_call.adirs);
	break;
      case TAGRes_term:
	save_string (bf, old -> Res_term.text);
	save_dir (bf, old -> Res_term.adir);
	save_affix_term (bf, old -> Res_term.arg);
	break;
      default:
	dcg_bad_tag (old -> tag, "save_member");
    };
}

/* Recursively save a apar */
void save_apar (BinFile bf, apar old)
{ /* save fixed fields before variant ones */
  save_dir (bf, old -> adir);
  save_affix_term_list (bf, old -> aexp);
}

/* Recursively save a confrontation */
void save_confrontation (BinFile bf, confrontation old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> line);
  save_int (bf, old -> col);
  save_guard_type (bf, old -> typ);
  save_affix_term_list (bf, old -> lhs);
  save_affix_term_list (bf, old -> rhs);
}

/* Recursively save a res_conf */
void save_res_conf (BinFile bf, res_conf old)
{ /* save fixed fields before variant ones */
  save_guard_type (bf, old -> typ);
  save_affix_term (bf, old -> lhs);
  save_affix_term (bf, old -> rhs);
}

/* Recursively save a affix_term */
void save_affix_term (BinFile bf, affix_term old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> line);
  save_int (bf, old -> col);
  save_char (bf, (char) old -> tag);
  switch (old -> tag)
    { case TAGTerminal:
	save_string (bf, old -> Terminal.marker);
	break;
      case TAGDyop:
	save_operator (bf, old -> Dyop.dop);
	save_affix_term (bf, old -> Dyop.arg1);
	save_affix_term (bf, old -> Dyop.arg2);
	break;
      case TAGMonop:
	save_operator (bf, old -> Monop.mop);
	save_affix_term (bf, old -> Monop.arg);
	break;
      case TAGEnclosed:
	save_affix_term_list (bf, old -> Enclosed.terms);
	break;
      case TAGAst:
	save_affix_term_list (bf, old -> Ast.terms);
	save_int (bf, old -> Ast.altnr);
	break;
      case TAGConcat:
	save_affix_term_list (bf, old -> Concat.terms);
	break;
      case TAGInt:
	save_int (bf, old -> Int.num);
	break;
      case TAGReal:
	save_real (bf, old -> Real.num);
	break;
      case TAGText:
	save_string (bf, old -> Text.txt);
	break;
      case TAGRegexp:
	save_string (bf, old -> Regexp.text);
	break;
      case TAGVar:
	save_string (bf, old -> Var.aname);
	break;
      default:
	dcg_bad_tag (old -> tag, "save_affix_term");
    };
}

/* Recursively save a trans_member */
void save_trans_member (BinFile bf, trans_member old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> line);
  save_int (bf, old -> col);
  save_glue (bf, old -> gl);
  save_char (bf, (char) old -> tag);
  switch (old -> tag)
    { case TAGTcall:
	save_string_list (bf, old -> Tcall.cname);
	save_int (bf, old -> Tcall.nr);
	break;
      case TAGTquasi:
	save_string (bf, old -> Tquasi.qname);
	save_int (bf, old -> Tquasi.nr);
	break;
      case TAGTgroup:
	save_int (bf, old -> Tgroup.nr);
	break;
      case TAGToption:
	save_int (bf, old -> Toption.nr);
	break;
      case TAGTtext:
	save_string (bf, old -> Ttext.text);
	break;
      case TAGTvar:
	save_string (bf, old -> Tvar.aname);
	break;
      case TAGThybrid:
	save_hyb_op (bf, old -> Thybrid.op);
	break;
      default:
	dcg_bad_tag (old -> tag, "save_trans_member");
    };
}

/* Recursively save a hyb_op */
void save_hyb_op (BinFile bf, hyb_op old)
{ /* save fixed fields before variant ones */
  save_char (bf, (char) old -> tag);
  switch (old -> tag)
    { case TAGHyb_sqr_open:
	break;
      case TAGHyb_sqr_close:
	break;
      case TAGHyb_curl_open:
	break;
      case TAGHyb_curl_close:
	break;
      case TAGHyb_bar:
	break;
      case TAGHyb_rel_left:
	save_string (bf, old -> Hyb_rel_left.rname);
	break;
      case TAGHyb_rel_right:
	save_string (bf, old -> Hyb_rel_right.rname);
	break;
      default:
	dcg_bad_tag (old -> tag, "save_hyb_op");
    };
}

/* Recursively save a affix_rule */
void save_affix_rule (BinFile bf, affix_rule old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> line);
  save_int (bf, old -> col);
  save_string (bf, old -> aname);
  save_char (bf, (char) old -> tag);
  switch (old -> tag)
    { case TAGAffix_synonym:
	save_string (bf, old -> Affix_synonym.syn);
	break;
      case TAGAffix_alts:
	save_affix_alternative_list (bf, old -> Affix_alts.alts);
	break;
      case TAGAffix_prim:
	break;
      default:
	dcg_bad_tag (old -> tag, "save_affix_rule");
    };
}

/* Recursively save a affix_alternative */
void save_affix_alternative (BinFile bf, affix_alternative old)
{ /* save fixed fields before variant ones */
  save_affix_element_list (bf, old -> elems);
  save_char (bf, (char) old -> tag);
  switch (old -> tag)
    { case TAGAffix_sequence:
	break;
      case TAGAffix_concat:
	break;
      case TAGAffix_union:
	break;
      case TAGAffix_partition:
	break;
      case TAGAffix_single:
	break;
      case TAGAffix_empty:
	break;
      default:
	dcg_bad_tag (old -> tag, "save_affix_alternative");
    };
}

/* Recursively save a affix_element */
void save_affix_element (BinFile bf, affix_element old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> line);
  save_int (bf, old -> col);
  save_char (bf, (char) old -> tag);
  switch (old -> tag)
    { case TAGAffix_var:
	save_string (bf, old -> Affix_var.vname);
	break;
      case TAGAffix_term:
	save_string (bf, old -> Affix_term.tname);
	break;
      case TAGAffix_text:
	save_string (bf, old -> Affix_text.text);
	break;
      case TAGAffix_inum:
	save_int (bf, old -> Affix_inum.ival);
	break;
      case TAGAffix_rnum:
	save_real (bf, old -> Affix_rnum.rval);
	break;
      default:
	dcg_bad_tag (old -> tag, "save_affix_element");
    };
}

/* Recursively save a invisible_nonterminal */
void save_invisible_nonterminal (BinFile bf, invisible_nonterminal old)
{ /* save fixed fields before variant ones */
  save_string (bf, old -> fname);
  save_int (bf, old -> line);
  save_int (bf, old -> col);
  save_string_list (bf, old -> name);
  save_int (bf, old -> arity);
}

/* Recursively save a element */
void save_element (BinFile bf, element old)
{ /* save fixed fields before variant ones */
  save_string (bf, old -> name);
}

/* Recursively save a domain */
void save_domain (BinFile bf, domain old)
{ /* save fixed fields before variant ones */
  save_int_list (bf, old -> elts);
}

/* Recursively save a regexp */
void save_regexp (BinFile bf, regexp old)
{ /* save fixed fields before variant ones */
  save_char (bf, (char) old -> tag);
  switch (old -> tag)
    { case TAGRegexp_or:
	save_regexp_list (bf, old -> Regexp_or.subs);
	break;
      case TAGRegexp_concat:
	save_regexp_list (bf, old -> Regexp_concat.subs);
	break;
      case TAGRegexp_star:
	save_regexp (bf, old -> Regexp_star.sub);
	break;
      case TAGRegexp_plus:
	save_regexp (bf, old -> Regexp_plus.sub);
	break;
      case TAGRegexp_opt:
	save_regexp (bf, old -> Regexp_opt.sub);
	break;
      case TAGRegexp_cset:
	save_int (bf, old -> Regexp_cset.cs);
	break;
      case TAGRegexp_char:
	save_int (bf, old -> Regexp_char.ch);
	break;
      case TAGRegexp_anychar:
	break;
      case TAGRegexp_whitespace:
	break;
      case TAGRegexp_nonwhitespace:
	break;
      case TAGRegexp_empty:
	break;
      default:
	dcg_bad_tag (old -> tag, "save_regexp");
    };
}

/* Recursively save a name */
void save_name (BinFile bf, name old)
{ /* save fixed fields before variant ones */
  save_int (bf, old -> line);
  save_int (bf, old -> col);
  save_string_list (bf, old -> id);
}

/* Recursively save a call_solution */
void save_call_solution (BinFile bf, call_solution old)
{ /* save fixed fields before variant ones */
  save_affix_term_list (bf, old -> apars);
  save_int (bf, old -> nr_matches);
}

/* Recursively save a madm */
void save_madm (BinFile bf, madm old)
{ /* save fixed fields before variant ones */
  save_char (bf, (char) old -> tag);
  switch (old -> tag)
    { case TAGRule_adm:
	break;
      case TAGMember_adm:
	save_int (bf, old -> Member_adm.alt_nr);
	save_int (bf, old -> Member_adm.mem_nr);
	break;
      default:
	dcg_bad_tag (old -> tag, "save_madm");
    };
}

/* Recursively save a grammar_list */
void save_grammar_list (BinFile bf, grammar_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_grammar (bf, l -> array[ix]);
}

/* Recursively save a prule_list */
void save_prule_list (BinFile bf, prule_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_prule (bf, l -> array[ix]);
}

/* Recursively save a plhs_list */
void save_plhs_list (BinFile bf, plhs_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_plhs (bf, l -> array[ix]);
}

/* Recursively save a rule_list */
void save_rule_list (BinFile bf, rule_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_rule (bf, l -> array[ix]);
}

/* Recursively save a rdecl_list */
void save_rdecl_list (BinFile bf, rdecl_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_rdecl (bf, l -> array[ix]);
}

/* Recursively save a variable_list */
void save_variable_list (BinFile bf, variable_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_variable (bf, l -> array[ix]);
}

/* Recursively save a definition_list */
void save_definition_list (BinFile bf, definition_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_definition (bf, l -> array[ix]);
}

/* Recursively save a fpar_list */
void save_fpar_list (BinFile bf, fpar_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_fpar (bf, l -> array[ix]);
}

/* Recursively save a dir_list */
void save_dir_list (BinFile bf, dir_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_dir (bf, l -> array[ix]);
}

/* Recursively save a alternative_list */
void save_alternative_list (BinFile bf, alternative_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_alternative (bf, l -> array[ix]);
}

/* Recursively save a fwo_group_list */
void save_fwo_group_list (BinFile bf, fwo_group_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_fwo_group (bf, l -> array[ix]);
}

/* Recursively save a member_list */
void save_member_list (BinFile bf, member_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_member (bf, l -> array[ix]);
}

/* Recursively save a apar_list */
void save_apar_list (BinFile bf, apar_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_apar (bf, l -> array[ix]);
}

/* Recursively save a confrontation_list */
void save_confrontation_list (BinFile bf, confrontation_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_confrontation (bf, l -> array[ix]);
}

/* Recursively save a res_conf_list */
void save_res_conf_list (BinFile bf, res_conf_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_res_conf (bf, l -> array[ix]);
}

/* Recursively save a affix_term_list */
void save_affix_term_list (BinFile bf, affix_term_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_affix_term (bf, l -> array[ix]);
}

/* Recursively save a trans_member_list */
void save_trans_member_list (BinFile bf, trans_member_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_trans_member (bf, l -> array[ix]);
}

/* Recursively save a affix_rule_list */
void save_affix_rule_list (BinFile bf, affix_rule_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_affix_rule (bf, l -> array[ix]);
}

/* Recursively save a affix_alternative_list */
void save_affix_alternative_list (BinFile bf, affix_alternative_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_affix_alternative (bf, l -> array[ix]);
}

/* Recursively save a affix_element_list */
void save_affix_element_list (BinFile bf, affix_element_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_affix_element (bf, l -> array[ix]);
}

/* Recursively save a invisible_nonterminal_list */
void save_invisible_nonterminal_list (BinFile bf, invisible_nonterminal_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_invisible_nonterminal (bf, l -> array[ix]);
}

/* Recursively save a element_list */
void save_element_list (BinFile bf, element_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_element (bf, l -> array[ix]);
}

/* Recursively save a domain_list */
void save_domain_list (BinFile bf, domain_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_domain (bf, l -> array[ix]);
}

/* Recursively save a regexp_list */
void save_regexp_list (BinFile bf, regexp_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_regexp (bf, l -> array[ix]);
}

/* Recursively save a name_list */
void save_name_list (BinFile bf, name_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_name (bf, l -> array[ix]);
}

/* Recursively save a call_solution_list */
void save_call_solution_list (BinFile bf, call_solution_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_call_solution (bf, l -> array[ix]);
}

/* Recursively save a madm_list */
void save_madm_list (BinFile bf, madm_list l)
{ int ix;
  savesize (bf, l -> size);
  for (ix = 0; ix < l -> size; ix++)
    save_madm (bf, l -> array[ix]);
}

/* Recursively load a grammar */
void load_grammar (BinFile bf, grammar *x)
{ /* load fixed fields before variant ones */
  grammar new = (grammar) dcg_malloc (sizeof (struct str_grammar));
  load_string (bf, &new -> fname);
  load_string (bf, &new -> gname);
  load_string_list (bf, &new -> uses);
  load_string_list (bf, &new -> lexica);
  load_string_list (bf, &new -> fact_tables);
  load_string_list (bf, &new -> triple_databases);
  load_prule_list (bf, &new -> exp_prules);
  load_prule_list (bf, &new -> prules);
  load_affix_rule_list (bf, &new -> arules);
  load_member (bf, &new -> root_call);
  new -> gnr = int_nil;
  *x = new;
}

/* Recursively load a prule */
void load_prule (BinFile bf, prule *x)
{ /* load fixed fields before variant ones */
  prule new = (prule) dcg_malloc (sizeof (struct str_prule));
  char ch;
  new -> gnr = int_nil;
  new -> drule = rule_nil;
  load_plhs (bf, &new -> lhs);
  load_char (bf, &ch);
  new -> tag = (tags_prule) ch;
  switch (new -> tag)
    { case TAGExt_prule:
	load_string (bf, &new -> Ext_prule.ename);
	break;
      case TAGQuasi_prule:
	load_string (bf, &new -> Quasi_prule.rname);
	break;
      case TAGProto_rule:
	load_group (bf, &new -> Proto_rule.grp);
	break;
      case TAGPspec:
	break;
      case TAGPstart:
	break;
      default:
	dcg_bad_tag (new -> tag, "load_prule");
    };
  *x = new;
}

/* Recursively load a plhs */
void load_plhs (BinFile bf, plhs *x)
{ /* load fixed fields before variant ones */
  plhs new = (plhs) dcg_malloc (sizeof (struct str_plhs));
  load_int (bf, &new -> line);
  load_int (bf, &new -> col);
  load_rule_layer (bf, &new -> rlayer);
  load_rule_kind (bf, &new -> rkind);
  load_rule_type (bf, &new -> rtype);
  load_string_list (bf, &new -> rname_parts);
  load_int_list (bf, &new -> rname_chars);
  load_fpar_list (bf, &new -> lhs_pars);
  *x = new;
}

/* Recursively load a rule */
void load_rule (BinFile bf, rule *x)
{ /* load fixed fields before variant ones */
  rule new = (rule) dcg_malloc (sizeof (struct str_rule));
  char ch;
  new -> rnr = int_nil;
  new -> empty = nullability_nil;
  new -> npred = int_nil;
  new -> reachable = int_nil;
  new -> codable = int_nil;
  new -> first = trans_pair_list_nil;
  new -> follow = trans_pair_list_nil;
  new -> goalnr = int_nil;
  load_spec (bf, &new -> rspec);
  load_char (bf, &ch);
  new -> tag = (tags_rule) ch;
  switch (new -> tag)
    { case TAGExt_rule:
	load_string (bf, &new -> Ext_rule.ename);
	break;
      case TAGQuasi_rule:
	load_string (bf, &new -> Quasi_rule.rname);
	break;
      case TAGDefs:
	load_definition_list (bf, &new -> Defs.defs);
	break;
      case TAGAnonymous_option:
	load_group (bf, &new -> Anonymous_option.grp);
	new -> Anonymous_option.anc_spec = spec_nil;
	new -> Anonymous_option.def = definition_nil;
	new -> Anonymous_option.call = member_nil;
	break;
      case TAGAnonymous_group:
	load_group (bf, &new -> Anonymous_group.grp);
	new -> Anonymous_group.anc_spec = spec_nil;
	new -> Anonymous_group.def = definition_nil;
	new -> Anonymous_group.call = member_nil;
	break;
      default:
	dcg_bad_tag (new -> tag, "load_rule");
    };
  *x = new;
}

/* Recursively load a spec */
void load_spec (BinFile bf, spec *x)
{ /* load fixed fields before variant ones */
  spec new = (spec) dcg_malloc (sizeof (struct str_spec));
  load_rule_layer (bf, &new -> rlayer);
  load_rule_kind (bf, &new -> rkind);
  load_rule_type (bf, &new -> rtype);
  load_string_list (bf, &new -> rname_parts);
  load_int_list (bf, &new -> rname_chars);
  load_affix_rule_list (bf, &new -> rsig);
  load_dir_list (bf, &new -> dirs);
  new -> concat_name = string_nil;
  new -> canonic_name = string_nil;
  new -> drule = rule_nil;
  new -> pr = prule_nil;
  new -> lnr = int_nil;
  *x = new;
}

/* Load a rule_layer */
void load_rule_layer (BinFile bf, rule_layer *x)
{ char ch;
  load_char (bf, &ch);
  *x = (rule_layer) ch;
}

/* Load a rule_type */
void load_rule_type (BinFile bf, rule_type *x)
{ char ch;
  load_char (bf, &ch);
  *x = (rule_type) ch;
}

/* Load a rule_kind */
void load_rule_kind (BinFile bf, rule_kind *x)
{ char ch;
  load_char (bf, &ch);
  *x = (rule_kind) ch;
}

/* Recursively load a rdecl */
void load_rdecl (BinFile bf, rdecl *x)
{ /* load fixed fields before variant ones */
  rdecl new = (rdecl) dcg_malloc (sizeof (struct str_rdecl));
  new -> rsig = affix_rule_list_nil;
  new -> rdef = rule_nil;
  *x = new;
}

/* Recursively load a variable */
void load_variable (BinFile bf, variable *x)
{ /* load fixed fields before variant ones */
  variable new = (variable) dcg_malloc (sizeof (struct str_variable));
  load_string (bf, &new -> vname);
  new -> vnr = int_nil;
  new -> adef = affix_rule_nil;
  new -> cnr = int_nil;
  *x = new;
}

/* Recursively load a definition */
void load_definition (BinFile bf, definition *x)
{ /* load fixed fields before variant ones */
  definition new = (definition) dcg_malloc (sizeof (struct str_definition));
  load_fpar_list (bf, &new -> lhs_pars);
  load_variable_list (bf, &new -> locals);
  load_group (bf, &new -> grp);
  new -> pr = prule_nil;
  *x = new;
}

/* Recursively load a fpar */
void load_fpar (BinFile bf, fpar *x)
{ /* load fixed fields before variant ones */
  fpar new = (fpar) dcg_malloc (sizeof (struct str_fpar));
  load_int (bf, &new -> line);
  load_int (bf, &new -> col);
  load_dir (bf, &new -> fdir);
  load_affix_term_list (bf, &new -> fexp);
  new -> adef = affix_rule_nil;
  new -> err = int_nil;
  *x = new;
}

/* Load a dir */
void load_dir (BinFile bf, dir *x)
{ char ch;
  load_char (bf, &ch);
  *x = (dir) ch;
}

/* Recursively load a group */
void load_group (BinFile bf, group *x)
{ /* load fixed fields before variant ones */
  group new = (group) dcg_malloc (sizeof (struct str_group));
  load_alternative_list (bf, &new -> alts);
  *x = new;
}

/* Recursively load a alternative */
void load_alternative (BinFile bf, alternative *x)
{ /* load fixed fields before variant ones */
  alternative new = (alternative) dcg_malloc (sizeof (struct str_alternative));
  load_int (bf, &new -> line);
  load_int (bf, &new -> col);
  load_real (bf, &new -> freq);
  load_fwo_group_list (bf, &new -> members);
  load_int (bf, &new -> commited);
  load_trans_member_list (bf, &new -> trans);
  new -> empty = int_nil;
  new -> first = trans_pair_list_nil;
  *x = new;
}

/* Recursively load a fwo_group */
void load_fwo_group (BinFile bf, fwo_group *x)
{ /* load fixed fields before variant ones */
  fwo_group new = (fwo_group) dcg_malloc (sizeof (struct str_fwo_group));
  char ch;
  load_glue (bf, &new -> gl);
  new -> empty = int_nil;
  load_char (bf, &ch);
  new -> tag = (tags_fwo_group) ch;
  switch (new -> tag)
    { case TAGSingle:
	load_member (bf, &new -> Single.mem);
	break;
      case TAGFwo:
	load_member_list (bf, &new -> Fwo.mems);
	break;
      default:
	dcg_bad_tag (new -> tag, "load_fwo_group");
    };
  *x = new;
}

/* Load a glue */
void load_glue (BinFile bf, glue *x)
{ char ch;
  load_char (bf, &ch);
  *x = (glue) ch;
}

/* Recursively load a member */
void load_member (BinFile bf, member *x)
{ /* load fixed fields before variant ones */
  member new = (member) dcg_malloc (sizeof (struct str_member));
  char ch;
  load_int (bf, &new -> line);
  load_int (bf, &new -> col);
  new -> empty = nullability_nil;
  new -> first = trans_pair_nil;
  load_char (bf, &ch);
  new -> tag = (tags_member) ch;
  switch (new -> tag)
    { case TAGCall:
	load_string_list (bf, &new -> Call.rname_parts);
	load_int_list (bf, &new -> Call.rname_chars);
	load_apar_list (bf, &new -> Call.apars);
	break;
      case TAGGuard:
	load_confrontation_list (bf, &new -> Guard.confs);
	break;
      case TAGTerm:
	load_string (bf, &new -> Term.text);
	load_apar (bf, &new -> Term.par);
	break;
      case TAGQuasi:
	load_string_list (bf, &new -> Quasi.qname_parts);
	load_int_list (bf, &new -> Quasi.qname_chars);
	load_apar_list (bf, &new -> Quasi.args);
	break;
      case TAGOp:
	load_control_op (bf, &new -> Op.op);
	new -> Op.gnr = int_nil;
	break;
      case TAGGroup:
	load_group (bf, &new -> Group.grp);
	break;
      case TAGOption:
	load_group (bf, &new -> Option.grp);
	break;
      case TAGRes_guard:
	load_res_conf_list (bf, &new -> Res_guard.rconfs);
	break;
      case TAGRes_call:
	new -> Res_call.rdef = rule_nil;
	load_affix_term_list (bf, &new -> Res_call.args);
	load_dir_list (bf, &new -> Res_call.adirs);
	break;
      case TAGRes_term:
	load_string (bf, &new -> Res_term.text);
	new -> Res_term.termnr = int_nil;
	new -> Res_term.is_regexp = int_nil;
	load_dir (bf, &new -> Res_term.adir);
	load_affix_term (bf, &new -> Res_term.arg);
	break;
      default:
	dcg_bad_tag (new -> tag, "load_member");
    };
  *x = new;
}

/* Recursively load a apar */
void load_apar (BinFile bf, apar *x)
{ /* load fixed fields before variant ones */
  apar new = (apar) dcg_malloc (sizeof (struct str_apar));
  load_dir (bf, &new -> adir);
  load_affix_term_list (bf, &new -> aexp);
  new -> adef = affix_rule_nil;
  *x = new;
}

/* Recursively load a confrontation */
void load_confrontation (BinFile bf, confrontation *x)
{ /* load fixed fields before variant ones */
  confrontation new = (confrontation) dcg_malloc (sizeof (struct str_confrontation));
  load_int (bf, &new -> line);
  load_int (bf, &new -> col);
  load_guard_type (bf, &new -> typ);
  load_affix_term_list (bf, &new -> lhs);
  load_affix_term_list (bf, &new -> rhs);
  *x = new;
}

/* Recursively load a res_conf */
void load_res_conf (BinFile bf, res_conf *x)
{ /* load fixed fields before variant ones */
  res_conf new = (res_conf) dcg_malloc (sizeof (struct str_res_conf));
  load_guard_type (bf, &new -> typ);
  load_affix_term (bf, &new -> lhs);
  load_affix_term (bf, &new -> rhs);
  *x = new;
}

/* Load a guard_type */
void load_guard_type (BinFile bf, guard_type *x)
{ char ch;
  load_char (bf, &ch);
  *x = (guard_type) ch;
}

/* Load a control_op */
void load_control_op (BinFile bf, control_op *x)
{ char ch;
  load_char (bf, &ch);
  *x = (control_op) ch;
}

/* Recursively load a affix_term */
void load_affix_term (BinFile bf, affix_term *x)
{ /* load fixed fields before variant ones */
  affix_term new = (affix_term) dcg_malloc (sizeof (struct str_affix_term));
  char ch;
  load_int (bf, &new -> line);
  load_int (bf, &new -> col);
  new -> adef = affix_rule_nil;
  new -> value = affix_value_nil;
  load_char (bf, &ch);
  new -> tag = (tags_affix_term) ch;
  switch (new -> tag)
    { case TAGTerminal:
	load_string (bf, &new -> Terminal.marker);
	new -> Terminal.edef = element_nil;
	break;
      case TAGDyop:
	load_operator (bf, &new -> Dyop.dop);
	load_affix_term (bf, &new -> Dyop.arg1);
	load_affix_term (bf, &new -> Dyop.arg2);
	break;
      case TAGMonop:
	load_operator (bf, &new -> Monop.mop);
	load_affix_term (bf, &new -> Monop.arg);
	break;
      case TAGEnclosed:
	load_affix_term_list (bf, &new -> Enclosed.terms);
	break;
      case TAGAst:
	load_affix_term_list (bf, &new -> Ast.terms);
	load_int (bf, &new -> Ast.altnr);
	break;
      case TAGConcat:
	load_affix_term_list (bf, &new -> Concat.terms);
	break;
      case TAGInt:
	load_int (bf, &new -> Int.num);
	break;
      case TAGReal:
	load_real (bf, &new -> Real.num);
	break;
      case TAGText:
	load_string (bf, &new -> Text.txt);
	break;
      case TAGRegexp:
	load_string (bf, &new -> Regexp.text);
	new -> Regexp.termnr = int_nil;
	break;
      case TAGVar:
	load_string (bf, &new -> Var.aname);
	new -> Var.vdef = variable_nil;
	break;
      default:
	dcg_bad_tag (new -> tag, "load_affix_term");
    };
  *x = new;
}

/* Recursively load a trans_member */
void load_trans_member (BinFile bf, trans_member *x)
{ /* load fixed fields before variant ones */
  trans_member new = (trans_member) dcg_malloc (sizeof (struct str_trans_member));
  char ch;
  load_int (bf, &new -> line);
  load_int (bf, &new -> col);
  load_glue (bf, &new -> gl);
  load_char (bf, &ch);
  new -> tag = (tags_trans_member) ch;
  switch (new -> tag)
    { case TAGTcall:
	load_string_list (bf, &new -> Tcall.cname);
	load_int (bf, &new -> Tcall.nr);
	new -> Tcall.cdef = member_nil;
	break;
      case TAGTquasi:
	load_string (bf, &new -> Tquasi.qname);
	load_int (bf, &new -> Tquasi.nr);
	new -> Tquasi.qdef = member_nil;
	break;
      case TAGTgroup:
	load_int (bf, &new -> Tgroup.nr);
	new -> Tgroup.gdef = member_nil;
	break;
      case TAGToption:
	load_int (bf, &new -> Toption.nr);
	new -> Toption.odef = member_nil;
	break;
      case TAGTtext:
	load_string (bf, &new -> Ttext.text);
	break;
      case TAGTvar:
	load_string (bf, &new -> Tvar.aname);
	new -> Tvar.vdef = variable_nil;
	break;
      case TAGThybrid:
	load_hyb_op (bf, &new -> Thybrid.op);
	break;
      default:
	dcg_bad_tag (new -> tag, "load_trans_member");
    };
  *x = new;
}

/* Recursively load a hyb_op */
void load_hyb_op (BinFile bf, hyb_op *x)
{ /* load fixed fields before variant ones */
  hyb_op new = (hyb_op) dcg_malloc (sizeof (struct str_hyb_op));
  char ch;
  load_char (bf, &ch);
  new -> tag = (tags_hyb_op) ch;
  switch (new -> tag)
    { case TAGHyb_sqr_open:
	break;
      case TAGHyb_sqr_close:
	break;
      case TAGHyb_curl_open:
	break;
      case TAGHyb_curl_close:
	break;
      case TAGHyb_bar:
	break;
      case TAGHyb_rel_left:
	load_string (bf, &new -> Hyb_rel_left.rname);
	break;
      case TAGHyb_rel_right:
	load_string (bf, &new -> Hyb_rel_right.rname);
	break;
      default:
	dcg_bad_tag (new -> tag, "load_hyb_op");
    };
  *x = new;
}

/* Recursively load a affix_rule */
void load_affix_rule (BinFile bf, affix_rule *x)
{ /* load fixed fields before variant ones */
  affix_rule new = (affix_rule) dcg_malloc (sizeof (struct str_affix_rule));
  char ch;
  load_int (bf, &new -> line);
  load_int (bf, &new -> col);
  load_string (bf, &new -> aname);
  new -> anr = int_nil;
  new -> gnr = int_nil;
  new -> lc_nrs = int_list_nil;
  new -> kind = arule_kind_nil;
  new -> dom = domain_nil;
  new -> empty = nullability_nil;
  new -> value = affix_value_nil;
  new -> npred = int_nil;
  new -> reachable = int_nil;
  load_char (bf, &ch);
  new -> tag = (tags_affix_rule) ch;
  switch (new -> tag)
    { case TAGAffix_synonym:
	load_string (bf, &new -> Affix_synonym.syn);
	new -> Affix_synonym.syndef = affix_rule_nil;
	break;
      case TAGAffix_alts:
	load_affix_alternative_list (bf, &new -> Affix_alts.alts);
	new -> Affix_alts.enumerable = int_nil;
	break;
      case TAGAffix_prim:
	break;
      default:
	dcg_bad_tag (new -> tag, "load_affix_rule");
    };
  *x = new;
}

/* Recursively load a affix_alternative */
void load_affix_alternative (BinFile bf, affix_alternative *x)
{ /* load fixed fields before variant ones */
  affix_alternative new = (affix_alternative) dcg_malloc (sizeof (struct str_affix_alternative));
  char ch;
  load_affix_element_list (bf, &new -> elems);
  new -> empty = int_nil;
  load_char (bf, &ch);
  new -> tag = (tags_affix_alternative) ch;
  switch (new -> tag)
    { case TAGAffix_sequence:
	break;
      case TAGAffix_concat:
	break;
      case TAGAffix_union:
	break;
      case TAGAffix_partition:
	break;
      case TAGAffix_single:
	break;
      case TAGAffix_empty:
	break;
      default:
	dcg_bad_tag (new -> tag, "load_affix_alternative");
    };
  *x = new;
}

/* Recursively load a affix_element */
void load_affix_element (BinFile bf, affix_element *x)
{ /* load fixed fields before variant ones */
  affix_element new = (affix_element) dcg_malloc (sizeof (struct str_affix_element));
  char ch;
  load_int (bf, &new -> line);
  load_int (bf, &new -> col);
  new -> empty = nullability_nil;
  load_char (bf, &ch);
  new -> tag = (tags_affix_element) ch;
  switch (new -> tag)
    { case TAGAffix_var:
	load_string (bf, &new -> Affix_var.vname);
	new -> Affix_var.vdef = affix_rule_nil;
	break;
      case TAGAffix_term:
	load_string (bf, &new -> Affix_term.tname);
	new -> Affix_term.edef = element_nil;
	break;
      case TAGAffix_text:
	load_string (bf, &new -> Affix_text.text);
	new -> Affix_text.termnr = int_nil;
	new -> Affix_text.is_regexp = int_nil;
	break;
      case TAGAffix_inum:
	load_int (bf, &new -> Affix_inum.ival);
	break;
      case TAGAffix_rnum:
	load_real (bf, &new -> Affix_rnum.rval);
	break;
      default:
	dcg_bad_tag (new -> tag, "load_affix_element");
    };
  *x = new;
}

/* Load a nullability */
void load_nullability (BinFile bf, nullability *x)
{ char ch;
  load_char (bf, &ch);
  *x = (nullability) ch;
}

/* Load a arule_kind */
void load_arule_kind (BinFile bf, arule_kind *x)
{ char ch;
  load_char (bf, &ch);
  *x = (arule_kind) ch;
}

/* Recursively load a invisible_nonterminal */
void load_invisible_nonterminal (BinFile bf, invisible_nonterminal *x)
{ /* load fixed fields before variant ones */
  invisible_nonterminal new = (invisible_nonterminal) dcg_malloc (sizeof (struct str_invisible_nonterminal));
  load_string (bf, &new -> fname);
  load_int (bf, &new -> line);
  load_int (bf, &new -> col);
  load_string_list (bf, &new -> name);
  load_int (bf, &new -> arity);
  *x = new;
}

/* Recursively load a element */
void load_element (BinFile bf, element *x)
{ /* load fixed fields before variant ones */
  element new = (element) dcg_malloc (sizeof (struct str_element));
  load_string (bf, &new -> name);
  new -> enr = int_nil;
  new -> dom = domain_nil;
  new -> log_value = int_nil;
  new -> value = affix_value_nil;
  *x = new;
}

/* Recursively load a domain */
void load_domain (BinFile bf, domain *x)
{ /* load fixed fields before variant ones */
  domain new = (domain) dcg_malloc (sizeof (struct str_domain));
  load_int_list (bf, &new -> elts);
  new -> dnr = int_nil;
  new -> width = int_nil;
  *x = new;
}

/* Recursively load a regexp */
void load_regexp (BinFile bf, regexp *x)
{ /* load fixed fields before variant ones */
  regexp new = (regexp) dcg_malloc (sizeof (struct str_regexp));
  char ch;
  load_char (bf, &ch);
  new -> tag = (tags_regexp) ch;
  switch (new -> tag)
    { case TAGRegexp_or:
	load_regexp_list (bf, &new -> Regexp_or.subs);
	break;
      case TAGRegexp_concat:
	load_regexp_list (bf, &new -> Regexp_concat.subs);
	break;
      case TAGRegexp_star:
	load_regexp (bf, &new -> Regexp_star.sub);
	break;
      case TAGRegexp_plus:
	load_regexp (bf, &new -> Regexp_plus.sub);
	break;
      case TAGRegexp_opt:
	load_regexp (bf, &new -> Regexp_opt.sub);
	break;
      case TAGRegexp_cset:
	load_int (bf, &new -> Regexp_cset.cs);
	break;
      case TAGRegexp_char:
	load_int (bf, &new -> Regexp_char.ch);
	break;
      case TAGRegexp_anychar:
	break;
      case TAGRegexp_whitespace:
	break;
      case TAGRegexp_nonwhitespace:
	break;
      case TAGRegexp_empty:
	break;
      default:
	dcg_bad_tag (new -> tag, "load_regexp");
    };
  *x = new;
}

/* Recursively load a name */
void load_name (BinFile bf, name *x)
{ /* load fixed fields before variant ones */
  name new = (name) dcg_malloc (sizeof (struct str_name));
  load_int (bf, &new -> line);
  load_int (bf, &new -> col);
  load_string_list (bf, &new -> id);
  *x = new;
}

/* Recursively load a call_solution */
void load_call_solution (BinFile bf, call_solution *x)
{ /* load fixed fields before variant ones */
  call_solution new = (call_solution) dcg_malloc (sizeof (struct str_call_solution));
  new -> rdef = rule_nil;
  load_affix_term_list (bf, &new -> apars);
  load_int (bf, &new -> nr_matches);
  *x = new;
}

/* Recursively load a madm */
void load_madm (BinFile bf, madm *x)
{ /* load fixed fields before variant ones */
  madm new = (madm) dcg_malloc (sizeof (struct str_madm));
  char ch;
  load_char (bf, &ch);
  new -> tag = (tags_madm) ch;
  switch (new -> tag)
    { case TAGRule_adm:
	new -> Rule_adm.terms = affix_term_list_nil;
	new -> Rule_adm.iptr = int_nil;
	new -> Rule_adm.goal = affix_rule_nil;
	new -> Rule_adm.complete = int_nil;
	break;
      case TAGMember_adm:
	new -> Member_adm.arule = affix_rule_nil;
	load_int (bf, &new -> Member_adm.alt_nr);
	load_int (bf, &new -> Member_adm.mem_nr);
	break;
      default:
	dcg_bad_tag (new -> tag, "load_madm");
    };
  *x = new;
}

/* Recursively load a grammar_list */
void load_grammar_list (BinFile bf, grammar_list *l)
{ int ix, size;
  grammar_list new;
  loadsize (bf, &size);
  new = init_grammar_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_grammar (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a prule_list */
void load_prule_list (BinFile bf, prule_list *l)
{ int ix, size;
  prule_list new;
  loadsize (bf, &size);
  new = init_prule_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_prule (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a plhs_list */
void load_plhs_list (BinFile bf, plhs_list *l)
{ int ix, size;
  plhs_list new;
  loadsize (bf, &size);
  new = init_plhs_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_plhs (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a rule_list */
void load_rule_list (BinFile bf, rule_list *l)
{ int ix, size;
  rule_list new;
  loadsize (bf, &size);
  new = init_rule_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_rule (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a rdecl_list */
void load_rdecl_list (BinFile bf, rdecl_list *l)
{ int ix, size;
  rdecl_list new;
  loadsize (bf, &size);
  new = init_rdecl_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_rdecl (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a variable_list */
void load_variable_list (BinFile bf, variable_list *l)
{ int ix, size;
  variable_list new;
  loadsize (bf, &size);
  new = init_variable_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_variable (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a definition_list */
void load_definition_list (BinFile bf, definition_list *l)
{ int ix, size;
  definition_list new;
  loadsize (bf, &size);
  new = init_definition_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_definition (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a fpar_list */
void load_fpar_list (BinFile bf, fpar_list *l)
{ int ix, size;
  fpar_list new;
  loadsize (bf, &size);
  new = init_fpar_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_fpar (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a dir_list */
void load_dir_list (BinFile bf, dir_list *l)
{ int ix, size;
  dir_list new;
  loadsize (bf, &size);
  new = init_dir_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_dir (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a alternative_list */
void load_alternative_list (BinFile bf, alternative_list *l)
{ int ix, size;
  alternative_list new;
  loadsize (bf, &size);
  new = init_alternative_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_alternative (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a fwo_group_list */
void load_fwo_group_list (BinFile bf, fwo_group_list *l)
{ int ix, size;
  fwo_group_list new;
  loadsize (bf, &size);
  new = init_fwo_group_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_fwo_group (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a member_list */
void load_member_list (BinFile bf, member_list *l)
{ int ix, size;
  member_list new;
  loadsize (bf, &size);
  new = init_member_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_member (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a apar_list */
void load_apar_list (BinFile bf, apar_list *l)
{ int ix, size;
  apar_list new;
  loadsize (bf, &size);
  new = init_apar_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_apar (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a confrontation_list */
void load_confrontation_list (BinFile bf, confrontation_list *l)
{ int ix, size;
  confrontation_list new;
  loadsize (bf, &size);
  new = init_confrontation_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_confrontation (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a res_conf_list */
void load_res_conf_list (BinFile bf, res_conf_list *l)
{ int ix, size;
  res_conf_list new;
  loadsize (bf, &size);
  new = init_res_conf_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_res_conf (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a affix_term_list */
void load_affix_term_list (BinFile bf, affix_term_list *l)
{ int ix, size;
  affix_term_list new;
  loadsize (bf, &size);
  new = init_affix_term_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_affix_term (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a trans_member_list */
void load_trans_member_list (BinFile bf, trans_member_list *l)
{ int ix, size;
  trans_member_list new;
  loadsize (bf, &size);
  new = init_trans_member_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_trans_member (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a affix_rule_list */
void load_affix_rule_list (BinFile bf, affix_rule_list *l)
{ int ix, size;
  affix_rule_list new;
  loadsize (bf, &size);
  new = init_affix_rule_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_affix_rule (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a affix_alternative_list */
void load_affix_alternative_list (BinFile bf, affix_alternative_list *l)
{ int ix, size;
  affix_alternative_list new;
  loadsize (bf, &size);
  new = init_affix_alternative_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_affix_alternative (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a affix_element_list */
void load_affix_element_list (BinFile bf, affix_element_list *l)
{ int ix, size;
  affix_element_list new;
  loadsize (bf, &size);
  new = init_affix_element_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_affix_element (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a invisible_nonterminal_list */
void load_invisible_nonterminal_list (BinFile bf, invisible_nonterminal_list *l)
{ int ix, size;
  invisible_nonterminal_list new;
  loadsize (bf, &size);
  new = init_invisible_nonterminal_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_invisible_nonterminal (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a element_list */
void load_element_list (BinFile bf, element_list *l)
{ int ix, size;
  element_list new;
  loadsize (bf, &size);
  new = init_element_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_element (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a domain_list */
void load_domain_list (BinFile bf, domain_list *l)
{ int ix, size;
  domain_list new;
  loadsize (bf, &size);
  new = init_domain_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_domain (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a regexp_list */
void load_regexp_list (BinFile bf, regexp_list *l)
{ int ix, size;
  regexp_list new;
  loadsize (bf, &size);
  new = init_regexp_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_regexp (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a name_list */
void load_name_list (BinFile bf, name_list *l)
{ int ix, size;
  name_list new;
  loadsize (bf, &size);
  new = init_name_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_name (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a call_solution_list */
void load_call_solution_list (BinFile bf, call_solution_list *l)
{ int ix, size;
  call_solution_list new;
  loadsize (bf, &size);
  new = init_call_solution_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_call_solution (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively load a madm_list */
void load_madm_list (BinFile bf, madm_list *l)
{ int ix, size;
  madm_list new;
  loadsize (bf, &size);
  new = init_madm_list (size);
  new -> size = size;
  for (ix = 0; ix < size; ix++)
    load_madm (bf, &new -> array[ix]);
  *l = new;
}

/* Recursively duplicate a grammar */
grammar rdup_grammar (grammar old)
{ /* allocate new record */
  grammar new;
  if (old == grammar_nil) return (old);
  new = (grammar) dcg_malloc (sizeof (struct str_grammar));

  /* duplicate fixed fields before variant ones */
  new -> fname = rdup_string (old -> fname);
  new -> gname = rdup_string (old -> gname);
  new -> uses = rdup_string_list (old -> uses);
  new -> lexica = rdup_string_list (old -> lexica);
  new -> fact_tables = rdup_string_list (old -> fact_tables);
  new -> triple_databases = rdup_string_list (old -> triple_databases);
  new -> exp_prules = rdup_prule_list (old -> exp_prules);
  new -> prules = rdup_prule_list (old -> prules);
  new -> arules = rdup_affix_rule_list (old -> arules);
  new -> root_call = rdup_member (old -> root_call);
  return (new);
}

/* Recursively duplicate a prule */
prule rdup_prule (prule old)
{ /* allocate new record */
  prule new;
  if (old == prule_nil) return (old);
  new = (prule) dcg_malloc (sizeof (struct str_prule));

  /* duplicate fixed fields before variant ones */
  new -> lhs = rdup_plhs (old -> lhs);
  new -> tag = old -> tag;
  switch (old -> tag)
    { case TAGExt_prule:
	new -> Ext_prule.ename = rdup_string (old -> Ext_prule.ename);
	break;
      case TAGQuasi_prule:
	new -> Quasi_prule.rname = rdup_string (old -> Quasi_prule.rname);
	break;
      case TAGProto_rule:
	new -> Proto_rule.grp = rdup_group (old -> Proto_rule.grp);
	break;
      case TAGPspec:
	break;
      case TAGPstart:
	break;
      default:
	dcg_bad_tag (old -> tag, "rdup_prule");
    };
  return (new);
}

/* Recursively duplicate a plhs */
plhs rdup_plhs (plhs old)
{ /* allocate new record */
  plhs new;
  if (old == plhs_nil) return (old);
  new = (plhs) dcg_malloc (sizeof (struct str_plhs));

  /* duplicate fixed fields before variant ones */
  new -> line = rdup_int (old -> line);
  new -> col = rdup_int (old -> col);
  new -> rlayer = rdup_rule_layer (old -> rlayer);
  new -> rkind = rdup_rule_kind (old -> rkind);
  new -> rtype = rdup_rule_type (old -> rtype);
  new -> rname_parts = rdup_string_list (old -> rname_parts);
  new -> rname_chars = rdup_int_list (old -> rname_chars);
  new -> lhs_pars = rdup_fpar_list (old -> lhs_pars);
  return (new);
}

/* Recursively duplicate a rule */
rule rdup_rule (rule old)
{ /* allocate new record */
  rule new;
  if (old == rule_nil) return (old);
  new = (rule) dcg_malloc (sizeof (struct str_rule));

  /* duplicate fixed fields before variant ones */
  new -> rspec = rdup_spec (old -> rspec);
  new -> tag = old -> tag;
  switch (old -> tag)
    { case TAGExt_rule:
	new -> Ext_rule.ename = rdup_string (old -> Ext_rule.ename);
	break;
      case TAGQuasi_rule:
	new -> Quasi_rule.rname = rdup_string (old -> Quasi_rule.rname);
	break;
      case TAGDefs:
	new -> Defs.defs = rdup_definition_list (old -> Defs.defs);
	break;
      case TAGAnonymous_option:
	new -> Anonymous_option.grp = rdup_group (old -> Anonymous_option.grp);
	break;
      case TAGAnonymous_group:
	new -> Anonymous_group.grp = rdup_group (old -> Anonymous_group.grp);
	break;
      default:
	dcg_bad_tag (old -> tag, "rdup_rule");
    };
  return (new);
}

/* Recursively duplicate a spec */
spec rdup_spec (spec old)
{ /* allocate new record */
  spec new;
  if (old == spec_nil) return (old);
  new = (spec) dcg_malloc (sizeof (struct str_spec));

  /* duplicate fixed fields before variant ones */
  new -> rlayer = rdup_rule_layer (old -> rlayer);
  new -> rkind = rdup_rule_kind (old -> rkind);
  new -> rtype = rdup_rule_type (old -> rtype);
  new -> rname_parts = rdup_string_list (old -> rname_parts);
  new -> rname_chars = rdup_int_list (old -> rname_chars);
  new -> rsig = rdup_affix_rule_list (old -> rsig);
  new -> dirs = rdup_dir_list (old -> dirs);
  return (new);
}

/* Recursively duplicate a rdecl */
rdecl rdup_rdecl (rdecl old)
{ /* allocate new record */
  rdecl new;
  if (old == rdecl_nil) return (old);
  new = (rdecl) dcg_malloc (sizeof (struct str_rdecl));

  /* duplicate fixed fields before variant ones */
  return (new);
}

/* Recursively duplicate a variable */
variable rdup_variable (variable old)
{ /* allocate new record */
  variable new;
  if (old == variable_nil) return (old);
  new = (variable) dcg_malloc (sizeof (struct str_variable));

  /* duplicate fixed fields before variant ones */
  new -> vname = rdup_string (old -> vname);
  return (new);
}

/* Recursively duplicate a definition */
definition rdup_definition (definition old)
{ /* allocate new record */
  definition new;
  if (old == definition_nil) return (old);
  new = (definition) dcg_malloc (sizeof (struct str_definition));

  /* duplicate fixed fields before variant ones */
  new -> lhs_pars = rdup_fpar_list (old -> lhs_pars);
  new -> locals = rdup_variable_list (old -> locals);
  new -> grp = rdup_group (old -> grp);
  return (new);
}

/* Recursively duplicate a fpar */
fpar rdup_fpar (fpar old)
{ /* allocate new record */
  fpar new;
  if (old == fpar_nil) return (old);
  new = (fpar) dcg_malloc (sizeof (struct str_fpar));

  /* duplicate fixed fields before variant ones */
  new -> line = rdup_int (old -> line);
  new -> col = rdup_int (old -> col);
  new -> fdir = rdup_dir (old -> fdir);
  new -> fexp = rdup_affix_term_list (old -> fexp);
  return (new);
}

/* Recursively duplicate a group */
group rdup_group (group old)
{ /* allocate new record */
  group new;
  if (old == group_nil) return (old);
  new = (group) dcg_malloc (sizeof (struct str_group));

  /* duplicate fixed fields before variant ones */
  new -> alts = rdup_alternative_list (old -> alts);
  return (new);
}

/* Recursively duplicate a alternative */
alternative rdup_alternative (alternative old)
{ /* allocate new record */
  alternative new;
  if (old == alternative_nil) return (old);
  new = (alternative) dcg_malloc (sizeof (struct str_alternative));

  /* duplicate fixed fields before variant ones */
  new -> line = rdup_int (old -> line);
  new -> col = rdup_int (old -> col);
  new -> freq = rdup_real (old -> freq);
  new -> members = rdup_fwo_group_list (old -> members);
  new -> commited = rdup_int (old -> commited);
  new -> trans = rdup_trans_member_list (old -> trans);
  return (new);
}

/* Recursively duplicate a fwo_group */
fwo_group rdup_fwo_group (fwo_group old)
{ /* allocate new record */
  fwo_group new;
  if (old == fwo_group_nil) return (old);
  new = (fwo_group) dcg_malloc (sizeof (struct str_fwo_group));

  /* duplicate fixed fields before variant ones */
  new -> gl = rdup_glue (old -> gl);
  new -> tag = old -> tag;
  switch (old -> tag)
    { case TAGSingle:
	new -> Single.mem = rdup_member (old -> Single.mem);
	break;
      case TAGFwo:
	new -> Fwo.mems = rdup_member_list (old -> Fwo.mems);
	break;
      default:
	dcg_bad_tag (old -> tag, "rdup_fwo_group");
    };
  return (new);
}

/* Recursively duplicate a member */
member rdup_member (member old)
{ /* allocate new record */
  member new;
  if (old == member_nil) return (old);
  new = (member) dcg_malloc (sizeof (struct str_member));

  /* duplicate fixed fields before variant ones */
  new -> line = rdup_int (old -> line);
  new -> col = rdup_int (old -> col);
  new -> tag = old -> tag;
  switch (old -> tag)
    { case TAGCall:
	new -> Call.rname_parts = rdup_string_list (old -> Call.rname_parts);
	new -> Call.rname_chars = rdup_int_list (old -> Call.rname_chars);
	new -> Call.apars = rdup_apar_list (old -> Call.apars);
	break;
      case TAGGuard:
	new -> Guard.confs = rdup_confrontation_list (old -> Guard.confs);
	break;
      case TAGTerm:
	new -> Term.text = rdup_string (old -> Term.text);
	new -> Term.par = rdup_apar (old -> Term.par);
	break;
      case TAGQuasi:
	new -> Quasi.qname_parts = rdup_string_list (old -> Quasi.qname_parts);
	new -> Quasi.qname_chars = rdup_int_list (old -> Quasi.qname_chars);
	new -> Quasi.args = rdup_apar_list (old -> Quasi.args);
	break;
      case TAGOp:
	new -> Op.op = rdup_control_op (old -> Op.op);
	break;
      case TAGGroup:
	new -> Group.grp = rdup_group (old -> Group.grp);
	break;
      case TAGOption:
	new -> Option.grp = rdup_group (old -> Option.grp);
	break;
      case TAGRes_guard:
	new -> Res_guard.rconfs = rdup_res_conf_list (old -> Res_guard.rconfs);
	break;
      case TAGRes_call:
	new -> Res_call.args = rdup_affix_term_list (old -> Res_call.args);
	new -> Res_call.adirs = rdup_dir_list (old -> Res_call.adirs);
	break;
      case TAGRes_term:
	new -> Res_term.text = rdup_string (old -> Res_term.text);
	new -> Res_term.adir = rdup_dir (old -> Res_term.adir);
	new -> Res_term.arg = rdup_affix_term (old -> Res_term.arg);
	break;
      default:
	dcg_bad_tag (old -> tag, "rdup_member");
    };
  return (new);
}

/* Recursively duplicate a apar */
apar rdup_apar (apar old)
{ /* allocate new record */
  apar new;
  if (old == apar_nil) return (old);
  new = (apar) dcg_malloc (sizeof (struct str_apar));

  /* duplicate fixed fields before variant ones */
  new -> adir = rdup_dir (old -> adir);
  new -> aexp = rdup_affix_term_list (old -> aexp);
  return (new);
}

/* Recursively duplicate a confrontation */
confrontation rdup_confrontation (confrontation old)
{ /* allocate new record */
  confrontation new;
  if (old == confrontation_nil) return (old);
  new = (confrontation) dcg_malloc (sizeof (struct str_confrontation));

  /* duplicate fixed fields before variant ones */
  new -> line = rdup_int (old -> line);
  new -> col = rdup_int (old -> col);
  new -> typ = rdup_guard_type (old -> typ);
  new -> lhs = rdup_affix_term_list (old -> lhs);
  new -> rhs = rdup_affix_term_list (old -> rhs);
  return (new);
}

/* Recursively duplicate a res_conf */
res_conf rdup_res_conf (res_conf old)
{ /* allocate new record */
  res_conf new;
  if (old == res_conf_nil) return (old);
  new = (res_conf) dcg_malloc (sizeof (struct str_res_conf));

  /* duplicate fixed fields before variant ones */
  new -> typ = rdup_guard_type (old -> typ);
  new -> lhs = rdup_affix_term (old -> lhs);
  new -> rhs = rdup_affix_term (old -> rhs);
  return (new);
}

/* Recursively duplicate a affix_term */
affix_term rdup_affix_term (affix_term old)
{ /* allocate new record */
  affix_term new;
  if (old == affix_term_nil) return (old);
  new = (affix_term) dcg_malloc (sizeof (struct str_affix_term));

  /* duplicate fixed fields before variant ones */
  new -> line = rdup_int (old -> line);
  new -> col = rdup_int (old -> col);
  new -> tag = old -> tag;
  switch (old -> tag)
    { case TAGTerminal:
	new -> Terminal.marker = rdup_string (old -> Terminal.marker);
	break;
      case TAGDyop:
	new -> Dyop.dop = rdup_operator (old -> Dyop.dop);
	new -> Dyop.arg1 = rdup_affix_term (old -> Dyop.arg1);
	new -> Dyop.arg2 = rdup_affix_term (old -> Dyop.arg2);
	break;
      case TAGMonop:
	new -> Monop.mop = rdup_operator (old -> Monop.mop);
	new -> Monop.arg = rdup_affix_term (old -> Monop.arg);
	break;
      case TAGEnclosed:
	new -> Enclosed.terms = rdup_affix_term_list (old -> Enclosed.terms);
	break;
      case TAGAst:
	new -> Ast.terms = rdup_affix_term_list (old -> Ast.terms);
	new -> Ast.altnr = rdup_int (old -> Ast.altnr);
	break;
      case TAGConcat:
	new -> Concat.terms = rdup_affix_term_list (old -> Concat.terms);
	break;
      case TAGInt:
	new -> Int.num = rdup_int (old -> Int.num);
	break;
      case TAGReal:
	new -> Real.num = rdup_real (old -> Real.num);
	break;
      case TAGText:
	new -> Text.txt = rdup_string (old -> Text.txt);
	break;
      case TAGRegexp:
	new -> Regexp.text = rdup_string (old -> Regexp.text);
	break;
      case TAGVar:
	new -> Var.aname = rdup_string (old -> Var.aname);
	break;
      default:
	dcg_bad_tag (old -> tag, "rdup_affix_term");
    };
  return (new);
}

/* Recursively duplicate a trans_member */
trans_member rdup_trans_member (trans_member old)
{ /* allocate new record */
  trans_member new;
  if (old == trans_member_nil) return (old);
  new = (trans_member) dcg_malloc (sizeof (struct str_trans_member));

  /* duplicate fixed fields before variant ones */
  new -> line = rdup_int (old -> line);
  new -> col = rdup_int (old -> col);
  new -> gl = rdup_glue (old -> gl);
  new -> tag = old -> tag;
  switch (old -> tag)
    { case TAGTcall:
	new -> Tcall.cname = rdup_string_list (old -> Tcall.cname);
	new -> Tcall.nr = rdup_int (old -> Tcall.nr);
	break;
      case TAGTquasi:
	new -> Tquasi.qname = rdup_string (old -> Tquasi.qname);
	new -> Tquasi.nr = rdup_int (old -> Tquasi.nr);
	break;
      case TAGTgroup:
	new -> Tgroup.nr = rdup_int (old -> Tgroup.nr);
	break;
      case TAGToption:
	new -> Toption.nr = rdup_int (old -> Toption.nr);
	break;
      case TAGTtext:
	new -> Ttext.text = rdup_string (old -> Ttext.text);
	break;
      case TAGTvar:
	new -> Tvar.aname = rdup_string (old -> Tvar.aname);
	break;
      case TAGThybrid:
	new -> Thybrid.op = rdup_hyb_op (old -> Thybrid.op);
	break;
      default:
	dcg_bad_tag (old -> tag, "rdup_trans_member");
    };
  return (new);
}

/* Recursively duplicate a hyb_op */
hyb_op rdup_hyb_op (hyb_op old)
{ /* allocate new record */
  hyb_op new;
  if (old == hyb_op_nil) return (old);
  new = (hyb_op) dcg_malloc (sizeof (struct str_hyb_op));

  /* duplicate fixed fields before variant ones */
  new -> tag = old -> tag;
  switch (old -> tag)
    { case TAGHyb_sqr_open:
	break;
      case TAGHyb_sqr_close:
	break;
      case TAGHyb_curl_open:
	break;
      case TAGHyb_curl_close:
	break;
      case TAGHyb_bar:
	break;
      case TAGHyb_rel_left:
	new -> Hyb_rel_left.rname = rdup_string (old -> Hyb_rel_left.rname);
	break;
      case TAGHyb_rel_right:
	new -> Hyb_rel_right.rname = rdup_string (old -> Hyb_rel_right.rname);
	break;
      default:
	dcg_bad_tag (old -> tag, "rdup_hyb_op");
    };
  return (new);
}

/* Recursively duplicate a affix_rule */
affix_rule rdup_affix_rule (affix_rule old)
{ /* allocate new record */
  affix_rule new;
  if (old == affix_rule_nil) return (old);
  new = (affix_rule) dcg_malloc (sizeof (struct str_affix_rule));

  /* duplicate fixed fields before variant ones */
  new -> line = rdup_int (old -> line);
  new -> col = rdup_int (old -> col);
  new -> aname = rdup_string (old -> aname);
  new -> tag = old -> tag;
  switch (old -> tag)
    { case TAGAffix_synonym:
	new -> Affix_synonym.syn = rdup_string (old -> Affix_synonym.syn);
	break;
      case TAGAffix_alts:
	new -> Affix_alts.alts = rdup_affix_alternative_list (old -> Affix_alts.alts);
	break;
      case TAGAffix_prim:
	break;
      default:
	dcg_bad_tag (old -> tag, "rdup_affix_rule");
    };
  return (new);
}

/* Recursively duplicate a affix_alternative */
affix_alternative rdup_affix_alternative (affix_alternative old)
{ /* allocate new record */
  affix_alternative new;
  if (old == affix_alternative_nil) return (old);
  new = (affix_alternative) dcg_malloc (sizeof (struct str_affix_alternative));

  /* duplicate fixed fields before variant ones */
  new -> elems = rdup_affix_element_list (old -> elems);
  new -> tag = old -> tag;
  switch (old -> tag)
    { case TAGAffix_sequence:
	break;
      case TAGAffix_concat:
	break;
      case TAGAffix_union:
	break;
      case TAGAffix_partition:
	break;
      case TAGAffix_single:
	break;
      case TAGAffix_empty:
	break;
      default:
	dcg_bad_tag (old -> tag, "rdup_affix_alternative");
    };
  return (new);
}

/* Recursively duplicate a affix_element */
affix_element rdup_affix_element (affix_element old)
{ /* allocate new record */
  affix_element new;
  if (old == affix_element_nil) return (old);
  new = (affix_element) dcg_malloc (sizeof (struct str_affix_element));

  /* duplicate fixed fields before variant ones */
  new -> line = rdup_int (old -> line);
  new -> col = rdup_int (old -> col);
  new -> tag = old -> tag;
  switch (old -> tag)
    { case TAGAffix_var:
	new -> Affix_var.vname = rdup_string (old -> Affix_var.vname);
	break;
      case TAGAffix_term:
	new -> Affix_term.tname = rdup_string (old -> Affix_term.tname);
	break;
      case TAGAffix_text:
	new -> Affix_text.text = rdup_string (old -> Affix_text.text);
	break;
      case TAGAffix_inum:
	new -> Affix_inum.ival = rdup_int (old -> Affix_inum.ival);
	break;
      case TAGAffix_rnum:
	new -> Affix_rnum.rval = rdup_real (old -> Affix_rnum.rval);
	break;
      default:
	dcg_bad_tag (old -> tag, "rdup_affix_element");
    };
  return (new);
}

/* Recursively duplicate a invisible_nonterminal */
invisible_nonterminal rdup_invisible_nonterminal (invisible_nonterminal old)
{ /* allocate new record */
  invisible_nonterminal new;
  if (old == invisible_nonterminal_nil) return (old);
  new = (invisible_nonterminal) dcg_malloc (sizeof (struct str_invisible_nonterminal));

  /* duplicate fixed fields before variant ones */
  new -> fname = rdup_string (old -> fname);
  new -> line = rdup_int (old -> line);
  new -> col = rdup_int (old -> col);
  new -> name = rdup_string_list (old -> name);
  new -> arity = rdup_int (old -> arity);
  return (new);
}

/* Recursively duplicate a element */
element rdup_element (element old)
{ /* allocate new record */
  element new;
  if (old == element_nil) return (old);
  new = (element) dcg_malloc (sizeof (struct str_element));

  /* duplicate fixed fields before variant ones */
  new -> name = rdup_string (old -> name);
  return (new);
}

/* Recursively duplicate a domain */
domain rdup_domain (domain old)
{ /* allocate new record */
  domain new;
  if (old == domain_nil) return (old);
  new = (domain) dcg_malloc (sizeof (struct str_domain));

  /* duplicate fixed fields before variant ones */
  new -> elts = rdup_int_list (old -> elts);
  return (new);
}

/* Recursively duplicate a regexp */
regexp rdup_regexp (regexp old)
{ /* allocate new record */
  regexp new;
  if (old == regexp_nil) return (old);
  new = (regexp) dcg_malloc (sizeof (struct str_regexp));

  /* duplicate fixed fields before variant ones */
  new -> tag = old -> tag;
  switch (old -> tag)
    { case TAGRegexp_or:
	new -> Regexp_or.subs = rdup_regexp_list (old -> Regexp_or.subs);
	break;
      case TAGRegexp_concat:
	new -> Regexp_concat.subs = rdup_regexp_list (old -> Regexp_concat.subs);
	break;
      case TAGRegexp_star:
	new -> Regexp_star.sub = rdup_regexp (old -> Regexp_star.sub);
	break;
      case TAGRegexp_plus:
	new -> Regexp_plus.sub = rdup_regexp (old -> Regexp_plus.sub);
	break;
      case TAGRegexp_opt:
	new -> Regexp_opt.sub = rdup_regexp (old -> Regexp_opt.sub);
	break;
      case TAGRegexp_cset:
	new -> Regexp_cset.cs = rdup_int (old -> Regexp_cset.cs);
	break;
      case TAGRegexp_char:
	new -> Regexp_char.ch = rdup_int (old -> Regexp_char.ch);
	break;
      case TAGRegexp_anychar:
	break;
      case TAGRegexp_whitespace:
	break;
      case TAGRegexp_nonwhitespace:
	break;
      case TAGRegexp_empty:
	break;
      default:
	dcg_bad_tag (old -> tag, "rdup_regexp");
    };
  return (new);
}

/* Recursively duplicate a name */
name rdup_name (name old)
{ /* allocate new record */
  name new;
  if (old == name_nil) return (old);
  new = (name) dcg_malloc (sizeof (struct str_name));

  /* duplicate fixed fields before variant ones */
  new -> line = rdup_int (old -> line);
  new -> col = rdup_int (old -> col);
  new -> id = rdup_string_list (old -> id);
  return (new);
}

/* Recursively duplicate a call_solution */
call_solution rdup_call_solution (call_solution old)
{ /* allocate new record */
  call_solution new;
  if (old == call_solution_nil) return (old);
  new = (call_solution) dcg_malloc (sizeof (struct str_call_solution));

  /* duplicate fixed fields before variant ones */
  new -> apars = rdup_affix_term_list (old -> apars);
  new -> nr_matches = rdup_int (old -> nr_matches);
  return (new);
}

/* Recursively duplicate a madm */
madm rdup_madm (madm old)
{ /* allocate new record */
  madm new;
  if (old == madm_nil) return (old);
  new = (madm) dcg_malloc (sizeof (struct str_madm));

  /* duplicate fixed fields before variant ones */
  new -> tag = old -> tag;
  switch (old -> tag)
    { case TAGRule_adm:
	break;
      case TAGMember_adm:
	new -> Member_adm.alt_nr = rdup_int (old -> Member_adm.alt_nr);
	new -> Member_adm.mem_nr = rdup_int (old -> Member_adm.mem_nr);
	break;
      default:
	dcg_bad_tag (old -> tag, "rdup_madm");
    };
  return (new);
}

/* Recursively duplicate a grammar_list */
grammar_list rdup_grammar_list (grammar_list old)
{ grammar_list new;
  int ix;
  if (old == grammar_list_nil) return (old);
  new = init_grammar_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_grammar_list (new, rdup_grammar (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a prule_list */
prule_list rdup_prule_list (prule_list old)
{ prule_list new;
  int ix;
  if (old == prule_list_nil) return (old);
  new = init_prule_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_prule_list (new, rdup_prule (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a plhs_list */
plhs_list rdup_plhs_list (plhs_list old)
{ plhs_list new;
  int ix;
  if (old == plhs_list_nil) return (old);
  new = init_plhs_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_plhs_list (new, rdup_plhs (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a rule_list */
rule_list rdup_rule_list (rule_list old)
{ rule_list new;
  int ix;
  if (old == rule_list_nil) return (old);
  new = init_rule_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_rule_list (new, rdup_rule (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a rdecl_list */
rdecl_list rdup_rdecl_list (rdecl_list old)
{ rdecl_list new;
  int ix;
  if (old == rdecl_list_nil) return (old);
  new = init_rdecl_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_rdecl_list (new, rdup_rdecl (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a variable_list */
variable_list rdup_variable_list (variable_list old)
{ variable_list new;
  int ix;
  if (old == variable_list_nil) return (old);
  new = init_variable_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_variable_list (new, rdup_variable (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a definition_list */
definition_list rdup_definition_list (definition_list old)
{ definition_list new;
  int ix;
  if (old == definition_list_nil) return (old);
  new = init_definition_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_definition_list (new, rdup_definition (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a fpar_list */
fpar_list rdup_fpar_list (fpar_list old)
{ fpar_list new;
  int ix;
  if (old == fpar_list_nil) return (old);
  new = init_fpar_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_fpar_list (new, rdup_fpar (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a dir_list */
dir_list rdup_dir_list (dir_list old)
{ dir_list new;
  int ix;
  if (old == dir_list_nil) return (old);
  new = init_dir_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_dir_list (new, rdup_dir (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a alternative_list */
alternative_list rdup_alternative_list (alternative_list old)
{ alternative_list new;
  int ix;
  if (old == alternative_list_nil) return (old);
  new = init_alternative_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_alternative_list (new, rdup_alternative (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a fwo_group_list */
fwo_group_list rdup_fwo_group_list (fwo_group_list old)
{ fwo_group_list new;
  int ix;
  if (old == fwo_group_list_nil) return (old);
  new = init_fwo_group_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_fwo_group_list (new, rdup_fwo_group (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a member_list */
member_list rdup_member_list (member_list old)
{ member_list new;
  int ix;
  if (old == member_list_nil) return (old);
  new = init_member_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_member_list (new, rdup_member (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a apar_list */
apar_list rdup_apar_list (apar_list old)
{ apar_list new;
  int ix;
  if (old == apar_list_nil) return (old);
  new = init_apar_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_apar_list (new, rdup_apar (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a confrontation_list */
confrontation_list rdup_confrontation_list (confrontation_list old)
{ confrontation_list new;
  int ix;
  if (old == confrontation_list_nil) return (old);
  new = init_confrontation_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_confrontation_list (new, rdup_confrontation (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a res_conf_list */
res_conf_list rdup_res_conf_list (res_conf_list old)
{ res_conf_list new;
  int ix;
  if (old == res_conf_list_nil) return (old);
  new = init_res_conf_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_res_conf_list (new, rdup_res_conf (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a affix_term_list */
affix_term_list rdup_affix_term_list (affix_term_list old)
{ affix_term_list new;
  int ix;
  if (old == affix_term_list_nil) return (old);
  new = init_affix_term_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_affix_term_list (new, rdup_affix_term (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a trans_member_list */
trans_member_list rdup_trans_member_list (trans_member_list old)
{ trans_member_list new;
  int ix;
  if (old == trans_member_list_nil) return (old);
  new = init_trans_member_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_trans_member_list (new, rdup_trans_member (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a affix_rule_list */
affix_rule_list rdup_affix_rule_list (affix_rule_list old)
{ affix_rule_list new;
  int ix;
  if (old == affix_rule_list_nil) return (old);
  new = init_affix_rule_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_affix_rule_list (new, rdup_affix_rule (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a affix_alternative_list */
affix_alternative_list rdup_affix_alternative_list (affix_alternative_list old)
{ affix_alternative_list new;
  int ix;
  if (old == affix_alternative_list_nil) return (old);
  new = init_affix_alternative_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_affix_alternative_list (new, rdup_affix_alternative (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a affix_element_list */
affix_element_list rdup_affix_element_list (affix_element_list old)
{ affix_element_list new;
  int ix;
  if (old == affix_element_list_nil) return (old);
  new = init_affix_element_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_affix_element_list (new, rdup_affix_element (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a invisible_nonterminal_list */
invisible_nonterminal_list rdup_invisible_nonterminal_list (invisible_nonterminal_list old)
{ invisible_nonterminal_list new;
  int ix;
  if (old == invisible_nonterminal_list_nil) return (old);
  new = init_invisible_nonterminal_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_invisible_nonterminal_list (new, rdup_invisible_nonterminal (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a element_list */
element_list rdup_element_list (element_list old)
{ element_list new;
  int ix;
  if (old == element_list_nil) return (old);
  new = init_element_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_element_list (new, rdup_element (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a domain_list */
domain_list rdup_domain_list (domain_list old)
{ domain_list new;
  int ix;
  if (old == domain_list_nil) return (old);
  new = init_domain_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_domain_list (new, rdup_domain (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a regexp_list */
regexp_list rdup_regexp_list (regexp_list old)
{ regexp_list new;
  int ix;
  if (old == regexp_list_nil) return (old);
  new = init_regexp_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_regexp_list (new, rdup_regexp (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a name_list */
name_list rdup_name_list (name_list old)
{ name_list new;
  int ix;
  if (old == name_list_nil) return (old);
  new = init_name_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_name_list (new, rdup_name (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a call_solution_list */
call_solution_list rdup_call_solution_list (call_solution_list old)
{ call_solution_list new;
  int ix;
  if (old == call_solution_list_nil) return (old);
  new = init_call_solution_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_call_solution_list (new, rdup_call_solution (old -> array[ix]));
  return (new);
}

/* Recursively duplicate a madm_list */
madm_list rdup_madm_list (madm_list old)
{ madm_list new;
  int ix;
  if (old == madm_list_nil) return (old);
  new = init_madm_list (old -> size);
  for (ix = 0; ix < old -> size; ix++)
    app_madm_list (new, rdup_madm (old -> array[ix]));
  return (new);
}

/* Recursively check the ref counts of a grammar */
void check_not_freed_grammar (grammar curr)
{ if (curr == grammar_nil) return;
  check_not_freed_string (curr -> fname);
  check_not_freed_string (curr -> gname);
  check_not_freed_string_list (curr -> uses);
  check_not_freed_string_list (curr -> lexica);
  check_not_freed_string_list (curr -> fact_tables);
  check_not_freed_string_list (curr -> triple_databases);
  check_not_freed_prule_list (curr -> exp_prules);
  check_not_freed_prule_list (curr -> prules);
  check_not_freed_affix_rule_list (curr -> arules);
  check_not_freed_member (curr -> root_call);
}

/* Recursively check the ref counts of a prule */
void check_not_freed_prule (prule curr)
{ if (curr == prule_nil) return;
  check_not_freed_plhs (curr -> lhs);
  switch (curr -> tag)
    { case TAGExt_prule:
	check_not_freed_string (curr -> Ext_prule.ename);
	break;
      case TAGQuasi_prule:
	check_not_freed_string (curr -> Quasi_prule.rname);
	break;
      case TAGProto_rule:
	check_not_freed_group (curr -> Proto_rule.grp);
	break;
      case TAGPspec:
	break;
      case TAGPstart:
	break;
      default:
	dcg_bad_tag (curr -> tag, "check_not_freed_prule");
    };
}

/* Recursively check the ref counts of a plhs */
void check_not_freed_plhs (plhs curr)
{ if (curr == plhs_nil) return;
  check_not_freed_int (curr -> line);
  check_not_freed_int (curr -> col);
  check_not_freed_rule_layer (curr -> rlayer);
  check_not_freed_rule_kind (curr -> rkind);
  check_not_freed_rule_type (curr -> rtype);
  check_not_freed_string_list (curr -> rname_parts);
  check_not_freed_int_list (curr -> rname_chars);
  check_not_freed_fpar_list (curr -> lhs_pars);
}

/* Recursively check the ref counts of a rule */
void check_not_freed_rule (rule curr)
{ if (curr == rule_nil) return;
  check_not_freed_spec (curr -> rspec);
  switch (curr -> tag)
    { case TAGExt_rule:
	check_not_freed_string (curr -> Ext_rule.ename);
	break;
      case TAGQuasi_rule:
	check_not_freed_string (curr -> Quasi_rule.rname);
	break;
      case TAGDefs:
	check_not_freed_definition_list (curr -> Defs.defs);
	break;
      case TAGAnonymous_option:
	check_not_freed_group (curr -> Anonymous_option.grp);
	break;
      case TAGAnonymous_group:
	check_not_freed_group (curr -> Anonymous_group.grp);
	break;
      default:
	dcg_bad_tag (curr -> tag, "check_not_freed_rule");
    };
}

/* Recursively check the ref counts of a spec */
void check_not_freed_spec (spec curr)
{ if (curr == spec_nil) return;
  check_not_freed_rule_layer (curr -> rlayer);
  check_not_freed_rule_kind (curr -> rkind);
  check_not_freed_rule_type (curr -> rtype);
  check_not_freed_string_list (curr -> rname_parts);
  check_not_freed_int_list (curr -> rname_chars);
  check_not_freed_affix_rule_list (curr -> rsig);
  check_not_freed_dir_list (curr -> dirs);
}

/* Recursively check the ref counts of a rdecl */
void check_not_freed_rdecl (rdecl curr)
{ if (curr == rdecl_nil) return;
}

/* Recursively check the ref counts of a variable */
void check_not_freed_variable (variable curr)
{ if (curr == variable_nil) return;
  check_not_freed_string (curr -> vname);
}

/* Recursively check the ref counts of a definition */
void check_not_freed_definition (definition curr)
{ if (curr == definition_nil) return;
  check_not_freed_fpar_list (curr -> lhs_pars);
  check_not_freed_variable_list (curr -> locals);
  check_not_freed_group (curr -> grp);
}

/* Recursively check the ref counts of a fpar */
void check_not_freed_fpar (fpar curr)
{ if (curr == fpar_nil) return;
  check_not_freed_int (curr -> line);
  check_not_freed_int (curr -> col);
  check_not_freed_dir (curr -> fdir);
  check_not_freed_affix_term_list (curr -> fexp);
}

/* Recursively check the ref counts of a group */
void check_not_freed_group (group curr)
{ if (curr == group_nil) return;
  check_not_freed_alternative_list (curr -> alts);
}

/* Recursively check the ref counts of a alternative */
void check_not_freed_alternative (alternative curr)
{ if (curr == alternative_nil) return;
  check_not_freed_int (curr -> line);
  check_not_freed_int (curr -> col);
  check_not_freed_real (curr -> freq);
  check_not_freed_fwo_group_list (curr -> members);
  check_not_freed_int (curr -> commited);
  check_not_freed_trans_member_list (curr -> trans);
}

/* Recursively check the ref counts of a fwo_group */
void check_not_freed_fwo_group (fwo_group curr)
{ if (curr == fwo_group_nil) return;
  check_not_freed_glue (curr -> gl);
  switch (curr -> tag)
    { case TAGSingle:
	check_not_freed_member (curr -> Single.mem);
	break;
      case TAGFwo:
	check_not_freed_member_list (curr -> Fwo.mems);
	break;
      default:
	dcg_bad_tag (curr -> tag, "check_not_freed_fwo_group");
    };
}

/* Recursively check the ref counts of a member */
void check_not_freed_member (member curr)
{ if (curr == member_nil) return;
  check_not_freed_int (curr -> line);
  check_not_freed_int (curr -> col);
  switch (curr -> tag)
    { case TAGCall:
	check_not_freed_string_list (curr -> Call.rname_parts);
	check_not_freed_int_list (curr -> Call.rname_chars);
	check_not_freed_apar_list (curr -> Call.apars);
	break;
      case TAGGuard:
	check_not_freed_confrontation_list (curr -> Guard.confs);
	break;
      case TAGTerm:
	check_not_freed_string (curr -> Term.text);
	check_not_freed_apar (curr -> Term.par);
	break;
      case TAGQuasi:
	check_not_freed_string_list (curr -> Quasi.qname_parts);
	check_not_freed_int_list (curr -> Quasi.qname_chars);
	check_not_freed_apar_list (curr -> Quasi.args);
	break;
      case TAGOp:
	check_not_freed_control_op (curr -> Op.op);
	break;
      case TAGGroup:
	check_not_freed_group (curr -> Group.grp);
	break;
      case TAGOption:
	check_not_freed_group (curr -> Option.grp);
	break;
      case TAGRes_guard:
	check_not_freed_res_conf_list (curr -> Res_guard.rconfs);
	break;
      case TAGRes_call:
	check_not_freed_affix_term_list (curr -> Res_call.args);
	check_not_freed_dir_list (curr -> Res_call.adirs);
	break;
      case TAGRes_term:
	check_not_freed_string (curr -> Res_term.text);
	check_not_freed_dir (curr -> Res_term.adir);
	check_not_freed_affix_term (curr -> Res_term.arg);
	break;
      default:
	dcg_bad_tag (curr -> tag, "check_not_freed_member");
    };
}

/* Recursively check the ref counts of a apar */
void check_not_freed_apar (apar curr)
{ if (curr == apar_nil) return;
  check_not_freed_dir (curr -> adir);
  check_not_freed_affix_term_list (curr -> aexp);
}

/* Recursively check the ref counts of a confrontation */
void check_not_freed_confrontation (confrontation curr)
{ if (curr == confrontation_nil) return;
  check_not_freed_int (curr -> line);
  check_not_freed_int (curr -> col);
  check_not_freed_guard_type (curr -> typ);
  check_not_freed_affix_term_list (curr -> lhs);
  check_not_freed_affix_term_list (curr -> rhs);
}

/* Recursively check the ref counts of a res_conf */
void check_not_freed_res_conf (res_conf curr)
{ if (curr == res_conf_nil) return;
  check_not_freed_guard_type (curr -> typ);
  check_not_freed_affix_term (curr -> lhs);
  check_not_freed_affix_term (curr -> rhs);
}

/* Recursively check the ref counts of a affix_term */
void check_not_freed_affix_term (affix_term curr)
{ if (curr == affix_term_nil) return;
  check_not_freed_int (curr -> line);
  check_not_freed_int (curr -> col);
  switch (curr -> tag)
    { case TAGTerminal:
	check_not_freed_string (curr -> Terminal.marker);
	break;
      case TAGDyop:
	check_not_freed_operator (curr -> Dyop.dop);
	check_not_freed_affix_term (curr -> Dyop.arg1);
	check_not_freed_affix_term (curr -> Dyop.arg2);
	break;
      case TAGMonop:
	check_not_freed_operator (curr -> Monop.mop);
	check_not_freed_affix_term (curr -> Monop.arg);
	break;
      case TAGEnclosed:
	check_not_freed_affix_term_list (curr -> Enclosed.terms);
	break;
      case TAGAst:
	check_not_freed_affix_term_list (curr -> Ast.terms);
	check_not_freed_int (curr -> Ast.altnr);
	break;
      case TAGConcat:
	check_not_freed_affix_term_list (curr -> Concat.terms);
	break;
      case TAGInt:
	check_not_freed_int (curr -> Int.num);
	break;
      case TAGReal:
	check_not_freed_real (curr -> Real.num);
	break;
      case TAGText:
	check_not_freed_string (curr -> Text.txt);
	break;
      case TAGRegexp:
	check_not_freed_string (curr -> Regexp.text);
	break;
      case TAGVar:
	check_not_freed_string (curr -> Var.aname);
	break;
      default:
	dcg_bad_tag (curr -> tag, "check_not_freed_affix_term");
    };
}

/* Recursively check the ref counts of a trans_member */
void check_not_freed_trans_member (trans_member curr)
{ if (curr == trans_member_nil) return;
  check_not_freed_int (curr -> line);
  check_not_freed_int (curr -> col);
  check_not_freed_glue (curr -> gl);
  switch (curr -> tag)
    { case TAGTcall:
	check_not_freed_string_list (curr -> Tcall.cname);
	check_not_freed_int (curr -> Tcall.nr);
	break;
      case TAGTquasi:
	check_not_freed_string (curr -> Tquasi.qname);
	check_not_freed_int (curr -> Tquasi.nr);
	break;
      case TAGTgroup:
	check_not_freed_int (curr -> Tgroup.nr);
	break;
      case TAGToption:
	check_not_freed_int (curr -> Toption.nr);
	break;
      case TAGTtext:
	check_not_freed_string (curr -> Ttext.text);
	break;
      case TAGTvar:
	check_not_freed_string (curr -> Tvar.aname);
	break;
      case TAGThybrid:
	check_not_freed_hyb_op (curr -> Thybrid.op);
	break;
      default:
	dcg_bad_tag (curr -> tag, "check_not_freed_trans_member");
    };
}

/* Recursively check the ref counts of a hyb_op */
void check_not_freed_hyb_op (hyb_op curr)
{ if (curr == hyb_op_nil) return;
  switch (curr -> tag)
    { case TAGHyb_sqr_open:
	break;
      case TAGHyb_sqr_close:
	break;
      case TAGHyb_curl_open:
	break;
      case TAGHyb_curl_close:
	break;
      case TAGHyb_bar:
	break;
      case TAGHyb_rel_left:
	check_not_freed_string (curr -> Hyb_rel_left.rname);
	break;
      case TAGHyb_rel_right:
	check_not_freed_string (curr -> Hyb_rel_right.rname);
	break;
      default:
	dcg_bad_tag (curr -> tag, "check_not_freed_hyb_op");
    };
}

/* Recursively check the ref counts of a affix_rule */
void check_not_freed_affix_rule (affix_rule curr)
{ if (curr == affix_rule_nil) return;
  check_not_freed_int (curr -> line);
  check_not_freed_int (curr -> col);
  check_not_freed_string (curr -> aname);
  switch (curr -> tag)
    { case TAGAffix_synonym:
	check_not_freed_string (curr -> Affix_synonym.syn);
	break;
      case TAGAffix_alts:
	check_not_freed_affix_alternative_list (curr -> Affix_alts.alts);
	break;
      case TAGAffix_prim:
	break;
      default:
	dcg_bad_tag (curr -> tag, "check_not_freed_affix_rule");
    };
}

/* Recursively check the ref counts of a affix_alternative */
void check_not_freed_affix_alternative (affix_alternative curr)
{ if (curr == affix_alternative_nil) return;
  check_not_freed_affix_element_list (curr -> elems);
  switch (curr -> tag)
    { case TAGAffix_sequence:
	break;
      case TAGAffix_concat:
	break;
      case TAGAffix_union:
	break;
      case TAGAffix_partition:
	break;
      case TAGAffix_single:
	break;
      case TAGAffix_empty:
	break;
      default:
	dcg_bad_tag (curr -> tag, "check_not_freed_affix_alternative");
    };
}

/* Recursively check the ref counts of a affix_element */
void check_not_freed_affix_element (affix_element curr)
{ if (curr == affix_element_nil) return;
  check_not_freed_int (curr -> line);
  check_not_freed_int (curr -> col);
  switch (curr -> tag)
    { case TAGAffix_var:
	check_not_freed_string (curr -> Affix_var.vname);
	break;
      case TAGAffix_term:
	check_not_freed_string (curr -> Affix_term.tname);
	break;
      case TAGAffix_text:
	check_not_freed_string (curr -> Affix_text.text);
	break;
      case TAGAffix_inum:
	check_not_freed_int (curr -> Affix_inum.ival);
	break;
      case TAGAffix_rnum:
	check_not_freed_real (curr -> Affix_rnum.rval);
	break;
      default:
	dcg_bad_tag (curr -> tag, "check_not_freed_affix_element");
    };
}

/* Recursively check the ref counts of a invisible_nonterminal */
void check_not_freed_invisible_nonterminal (invisible_nonterminal curr)
{ if (curr == invisible_nonterminal_nil) return;
  check_not_freed_string (curr -> fname);
  check_not_freed_int (curr -> line);
  check_not_freed_int (curr -> col);
  check_not_freed_string_list (curr -> name);
  check_not_freed_int (curr -> arity);
}

/* Recursively check the ref counts of a element */
void check_not_freed_element (element curr)
{ if (curr == element_nil) return;
  check_not_freed_string (curr -> name);
}

/* Recursively check the ref counts of a domain */
void check_not_freed_domain (domain curr)
{ if (curr == domain_nil) return;
  check_not_freed_int_list (curr -> elts);
}

/* Recursively check the ref counts of a regexp */
void check_not_freed_regexp (regexp curr)
{ if (curr == regexp_nil) return;
  switch (curr -> tag)
    { case TAGRegexp_or:
	check_not_freed_regexp_list (curr -> Regexp_or.subs);
	break;
      case TAGRegexp_concat:
	check_not_freed_regexp_list (curr -> Regexp_concat.subs);
	break;
      case TAGRegexp_star:
	check_not_freed_regexp (curr -> Regexp_star.sub);
	break;
      case TAGRegexp_plus:
	check_not_freed_regexp (curr -> Regexp_plus.sub);
	break;
      case TAGRegexp_opt:
	check_not_freed_regexp (curr -> Regexp_opt.sub);
	break;
      case TAGRegexp_cset:
	check_not_freed_int (curr -> Regexp_cset.cs);
	break;
      case TAGRegexp_char:
	check_not_freed_int (curr -> Regexp_char.ch);
	break;
      case TAGRegexp_anychar:
	break;
      case TAGRegexp_whitespace:
	break;
      case TAGRegexp_nonwhitespace:
	break;
      case TAGRegexp_empty:
	break;
      default:
	dcg_bad_tag (curr -> tag, "check_not_freed_regexp");
    };
}

/* Recursively check the ref counts of a name */
void check_not_freed_name (name curr)
{ if (curr == name_nil) return;
  check_not_freed_int (curr -> line);
  check_not_freed_int (curr -> col);
  check_not_freed_string_list (curr -> id);
}

/* Recursively check the ref counts of a call_solution */
void check_not_freed_call_solution (call_solution curr)
{ if (curr == call_solution_nil) return;
  check_not_freed_affix_term_list (curr -> apars);
  check_not_freed_int (curr -> nr_matches);
}

/* Recursively check the ref counts of a madm */
void check_not_freed_madm (madm curr)
{ if (curr == madm_nil) return;
  switch (curr -> tag)
    { case TAGRule_adm:
	break;
      case TAGMember_adm:
	check_not_freed_int (curr -> Member_adm.alt_nr);
	check_not_freed_int (curr -> Member_adm.mem_nr);
	break;
      default:
	dcg_bad_tag (curr -> tag, "check_not_freed_madm");
    };
}

/* Recursively check the refcounts of a grammar_list */
void check_not_freed_grammar_list (grammar_list curr)
{ int ix;
  if (curr == grammar_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_grammar (curr -> array[ix]);
}

/* Recursively check the refcounts of a prule_list */
void check_not_freed_prule_list (prule_list curr)
{ int ix;
  if (curr == prule_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_prule (curr -> array[ix]);
}

/* Recursively check the refcounts of a plhs_list */
void check_not_freed_plhs_list (plhs_list curr)
{ int ix;
  if (curr == plhs_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_plhs (curr -> array[ix]);
}

/* Recursively check the refcounts of a rule_list */
void check_not_freed_rule_list (rule_list curr)
{ int ix;
  if (curr == rule_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_rule (curr -> array[ix]);
}

/* Recursively check the refcounts of a rdecl_list */
void check_not_freed_rdecl_list (rdecl_list curr)
{ int ix;
  if (curr == rdecl_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_rdecl (curr -> array[ix]);
}

/* Recursively check the refcounts of a variable_list */
void check_not_freed_variable_list (variable_list curr)
{ int ix;
  if (curr == variable_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_variable (curr -> array[ix]);
}

/* Recursively check the refcounts of a definition_list */
void check_not_freed_definition_list (definition_list curr)
{ int ix;
  if (curr == definition_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_definition (curr -> array[ix]);
}

/* Recursively check the refcounts of a fpar_list */
void check_not_freed_fpar_list (fpar_list curr)
{ int ix;
  if (curr == fpar_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_fpar (curr -> array[ix]);
}

/* Recursively check the refcounts of a dir_list */
void check_not_freed_dir_list (dir_list curr)
{ int ix;
  if (curr == dir_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_dir (curr -> array[ix]);
}

/* Recursively check the refcounts of a alternative_list */
void check_not_freed_alternative_list (alternative_list curr)
{ int ix;
  if (curr == alternative_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_alternative (curr -> array[ix]);
}

/* Recursively check the refcounts of a fwo_group_list */
void check_not_freed_fwo_group_list (fwo_group_list curr)
{ int ix;
  if (curr == fwo_group_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_fwo_group (curr -> array[ix]);
}

/* Recursively check the refcounts of a member_list */
void check_not_freed_member_list (member_list curr)
{ int ix;
  if (curr == member_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_member (curr -> array[ix]);
}

/* Recursively check the refcounts of a apar_list */
void check_not_freed_apar_list (apar_list curr)
{ int ix;
  if (curr == apar_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_apar (curr -> array[ix]);
}

/* Recursively check the refcounts of a confrontation_list */
void check_not_freed_confrontation_list (confrontation_list curr)
{ int ix;
  if (curr == confrontation_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_confrontation (curr -> array[ix]);
}

/* Recursively check the refcounts of a res_conf_list */
void check_not_freed_res_conf_list (res_conf_list curr)
{ int ix;
  if (curr == res_conf_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_res_conf (curr -> array[ix]);
}

/* Recursively check the refcounts of a affix_term_list */
void check_not_freed_affix_term_list (affix_term_list curr)
{ int ix;
  if (curr == affix_term_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_affix_term (curr -> array[ix]);
}

/* Recursively check the refcounts of a trans_member_list */
void check_not_freed_trans_member_list (trans_member_list curr)
{ int ix;
  if (curr == trans_member_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_trans_member (curr -> array[ix]);
}

/* Recursively check the refcounts of a affix_rule_list */
void check_not_freed_affix_rule_list (affix_rule_list curr)
{ int ix;
  if (curr == affix_rule_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_affix_rule (curr -> array[ix]);
}

/* Recursively check the refcounts of a affix_alternative_list */
void check_not_freed_affix_alternative_list (affix_alternative_list curr)
{ int ix;
  if (curr == affix_alternative_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_affix_alternative (curr -> array[ix]);
}

/* Recursively check the refcounts of a affix_element_list */
void check_not_freed_affix_element_list (affix_element_list curr)
{ int ix;
  if (curr == affix_element_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_affix_element (curr -> array[ix]);
}

/* Recursively check the refcounts of a invisible_nonterminal_list */
void check_not_freed_invisible_nonterminal_list (invisible_nonterminal_list curr)
{ int ix;
  if (curr == invisible_nonterminal_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_invisible_nonterminal (curr -> array[ix]);
}

/* Recursively check the refcounts of a element_list */
void check_not_freed_element_list (element_list curr)
{ int ix;
  if (curr == element_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_element (curr -> array[ix]);
}

/* Recursively check the refcounts of a domain_list */
void check_not_freed_domain_list (domain_list curr)
{ int ix;
  if (curr == domain_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_domain (curr -> array[ix]);
}

/* Recursively check the refcounts of a regexp_list */
void check_not_freed_regexp_list (regexp_list curr)
{ int ix;
  if (curr == regexp_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_regexp (curr -> array[ix]);
}

/* Recursively check the refcounts of a name_list */
void check_not_freed_name_list (name_list curr)
{ int ix;
  if (curr == name_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_name (curr -> array[ix]);
}

/* Recursively check the refcounts of a call_solution_list */
void check_not_freed_call_solution_list (call_solution_list curr)
{ int ix;
  if (curr == call_solution_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_call_solution (curr -> array[ix]);
}

/* Recursively check the refcounts of a madm_list */
void check_not_freed_madm_list (madm_list curr)
{ int ix;
  if (curr == madm_list_nil) return;
  for (ix = 0; ix < curr -> size; ix++)
    check_not_freed_madm (curr -> array[ix]);
}

