/*
   File: backend.c
   Finishes the compilation by compiling the generated c code and
   linking the code into a shared object that can be dynamically
   loaded by the EAG3 runtime system.

   Copyright (C) 2012 Marc Seutter

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: backend.c,v 1.5 2012/09/21 11:01:18 marcs Exp $"
*/

/* include <config.h> if autoconfigured */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

/* global includes */
#include <stdio.h>
#include <stdlib.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <sys/types.h>

/* libdcg includes */
#include <dcg.h>
#include <dcg_error.h>
#include <dcg_string.h>
#include <dcg_procutil.h>

/* local includes */
#include "code_common.h"
#include "options.h"

/* TMPDIR is the usual environment variable to consult */ 
#ifndef TMPDIR
#define TMPDIR "TMPDIR"
#endif

/* Define the usual default temporary directory */
#ifndef DEFAULT_TMP_DIR
#define DEFAULT_TMP_DIR "/tmp"
#endif

/* Define the default include directory */
#ifndef INCDIR
#define INCDIR "/usr/local/share/eag3/include"
#endif

/* Define the default include directory */
#ifndef DCGINCDIR
#define DCGINCDIR "/usr/local/share/mimir/include"
#endif

/* Define the default lib directory */
#ifndef LIBDIR
#define LIBDIR "/usr/local/lib"
#endif

/* Define the default include directory */
#ifndef DCGLIBDIR
#define DCGLIBDIR "/usr/local/lib"
#endif

#ifndef WIN32
static char *object_fname;
static void do_compile ()
{ char *cc_argv[32];
  int status;
  int ix = 0;

  /* We do not want to leave the object code in place */
  char *temp_dir = getenv (TMPDIR);
  if (temp_dir == NULL) temp_dir = DEFAULT_TMP_DIR;
  object_fname = dcg_new_fmtd_string ("%s%ceag3_%d.lo", temp_dir, DIR_SEP, (int) getpid ());

  /* Fill in the argument vector to assemble */
  dcg_warning (0, "   compiling generated C code...");
  cc_argv[ix++] = "gcc";
  cc_argv[ix++] = "-fpic";
  cc_argv[ix++] = "-finline-functions";
  if (code_for_debug) cc_argv[ix++] = "-g";
  cc_argv[ix++] = "-I";
  cc_argv[ix++] = INCDIR;
  cc_argv[ix++] = "-I";
  cc_argv[ix++] = DCGINCDIR;
  cc_argv[ix++] = "-c";
  cc_argv[ix++] = c_code_fname;
  if (code_for_debug) cc_argv[ix++] = "-O0";
  else cc_argv[ix++] = "-O2";
  cc_argv[ix++] = "-Wall";
  cc_argv[ix++] = "-o";
  cc_argv[ix++] = object_fname;
  cc_argv[ix] = NULL;
  status = dcg_spawn_and_wait (cc_argv);

  /* Delete the generated c_code file when not debugging */
  if (!code_for_debug && unlink (c_code_fname))
    dcg_panic ("could not delete '%s'", c_code_fname);
  if (status) dcg_exit (4);
}

static void do_link ()
{ char *ld_argv[32];
  char *so_name;
  int status;
  int ix = 0;

  /* Define the name of the executable */
  if (output_fname != NULL)             /* -o name given */
    so_name = output_fname;
  else so_name = dcg_new_fmtd_string ("%s%c%s.so", dir_name, DIR_SEP, base_gname);

  /* Fill in the argument vector to link */
  dcg_warning (0, "   linking object code...");
  ld_argv[ix++] = "gcc";
  ld_argv[ix++] = "-o";
  ld_argv[ix++] = so_name;
  ld_argv[ix++] = "-shared";
  ld_argv[ix++] = object_fname;
  if (code_for_debug) ld_argv[ix++] = "-g";
  ld_argv[ix++] = dcg_new_fmtd_string ("-L%s", LIBDIR);
  ld_argv[ix++] = "-Wl,--rpath";
  ld_argv[ix++] = dcg_new_fmtd_string ("-Wl,%s", LIBDIR);
  ld_argv[ix++] = "-leagrts";
  ld_argv[ix++] = "-leagbase";
  ld_argv[ix++] = dcg_new_fmtd_string ("-L%s", DCGLIBDIR);
  ld_argv[ix++] = "-Wl,--rpath";
  ld_argv[ix++] = dcg_new_fmtd_string ("-Wl,%s", DCGLIBDIR);
  ld_argv[ix++] = "-ldcg";
  ld_argv[ix++] = "-ldcg2";
  ld_argv[ix++] = "-lm";
  ld_argv[ix] = NULL;
  status = dcg_spawn_and_wait (ld_argv);

  /* Delete the generated object file */
  if (unlink (object_fname))
    dcg_panic ("could not delete '%s'", object_fname);
  if (status) dcg_exit (4);
}
#endif

void compile_c_and_link ()
{ /* If we only have to generate assembler, we are done */
  if (no_code || generate_c_only) return;
#ifndef WIN32
  do_compile ();
  do_link ();
#endif
}

