import os
import numpy
import scipy.interpolate as interpolate
import string

def linelst(lrange, shortlst, longlst=os.getenv('HOME')+'/cats/Kurucz/linelists/gfall.dat'):
#    print 'Hello'
#    print longlst
    
    h = 6.6260688e-27
    c = 2.9979246e+10
    ev = 1.60218e-12
    
    fl = open(longlst,'r')
    fs = open(shortlst,'w')
    
    fs.write('Line list from Kurucz\n')
    
    for s in fl:
        lam   = float(s[0:11])
        loggf = float(s[11:18])
        elem  = float(s[18:24])
        elo   = float(s[24:36])
        
        lam_aa = lam * 10.0
        if ((lam_aa > lrange[0]) and (lam_aa < lrange[1])):
#            print lam_aa, loggf, elem, elo
            x1 = int(elem)
            x2 = (elem - x1)*10.
            elem_out = x1 + x2
            elo_out = h * c * elo / ev
            if (x2 < 0.299) and (elo_out < 50):
                fs.write('{0:10.3f}{1:10.3f}{2:10.3f}{3:10.3f}\n'.format(lam_aa,elem_out,elo_out,loggf))

    fl.close()    
    fs.close()
    

def kur2moog(kname, mname, vturb, m):
    fk = open(kname,'r')
    fm = open(mname,'w')
    
#    natoms = len(atoms)
  
    s = fk.readline()
    ss = s.split()
    teff = ss[1]
    logg = ss[3]
    
    while (ss[0] != 'READ'):
        s = fk.readline()
        ss = s.split()
        
    ntau = int(ss[2])
  
    fm.write('KURUCZ\n')
    fm.write('Teff = '+str(teff)+' K, Logg = '+str(logg)+'\n')
    fm.write('NTAU'+str(ntau).rjust(11)+'\n')
    
    for i in range(ntau):
        s = fk.readline()
        fm.write(s)
        
    fm.write('{0:13.11f}\n'.format(vturb))
#    fm.write('NATOMS     {0:d}  {1:f}\n'.format(natoms,m))
#    for i in range(natoms):
#        fm.write('    {0:d}  {1:0.5f}\n'.format(atoms[i], abun[i]))
    fm.write('NATOMS       0   {0:f}\n'.format(m))

# No molecules for now!!
    fm.write('NMOL       0\n\n')

    fm.close()
    fk.close()


def moogspec(m, atmname, spname, vturb = 2.0, atoms=[], abun=[], synlimits=[6478., 6512., 0.1, 10.0], linelist='linelist.txt'):
    
    kur2moog(atmname,'moog.atm', vturb, m)
    fm = open('batch.par','w')
    
    natoms = len(atoms)
    
    print('MOOG: Computing synthetic spectrum '+spname)
    
    fm.write('synth\n')
    fm.write('atmosphere  1\n')
    fm.write('molecules   1\n')
    fm.write('trudamp     1\n')
    fm.write('damping     0\n')
    fm.write('lines       1\n')
    fm.write('units       0\n')
    fm.write('abundances  {0:d} {1:d}\n'.format(natoms,1))
    for i in range(natoms):
        fm.write('  {0:d}  {1:0.2f}\n'.format(atoms[i], abun[i]))

    fm.write('synlimits\n')
    fm.write(' {0:0.3f}   {1:0.3f}   {2:0.3f}   {3:0.3f}\n'.format(synlimits[0]-10,synlimits[1]+10,synlimits[2],synlimits[3]))
    fm.write('fluxlimits\n')
    fm.write(' {0:0.3f}   {1:0.3f}   {2:0.3f}\n'.format(synlimits[0]-10.,synlimits[1]+10.,synlimits[2]))
    fm.write('plot        0\n')
#    fm.write('plotpars    1\n')
#    fm.write(' {0:0.1f}   {1:0.1f}   0.0   2.0\n'.format(synlimits[0],synlimits[1]))
#    fm.write(' 0.0  0.0  0.0  0.0\n')
#    fm.write(' g   1.0  0.0  0.0  0.0  0.0\n')
    fm.write('freeform    0\n')
    fm.write('iraf        1\n')
    fm.write('standard_out   \'moog.out\'\n')
    fm.write('summary_out    \'moog.summ\'\n')
#    fm.write('smoothed_out   \''+spname+'\'\n')
    fm.write('iraf_out       \'moog.iraf\'\n')
    fm.write('model_in       \'moog.atm\'\n')
    fm.write('lines_in       \''+linelist+'\'\n')
    fm.close()
    
#    os.system('moogsilent >& /dev/null')
    os.system('moogsilent_g77 >& /dev/null')
    
# Read continuum fluxes from moog.out

    fo = open('moog.out','r')
    lamc, cont = [], []

    for s in fo:
        if (s.find('CONTINUUM FLUX/INTENSITY') > 0):
            ss = s.split()
            scont = string.replace(ss[7],'D','E')
            lamc = lamc + [float(ss[3])]
            cont = cont + [float(scont)]
    
    fo.close()
    fcont = interpolate.interp1d(lamc, cont, bounds_error=False)
        
# Convert the MOOG 'Iraf' format spectrum to two-column (lambda, flux) format and scale to continuum
    
    fir = open('moog.iraf','r')
    fsp = open(spname,'w')
    
    s = fir.readline()
    while (s.find('END') != 0):
        fsp.write('# '+s)
#        print s
        ss = s.split()
        if (ss[0] == 'W0'):
            w0 = float(ss[2])
            
        if (ss[0] == 'WPC'):
            wpc = float(ss[2])    
    
        s = fir.readline()
        
    fsp.write('# '+s)
    
    s = fir.readline()
    lam = w0
    
    while (s != ''):
        ss = s.split()
        for flx in ss:
             fscl = float(flx)*fcont(lam)
             if (lam >= synlimits[0]) and (lam <= synlimits[1]):
                 fsp.write('{0:0.4f}  {1:0.4f}  {2:0.4e}\n'.format(lam, float(flx), fscl))
    
             lam = lam + wpc
             
        s = fir.readline()
        
        
    fsp.close()
    fir.close()    
        
    
def moogew(m, atmname, ewname, vturb = 2.0, atoms=[], abun=[], synlimits=[6478., 6512., 0.1, 10.0], linelist='linelist.txt'):
    
    kur2moog(atmname,'moog.atm', vturb, m)

# EWFIND apparently only handles a limited number of lines. 

    nlmax = 2500
    nltot = 0
    
    with open(linelist,'r') as f:
        for s in f:
            nltot = nltot+1

    nlf = nltot / nlmax + 1
    fll = open(linelist,'r')
    s = fll.readline()
    
    fe = open(ewname,'w')
    readew = False
    fe.write('# Wavelength      EP     logGF     Ident     Abund    EWcalc     Cont\n')
    
    j = 1
    for ilf in range(nlf):

        fsll = open('__llist.short','w')
        fsll.write('Line list\n')
        i = 0
           
        while (i < nlmax and s != ''):
            s = fll.readline()
            ss = s.split()
            if (s != ''):
                fsll.write(s)
                lam2 = float(ss[0])
                i2 = j
            
            if (i == 0):
                lam1 = float(ss[0])
                i1 = j

            i = i + 1 
            j = j + 1 

        
        fsll.close()
    

        fm = open('batch.par','w')
      
        natoms = len(atoms)
   
        print('MOOG: Computing equivalent widths '+ewname)
        print('      {0:d}-{1:d} lines of {2:d}, {3:0.3f}-{4:0.3f} AA'.format(i1,i2,nltot-1,lam1,lam2))
	    
        fm.write('doflux\n')
        fm.write('atmosphere  1\n')
        fm.write('molecules   1\n')
        fm.write('trudamp     1\n')
        fm.write('lines       1\n')
        fm.write('units       0\n')
        fm.write('abundances  {0:d} {1:d}\n'.format(natoms,1))
        for i in range(natoms):
            fm.write('  {0:d}  {1:0.2f}\n'.format(atoms[i], abun[i]))
	
        fm.write('synlimits\n')
        fm.write(' {0:0.3f}   {1:0.3f}   {2:0.3f}   {3:0.3f}\n'.format(lam1-10,lam2+10,synlimits[2],synlimits[3]))
        fm.write('fluxlimits\n')
        fm.write(' {0:0.3f}   {1:0.3f}   1.0\n'.format(lam1-10.,lam2+10.,synlimits[2]))
        fm.write('plot        0\n')
#        fm.write('plotpars    1\n')
#        fm.write(' {0:0.1f}   {1:0.1f}   0.0   2.0\n'.format(synlimits[0],synlimits[1]))
#        fm.write(' 0.0  0.0  0.0  0.0\n')
#        fm.write(' g   1.0  0.0  0.0  0.0  0.0\n')
        fm.write('freeform    0\n')
        fm.write('iraf        0\n')
        fm.write('standard_out   \'moog.out\'\n')
        fm.write('summary_out    \'moog.summ\'\n')
#        fm.write('smoothed_out   \''+spname+'\'\n')
#        fm.write('iraf_out       \'moog.iraf\'\n')
        fm.write('model_in       \'moog.atm\'\n')
        fm.write('lines_in       \'__llist.short\'\n')
        fm.close()
    #        os.system('moogsilent_gfortran >& /dev/null')
    
# Read continuum fluxes from moog.out

        os.system('moogsilent >& /dev/null')
        lamc, cont = [], []
	
        with open('moog.out','r') as f:
            for s in f:
                if (s.find('CONTINUUM FLUX/INTENSITY') > 0):
                    ss = s.split()
                    scont = string.replace(ss[7],'D','E')
                    lamc = lamc + [float(ss[3])]
                    cont = cont + [float(scont)]
    
        fcont = interpolate.interp1d(lamc, cont, bounds_error=False)
    
# Read the data for each line and write to ewname

        os.rename('batch.par','batch.par.TMP')
        fm = open('batch.par','w')
        
        with open('batch.par.TMP','r') as f:
            for s in f:
                if ('doflux' in s):
                    fm.write('ewfind\n')
                else:
                    fm.write(s)
        
        fm.close()
                
        os.system('moogsilent_gfortran >& /dev/null')

        with open('moog.summ','r') as f:
            for s in f:
                ss = s.split()
                if (readew):
                    lam = float(ss[0])
                    flam = float(fcont(lam))
                    fe.write('{0:s}   {1:0.2e}\n'.format(string.rstrip(s,'\n'),flam))
                    readew = False
    	            
                if (ss[0] == 'wavelength'):
                    readew = True
        
    fll.close()
    fe.close()
        
        
def sumew(ewfiles, weights, outfile):

    n_ew = len(ewfiles)
    lam   = []
    ep    = []
    loggf = []
    ident = []
    cflux = []
    abund = []
    ew    = []
    
    
    of = open(outfile,'w')
    of.write('# '+ewfiles[0]+' {0:0.4f}\n'.format(weights[0]))

    with open(ewfiles[0],'r') as f:
        for s in f:
            ss = s.split()
            if (ss[0] != '#'):
                lam.append(float(ss[0]))
                ep.append(float(ss[1]))
                loggf.append(float(ss[2]))
                ident.append(s[31:41])
                abund.append(float(ss[5]))
                ew.append(float(ss[6]))
                cflux.append(float(ss[7]))
    
    acflux = numpy.array(cflux)
    aew    = numpy.array(ew)
    cftot  = acflux * weights[0]
    sew    = aew * acflux * weights[0]
    

    for i in range(1,n_ew):
        cflux = []
        ew    = []

        of.write('# '+ewfiles[i]+' {0:0.4f}\n'.format(weights[i]))
  
        with open(ewfiles[i],'r') as f:
            for s in f:
                ss = s.split()
                if (ss[0] != '#'):
                    ew.append(float(ss[6]))
                    cflux.append(float(ss[7]))

        acflux = numpy.array(cflux)
        aew    = numpy.array(ew)
        sew = sew + aew * acflux * weights[i]
        cftot = cftot + acflux * weights[i]
  
    ewtot = sew / cftot
    
    of.write('# Wavelength      EP     logGF     Ident     Abund    EWcalc\n')

    
    for i in range(len(lam)):
        of.write('{0:10.2f} {1:9.2f} {2:9.3f} {3:s} {4:8.2f} {5:9.1f}\n'.format(lam[i], ep[i], loggf[i], ident[i], abund[i], ewtot[i]))
        
    of.close()
        
    
