import os

# Path to executable binaries (atlas, synthe, bsyn, etc).
# Important: the final '/' must be included.

# binpath = os.path.dirname(__file__)+'/bin/'
binpath = os.getenv('HOME')+'/bin/bin.Darwin/'
# binpath = os.getenv('HOME')+'/bin/'
# binpath = ''

# Prefix for cats/ directory
catpref = os.getenv('HOME')
# catpref = '/scratch/soeren'
# catpref = '/vol/astro-constant/slarsen'

# Directory for temporary files during model calculations

TMPROOT = '/Volumes/ramdisk'

# Maximum number of parallel processes

MAXPROC = 16

# Preset default abundances (Grevesse & Sauval 1998, Space Sci Rev 85, 161)
# These are relative to the total number density.

stdabun = [
#   ('H',   1,  0.92156),
#   ('He',  2,  0.078438),
   ('Li',  3, -10.94),
   ('Be',  4, -10.64),
   ('B' ,  5,  -9.49),
   ('C' ,  6,  -3.52),
   ('N' ,  7,  -4.12),
   ('O' ,  8,  -3.21),
   ('F' ,  9,  -7.48),
   ('Ne', 10,  -3.96),
   ('Na', 11,  -5.71),
   ('Mg', 12,  -4.46),
   ('Al', 13,  -5.57),
   ('Si', 14,  -4.49),
   ('P' , 15,  -6.59),
   ('S' , 16,  -4.71),
   ('Cl', 17,  -6.54),
   ('Ar', 18,  -5.64),
   ('K' , 19,  -6.92),
   ('Ca', 20,  -5.68),
   ('Sc', 21,  -8.87),
   ('Ti', 22,  -7.02),
   ('V' , 23,  -8.04),
   ('Cr', 24,  -6.37),
   ('Mn', 25,  -6.65),
   ('Fe', 26,  -4.54),
   ('Co', 27,  -7.12),
   ('Ni', 28,  -5.79),
   ('Cu', 29,  -7.83),
   ('Zn', 30,  -7.44),
   ('Ga', 31,  -9.16),
   ('Ge', 32,  -8.63),
   ('As', 33,  -9.67),
   ('Se', 34,  -8.63),
   ('Br', 35,  -9.41),
   ('Kr', 36,  -8.73),
   ('Rb', 37,  -9.44),
   ('Sr', 38,  -9.07),
   ('Y' , 39,  -9.80),
   ('Zr', 40,  -9.44),
   ('Nb', 41, -10.62),
   ('Mo', 42, -10.12),
   ('Tc', 43, -20.00),
   ('Ru', 44, -10.20),
   ('Rh', 45, -10.92),
   ('Pd', 46, -10.35),
   ('Ag', 47, -11.10),
   ('Cd', 48, -10.27),
   ('In', 49, -10.38),
   ('Sn', 50, -10.04),
   ('Sb', 51, -11.04),
   ('Te', 52,  -9.80),
   ('I' , 53, -10.53),
   ('Xe', 54,  -9.87),
   ('Cs', 55, -10.91),
   ('Ba', 56,  -9.91),
   ('La', 57, -10.87),
   ('Ce', 58, -10.46),
   ('Pr', 59, -11.33),
   ('Nd', 60, -10.54),
   ('Pm', 61, -20.00),
   ('Sm', 62, -11.03),
   ('Eu', 63, -11.53),
   ('Gd', 64, -10.92),
   ('Rb', 65, -11.69),
   ('Dy', 66, -10.90),
   ('Ho', 67, -11.78),
   ('Er', 68, -11.11),
   ('Tm', 69, -12.04),
   ('Yb', 70, -10.96),
   ('Lu', 71, -11.98),
   ('Hf', 72, -11.16),
   ('Ta', 73, -12.17),
   ('W' , 74, -10.93),
   ('Re', 75, -11.76),
   ('Os', 76, -10.59),
   ('Ir', 77, -10.69),
   ('Pt', 78, -10.24),
   ('Au', 79, -11.03),
   ('Hg', 80, -10.91),
   ('Tl', 81, -11.14),
   ('Pb', 82, -10.09),
   ('Bi', 83, -11.33),
   ('Po', 84, -20.00),
   ('At', 85, -20.00),
   ('Rn', 86, -20.00),
   ('Fr', 87, -20.00),
   ('Ra', 88, -20.00),
   ('Ac', 89, -20.00),
   ('Th', 90, -11.95),
   ('Pa', 91, -20.00),
   ('U' , 92, -12.54),
   ('Np', 93, -20.00),
   ('Pu', 94, -20.00),
   ('Am', 95, -20.00),
   ('Cm', 96, -20.00),
   ('Bk', 97, -20.00),
   ('Cf', 98, -20.00),
   ('Es', 99, -20.00)
]
