from . import absetup
import utils
import numpy

def linsel(ewlst, elem, ewmin=10, res=1e4):
    lam,loggf,E,code,fhfs,resid,ew = utils.getcol(ewlst,(0,1,2,3,4,5,6),skipstr='nan')    
    ids = code.astype('int')

    for kk in absetup.stdabun:
        if (kk[0] == elem): eid = kk[1]

    w = numpy.where((ids == eid) & (ew > ewmin))
    extlst = ['I','II','III','IV','V','VI','VII','VIII','IX','X']

    for _lam, _loggf, _E, _code, _fhfs, _resid, _ew in \
      zip(lam[w], loggf[w], E[w], code[w], fhfs[w], resid[w], ew[w]):

        eion = int((_code - eid)*100.1)

        sig = _lam / (res*2.35)
        maxdlam = sig*5

        dlam = abs(lam-_lam)
        ww = numpy.where((dlam < maxdlam) & (ids != eid))
        eother = sum(ew[ww]*numpy.exp(-dlam[ww]**2. / (2*sig**2.)))
#        print("%10.3f %6.1f %6.1f" % (elam, eew, eother))
        print("%10.3f %7.3f %12.3f %5.2f   %5.3f   %6.4f %7.1f  %2s %-4s %7.1f" % (_lam, _loggf, _E, _code, _fhfs, _resid, _ew, elem, extlst[eion], eother))
