# Stuff that pertains to local set-up. May be of limited relevance in a more
# general context, but can perhaps serve as examples.

from . import abutils
from . import fitabun
import utils
import numpy
import os
import getpass
import datetime
import platform
import scipy.interpolate as ip


def dosetup(elemfit, pfx, vfx, stelpar, fout, fnfnc, rvfnc, sigfnc, fcfnc, vac2air=False):
# This function must be called before dofit() 

    global Gelem
    global Gpfix
    global Gvfix
    global Gstelpar
    global Gfout
    global Gsetfname 
    global Gcalcrv
    global Gcalcsigsm
    global Gfncont
    global Gvac2air
    
    Gelem     = elemfit     # Element to fit (e.g. 'Fe')
    Gpfix     = pfx         # Names of fixed parameters
    Gvfix     = vfx         # Values of fixed parameters
    Gstelpar  = stelpar     # Stellar parameters
    Gfout     = fout        # Handle for output file (must be open for writing)
    Gsetfname  = fnfnc      # Function that returns filename
    Gcalcrv    = rvfnc      # Function that returns radial velocity
    Gcalcsigsm = sigfnc     # Function that returns sigma
    Gfncont    = fcfnc      # Function that returns name of continuum file
    Gvac2air   = vac2air    # Perform vacuum-to-air conversion?

    Gfout.write('# %s@%s %s\n' % (getpass.getuser(), os.uname()[1], os.getcwd()))
    Gfout.write('# Python %s %s %s %s\n' % 
              (platform.python_version(), os.uname()[0], 
               os.uname()[2], str(datetime.datetime.now()))
               )
    Gfout.flush()
    os.fsync(Gfout)

    return


def dofit(forder,rng,oname,fitfnc,fitord, nknots=5, fitrng=[-1.0, 1.0], 
          calcerr=True):

    lamc = (rng[0] + rng[1])/2.
    lamstep = 0.01

    fncont = Gfncont()
    if (fncont is None):
        cont = None
    else:
        if (utils.ncol(fncont) < 5):
            lc, fc = numpy.loadtxt(fncont,usecols=(0,3), unpack=True)
            wgtc = numpy.ones(len(lc))
        else:
            lc, fc, wgtc = numpy.loadtxt(fncont,usecols=(0,3,4), unpack=True)
            
        cont = (lc, fc)
        fwgt = ip.interp1d(lc, wgtc)

    fname = Gsetfname(forder)
    rv    = Gcalcrv(lamc)
    sigsm = Gcalcsigsm(lamc)

    if (Gvac2air):
        with open(fname,'r') as f:
            data = abutils.vac2air(abutils.rvcorrect([s.split()[0:4] for s in f if s[0] != '#'], rv))
    else:
        with open(fname,'r') as f:
            data = abutils.rvcorrect([s.split()[0:4] for s in f if s[0] != '#'], rv)
        
    lam = [dd[0] for dd in data]

    if (cont is not None):   # Use the continuum flags for weights, too.
                             # Multiply by already existing weights
        dtmp = []
        wgtlam = fwgt(lam)
        for _data, _wgtlam in zip(data, wgtlam):
            if len(_data) > 3:
                dtmp.append([_data[0], _data[1], _data[2], _data[3]*_wgtlam])
            else:
                dtmp.append([_data[0], _data[1], _data[2], _wgtlam])
        data = dtmp

    specrng = [max(rng[0], min(lam)+0.1), min(rng[1], max(lam)-0.1), lamstep]

    fitabun.SPECRNG = specrng
    fitabun.CFITFNC = fitfnc
    fitabun.NKNOTS = nknots
    fitabun.CFITORD = fitord


    vfit,sigbst,vp,vm, chsq = fitabun.fit1par(data, Gstelpar, [Gelem], fitrng,
           pfix=Gpfix, vfix=Gvfix, sigsm=sigsm, cont=cont, calcerr=calcerr)

    Gfout.write('%-4s %0.2f %0.2f %+0.3f %+0.3f %+0.3f %7.3f\n' % (oname, specrng[0], specrng[1], vfit, vp, vm, chsq))
    Gfout.flush()
    os.fsync(Gfout)
    os.system('cp -f fitabun.txt '+str(oname))


