/*
   File: tuples.h
   Handles the storage, reading, writing and updating
   of the unparsing rules
*/
#ifndef IncTuples
#define IncTuples
#include <export.h>

#define type_terminal 1
#define type_forcednonterminal 2
#define type_nonterminal 3
#define type_set 4

/*
   vert_offset registers the vertical offset to the end position
   of the previous tuple; hor_offset registers the horizontal
   offset to the end position of the previous tuple or the
   position of the tuple to which it is related.
*/
typedef struct tuple_rec
	{ int type;
	  char *text;
	  int relates;
	  int hor_offset;
	  int vert_offset;
	  int sonnr;
	  struct tuple_rec *next;
	} *tuple;
#define tuple_nil ((tuple)0)

typedef struct rule_rec
	{ tuple hrule;
	  tuple vrule;
	} *rule;
#define rule_nil ((rule)0)

export rule *ruletable;
export int max_nr_of_rules;
export int max_nr_of_tuples;
export void init_tuples (char *gram);	/* argument is grammars basename */

export char *tuple_error_buffer;
export char *tuple_edit_buffer;

#define max_rule_header "number of rules:"
#define max_tuple_header "number of tuples:"

export int changed_rules;
export void write_tuples ();

#define hor_rule 0
#define ver_rule 1
export void write_rule_to_buffer (rule lrule, int dir);
export int try_and_replace_rule (rule lrule, int dir);

#endif /* IncTuples */
