/*
   File: templates.c
   Administers templates and template substitution
*/

/* global includes */
#include <stdio.h>

/* libeag includes */
#include <export.h>
#include <memalloc.h>
#include <textstorage.h>
#include <ds.h>

/* local includes */
#include <tuples.h>
#include <editor.h>
#include <editorparsing.h>
#include <templates.h>

typedef struct template_rec
	{ char *text;
	  int nrsons;
	  int *sonnrs;
	  struct template_rec *next;
	} *Template;
#define template_nil ((Template)0)

private Template *template_table;
public char *template_buffer;

/*
   A placeholder can always be substituted by a text template.
   (Structure substitution fails when predicates occur in the pattern,
    or if the pattern is not a direct descendant)
*/
private void append_at_list_head (int nodenr, char *text,
				  int nrsons, int *sonnrs)
	{ Template new = (Template) ckmalloc (sizeof (struct template_rec));
	  new -> text = addto_names (text);
	  new -> nrsons = nrsons;
	  new -> sonnrs = sonnrs;
	  new -> next = template_table[nodenr];
	  template_table[nodenr] = new;
	};

public void enter_template_in_list_struct (int nodenr, char *text,
					   int nrsons, int *sonnrs)
	{ int *nsonnrs;
	  int i;
	  nsonnrs = (int *) ckcalloc (nrsons, sizeof (int));
	  for (i = 0; i < nrsons; i++) nsonnrs[i] = sonnrs[i];
	  append_at_list_head (nodenr, text, nrsons, nsonnrs);
	};

public void enter_template_in_list_text (int nodenr, char *text)
	{ append_at_list_head (nodenr, text, 0, ((int *)0));
	};

public void update_template_buffer (int nodenr)
	{ Template ptr;
	  char *bufptr = template_buffer;
	  for (ptr = template_table [nodenr]; ptr; ptr = ptr -> next)
	     { char *src;
	       for (src = ptr -> text; *src; src++, bufptr++) *bufptr = *src;
	       *bufptr = '\n';
	       bufptr++;
	     };
	  *bufptr = '\0';
	};

public void replace_focus_by_template (int nodenr, int nr)
	{ Template ptr;
	  int ct;
	  for (ptr = template_table[nodenr], ct = 0;
	       ptr && (ct != nr);
	       ptr = ptr -> next, ct++);
	  if (!ptr) return;
	  replace_focus_by_text (ptr -> text);
	};

public void init_templates ()
	{ int i;
	  template_table = (Template *) ckcalloc
			(max_nr_of_rules, sizeof (Template));
	  for (i=0; i < max_nr_of_rules; i++)
	     template_table[i] = template_nil;
	  template_buffer = (char *) ckmalloc (max_nr_of_rules * screenwidth);
	  template_buffer[0] = '\0';
	};
