/*
   File: initedit.c
   initializes the editor modules
*/

/* global includes */
#include <stdio.h>

/* libeag includes */
#include <init.h>
#include <textstorage.h>

/* libedt includes */
#include <cpmerge.h>
#include <tuples.h>
#include <unparser.h>
#include <editor.h>
#include <focus.h>
#include <editmain.h>
#include <templates.h>
#include <initedit.h>

public int init_editor (char *name, int *argc, char **argv)
	{ int status;
	  register_main_widgets (name, argc, argv);
	  status = init_transducer (*argc, argv, 1, &Filename);
	  init_cpmerge ();
	  init_tuples (name);
	  init_unparser ();
	  init_focus ();
	  init_templates ();
	  if (!status)
	     { char Buffer[80];
	       sprintf (Buffer, "in.%s", name);
	       Filename = addto_names (Buffer);
	     };
	  return (status);
	};

public void start_editor ()
	{ register_editor_widget ();
	  register_remaining_widgets ();
	  start_application_loop ();
	};
