/*
   File: freegraph.c
   Frees an affix graph.
*/

/* global includes */
#include <stdio.h>

/* libeag includes */
#include <ds.h>

/* local includes */
#include <freegraph.h>

private void free_link_to_pos (posnode p, int side, linknode *lnkptr)
	{ linknode *ptr = lnkptr;
	  while (*ptr)
	     if (((*ptr) -> pos == p) && ((*ptr) -> side == side))
		{ linknode old = *ptr;
	          *ptr = old -> next;
		  free_linknode (old);
		  return;
		}
	     else ptr = &((*ptr) -> next);
	  fprintf (stderr, "Mismatch between links and positions\n");
	};

private void free_affix_in_pos (posnode p, int side, affixnode a)
	{ free_link_to_pos (p, side, &a -> links);
	  if (a -> links) return;
	  detach_valuenode (a -> value);
	  free_affixnode (a);
	};

private void free_affixes_in_side (posnode p, int side)
	{ int type = p -> sides[side].type;
	  switch (type)
	     { case singleaffix:
		  free_affix_in_pos (p, side, p -> sides[side].a.affx);
		  break;
	       case concataffix:
	       case composaffix:
		  { int i;
		    int nr = p -> sides[side].a.co.nraffs;
		    for (i = 0; i < nr; i++)
		       free_affix_in_pos (p, side,
				p -> sides[side].a.co.affs[i]);
		    free_affixspace (nr, p -> sides[side].a.co.affs);
		  };
	     };
	};

private void free_position (posnode p)
	{ free_affixes_in_side (p, upper_side);
	  free_affixes_in_side (p, lower_side);
	  free_posnode (p);
	};

private void free_positions (treenode node)
	{ int i;
	  for (i = 0; i < node -> nraffs; i++)
	     free_position (node -> affs[i]);
	  free_posspace (node -> nraffs, node -> affs);
	};

private void free_sons (treenode node)
	{ int i;
	  for (i = 0; i < node -> nrsons; i++)
	     free_graph (node -> sons [i]);
	  free_sonspace (node -> nrsons, node -> sons);
	};

public void free_graph (treenode node)
	{ free_positions (node);
	  free_sons (node);
	  free_treenode (node);
	};
