/*
   File: focus.c
   Keeps track of the focus
*/

/* global includes */
#include <stdio.h>

/* libeag includes */
#include <export.h>
#include <ds.h>

/* local includes */
#include <unparser.h>
#include <cpmerge.h>
#include <memalloc.h>
#include <focus.h>

public focus root_focus;
public focus current_focus;
private focus free_focus_list;

private focus new_focus (int begin_x, int begin_y, int end_x, int end_y,
			 treenode node, focus parent)
	{ focus new;
	  if (free_focus_list == focus_nil)
	     new = (focus) ckmalloc (sizeof (struct focus_rec));
	  else
	     { new = free_focus_list;
	       free_focus_list = new -> parent;
	     };
	  new -> begin_x = begin_x;
	  new -> begin_y = begin_y;
	  new -> end_x = end_x;
	  new -> end_y = end_y;
	  new -> node = node;
	  new -> parent = parent;
	  return (new);
	};

private void free_complete_focus ()
	{ if (!root_focus) return;
	  root_focus -> parent = free_focus_list;
	  free_focus_list = current_focus;
	  current_focus = focus_nil;
	  root_focus = focus_nil;
	};

private void free_current_focus ()
	{ focus ptr;
	  if (!root_focus) return;
	  if (current_focus == root_focus) return;
	  for (ptr = current_focus;
	       ptr -> parent != root_focus;
	       ptr = ptr -> parent);
	  ptr -> parent = free_focus_list;
	  free_focus_list = current_focus;
	  current_focus = root_focus;
	};

private int fits_in_range (int x, int y, int bx, int by, int ex, int ey)
	{ if (y < by) return (0);
	  if ((y == by) && (x < bx)) return (0);
	  if (ey < y) return (0);
	  if ((ey == y) && (ex <= x)) return (0);
	  return (1);
	};

private int fits_in_focus (focus f, int x, int y)
	{ return (fits_in_range (x, y, f -> begin_x, f -> begin_y,
				f -> end_x, f -> end_y));
	};

public void set_focus_from_pos (int x, int y)
	{ if (!fits_in_focus (root_focus, x, y)) return;
	  free_current_focus ();
	  while (current_focus -> node -> type == normalnode)
	     { treenode node = current_focus -> node;
	       int i;
	       int found = 0;
	       for (i=0; i < node -> nrsons; i++)
		  { int bx = node -> sons[i] -> x;
		    int by = node -> sons[i] -> y;
		    int ex = bx + node -> sons[i] -> width;
		    int ey = by + node -> sons[i] -> height;
		    if (fits_in_range (x, y, bx, by, ex, ey))
		       { current_focus = new_focus (bx, by, ex, ey,
				node -> sons[i], current_focus);
			 found = 1;
		       };
	          };
	       if (!found) return;
	     };
	};

public void set_focus_to_father ()
	{ focus ptr;
	  if (current_focus == root_focus) return;
	  ptr = current_focus;
	  current_focus = current_focus -> parent;
	  ptr -> parent = free_focus_list;
	  free_focus_list = ptr;
	};

public void reset_root_focus ()
	{ free_complete_focus ();
	  root_focus = new_focus (0, 0, unparsed_width, unparsed_height,
			the_root, focus_nil);
	  current_focus = root_focus;
	};

public void init_focus ()
	{ root_focus = focus_nil;
	};
