/*
   File: editorparsing.c
   Defines all routines necessary for reparsing and handling error nodes
*/

/* global includes */
#include <stdio.h>

/* libeag includes */
#include <export.h>
#include <ds.h>
#include <textstorage.h>
#include <textparsing.h>

/* local includes */
#include <editor.h>
#include <editmain.h>
#include <cpmerge.h>
#include <unparser.h>
#include <freegraph.h>
#include <focus.h>
#include <editorparsing.h>

private treenode mk_errornode (treenode father)
	{ char *ptr;
	  treenode new = new_treenode ();
	  new -> type = errornode;
	  for (ptr = parsebuffer; *ptr != EOFCHAR; ptr++);
	  *ptr = '\0';
	  new -> name = addto_names (parsebuffer);
	  new -> nodenr = 1;
	  new -> nrsons = 0;
	  new -> sons = treearray_nil;
	  new -> father = father;
	  new -> nraffs = 0;
	  new -> affs = posarray_nil;
	  new -> x = -1;
	  new -> y = 0;
	  new -> copied = treenode_nil;
	  return (new);
	};

private void mk_error_tree ()
	{ treenode tree = new_treenode ();
	  tree -> type = normalnode;
	  tree -> name = "rootnode";
	  tree -> nodenr = 0;
	  tree -> nrsons = 1;
	  tree -> sons = new_sonspace (1);
	  tree -> sons[0] = mk_errornode (tree);
	  tree -> father = treenode_nil;
	  tree -> nraffs = 0;
	  tree -> affs = posarray_nil;
	  tree -> x = -1;
	  tree -> y = 0;
	  tree -> copied = treenode_nil;
	  the_root = tree;
	};

import void transduce ();
public void initial_transduce_and_unparse (int status)
	{ if (!status) copy_into_parsebuffer (untyped_symbol, 3, 0);
	  transduce ();
	  if (!nrofparses) mk_error_tree ();
	  unparse ();
	  changed = 1;
	  reset_root_focus ();
	};

private void reparse_parsebuffer ()
	{ free_graph (the_root);
	  reinit_ds ();
	  reinit_textparsing ();
	  init_cpmerge ();
	  transduce ();
	  if (!nrofparses) mk_error_tree ();
	  unparse ();
	  changed = 1;
	  reset_root_focus ();
	};

public void reparse ()
	{ copy_into_parsebuffer (unparse_buffer, strlen (unparse_buffer), 0);
	  reparse_parsebuffer ();
	};

private char *start_of_focus ()
	{ int line = 0;
	  int col = 0;
	  char *ptr = unparse_buffer;
	  while (1)
	     { if ((line == current_focus -> begin_y) &&
		   (col == current_focus -> begin_x)) return (ptr);
	       if (!*ptr) return (NULL);
	       if (*ptr == '\n')
		  { line++;
		    col = 0;
		  }
	       else col++;
	       ptr++;
	     };
	};

private void replace_text (char *begin, int width, char *s)
	{ char *dptr, *sptr;
	  char *end = begin + width;
	  int diff = strlen (s) - width;
	  if (diff > 0)
	     { /* copy backwards */
	       sptr = end + strlen (end) + 1;
	       dptr = sptr + diff;
	       while (sptr != end - 1) *dptr-- = *sptr--;
	     }
	  else if (diff < 0)
	     { sptr = end;
	       dptr = end + diff;
	       while (*sptr) *dptr++ = *sptr++;
	       *dptr = '\0';
	     };
	  for (dptr = begin, sptr = s; *sptr; sptr++, dptr++) *dptr = *sptr;
	};

public void replace_focus_by_text (char *s)
	{ char *begin = start_of_focus ();
	  replace_text (begin,
		current_focus -> end_x - current_focus -> begin_x, s);
	};

public void save_unparse_buffer (char *sname)
	{ FILE *out = fopen (sname, "w");
	  if (!out)
	     { fprintf (stderr, "could not write in file '%s'\n", sname);
	     }
	  else
	     { fputs (unparse_buffer, out);
	       fclose (out);
	       changed = 0;
	     };
	};

public void load_parsebuffer (char *sname)
	{ FILE *in = fopen (sname, "r");
	  if (!in)
	     { fprintf (stderr, "could not read from file '%s'\n", sname);
	     }
	  else
	     { Filename = addto_names (sname);
	       copy_file_into_parsebuffer (in);
	       reparse_parsebuffer ();
	     };
	};
