/*
   File: textstorage.c
   Stores text fragments in a binary tree
*/

/* global includes */
#include <stdio.h>
#include <string.h>

/* local includes */
#include <export.h>
#include <error.h>
#include <memalloc.h>
#include <textstorage.h>

typedef struct text_rec
	{ char *word;
	  struct text_rec *left;
	  struct text_rec *right;
	} *text_tree;
#define text_tree_nil ((text_tree)0)

private text_tree root;

public void init_textstorage ()
	{ root = text_tree_nil;
	};

public char *addto_names (char *t)
	{ register text_tree *ptr = &root; 
	  while (1)
	     { register int cond;
	       if (*ptr == text_tree_nil)
		  { *ptr = (text_tree) ckmalloc (sizeof (struct text_rec));
		    (*ptr) -> word = newstring (t);
		    (*ptr) -> left = text_tree_nil;
		    (*ptr) -> right = text_tree_nil;
		    return ((*ptr) -> word);
		  };
	       cond = strcmp (t, (*ptr) -> word);
	       if (cond < 0) ptr = &((*ptr) -> left);
	       else if (cond > 0) ptr = &((*ptr) -> right);
	       else return ((*ptr) -> word);
	     }
	};

public char *lookup (char *t)
	{ register text_tree ptr = root; 
	  while (1)
	     { register int cond;
	       if (ptr == text_tree_nil)
	          { panic ("text %s not found in text storage\n", t);
		    exit (4);
		  };
	       cond = strcmp (t, ptr -> word);
	       if (cond < 0) ptr = ptr -> left;
	       else if (cond > 0) ptr = ptr -> right;
	       else return (ptr -> word);
	     };
	};
