/*
   File: textparsing.h
   Defines the routines to parse terminals and terminal sets
   for recursive backup parsing.
*/
#ifndef IncTextparsing
#define IncTextparsing
#include <export.h>
#include <stdio.h>
#define EOFCHAR '\204'

export int parsebuffer_size;
export int strstore_size;
export int nrofparses;
export char *parsebuffer;
export char *strstore;
export char *iptr;
export char *miptr;
export int mtotal;

export char *eptr;
export char pemsg[];
export void lookahead_failure (char *name);

export void copy_into_parsebuffer (char *src, int len, int col);
export void copy_file_into_parsebuffer (FILE *fd);
export int in_set (char *ptr, char *set);
#define in_lookahead(s) in_set(iptr,s)
#define iptr_at(c) ((*iptr) == c)
export void make_empty_strstore ();
export void endofsentence ();
export int currentcolumn ();
export int currentrow ();
export void cut ();
export void parse_terminal ();
export void parse_set ();
export void parse_non_set ();
export void parse_set_star ();
export void parse_non_set_star ();
export void parse_set_plus ();
export void parse_non_set_plus ();
export void parse_set_star_strict ();
export void parse_non_set_star_strict ();
export void parse_set_plus_strict ();
export void parse_non_set_plus_strict ();
export void fail_if_iptr_at_set ();
export void fail_if_iptr_not_at_set ();
export void increment_nrparses ();
export void init_textparsing ();
export void reinit_textparsing ();
export void complain_on_found_parses ();
export void dump_matches ();

export void rec_parse_terminal ();
export void rec_parse_number ();
export void rec_parse_set ();
export void rec_parse_non_set ();
export void rec_parse_set_star ();
export void rec_parse_non_set_star ();
export void rec_parse_set_plus ();
export void rec_parse_non_set_plus ();
export void rec_parse_set_star_strict ();
export void rec_parse_non_set_star_strict ();
export void rec_parse_set_plus_strict ();
export void rec_parse_non_set_plus_strict ();

export void meta_endofsentence ();
export void meta_endofnumber ();
export void recbody_parse_terminal ();
export void recbody_parse_number ();
export void recbody_parse_set ();
export void recbody_parse_non_set ();
export void recbody_parse_set_star ();
export void recbody_parse_non_set_star ();
export void recbody_parse_set_plus ();
export void recbody_parse_non_set_plus ();
export void recbody_parse_set_star_strict ();
export void recbody_parse_non_set_star_strict ();
export void recbody_parse_set_plus_strict ();
export void recbody_parse_non_set_plus_strict ();

#endif /* IncTextParsing */
