/*
   File: stddefs.h
   Implements the standard eag library
*/
#ifndef IncStddefs
#define IncStddefs
#include <export.h>
#include <ds.h>

export affixnode make_nil_value ();
export affixnode make_string_value ();
export affixnode make_tuple_value ();
export affixnode make_int_value ();
export affixnode make_any_value ();
export void rec_nil_value ();
export void rec_string_value ();
export void rec_tuple_value ();
export void rec_int_value ();
export void rec_any_value ();
export void recbody_string_value ();
export void recbody_int_value ();

export void pred_equal ();
export void pred_notequal ();
export void pred_inttostring ();
export void pred_minus ();
export void pred_mul ();
export void pred_div ();
export void pred_power ();
export void pred_uppercase ();
export void pred_notinreservedwordlist ();
export void pred_stringtoint ();
export void pred_dumpaffix ();
export void semipred_endofsentence ();
export void semipred_column ();
export void semipred_row ();

export char *stddefs_name_from_nodenr ();
export void init_stddefs ();
#endif /* IncStddefs */
