/*
   File: memalloc.c
   Defines a checked malloc and calloc
*/

/* global includes */
#include <stdio.h>
#include <malloc.h>

/* local includes */
#include <export.h>
#include <error.h>
#include <memalloc.h>

public void *ckmalloc (int size)
	{ void *new = (void *) malloc ((unsigned) size);
	  if (new) return (new);
	  panic ("could not malloc %d bytes\n", size);
	  return ((void *) NULL);
	};

public void *ckcalloc (int nr, int size)
	{ void *new;
	  if (nr == 0) return ((void *) NULL);
	  new = (void *) calloc ((unsigned) nr, (unsigned) size);
	  if (new) return (new);
	  panic ("could not calloc %d chunks of %d bytes\n", nr, size);
	  return ((void *) NULL);
	};

public void *ckrealloc (void *ptr, int size)
	{ void *new = (void *) realloc ((char *) ptr, (unsigned) size);
	  if (new) return (new);
	  panic ("could not realloc %d bytes\n", size);
	  return ((void *) NULL);
	};

public void *ckrecalloc (void *ptr, int nr, int size)
	{ void *new = (void *) realloc ((char *) ptr, (unsigned) (nr * size));
	  if (new) return (new);
	  panic ("could not realloc %d chunks of %d bytes\n", nr, size);
	  return ((void *) NULL);
	};

public char *newstring (char *src)
	{ char *new = (char *) ckmalloc (strlen (src) + 1);
	  strcpy (new, src);
	  return (new);
	};

