/*
   File: init.c
   initializes the transducer or recognizer routines
*/

/* global includes */
#include <stdio.h>

/* local includes */
#include <export.h>
#include <error.h>
#include <textstorage.h>
#include <textparsing.h>
#include <init.h>
#include <ds.h>
#include <buildtree.h>
#include <buildaffixgraph.h>

private void syntax_error (char *error_string)
	{ error ("error on command line: %s\n", error_string);
	  error ("usage: transducer [options] [filename]\n");
	  error ("or:    editor [Xtoolkitoptions] [options] [filename]\n");
	  exit (4);
	};

private void scan_option (char *arg)
	{
	};

private FILE *scanargs (int argc, char **argv, char **fname)
	{ FILE *input;
	  int i;
	  char *name = NULL;
	  for (i=1; i < argc; i++)
	     { char *arg = argv[i];
	       if (arg[0] == '-') scan_option (arg+1);
	       else if (name == NULL) name = arg;
	       else syntax_error ("too many input files specified");
	     };
	  if (name == NULL) input = stdin;
	  else if (!(input = fopen (name, "r")))
	     { syntax_error ("could not open input file");
	     };
	  *fname = name;
	  return (input);
	};

public int init_transducer (int argc, char **argv, int edit, char **fname)
	{ FILE *input = scanargs (argc, argv, fname);
	  init_textstorage ();	/* should be selfexplaining */
	  init_ds ();		/* initializes tree stack and q stack */
	  init_textparsing ();	/* initializes parsebuffer and strstore */
	  if (edit && (input == stdin)) return (0);
	  copy_file_into_parsebuffer (input);
	  return (1);
	};
