/*
   File: error.c
   Defines routines for diagnostic messages
*/

/*
   Global includes
*/
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

/* libeag includes */
#include <export.h>
#include <error.h>
#define MAXERRSIZE 256

public int verbose;
public int full_verbose;

public void init_error ()
	{ verbose = 0;
	  full_verbose = 0;
	};

public void panic (char *format, ...)
	{ char buf[MAXERRSIZE];
	  va_list arg_ptr;
	  va_start (arg_ptr, format);
	  vsprintf (buf, format, arg_ptr);
	  va_end (arg_ptr);
	  fprintf (stderr, "%s\n", buf);
	  exit (4);
	};

public void error (char *format, ...)
	{ char buf[MAXERRSIZE];
	  va_list arg_ptr;
	  va_start (arg_ptr, format);
	  vsprintf (buf, format, arg_ptr);
	  va_end (arg_ptr);
	  fprintf (stderr, "%s\n", buf);
	};

public void wlog (char *format, ...)
	{ char buf[MAXERRSIZE];
	  va_list arg_ptr;
	  va_start (arg_ptr, format);
	  vsprintf (buf, format, arg_ptr);
	  va_end (arg_ptr);
	  fprintf (stderr, "%s\n", buf);
	};

public void warning (char *format, ...)
	{ char buf[MAXERRSIZE];
	  va_list arg_ptr;
	  va_start (arg_ptr, format);
	  vsprintf (buf, format, arg_ptr);
	  va_end (arg_ptr);
	  if (verbose) fprintf (stderr, "%s\n", buf);
	};

public void hint (char *format, ...)
	{ char buf[MAXERRSIZE];
	  va_list arg_ptr;
	  va_start (arg_ptr, format);
	  vsprintf (buf, format, arg_ptr);
	  va_end (arg_ptr);
	  if (full_verbose) fprintf (stderr, "%s\n", buf);
	};

public void eprint_log (char *format, ...)
	{ char buf[MAXERRSIZE];
	  va_list arg_ptr;
	  va_start (arg_ptr, format);
	  vsprintf (buf, format, arg_ptr);
	  va_end (arg_ptr);
	  fprintf (stderr, "%s", buf);
	};

public void bad_tag (int tag, char *routine)
	{ panic ("bad tag %d occurred in routine %s", tag, routine);
	};

public void internal_error (char *routine)
	{ panic ("internal consistency check failed in routine %s", routine);
	};
