/*
   File: ds.h
   Defines the necessary datastructures to store 
   syntax trees and propagate affix values
*/
#ifndef IncDs
#define IncDs
#include <stdio.h>
#include <export.h>

/*
   Tree nodes are built for every alternative in the syntax rules
   of the original grammar, as well as for special purposes in the
   editor or for semiterminals
*/
#define undefinednode 0
#define leafnode 1
#define normalnode 2
#define ambiguousnode 3
#define errornode 4

#define typedplaceholdernode 6
#define untypedplaceholdernode 7

#define predicatenode 9
#define semipredicatenode 10
typedef struct tree_rec
	{ int type;
	  char *name;			/* is dat nodig? */
	  int nodenr;			/* nr of the alternative */
	  int nrsons;			/* nr of sons */
	  struct tree_rec **sons;	/* sons */
	  struct tree_rec *father;	/* is deze nodig? */
	  int nraffs;			/* nr of affixes */
	  struct pos_rec **affs;	/* affix positions */
	  int width;			/* alleen voor editor */
	  int height;			/* idem */
	  int x;			/* idem */
	  int y;			/* idem */
	  struct tree_rec *copied;	/* idem */
	} *treenode;
#define treenode_nil ((treenode)NULL)
#define treearray_nil ((treenode *)NULL)

/*
   While parsing, partial syntax trees are stored on a stack
*/
export treenode *tptr;
export int treestack_size;

#define push_treenode(t) *tptr = t; tptr++
#define pop_treenode() *(--tptr)
#define top_treenode() *(tptr-1)

/*
   One side of an affix position corresponds with an affix expression
   in the original grammer. Only when the value at one side is fully
   known will it be propagated to the other side of the position
*/
#define undefinedaffix 0
#define singleaffix 1
#define concataffix 2
#define composaffix 3
typedef struct pos_side_rec
	{ int type;			/* what kind of affix expr are we */
	  int sill;			/* the sill */
	  union
	     { struct affix_rec *affx;	/* the single affix */
	       struct
		  { int nraffs;		/* nr of affixes in this position */
	  	    struct affix_rec **affs;	/* the affixes */
		  } co;			/* a composed or concatenated affix */
	     } a;
	} pos_side;

#define lower_side 0
#define upper_side 1
typedef struct pos_rec
	{ struct tree_rec *node;	/* whose position am i */
					/* doubles for free list adm */
	  pos_side sides[2];		/* defining and applying side */
	  int delayed;			/* is this position delayed */
	  struct pos_rec **args;	/* args of delayed predicate */
	  void (*dfunc)();		/* the actual delayed function */
	} *posnode;
#define posnode_nil ((posnode)NULL)
#define posarray_nil ((posnode *)NULL)

/*
   At present affix values can only be of three types. Either it is
   a string value, or it is a composed value or it is a number.
   Because affix values are propagated through the affix tree, one
   can never be sure when a value node may be freed. For this
   reason an incremental reference count mechanism is used for values.
*/
#define undefinedtype 0
#define stringtype 1
#define compostype 2
#define numbertype 3
typedef struct value_rec
	{ int type;
	  int ref_count;		/* reference count */
	  union
	     { char *string;		/* the string */
					/* doubles for management purposes */
	       int number;		/* the numeric value */
	       struct
		  { int nr;		/* number of composed affixes */
		    struct value_rec **vals;	/* the composed affixes */
		  } co;			/* the composed value */
	     } v;
	} *valuenode;
#define valuenode_nil ((valuenode)NULL)
#define valuearray_nil ((valuenode *)NULL)
#define attach_valuenode(val) val -> ref_count++

/*
   An affix node corresponds with an affix in the original grammar
   Via the links the affix value will be propagated to other nodes.
*/
typedef struct affix_rec
	{ char *name;			/* affix name */
	  int defined;			/* is defined */
	  int hasval;			/* has a value */
	  struct value_rec *value;	/* the value of the affix */
	  void (*mfunc)();		/* function to check meta definition */
	  struct link_rec *links;	/* linked list of all links */
	  struct affix_rec *copied;	/* used when copying syntax trees */
					/* doubles for freelist adm */
	} *affixnode;
#define affixnode_nil ((affixnode)NULL)
#define affixarray_nil ((affixnode *)NULL)

/*
   A link is undefined if the affix value is not yet known
*/
#define undefined_link 0
#define applied_link 1
#define defined_link 2
#define first_defined_link 3
#define in_link 4
#define out_link 5
typedef struct link_rec
	{ struct tree_rec *node;	/* to which node do i propagate */
	  struct pos_rec *pos;		/* to which affix position */
	  int side;			/* and which side */
	  int type;			/* how do/did i propagate */
	  struct link_rec *next;		/* next link */
	} *linknode;
#define linknode_nil ((linknode)NULL)

/*
   The continuation stack is used for lots of intermediate values
   and continuations
*/
typedef union
	{ void (*q)();			/* continuation */
	  char *s;			/* a string */
	  int i;			/* number */
	  int *ip;			/* pointer to number */
	  struct tree_rec *t;		/* treenode */
	  struct affix_rec *a;		/* affix */
	  struct value_rec *v;		/* value */
	  struct pos_rec *p;		/* affix position */
	  struct affix_rec **ap;	/* array of affixes */
	  struct value **vp;		/* array of values */
	  struct pos_rec **pp;		/* array of positions */
	} cont;

export cont *qptr;			/* this pointer stores the top */
					/* tbp. the first free location */
export int qstack_size;			/* change only at init */

/*
   Define access macros for the continuation stack
*/
#define pushq(arg) qptr -> q = arg; qptr++
#define pushs(arg) qptr -> s = arg; qptr++
#define pushi(arg) qptr -> i = arg; qptr++
#define pusht(arg) qptr -> t = arg; qptr++
#define pusha(arg) qptr -> a = arg; qptr++
#define pushv(arg) qptr -> v = arg; qptr++
#define pushp(arg) qptr -> p = arg; qptr++
#define puship(arg) qptr -> ip = arg; qptr++
#define pushap(arg) qptr -> ap = arg; qptr++
#define pushvp(arg) qptr -> vp = arg; qptr++
#define pushpp(arg) qptr -> pp = arg; qptr++
#define callq() (--qptr) -> q()
#define topq() ((qptr-1) -> q)
#define tops() ((qptr-1) -> s)
#define topi() ((qptr-1) -> i)
#define popq() ((--qptr) -> q)
#define pops() ((--qptr) -> s)
#define popi() ((--qptr) -> i)
#define popt() ((--qptr) -> t)
#define popa() ((--qptr) -> a)
#define popv() ((--qptr) -> v)
#define popp() ((--qptr) -> p)
#define popip() ((--qptr) -> ip)
#define popap() ((--qptr) -> ap)
#define popvp() ((--qptr) -> vp)
#define poppp() ((--qptr) -> pp)
#define pop(nr) qptr -= nr

/*
   Memory management routines
*/
export treenode new_treenode ();
export void free_treenode (treenode old);
export treenode *new_sonspace (int nrsons);
export void free_sonspace (int nrsons, treenode *old);
export posnode new_posnode ();
export void free_posnode (posnode old);
export posnode *new_posspace (int nrofps);
export void free_posspace (int nrofps, posnode *old);
export valuenode new_valuenode ();
export void free_valuenode (valuenode old);
export void detach_valuenode (valuenode old);
export valuenode *new_valuespace (int nrofvs);
export void free_valuespace (int nrofvs, valuenode *old);
export affixnode new_affixnode (char *name);
export void free_affixnode (affixnode old);
export affixnode *new_affixspace (int nraffs);
export void free_affixspace (int nraffs, affixnode *old);
export linknode new_linknode ();
export void free_linknode (linknode old);

/*
   Transput
*/
export void dump_affixvalue_on_file (valuenode v, FILE *out);
export void output_affix ();

/*
   Initialization
*/
export void init_ds ();			/* initialize this module */
export void reinit_ds ();		/* reinitializes this module */
#endif /* IncDs */
