/*
   File: buildaffixgraph.c
   Defines the actions necessary for building the affix graph
*/

/* global includes */
#include <stdio.h>

/* local includes */
#include <export.h>
#include <ds.h>
#include <textstorage.h>
#include <propagate.h>
#include <buildaffixgraph.h>

public valuenode string_to_value (char *s)
	{ valuenode new = new_valuenode ();
	  new -> type = stringtype;
	  new -> ref_count = 1;
	  new -> v.string = s;
	  return (new);
	};

public valuenode number_to_value (int i)
	{ valuenode new = new_valuenode ();
	  new -> type = numbertype;
	  new -> ref_count = 1;
	  new -> v.number = i;
	  return (new);
	};

public valuenode new_tuple_value (int nr)
	{ valuenode *vals = new_valuespace (nr);
	  valuenode new = new_valuenode ();
	  new -> type = compostype;
	  new -> v.co.nr = nr;
	  new -> v.co.vals = vals;
	  return (new);
	};

public affixnode string_to_affix (char *name, char *s)
	{ valuenode val = string_to_value (s);
	  affixnode new = new_affixnode (name);
	  new -> defined = 1;
	  new -> hasval = 1;
	  new -> value = val;
	  return (new);
	};

public affixnode number_to_affix (char *name, int i)
	{ valuenode val = number_to_value (i);
	  affixnode new = new_affixnode (name);
	  new -> defined = 1;
	  new -> hasval = 1;
	  new -> value = val;
	  return (new);
	};

public affixnode make_undefined_affix ()
	{ affixnode new = new_affixnode ("predef_undefined");
	  valuenode newval = new_valuenode ();
	  newval -> type = undefinedtype;
	  new -> defined = 1;
	  new -> hasval = 1;
	  new -> value = newval;
	  return (new);
	};

/*
   change the type of the links
*/
public linknode make_link_typed (affixnode affx, posnode pos, int type)
	{ linknode lk;
	  for (lk = affx -> links; lk != linknode_nil; lk = lk -> next)
	     if ((lk -> pos == pos) && (lk -> type != type))
	        { int side = lk -> side;
		  pos -> sides[side].sill -= 1;
		  lk -> type = type;
		  return (lk);
		};
	  return (linknode_nil);
	};

/*
   undo the change
*/
public void restore_link_to_undefined (posnode pos, linknode lk)
	{ if (lk != linknode_nil)
	     { int side = lk -> side;
	       lk -> type = undefined_link;
	       pos -> sides[side].sill += 1;
	     };
	};

public void add_link (affixnode aff, posnode pos, int side)
	{ linknode link = new_linknode ();
	  link -> node = pos -> node;
	  link -> pos = pos;
	  link -> side = side;
	  link -> next = aff -> links;
	  aff -> links = link;
	  if (aff -> hasval)
	     { link -> type = applied_link;
	       pos -> sides[side].sill -= 1;
	     }
	  else link -> type = undefined_link;
	};

public void add_dlink (affixnode aff, posnode pos, int side)
	{ linknode link = new_linknode ();
	  link -> node = pos -> node;
	  link -> pos = pos;
	  link -> side = side;
	  link -> next = aff -> links;
	  aff -> links = link;
	  if (aff -> hasval) link -> type = applied_link;
	  else link -> type = undefined_link;
	};

public void delete_link (affixnode aff, posnode pos)
	{ linknode current = aff -> links;
	  if (current -> pos == pos)
	     { aff -> links = current -> next;
	       free_linknode (current);
	     }
	  else
	     { linknode next = current -> next;
	       for (next = current -> next;
		    next != linknode_nil;
		    current = next, next = next -> next)
		  if (next -> pos == pos)
		     { current -> next = next -> next;
		       free_linknode (next);
		       return;
		     };
	     };
	};
