/*
   File: alib.c
   Generated on Thu Mar  4 16:12:21 1993
   Implements the predefines library 'alib'
*/
#include <stdio.h>
#include <export.h>
#include <memalloc.h>
#include <textstorage.h>
#include <ds.h>
#include <buildtree.h>
#include <buildaffixgraph.h>
#include <propagate.h>
#include <nodenrs.h>
#include <alib.h>

/* our module number */
private int alib_modnr = 2;

private char *field;
private int width;
private int height;

private void act_makeemptyfield (posnode ps1, posnode ps2)
	{ valuenode v1 = calc_affix_value (ps1, lower_side);
	  valuenode v2 = calc_affix_value (ps2, lower_side);
	  /* Insert code here */
	  if ((v1 -> type == numbertype) && (v2 -> type == numbertype))
	     { char *savefield = field;
	       int savewidth = width;
	       int saveheight = height;
	       int i;
	       width = v1 -> v.number;
	       height = v2 -> v.number;
	       field = (char *) ckcalloc (width*height, sizeof (char));
	       for (i=0; i < width * height; i++) field[i] = 0;
	       callq ();
	       ckfree (field);
	       height = saveheight;
	       width = savewidth;
	       field = savefield;
	     };
	  /* End of insertion */
	  detach_valuenode (v1);
	  detach_valuenode (v2);
	};

private void delayed_makeemptyfield (posnode *ps)
	{ posnode ps1 = ps[0];
	  posnode ps2 = ps[1];
	  if (!position_is_defined (ps1) || !position_is_defined (ps2))
	     callq();
	  else if (!position_has_value (ps1) || !position_has_value (ps2))
	     callq();
	  else
	   { ps1 -> delayed = 0;
	     ps2 -> delayed = 0;
	     act_makeemptyfield (ps1, ps2);
	     ps1 -> delayed = 1;
	     ps2 -> delayed = 1;
	   };
	};

public void pred_makeemptyfield ()
	{ affixnode af1 = new_affixnode ("makeemptyfield_af1");
	  affixnode af2 = new_affixnode ("makeemptyfield_af2");
	  pushq (delayed_makeemptyfield);
	  pushq (make_node_delayed);
	  pusha (af2);
	  pushi (singleaffix);
	  pusha (af1);
	  pushi (singleaffix);
	  pushi (2);
	  pushi (0);
	  pushi (mk_nodenr (alib_modnr, 0));
	  pushq (make_predicatenode);
	  callq ();
	  pop (10);
	  detach_valuenode (af1 -> value);
	  free_affixnode (af1);
	  detach_valuenode (af2 -> value);
	  free_affixnode (af2);
	  pushq (pred_makeemptyfield);
	};

private void act_isempty (posnode ps1, posnode ps2)
	{ valuenode v1 = calc_affix_value (ps1, lower_side);
	  valuenode v2 = calc_affix_value (ps2, lower_side);
	  /* Insert code here */
	  if ((v1 -> type == numbertype) && (v2 -> type == numbertype))
	     { int x = v1 -> v.number;
	       int y = v2 -> v.number;
	       if ((0 <= x) && (0 <= y) && (x < width) && (y < height))
		  if (!field [y * width + x]) callq ();
	     };
	  /* End of insertion */
	  detach_valuenode (v1);
	  detach_valuenode (v2);
	};

private void delayed_isempty (posnode *ps)
	{ posnode ps1 = ps[0];
	  posnode ps2 = ps[1];
	  if (!position_is_defined (ps1) || !position_is_defined (ps2))
	     callq();
	  else if (!position_has_value (ps1) || !position_has_value (ps2))
	     callq();
	  else
	   { ps1 -> delayed = 0;
	     ps2 -> delayed = 0;
	     act_isempty (ps1, ps2);
	     ps1 -> delayed = 1;
	     ps2 -> delayed = 1;
	   };
	};

public void pred_isempty ()
	{ affixnode af1 = new_affixnode ("isempty_af1");
	  affixnode af2 = new_affixnode ("isempty_af2");
	  pushq (delayed_isempty);
	  pushq (make_node_delayed);
	  pusha (af2);
	  pushi (singleaffix);
	  pusha (af1);
	  pushi (singleaffix);
	  pushi (2);
	  pushi (0);
	  pushi (mk_nodenr (alib_modnr, 1));
	  pushq (make_predicatenode);
	  callq ();
	  pop (10);
	  detach_valuenode (af1 -> value);
	  free_affixnode (af1);
	  detach_valuenode (af2 -> value);
	  free_affixnode (af2);
	  pushq (pred_isempty);
	};

private void act_take (posnode ps1, posnode ps2)
	{ valuenode v1 = calc_affix_value (ps1, lower_side);
	  valuenode v2 = calc_affix_value (ps2, lower_side);
	  /* Insert code here */
	  if ((v1 -> type == numbertype) && (v2 -> type == numbertype))
	     { int x = v1 -> v.number;
	       int y = v2 -> v.number;
	       if ((0 <= x) && (0 <= y) && (x < width) && (y < height))
		  { char savecell = field [y * width + x];
		    field [y * width + x] = 1;
		    callq ();
		    field [y * width + x] = savecell;
		  };
	     };
	  /* End of insertion */
	  detach_valuenode (v1);
	  detach_valuenode (v2);
	};

private void delayed_take (posnode *ps)
	{ posnode ps1 = ps[0];
	  posnode ps2 = ps[1];
	  if (!position_is_defined (ps1) || !position_is_defined (ps2))
	     callq();
	  else if (!position_has_value (ps1) || !position_has_value (ps2))
	     callq();
	  else
	   { ps1 -> delayed = 0;
	     ps2 -> delayed = 0;
	     act_take (ps1, ps2);
	     ps1 -> delayed = 1;
	     ps2 -> delayed = 1;
	   };
	};

public void pred_take ()
	{ affixnode af1 = new_affixnode ("take_af1");
	  affixnode af2 = new_affixnode ("take_af2");
	  pushq (delayed_take);
	  pushq (make_node_delayed);
	  pusha (af2);
	  pushi (singleaffix);
	  pusha (af1);
	  pushi (singleaffix);
	  pushi (2);
	  pushi (0);
	  pushi (mk_nodenr (alib_modnr, 2));
	  pushq (make_predicatenode);
	  callq ();
	  pop (10);
	  detach_valuenode (af1 -> value);
	  free_affixnode (af1);
	  detach_valuenode (af2 -> value);
	  free_affixnode (af2);
	  pushq (pred_take);
	};

public void semipred_showfield ()
	{ int i,j;
	  fprintf (stderr, "Field:\n");
	  for (i = 0; i < height; i++)
	     { for (j = 0; j < width; j++)
		  fputc ((field [i*width +j])?'X':' ', stderr);
	       fputc ('\n', stderr);
	     };
	  fputc ('\n', stderr);
	  pushi (0);
	  pushi (0);
	  pushi (mk_nodenr (alib_modnr, 3));
	  pushq (make_semipredicatenode);
	  callq ();
	  pop (4);
	  pushq (semipred_showfield);
	};

public char *alib_name_from_nodenr (int nodenr)
	{ int lnr = lnodenr_from_nodenr (nodenr);
	  switch (lnr)
	     { case 0: return ("pred_makeemptyfield");
	       case 1: return ("pred_isempty");
	       case 2: return ("pred_take");
	       case 3: return ("semipred_showfield");
	       default: fprintf (stderr, "strange nodenr %d in alib\n", lnr);
	     };
	  exit (4);
	};

public void init_alib (int modnr)
	{ alib_modnr = modnr;
	};
