/*
   File: tree.h
   Defines the internal representation of an EAG
*/
#ifndef IncTree
#define IncTree
#include <export.h>

#define non 8
#define star 4
#define plus 2
#define strict 1
typedef struct set_rec
	{ int kind;
	  char *string;
	} *set;
#define set_nil ((set) NULL)
#define string_nil ((char *) NULL)

typedef struct affix_variable_rec
	{ char *variable;
	  struct meta_rule_rec *def;
	} *affix_variable;
#define affix_variable_nil ((affix_variable) NULL)

#define tag_affix_nonterminal 0
#define tag_affix_terminal 1
#define tag_affix_number 2
#define tag_affix_set 3
/*
   string, number and set affixes give rise to affixes with
   anonymous names. In a scan before actual coding these
   names are generated.
*/
typedef struct affix_rec
	{ int tag;
	  char *name;
	  int type;
	  struct affix_rec *next;	/* for local var list */
	  union
	     { affix_variable var;
	       char *string;
	       int number;
	       set aset;
	     } u;
	} *affix;
#define affix_nil ((affix) NULL)

typedef struct affix_list_rec
	{ int nrofas;
	  int room;
	  affix *as;
	} *affix_list;
#define affix_list_nil ((affix_list) NULL)

#define tag_single 0
#define tag_compos 1
#define tag_concat 2
typedef struct expr_rec
	{ int tag;
	  union
	     { affix single;
	       affix_list compos;
	       affix_list concat;
	     } u;
	} *expr;
#define expr_nil ((expr) NULL)			/* empty meta alternative */

/* positions */
#define undefinedflow 0
#define noflow 1
#define inherited 2
#define derived 3
#define errorflow 4
typedef struct pos_rec
	{ int kind;
	  expr ex;
	  int type;
	} *pos;
#define pos_nil ((pos) NULL)

typedef struct pos_list_rec
	{ int nrofps;
	  int room;
	  pos *ps;
	} *pos_list;
#define pos_list_nil ((pos_list) NULL)		/* absent display */

typedef struct call_rec
	{ char *nonterminal;
	  pos_list display;
	  struct hyper_rule_rec *def;
	} *call;
#define call_nil ((call) NULL)

typedef struct semiterminal_rec
	{ set s;
	  pos_list display;
	} *semiterminal;

#define tag_call 0
#define tag_terminal 1
#define tag_semiterminal 2
#define tag_cut 3
typedef struct member_rec 
	{ int empty;		/* FIRST (member); */
	  int followlayout;	/* layout may be inserted after this member */
	  char *first;
	  int number;		/* all members are numbered */
	  int sonnr;
	  int tag;
	  union 
	     { call cl;
	       char *terminal;
	       semiterminal semi;
	     } u;
	} *member;
#define member_nil ((member) NULL)

typedef struct member_list_rec
	{ int nrofms;
	  int room;
	  member *ms;
	} *member_list;
#define member_list_nil ((member_list) NULL)	/* empty alternative */

typedef struct alt_rec
	{ pos_list display;			/* lhs display */
	  member_list members;
	  int number;				/* to number all the alts */
	  int nodenr;				/* to number all the alts */
	  int nrsons;				/* number of sons with tree */
	  affix locals;				/* local affixes */
	  int empty;				/* may generate empty */
	  char *first;				/* first set */
	  char *director;			/* director set */
	  int rule_nr;				/* number of hyper_rule */
	} *alt;
#define alt_nil ((alt) NULL)

typedef struct alt_list_rec
	{ int nrofas;
	  int room;
	  alt *as;
	} *alt_list;
#define alt_list_nil ((alt_list) NULL)		/* predefined hyper group */

typedef struct meta_alt_rec
	{ expr e;
	  int number;				/* used in coding */
	} *meta_alt;
#define meta_alt_nil ((meta_alt) NULL)

typedef struct meta_alt_list_rec
	{ int nrofas;
	  int room;
	  meta_alt *as;
	} *meta_alt_list;
#define meta_alt_list_nil ((meta_alt_list) NULL)

/* flags to indicate the kind of hyper_rule */
#define h_undefined 0
#define h_nonpredicate 1
#define h_predicate 2
#define h_semipredicate 4
#define h_maybepredicate 16
#define h_mayproduceempty 1
#define h_neverproducesempty 2
#define h_alwaysproducesempty 4
typedef struct hyper_rule_rec
	{ char *nonterminal;
	  alt_list alts;
	  int kind;
	  int empty;
	  int ext;
	  int number;
	  int placeholder;
	  int startswithlayout;
	  int endsinlayout;
	  char *first;
	  char *follow;
	  pos_list proto_display;
	  int reachable;
	  int has_sons;
	  int goal;
	} *hyper_rule;
#define hyper_rule_nil ((hyper_rule) NULL)

typedef struct value_rec
	{ int ref_count;
	  int type;
	  union
	     { char *string;
	       int number;
	       struct value_list_rec *tuple;
	     } v;
	} *value;
#define value_nil ((value) NULL)

typedef struct value_list_rec
	{ int nrofvs;
	  int room;
	  value *vals;
	} *value_list; 
#define value_list_nil ((value_list) NULL)

#define undefined_meta_value 0
#define single_meta_value 1
#define multiple_meta_value 2
#define recognizer_meta_value 3
#define error_meta_value 4
typedef struct meta_rule_rec
	{ char *meta_nonterminal;
	  meta_alt_list meta_alts;
	  int type;
	  int ext;
	  int kind;
	  int empty;
	  int number;
	  value mvalue;
	  int reachable;
	} *meta_rule;
#define meta_rule_nil ((meta_rule) NULL)

typedef struct hyper_tree_rec
	{ hyper_rule node;			/* sorted by name */
	  struct hyper_tree_rec *left;
	  struct hyper_tree_rec *right;
	} *hyper_tree;
#define hyper_tree_nil ((hyper_tree) NULL)

typedef struct meta_tree_rec
	{ meta_rule node;			/* sorted by name */
	  struct meta_tree_rec *left;
	  struct meta_tree_rec *right;
	} *meta_tree;
#define meta_tree_nil ((meta_tree) NULL)

export hyper_tree hyper_root;
export meta_tree meta_root;
export hyper_rule layout_rule;
export call start_rule;
export alt start_alt;

export int enter_meta_rule (meta_rule meta);
export meta_rule lookup_meta_rule (char *nont);
export int enter_hyper_rule (hyper_rule hyper);
export hyper_rule lookup_hyper_rule (char *nont);
export void init_tree ();

#endif /* IncTree */
