/*
   File: tree.c
   Defines the internal representation of an EAG
*/
#include <stdio.h>
#include <memalloc.h>
#include <tree.h>

public hyper_tree hyper_root;
public meta_tree meta_root;
public hyper_rule layout_rule;
public call start_rule;
public alt start_alt;

public int enter_meta_rule (meta_rule meta)
	{ register meta_tree *ptr = &meta_root; 
	  while (1)
	     { register int cond;
	       if (*ptr == meta_tree_nil)
		  { *ptr = (meta_tree) ckmalloc (sizeof (struct meta_tree_rec));
		    (*ptr) -> node = meta;
		    (*ptr) -> left = meta_tree_nil;
		    (*ptr) -> right = meta_tree_nil;
		    return (1);
		  };
	       cond = strcmp (meta -> meta_nonterminal,
				(*ptr) -> node -> meta_nonterminal);
	       if (cond < 0) ptr = &((*ptr) -> left);
	       else if (cond > 0) ptr = &((*ptr) -> right);
	       else return (0);		/* Multiple occurence */
	     }
	};

public meta_rule lookup_meta_rule (char *nont)
	{ register meta_tree ptr = meta_root;
	  while (1)
	     { register int cond;
	       if (ptr == meta_tree_nil) return (meta_rule_nil);
	       cond = strcmp (nont, ptr -> node -> meta_nonterminal);
	       if (cond < 0) ptr = ptr -> left;
	       else if (cond > 0) ptr = ptr -> right;
	       else return (ptr -> node);
	     };
	};

public int enter_hyper_rule (hyper_rule hyper)
	{ register hyper_tree *ptr = &hyper_root; 
	  while (1)
	     { register int cond;
	       if (*ptr == hyper_tree_nil)
		  { *ptr = (hyper_tree) ckmalloc
				(sizeof (struct hyper_tree_rec));
		    (*ptr) -> node = hyper;
		    (*ptr) -> left = hyper_tree_nil;
		    (*ptr) -> right = hyper_tree_nil;
		    return (1);
		  };
	       cond = strcmp (hyper -> nonterminal,
				(*ptr) -> node -> nonterminal);
	       if (cond < 0) ptr = &((*ptr) -> left);
	       else if (cond > 0) ptr = &((*ptr) -> right);
	       else return (0);
	     }
	};

public hyper_rule lookup_hyper_rule (char *nont)
	{ register hyper_tree ptr = hyper_root;
	  while (1)
	     { register int cond;
	       if (ptr == hyper_tree_nil) return (hyper_rule_nil);
	       cond = strcmp (nont, ptr -> node -> nonterminal);
	       if (cond < 0) ptr = ptr -> left;
	       else if (cond > 0) ptr = ptr -> right;
	       else return (ptr -> node);
	     };
	};

public void init_tree ()
	{ hyper_root = hyper_tree_nil;
	  meta_root = meta_tree_nil;
	};
