/*
   File: skelmain.c
   Defines main program of skeleton generator.
*/

/* global includes */
#include <stdio.h>

/* libeag includes */
#include <export.h>
#include <error.h>
#include <memalloc.h>
#include <textstorage.h>

/* local includes */
#include <sizes.h>
#include <tree.h>
#include <numbering.h>
#include <parser.h>
#include <codeskel.h>
#include <main.h>

private FILE *open_input_file (char *name)
	{ char fname[MAXFNAME];
	  FILE *fd;

	  sprintf (fname, "%s.eag", name);
	  if ((fd = fopen (fname, "r"))) return (fd);
	  sprintf (fname, "%s", name);
	  if ((fd = fopen (fname, "r"))) return (fd);
	  panic ("could not open inputfile %s", name);
	  return ((FILE *) NULL);
	};

private void print_usage ()
	{ wlog ("usage: eag-skel [flags] filename");
	  wlog ("-h:  provide this help");
	  wlog ("-v:  verbose");
	  wlog ("-fv: full verbose");
	  exit (4);
	};

private void syntax_error (char *syn_error)
	{ error ("error on command line: %s", syn_error);
	  print_usage ();
	};

private void scan_option (char *ptr)
	{ if (strcmp (ptr, "h") == 0) print_usage ();
	  else if (strcmp (ptr, "v") == 0) verbose = 1;
	  else if (strcmp (ptr, "fv") == 0) { full_verbose = 1; verbose = 1; }
	  else syntax_error ("illegal option specified");
	};

public void main (int argc, char **argv)
	{ FILE *in;
	  int i;
	  char *fname = NULL;

	  for (i=1; i < argc; i++)
	     { char *arg = argv[i];
	       if (arg[0] == '-') scan_option (arg+1);
	       else if (fname == NULL) fname = arg;
	       else syntax_error ("too many filenames specified");
	     };
	  if (fname == NULL) { fname = "_stdin"; in = stdin; }
	  else in = open_input_file (fname);
	  init_error ();
	  init_textstorage ();
	  init_tree ();
	  parse_eag (in, 1);
	  do_numbering ();
	  generate_skeleton (fname);
	};
