/*
   File: reduce.c
   Reduces the grammer
*/

/* Global includes */
#include <stdio.h>

/* libeag includes */
#include <export.h>
#include <error.h>

/* local includes */
#include <sizes.h>
#include <tree.h>
#include <numbering.h>
#include <main.h>
#include <reduce.h>

private void mark_in_meta_rule (meta_rule mrule);
private void mark_in_affix_variable (affix_variable v)
	{ if (v -> def != meta_rule_nil)
	     mark_in_meta_rule (v -> def);
	};

private void mark_in_affix (affix a)
	{ if (a -> tag == tag_affix_nonterminal)
	     mark_in_affix_variable (a -> u.var);
	};

private void mark_in_affix_list (affix_list al)
	{ int i;
	  for (i=0; i < al -> nrofas; i++)
	     mark_in_affix (al -> as[i]);
	};

private void mark_in_expression (expr e)
	{ if (e == expr_nil) return;		/* empty meta alt */
	  switch (e -> tag)
	     { case tag_single: mark_in_affix (e -> u.single); break;
	       case tag_concat: mark_in_affix_list (e -> u.concat); break;
	       case tag_compos: mark_in_affix_list (e -> u.compos);
	       default: break;
	     };
	};

private void mark_in_meta_alts (meta_alt_list al)
	{ int i;
	  if (al == meta_alt_list_nil) return;	/* predefined metarule */
	  for (i=0; i < al -> nrofas; i++)
	     mark_in_expression (al -> as[i] -> e);
	};

private void mark_in_meta_rule (meta_rule mrule)
	{ if (mrule -> reachable) return;
	  mrule -> reachable = 1;
	  if (mrule -> ext) return;
	  mark_in_meta_alts (mrule -> meta_alts);
	};

private void mark_in_position (pos p)
	{ mark_in_expression (p -> ex);
	};

private void mark_in_display (pos_list pl)
	{ int i;
	  if (pl == pos_list_nil) return;
	  for (i=0; i < pl -> nrofps; i++)
	     mark_in_position (pl -> ps[i]);
	};

private void mark_in_rule (hyper_rule rule);
private void mark_in_call (hyper_rule rule, call cl)
	{ mark_in_rule (cl -> def);
	  mark_in_display (cl -> display);
	  rule -> has_sons = 1;
	};

private void mark_in_semiterminal (hyper_rule rule, semiterminal sm)
	{ mark_in_display (sm -> display);
	  rule -> has_sons = 1;
	};

private void mark_in_member (hyper_rule rule, member m)
	{ switch (m -> tag)
	     { case tag_call: mark_in_call (rule, m -> u.cl);
	       case tag_terminal: break;
	       case tag_semiterminal: mark_in_semiterminal (rule, m -> u.semi);
	       default: break;
	     };
	};

private void mark_in_members (hyper_rule rule, member_list mems)
	{ int i;
	  if (mems == member_list_nil) return;
	  for (i=0; i < mems -> nrofms; i++)
	     mark_in_member (rule, mems -> ms[i]);
	};

private void mark_in_alt (hyper_rule rule, alt a)
	{ mark_in_display (a -> display);
	  mark_in_members (rule, a -> members);
	};

private void mark_in_alts (hyper_rule rule, alt_list alts)
	{ int i;
	  for (i=0; i < alts -> nrofas; i++)
	     mark_in_alt (rule, alts -> as[i]);
	};

private void mark_in_rule (hyper_rule rule)
	{ if (rule -> reachable) return;
	  rule -> reachable = 1;
	  if (rule -> ext) return;
	  mark_in_alts (rule, rule -> alts);
	};

private void report_on_hyper_rule (hyper_rule rule)
	{ wlog ("rule %s is %sreachable and has %ssons.",
		rule -> nonterminal, (rule -> reachable)?"":"not ",
		(rule -> has_sons)?"":"no ");
	};

private void report_on_meta_rule (meta_rule mrule)
	{ wlog ("meta rule %s is %sreachable.",
		mrule -> meta_nonterminal, (mrule -> reachable)?"":"not ");
	};

private void try_report_on_grammar_reduction ()
	{ int i;
	  if (!full_verbose) return;
	  for (i = 0; i < nr_of_hyper_rules; i++)
	     report_on_hyper_rule (all_hyper_rules[i]);
	  for (i = 0; i < nr_of_meta_rules; i++)
	     report_on_meta_rule (all_meta_rules[i]);
	};

public void reduce_grammar ()
	{ warning ("reducing grammar...");
	  mark_in_rule (start_rule -> def);
	  mark_in_display (start_rule -> display);
	  try_report_on_grammar_reduction ();
	};
