/*
   File: numbering.h
   numbers all rules and meta rules so that we may use these numbers
   in matrices to derive the closure of the left corner relation,
   de left recursion detection etc.
*/
#ifndef IncNumbering
#define IncNumbering
#include <export.h>
#include <tree.h>

export int nr_of_hyper_rules;
export int nr_of_hyper_alts;
export int nr_of_members;
export int max_members_per_alt;

export hyper_rule *all_hyper_rules;
export alt *all_hyper_alts;
export member *all_members;

export int nr_of_meta_rules;
export int nr_of_meta_alts;
export meta_rule *all_meta_rules;
export meta_alt *all_meta_alts;

export void do_numbering ();
#endif /* IncNumbering */
