/*
   File: lex.h
   Does lexical analysis of EAGs
*/
#ifndef IncLex
#define IncLex
#include <export.h>

/* Define the tokens */
typedef int symbol;
#define UNDEFINED 0
#define IDENTIFIER 1
#define NUMBER 2
#define STRING 3
#define SET 4
#define COLON 5
#define DOUBLECOLON 6
#define POINT 7
#define SEMICOLON 8
#define COMMA 9
#define LEFTPARENTHESIS 11
#define RIGHTPARENTHESIS 12
#define DOLLAR 13
#define FLOW 14
#define UP 15
#define STAR 16
#define PLUS 17
#define EXCLAMATIONMARK 18
#define CUT 19
#define EOFSYMBOL 20

export int line, column;
export int nval;
export char *sval;
export symbol thistoken;
export symbol nexttoken;
export int lex_errors;
export void init_lex ();
export void insymbol ();

#endif /* IncLex */
