/*
   File: gentree.h
   Defines the actions necessary for building the syntax tree
   of an eag during parse
*/
#ifndef IncBuildtree
#define IncBuildtree
#include <export.h>
#include <tree.h>

export set new_set (int kind, char *string);
#define rdup_set(s) new_set (s -> kind, s -> string)

export affix_variable new_affix_variable (char *name);
#define rdup_affix_variable(v) new_affix_variable (v -> variable)

export affix new_affix_nonterminal (affix_variable var);
export affix new_affix_terminal (char *s);
export affix new_affix_number (int val);
export affix new_affix_set (set s);
export affix rdup_affix (affix a);

export affix_list new_affix_list ();
export void app_affix_list (affix_list al, affix a);
export affix_list rdup_affix_list (affix_list old);

export expr new_expr_single (affix a);
export expr new_expr_compos (affix_list al);
export expr new_expr_concat (affix_list al);
export expr rdup_expr (expr e);

export pos new_pos (int kind, expr ex);
export pos rdup_pos (pos p);
export pos new_empty_pos ();

export pos_list new_pos_list ();
export void app_pos_list (pos_list pl, pos p);
export pos_list rdup_pos_list (pos_list old);
export pos_list new_empty_pos_list (int nrofps);

export call new_call (char *nont, pos_list display);
export semiterminal new_semiterminal (set s, pos_list display);

export member new_member_call (call c);
export member new_member_terminal (char *s);
export member new_member_semiterminal (semiterminal semi);
export member new_member_cut ();

export member_list new_member_list ();
export void app_member_list (member_list ml, member m);

export alt new_alt (pos_list pl, member_list ml);
export alt_list new_alt_list ();
export void app_alt_list (alt_list al, alt a);

export hyper_rule new_hyper_rule (char *nont, alt_list alts);
export hyper_rule new_external_hyper_rule (char *nont, alt_list alts, int kind);

export meta_alt new_meta_alt (expr e);
export meta_alt_list new_meta_alt_list ();
export void app_meta_alt_list (meta_alt_list mal, meta_alt ma);

export meta_rule new_meta_rule (char *nont, meta_alt_list alts);
export meta_rule new_external_meta_rule (char *nont, int type,
					 int kind, int empty);

#endif /* IncBuildtree */
