/*
   File: gentemplates.c
   Generates the template list
*/

/* Global includes */
#include <stdio.h>

/* libeag includes */
#include <export.h>
#include <error.h>

/* libedt includes */
#include <editor.h>

/* local includes */
#include <tree.h>
#include <sizes.h>
#include <main.h>
#include <prepare.h>
#include <numbering.h>
#include <common.h>
#include <layout.h>
#include <gentemplates.h>

/*
   editor template list generation
*/
private int alt_contains_semiterminals (alt a)
	{ int i;
	  member_list mems = a -> members;
	  if (mems != member_list_nil) 
	     for (i = 0; i < mems -> nrofms; i++)
		if (mems -> ms[i] -> tag == tag_semiterminal) return (1);
	  return (0);
	};

private int find_first_call (member_list mems, hyper_rule *def,
			     int from, int *found)
	{ int i;
	  for (i = from; i < mems -> nrofms; i++)
	     { member m = mems -> ms[i];
	       if (!is_an_invisible_member (m))
		  { if (m -> tag != tag_call) return (0);
		    *found = i;
		    *def = m -> u.cl -> def;
		    return (1);
	          };
	     };
	  return (0);
	};

private int alt_is_single_call (alt a, hyper_rule *def)
	{ int i;
	  member_list mems = a -> members;
	  if (mems == member_list_nil) return (0);
	  if (!find_first_call (mems, def, 0, &i)) return (0);
	  for (i++; i < mems -> nrofms; i++)
	     if (!is_an_invisible_member (mems -> ms[i])) return (0);
	  return (1);
	};

private void generate_template_member (member m)
	{ if (is_an_invisible_member (m)) return;
	  switch (m -> tag)
	     { case tag_call:
		  fprintf (out, "%s%s%s", typed_open_symbol,
			m -> u.cl -> nonterminal, typed_close_symbol);
		  break;
	       case tag_terminal:
		  output_unquoted_string (out, m -> u.terminal);
	       default: break;
	     };
	};

private void generate_template_members (member_list mems)
	{ int i;
	  if (mems == member_list_nil) return;
	  for (i=0; i < mems -> nrofms; i++)
	     { member m = mems -> ms[i];
	       generate_template_member (m);
	       if (m -> followlayout) fputc (' ', out);
	     };
	};

private void generate_text_template (int nodenr, alt a)
	{ fprintf (out, "\t  enter_template_in_list_text (%d, \"", nodenr);
	  generate_template_members (a -> members);
	  fprintf (out, "\");\n");
	};

private void enter_templates_of_rule_with_nodenr (int nodenr, hyper_rule rule,
						  int indirect);
private void check_to_generate_indirect_templates (int nodenr, hyper_rule def)
	{ if (indirect_templates)
	     enter_templates_of_rule_with_nodenr (nodenr, def, 1);
	  fprintf (out, "\t  enter_template_in_list_text (%d, \"<|%s|>\");\n",
				nodenr, def -> nonterminal);
	};

private void enter_templates_of_alt (int nodenr, alt a)
	{ hyper_rule def;
	  if (alt_contains_semiterminals (a)) return;
	  if (alt_is_single_call (a, &def))
	     check_to_generate_indirect_templates (nodenr, def);
	  else generate_text_template (nodenr, a);
	};

private void enter_templates_of_rule_with_nodenr (int nodenr, hyper_rule rule,
						  int indirect)
	{ int i;
	  for (i=0; i < rule -> alts -> nrofas; i++)
	     enter_templates_of_alt (nodenr, rule -> alts -> as[i]);
	};

private void enter_templates_of_rule (hyper_rule rule)
	{ int nodenr;
	  if (!rule -> placeholder) return;
	  nodenr = rule -> alts -> as[0] -> nodenr - 1;
	  enter_templates_of_rule_with_nodenr (nodenr, rule, 0);
	};

private void enter_templates_of_rules ()
	{ int i;
	  for (i = 0; i < nr_of_hyper_rules; i++)
	     enter_templates_of_rule (all_hyper_rules[i]);
	};

public void generate_enter_templates ()
	{ warning ("coding templates table...");
	  fprintf (out, "static void enter_templates ()\n");
	  fprintf (out, "\t{\n");
	  enter_templates_of_rules ();
	  fprintf (out, "\t};\n\n");
	};
