/*
   File: common.h
   Defines all routines that are common to all parser generators.
*/
#ifndef IncCommon
#define IncCommon

#include <stdio.h>
#include <export.h>
#include <tree.h>

export FILE *out;
export void open_output_file (char *basename, char *infix, char *suffix);
export void close_output_file ();

export void generate_std_includes (char **predefs, int nrpreds);
export char *rule_qualifier (hyper_rule rule);
export void code_nodenrs (char *fname);
export void output_char (FILE *file, char c);
export void output_unquoted_string (FILE *file, char *string);
export void output_string (FILE *file, char *string);

export void may_generate_lookahead_check (hyper_rule rule, char *s);
export void generate_terminal (char *s, int *nr_pushes);
export void generate_semiterminal (semiterminal sm, int *sonnr,
				   int *nrpushes, int code_build);

export void generate_cut (int *nrpushes);
export void generate_affix_output (pos_list dpy, int *nrpushes);
export void generate_affix_decls (alt a);
export void generate_affix_undecls (alt a);
export void generate_display (pos_list pl, int *nr_pushes);

export void generate_alt_header (hyper_rule rule, int i, alt a,
				 int code_build, int cut);
export void generate_alt_trailer (hyper_rule rule, int i, alt a,
				  int nrpushes, int code_build, int cut);
export void generate_placeholder_alt_header (hyper_rule rule,
					     int untyped, char look);
export void generate_placeholder_alt_trailer (hyper_rule rule,
					      int untyped, int nrpushes);
export void generate_buildplaceholdernode (hyper_rule rule,
					   int untyped, int *nrpushes);

export void generate_start_rule ();
export void generate_module_interface (char *fname,
				       char **predefs, int nrpreds);
export void generate_main (char *fname, char **predefs, int nrpreds);
#endif /* IncCommon */
