C dirdif3.FOR       contents: progr. DDMAIN, FOUR, PHASEX, NUTS (+subpr)
C
C=======================================================================
C=======================================================================
CPROGRAM DDMAIN dd3.C$200.                                 updt Jan 2008
C$200.
C=======================================================================
C=======================================================================
      SUBROUTINE DDMAIN
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zddif.inc'
      EQUIVALENCE (ICRYS,  IFILE(3)),  (IE100,  IFILE(10))
      EQUIVALENCE (IBINDU, IFILE(14)), (IBINDI, IFILE(15))
      EQUIVALENCE (IDOKA, KEYS(10))
      EQUIVALENCE (KEYD, KSTAT(19))
      DATA NCALL /0/
      IF (NCALL .EQ. 0) THEN
         NCALL = 1
         BPINP = 2.0
         ENDIF
      CALL KEPROG ('DDMAIN')
      IF (IORIE .EQ. -999) THEN
         IORIE = 0
         CALL ATPATS (0)
         ENDIF
      CALL DDMINI
      IF (IDOKA .EQ. 17) RETURN
      IF (KEYD .EQ. 9) STOP 201
      CALL DICALC
      IF (IDOKA .EQ. 17) RETURN
      IF (KEYD .EQ. 2 .OR. KEYD .EQ. 3) THEN
         CALL FILINQ (IBINDU, 'BINDUA', 'UNFORMATTED', 'INPUT', KINQU)
         IF (KINQU .NE. -1) CALL FILCLO (IBINDU, 'DELETE')
         CALL FILINQ (IBINDI, 'BINDIF', 'UNFORMATTED', 'INPUT', KINQI)
         IF (KINQI .NE. -1) CALL FILCLO (IBINDI, 'DELETE')
         CALL FILINQ (IE100,  'E100',   'FORMATTED',   'INPUT', KINIE)
         IF (KINIE .NE. -1) CALL FILCLO (IE100,  'DELETE')
         ENDIF
      CALL KEPROX
      RETURN
      END
      SUBROUTINE AT123P (INOUT, FINAM, LISX, ATN, ATX, N)
      CHARACTER INOUT*6, FINAM*6, ATN(N)*6
      DIMENSION ATX(10,N)
      INCLUDE 'Zaaaa.inc'
      EQUIVALENCE (IRUN, KSTAT(13))
      CHARACTER INO*6, FROMTO*11
      LIS = LISX
      IF (LIS .EQ. 24) GOTO 100
      IF (LIS .LT. 6 .OR. LIS .GT. 9) STOP 201
      IF (LIS .EQ. 6) LIS=9
      IF (LIS .EQ. 7) LIS=24
      IF (LIS .EQ. 8) CALL WR24
  100 CONTINUE
      INO = INOUT
      IF (INOUT(1:1) .EQ. ' ') INO = INOUT(2:6)
      FROMTO = '  to  file '
      IF (INOUT .EQ. ' INPUT') FROMTO = ' from file '
      WRITE (LIS, 121) INO, FROMTO, FINAM, N
  121 FORMAT (/ 1X, A6,' atoms ', A11, A6, 24X,' ( list max =',I2,' )')
      DO 111 I=1,N
      WRITE (LIS, 103) IRUN, NRECYR, ATN(I), (ATX(K,I), K=1,5)
  103 FORMAT (8X, 'RUN', I4,' cycle',I3,'  atom ',A6, 3F7.4, 2F7.3)
  111 CONTINUE
      WRITE (LIS, FMT='(1X)')
      IF (LIS .NE. 8) CALL WR24
      RETURN
      END
      SUBROUTINE NNRECY (KEY)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zsear.inc'
      LOGICAL NOFREE, SWRECY, NORECY
      EQUIVALENCE (SWITCH(7), SWRECY), (SWITCH(8), NORECY)
      EQUIVALENCE (SWITCH(9), NOFREE)
      DIMENSION R2MUL(50,MRECY), MUL2NA(MRECY),
     *   PSMUL2(MRECY), R2EMU2(MRECY), R1MUL2(MRECY)
      DATA NCALL, LAST, NRSTAR / 0, 0, 4 /
      NCALL = NCALL + 1
      IF (NCALL .EQ. 1) THEN
         NCALL1 = 0
         NCALL2 = 0
         WRITE (8,FMT='('' $TE!NNRECY :MPAT IPAT MORIE IORIE !!!!'',
     *      4I3)') MPAT, IPAT, MORIE, IORIE
         IF (MPAT .GT. 0) WRITE (8,*) '$TE!NNRECY : PATTY called'
         IF (MORIE .GT. 0) WRITE (8,*) '$TE!NNRECY : ORIENT called'
         NRECYX = 0
         IF (MPAT .GT. 0) NRECYX = 1
         IF (MORIE .GT. 0) NRECYX = 2
         WRITE (8,FMT='('' $TE!NNRECY A: NRECYX ='', I1)') NRECYX
         ENDIF
      NOFREE = .TRUE.
      NS = NRECYS
      NT = NRECYT
      CALL WR24
      IF (KEY .NE. -1) GOTO 40
      IF (NCALL1 .EQ. 1) GOTO 19
      NCALL1 = 1
      WRITE (8,FMT='('' $TE!NNRECY :NAT '',   I6)')    NAT
      WRITE (8,FMT='('' $TE!NNRECY :PSQ '',   F6.3)')  PSQ
      WRITE (8,FMT='('' $TE!NNRECY :NATSYM'', I4)')    NATSYM
      WRITE (8,FMT='('' $TE!NNRECY :NRECYX'', I6)')    NRECYX
      IZMAX = 1
      DO 16 I = 1, NAT
   16 IZMAX = MAX0 (IZMAX, IZAT(I))
      NRECYX = 2
      IF (NAT .LT. 10 .AND. IZMAX.GT.10 ) NRECYX = 1
      IF (NAT .GT. 0.7*NATSYM .OR. PSQ.GT.0.9 ) NRECYX = 3
      WRITE (8,FMT='('' $TE!NNRECY B: NRECYX ='', I1)') NRECYX
   19 CONTINUE
      IF (NCALL2 .EQ. 1) RETURN
      IF (MPAT .EQ. -99 ) THEN
         NCALL2 = 1
         NRECYX = 3
         IF (NAT .LT. 0.5*NATSYM) NRECYX = 2
         WRITE (8,FMT='('' $TE!NNRECY C: NRECYX ='', I1)') NRECYX
         ENDIF
      IF (NRECYS .EQ. 1) THEN
         IF (NRECYX .EQ. 2) NRECYS = 3
         IF (NRECYX .EQ. 3) NRECYS = 5
         ENDIF
      RETURN
   40 CONTINUE
      IF (KEY .EQ. 1) GOTO 100
      IF (KEY .EQ. 5) GOTO 500
      IF (KEY .EQ.90) GOTO 900
      IF (KEY .EQ.99) GOTO 990
      IF (NRECYR .NE. 0) GOTO 50
      NRECY = 1
      NRECYR = 1
      NRECYS = 1
      NRECYT = 1
         WRITE (8, FMT='(/'' $TE NNRECY    start'', 30X,
     *       ''    R2X'')')
         WRITE (8, 98) KEY, NRECYR, NS, NT, NRECYS, NRECYT
         WRITE (8, FMT='(/'' $TE-NNRECY(0) cy-R -S -T  '',
     *       '' NATS NATL -REC  NAT   PSQ   R2X'')')
      IF (IPAT .GT. 0) THEN
         LAST = IPAT
      ELSE
         LAST = LAST + 1
         ENDIF
      CALL KERNZI (0,  MUL2NA, 21)
      CALL KERNZA (0., PSMUL2, 21)
      CALL KERNZA (0., R2EMU2, 21)
      CALL KERNZA (0., R1MUL2, 21)
      RETURN
   50 CONTINUE
      NRECYR = NRECYR + 1
      NRECYT = NRECYT + 1
      IF (NS .EQ. 1) THEN
         NRECYS = 2
         NRECYT = 1
      ELSEIF (NS .EQ. 2) THEN
         F = FLOAT(NATREC) / FLOAT(NAT)
         IF (NRECYT .EQ. 1 ) GOTO 99
         IF (NRECYT .EQ. 2 .AND. NATL .LE. 9) GOTO 99
         IF (NRECYT .LE. 3 .AND. F .LE. .70) GOTO 99
         IF (NRECYT .LE. 3 .AND. NATS .LE. 5) GOTO 99
         NRECYS = 4
         NRECYT = 1
      ELSEIF (NRECYT .GE. 3) THEN
         NRECYS = NRECYS + 1
         NRECYT = 1
         ENDIF
   98 FORMAT (// ' $TE NNRECY(',I2,')  cy-R', I3, '  -S -T =',
     *           I3,I2,' ===>', I3,I2, 3X, F7.3/)
   99 WRITE (8, 98) KEY, NRECYR, NS, NT, NRECYS, NRECYT,  R2X
      RETURN
  100 CONTINUE
      IF (LAST .LE. 0 .OR. NRECYR .LE. 0) RETURN
      R2MUL(LAST, NRECYR) = R2X
      MUL2NA(NRECYR) = NAT
      PSMUL2(NRECYR) = PSQ
      R2EMU2(NRECYR) = R2EX
      R1MUL2(NRECYR) = R1X
      R2LAST = R2X
      NRLAST = NRECYR
      IF (IPAT .EQ. 1) THEN
         IF (NRECYR .EQ. 3 .AND. PSQ .GT. 0.90) NRSTAR = 3
         IF (NRECYR .EQ. 4 .AND.
     *       NRSTAR .LE. 2 .AND. PSQ .GT. 0.80) NRSTAR = 4
         IF (NRECYR .EQ. 5 .AND. NRSTAR .LE. 2) NRSTAR = 5
         R2BEST = R2X
         IF (NRECYR .GT. NRSTAR+2) THEN
            R2BEST = (3.* R2MUL(IBEST, NRECYR-2) +
     *                4.* R2MUL(IBEST, NRECYR-1) +
     *                5.* R2MUL(IBEST, NRECYR)   ) /12.
            ENDIF
         NRBEST = NRECYR
         IBEST = 1
      ELSEIF (IPAT .GT. 1  .AND. NRECYR .GE. NRSTAR) THEN
         IF (NRECYR .GT. NRBEST .AND. NRECYR .LT. MRECY) THEN
            R2MUL(IBEST, NRECYR) = R2MUL(IBEST, NRBEST)
            ENDIF
         IF (NRECYR .EQ. NRSTAR) THEN
            IF (R2X-0.05 .GT. 1.3 * R2MUL(IBEST, NRECYR)) THEN
               R2BES1 = R2MUL(IBEST, NRECYR)
               R2LAST = R2MUL(LAST,  NRECYR)
               GOTO 150
               ENDIF
         ELSEIF (NRECYR .EQ. NRSTAR+1) THEN
            R2BES1 = (3.* R2MUL(IBEST, NRSTAR) +
     *                4.* R2MUL(IBEST, NRECYR) ) / 7.
            R2LAST = (3.* R2MUL(LAST,  NRSTAR) +
     *                4.* R2MUL(LAST,  NRECYR) ) / 7.
            IF (R2LAST-0.02 .GT. 1.2 * R2BES1) GOTO 150
         ELSEIF (NRECYR .EQ. NRSTAR+2) THEN
            R2BES1 = (3.* R2MUL(IBEST, NRSTAR)  +
     *                4.* R2MUL(IBEST, NRSTAR +1) +
     *                5.* R2MUL(IBEST, NRECYR)  ) / 12.
            R2LAST = (3.* R2MUL(LAST,  NRSTAR)  +
     *                4.* R2MUL(LAST,  NRSTAR +1) +
     *                5.* R2MUL(LAST,  NRECYR)  ) / 12.
            IF (R2LAST .GT. 1.1 * R2BES1) GOTO 150
         ELSEIF (NRECYR .GT. NRSTAR+2) THEN
            R2BES1 = (3.* R2MUL(IBEST, NRECYR-2) +
     *                4.* R2MUL(IBEST, NRECYR-1) +
     *                5.* R2MUL(IBEST, NRECYR)   ) / 12.
            R2LAST = (3.* R2MUL(LAST,  NRECYR-2) +
     *                4.* R2MUL(LAST,  NRECYR-1) +
     *                5.* R2MUL(LAST,  NRECYR)   ) / 12.
            IF (R2LAST .GT. 1.0 * R2BES1) GOTO 150
         ENDIF
      ENDIF
      IF (NRECYS.LE.3 .OR. (NRECYS.EQ.4 .AND. NRECYT.LE.2)) GOTO 147
      IF (NRECYS .LE. 5) THEN
         IF ((NRECYT .LE. 2 .AND. NATL .LE. 10) .OR.
     *       (NRECYT .LE. 4 .AND. R2X .GT. .40)) GOTO 147
         ENDIF
      NRECYT = 0
      IF (NS .LE. 5) THEN
         NRECYS = NRECYS + 1
      ELSEIF (NS .LE. 7) THEN
         NRECYS = 8
         NOFREE = .TRUE.
      ELSEIF (NS .LE. 9) THEN
         NRECYS = 10
      ELSEIF (NS .LE. 11) THEN
         NRECYS = 12
      ELSEIF (NRECYS .LE. 20) THEN
         NRECYS = NS + 2
      ELSE
         NRECYS = 99
         ENDIF
      WRITE (8, 98) KEY, NRECYR, NS, NT, NRECYS, NRECYT,  R2X
  147 CONTINUE
      WRITE (8,FMT='('' $TE-NNRECY('',I2,'') '', 3I3, 2X, 4I5, 2F6.3)')
     *   KEY, NRECYR, NRECYS, NRECYT, NATS, NATL, NATREC, NAT, PSQ, R2X
      RETURN
  150 CONTINUE
      WRITE (9, FMT='('' Stop : R2av='', F5.3,
     *  ''   (best set so far is AtSET='',I2,'', R2av='', F5.3,
     *  '' )'')')
     *      R2LAST, IBEST, R2BES1
      R2LAST = 99.9
      GOTO 900
  500 CONTINUE
      NATNOH = KSTAT(4)
      IF (NRECYS .LT. 4 .AND.
     *      (R2X .LT. 0.25 .OR. NATREC .GE. NATNOH - NATNOH/10)) THEN
         NRECYS = 4
         NRECYT = 0
         GOTO 99
         ENDIF
      RETURN
  900 CONTINUE
      SWRECY = .FALSE.
      NORECY = .TRUE.
      GOTO 1000
  990 CONTINUE
      IF (NRECYR .GE. 17 .OR. NRECYS .GE. 13) THEN
         NRECYS = 99
         NRECYT = 1
         SWRECY = .FALSE.
         NORECY = .TRUE.
         GOTO 1000
         ENDIF
      RETURN
 1000 CONTINUE
      IF (IPAT .EQ. 1) WRITE (9, FMT='(/'' First set: AtSET= 1'',
     *         ''  R2av='', F5.3, ''  (Nr cy:'', I2, '')''/)')
     *   R2BEST, NRBEST
      IF (IPAT .GT. 1) THEN
         IF (R2LAST .LT. R2BEST) THEN
            WRITE (9, FMT='(/'' BEST now: AtSET='', I2, '' R2av='',F5.3,
     *          ''   (was: AtSET='', I2, '' R2av='',F5.3, '')''/ )')
     *         IPAT, R2LAST, IBEST, R2BEST
            R2BEST = R2LAST
            IBEST = IPAT
            NRBEST = NRLAST
            ENDIF
          ENDIF
      CALL WR24
      I1 = NRECYR - 9
      IF (I1 .LT. 1) I1 = 1
      L=8
      DO 1100 LL=1,2
      WRITE (L, FMT='(1X/'' NNRECY summary   IRUN='', I3,
     *                   '' IPAT='',I3/)') KSTAT(13), IPAT
      WRITE (L, FMT='( '' Ncy '', 10I6   )') (I, I = I1, NRECYR)
      WRITE (L, FMT='( '' NAT '', 10I6   )') (MUL2NA(I), I = I1, NRECYR)
      WRITE (L, FMT='( '' PSQ '', 10F6.3 )') (PSMUL2(I), I = I1, NRECYR)
      WRITE (L, FMT='( '' R1X '', 10F6.3 )') (R1MUL2(I), I = I1, NRECYR)
      WRITE (L, FMT='( '' R2E '', 10F6.3 )') (R2EMU2(I), I = I1, NRECYR)
      WRITE (L, FMT='( '' R2X '', 10F6.3/)') (R2MUL(LAST,I),
     *                                                   I = I1, NRECYR)
      L=25
 1100 CONTINUE
      RETURN
      END
      SUBROUTINE DDMINI
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zbuff.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zddif.inc'
      INCLUDE 'Zsear.inc'
      EQUIVALENCE (IDDL, IFILE(1))
      EQUIVALENCE (IDDS, IFILE(1)), (ICRYS,IFILE(3))
      EQUIVALENCE (ICON, IFILE(4))
      EQUIVALENCE (IBINFC, IFILE(12))
      EQUIVALENCE (IBINDU, IFILE(14)), (IBINDI, IFILE(15))
      EQUIVALENCE (IBINFF, IFILE(16))
      EQUIVALENCE (IDOKA, KEYS(10))
      EQUIVALENCE (KEYWIL, KSTAT(17))
      LOGICAL      SWPRI, EXPAND, SWRECY, NORECY
      EQUIVALENCE (SWPRI, SWITCH(10)), (EXPAND, SWITCH(23))
      EQUIVALENCE (SWRECY, SWITCH(7)), (NORECY, SWITCH(8))
      EQUIVALENCE (IMAP, KSTAT(7))
      EQUIVALENCE (IRUN, KSTAT(13))
      EQUIVALENCE (KEYD, KSTAT(19))
      EQUIVALENCE (KEYDS, KSTAT(20))
      EQUIVALENCE (KEXPA, KSTAT(21))
      DIMENSION BUFFOX(10), BUFFOY(10)
      DIMENSION SCRAT(10)
      CHARACTER*6 LITA(1)
      PARAMETER (LCMAX = 10)
      CHARACTER*6 LCONDA(LCMAX)
      DATA LCONDA / 'DDMAIN', 'OPTION', 'DIRP1',  'PRINT',  'EXPAND',
     *              '$PTB$' , '$PTB$'   , '$PTB$', '$PTB$', '$PTB$' /
      DATA IATOMS, IAT10 /2, 10/
      DATA NCALL, NCALLM /0, 0/
      CALL WR24
      NITFC = 2
      NITDUA = 7
      NITDIF = 4
      NITFFT = 5
      NITDOP = 9
      NITB = 5
      IF (NCALL .EQ. 0) THEN
         NCALL = 1
         NATL = 0
         WRITE (8, FMT='('' $TE SCALE sub  Ncy   PSQ    R2   SCALE'',
     *     ''  Bp    Br   KEYWIL'')' )
         ENDIF
      IF (NCALLM .EQ. 0) R2X = 999.
      KEYWIL = 0
      CALL WILSIN (999)
      CALL RDCRYS (ICRYS)
      NITFC2 = 3 + 2 * NSYMM
      IF (MPAT .LT. 0) GOTO 120
      IF (NCALLM .EQ. 0) THEN
         DO 110 I=1,NTYPE
  110    SCRAT(I) = CELALL(I) / ZET
         I = NTYPE
         J = NINT(ZET)
         WRITE (24, 114) J, (CELATY(K), SCRAT(K), K=1,I)
  114 FORMAT (' Z:', I3/' FORMUL:', 6(2X,A2,F6.1)/ ( 8X,6(2X,A2,F6.1)))
         ENDIF
      IF (NCALLM .NE. 0) BOV = BOVMER
      KEYD = -1
      KEYBB = 0
  120 CALL RDCOND (ICON, LCONDA, LCMAX, KEND)
      GOTO (120, 2, 3, 120, 3, 6, 7, 8, 9, 10), KEND
      IF (KEND.EQ.0) GOTO 140
  122 CALL KERROR ('No option given or wrong data', 120, 'DDMINI')
  2   IF (NFNUM.LE.0) CALL KERROR
     *   ('No OPTION number given in CONDA file', 2, 'DDMINI')
      KEYD = NINT(FNUM(1))
      KEYDS = NINT(FNUM(2))
      CHOUT = ' '
      IF (KEYD.EQ.5) CALL KERROR ('KEYD=5 ???', 122, 'DDMINI')
      IF (KEYD.EQ.7)
     *   WRITE (9, FMT='('' Get R2 values for multi PATTY results'')')
      IF (KEYD.EQ.2) THEN
         WRITE (24, 1122)
 1122 FORMAT(1X/' ****** Prepare for FOUR using',
     *   ' dir.method phases *****'/1X)
         ENDIF
      IF (KEYD.EQ.0) WRITE (24, FMT='(1X/'' ============ Program'',
     *       '' DDMAIN: structure factor calculation''/1X)')
      IF (KEYD.GT.7 .OR. KEYD.LT.0 .OR. KEYD.EQ.6)
     *   CALL KERROR ('Wrong option given', 2, 'DDMINI')
      IF (KEYD .EQ. 7) WRITE (24,
     *   FMT='('' DDMAIN input option KEYD ='', I2)') KEYD
      GOTO 120
  3   EXPAND = .TRUE.
      NORECY = .TRUE.
      WRITE (8, 123)
  123 FORMAT (' EXPAND data to P1 symmetry (or centered equivalent)')
      GOTO 120
  6   CONTINUE
  7   CONTINUE
  8   CONTINUE
  9   CONTINUE
  10  GOTO 120
  140 CONTINUE
      IF (KEYD .LT. 0) GOTO 122
      CALL FILCLO (ICON, 'KEEP')
      IF (((KEYD.EQ.1 .OR. KEYD.EQ.3 ) .AND. .NOT. NORECY ) .OR.
     *     (KEYD.EQ.0 .AND. NRECYR.GT.2)) THEN
         CALL NNRECY (0)
         KSTAT(6) = 0
         IF (NRECYS .GE. 2) KEYWIL = -2
         IF (KEYD.EQ.1) WRITE (24, FMT=
     *      '(44X, '' prepare for PHASEX cycle'', I3)') NRECYR
         IF (KEYD.EQ.3) WRITE (24, FMT=
     *      '(43X, '' prepare for Fourier cycle'', I3)') NRECYR
         IF (KEYD.EQ.0 .AND. NRECYR .GT. 2) WRITE (9, FMT=
     *      '('' cycle'', I3, ''   = final SF '')') NRECYR
         ENDIF
      IF (NRECYR .EQ. 1 .AND. ( KEYD.EQ.1 .OR. KEYD.EQ.3 )) THEN
         IF ( KEYD.EQ.1 )  WRITE (9, 1111)
 1111    FORMAT (1X/' PHASEX+FOUR recycling procedure:')
         IF( KEYD.EQ.3 )  WRITE (9, 1112)
 1112    FORMAT (1X/' FOUR recycling procedure:')
         IF (MPAT .LT. 0) THEN
            SCALE = SCAMER
            BOV = BOVMER
            BP = BOV
            BR = BOV
            ENDIF
         ENDIF
         NORECY = .FALSE.
         SWRECY = .TRUE.
      CALL WR24
      IF (KSTAT(6) .EQ. 17) THEN
         WRITE (8, 142)
  142    FORMAT (' stop multi PATTY    [ switch KSTAT(6)=17 ]')
         WRITE (8, 259) IPAT, NRECYR, NRECYS, R2X
         SWRECY = .FALSE.
         NORECY = .TRUE.
         ENDIF
      IF ((KEYD.EQ.1 .OR. KEYD.EQ.3) .AND. SWRECY) THEN
         WRITE(24, 1114) NRECYR
 1114    FORMAT ( ' cycle', I3 / ' -----'/ )
         ENDIF
      CALL WR24
      IF (NRECYR .GT. 1) GOTO 6142
      IF (NCALLM .GT. 0) GOTO 6142
      CALL MERBIN
      IF (KEYWIL .NE. 4 .AND. NINT(10000.*BP) .NE. 20000) KEYWIL = 1
      IF (KEYWIL .NE. 4 .AND. NINT(10000.*BR) .NE. 20000)
     *                                           KEYWIL = KEYWIL + 2
      WRITE (8, FMT='('' SCALE, BOV, BP, BR, KEYWIL ='', 4F8.4, I2)')
     *                   SCALE, BOV, BP, BR, KEYWIL
      CALL WILSIN (999)
      NCALLM = NCALLM + 1
      IF (EXPAND) KEYWIL = 4
 6142 CONTINUE
      WRITE (8, 1142) KEYD, IRUN, NRECYR, SCALE, BP, BR
 1142 FORMAT (// ' KEYD',I2,' RUN',I4, ' cy', I3,
     *   ' [  SCALE, Bp, Br, :', F8.4, 2F7.3,' ] '//)
      IF (KEYD .NE. 4) GOTO 143
      NAT  = 1
      KEYT = 1
      CALL KERNZA (0., ATXYZ, 10)
      IZAT(1) = 1
      ATNAME(1) = 'H'
      CALL FCALCI (ATXYZ, IZAT, ITAT, NAT)
      IMAP = 2
      IF (KEYDS .EQ. 1) IMAP = 6
      GOTO 935
  143 CONTINUE
      IF (NRECYR .EQ. 1 .AND. ( KEYD.EQ.1 .OR. KEYD.EQ.3 ))
     *   WRITE (9, FMT='(12X,
     *      ''nr of     deleted   expected R2-----       actual R2'')')
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.EQ.-1) CALL KERROR (' No ATOMS file found',
     *   143, 'DDMINI')
      CALL KERINA (IATOMS, LIT, 1, LEND)
      IF (LIT(1) .NE. 'ATOMS') CALL KERROR
     *   (' Incorrect header on ATOMS file', 143, 'DDMINI')
      REWIND IATOMS
      NSET = 0
      CHIN(1:10) = ' $TE!NREC-'
      WRITE (8,*) CHIN
      LITA(1) = 'SC='
      CALL KERINB (LITA, 1)
      ATSCAL = -1.
      IF (LIT(NLIT) .EQ. LITA(1)) ATSCAL=FNUM(NFNUM)
      CALL ATIN7 (NSET)
      IF (KEYD .NE. 7) THEN
         NN = MIN0 (5, NAT)
         CALL AT123P (' INPUT', ' ATOMS', 24, ATNAME, ATXYZ, NN)
         ENDIF
         CALL WR24
      NATINP = NAT
      IF (NATS .EQ. 0) NATS = NAT
      IF (KEYT .EQ. 3 .AND. EXPAND) THEN
         WRITE (9,*) ' EXPAND with anisotropic temp.f. is nonsense'
         KEYT = 2
         ENDIF
      IF ((KEYT .EQ. 2 .AND. EXPAND) .OR.
     *    (KEYT .GE. 2 .AND. KEYBB .EQ. 1)) THEN
         WRITE (24, FMT='('' Ignore individual temp. factors'')')
         KEYT = 1
         DO 145 I = 1, NAT
         ATXYZ(5,I) = 0.0
  145    ATXYZ(6,I) = 0.0
         ENDIF
      IF (KEYT .GE. 2) KEYWIL = -2
      CALL WR24
      IF (KEYD.EQ.2) THEN
         CALL FILINQ (IBINDU, 'BINDUA', 'UNFORMATTED', 'INPUT', KINQU)
         CALL FILINQ (IBINDI, 'BINDIF', 'UNFORMATTED', 'INPUT', KINQI)
         IF (KINQU.EQ.-1 .OR. KINQI.EQ.-1) CALL KERROR
     *      (' No BINDUA or BINDIF file found', 0, 'DDMAIN')
         CALL BINIFF (1, IBINDU,'BINDUA',FITDUA,NITDUA,BUFDUA,KENDUA)
         CALL BINIFF (1, IBINDI,'BINDIF',FITDIF,NITDIF,BUFDIF,KENDIF)
         GOTO 255
         ENDIF
      CALL WR24
      IF (NORECY) CALL ATOMPR (7, 7, ATXYZ, ATNAME, IZAT, NAT)
      CALL ATOMPR (8, 7, ATXYZ, ATNAME, IZAT, NAT)
      IF (KEYT.EQ.2) WRITE (8, 156)
  156 FORMAT (' Individual isotropic temp.factors on input atoms file')
      IF (KEYT.EQ.3) WRITE (8, 157)
  157 FORMAT (' Mixed isotropic / anisotropic temp.factors used')
      IF (KEYT .EQ. 1) WRITE (8, 173) BOV
  173 FORMAT (' temp KEYT=1, Overall temp.f.: Bov =', F8.3/)
      IF (KEYT.EQ.3 .AND. KEYD.GE.5) CALL KERROR
     *   ('Anisotr.t.f. not allowed for AUTOR2 TEST', 180, 'DDMINI')
      IF (KSTAT(1) .NE. 12357) GOTO 7167
      CALL KERNZA (0.0, CELPAR, NTYPE)
      DO 7161 I=1,NAT
      DO 7160 J=1,NTYPE
      IF (IZAT(I).NE.IZTYPE(J)) GOTO 7160
      CELPAR(J) = CELPAR(J) + ATXYZ(4,I) * AMULT
 7160 CONTINUE
 7161 CONTINUE
      IIII = 0
      DO 7162 J=1,NTYPE
      BUFFOY(J) = CELALL(J)
      IF ( CELPAR(J) .LE. CELALL(J)) GOTO 7162
      IF (( NRECYS .GE. 11 .AND. IZTYPE(J) .GE. 20 ) .OR.
     *    ( NRECYS .GE. 12 .AND. IZTYPE(J) .GE. 10 ) .OR.
     *    ( NRECYS .GE. 13 .AND. IZTYPE(J) .GE.  4)) THEN
         CELALL(J) = CELPAR(J)
         IIII = 1
         ENDIF
 7162 CONTINUE
      IF (IIII .EQ. 0) GOTO 7167
      DO 7165 I=1,NTYPE
      BUFFOY(I) = BUFFOY(I) / ZET
 7165 BUFFOX(I) = CELALL(I) / ZET
      J = NINT(ZET)
      WRITE(24, 7766) J, (CELATY(K), BUFFOY(K), K=1,NTYPE)
 7766 FORMAT (/' NOTE: Cell Contents was: '/
     *  ' Z:', I3 / ' FORMUL:', 6(2X,A2,F6.1) /
     *                           ( 8X, 6(2X,A2,F6.1))/)
      WRITE(24, 7166) J, (CELATY(K), BUFFOX(K), K=1,NTYPE)
 7166 FORMAT (/' NOTE: Cell Contents reset [ output FOUR !! ] :'/
     *  ' Z:', I3 / ' FORMUL:', 6(2X,A2,F6.1) /
     *                           ( 8X, 6(2X,A2,F6.1))/)
 7167 CONTINUE
      CALL FCALCI (ATXYZ, IZAT, ITAT, NAT)
      CALL NNRECY(-1)
      IF (EXPAND) GOTO 183
      WRITE (24, FMT='('' Scattering fraction, p**2 = '',F7.3)') PSQ
      IF (PSQ .GT. 1.2) THEN
         WRITE (24, FMT='('' Note: this may cause errors;'' /
     *                    '' Cell contents incorrect?'')')
         IF (NRECYR .LE. 1) THEN
         WRITE (9,FMT='('' Scattering fraction, p**2 = '',F7.3)') PSQ
            WRITE (9, 8183)
 8183 FORMAT (1X/' Too many atoms, or too many HEAVY atoms. '/
     * '                    --------------       Check your data:'/
     * ' if the cell contents are incorrect:'/
     * '      modify CRYSIN (call CRYSDA), or change the input ATOMS.'/
     * ' If a complete molecule lies on a symmetry element:' /
     * '      remove the symmetry-redundent part of it,      else:'/
     * ' if FOUR recycling led to too many HEAVY atoms:' /
     * '      rename some of the HEAVY atoms to lower its Z value!'/
     * ' Note:  p**2 up to 1.2 is acceptable but causes scaling'/
     * '      errors.   You should make  p**2 = 1,  approximately.'/)
            ENDIF
         NATINP = NAT
         NAT10 = MAX0(2, NATINP/10)
         NAT = MAX0(1, NATINP - NAT10)
         CALL FCALII
         IF (PSQ .GT. 1.2) THEN
            NAT10 = MAX0(NAT10+1, NATINP/5)
            NAT = MAX0(1, NATINP - NAT10)
            CALL FCALII
            ENDIF
         NAT10 = NATINP - NAT
         WRITE (24, 181) NAT10, PSQ
  181    FORMAT (' The last', I3, ' atoms from the input atoms set '/
     *      ' will be rejected; p**2 then is', F7.3/)
         IF (NRECYR .LE. 1) WRITE (9, 181) NAT10, PSQ
         ENDIF
      IF (PSQ .GT. 1.0) THEN
        WRITE(24,FMT='('' P**2 is artificially reset to p**2 = 1.0'')')
        PSQ = 1.0
         ENDIF
  183 CONTINUE
      IF (KEYT .NE. 3 .AND. .NOT.EXPAND) CALL FCALII
      IF (NRECYR .GE. 2) KEYWIL = -2
      IF (KEYD .GE. 5) KEYWIL = 0
      IF (KEYWIL .EQ. 4) GOTO 190
      IF (NAT .GT. 15 .OR. PSQ .GT. .90) KEYWIL = -2
      IZMAX = 1
      DO 186 I = 1, NAT
  186 IZMAX = MAX0 (IZMAX, IZAT(I))
      IF (IZMAX .LT. 50 .AND. PSQ .GT. .80) KEYWIL = -2
      IF (IZMAX .LT. 35 .AND. PSQ .GT. .70) KEYWIL = -2
      IF (IZMAX .LT. 20 .AND. PSQ .GT. .60) KEYWIL = -2
      IF (NRECYS .EQ. 3) KEYWIL = -2
      IF (NRECYS .EQ. 5) KEYWIL = 4
      IF (NRECYS .EQ. 5 .AND. NRECYX .EQ. 3 .AND. ATSCAL .GT. 0.) THEN
         WRITE (8, FMT='('' SCALE from ATOMS file ATSCAL='', F10.7)')
     *      ATSCAL
         IF (ABS ( SCALE - ATSCAL) .GT. 0.0001) WRITE (8,FMT=
     *     '('' [ old internal SCALE was SCALE='', F10.7)') SCALE
         WRITE (8, FMT='('' $TE!NRECY ATSCAL='', F10.7)') ATSCAL
         SCALE = ATSCAL
         WRITE (8, FMT='('' $TE SCALE ATsc '',I3,2F6.3,F8.4,2F6.3, I5)')
     *       NRECYR, PSQ, R2X, SCALE, BP, BR, KEYWIL
         ENDIF
  190 CONTINUE
      CALL WR24
      WRITE (8, FMT='(/'' DDMAIN : KEYT ='', I2)') KEYT
      WRITE (8, 211) SCALE, BP, BR
  211 FORMAT (' DDMAIN : Scale and B-values : Scale =',
     *          F9.5, ' Bp =', F6.3, ' Br =', F6.3)
         WRITE (8, FMT='('' $TE SCALE >>SF '',I3,2F6.3,F8.4,2F6.3,
     *      '' KEYD='', I1)')
     *       NRECYR, PSQ, R2X, SCALE, BP, BR, KEYD
      IF (KEYD.EQ.0 .OR. KEYD.EQ.5 .OR. EXPAND) THEN
         CALL FCALC (NSET, 0)
         CALL WR24
      ELSEIF (KEYT .LT. 3) THEN
         CALL AUTOFR (NSET)
         CALL WR24
         IF (KSTAT(6) .EQ. 17) THEN
            WRITE (8, 7142)
 7142       FORMAT (' stop multi PATTY    [ switch KSTAT(6)=17 ]')
            WRITE (8, 259) IPAT, NRECYR, NRECYS, R2X
            ENDIF
         IF (KSTAT(6) .EQ. 17) GOTO 739
         IF (IDOKA .EQ. 17) RETURN
      ELSE
         WRITE (9,*) ' AUTOFR is suppressed when using Anisotr.t.f. !'
         CALL FCALC (NSET, 0)
         ENDIF
      IF (KEYD .EQ. 0) THEN
         CALL FILCLO (IATOMS, 'KEEP')
         CALL FILCLO (IBINFC, 'KEEP')
         CALL KEPROX
         RETURN
         ENDIF
      IF (KEYD .GE. 5) THEN
         CALL FILCLO (IATOMS, 'KEEP')
         CALL KEPROX
         RETURN
         ENDIF
      IF (.NOT.EXPAND .AND. NORECY .AND. KEYD.EQ.0) CALL SCALE7
      CALL WR24
      CALL NNRECY (1)
      IF (NAT .GT. 799) GOTO 254
      IF (KEYT .EQ. 1) THEN
         IF (.NOT. EXPAND .AND. KEYD.EQ.1) CALL SCASTA
         DO 233 I = 1, NAT
         ATXYZ(6,I) = 0.0
  233    ATXYZ(5,I) = BP
         IF (.NOT. EXPAND) CALL ATOMOC (1, ATXYZ, IZAT,  NAT)
         KEYT = 2
         GOTO 237
         ENDIF
      IF (NAT .EQ. NATINP) GOTO 254
  237 CONTINUE
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'OUTPUT', KINQ)
      IF (.NOT. EXPAND) CALL ATOMOC (2, ATXYZ, IZAT,  NAT)
      IF (IPAT .EQ. 0) THEN
         WRITE (CHOUT, 242) CCODE, IRUN, NRECYR, R2X, SCALE
  242    FORMAT ('ATOMS ', A6, ' < DDMAIN 0 ',
     *   ' RUN', I4, ' CY=', I3, '  R2=', F6.3, '  SC=', F10.6 )
      ELSE
         WRITE (CHOUT, 243) CCODE, IPAT, IRUN, NRECYR, R2X, SCALE
  243    FORMAT ('ATOMS ', A6, ' PAT=', I3,
     *   ' RUN', I4, ' CY=', I3, '  R2=', F6.3, '  SC=', F10.6 )
         ENDIF
      WRITE (IATOMS, FMT = '(A72)') CHOUT
      NN = NATINP - NAT
      IF (NRECYR .GE. 1) WRITE (IATOMS, 247) NN, NRECYR
  247 FORMAT ('REMARK DDMAIN,', I3, ' atoms rejected in CYCLE', I3 )
      IF (NRECYR .EQ. 1 .AND. SWRECY) WRITE (IATOMS, FMT=
     *  '(''REMARK DDMAIN, input atoms, CYCLE 1'' )')
      NN = MIN0 (3, NAT)
      CALL AT123P ('OUTPUT', ' ATOMS', 24, ATNAME, ATXYZ, NN)
      WRITE (8, 248) CHOUT
  248 FORMAT (/' output atoms set to file ATTEM :'// 1X, A72/)
      DO 252 NATR = 1, NAT
  252 CALL ATOMWB (IATOMS, ATXYZ, ATNAME, NATR)
      WRITE (24, 253) NAT
  253 FORMAT (' Number of atoms written to ATOMS file:', I4)
      CALL WR24
      WRITE (IATOMS, FMT = '(''END'')')
      IF (NRECYR .EQ. 1 .AND. SWRECY) THEN
         CALL FILINQ (IAT10, 'ATTEM', 'FORMATTED', 'INPUT', KINQ)
         CALL FILCLO (IAT10, 'DELETE')
      ELSE
         CALL COPY80 (IATOMS, 'ATOMS', IAT10, 'ATTEM')
         ENDIF
  254 CONTINUE
      CALL FILCLO (IATOMS, 'KEEP')
      IF (NRECYS .LE. 7) GOTO 739
      IF (MPAT .GT. -99 .AND. MPAT .LT. -1) THEN
         IF (NRECYS .LE. 8 .AND. R2X .LT. .50) GOTO 739
         WRITE (8, 259) IPAT, NRECYR, NRECYS, R2X
  259    FORMAT(/ ' stop multi PATTY analysis for IPAT=',I2/ 6X,
     *       ' NRECYR=',I2,' NRECYS=',I2, ' R2X=', F5.3 /)
         CALL NNRECY (90)
         KSTAT(14) = 0
         GOTO 1357
         ENDIF
      CALL GETR2X (0, 10, IRUN, KEND)
      WRITE (8, FMT='('' TEMP99 KEND'', I3)') KEND
      IF (KEND .LE. 0) GOTO 739
      CALL KERNZA (-1.0, R2CYCA, MRECY)
      NCY = KEND+1
      IF (NCY .LT. 7) WRITE (8, *) ' check NCY, NRECYR:', NCY, NRECYR
      IF (NCY .LT. 7) GOTO 739
      R2CYC(NCY) = R2X
      R2MIN = 9.999
      NR2MIN = NCY
      IF ( R2CYC(1).GT.0.) R2CYCA(1) =  R2CYC(1)
      IF ( R2CYC(1).GT.0. .AND. R2CYC(2).GT.0.)
     *   R2CYCA(2) = ( R2CYC(1) + R2CYC(2) ) / 2.
      IF( R2CYC(1).GT.0. .AND. R2CYC(2).GT.0. .AND. R2CYC(3).GT.0.)
     *    R2CYCA(3) = ( R2CYC(1) + R2CYC(2) + R2CYC(3) ) / 3.
      DO 723 N = 3, NCY
      IF (R2CYC(N) .LT. R2MIN) THEN
         NR2MIN = N
         R2MIN = R2CYC(N)
         ENDIF
      IF (N .EQ. 3) GOTO 723
      IF( R2CYC(N-3).GT.0. .AND. R2CYC(N-2).GT.0. .AND. R2CYC(N-1).GT.0.
     *   .AND. R2CYC(N).GT.0.)   R2CYCA(N) =
     *   ( R2CYC(N-3) + R2CYC(N-2) + R2CYC(N-1) + R2CYC(N) ) / 4.
  723 CONTINUE
      NCY1 = MAX0 (1, NCY - 9)
      WRITE (8, 733) (I, I=NCY1,NCY)
  733 FORMAT(/' For cycle nr', I4, 9I6)
      WRITE (8, 734) (R2CYC(I), I=NCY1,NCY)
  734 FORMAT (' R2 values: ', 10F6.3)
      WRITE (8, 735) (R2CYCA(I), I=NCY1,NCY)
  735 FORMAT (' Smoothed : ', 10F6.3)
      IF (R2CYC(NCY) .LT. R2CYC(NCY-1)) GOTO 739
      IF (R2CYC(NCY) .LT. R2CYC(NCY-2)) GOTO 739
      IF (R2CYCA(NCY) .LT. R2CYCA(NCY-1)) GOTO 739
      IF (R2CYCA(NCY) .LT. R2CYCA(NCY-2)) GOTO 739
      IF (R2X .LT. 1.01 * R2MIN) GOTO 739
      IF (R2X .LT. R2CYCA(NCY-1)) GOTO 739
      IF (R2X .LT. 1.1 * R2CYCA(NCY-1) .AND. NRECYR .LE. 8 .AND.
     *    R2X .LT. 1.1 * R2CYCA(NCY-2)) GOTO 739
      WRITE(9,*) ' The R2 value increases, the refinement is not stable'
      CALL GETR2X (NR2MIN, 10,  IRUN, KEND)
      IF (KEND .LE. 0) GOTO 739
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'OUTPUT', KINQ)
  736 READ (10, FMT='(A80)', END= 737) CHIN
      WRITE (IATOMS, FMT='(A80)' ) CHIN
      IF (CHIN(1:4) .NE. 'END ') GOTO 736
  737 READ (10,  FMT='(A80)', END= 1737) CHIN
      IF (CHIN(1:6) .NE. 'ATOMS ') GOTO 737
      CALL KERINB (LIT, 1)
      IF (LIT(4) .NE. 'DDMAIN') GOTO 1737
      REWIND IATOMS
      WRITE (IATOMS, FMT='(A80)' ) CHIN
 2736 READ (10,  FMT='(A80)', END= 1737) CHIN
      WRITE (IATOMS, FMT='(A80)' ) CHIN
      IF (CHIN(1:4) .NE. 'END ') GOTO 2736
 1737 CALL FILCLO (IATOMS, 'KEEP')
      CALL FILCLO (10, 'KEEP')
      WRITE (9,*) 'The atoms set with the lowest R2 value retrieved'
      IF (R2MIN .GT. .50) THEN
         WRITE (9,*) 'The R2 value is too high: stop.'
         CALL WR24
         IF (MPAT .GE. -1)
     *      CALL KERROR (' Wrong model used ?', 1737, 'DDMINI')
         CALL NNRECY (90)
         CALL ATPATS (1)
         ENDIF
      NORECY = .TRUE.
 1357 CONTINUE
      CALL FILINQ (IDDS, 'DDSYST', 'FORMATTED', 'OUTPUT', KIDDS)
      CALL FILINQ (ICON, 'CONDA', 'FORMATTED', 'OUTPUT', KINQCO)
      WRITE (ICON, 630) CCODE
  630 FORMAT ('CONDA ', A6)
      IF (MPAT .EQ. -99) THEN
         CALL XCONDA (ICON, IDDS, ICENT, 0)
         GOTO 631
      ELSEIF (MPAT .LE. -2 .AND. MPAT .GT. -99) THEN
         WRITE (IDDS, FMT='(''DDMAIN'' / ''STOP'')')
         WRITE (ICON, FMT='(''PROGRAM DDMAIN''/ ''OPTION 0 FCALC''/
     *      ''FINISH'')' )
      ELSE
         WRITE (IDDS, FMT='(''DDMAIN'' / ''FOUR''/
     *                      ''DDMAIN'' / ''NUTS''/ ''STOP'')')
         WRITE (ICON, FMT='(''PROGRAM DDMAIN''/ ''OPTION 3 FOUR ''/
     *                      ''PROGRAM FOUR '')')
         WRITE (ICON, FMT='(''PROGRAM DDMAIN''/ ''OPTION 0 FCALC''/
     *                      ''PROGRAM NUTS  AT2X'' / ''FINISH'')' )
         ENDIF
      CALL FILCLO (IDDS, 'KEEP')
      CALL FILCLO (ICON, 'KEEP')
      KSTAT(6) = 17
  631 CONTINUE
      CALL KEPROX
      RETURN
  739 CONTINUE
  255 CONTINUE
      IF (.NOT. EXPAND) THEN
         CALL BINIFF (1, IBINFC, 'BINFC',  FITFC,  NITFC, BUFFC,KENDFC)
      ELSE
         CALL BINIFF (1, IBINFC, 'BINFC2', FITFC2, NITFC2,BUFFC,KENDFC)
         ENDIF
      PSQX = PSQ
      IF (EXPAND) PSQX = P1SQ
      IF (KEYD .EQ. 2) CALL FCALCI (ATXYZ, IZAT, ITAT, NAT)
      IF (KEYD .NE. 1) GOTO 270
      IF (NAT .GE. 100) GOTO 260
      IF (IFIX (100.0 * PSQX) .LT. MAX0(79, 100- 3*NAT)
     *                           - MIN0(14, NAT/3) ) GOTO 270
  260 CONTINUE
      CALL FILINQ (IDDS, 'DDSYST', 'FORMATTED', 'OUTPUT', KINQ)
      IF (KINQ.EQ.-1) CALL KERROR ('No DDSYST file found',0,'DDMAIN')
      LITFFT = 0
  261 READ (IDDS, FMT='(A6)') LIT(1)
      IF (LIT(1) .EQ. 'FOUR') LITFFT = 1
      IF (LIT(1) .NE. 'STOP') GOTO 261
      REWIND IDDS
      IF (LITFFT .EQ. 1) THEN
         IF (NORECY) WRITE (24, 262)
  262    FORMAT (1X/' The scattering power is too large',
     *                  ' therefore program PHASEX is not' /
     *          ' applied and program FOUR follows.'/1X)
         WRITE (IDDS, FMT='(''FOUR'' / ''NUTS'' )')
         ENDIF
      WRITE (IDDS, FMT='(''STOP'')')
      CALL FILCLO (IDDS, 'KEEP')
      KEYD = 3
      KEYDS = 0
  270 CONTINUE
      IF (KEYD.EQ.3 .AND. KEYDS.GE.3) GOTO 310
      IF (KEYD .EQ. 2) GOTO 310
      IF (.NOT.EXPAND) CALL FCALII
      IF (KEYD .NE. 1) GOTO 310
      RDENR = 0
      RNUMR = 0
      DO 290 I=1,NTYPE
      RDENR = RDENR + (CELALL(I)-CELPAR(I))*IZTYPE(I)**2
  290 RNUMR = RNUMR + (CELALL(I)-CELPAR(I))*IZTYPE(I)**3
      E000R = (RDENR**1.5) / RNUMR / SQRT(ALATT)
      CALL BINOFF (1, IBINDU, 'BINDUA', FITDUA, NITDUA, BUFDUA, KENDUA)
      RETURN
  310 IEF = 1
      IF (KEYD.EQ.3 .AND. KEYDS.EQ.5) IEF = -1
      IMAP = 3
      IF (IEF.EQ.-1) IMAP = 4
  935 CONTINUE
      IF (EXPAND) KEXPA = 1
      CALL BINOFF (1, IBINFF, 'BINFFT', FITFFT, NITFFT, BUFFFT, KENDFF)
      CALL WR24
      WRITE (8, FMT='(/'' ***** end of subr DDMINI ***** ''/)')
      RETURN
      END
      SUBROUTINE ATIN7 (NSET)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zddif.inc'
      EQUIVALENCE (IATOMS, IFILE(2))
      COMMON /ORFLES/ LASTV, NORFLX (6, 50)
      CHARACTER *80 CHIN2, CHIN3
  110 CALL KERINA (IATOMS, LIT, 1, LEND)
      IF (LEND .NE. 0) THEN
         NSET  = -NSET
         RETURN
         ENDIF
      IF (LIT(1) .NE. 'ATOMS') GOTO 110
      CHIN2 = CHIN
      IF (NSET.EQ.0 .AND. LIT(5).EQ.'MOD=' .AND. LIT(9).EQ.'R2=') THEN
         NTV = NINT(FNUM(4))
         IF (NTV .GT. 50) NTV = 50
         NORFLX(4,NTV) = NTV
         NORFLX(1,NTV) = NINT(FNUM(1))
         NORFLX(2,NTV) = NINT(FNUM(2))
         NORFLX(3,NTV) = NINT(FNUM(3))
         NORFLX(5,NTV) = NINT(FNUM(6))
         LASTV = NTV
         WRITE(24, 114) (NORFLX(I, NTV), I=1,5)
         WRITE (8, 114) (NORFLX(I, NTV), I=1,5)
  114    FORMAT (22X,' atoms set MOD= OR= TR= TV= FOM= ', 4I3, I5)
         ENDIF
      READ (IATOMS, 117, ERR = 123, END = 123) CHIN3
  117 FORMAT (A)
      GOTO 129
  123 CALL KERNER (123, 'ATIN7')
  129 BACKSPACE IATOMS
      BACKSPACE IATOMS
      CALL ATOMIN (IATOMS, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      NSET = NSET + 1
      NATQ = NAT
      NATH = 0
      N = 1
  143 CONTINUE
      IF (ATNAME(N)(1:1).EQ.'H' .AND. IZAT(N).EQ.1) NATH = NATH + 1
      IF (ATNAME(N)(1:1) .EQ. 'Q') THEN
         IF (N .EQ. NAT) GOTO 148
         DO 146 N1 = N, NAT - 1
         CALL KERNAB (ATXYZ(1,N1+1), ATXYZ(1,N1), 10)
         ATNAME(N1) = ATNAME(N1+1)
  146    IZAT(N1) = IZAT(N1+1)
  148    NAT = NAT - 1
         N = N - 1
         ENDIF
      N = N + 1
      IF (N .LE. NAT) GOTO 143
      IF (NAT.LT.NATQ) WRITE (8, FMT=
     *  '('' Nr of Q-atoms (= peaks) rejected:'', I3)') NATQ-NAT
      IF (NATH.NE.0) WRITE(24, FMT=
     *  '('' Number of H atoms included:'', I3)') NATH
      IF (NAT .LE. 0) CALL KERROR ('.... No atoms left!', 0, 'ATIN7')
      IF (NSET .GT. 1) CALL ATOMPR (8, 2, ATXYZ, ATNAME, IZAT, NAT)
      CHIN = CHIN2
      CALL KERINB (LIT, 1)
      CALL QFOMR2 (1, NSET, 0., 0., CHIN3)
      RETURN
      END
      SUBROUTINE QFOMR2 (KEY, NSET, R2E, R2, CHIN3)
      CHARACTER *80 CHIN3
      INCLUDE 'Zaaaa.inc'
      EQUIVALENCE (KEYWIL, KSTAT(17))
      EQUIVALENCE (IRUN, KSTAT(13))
      EQUIVALENCE (KEYD, KSTAT(19))
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zatq2.inc'
      DIMENSION NSKIP(MS), QQ(MS), LL(MS), LLL(MS)
      PARAMETER (LITAM = 10)
      CHARACTER *6 LITA(LITAM)
      DATA LITA / 'OR=   ', 'ISIG= ', 'TR=   ', 'TV=   ', 'FOM=  ',
     *            'PAT   ', 'R2=   ', 'RUN   ', 'X=    ', 'PAT=  ' /
      DATA IATOMS /2/
      DATA K     /0/
      DATA ISTOP /0/
      DATA PFOMM /0./
      DATA MSET  /0/
      DATA NSET9 /999/
      DATA BPST, BRST, BPMIN, BRMINP /0., 0., 999., 999./
      CALL WR24
      IF (KEY .EQ. 0) THEN
         ISTOP = 0
         NSET9 = 999
         RETURN
         ENDIF
      IF (KEYD .NE. 7) ISTOP = 1
      IF (LITJ2 .NE. 'PATTY ') ISTOP = 1
      IF (ISTOP .GT. 0) RETURN
         NPAT = 0
         PFOM = 0.
         RR2 = 0.
         NPAT1 = 0
         NPAT2 = 0
      NF = 0
      FFF = 0.
      IF (KEY .LT. 0) GOTO 700
      IF (KEY .EQ. 2) GOTO 500
      IF (NSET .LE. 0) RETURN
      IF (NSET .LT. NSET9) THEN
         PFOMM = 0.
         NSET9 = NSET
         MSET = NSET
         ISTOP = 0
         ENDIF
      IF (MPAT .GE. 2) SCALE = SCAMER
      NCHIN = 0
  100 NCHIN = NCHIN + 1
      CALL KERINB (LITA, LITAM)
      IF (NLIT .LT. 3 .OR. NFNUM .LT. 2) GOTO 400
      NF = 0
      NL = 0
      NPAT = 0
      PFOM = 0.
      RR2 = 0.
      NPAT1 = 0
      NPAT2 = 0
      DO 312 I = 1, 32
      IF (NFDOL(I) .LT. 0) THEN
         NL = NL + 1
      ELSEIF (NFDOL(I) .GT. 0) THEN
         NF = NF + 1
         FFF = FNUM(NF)
         IF (NLUSER(NL) .LE. 0) GOTO 312
         IF (NLUSER(NL) .EQ. 6) NPAT1 = NINT (FFF)
         IF (NLUSER(NL) .EQ. 10) NPAT2 = NINT (FFF)
         IF (NLUSER(NL) .EQ. 5) PFOM = FFF
         IF (NLUSER(NL) .EQ. 7) RR2 = FFF
      ELSE
         GOTO 317
         ENDIF
  312 CONTINUE
  317 CONTINUE
      IF (NPAT1 .GT. 0 .AND. PFOM .GT. 0.01) THEN
         NPAT = NPAT1
         GOTO 403
      ELSEIF (NPAT2 .GT. 0 .AND. PFOM .GT. 0.01) THEN
         NPAT = NPAT2
         GOTO 403
      ELSE
         NPAT1 = 0
         NPAT2 = 0
         PFOM = 0.
         RR2 = 0.
         ENDIF
  400 CONTINUE
      IF (NCHIN .EQ. 1) THEN
         CHIN =  CHIN3
         GOTO 100
         ENDIF
  403 CONTINUE
      NPATS(NSET) = NPAT
      PFOMS(NSET) = PFOM
      R2S(NSET) = RR2
      IF (PFOM .GT. PFOMM) PFOMM = PFOM
      NATSS(NSET) = NAT
      DO 147 I=1, NAT
      K = K + 1
      CALL KERNAB (ATXYZ(1,I), XYZ(1,K), 5)
      ATNMS(K) = ATNAME(I)
  147 CONTINUE
      MSET = NSET
      RETURN
  500 CONTINUE
      R2ES(NSET) = R2E
      R2S(NSET) = R2
      BPS(NSET) = BP
      BRS(NSET) = BR
      BPST = BPST + BP
      BRST = BRST + BR
      IF (BP .LT. BPMIN) THEN
         BPMIN = BP
         BRMINP = BR
         ENDIF
      BP = BOVMER
      BR = BP
      SCALE = SCAMER
      RETURN
  700 CONTINUE
      ISTOP = 999
      IF (PFOMM .LE. 0.) RETURN
      BPST = BPST / MSET
      BRST = BRST / MSET
      BPMAX = 1.1 * BPST
      BPSE = 0.
      BRSE = 0.
      NBPS = 0
      DO 711 I = 1, MSET
      PFOMS(I) = PFOMS(I) / PFOMM
      BPSS(I) = 0.
      IF (BPS(I) .LE. BPMAX) THEN
         BPSE = BPSE + BPS(I)
         BRSE = BRSE + BRS(I)
         NBPS = NBPS + 1
         ENDIF
      IF (BPS(I) .GT. 0.01) BPSS(I) = BPST / BPS(I)
  711 CONTINUE
      BPSE = BPSE / NBPS
      BRSE = BRSE / NBPS
      WRITE (24, FMT='(1X/'' Values of Bp and Br for all PATTY sets''/
     *  1X/'' Nset    Bp     Br    BpFOM ''/1X)')
      WRITE (24, FMT='(I4, 2F7.2, F9.2)')
     *      (I, BPS(I), BRS(I), BPSS(I), I=1,MSET)
      WRITE (24, FMT='(1X/'' Average values of Bp and Br'', 2F6.2 /
     *                    '' Lower average  of Bp and Br'', 2F6.2 /
     *                    '' Lowest value of Bp, with Br'', 2F6.2 )')
     *      BPST, BRST, BPSE, BRSE, BPMIN, BRMINP
      BP = BPS(1)
      BR = BRS(1)
      KEYWIL = -2
      NSKIP(1) = 0
      DO 713 I = 2, MSET
      NSKIP(I) = NSKIP(I-1) + NATSS(I-1)
  713 CONTINUE
      QFM = 0.
      DO 715 I = 1, MSET
      IF (R2S(I) .LT. 0.01) R2S(I) = 1.0
      F = PFOMS(I) * R2ES(I)
      IF (F .LT. 0.01) F = 0.01
      QFOMS(I) = SQRT(F) / R2S(I)
      IF (QFM .LT. QFOMS(I)) QFM = QFOMS(I)
  715 CONTINUE
      DO 716 I = 1, MSET
      QFOMS(I) = QFOMS(I) / QFM
      QQ(I) = QFOMS(I)
  716 CONTINUE
      IL = 0
      DO 720 L = 1, MSET
      Q = 0.
      IM = 0
      DO 718 I = 1, MSET
      IF (QQ(I) .LE. Q) GOTO 718
      Q = QQ(I)
      IM = I
  718 CONTINUE
      QQ(IM) = 0.
      LL(IM) = L
      IL = IL + 1
      LLL(L) = IM
  720 CONTINUE
      WRITE (24, FMT='(1X/'' final R2 TEST results '' /1X/ ,
     * '' input  PATTY-results  R2-results   Combined  new order'',
     *    ''     Bp-results''/
     * '' NSET    PAT   FOM=    R2Expect R2     FOM=     PAT=   '',
     *    ''     BpFOM''/1X)')
      MPAT2 = 1
      IF (MSET .LE. 1) GOTO 721
      MPAT2 = MAX0(LL(1), LL(2))
      IF (MSET .GE. 3) MPAT2 = MAX0(MPAT2, LL(3))
      CALL WR24
      WRITE (8, FMT='( '' $TE best PATTY'',3I3)') LL(1), LL(2), MPAT2
      NSETM = NINT(R2E)
      IF (NSETM .LE. 0) NSETM = 1
      NSETM2 = NINT(R2)
      IF (NSETM2 .LE. 0) NSETM2 = 1
      MPAT3 = MAX0(LL(NSETM), LL(NSETM2))
      WRITE (8, FMT='( '' $TE best < R2 '',3I3)')
     *   LL(NSETM), LL(NSETM2), MPAT3
      IF (MPAT3 .GT. MPAT2) MPAT2 = MPAT3
      IF (MPAT2 .GT. 10) MPAT2 = 10
  721 CONTINUE
      NNNPAT = 0
      DO 725 I = 1, MSET
      IFOM = NINT (PFOMS(I) * 10000.)
      WRITE (24, 724) I, NPATS(I), IFOM, R2ES(I),R2S(I),QFOMS(I),LL(I)
     *   , BPSS(I)
  724 FORMAT (I5,   I7,    I7,    F9.3, F6.3, F9.4, I9, F12.2)
         IF (I .NE. NPATS(I))  NNNPAT = 1
  725 CONTINUE
      IF (MPAT .EQ. 55) THEN
         MPAT = MPAT2
         IF (MPAT .GT. MSET) MPAT = MSET
         WRITE(9,FMT='(/'' PATTY, max nr of solutions:'',I3/)') MPAT
         ENDIF
      IF (MPAT .GT. MSET) MPAT = MSET
      CALL WR24
      WRITE(24, 727) MPAT
  727 FORMAT (/' Nr of PATTY sets to be expanded:',I3/)
      IF (NNNPAT .EQ. 1) WRITE(24, FMT='(/
     *      '' NOTE: the sequence of input sets'',
     *      '' (NSET) is not equal''/'' to the original PATTY output'',
     *      '' sequence (PAT):''/ '' see REMARK on ATOMS file'',
     *      '' when NSET and PAT do not match.''/
     *      '' The present output ATOMS sequence is denoted PAT=''/)')
      IM = LLL(1)
      BP = BPS(IM)
      BR = BRS(IM)
      REWIND IATOMS
      DO 757 M = 1, MSET
      IM = LLL(M)
      WRITE (IATOMS, FMT='(''ATOMS '', A6, '' < PAT.R2 0 RUN'', I4,
     *   '' PAT='', I3, '' R2='', F6.3, '' FOM='', F6.3)')
     *   CCODE, IRUN, LL(IM), R2S(IM), QFOMS(IM)
      WRITE (IATOMS, FMT='(''REMARK BpBr= '', 2F9.4)') BPS(IM), BRS(IM)
      IF (NNNPAT .EQ. 1) WRITE (IATOMS, FMT='(
     *    ''REMARK original from PATTY:'', I3,
     *    '', was now input NSET='', I3)') NPATS(IM), M
      K = NSKIP(IM) + 1
      KK = K - 1 + NATSS(IM)
      DO 747 I = K, KK
      WRITE (IATOMS, FMT='( ''ATOM   '',A6, 3F9.5, 2F9.4)')
     *   ATNMS(I), (XYZ(J,I), J=1,5)
  747 CONTINUE
      WRITE (IATOMS, FMT='(''END''/)')
  757 CONTINUE
      WRITE (IATOMS, FMT='(''FINISH'')')
      WRITE (24, 760)
  760 FORMAT (1X/
     * ' All accepted parameter sets are written to the ATPAT file' /)
      CALL KERASE ('ATPAT')
      CALL COPY80 (IATOMS, 'ATOMS', 10, 'ATPAT')
      IF (MPAT .EQ. 1) THEN
         MPAT = -1
         PATBP = BP
         PATBR = BR
         RETURN
         ENDIF
      CALL WR24
      IF (MPAT .GT. 0) MPAT = - MPAT
      CALL ATPATS (0)
      RETURN
      END
      SUBROUTINE FCALII
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zaaaa.inc'
      EQUIVALENCE (KEYD, KSTAT(19))
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zddif.inc'
      DIMENSION KLAD(MAXAT)
      CALL ATOMOC (0, ATXYZ, KLAD, NAT)
      CALL KERNZA (0.0, CELPAR, NTYPE)
      DO 170 I = 1,NAT
      DO 170 J = 1,NTYPE
      IF (IZAT(I) .NE. IZTYPE(J)) GOTO 170
      ITAT(I) = J
      CELPAR(J) = CELPAR(J) + ATXYZ(4,I) * AMULT / FLOAT(KLAD(I))
  170 CONTINUE
      SUMZP = 0.0
      SUMZA = 0.0
      DO 180 I = 1,NTYPE
      SUMZP = SUMZP + CELPAR(I) * FF(2,I) ** 2
  180 SUMZA = SUMZA + CELALL(I) * FF(2,I) ** 2
      PSQ = SUMZP / SUMZA
      P1SQ = PSQ / ( ICENT * NSYMM )
      BPAV = 0.
      IF (KEYT .GT. 1) THEN
         IZATT = 0
         DO 174 I = 1, NAT
         BPAV = BPAV + ATXYZ(5,I) * IZAT(I) **2
  174    IZATT = IZATT + IZAT(I) ** 2
         BPAV = BPAV / FLOAT(IZATT)
         WRITE (8, 173) BPAV
  173    FORMAT (/' FCALII: Averaged value of Bp for known atoms:',
     *      ' Bp = ', F8.3/)
         BP = BPAV
         ENDIF
      IF (PSQ .GT. 1.1) THEN
         WRITE (24, FMT='('' Warning: P**2:'', F7.3)') PSQ
         ENDIF
      CALL WR24
      ISMAX = IFIX (STLMAX * 400. + 0.04) + 2
      IF (ISMAX .GT. 500) CALL KERROR ('STLMAX reset?', 270, 'FCALII')
      DO 282 IS=1,ISMAX
      STL = FLOAT(IS-1) * 0.0025
      STL2 = STL * STL
      SUMF2P(IS) = 0.0
      DO 260 I=1,NTYPE
  260 SUMF2P(IS) = SUMF2P(IS)+ FF(IS,I) * FF(IS,I) * CELPAR(I)
      EXPBR(IS) = EXP(-BR * STL2)
  282 EXPBP(IS) = EXP(-BP * STL2)
      RETURN
      END
      SUBROUTINE FCALC (NSET, KEYAUT)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zbinx.inc'
      INCLUDE 'Zbuff.inc'
      INCLUDE 'Zcrys.inc'
      EQUIVALENCE (IBINFC, IFILE(12))
      EQUIVALENCE (IDOKA, KEYS(10))
      EQUIVALENCE (KEYWIL, KSTAT(17))
      EQUIVALENCE (KEYD, KSTAT(19))
      EQUIVALENCE (KEYDS, KSTAT(20))
      LOGICAL SWRECY, EXPAND, LTESTR
      EQUIVALENCE (SWRECY, SWITCH(7)), (EXPAND, SWITCH(23))
      EQUIVALENCE (LTESTR, SWITCH(27))
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zddif.inc'
      LOGICAL LBINFC, LCALR2
      LBINFC = .TRUE.
      LCALR2 = .FALSE.
      LTESTR = .TRUE.
      CALL WR24
      IF (KEYD .LT. 5) LTESTR = .FALSE.
      IF (KEYD .EQ. 0 .AND. KEYDS .EQ. -1) LCALR2 = .TRUE.
      IF (LCALR2) LTESTR = .TRUE.
      IF (LCALR2) KEYWIL = 4
      IF (LTESTR) LBINFC = .FALSE.
      IF (LBINFC) LTESTR = .FALSE.
      R2MIN = 999.
      WRITE(24, FMT='(/'' Calculate structure factors'')')
      CALL WILSIN (999)
      IF (.NOT. LCALR2)
     *   WRITE (8, FMT='(/'' Calculate structure factors, new'',
     *       '' temperature factors and new scale'')')
      FICENT = FLOAT (ICENT)
      IF (KEYD .GE. 5) STOP 206
      GOTO 151
  100 CALL ATIN7 (NSET)
      IF (NSET .LE. 0) GOTO 910
      IF (KEYT .EQ. 3) CALL KERROR
     *   (' No anisotr. allowed in AUTOR2 TEST runs', 100, 'AUTOFR')
      CALL FCALCI (ATXYZ, IZAT, ITAT, NAT)
  151 CONTINUE
      IF (EXPAND) THEN
         WRITE(24, 183) P1SQ
  183    FORMAT (' Scattering fraction of known part:'/
     *   '    excluding symmetry related molecules: P1**2 =', F6.3)
      ELSE
         IF (PSQ .LT. 0.99) THEN
            WRITE (8, 184) PSQ
  184       FORMAT (' Scattering fraction of known part: P**2 =', F6.3)
            ENDIF
         ENDIF
      CALL WR24
      IF (.NOT. EXPAND) THEN
         IF (LBINFC)
     *   CALL BINOFF (1, IBINFC,'BINFC', FITFC, NITFC, BUFFC, KENDFC)
      ELSE
         CALL BINOFF (1, IBINFC,'BINFC2', FITFC2, NITFC2, BUFFC, KENDFC)
         ENDIF
      CALL RINI (RNUM,RDEN,RNM2XF,RDN2XF,RNM2EF,
     *          RNM2XZ,RDN2XZ,RNM2EZ,RDN2EZ,SR2NUM,SR2DEN,C1,C2,ICENT)
      SUMNR2 = 0.
      SUMFO2 = 0.
      SUMFP2 = 0.
      SUMFF2 = 0.
      SUMFC2 = 0.
      SUMFO4 = 0.
      SUMFR4 = 0.
      IREFX = 0
  200 CONTINUE
      IREFX = IREFX + 1
      HCODE = FBINX(1,IREFX)
      FOBS = FBINX(2,IREFX)
      IF (FOBS .LT. 0.) GOTO 220
      SIG = FBINX(3,IREFX)
      CALL HKLC1U (HCODE, HKLX)
      CALL HKLSTL (HKLX, STL, STL2)
      IF (.NOT. EXPAND) THEN
         CALL FCALC1 (ATXYZ, ITAT, NAT)
         FP2F2R = FP**2 + (SUMF2(ISS) - SUMF2P(ISS)) * EXPBR(ISS)**2
         SUMFO2 = SUMFO2 + FOBS**2
         SUMFP2 = SUMFP2 + FP2F2R
         SUMFC2 = SUMFC2 + FP**2
         FOSC  = FOBS * SCALE
         SUMFR4 = SUMFR4 + (FP**2 - FOSC**2)**2
         SUMFO4 = SUMFO4 + FOSC**4
         CALL R2CALC (RNUM,RDEN,RNM2XF,RDN2XF,RNM2EF,RDN2EF,
     *        RNM2XZ,RDN2XZ,RNM2EZ,RDN2EZ,SR2NUM,SR2DEN,C1,C2)
         R2X = RNM2XZ
         CALL WILSIN (0)
      ELSE
         CALL FCALC2 (ATXYZ, ITAT, NAT)
         SUMNR2 = SUMNR2 + ASYMM / EPSIL2
         SF2 = SUMF2 (ISS)
         SF2P= SUMF2P(ISS)
         SUMFF2 = SUMFF2 + (SF2 - SF2P*ASYMC) * EXPBR(ISS) / EPSIL2
         SUMFO2 = SUMFO2 + FOBS**2 / EPSIL2
         DO 210 I = 1, NSYMM
         IF (FPEXP(1,I).GT.0.0) SUMFP2 = SUMFP2 + FPEXP(1,I)**2
  210    CONTINUE
         ENDIF
      IF (.NOT. EXPAND) THEN
         FITFC(1) = FP
         FITFC(2) = PHIP
         IF (LBINFC)
     *   CALL BINOFF (0, IBINFC, 'BINFC', FITFC,  NITFC, BUFFC, KENDFC)
      ELSE
         FITFC2(1) = EPSIL2
         FITFC2(2) = SF2
         FITFC2(3) = SF2P
         CALL KERNAB (FPEXP, FITFC2(4), NITFC2-3)
         CALL BINOFF (0, IBINFC, 'BINFC2',FITFC2, NITFC2,BUFFC, KENDFC)
         ENDIF
      GOTO 200
  220 CONTINUE
      IF (.NOT. EXPAND) THEN
         IF (LBINFC)
     *   CALL BINOFF (-1, IBINFC, 'BINFC', FITFC,  NITFC, BUFFC, KENDFC)
      ELSE
         CALL BINOFF (-1, IBINFC, 'BINFC2',FITFC2, NITFC2,BUFFC, KENDFC)
         ENDIF
      IF (.NOT. EXPAND) THEN
         CALL RPR (RNUM,RDEN,RNM2XF,RDN2XF,RNM2EF,RDN2EF,
     *        RNM2XZ,RDN2XZ,RNM2EZ,RDN2EZ,SR2NUM,SR2DEN)
         R2X = RNM2XZ
      IF (KEYAUT .EQ. 1) RETURN
      IF (MPAT .LE. -2 .AND. MPAT .GT. -99) CALL ATPATS(1)
         IF (IPAT .LT. 0)  CALL ATSETS
         IF (LCALR2) GOTO 990
         IF (LTESTR) THEN
            IF (NSET .EQ. 1) WRITE(24, FMT='(/
     *         '' Structure factor calculation for all atom sets:''/
     *         '' Set No.  Nr.atoms  p**2  expected R2  actual R2'')')
            WRITE(24, 1254) NSET, NAT, PSQ, RNM2EZ, RNM2XZ
 1254       FORMAT (I7, I8, F9.3, F13.3, F11.3)
            IF (RNM2XZ .LT. R2MIN) THEN
               R2MIN = RNM2XZ
               NSETM = NSET
               ENDIF
            ENDIF
      ELSE
         WRITE (8, 254) NINT(SUMNR2)
  254    FORMAT (' Number of reflections after expansion:', I10)
         SUMFP2 = SUMFP2 * FICENT  + SUMFF2
         ENDIF
      CALL WR24
      IF (LTESTR) GOTO 100
      GOTO 990
  910 CONTINUE
      WRITE(24, FMT='(
     *      '' Structure factor calc finished for all atom sets '')')
      IF (R2MIN .LT. 998. .AND. NSETM .NE. 1) THEN
         WRITE(24, 1255) R2MIN, NSETM
 1255    FORMAT(' Note: Lowest value of R2 =', F6.3, ' for set nr.', I3)
         ENDIF
      CALL WR24
      IDOKA = 17
  990 RETURN
      END
      SUBROUTINE FCALC1 (ATXYZ, ITAT, NAT7)
      DIMENSION ATXYZ(10,NAT7), ITAT(NAT7)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      DIMENSION FFF(10), ADTRIG(24)
      DATA  FFF, ADTRIG / 34*0.0 /
      S = STL * 400. + 1.
      IS = IFIX(S)
      STLDEL = S - FLOAT(IS)
      ISS = NINT(S)
      DO 110 J=1,NTYPE
      IF (CELPAR(J).LE.0.0) GOTO 110
      FFF(J) = FF(IS,J) + (FF(IS+1,J)-FF(IS,J)) * STLDEL
  110 CONTINUE
      CALL HKLEX1 (HKLX, HKLX)
      IF (NSYMM.EQ.1) GOTO 150
      DO 140 J=2,NSYMM
      IF (ITRS(J).EQ.0) GOTO 140
      ADTRIG(J) = HKLX(1,1)*TSYMM(1,J) + HKLX(2,1)*TSYMM(2,J) +
     *            HKLX(3,1)*TSYMM(3,J)
  140 CONTINUE
  150 FAP = 0.0
      FBP = 0.0
      IF (KEYT.EQ.1) GOTO 300
      DO 250 I=1,NAT
      A1 = 0.
      B1 = 0.
      A2 = 0.
      B2 = 0.
      DO 200 J=1,NSYMM
      TRIG = HKLX(1,J)*ATXYZ(1,I) + HKLX(2,J)*ATXYZ(2,I) +
     *       HKLX(3,J)*ATXYZ(3,I) + ADTRIG(J)
      IF (TRIG.LT.0.0) TRIG = TRIG - 0.00010
      ITRIG = MOD ( IFIX(TRIG * 10000. + 0.5), 10000)
      IF (ITRIG.LE.0) ITRIG = ITRIG + 10000
      IF (ATXYZ(6,I) .GT. 0.0) GOTO 180
      A1 = A1 + SICO(ITRIG + 2500)
      B1 = B1 + SICO(ITRIG + 2500)
      IF (ICENT.EQ.2) GOTO 200
      A2 = A2 - SICO(ITRIG)
      B2 = B2 + SICO(ITRIG)
      GOTO 200
  180 X1 = HKLX(1,J) * ATXYZ (5,I)
     *   + HKLX(2,J) * ATXYZ(10,I)
     *   + HKLX(3,J) * ATXYZ (9,I)
      X2 = HKLX(2,J) * ATXYZ (6,I)
     *   + HKLX(3,J) * ATXYZ (8,I)
      X3 = HKLX(3,J) * ATXYZ (7,I)
      TF = EXP(-0.25 * ( X1*HKLX(1,J) + X2*HKLX(2,J) + X3*HKLX(3,J) ))
      A1 = A1 + SICO(ITRIG + 2500) * TF
      B1 = B1 + SICO(ITRIG + 2500) * TF
      IF (ICENT.EQ.2) GOTO 200
      A2 = A2 - SICO(ITRIG) * TF
      B2 = B2 + SICO(ITRIG) * TF
  200 CONTINUE
      IJ = ITAT(I)
      IF (ATXYZ(6,I).LT.0.0) THEN
         TF = ATXYZ(4,I) * EXP (-STL2 * ATXYZ(5,I))
      ELSE
         TF = ATXYZ(4,I)
         ENDIF
      FAP = FAP + A1 * FFF(IJ)     * TF
      FBP = FBP + B1 * SFAC(11,IJ) * TF
      IF (ICENT .EQ. 2) GOTO 250
      FAP = FAP + A2 * SFAC(11,IJ) * TF
      FBP = FBP + B2 * FFF(IJ)     * TF
  250 CONTINUE
      FP = ASYMCL * SQRT (FAP*FAP + FBP*FBP)
      GOTO 500
  300 DO 450 I=1,NAT
      A1 = 0.
      B2 = 0.
      DO 400 J=1,NSYMM
      TRIG = HKLX(1,J)*ATXYZ(1,I) + HKLX(2,J)*ATXYZ(2,I) +
     *       HKLX(3,J)*ATXYZ(3,I) + ADTRIG(J)
      IF (TRIG.LT.0.0) TRIG = TRIG - 0.00010
      ITRIG = MOD ( IFIX(TRIG * 10000. + 0.5), 10000)
      IF (ITRIG.LE.0) ITRIG = ITRIG + 10000
      A1 = A1 + SICO(ITRIG + 2500)
      IF (ICENT.EQ.2) GOTO 400
      B2 = B2 + SICO(ITRIG)
  400 CONTINUE
      IJ = ITAT(I)
      FAP = FAP + A1 * FFF(IJ) * ATXYZ(4,I)
      IF (ICENT .EQ. 2) GOTO 450
      FBP = FBP + B2 * FFF(IJ) * ATXYZ(4,I)
  450 CONTINUE
      FP = ASYMCL * SQRT (FAP*FAP + FBP*FBP) * EXPBP(ISS)
  500 PHIP = 0.0
      IF (FP.GT.0.001) PHIP = ATAN2(FBP,FAP) / 0.0174532925
      IF (PHIP.LT.0.0) PHIP = PHIP + 360.
      RETURN
      END
      SUBROUTINE FCALC2  (ATXYZ, ITAT, NAT7)
      DIMENSION ATXYZ(10,NAT7), ITAT(NAT7)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zbuff.inc'
      DIMENSION FFF(10)
      S = STL * 400. + 1.
      IS = IFIX(S)
      STLDEL = S - FLOAT(IS)
      ISS = NINT(S)
      DO 110 J=1,NTYPE
      IF (CELPAR(J).LE.0.0) GOTO 110
      FFF(J) = FF(IS,J) + (FF(IS+1,J)-FF(IS,J)) * STLDEL
  110 CONTINUE
      CALL HKLEX1 (HKLX, HKLX)
      CALL HKLEX2 (HKLX, IDHKL, IEPS, IEPS2)
      EPSIL = IEPS
      EPSIL2 = IEPS2
      DO 600 J=1,NSYMM
      IF (IDHKL(J).EQ.0) GOTO 200
      K = IABS(IDHKL(J))
      FPEXP(1,J) = -K
      FPEXP(2,J) = FPEXP(2,K)
      IF (FPEXP(2,J).LT.0.0001) FPEXP(2,J)=0.0001
      IF (IDHKL(J).LT.0) FPEXP(2,J)=-FPEXP(2,J)
      GOTO 600
  200 FAP = 0.0
      FBP = 0.0
      DO 400 I=1,NAT
      TRIG = HKLX(1,J)*ATXYZ(1,I) + HKLX(2,J)*ATXYZ(2,I) +
     *       HKLX(3,J)*ATXYZ(3,I)
      IF (TRIG.LT.0.0) TRIG = TRIG - 0.00010
      ITRIG = MOD ( IFIX(TRIG * 10000. + 0.5), 10000)
      IF (ITRIG.LE.0) ITRIG = ITRIG + 10000
      IJ = ITAT(I)
      FAP = FAP + SICO(ITRIG + 2500) * FFF(IJ)
      FBP = FBP + SICO(ITRIG)        * FFF(IJ)
  400 CONTINUE
      FP = ALATT * SQRT (FAP*FAP + FBP*FBP) * EXPBP(ISS)
      PHIP = 0.0
      IF (FP.GT.0.001) PHIP = ATAN2(FBP,FAP) / 0.0174532925
      IF (PHIP.LT.0.0) PHIP = PHIP + 360.
      FPEXP(1,J) = FP
      FPEXP(2,J) = PHIP
  600 CONTINUE
      RETURN
      END
      SUBROUTINE SCALE7
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      EQUIVALENCE (IDDL, IFILE(1))
      EQUIVALENCE (KEYWIL, KSTAT(17))
      LOGICAL SWRECY, EXPAND
      EQUIVALENCE (SWRECY, SWITCH(7)), (EXPAND, SWITCH(23))
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zddif.inc'
      PARAMETER (PSQMAX = 0.90)
      CALL WR24
      WRITE (8, FMT='('' Calculate new SCALE and B values'')')
      IF (MPAT .GE. 1) KEYWIL = 0
      SC2 = SQRT (SUMFP2 / SUMFO2)
      IF (MPAT .GE. 2) GOTO 112
      IF (MPAT .LE. 2222) GOTO 112
      WRITE (8, 258) SC2
  258 FORMAT (' New scale = SQRT((SUMFP2 + FF2R) / SUMFO2):', F11.5)
      IF (PSQ .LT. PSQMAX) THEN
         WRITE (8, FMT='(''+'', 56X, ''(not used)'')')
      ELSE
         WRITE (8, FMT='(''+'', 56X, '' accepted!'')')
         SCALE = SC2
         KEYWIL = 4
         ENDIF
  112 CONTINUE
      IF (KEYWIL .NE. 4 .AND. NRECYS .LE. 5) CALL WILPAR
      CALL WR24
      IF (KEYWIL.NE.4 .AND. KEYWIL.GE.0) CALL WIL2DI
      RETURN
      END
      SUBROUTINE AUTOFR (NSET)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zbinx.inc'
      INCLUDE 'Zbuff.inc'
      INCLUDE 'Zcrys.inc'
      EQUIVALENCE (ICOND, IFILE(4)), (IDDL, IFILE(1)), (IDDS, IFILE(2))
      EQUIVALENCE (IBINFC, IFILE(12))
      EQUIVALENCE (KEYWIL, KSTAT(17))
      EQUIVALENCE (IRUN, KSTAT(13))
      EQUIVALENCE (KPROG, KSTAT(18))
      EQUIVALENCE (KEYD, KSTAT(19))
      LOGICAL SWRECY, NORECY, LTESTR
      EQUIVALENCE (SWRECY, SWITCH(7)), (NORECY, SWITCH(8))
      EQUIVALENCE (LTESTR, SWITCH(27))
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zddif.inc'
      EQUIVALENCE (ICYCL, NRECYR)
      DOUBLEPRECISION ATFP4(MAXAT), ATFPO(MAXAT), SFPS2, SFPS4, TERM2,
     *   TERM3, RNUM2C, RDEN2C
      DOUBLEPRECISION ATTOT(MAXAT)
      LOGICAL LBINFC
      LBINFC = .TRUE.
      LTESTR = .FALSE.
      CALL WR24
      WRITE (8, 100) 1
  100 FORMAT (/' -------------------- autofour bench mark', I3/)
      IF (KEYD .EQ. 7) THEN
         LTESTR = .TRUE.
         LBINFC = .FALSE.
         KEYWIL = 0
         BOV = BOVMER
         BP = BOV
         BR = BOV
         WRITE(24, 102)
  102    FORMAT (/' Structure factor calculation for all atom sets'/)
         ENDIF
      R2MIN =  999.9
      NSETM = 0
      NSETM2 = 0
      NATNOW = 0
      DO 103 IT = 1, NTYPE
      IF (IZTYPE(IT).NE.1) THEN
         NATNOW = NATNOW + NINT ( CELPAR(IT) )
         ENDIF
  103 CONTINUE
      NATEND = NATSYM
      NATNOW = NATNOW / IMULT
      NATRES = NATEND - NATNOW
      IF (.NOT. LTESTR .AND. NRECYR .GT. 1) THEN
         WRITE(24,*)
     *   'Number of original input atoms (minus removed ones) =',NATS
         WRITE(24,*)
     *   'Number of atoms fed into the last Fourier synthesis =',NATL
         WRITE(24,*)
     *   'Number of atoms (peaks) taken from last Fourier map =',NAT
         IF (NATEND .NE. NAT) WRITE(24,*)
     *   'Number of atoms  expected in the complete structure =',NATEND
         ENDIF
      IF (NATL .LT. NATS) NATL = NATS
      CRTEST = 0.0
      NDELM  = (NAT-3) / 2
      IF (NAT .LE. 4) NDELM = 0
      IF (NAT .GE. 10) NDELM = NAT / 3
      IF (NAT .GE. 20) NDELM = NAT / 4 + 1
      IF (NDELM .GT. 25 ) NDELM = 25
      NATFIX = 0
      IF (ICYCL .LE. 3 .AND. NATS .LE. 3) NATFIX = NATS
      IF (ICYCL .LE. 1) GOTO 105
      IF( NRECYS .GE. 3 ) NATFIX = 0
      IF( NRECYS .GE. 4 ) NDELM = NAT / 5
      IF( NRECYS .GE. 6 ) NDELM = NAT / 7
      IF( NRECYS .GE. 8 ) NDELM = NAT / 9
      IF( NRECYS .GE. 10) NDELM = NAT / 12
      IF (NDELM .GT. 25 ) NDELM = 25
      IF (NRECYS .GE. 12) NDELM = 0
  105 CONTINUE
      CALL WR24
      ISTART = MAX ( NATFIX + 1, NAT - 500)
      ISTORE = MAX ( 2, ISTART )
      ISTORM = ISTORE - 1
      GOTO 113
  109 CONTINUE
      CALL WR24
      WRITE (8, 100) 4
      CALL WILSIN (999)
      CALL ATIN7 (NSET)
      IF (NSET .LE. 0) GOTO 910
      IF (KEYT .EQ. 3) CALL KERROR
     *   (' No anisotr. allowed in AUTOR2 TEST runs', 100, 'AUTOFR')
      CALL FCALCI (ATXYZ, IZAT, ITAT, NAT)
  113 CONTINUE
      IF (LTESTR) THEN
         WRITE(24, 114) NSET
  114 FORMAT (//' ----------------------------------'/
     *          ' AUTOFR: test PATTY Atom Set Nr.', I3//)
         NDELM = 0
         KEYWIL = 0
         NN = MIN0 (3, NAT)
         CALL AT123P (' INPUT', ' ATOMS', 24,  ATNAME, ATXYZ, NN)
         ENDIF
      CALL WR24
      IF (LBINFC)
     *   CALL BINOFF (1, IBINFC,'BINFC', FITFC, NITFC, BUFFC, KENDFC)
      CALL RINI(RNUM,RDEN,RNM2XF,RDN2XF,RNM2EF,
     *          RNM2XZ,RDN2XZ,RNM2EZ,RDN2EZ,SR2NUM,SR2DEN,C1,C2,ICENT)
      DO 117 J = 1, MAXAT
      ATTOT(J) = 0.0
      ATFP4(J) = 0.0
  117 ATFPO(J) = 0.0
      IREFL = 0
      SUMFO2 = 0.
      SUMFP2 = 0.
      RNUM2C = 0.
      RDEN2C = 0.
      TERM2  = 0.
      TERM3  = 0.
      SUMFC2 = 0.
      SUMFO4 = 0.
      SUMFR4 = 0.
      SFPS2  = 0.
      SFPS4  = 0.
      SUME2 = 0.
      SUME1 = 0.
  200 CONTINUE
      IREFL = IREFL + 1
      HCODE = FBINX(1,IREFL)
      FOBS = FBINX(2,IREFL)
      IF (FOBS .LT. 0.) GOTO 220
      SIG = FBINX(3,IREFL)
      CALL HKLC1U (HCODE, HKLX)
      CALL HKLSTL (HKLX, STL, STL2)
      CALL FCALC7 (ATXYZ, ITAT, NAT, ETAO2)
      FP2F2R = FP**2 + (SUMF2(ISS) - SUMF2P(ISS)) * EXPBR(ISS)**2
      SUMFO2 = SUMFO2 + FOBS**2
      SUMFP2 = SUMFP2 + FP2F2R
      SUMFC2 = SUMFC2 + FP**2
      FOSC  = FOBS * SCALE
      SUMFR4 = SUMFR4 + (FP**2 - FOSC**2)**2
      SUMFO4 = SUMFO4 + FOSC**4
      CALL R2CALC (RNUM,RDEN,RNM2XF,RDN2XF,RNM2EF,RDN2EF,
     *             RNM2XZ,RDN2XZ,RNM2EZ,RDN2EZ,SR2NUM,SR2DEN,C1,C2)
      CALL WILSIN (0)
      FOSC   = FOBS * SCALE
      EOBS2  = ( FOSC * FOSC ) / ETAO2
      SUME2 = SUME2 + EOBS2
      SUME1 = SUME1 + ABS(EOBS2 - 1.)
      FPS2   = ( FP * FP ) / ETAO2
      IF (FPS2 .LT. 0.000001) FPS2 = 0.000001
      FPS4   = FPS2 * FPS2
      SFPS2  = SFPS2 + FPS2
      SFPS4  = SFPS4 + FPS4
      FAPM = FAP
      FBPM = FBP
      DO 205 I= 1, ISTORM
      FAPM = FAPM - ATXYZ(8,I)
      FBPM = FBPM - ATXYZ(9,I)
  205 CONTINUE
      FPM  = ASYMCL * SQRT(FAPM*FAPM+FBPM*FBPM)
      FPS2M  = ( FPM * FPM ) / ETAO2
      IF (FPS2M .LT. 0.000001) FPS2M = 0.000001
      FPS4M  = FPS2M * FPS2M
      ATFP4(ISTORM)=ATFP4(ISTORM) + FPS4M
      ATFPO(ISTORM)=ATFPO(ISTORM) - 2 * EOBS2 * FPS2M
      ATTOT(ISTORM)=ATTOT(ISTORM) + FPS4M - 2 * EOBS2 * FPS2M
      DO 210 I= ISTORE, NAT
      FAPM = FAP - ATXYZ(8,I)
      FBPM = FBP - ATXYZ(9,I)
      FPM  = ASYMCL * SQRT(FAPM*FAPM+FBPM*FBPM)
      FPS2M  = ( FPM * FPM ) / ETAO2
      IF (FPS2M .LT. 0.000001) FPS2M = 0.000001
      FPS4M  = FPS2M * FPS2M
      ATFP4(I)=ATFP4(I) + FPS4M
      ATFPO(I)=ATFPO(I) - 2 * EOBS2 * FPS2M
      ATTOT(I)=ATTOT(I) + FPS4M - 2 * EOBS2 * FPS2M
  210 CONTINUE
      TERM2  = TERM2 + FPS4
      TERM3  = TERM3  - 2 * EOBS2 * FPS2
      RNUM2C = RNUM2C + FPS4 - 2 * EOBS2 * FPS2
      RDEN2C = RDEN2C + EOBS2 * EOBS2
      FITFC(1) = FP
      FITFC(2) = PHIP
      IF (LBINFC)
     *   CALL BINOFF (0, IBINFC, 'BINFC', FITFC,  NITFC, BUFFC, KENDFC)
      GOTO 200
  220 CONTINUE
      CALL WR24
      IF (LBINFC)
     *   CALL BINOFF (-1, IBINFC, 'BINFC', FITFC,  NITFC, BUFFC, KENDFC)
      IF (NSET .EQ. 1) WRITE (8, 240) IREFL
  240 FORMAT (' Number of reflections read from file BINFO:', I5)
      SUME2 = SUME2 / FLOAT(NREFL)
      SUME1 = SUME1 / FLOAT(NREFL)
      SUME1X= 0.986
      IF (ICENT .EQ. 1) SUME1X= 0.736
      IF (NSET .LE. 1) WRITE(24, 1242) SUME2, SUME1, SUME1X
 1242 FORMAT (/' Statistics:  <E2> =', F6.3, '  <|E2-1|> =', F6.3/
     *         ' Expected  :  <E2> = 1.000  <|E2-1|> =', F6.3/)
      IF (SUME1 .LT. 0.65) WRITE(24, 1243)
 1243 FORMAT (' Beware of possible twinning !!!!!!!!!!!!!!!!!'/)
      CALL RPR (RNUM,RDEN,RNM2XF,RDN2XF,RNM2EF,RDN2EF,
     *        RNM2XZ,RDN2XZ,RNM2EZ,RDN2EZ,SR2NUM,SR2DEN)
      R2X = RNM2XZ
      CALL WR24
      WRITE (8, 100) 7
      CALL SCALE7
      CALL WR24
      CALL QFOMR2 (2, NSET, RNM2EZ, RNM2XZ, CHIN)
      CALL WR24
      WRITE (8, 100) 8
      R2X = RNM2XZ
      SC98 = SQRT (SUMFC2 / SUMFO2)
      R2FFFF = SUMFR4 / SUMFO4
      WRITE (8, 249) NRECYR, SCALE, SC98, R2FFFF
  249    FORMAT (' $TEX Ncy, SCALE, SC98(Fc/Fo), R2(F2):',
     * I2, 2F8.4, F6.3)
      IF( NDELM.EQ.0 ) GOTO 857
      IF( NAT .EQ. 1 ) GOTO 857
      WRITE (8, 100) 9
      TERM2  = TERM2  / RDEN2C
      EXPRC = 36. * FLOAT(IMULT) / SUMF2(2)
      AVCR = 0.
      NAVCR = 0
      SDCR = 0.
      DO 251 IR = ISTORM, NAT
      ATXYZ(8,IR) = SFPS4 - ATFP4(IR)
      ATXYZ(8,IR) = ATXYZ(8,IR) / RDEN2C
      IF ((ATXYZ(8,IR)) .LT. 0.000001) ATXYZ(8,IR) = 0.000001
      ATXYZ(9,IR) = TERM3 - ATFPO(IR)
      ATXYZ(9,IR) = ATXYZ(9,IR) / RDEN2C
      ATXYZ(10,IR) = ATXYZ(8,IR) + ATXYZ(9,IR)
      ATXYZ(10,IR) = RNUM2C - ATTOT(IR)
      ATXYZ(10,IR) = ATXYZ(10,IR) / RDEN2C
      CR = 10000.
      IF ((ATXYZ(8,IR)) .LT. 0.0000001) CALL KERROR
     *   (' R2-TERM2 too low: impossible??', 244, 'AUTOFR')
      CR = ATXYZ(10,IR) * 36. / ( IZAT(IR)**2 * ATXYZ(4,IR) )
      CR = CR / EXPRC
      ATXYZ(7,IR) = CR
      AVCR = AVCR + CR
      NAVCR= NAVCR + 1
  251 CONTINUE
      IF ( NAVCR .LE. 0 ) THEN
         WRITE(24, FMT='('' SET'', I3,
     *     '' : all atoms increase R2: wrong atom set?'')') NSET
         NAVCR = 1
         ENDIF
      AVCR = AVCR / FLOAT(NAVCR)
      DO 254 IR = ISTORM, NAT
      CR = ATXYZ(7,IR)
      IF ( IR.GT.ISTORM .OR. NATFIX.LE.1 ) THEN
      SDCR = SDCR + (AVCR - CR)**2
      ENDIF
  254 CONTINUE
      SDCR = SQRT ( SDCR / FLOAT(NAVCR) )
      IF (.NOT. LTESTR) WRITE(24, 1250) AVCR, SDCR, NAVCR
      WRITE (8, 1250) AVCR, SDCR, NAVCR
 1250 FORMAT (' Averaged relative contribution:', F6.3,
     *  ' s.d.:', F6.3 , ' for ', I4, ' terms')
      AVSD2 = AVCR + 2. * SDCR
      IF ( PSQ.LT.0.95 .AND. ICYCL.LE.2 ) THEN
         CRTEST = AMIN1( 0.25, AVSD2)
         IF (AVCR.GT.0.0) CRTEST = AMIN1( 0.75, AVSD2)
      ELSE
         CRTEST = AMIN1 (0.5, AVSD2)
         IF (NATRES.LE.2) THEN
            IF (NAT.GT.100) THEN
               SDADD = 0.
               DO 257 IL = NAT-30,NAT
               SDADD = SDADD + SDCR * 0.04
               ATXYZ(7,IL) = ATXYZ(7,IL) + SDADD
  257          CONTINUE
               ENDIF
            ENDIF
         ENDIF
      AVSD1 = AVCR + SDCR
      BADR2 = R2X - RNM2EZ
      IF (R2X .GT. 0.2 .AND. BADR2 .GT. 0.09999)
     *   AVSD1 = AVCR + SDCR * 0.1 / BADR2
      CRTES1 = CRTEST
      IF (BADR2 .GT. 0.1) CRTES1 = AMIN1 (CRTEST, AVSD1)
      CRTEST = AMAX1( CRTEST, AVCR + 0.001)
      IF( CRTEST .LT. -0.5 ) CRTEST = -0.5
      IF (PSQ .GT. 0.90) CRTEST = AMAX1 (CRTEST, 0.5 * PSQ)
      IF (CRTEST .LT. AVCR) CRTEST = AVCR
      IF (.NOT. LTESTR) WRITE (8, 259) CRTES1, CRTEST
  259 FORMAT (' Acceptance criterion for R2-rejection =', F7.3, ' ???'/
     *        ' Acceptance criterion ( heavy atoms !) =', F7.3, ' ???'/
     1        ' Expected relative contribution to R2  = -1.000')
      NDELMC = 0
      DO 263 IR = ISTORM, NAT
      CR = ATXYZ(7,IR)
      IF (LTESTR) THEN
         WRITE(8,261) NSET, IR,
     *      ATNAME(IR),ATXYZ(8,IR),ATXYZ(9,IR),ATXYZ(10,IR), CR
  261 FORMAT(' Set', I3,' Atom', I3, 1X, A6, ' contr. to R2 =', F6.5,
     *      F7.5, ' =', F7.5, ' Rel:', F7.3 )
      ELSE
         IF ((CR .GT. CRTEST .AND. IZAT(IR) .GT. 13) .OR.
     *       (CR .GT. CRTES1 .AND. IZAT(IR) .LE. 13))  THEN
            NDELMC = NDELMC + 1
            IF (NDELM .EQ. 0) WRITE(24,262) IR, ATNAME(IR), CR
            IF (NDELM .NE. 0) WRITE(8,262) IR, ATNAME(IR), CR
  262 FORMAT(' Atom', I3,1X, A6, ' Relative contribution to R2 =', F6.4)
            ENDIF
         ENDIF
  263 CONTINUE
      CALL WR24
      WRITE (8, 100) 10
      NDELM7 =  NDELM
      IF( NAT .GE. 10 .AND. ICYCL .LE. 7 )
     *   NDELM = MAX0( NDELM, INT( FLOAT(NAT)*(RNM2XZ-RNM2EZ)/(PSQ*2.)))
      WRITE (8, FMT='('' $TE NDELM .1. NDELM7 '', 2I3)') NDELM, NDELM7
      IF( NAT .GE. 20 .AND. ICYCL .LE. 7 .AND. PSQ .GT. 0.8)
     *   NDELM = MAX0( NDELM, INT( FLOAT(NAT)*(RNM2XZ-RNM2EZ)/(PSQ)))
      WRITE (8, FMT='('' $TE NDELM .2. NDELM7 '', 2I3)') NDELM, NDELM7
      NDELM = MIN0 (NDELM, NAT*2/3)
      WRITE (8, FMT='('' $TE NDELM .3. NDELM7 '', 2I3)') NDELM, NDELM7
      IF (FLOAT(NDELM)/FLOAT(NAT).LT.0.01*FLOAT(ICYCL-3)) NDELM = 0
      WRITE (8, FMT='('' $TE NDELM .4. NDELM7 '', 2I3)') NDELM, NDELM7
      NDELM = MIN0 ( NDELM, NDELMC )
      WRITE (8, FMT='('' $TE NDELM .!. NDELMC '', 2I3)') NDELM, NDELMC
      IF (NDELM .LT. 0) NDELM = 0
      WRITE (8, FMT='('' $TE NDELM .6. NDELM7 '', 2I3)') NDELM, NDELM7
      IF (NDELM7 .LE. 0 ) THEN
         NDELM = NDELM7
      ELSEIF (NDELM .GE. NDELM7) THEN
         NDELM = NDELM7
      ELSE
         NDELM = (NDELM7 + NDELM) / 2
         ENDIF
      WRITE (8, FMT='('' $TE NDELM Ncy > NDELM '', 2I3)') NRECYR, NDELM
      NDEL =0
      IF (NORECY) THEN
         WRITE (8, FMT='(A)')
     *      ' No rejections if NORECY is given in automatic mode'
         GOTO 857
         ENDIF
      IF (LTESTR) GOTO 857
      IF( NDELM.EQ.0 ) THEN
         WRITE(24,*) 'atom check finished: All input atoms accepted!'
         GOTO 857
         ENDIF
      CALL WR24
      WRITE (8, 100) 11
      IZAV = 0
      Z2TOT = 0.
      DO 267 I = 1, NAT
      Z2TOT = Z2TOT + FLOAT(IZAT(I))**2
  267 IZAV = IZAV + IZAT(I)
      IZ2TOT = NINT (Z2TOT * 0.90)
      ZAV = FLOAT(IZAV) / FLOAT(NAT)
      DO 277 ID = 1, NDELM
      CRMAX = -100.0
      IAD   =  0
      DO 273 IS = ISTART, NAT
      IF ( ATXYZ(8,IS). LT . 0.000001 ) GOTO 273
      IF ( ATXYZ(7,IS) .GT. CRMAX) THEN
         CRMAXT = ATXYZ(7,IS)
         FZAF = SQRT (FLOAT(IZAT(IS)) / ZAV)
         IF (CRMAXT .GT. 0. .AND. FZAF .GT. 1.2) CRMAXT = CRMAXT / FZAF
         IF (CRMAXT .LT. CRMAX) GOTO 273
         CRMAX = CRMAXT
         IAD = IS
         ENDIF
  273 CONTINUE
      IF (CRMAX .LT. CRTEST) GOTO 309
      IF(IAD.EQ.0) GOTO 309
      IZ2TOT = IZ2TOT - IZAT(IAD)**2
      IF (IZ2TOT .LT. 0) GOTO 309
      NDEL = NDEL + 1
      KEYS(2) = NDEL
      WRITE(24,275) IAD, ATNAME(IAD), CRMAX
  275 FORMAT(' Atom', I4, ' = ' , A6,
     1 ' is deleted! (Rel. contribution to R2 =', F7.4, ')')
      TERM2  = TERM2  - ATXYZ(8,IAD)
      TERM3  = TERM3  - ATXYZ(9,IAD) * RDEN2C
      ATXYZ(8,IAD)  = 0.0
      ATXYZ(9,IAD)  = 0.0
      ATXYZ(10,IAD) = -999.
      ISMAX = IFIX (STLMAX * 400. +0.0001) + 2
      ITY = ITAT(IAD)
      DO 276 IS=1,ISMAX
  276 SUMF2P(IS) = SUMF2P(IS) - FF(IS,ITY) * FF(IS,ITY) * ICENT * NSYMM
      PSQ = SUMF2P(2)/SUMF2(2)
  277 CONTINUE
  309 CONTINUE
      IF( NDEL.LE.0 ) THEN
         CALL WR24
         WRITE(24,*) ' atom check finished: All input atoms accepted!'
         GOTO 801
         ENDIF
      CALL WR24
      WRITE (8, 100) 12
      KEYS(2) = NDEL
      WRITE(24, 333) NDEL
  333 FORMAT (' Nr of atoms deleted because of R2: ', I4)
      NATSN = 0
      IF (NATFIX.EQ.0) THEN
         DO 388 IR = 1 ,NATS
  388    IF (ATXYZ(10,IR).LT.-998.) NATSN = NATSN + 1
         ENDIF
      NSC   = NAT
      ISC   = 1
  390 IF (ATXYZ(10,ISC).LT.-998.) THEN
         NSC = NSC - 1
         DO 395 IS2 = ISC, NSC
         ATNAME(IS2) = ATNAME(IS2 + 1)
         IZAT(IS2)   = IZAT(IS2 + 1)
         ITAT(IS2)   = ITAT(IS2 + 1)
         DO 392 NE  = 1, 10
         ATXYZ(NE,IS2) = ATXYZ(NE, IS2 + 1)
  392    CONTINUE
  395    CONTINUE
      ELSE
         ISC = ISC + 1
         ENDIF
      IF ( ISC .LE. (NAT-NDEL) ) GOTO 390
      NAT = NAT - NDEL
      IF (NATSN .GT. 0) THEN
            WRITE(24, 397) NATS, NATSN
  397    FORMAT(' Of the',I4,' original input atoms,',I3,' are deleted')
         NATS = NATS - NATSN
         WRITE (CHOUT,FMT='(''RUN '',I3,'' NEW   NAT= '',I4,
     *       '' KPROG '', I3)') IRUN, NATS, KPROG
         CALL LOGWR (IDDL)
         CALL FILCLO (IDDL, 'KEEP')
         ENDIF
      CALL FCALII
      DO 475 I = 1, NAT
      ATXYZ(8,I)  = -0.000001
      ATXYZ(9,I)  = 0.0
      ATXYZ(10,I) = 0.0
  475 CONTINUE
      CALL WR24
      WRITE (8, 100) 13
      CALL FCALC (NSET, 1)
      IF (NRECYS .LT. 9) RETURN
      KEYD = 3
      CALL WR24
      WRITE (8, 100) 14
      WRITE(24, FMT='(//'' EXIT via AUTOFR ? 13579''//)')
      CALL FILINQ (ICOND, 'CONDA', 'FORMATTED', 'OUTPUT', KINQ)
      CALL FILINQ (IDDS, 'DDSYST', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (ICOND,
     *   FMT = '(''CONDA  '', A6, '' generated by AUTOFR'' )') CCODE
      WRITE (ICOND, FMT = '(''PROGRAM  FOUR'')')
      WRITE (ICOND, FMT = '(''PROGRAM DDMAIN ''/''OPTION 0 FCALC'')')
      WRITE (ICOND, FMT = '(''PROGRAM  NUTS AT2X'')')
      WRITE (ICOND, FMT = '(''FINISH'')')
      WRITE (IDDS, FMT = '(''FOUR'' /''DDMAIN'' /''NUTS'' /''STOP'')')
      CALL FILCLO (ICOND, 'KEEP')
      CALL FILCLO (IDDS, 'KEEP')
      CALL COPY80 (ICOND, ' CONDA' , 9, ' ATPTB' )
      CALL FILCLO (ICOND, 'KEEP')
      CALL FILCLO (9, 'KEEP')
      CALL WR24
      RETURN
  801 CONTINUE
      WRITE (8, 100) 15
  857 CONTINUE
      WRITE (8, 100) 16
      IF (LTESTR) THEN
         WRITE(24, FMT='(/ '' R2 results:''/
     *      '' Set No.  Nr.atoms  p**2  expected R2  actual R2'')')
         WRITE(24, 1254) NSET, NAT, PSQ, RNM2EZ, RNM2XZ
 1254    FORMAT (I7, I8, F9.3, F13.3, F11.3)
      CALL WR24
         IF (RNM2XZ .LT. R2MIN) THEN
            R2MIN = RNM2XZ
            NSETM2 = NSETM
            NSETM = NSET
            ENDIF
         GOTO 109
         ENDIF
      CALL WR24
      WRITE(24,*) 'autofr finished!'
      RETURN
  910 CONTINUE
  911 FORMAT(//' ========================================',
     *        /' AUTOFR tests finished for all atom sets '
     *        /' ========================================'/)
      WRITE(24, 911)
      CALL WR24
      IF (R2MIN .LT. 998.) THEN
         WRITE (9, 1255) R2MIN, NSETM
 1255    FORMAT(' Note: Lowest value of R2 =',F6.3,' for set nr.', I3)
      CALL WR24
         FSETM = NSETM
         FSETM2 = NSETM2
         CALL QFOMR2 (-1, 0, FSETM, FSETM2, CHIN)
         ENDIF
      CALL WR24
      RETURN
      END
      SUBROUTINE FCALC7 (ATXYZ, ITAT, NAT7, ETAO2)
      DIMENSION ATXYZ(10,NAT7), ITAT(NAT7)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      DIMENSION FFF(10), ADTRIG(24)
      DATA  FFF, ADTRIG / 34*0.0 /
      S = STL * 400. + 1.
      IS = IFIX(S)
      STLDEL = S - FLOAT(IS)
      ISS = NINT(S)
      DO 110 J=1,NTYPE
      IF (CELPAR(J).LE.0.0) GOTO 110
      FFF(J) = FF(IS,J) + (FF(IS+1,J)-FF(IS,J)) * STLDEL
  110 CONTINUE
      TBPOV = EXPBP (ISS)
      CALL HKLEX1 (HKLX, HKLX)
      IF (NSYMM.EQ.1) GOTO 150
      DO 140 J=2,NSYMM
      IF (ITRS(J).EQ.0) GOTO 140
      ADTRIG(J) = HKLX(1,1)*TSYMM(1,J) + HKLX(2,1)*TSYMM(2,J) +
     *            HKLX(3,1)*TSYMM(3,J)
  140 CONTINUE
  150 FAP = 0.0
      FBP = 0.0
      DO 250 I=1,NAT
      A1 = 0.
      B2 = 0.
      DO 200 J=1,NSYMM
      TRIG = HKLX(1,J)*ATXYZ(1,I) + HKLX(2,J)*ATXYZ(2,I) +
     *       HKLX(3,J)*ATXYZ(3,I) + ADTRIG(J)
      IF (TRIG.LT.0.0) TRIG = TRIG - 0.00010
      ITRIG = MOD ( IFIX(TRIG * 10000. + 0.5), 10000)
      IF (ITRIG.LE.0) ITRIG = ITRIG + 10000
      A1 = A1 + SICO(ITRIG + 2500)
      IF (ICENT.NE.2) B2 = B2 + SICO(ITRIG)
  200 CONTINUE
      IF (KEYT .EQ. 1) THEN
         TF = ATXYZ(4,I) * TBPOV
      ELSE
         TF = ATXYZ(4,I) * EXP (-STL2*ATXYZ(5,I))
         ENDIF
      IJ = ITAT(I)
      ATXYZ(8,I) = A1 * FFF(IJ) * TF
      FAP = FAP + ATXYZ(8,I)
      IF (ICENT.EQ.2) GOTO 250
      ATXYZ(9,I) = B2 * FFF(IJ) * TF
      FBP = FBP + ATXYZ(9,I)
  250 CONTINUE
      ETAO2 = SUMF2P(ISS) * EXPBP(ISS) * EXPBP(ISS) +
     *      ( SUMF2(ISS) - SUMF2P(ISS) ) * EXPBR(ISS) * EXPBR(ISS)
      FP = ASYMCL * SQRT (FAP*FAP + FBP*FBP)
      PHIP = 0.0
      IF (FP.GT.0.001) PHIP = ATAN2(FBP,FAP) / 0.0174532925
      IF (PHIP.LT.0.0) PHIP = PHIP + 360.
      RETURN
      END
      SUBROUTINE RINI (RNUM,RDEN,RNM2XF,RDN2XF,RNM2EF,
     * RNM2XZ,RDN2XZ,RNM2EZ,RDN2EZ,SR2NUM,SR2DEN,C1,C2,ICENT)
      IF (ICENT.EQ.1) THEN
         C1 = 4
         C2 = 2
      ELSE
         C1 = 6
         C2 = 3
         ENDIF
      RNUM  = 0.
      RDEN  = 0.
      RNM2XF= 0.
      RDN2XF= 0.
      RNM2EF= 0.
      RNM2XZ= 0.
      RDN2XZ= 0.
      RNM2EZ= 0.
      RDN2EZ= 0.
      SR2NUM= 0.
      SR2DEN= 0.
      RETURN
      END
      SUBROUTINE R2CALC (RNUM,RDEN,RNM2XF,RDN2XF,RNM2EF,RDN2EF,
     * RNM2XZ,RDN2XZ,RNM2EZ,RDN2EZ,SR2NUM,SR2DEN,C1,C2)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      LOGICAL SWRECY, EXPAND
      EQUIVALENCE (SWRECY, SWITCH(7)), (EXPAND, SWITCH(23))
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zddif.inc'
      INCLUDE 'Zbuff.inc'
      EQUIVALENCE (IBINFC, IFILE(12))
      FOSC  = FOBS * SCALE
      FDEL  = ABS (FOSC-FP)
      RNUM  = RNUM  + FDEL
      RDEN  = RDEN  + FOSC
      ETAC2 = SUMF2P(ISS) * EXPBP(ISS)**2
      ETAO2 = ETAC2 + (SUMF2(ISS) - SUMF2P(ISS)) * EXPBR(ISS)**2
      ETA2  = ETAC2 / ETAO2
      EOBS2 = FOSC **2 / ETAO2
      EOBS4 = EOBS2 **2
      ETAEP2 = FP**2 / ETAO2
      EP = FP / ETAC2 **0.5
      RNM2XF = RNM2XF + (EOBS2 - ETAEP2)**2
      RDN2XF = RDN2XF +  EOBS4
      ETA4   = ETA2 * ETA2
      ETA8   = ETA4 * ETA4
      ETA2M4 = ETA2 - ETA4
      RNM2EF = RNM2EF + EOBS4 * (ETA8 - 2*ETA4 + 1) +
     *                  EOBS2 * (C1 * ETA4 - 2) * ETA2M4 +
     *                  C2    * ETA2M4**2
      RDN2EF = RDN2XF
      ETA2  = SUMF2P(2) / SUMF2(2)
      RNM2XZ = RNM2XZ + (EOBS2 - ETA2 * EP**2)**2
      RDN2XZ = RDN2XZ +  EOBS4
      ETA4   = ETA2 * ETA2
      ETA8   = ETA4 * ETA4
      ETA2M4 = ETA2-ETA4
      RNM2EZ = RNM2EZ + EOBS4 * (ETA8 - 2*ETA4 + 1) +
     *                  EOBS2 * (C1 * ETA4 - 2) * ETA2M4 +
     *                  C2    * ETA2M4**2
      RDN2EZ = RDN2XF
      EOBS6  = EOBS2 * EOBS4
      ETA6   = ETA2 * ETA4
      ETA10  = ETA2 * ETA8
      ETA12  = ETA4 * ETA8
      ETA14  = ETA2 * ETA12
      IF(ICENT.EQ.1) THEN
         SR2NUM = SR2NUM +
     *   EOBS6    *  (  8  * ETA14 -  16 * ETA10 +  8 * ETA6 ) *
     *                  ( 1 - ETA2 )    +
     *   EOBS4    *  (  52 * ETA12 -  48 * ETA8  +  4 * ETA4 ) *
     *                  ( 1 - ETA2 )**2 +
     *   EOBS2    *  (  80 * ETA10 -  16 * ETA6 )              *
     *                  ( 1 - ETA2 )**3 +
     *   20 * ETA8 *    ( 1 - ETA2 )**4
      ELSE
         SR2NUM = SR2NUM +
     *   EOBS6    *  ( 16  * ETA14 -  32 * ETA10 + 16 * ETA6 ) *
     *                  ( 1 - ETA2 )    +
     *   EOBS4    *  ( 168 * ETA12 - 144 * ETA8  +  8 * ETA4 ) *
     *                  ( 1 - ETA2 )**2 +
     *   EOBS2    *  ( 384 * ETA10 -  48 * ETA6 )              *
     *                  ( 1 - ETA2 )**3 +
     *   96 * ETA8 *    ( 1 - ETA2 )**4
         ENDIF
      SR2DEN = SR2DEN + EOBS4
      RETURN
      END
      SUBROUTINE RPR(RNUM,RDEN,RNM2XF,RDN2XF,RNM2EF,RDN2EF,
     *           RNM2XZ,RDN2XZ,RNM2EZ,RDN2EZ,SR2NUM,SR2DEN)
      INCLUDE 'Zaaaa.inc'
      EQUIVALENCE (IDDL, IFILE(1))
      EQUIVALENCE (IRUN, KSTAT(13))
      EQUIVALENCE (KEYD, KSTAT(19))
      LOGICAL LTESTR
      EQUIVALENCE (LTESTR, SWITCH(27))
      RNUM   = RNUM   / RDEN
      RNM2XF = RNM2XF / RDN2XF
      RNM2XZ = RNM2XZ / RDN2XZ
      RNM2EF = RNM2EF / RDN2EF
      RNM2EZ = RNM2EZ / RDN2EZ
      RNM2EF = RNM2EF**2 + (1.0 - RNM2EF) * SQRT(RNM2EF**2 + 0.0025)
      RNM2EZ = RNM2EZ**2 + (1.0 - RNM2EZ) * SQRT(RNM2EZ**2 + 0.0025)
      IF ( SR2NUM .LT. 0.0 ) SR2NUM = 0.0
      SR2NUM = SR2NUM**0.5
      SR2NUM = SR2NUM / SR2DEN
      R2EX = RNM2EZ
      R1X = RNUM
      IF (LTESTR) RETURN
      CALL WR24
      IF (PSQ .GT. .5) WRITE(24, 251) RNUM
      IF (KEYD .EQ. 0) WRITE (9, 251) RNUM
  251 FORMAT (12X, 'Conventional R-factor =', F7.3)
      CALL WR24
      WRITE (8, 250) RNM2XF,RNM2EF,RNM2XZ,RNM2EZ, RNM2XZ
  250 FORMAT (' R2 (fj) =', F6.3, ' (est.:', F5.3,
     *  ')  R2 (Zj) =', F6.3, ' (est.:', F5.3, ') =====>', F6.3,/)
      WRITE (CHOUT, FMT='('' cycle'', I3)') NRECYR
      IF (KEYS(2) .GT. 0) THEN
         WRITE (CHOUT(24:59), 255) KEYS(2), RNM2EZ
  255    FORMAT ( '-', I3, 14X, F6.3)
      ELSE
         WRITE (CHOUT(13:45), 256) NAT, RNM2EZ
  256    FORMAT ('atoms', I4, 11X, 'R2E=', F6.3)
         ENDIF
      WRITE (CHOUT(51:64), 257) RNM2XZ
  257 FORMAT ('==>  R2=', F6.3)
      KEYS(2) = 0
      IF ( RNM2XZ .LT. 0.0495 ) CHOUT(30:49) = ' '
      WRITE (9, FMT='(A)') CHOUT
      CALL WR24
      IF (NRECYR .EQ. 1) WRITE (8, FMT='('' '')')
      WRITE (8, 301) CCODE, IRUN, NRECYR, NAT, RNUM, RNM2EZ, RNM2XZ
  301 FORMAT (A6,' IRUN',I4, ' Ncy', I3,
     *   ' NAT',I4,' R',F6.3,' R2E',F6.3,' R2',F6.3)
      RETURN
      END
      SUBROUTINE SCASTA
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zbinx.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zddif.inc'
      INCLUDE 'Zbuff.inc'
      EQUIVALENCE (IBINFC, IFILE(12))
      EQUIVALENCE (IDDL, IFILE(1))
      EQUIVALENCE (KEYWIL, KSTAT(17))
      DIMENSION AVAL(100),BVAL(100),CVAL(200),
     * SCERR(21),IPGO(9,21,3),PGO1(9,21,3),PGO2(9,21,3),FPGOS(2,9,3),
     * FBEX(3),PGOS1(2,9,3),PGOS2(2,9,3),IREFST(2,9,3),SCTAB(2,9,3),
     * RSCTL(2,9,3),RSCNM(2,9,3),RSC(2,9,3),E2SUMT(2,9,3),BPVAR(10,3),
     * BRVAR(10,3),E2FOM(2,9,3)
      EQUIVALENCE (AVAL(1),CVAL(1)), (BVAL(1),CVAL(101))
      LOGICAL   SCOK1, SCOK2, WCHOSE
      PARAMETER (DELTAB = 0.05, DELTAS = 0.02, RAD = 57.29578)
      PARAMETER (BOVVAR = 0.2)
      DATA AVAL /
     * 0.05607, 0.05316, 0.10737, 0.43949, 0.38354, 0.94552, 0.78177,
     * 1.77778,-0.62897, 0.52696, 0.26794, 0.64104,-1.23707, 0.66410,
     * 0.17746, 0.48249,-0.40477,-0.20574, 1.01686,-1.02381,-0.49083,
     *-0.99899,-0.10605, 1.22243,-0.79348,-0.50365, 0.05771, 0.11873,
     *-0.38572,-0.48818, 0.51336,-1.72440, 0.29756, 0.62057,-1.10752,
     *-0.72877, 0.91284,-0.28598,-1.39700,-0.02802,-0.98413,-0.29812,
     * 0.14420,-0.03831, 0.77742,-0.97348, 0.24064, 0.88360,-0.00087,
     * 0.94690,-0.76506, 0.21406, 0.55916, 0.60612, 0.73216,-0.60812,
     *-0.68421, 0.26031,-0.51343,-0.56541,-0.59166, 0.13868, 1.21770,
     *-0.61774, 0.74481,-0.29790,-0.54401,-0.14904, 0.24532,-0.07146,
     *-1.18466,-0.11162, 0.01974, 0.40478,-0.11380, 0.18916,-0.65419,
     * 0.16521,-0.35749, 0.44576, 1.40299,-0.74702,-0.64231, 0.42047,
     * 0.10152,-0.42354,-0.98954,-0.03869,-0.02689,-0.32888,-0.49380,
     * 0.37292,-0.93195, 0.76896, 0.12626, 0.35347,-0.72071, 0.33275,
     *-0.34783, 0.03697 /
      DATA BVAL /
     *-0.03907,-1.75002,-0.06408, 1.12202,-0.24004,-0.66600,-0.11809,
     *-1.40804,-1.42002,-0.24606,-0.88801, 0.52319,-0.64014, 0.34116,
     * 0.29016,-0.28116,-0.14612, 0.24712, 0.47915,-0.28316,-0.48419,
     *-1.24918,-0.84426, 1.10029, 1.17727, 0.76122, 0.86424, 0.25520,
     * 0.52625,-0.99430, 0.06231,-0.58133, 0.29139, 1.01030,-0.79730,
     * 0.23834, 0.25831, 2.00439, 0.59242,-0.90149, 0.09043, 0.54341,
     * 0.45847, 0.93748,-0.03748,-0.07542, 0.47249, 0.61343,-0.26141,
     * 1.63743,-0.34850,-0.11253,-0.23654, 0.30458, 0.07050,-0.16750,
     *-1.13557,-0.26351, 0.87757,-0.58550, 0.24956,-0.64854, 0.24951,
     *-1.58359,-0.79956, 1.46555, 0.04664,-0.41467, 0.42766,-0.56565,
     *-0.86260,-0.74867, 0.30365, 0.22761, 0.68965,-0.06278, 0.70473,
     * 0.68972, 0.00874, 0.23871, 0.33476,-1.04381,-0.61488, 1.28188,
     * 1.22180, 1.09083,-0.28580,-0.59186,-1.14085, 0.73180, 0.87385,
     * 0.14382,-0.85487,-1.05181,-0.18495, 0.15194,-0.04698,-0.81092,
     *-0.98992, 0.16298 /
      DATA SCMIN1, BPMIN1, BRMIN1 / 0., 0., 0. /
      DATA SCMIN2, BPMIN2, BRMIN2 / 0., 0., 0. /
      DATA SCMIN3, BPMIN3, BRMIN3 / 0., 0., 0. /
      CALL WR24
      IF (KEYWIL .EQ. 4) RETURN
      FKEYP2 = PSQ / SQRT(FLOAT(NAT))
      FCRIT=0.23
      PSQCRT=0.3
      IF (FKEYP2 .LT. FCRIT .OR. PSQ .LT. PSQCRT) THEN
         WRITE (8, 55)
  55     FORMAT(' Known fragment is small: Smykalla-refinement',
     *         ' is not executed!')
         WRITE (8, 56) PSQ, FKEYP2
  56        FORMAT(' TEMP: p**2 and FPKEY2 are ',F5.2,' and ',F5.2)
         RETURN
         ENDIF
      EGRENS=AMAX1(PSQ,0.5)
      WCHOSE=.TRUE.
      IUNOBS=0
      IREF=0
      ITAB1=0
      ITAB2=0
      ITAB3=0
      SQ2=SQRT(2.)
      ZRTMP=0.
      ZRTMPX=0.
      ZPTMPX=0.
      BRX=0.
      BPX=0.
      YX=0.
      BOV = BOVMER
      DO 100 ISC=1,21
  100   SCERR(ISC)=SCAMER*(1.+FLOAT(ISC-11)*DELTAS)
      CALL KERNZI (0, IPGO,567)
      CALL KERNZA (0.,FPGOS,54)
      CALL KERNZI (0, IREFST,54)
      CALL KERNZA (0.,PGO1,567)
      CALL KERNZA (0.,PGO2,567)
      CALL KERNZA (0.,PGOS1,54)
      CALL KERNZA (0.,PGOS2,54)
      CALL KERNZA (0.,BRVAR,30)
      CALL KERNZA (0.,BPVAR,30)
      CALL BINIFF (1, IBINFC, 'BINFC',  FITFC,  NITFC, BUFFC,KENDFC)
      BPINP=BP
      IEXS=1
      EXVAR1=0.
      EXVAR2=0.
      E2AVE=0.
      RSCAVE=0.
      E2SDIF=0.
      RSCDIF=0.
      IAVE=0
      IREFX = 0
  130 CONTINUE
      IREFX = IREFX + 1
      HCODE = FBINX(1,IREFX)
      FOBS = FBINX(2,IREFX)
      IF (FOBS .LT. 0.) GOTO 210
      SIG = FBINX(3,IREFX)
      CALL BINIFF (0, IBINFC, 'BINFC',  FITFC,  NITFC, BUFFC,KENDFC)
      IF (KENDFC.LT.0) CALL KERROR ('BINFC cut-off ?', 0, 'SCASTA')
      FP = FITFC(1)
      PHIP = FITFC(2)
      IF (FP .LT. -990.) GOTO 130
      JCODE=1
      IF (FOBS.LT.5.*SIG) JCODE=2
      CALL HKLC1U (HCODE, HKLX)
      CALL HKLSTL (HKLX, STL, STL2)
      ISS = IFIX (STL*400. + 1.5)
      CALL HKLEX1 (HKLX, HKLX)
      CALL HKLEX2 (HKLX, IDHKL, IEPS, IEPS2)
      EPSIL = IEPS
      SUMF2R=SUMF2(ISS)-SUMF2P(ISS)
      ZTMP = SQRT (SUMF2(ISS) * EPSIL * ALATT) * EXP(-BOV*STL2)
      ZPTMP= SQRT (SUMF2P(ISS) * EPSIL * ALATT) * EXP(-BOV*STL2)
      ZRTMP= SQRT (SUMF2R * EPSIL * ALATT) * EXP(-BOV*STL2)
      YBOV = FP * EXP((-BOV+BPINP)*STL2)
      Y    = FP * EXP((-BP+BPINP)*STL2)
      IF (ABS(Y) .LT. 0.0001) GOTO 130
      IF (ICENT.EQ.1) THEN
        IF (ITAB1.EQ.100) ITAB2=ITAB2+1
        ITAB1 = MOD(ITAB1,100)+1
        ITAB2 = MOD(ITAB2,100)+1
        ER = SQRT(AVAL(ITAB1)**2+BVAL(ITAB2)**2)
        PHIR = ATAN2(BVAL(ITAB2),AVAL(ITAB1))
      ELSE
        ITAB3= MOD(ITAB3,200)+1
        ER = 0.
        PHIR = 0.
      ENDIF
      EOB = (SCALE * FOBS) / ZTMP
      IF (EOB.GT.EGRENS) THEN
         IF (JCODE.EQ.2) IUNOBS = IUNOBS+1
         IREF=IREF+1
         ENDIF
      FBEX(1)=-1*BOVVAR
      FBEX(2)=0.
      FBEX(3)=BOVVAR
      IF (BOV.LT.BOVVAR*2) THEN
        FBEX(1)=AMIN1(BOV,BOVVAR)-BOV
        IF (ABS(FBEX(1)).LT.0.00001) IEXS=2
      ENDIF
      IF (BOV.GT.BOVVAR*10) THEN
        FBEX(1)=-0.1*BOV
        FBEX(3)=0.1*BOV
      ENDIF
      DO 140 IB=1,10
      DO 140 IEX=IEXS,3
      BOVCOR=EXP(-1*FBEX(IEX)*STL2)
      IF ((IB.EQ.10.AND.IEX.EQ.1).OR.(IB.EQ.10.AND.IEX.EQ.2)) GOTO 140
      IF (IB.LT.10) THEN
      IF (PSQ.GT.0.5) THEN
        BRVAR(IB,IEX) = (BOV+FBEX(IEX))*(FLOAT(IB-5)*DELTAB)
        BPVAR(IB,IEX) = (BRVAR(IB,IEX) * (PSQ-1))/PSQ
      ELSE
        BPVAR(IB,IEX) = (BOV+FBEX(IEX)) * (FLOAT(IB-5)*DELTAB)
        BRVAR(IB,IEX) = (BPVAR(IB,IEX)*PSQ)/(PSQ-1)
      ENDIF
        EXVAR1 = EXP(-BRVAR(IB,IEX)*STL2)
        EXVAR2 = EXP(-BPVAR(IB,IEX)*STL2)
      ENDIF
        IF (IB.EQ.10) THEN
          ZRTMPX= SQRT (SUMF2R * EPSIL * ALATT) * EXP(-BR*STL2)
          ZPTMPX= SQRT (SUMF2P(ISS) * EPSIL * ALATT) * EXP(-BP*STL2)
          YX=Y
        ELSE
          ZRTMPX = ZRTMP * EXVAR1 * BOVCOR
          ZPTMPX = ZPTMP * EXVAR2 * BOVCOR
          YX = YBOV * EXVAR2 * BOVCOR
        ENDIF
        FPX=0.
        IF (ICENT.EQ.1) THEN
          FPX= YX * COS(PHIP/RAD)
          FRSTAT=ER*ZRTMPX
          XO= FPX+(FRSTAT*COS(PHIR))
          YO= (YX*SIN(PHIP/RAD))+(FRSTAT*SIN(PHIR))
          FO= SQRT((XO**2)+(YO**2))
        ELSE
          FRX= CVAL(ITAB3)*ZRTMPX*SQ2
          FO= ABS(YX+FRX)
        ENDIF
        EO= FO/SQRT(ZPTMPX**2+ZRTMPX**2)
        IF (IB.LT.10) THEN
        DO 135 IEO=0,1
         EGR=EGRENS+(IEO*0.1)
         JEO=IEO+1
         IF (EO.GT.EGR) THEN
         IREFST(JEO,IB,IEX) = IREFST(JEO,IB,IEX)+1
         IF (ABS(YX).GT.FO) FPGOS(JEO,IB,IEX)=FPGOS(JEO,IB,IEX)+1.
           IF (WCHOSE) THEN
             PGOS1(JEO,IB,IEX)=PGOS1(JEO,IB,IEX)+
     *                           ((ABS(YX)-FO)/SQRT(SUMF2(ISS)))
             PGOS2(JEO,IB,IEX)=PGOS2(JEO,IB,IEX)+
     *                           (ABS(YX)/SQRT(SUMF2(ISS)))
           ELSE
             PGOS1(JEO,IB,IEX)=PGOS1(JEO,IB,IEX)+(ABS(YX)-FO)
             PGOS2(JEO,IB,IEX)=PGOS2(JEO,IB,IEX)+ABS(YX)
           ENDIF
         ENDIF
  135  CONTINUE
       ENDIF
       IF (IB.LT.10) THEN
       IF (EOB.GT.EGRENS) THEN
         DO 150 ISC=1,21
         FSC = FOBS * SCERR(ISC)
           IF (ABS(YX).GT.FSC) IPGO(IB,ISC,IEX)=IPGO(IB,ISC,IEX)+1
           IF (WCHOSE) THEN
             PGO1(IB,ISC,IEX)=PGO1(IB,ISC,IEX)+
     *                     ((ABS(YX)-FSC)/SQRT(SUMF2(ISS)))
             PGO2(IB,ISC,IEX)=PGO2(IB,ISC,IEX)+
     *                     (ABS(YX)/SQRT(SUMF2(ISS)))
           ELSE
             PGO1(IB,ISC,IEX)=PGO1(IB,ISC,IEX)+(ABS(YX)-FSC)
             PGO2(IB,ISC,IEX)=PGO2(IB,ISC,IEX)+ABS(YX)
           ENDIF
  150   CONTINUE
      ENDIF
      ENDIF
  140 CONTINUE
      GOTO 130
  210 DO 215 IB=1,9
      DO 215 IEX=IEXS,3
      FRFDIF=FLOAT(ABS(IREFST(1,IB,IEX)-IREFST(2,IB,IEX)))
      IF(FRFDIF.GT.0.001) THEN
        FINTPO=FLOAT(IREFST(2,IB,IEX)-IREF)/FRFDIF
      ELSE
        FINTPO = 0.0
      ENDIF
      FPGOSD=FPGOS(2,IB,IEX)-FPGOS(1,IB,IEX)
      PGOSD1=PGOS1(2,IB,IEX)-PGOS1(1,IB,IEX)
      PGOSD2=PGOS2(2,IB,IEX)-PGOS2(1,IB,IEX)
      FPGOS(1,IB,IEX)=FPGOS(2,IB,IEX)+FINTPO*FPGOSD
      PGOS1(1,IB,IEX)=PGOS1(2,IB,IEX)+FINTPO*PGOSD1
      PGOS2(1,IB,IEX)=PGOS2(2,IB,IEX)+FINTPO*PGOSD2
  215 CONTINUE
      CALL BINIFF (1, IBINFC, 'BINFC',  FITFC,  NITFC, BUFFC,KENDFC)
      DO 230 IB=1,9
      DO 230 IEX=IEXS,3
      FOMOL1=0.
      FOMOL2=0.
      SCOKE1=0.
      SCOKE2=0.
      SCOK1=.FALSE.
      SCOK2=.FALSE.
      FOM1ST=FPGOS(1,IB,IEX)/FLOAT(IREF)
      FOM2S=PGOS1(1,IB,IEX)/PGOS2(1,IB,IEX)
      DO 220 ISC=1,21
      FOM1=(FLOAT(IPGO(IB,ISC,IEX))/FLOAT(IREF))-FOM1ST
      FOM2=(PGO1(IB,ISC,IEX)/PGO2(IB,ISC,IEX))-FOM2S
      IF (ISC.NE.1) THEN
        SCDIF=SCERR(ISC)-SCERR(ISC-1)
        IF (.NOT. SCOK1) THEN
          IF (FOM1.LE.0) THEN
            FOMDIF=ABS(FOM1-FOMOL1)
            SCOKE1=SCERR(ISC)+((FOM1/FOMDIF)*SCDIF)
            SCOK1=.TRUE.
          ELSE
            IF (ISC.EQ.21) SCOKE1=SCERR(ISC)
          ENDIF
        ENDIF
        IF (.NOT. SCOK2) THEN
          IF (FOM2.LE.0.) THEN
            FOMDIF=ABS(FOM2-FOMOL2)
            SCOKE2=SCERR(ISC)+((FOM2/FOMDIF)*SCDIF)
            SCOK2=.TRUE.
          ELSE
            IF (ISC.EQ.21) SCOKE2=SCERR(ISC)
          ENDIF
        ENDIF
      ELSE
        IF (FOM1.LE.0) THEN
          SCOKE1=SCERR(1)
          SCOK1=.TRUE.
        ENDIF
        IF (FOM2.LE.0) THEN
          SCOKE2=SCERR(1)
          SCOK2=.TRUE.
        ENDIF
      ENDIF
      FOMOL1=FOM1
      FOMOL2=FOM2
  220 CONTINUE
      SCTAB(1,IB,IEX)=SCOKE1
      SCTAB(2,IB,IEX)=SCOKE2
  230 CONTINUE
      WRITE(8,243)
  243 FORMAT (' ')
      WRITE(8,244)
      WRITE(24,244)
  244 FORMAT (' New refinement of SCALE, Bp and Br:',
     *' (Israel et al., Z. f. Krist., 1995)')
      WRITE(8,FMT='(''  Bp     Br      scale     Ra  '',
     * ''     DaRa     Rb       DbRb     FOM3'')')
      CALL KERNZA(0.,E2SUMT,54)
      CALL KERNZA(0.,E2FOM,54)
      CALL KERNZA(0.,RSCTL,54)
      CALL KERNZA(0.,RSCNM,54)
      CALL KERNZA(0.,RSC,54)
      RSCTL2=0.
      RSCNM2=0.
      E2SMT2=0.
      FOMMN1=999.
      FOMMN2=999.
      FOMMN3=999.
      ITPX = 0
      IREFX = 0
  250 CONTINUE
      IREFX = IREFX + 1
      HCODE = FBINX(1,IREFX)
      FOBS = FBINX(2,IREFX)
      IF (FOBS .LT. 0.) GOTO 310
      SIG = FBINX(3,IREFX)
      CALL BINIFF (0, IBINFC, 'BINFC',  FITFC,  NITFC, BUFFC,KENDFC)
      IF (KENDFC.LT.0) CALL KERROR ('BINFC cut-off ?', 0, 'SCASTA')
      FP = FITFC(1)
      PHIP = FITFC(2)
      IF (FP .LT. -990.) GOTO 250
      JCODE=1
      IF (FOBS.LT.5.*SIG) JCODE=2
      CALL HKLC1U (HCODE, HKLX)
      CALL HKLSTL (HKLX, STL, STL2)
      ISS = IFIX (STL*400. + 1.5)
      CALL HKLEX1 (HKLX, HKLX)
      CALL HKLEX2 (HKLX, IDHKL, IEPS, IEPS2)
      EPSIL = FLOAT(IEPS)
      SUMF2R=SUMF2(ISS)-SUMF2P(ISS)
      ZTMP = SQRT (SUMF2(ISS) * EPSIL * ALATT) * EXP(-BOV*STL2)
      ZRTMP= SQRT (SUMF2R * EPSIL * ALATT) * EXP(-BOV*STL2)
      ZPTMP= SQRT (SUMF2P(ISS) * EPSIL * ALATT) * EXP(-BOV*STL2)
      YBOV = FP * EXP((-BOV+BPINP)*STL2)
      Y    = FP * EXP((-BP+BPINP)*STL2)
      DO 280 IFOM=1,3
      M=3
      N=9
      IF (IFOM.EQ.3) THEN
        M=IEXS
        N=1
      ENDIF
      DO 280 IB=1,N
      DO 280 IEX=IEXS,M
      BOVCOR=EXP(-1*FBEX(IEX)*STL2)
      IF (IFOM.NE.3) THEN
        EXVAR1 = EXP(-BRVAR(IB,IEX)*STL2)
        EXVAR2 = EXP(-BPVAR(IB,IEX)*STL2)
        ZRTMPX = ZRTMP * EXVAR1 * BOVCOR
        ZPTMPX = ZPTMP * EXVAR2 * BOVCOR
        YX = YBOV * EXVAR2 * BOVCOR
        FSC=FOBS*SCTAB(IFOM,IB,IEX)
      ELSE
        ZRTMPX = SQRT (SUMF2R * EPSIL * ALATT) * EXP(-BR*STL2)
        YX = Y
        FSC=FOBS*SCALE
      ENDIF
      FONRM = (FSC*FSC)/SUMF2(ISS)
      FPNRM = (YX*YX)/SUMF2(ISS)
      FRNRM = (ZRTMPX*ZRTMPX)/SUMF2(ISS)
      IF (IFOM.NE.3) THEN
        RSCTL(IFOM,IB,IEX)=RSCTL(IFOM,IB,IEX)+(FONRM-FPNRM-FRNRM)**2
        RSCNM(IFOM,IB,IEX)=RSCNM(IFOM,IB,IEX)+FONRM**2
      ELSE
        RSCTL2=RSCTL2+(FONRM-FPNRM-FRNRM)**2
        RSCNM2=RSCNM2+FONRM**2
      ENDIF
      ITPX = IPHFIX(HKLX) - 1
      E1T = (FSC-YX) / ZRTMPX
      E1ST = ABS(E1T)
      IF (E1ST.GT.4.) E1ST = 4.
      IF (JCODE.LE.1) GOTO 270
      IF (E1T.GT.0.) GOTO 260
      E1T = (1.4*FSC - YX)/ZRTMPX
      IF (E1T.GT.0.) E1 = 0.0
      GOTO 270
  260 E1T = (0.7*FSC - YX)/ZRTMPX
      IF (E1T.LT.0.0) E1T = 0.0
  270 E2T = (FSC+YX) / ZRTMPX
      IF (JCODE.GT.1) E2T = AMAX1(YX/ZRTMPX, E1T)
      CALL W1PROB (ITPX, E1T, E2T, PT)
      EEX = E2EXP(ITPX, E1ST, E2T)
      IF (IFOM.NE.3) THEN
        E2SUMT(IFOM,IB,IEX) = E2SUMT(IFOM,IB,IEX) + EEX
      ELSE
        E2SMT2=E2SMT2+EEX
      ENDIF
  280 CONTINUE
      GOTO 250
  310 DO 320 IFOM=1,2
      DO 320 IB=1,9
      DO 320 IEX=IEXS,3
        E2SUMT(IFOM,IB,IEX)=E2SUMT(IFOM,IB,IEX)/FLOAT(NREFL)
        E2FOM(IFOM,IB,IEX)=0.
        IF (E2SUMT(IFOM,IB,IEX).LT.1.0)
     *           E2FOM(IFOM,IB,IEX)=2*ABS(1.0-E2SUMT(IFOM,IB,IEX))
        IF (E2SUMT(IFOM,IB,IEX).GT.1.1)
     *           E2FOM(IFOM,IB,IEX)=ABS(1.1-E2SUMT(IFOM,IB,IEX))
        E2AVE=E2AVE+E2FOM(IFOM,IB,IEX)
        RSC(IFOM,IB,IEX)=RSCTL(IFOM,IB,IEX)/RSCNM(IFOM,IB,IEX)
        RSCAVE=RSCAVE+RSC(IFOM,IB,IEX)
        IAVE=IAVE+1
  320 CONTINUE
      E2SMT2=E2SMT2/NREFL
      E2FOM2=0.
      IF (E2SMT2.LT.1.0) E2FOM2=2*ABS(1.0-E2SMT2)
      IF (E2SMT2.GT.1.1) E2FOM2=ABS(1.1-E2SMT2)
      IAVE=IAVE+1
      E2AVE=(E2AVE+E2FOM2)/FLOAT(IAVE)
      RSC2=RSCTL2/RSCNM2
      RSCAVE=(RSCAVE+RSC2)/FLOAT(IAVE)
      DO 321 IFOM=1,2
      DO 321 IB=1,9
      DO 321 IEX=IEXS,3
        ATERM=ABS(E2FOM(IFOM,IB,IEX)-E2AVE)
        BTERM=ABS(RSC(IFOM,IB,IEX)-RSCAVE)
        E2SDIF=E2SDIF+ATERM
        RSCDIF=RSCDIF+BTERM
  321 CONTINUE
      ATERM=ABS(E2FOM2-E2AVE)
      BTERM=ABS(RSC2-RSCAVE)
      E2SDIF=AMAX1((E2SDIF+ATERM)/FLOAT(IAVE),0.1)
      RSCDIF=AMAX1((RSCDIF+BTERM)/FLOAT(IAVE),0.01)
      FOM3P1=RSCDIF*E2FOM2
      FOM3P2=E2SDIF*RSC2
      FOM3=FOM3P1+FOM3P2
      WRITE(8,FMT='(2F7.4, 6F9.4)')
     *    BP,BR,SCALE,E2FOM2,FOM3P1,RSC2,FOM3P2, FOM3
      IF (FOM3.LT.FOMMN1) THEN
        FOMMN1=FOM3
        SCMIN1=SCALE
        BPMIN1=BP
        BRMIN1=BR
      ENDIF
      DO 330 IFOM=1,2
        WRITE(8,FMT='('' FOM'',I1,''-------------------'')')IFOM
      DO 330 IB=1,9
      DO 330 IEX=IEXS,3
        BPX = (BOV+FBEX(IEX)) + BPVAR(IB,IEX)
        BRX = (BOV+FBEX(IEX)) + BRVAR(IB,IEX)
        FOM3P1=RSCDIF*E2FOM(IFOM,IB,IEX)
        FOM3P2=E2SDIF*RSC(IFOM,IB,IEX)
        FOM3=FOM3P1+FOM3P2
        IF (FOM3.LT.FOMMN1) THEN
          FOMMN3=FOMMN2
          BPMIN3=BPMIN2
          BRMIN3=BRMIN2
          SCMIN3=SCMIN2
          FOMMN2=FOMMN1
          BPMIN2=BPMIN1
          BRMIN2=BRMIN1
          SCMIN2=SCMIN1
          FOMMN1=FOM3
          BPMIN1=BPX
          BRMIN1=BRX
          SCMIN1=SCTAB(IFOM,IB,IEX)
          GOTO 329
        ENDIF
        IF ((FOM3.LT.FOMMN2).AND.(FOM3.GT.FOMMN1))THEN
          FOMMN3=FOMMN2
          BPMIN3=BPMIN2
          BRMIN3=BRMIN2
          SCMIN3=SCMIN2
          FOMMN2=FOM3
          BPMIN2=BPX
          BRMIN2=BRX
          SCMIN2=SCTAB(IFOM,IB,IEX)
          GOTO 329
        ENDIF
        IF ((FOM3.LT.FOMMN3).AND.(FOM3.GT.FOMMN2)) THEN
          FOMMN3=FOM3
          BPMIN3=BPX
          BRMIN3=BRX
          SCMIN3=SCTAB(IFOM,IB,IEX)
        ENDIF
  329   WRITE(8,FMT='(2F7.4, 6F9.4)')
     *     BPX,BRX,SCTAB(IFOM,IB,IEX),
     *     E2FOM(IFOM,IB,IEX),FOM3P1,RSC(IFOM,IB,IEX),FOM3P2,FOM3
  330 CONTINUE
      WRITE(8,FMT='('' Best solutions: '')')
      WRITE(8, 333) BPMIN1, BRMIN1, SCMIN1, FOMMN1
      WRITE(8, 333) BPMIN2, BRMIN2, SCMIN2, FOMMN2
      WRITE(8, 333) BPMIN3, BRMIN3, SCMIN3, FOMMN3
  333 FORMAT (' Bp ',F7.3, ' Br ', F7.3, ' Sc ',F7.3,' FOM3 ',F7.5)
      WRITE (8, 334)
  334 FORMAT (' We selected the first solution for further',
     * ' calculations!')
      WRITE(24, 335)
  335 FORMAT (' New values are:')
      SCALE=SCMIN1
      BP=BPMIN1
      BR=BRMIN1
      WRITE(24, 336) BP, BR, SCALE
  336 FORMAT (' Bp =', F6.3, '  Br = ', F6.3, '  Scale = ', F9.5)
      WRITE (CHOUT, 337) SCALE, BP, BR
  337 FORMAT ('SCALE ', F14.7, ' BP ', F11.5, ' BR ', F10.5)
      CALL LOGWR (IDDL)
      CALL BINIFF (1, IBINFC, 'BINFC',  FITFC,  NITFC, BUFFC,KENDFC)
      CALL WR24
      END
      SUBROUTINE GETR2X (KEY, IATT, IRUN, KEND)
      INCLUDE 'Zaaaa.inc'
      KEND = 0
      IF (KEY .NE. 0) GOTO 813
      CALL KERNZA (-1.0, R2CYC, MRECY)
      NCYT = 0
      NCY = 0
      CALL FILINQ (IATT, 'ATTEM', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.EQ.-1) RETURN
  313 CALL KERINA (IATT,  LIT, 1, LEND)
      IF (LEND .EQ. 5) GOTO 713
      IF (LEND .LT. 0) GOTO 713
      IF (LIT(1) .NE. 'ATOMS') GOTO 313
      CALL KERING ('RUN', N, KTOT)
      IF (N .LE. 0) GOTO 313
      NRUN = NINT (FNUM(N))
      IF (NRUN .NE. IRUN) GOTO 313
      CALL KERING ('CY=', N, KTOT)
      IF (N .LE. 0) GOTO 313
      NCYT = NINT (FNUM(N))
      IF (NCYT .LE. 0 .OR. NCYT .GT. 20) GOTO 313
      CALL KERING ('R2X=', N, KTOT)
      IF (N .LE. 0) GOTO 313
      R2X = FNUM(N)
      IF (R2X .LE. -0.001 .OR. R2X .GT. 9.999) GOTO 313
      NCY = NCYT
      R2CYC(NCY) = R2X
      GOTO 313
  713 CALL FILCLO (IATT, 'KEEP')
      KEND = NCY
      CALL WR24
      WRITE (8, 714) (I, I=1,10), (R2CYC(J), J=1,NCY)
  714 FORMAT (/' For cycle nr', I4, 9I6/
     *         ' R2 values: ', 10F6.3/ 12X, 10F6.3)
      RETURN
  813 CONTINUE
      CALL FILINQ (IATT, 'ATTEM', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.EQ.-1) RETURN
      KEY1 = KEY - 1
  823 CALL KERINA (IATT,  LIT, 1, LEND)
      IF (LEND .EQ. 5) GOTO 893
      IF (LEND .LT. 0) GOTO 893
      IF (LIT(1) .NE. 'ATOMS') GOTO 823
      CALL KERING ('RUN', N, KTOT)
      IF (N .LE. 0) GOTO 823
      NRUN = NINT (FNUM(N))
      IF (NRUN .NE. IRUN) GOTO 823
      CALL KERING ('CY=', N, KTOT)
      IF (N .LE. 0) GOTO 823
      NCYT = NINT (FNUM(N))
      IF (NCYT .LT. KEY1) GOTO 823
      IF (NCYT .GT. KEY1) CALL KERROR (' ?? ', 823, 'GETR2X')
      CALL KERING ('R2X=', N, KTOT)
      IF (N .LE. 0) GOTO 823
      KEND = 1
      BACKSPACE IATT
      RETURN
  893 CALL FILCLO (IATT, 'KEEP')
      RETURN
      END
      SUBROUTINE KERING (ALI, KEND, KTOT)
      CHARACTER ALI *(*)
      INCLUDE 'Zsyst.inc'
      CHARACTER * 6  ALIT
      ALIT = ALI
      KTOT = 0
      IF (NLIT .LE. 0) GOTO 202
      DO 200 L = 1, NLIT
      IF (LIT(L) .NE. ALIT) GOTO 200
      LCOL = NCOLL(L)
      LCOL2 = 99
      IF (L .LT. NLIT) LCOL2 = NCOLL(L+1)
      IF (LCOL2 .LT. 0) LCOL2 = 99
      GOTO 250
  200 CONTINUE
  202 KEND = -1
      RETURN
  250 IF (NFNUM .LE. 0) GOTO 302
      DO 300 N = 1, NFNUM
      NCOL = NCOLN(N)
      IF (NCOL .LE. 0) GOTO 302
      IF (NCOL .LT. LCOL) GOTO 300
      IF (NCOL .GT. LCOL2) GOTO 302
      GOTO 400
  300 CONTINUE
  302 KEND = -2
      RETURN
  400 CONTINUE
      KEND = N
      KTOT = 1
  460 CONTINUE
      IF (N .GE. NFNUM) RETURN
      N = N + 1
      IF (NCOLN(N) .GT. LCOL2) RETURN
      KTOT = KTOT + 1
      GOTO 460
      END
      SUBROUTINE DICALC
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zbinx.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zbuff.inc'
      EQUIVALENCE (IDOKA, KEYS(10))
      EQUIVALENCE (IBINFC, IFILE(12))
      EQUIVALENCE (KEYD, KSTAT(19))
      EQUIVALENCE (KEYDS, KSTAT(20))
      LOGICAL EXPAND
      EQUIVALENCE (EXPAND, SWITCH(23))
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zddif.inc'
      DIMENSION IHKL(3), HKLXX(3,24)
      KEYDX = KEYD
      KEYRET = 0
      IF (KEYD.EQ.1) WRITE (8, FMT =
     *    '(/'' ****** Prepare input for program PHASEX ******''/)')
      IF (KEYD.EQ.2 .OR. KEYD.EQ.3) WRITE (8, FMT =
     *    '(/'' ****** Prepare input for program FOUR ******''/)')
  200 IF (KEYD.NE.4) CALL DIDUAL (-1)
      IF (KEYD.EQ.2 .OR. KEYD.EQ.3) CALL DIFFT (-1)
      IF (KEYD.EQ.4) CALL DIPATT (-1)
      ITP = 0
      LOOPFP = 1
      IF (EXPAND) LOOPFP = NSYMM
      NR = 0
      EPSIL2 = 1.
      IREFX = 0
  210 KEYDX = KEYD
      IREFX = IREFX + 1
      HCODE = FBINX(1,IREFX)
      FOBS = FBINX(2,IREFX)
      IF (FOBS .LT. 0.) GOTO 230
      SIG = FBINX(3,IREFX)
      IF (KEYD.EQ.4) GOTO 215
      IF (.NOT. EXPAND) THEN
         CALL BINIFF (0, IBINFC, 'BINFC',  FITFC,  NITFC, BUFFC,KENDFC)
         FP = FITFC(1)
         PHIP = FITFC(2)
      ELSE
         CALL BINIFF (0, IBINFC, 'BINFC2', FITFC2, NITFC2,BUFFC,KENDFC)
         EPSIL2 = FITFC2(1)
         SF2 = FITFC2(2)
         SF2P = FITFC2(3)
         CALL KERNAB (FITFC2(4), FPEXP, NITFC2-3)
         ENDIF
      IF (KENDFC.LT.0) CALL KERROR ('BINFC cut-off ?', 0, 'DICALC')
      IF (EXPAND) THEN
         IF (EPSIL2.LT.-990.) GOTO 210
      ELSE
         IF (FP.LT.-990.) GOTO 210
         ENDIF
  215 JCODE = 1
      IF (FOBS .LT. 5.*SIG) JCODE = 2
      CALL HKLC1U (HCODE, HKLX)
      CALL HKLSTL (HKLX, STL, STL2)
      ISS = IFIX (STL * 400. + 1.5)
      SUMF2R = SUMF2(ISS) - SUMF2P(ISS)
      IF (SUMF2R.LT.0.001) SUMF2R = 0.001
      X = FOBS * SCALE
      XSIG = SIG * SCALE
      IF (KEYD.EQ.4) THEN
         NR = NR + 1
         CALL DIPATT (0)
         GOTO 210
         ENDIF
      IF (EXPAND) CALL HKLEX1 (HKLX, HKLXX)
      DO 229 IFP=1,LOOPFP
      IF (EXPAND) THEN
          KEYDX = KEYD
          FP   = FPEXP(1,IFP)
          IF (FP .LT. 0.0) GOTO 229
          PHIP = FPEXP(2,IFP)
          HKLX(1,1) = HKLXX(1,IFP)
          HKLX(2,1) = HKLXX(2,IFP)
          HKLX(3,1) = HKLXX(3,IFP)
          CALL HKLC1 (HKLX, HCODE)
          ENDIF
      NR = NR + 1
      IF (KEYT.EQ.1) THEN
          Y = FP * EXP(-BP*STL2)
      ELSE
          Y = FP
          ENDIF
      IF (EXPAND) GOTO 221
      ITP = IPHFIX(HKLX) - 1
      IF (ITP .LT. -1) THEN
          CALL KERF2I (HKLX, IHKL, 3)
          WRITE(24, 220) (IHKL(I), I=1,3)
  220     FORMAT (' Reflection ',3I3, ' gives impossible phase restr.')
          CALL KERNER (220, 'DICALC')
          ENDIF
  221 IF (KEYD.EQ.2) CALL DIFFT (0)
      IF (KEYD.EQ.3 .AND. KEYDS.GE.4) GOTO 228
      IF (KEYDX.NE.2) CALL DIDUAL (0)
  228 IF (KEYDX.EQ.3) CALL DIFFT (0)
  229 CONTINUE
      GOTO 210
  230 IF (KEYD .EQ. 2 .OR. KEYD .EQ. 3) CALL FILCLO (IBINFC, 'DELETE')
      IF (KEYD.EQ.2) THEN
         CALL DIFFT (1)
         RETURN
         ENDIF
      IF (KEYD.EQ.4) THEN
         CALL DIPATT (1)
         RETURN
         ENDIF
      IF (KEYD.EQ.3 .AND. KEYDS.GE.4) THEN
         CALL DIFFT (1)
         RETURN
         ENDIF
      CALL DIDUAL (1)
      IF (IDOKA .EQ. 17) RETURN
      IF (KEYRET.LT.10) GOTO 200
      IF (KEYD.EQ.3) CALL DIFFT (1)
      RETURN
      END
      SUBROUTINE DIDUAL (KEY)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zbuff.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zddif.inc'
      EQUIVALENCE (NOPHAS, KSTAT(3))
      LOGICAL      SWPRI, EXPAND
      EQUIVALENCE (SWPRI, SWITCH(10)), (EXPAND, SWITCH(23))
      EQUIVALENCE (IDDL, IFILE(1)), (IDDS, IFILE(2))
      EQUIVALENCE (IE100,  IFILE(10)), (ICOND,  IFILE(4))
      EQUIVALENCE (IBINFC, IFILE(12))
      EQUIVALENCE (IBINDU, IFILE(14)), (IBINFF, IFILE(16))
      EQUIVALENCE (KEYD, KSTAT(19))
      EQUIVALENCE (FITDUA(4), ZSCATT), (FITDUA(5), P1), (FITDUA(6), P2),
     *            (FITDUA(7), W1)
      PARAMETER (PSQMIN = 0.15, E1MINP = 0.9)
      DIMENSION  DEG(8), IHKL(3), W1LIM(6), EPLIM(6)
      DIMENSION HKLM(3), HKLMA(3), HKLMI(3)
      CHARACTER * 7 RESTR(9)
      DATA ESUMMI /  .50  /
      DATA W1LIM  /  .001, .050, .200, .800,  .999,  1.000  /
      DATA EPLIM  /  .01,  .20,  .60, 1.00,  1.50,  10.000  /
      DATA DEG    / 0., 30., 45., 60., 90., 120., 135., 150. /
      DATA RESTR  / '   NONE', '  0/180', ' 30/210',
     *              ' 45/225', ' 60/240', ' 90/270',
     *              '120/300', '135/315', '150/330' /
      DATA PSQX, NGN, NSP, NR1, NPP, IEPS  / 0.0 , 0, 0, 0, 0, 0 /
      DATA HKMAX, NGNLE,NSPLE, E2CLE,E2ALE, NE1ALL /0., 0, 0, 0., 0., 0/
      DATA E1MIN / 0./
      CALL WR24
      IF (KEY) 200, 240, 380
  200 E2SUM = 0.
      E2ALE = 0.
      E2CLE = 0.
      NSP   = 0
      NGN   = 0
      NSPLE = 0
      NGNLE = 0
      SUMX  = 0.
      SUMX2 = 0.
      SUMY2 = 0.
      SUMXY = 0.
      CALL KERNZI (0, NUMW1,  6)
      CALL KERNZI (0, NUMEP,  6)
      CALL KERNZI (0, NUMEP2, 6)
      IF (NREFL .GT. 1000) THEN
         E1MIN = E1MINP
      ELSE
         IF (NREFL .GT. 500) THEN
            E1MIN = 0.7
         ELSE
            E1MIN = 0.5
            ENDIF
         WRITE(8, FMT = '('' E1MIN reset to: '', F6.3)') E1MIN
         ENDIF
      EPSIL = 1.
      IEPS  = 1
      IF (KEYD.EQ.1) THEN
         CALL KERNZA (-9999., HKLM,  3)
         CALL KERNZA (-9999., HKLMA, 3)
         CALL KERNZA ( 9999., HKLMI, 3)
         HKMAX =  0.0
         ENDIF
      IF (SWPRI .AND. KEYD.NE.2) THEN
         NPP = MAX0(1,(NREFL/40))
         IF (KEYD.EQ.1) NPP = MAX0(1,(NREFL/160))
         WRITE (8, FMT='(/'' Print every '', I3,
     *                      ''th- reflection'')') NPP
         IF (KEYD .EQ. 1) WRITE (8, FMT='(''+'', 31X,
     *                           ''(accepted for PHASEX)'')')
         IF (KEYD .EQ. 3) WRITE (8, FMT='(''+'', 31X,
     *                           ''(accepted for FOUR)'')')
         WRITE (8, 230)
  230    FORMAT ('   H   K   L  JC  EPS    FO*SC    FP(BP)   ',
     *   'PHASE REST.   PH      P1      P2      W1      E1      E2')
      ENDIF
      NR1 = 0
      NE1ALL = 0
      PSQX = PSQ
      IF (EXPAND) PSQX = P1SQ
      HMUL = 1.0
      IF (NREFL .GT. 5000) HMUL = 0.5
      HKLX(1,1) = HKLMAX(1) * HMUL
      HKLX(2,1) = HKLMAX(2) * HMUL
      HKLX(3,1) = HKLMAX(3) * HMUL
      IF (PSQX.LE.PSQMIN) THEN
         CALL E1WEAK (1, HKLX, ESUM)
         IF (NREFL.LT.4000) ESUMMI = 1.0
         ENDIF
      RETURN
  240 CONTINUE
      IF (EXPAND) GOTO 255
      IF (ITP.EQ.0) GOTO 250
      DIF = ABS(DEG(ITP) - PHIP)
      DIF = MIN1(DIF, 360.-DIF)
      PHIP = DEG(ITP)
      IF (DIF.GT.90.) PHIP = PHIP + 180.
  250 CALL HKLEX1 (HKLX, HKLX)
      CALL HKLEX2 (HKLX, IDHKL, IEPS, IEPS2)
      EPSIL = FLOAT(IEPS)
  255 Z = SQRT (SUMF2R * EPSIL * ALATT) * EXP(-BR*STL2)
      IF (FOBS.LT.0.0001) THEN
         FOBS = 0.0001
         X = 0.0001 * SCALE
         ENDIF
      EOBS = X / Z
      SIGE = SIG*SCALE / Z
      ZSCATT = Z
      E1 = (X-Y) / Z
      SUMX  = SUMX  + X
      SUMX2 = SUMX2 + X*X
      SUMY2 = SUMY2 + Y*Y
      SUMXY = SUMXY + ABS(X-Y)
      E1STAT = ABS(E1)
      IF (E1STAT.GT.4.) E1STAT = 4.
      IF (JCODE.LE.1) GOTO 270
      IF (E1.GT.0.) GOTO 260
      E1 = (1.4*X - Y)/Z
      IF (E1.GT.0.) E1 = 0.0
      GOTO 270
  260 E1 = (0.7*X - Y)/Z
      IF (E1.LT.0.0) E1 = 0.0
  270 P1 = PHIP
      IF (E1.LT.0.0)  P1 = PHIP - 180.
      IF (P1.LT.-0.5) P1 = P1 + 360.
      E2 = (X+Y) / Z
      IF (JCODE.GT.1) E2 = AMAX1(Y/Z, E1)
      P2 = PHIP - 180.
      IF (P2.LT.-0.5) P2 = P2 + 360.
      CALL W1PROB (ITP, E1, E2, P)
      W1 = 4.0 * (P-0.5)**2
      IF (P.LT.0.5) W1 = 0.0
      EEX = E2EXP(ITP, E1STAT, E2)
      E2SUM = E2SUM + EEX
      CALL KERF2I (HKLX, IHKL, 3)
      IF (.NOT. SWPRI .OR.  KEYD.EQ.2) GOTO 300
      IF (KEYD.EQ.1 .AND. E1.LT.E1MIN) GOTO 300
      IF (NR / NPP*NPP .NE. NR ) GOTO 300
      IJ = ITP + 1
      WRITE (8, 290) (IHKL(I),I=1,3), JCODE, IEPS, X, Y, RESTR(IJ),
     *                  PHIP, P1, P2, W1, E1, E2
  290 FORMAT (5I4, 2F10.3, 3X, A7, 2X, 3F8.0, 3F8.3)
  300 IF (ITP.GE.1) NSP = NSP + 1
      IF (ITP.EQ.0) NGN = NGN + 1
      EP = 0.0
      IF (SUMF2P(ISS).GT.0.000001)
     *    EP = Y / SQRT(EPSIL * ALATT * SUMF2P(ISS))
      DO 310 IEP=1,6
      IF (EP.LT.EPLIM(IEP)) GOTO 320
  310 CONTINUE
      IEP = 6
  320 NUMEP(IEP) = NUMEP(IEP) + 1
      IF (ABS(PHIP-P1) .LT. 90.) GOTO 330
      NUMEP2(IEP) = NUMEP2(IEP) + 1
      NUMW1(6) = NUMW1(6) + 1
      GOTO 360
  330 DO 340 I=1,5
      IW1 = I
      IF (W1.LT.W1LIM(I)) GOTO 350
  340 CONTINUE
      IW1 = 5
  350 NUMW1(IW1) = NUMW1(IW1) + 1
  360 CONTINUE
      IF (PSQX.GT.PSQMIN) GOTO 365
      IF (IEPS.NE.1) GOTO 365
      ESUM = E1 + EOBS + SIGE
      IF (ESUM.GT.ESUMMI) GOTO 365
      NE1ALL = NE1ALL + 1
      CALL E1WEAK (0, HKLX, ESUM)
  365 IF (E1.GE.E1MIN .OR. KEYD.NE.1) GOTO 370
      IF (ITP.EQ.0) THEN
          E2ALE = E2ALE + EEX
          NGNLE = NGNLE + 1
          ELSE
          E2CLE = E2CLE + EEX
          NSPLE = NSPLE + 1
          ENDIF
      RETURN
  370 NR1 = NR1 + 1
      IF (KEYD.NE.1) RETURN
      FITDUA(1) = HCODE
      FITDUA(2) = E1
      FITDUA(3) = E2
      CALL BINOFF (0, IBINDU, 'BINDUA', FITDUA, NITDUA, BUFDUA, KENDUA)
      DO 375 I=1,3
      HKLMA(I) = AMAX1(HKLMA(I), HKLX(I,1))
  375 HKLMI(I) = AMIN1(HKLMI(I), HKLX(I,1))
      HKMAX   = AMAX1 (HKMAX, ABS(HKLX(1,1)-HKLX(2,1)) )
      RETURN
  380 KEYOLD = KEYRET
      CALL WR24
      CALL DIRESC (PSQX)
      IF (KEYOLD.EQ.KEYRET .OR. KEYRET.GT.2) GOTO 390
      IF (KEYD.NE.1 .OR. EXPAND) GOTO 390
      CALL BINIFF (1, IBINFC, 'BINFC',  FITFC,  NITFC, BUFFC,KENDFC)
      CALL BINIFF (1, IBINDU, 'BINDUA', FITDUA,NITDUA,BUFDUA,KENDUA)
      CALL BINOFF (1, IBINDU, 'BINDUA', FITDUA,NITDUA,BUFDUA,KENDUA)
      RETURN
  390 IF (ICENT.EQ.1 .AND. .NOT.EXPAND) WRITE (8, 400) NSP, NGN
  400 FORMAT (/' Number of special  reflections:', I6 /
     *        ' Number of general  reflections:', I6)
      IF (ICENT.EQ.2 .AND. .NOT. EXPAND ) WRITE (8, 410) NSP
      IF (EXPAND) WRITE (8, 410) NGN
  410 FORMAT (23H Number of reflections:, I6 )
      IF (KEYD.NE.1) GOTO 450
      CALL BINOFF (-1, IBINDU, 'BINDUA', FITDUA, NITDUA, BUFDUA, KENDUA)
      WRITE (8, 420) NR1, E1MIN
  420 FORMAT (' Number of accepted reflections:', I6,
     *        '  (E1 > ', F4.2, ', sent to PHASEX)')
      IF (ICENT.EQ.1 .AND. .NOT.EXPAND)
     *    WRITE (8, 430) NSP-NSPLE, NGN-NGNLE
  430 FORMAT (' Number of accepted special reflections:', I6 /
     *        ' Number of accepted general reflections:', I6)
      JSYST = ISYST
      IF (EXPAND) JSYST = 0
      CALL HKLSYX (JSYST, HKLMA, HKLMI, HKMAX, HKLM)
      CALL KERF2I (HKLM, IHKL, 3)
      IF ( IHKL(1).LE.2 .OR. IHKL(2).LE.2 .OR. IHKL(3).LE.2 .OR.
     *      NR1.LT.100 ) THEN
         NOPHAS = 1
         WRITE(24, FMT='(/'' goto NOT to PHASEX but to WFOUR !''/)')
         CALL FILINQ (IDDS, 'DDSYST', 'FORMATTED', 'OUTPUT', KIDDS)
         WRITE (IDDS, FMT='( ''DDMAIN'' /''FOUR'' /
     *                       ''DDMAIN'' /''NUTS'' /''STOP'')')
         CALL FILCLO (IDDS, 'KEEP')
         CALL FILINQ (ICOND, 'CONDA', 'FORMATTED', 'OUTPUT', KINQCO)
         WRITE (ICOND, 630) CCODE
  630    FORMAT ('CONDA ', A6,  ' return from PHASEX (rejected) ')
         WRITE (ICOND, FMT='(''PROGRAM DDMAIN''/
     *       ''OPTION 3 FOUR 0 ''/
     *       ''PROGRAM FOUR '' /
     *       ''PROGRAM DDMAIN ''/''OPTION 0 FCALC''/
     *       ''PROGRAM NUTS A2X'' / ''FINISH'')' )
         CALL FILCLO (ICOND, 'KEEP')
         CALL COPY80 (ICOND, ' CONDA' , 29, ' ATPTB' )
         CALL FILCLO (ICOND, 'KEEP')
         CALL FILCLO (29, 'KEEP')
         CALL KEPROX
         RETURN
         ENDIF
      WRITE (CHOUT, 440) NAT, PSQX, IHKL, NR1
  440 FORMAT ('PHASEX NAT',I4, ' PSQ',F6.3, ' MHKL',3I4, ' NREFL1',I7)
      CALL LOGWR (IDDL)
      CALL FILCLO (IDDL, 'KEEP')
      CALL FILINQ (IE100, 'E100', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (IE100, 442) CCODE, NGN, NSP, E2ALE, E2CLE
  442 FORMAT ('E100   ', A6, 4X, 2I6, 2F7.0)
      IF (PSQX.LE.PSQMIN .AND. KEYD.EQ.1) THEN
          CALL E1WEAK (-1, HKLX, ESUM)
          WRITE (8, 445) NREFL, NE1ALL, ESUMMI
  445     FORMAT (' Number of all reflections     : ', I6, /
     *            ' Number of possible weak refl. : ', I6, /
     *            ' (E1+Eobs+SIG(Eobs) < ', F4.2, ')')
          ELSE
          WRITE (IE100, FMT='(''END'')')
          ENDIF
  450 KEYRET = 10
      RETURN
      END
      SUBROUTINE E1WEAK (KEYE1, HKL, ESUM)
      DIMENSION HKL(3)
      INCLUDE 'Zsyst.inc'
      EQUIVALENCE (IE100, IFILE(10))
      PARAMETER (MAXDAT = 100)
      DIMENSION DATE1(4, MAXDAT), HKLME1(3)
      DATA IE1 / 0 /
      IF (KEYE1.LE.0) GOTO 200
      IE1 = MAXDAT + 1
      CALL KERNZA (-1.,  DATE1, 4*MAXDAT)
      CALL KERNAB (HKL, HKLME1, 3)
      CALL WR24
      RETURN
  200 IF (KEYE1.LT.0) GOTO 300
      IF (ABS(HKL(1)).GT.HKLME1(1) .OR. ABS(HKL(2)).GT.HKLME1(2) .OR.
     *    ABS(HKL(3)).GT.HKLME1(3)) RETURN
      IE1 = IE1 - 1
      DO 210 J=MAXDAT,IE1+1,-1
      IF (ESUM.GE.DATE1(4,J)) GOTO 210
      JJ = J
      GOTO 220
  210 CONTINUE
      JJ = IE1
      IF (IE1.EQ.0) THEN
         IE1 = 1
         RETURN
         ENDIF
      GOTO 240
  220 IF (IE1.EQ.0) IE1 = 1
      DO 230 J=IE1+1,JJ
      DO 230 L=1,4
  230 DATE1(L,J-1) = DATE1(L,J)
  240 DO 250 L=1,3
  250 DATE1(L,JJ) = HKL(L)
      DATE1(4,JJ) = ESUM
      RETURN
  300 IE1 = MAXDAT + 1 - IE1
      I = MAXDAT - IE1 + 1
      ESUMMA = DATE1(4,I)
      ESUMMI = DATE1(4,MAXDAT)
      WRITE (IE100, 410) IE1, ESUMMI, ESUMMA
      CALL WR24
      WRITE (8, 410) IE1, ESUMMI, ESUMMA
  410 FORMAT (' For ', I3, ' weakest reflections: E1+Eobs+SIG(Eobs) = ',
     *         F4.2, ' upto ', F4.2)
      DO 430 I=MAXDAT,MAXDAT-IE1+1,-1
      WRITE (IE100, 420) (NINT(DATE1(I1,I)), I1=1,3)
  420 FORMAT (3I4)
  430 CONTINUE
      WRITE (IE100, FMT='(''END'')')
      RETURN
      END
      SUBROUTINE DIFFT (KEY)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zbuff.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zddif.inc'
      LOGICAL      SWPRI, EXPAND
      EQUIVALENCE (SWPRI, SWITCH(10)), (EXPAND, SWITCH(23))
      EQUIVALENCE (IBINDU, IFILE(14)), (IBINDI, IFILE(15))
      EQUIVALENCE (IBINFF, IFILE(16))
      EQUIVALENCE (KEYD, KSTAT(19))
      EQUIVALENCE (KEYDS, KSTAT(20))
      EQUIVALENCE (FITDUA(4), ZSCATT), (FITDUA(5), P1), (FITDUA(6), P2),
     *            (FITDUA(7), W1)
      EQUIVALENCE (FITDIF(1), HCODI), (FITDIF(2), EL), (FITDIF(3), PL),
     *            (FITDIF(4), WL)
      DIMENSION NNNN(3)
      PARAMETER (WMIN = 0.9, EFMIN = 0.4)
      PARAMETER (RAD = 57.29578)
      LOGICAL LOGDUA, LOGDIF
      CALL WR24
      IF (KEY) 200, 230, 420
  200 CALL KERNZI (0, NNNN,   3)
      LOGDUA = .FALSE.
      LOGDIF = .FALSE.
      NTEL = 20
      NTEL2 = 0
      SHARP = 0.0
      WRITE (8, 211) STLMAX, BR, SHARP
      IF (STLMAX .LT. 0.5) THEN
         SHARP = BR * (0.55 - STLMAX) * 10.
         IF (SHARP .GT. 20.) SHARP = 20.
         WRITE (8, 211) STLMAX, BR, SHARP
  211    FORMAT(' STLMAX=',F6.4,' BR=',F6.3,' Sharpening: SHARP =',F6.3)
         ENDIF
      WRITE (8, FMT='(/)')
      WFIND = 1.0
      WF2 = 0.0
      WF3 = 0.0
      IF ((KEYD .EQ. 3 .AND. KEYDS .EQ. 0) .OR. KEYD .EQ. 2) THEN
         IF (PSQ .GT. .60) WFIND = AMAX1 ((0.90 - PSQ) / 0.30 , 0.)
         IF (WFIND .LT. .30) WFIND = 0.0
         WF3 = (1. - WFIND) * AMAX1 ((PSQ - 0.70) / 0.30, 0.0)
         WF2 = 1. - WFIND - WF3
         ENDIF
      D123 = AMIN1 (0.1 + (1.-PSQ)/4.,  0.2)
      X123 = AMIN1 (0.1 + (1.-PSQ)/0.8, 0.4)
      IF (.NOT. SWPRI .OR. KEYD.EQ.3) RETURN
      CHOUT = '(5(F6.0, 2F4.0, F6.0, F5.0))'
      CALL LINPRI (8, FITFFT, 25)
      NPP = MAX0 (1, (NREFL/200))
      WRITE (8, FMT='(/'' DDMAIN listing for '', A6,
     *      '', OPTION: Prepare input for PROGRAM FOUR'')') CCODE
      WRITE (8, FMT='(/'' Print every '',I3,''th- reflection'',
     *       '' (accepted for FOUR)'', /,
     *       ''     H   K   L  AMPL PHASE'', /)') NPP
      RETURN
  230 CONTINUE
      WXY= AMAX1 (AMIN1 ((Y /  AMAX1(X, 0.01) - D123) / X123, 1.0), 0.0)
      WX = AMAX1 (AMIN1 ((XSIG/AMAX1(X, 0.01) - 0.2) / 0.15 , 2.0), 0.0)
      WX = WX * AMIN1 (1.5 - PSQ, 1.0)
      WXDX = AMIN1 (WX * XSIG, X)
      WXDY = AMIN1 (WX * XSIG, ABS(X-Y))
      IF (X -Y .LT. 0.0) WXDY = - WXDY
      NTEL = NTEL + 1
      IF (NTEL .LE. 10) WRITE (8, FMT='('' NTEL X,Y,WXY,WX,WXDX,WXDY '',
     *   6F7.3 )')   X,Y,WXY,WX,WXDX,WXDY
      IF (KEYD.EQ.3 .AND. KEYDS.GE.4) GOTO 321
      IF (KEYDX.EQ.3 .OR. LOGDUA) GOTO 270
      CALL BINIFF (0, IBINDU, 'BINDUA', FITDUA, NITDUA, BUFDUA, KENDUA)
      IF (KENDUA.LT.0) THEN
         LOGDUA = .TRUE.
         KEYDX = 3
         RETURN
         ENDIF
      HCODU = FITDUA(1)
      IF (HCODU-HCODE .GE. 0.99) THEN
         KEYDX = 3
         KENDUA = KENDUA - NITDUA
         NTEL2 = NTEL2 + 1
      IF (NTEL .LE. 10) WRITE (8, FMT='('' NTEL NTEL2'',I3 )')  NTEL2
         RETURN
         ENDIF
      E1 = FITDUA(2)
      E2 = FITDUA(3)
      IF (NTEL .LE. 10) WRITE (8, FMT='('' NTEL E1,E2'',2F8.4)')E1,E2
      IF (LOGDIF) GOTO 270
      CALL BINIFF (0, IBINDI, 'BINDIF', FITDIF, NITDIF, BUFDIF, KENDIF)
      IF (KENDIF.LT.0) THEN
         LOGDIF = .TRUE.
         GOTO 270
         ENDIF
      IF (HCODI-HCODE .GE. 0.99) THEN
         KENDIF = KENDIF - NITDIF
      NNNN(2) = NNNN(2) + 1
         GOTO 270
         ENDIF
      IF (WL.GE.WMIN .OR. WL.GT.5*W1) GOTO 260
      NNNN(1) = NNNN(1) + 1
      GOTO 270
  260 FL = EL * ZSCATT
      EF = FL * WL
      IF (NTEL .LE. 10) WRITE (8, FMT='('' NTEL 260: EF'',F8.4 )') EF
      PLRAD = PL / RAD
      PHIRAD = PHIP / RAD
      FA = EF * COS(PLRAD) + Y * COS(PHIRAD)
      FB = EF * SIN(PLRAD) + Y * SIN(PHIRAD)
      EF = SQRT(FA*FA + FB*FB)
      PHAMP = ATAN2(FB,FA) * RAD
      IF (PHAMP.LT.-0.5) PHAMP = PHAMP + 360.
      GOTO 300
  270 EX1 = -0.5 * E1**2
      EX2 = -0.5 * E2**2
      IF (NTEL.LE.10) WRITE(8,FMT='('' NTEL EX1'',2F8.4,I2 )')
     *    EX1,EX2,ITP
      IF (ITP .NE. 0) GOTO 280
      Q = EX1 - EX2
      EF = X * SIMW(Q)
      IF (NTEL.LE.10) WRITE(8,FMT='('' NTEL 270: EF'',F8.4 )') EF
      GOTO 290
  280 EX1 = EXP(EX1)
      EF = X * (2. * EX1 / (EX1+EXP(EX2)) -1.0)
      IF (NTEL.LE.10) WRITE(8,FMT='('' NTEL 280: EF'',F8.4 )') EF
  290 CONTINUE
      IF (NTEL.LE.10) WRITE(8,FMT='('' NTEL 290: EF'',F8.4 )') EF
      EF = WFIND * EF + WF2 * WXY * (X - WXDX + X - Y - WXDY)
     *                + WF3 * WXY * (X - WXDX)
      IF (NTEL.LE.10) WRITE(8,FMT='('' NTEL 290+ EF'',F8.4 )') EF
      IF (PSQ .LE. .95) GOTO 296
      IF ( (NAT .EQ. NATL .AND. NRECYR .GE. 4) .OR.
     *  ( NAT .LE. NATL+1 .AND. NRECYR .GE. 5) .OR. NRECYR .GE. 6) THEN
         XX4 = AMIN1 (X, 4.* Y)
         YY4 = AMIN1 (Y, 4.* X)
         EF = 2. * XX4 - YY4
         IF (2. * X .LT. XSIG) EF = 0.
         ENDIF
  296 PHAMP = PHIP
      IF (EF.GT.0.) GOTO 300
      EF = -EF
      PHAMP = PHAMP - 180.
      IF (PHAMP.LT.-0.5) PHAMP = PHAMP + 360.
  300 CONTINUE
      IF (NTEL.LE.10) WRITE(8,FMT='('' NTEL 300: EF'',F8.4 )') EF
      IF (EF.LT.EFMIN) RETURN
      NNNN(3) = NNNN(3) + 1
      CALL KERNAB (HKLX, FITFFT, 3)
      FITFFT(4) = EF * EXP (SHARP * STL2)
      FITFFT(5) = PHAMP
      IF (.NOT. SWPRI .OR. KEYD.NE.2) GOTO 310
      IF (NNNN(3) / NPP*NPP .NE. NNNN(3)) GOTO 310
      CALL LINPRI (0, FITFFT, 5)
  310 CALL BINOFF (0, IBINFF, 'BINFFT', FITFFT, NITFFT, BUFFFT, KENDFF)
      RETURN
  321 EF = WXY * (X - WXDX)
      IF (KEYDS .EQ. 6) EF = EF + WXY * (X - Y - WXDY)
      IF (KEYDS .EQ. 5) EF = WXY * (X - Y - WXDY)
      IF (KEYDS .EQ. 9) EF = Y
      GOTO 296
  420 CONTINUE
      CALL WR24
      IF (KEYD.EQ.2) THEN
          IF (SWPRI) CALL LINPRI (-1, FITFFT, 5)
          WRITE (8, 430) NNNN(2)
  430     FORMAT (/ I6, ' reflections skipped by PHASEX')
          WRITE (8, 440) NNNN(1), WMIN
  440     FORMAT (I6, ' refined reflections with weight < ', F6.4,
     *            ' considered unrefined')
          ENDIF
      CALL BINOFF (-1, IBINFF, 'BINFFT', FITFFT, NITFFT, BUFFFT, KENDFF)
      NNNN2 = NR - NNNN(3)
      WRITE (8, 445) NNNN2, EFMIN, NNNN(3)
  445 FORMAT (     I6, ' reflections with ampl. < ', F4.2, ', skipped',
     *         / , I6, ' reflections accepted (written to BINFFT file)')
      IF (NNNN(3) .LT. 97) WRITE(24, 445) NNNN2, EFMIN, NNNN(3)
      IF (NNNN(3) .GT. 37) RETURN
      WRITE (9,*) ' Structure expansion failed. Wrong scale ?'
      IF (MPAT .LE. -2) CALL ATPATS(1)
      CALL KERNER (445, 'DIFFT')
      RETURN
      END
      SUBROUTINE W1PROB (ITYP, A, B, PROB)
      IF (B.GT.6.0) B = 6.0
      IF (A.GE.0.0) GOTO 100
      PROB = 1.0
      A = -A
      IF (A.GT.4.0) A = 4.0
      RETURN
  100 IF (A.LE.4.0) GOTO 110
      A = 4.0
      B = 4.0
      PROB = 0.5
      RETURN
  110 IF (ITYP.GE.1) GOTO 120
      R1 = A*EXP(-A*A)
      R2 = B*EXP(-B*B) +  R1
      GOTO 130
  120 R1 = EXP(-0.5*A*A)
      R2 = EXP(-0.5*B*B) + R1
  130 PROB = R1 / R2
      RETURN
      END
      SUBROUTINE DIRESC (PSQ)
      INCLUDE 'Zsyst.inc'
      INCLUDE 'Zddif.inc'
      EQUIVALENCE (KEYD, KSTAT(19))
      DIMENSION  W1LIM(6), EPLIM(6)
      DATA W1LIM /  .001, .050, .200, .800,  .999,  1.000  /
      DATA EPLIM /  .01,  .20,  .60, 1.00,  1.50,  10.000  /
      CALL WR24
      IF (SUMX2 .LT. 0.000001 .OR. SUMX .LT. 0.0001) THEN
         WRITE(24, FMT='(/'' Emergency wayout: RESCALE bypassed'')')
         RETURN
         ENDIF
      PSQX  = SUMY2/SUMX2
      SUMXY = SUMXY/SUMX
      WRITE(24, 200) NR, SUMXY
      WRITE (8, 200) NR, SUMXY
  200 FORMAT (/' R-value on ', I6, ' reflections is  R =  ', F6.3 )
      DO 210 I=1,6
      IF (NUMEP(I).LE.0) EPPROC(I) = 0.
      IF (NUMEP(I).GT.0) EPPROC(I) =
     *                   100. * FLOAT(NUMEP2(I)) / FLOAT(NUMEP(I))
  210 CONTINUE
      W1PROC = 100. * FLOAT(NUMW1(6)) / NR
      IF (KEYD .EQ. 1) WRITE (8, 220) (W1LIM(I), NUMW1(I),
     *   EPLIM(I), NUMEP(I), NUMEP2(I), EPPROC(I), I=1,6), W1PROC
  220 FORMAT (/' Distribution of reflections in ranges of weight W1',
     * ' and EP:' / '      W1-interval       EP-interval' /
     * '      W1-lim.  No       EP-lim.  No   No(*)  Perc(*)' /
     *        ' 0.000-',F5.3, I5, '   0.00-', F5.2, 2I5, F9.2,
     *   5 (/ 7X,F5.3, I5, F13.2, 2I5, F9.2) /9X,'  *    *'/
     *        9X, '  *=FP.gt.FO : percentage', F6.2 )
      WRITE (8, 230) PSQX
  230 FORMAT (' Recalculated Psq of the known part is',
     *        '  P(av)**2 = ', F6.3, ' (not used)')
      E2AV = E2SUM / NR
      RESC = SQRT(E2AV)
      IF (PSQ .GT. 0.98) RETURN
      IF (KEYD .NE. 1 ) GOTO 277
      IF (RESC.LT..88 .OR. RESC.GT.1.12 )
     *   WRITE (8, 246) E2AV
  246    FORMAT (' TEMP ... The average value of Er**2 is', F5.2 )
      IF (PSQ .GT. 0.95) GOTO 277
      IF (RESC.LT..80 .OR. RESC.GT.1.22) THEN
         WRITE(24, 247) E2AV
  247    FORMAT (' The average value of Er**2 is', F5.2, ' (not used)')
         WRITE(24, 270)
  270    FORMAT (20X, 'This is a rather large deviation'
     *            / 20X, 'Check your input data ...' //)
         ENDIF
  277 IF (RESC.LT..95 .OR. RESC.GT.1.10) GOTO 280
      RETURN
  280 CONTINUE
      RESCAL = SQRT (RESC**2  * (1. - PSQ) + PSQ )
      WRITE(24, 291) RESCAL
      WRITE (8, 291) RESCAL
  291 FORMAT (' The RESCALE factor to make avg. Er**2 = 1.0 is', F6.3,
     * ' (not used)' )
      RETURN
      END
      SUBROUTINE DIPATT (KEY)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zbuff.inc'
      INCLUDE 'Zddif.inc'
      LOGICAL      SWPRI
      EQUIVALENCE (SWPRI, SWITCH(10))
      EQUIVALENCE (IBINFF, IFILE(16))
      EQUIVALENCE (KEYD, KSTAT(19))
      EQUIVALENCE (KEYDS, KSTAT(20))
      COMMON /SINGP/ SINGPK, ORIGIN, PATP(8)
      DIMENSION NNNN(2), PATX(11)
      PARAMETER (EFMIN = 0.1, PI02 = 0.6283185)
      DATA NPP, DEL10  / 0, 0.0/
      IF (KEY) 200, 230, 260
  200 CALL KERNZA (0.0, PATX, 11)
      CALL KERNZI (0,   NNNN,  2)
      SINGPK = 0.0
      CALL WR24
      WRITE (8, FMT='('' Prepare input for sharpened Patterson'')')
      BPATT = BOV
      IF (2000 .NE. NINT(1000. * BP)) BPATT = BP
      BP = 2.0
      IF (.NOT. SWPRI) RETURN
      DEL10 = 10.0
      WRITE (8, FMT='('' DDMAIN listing for '', A6,
     *      '', OPTION: Prepare input for PROGRAM ORIENT'')') CCODE
      NPP = MAX0 (1, (NREFL/200))
      WRITE (8, FMT='('' Print every '',I3,''th- reflection'',
     *       '' (accepted for sharpened Patterson)'', /,
     *       ''     H   K   L  AMPL PHASE'')') NPP
      CHOUT = '(5(F6.0, 2F4.0, F6.0, F5.0))'
      CALL LINPRI (8, FITFFT, 25)
      RETURN
  230 DDD = (0.2 + STL)**2 * EXP(BPATT * STL2)
      EFP = X**2 * DDD
      IF (KEYDS .EQ. 0) THEN
         EF  = EFP - EXP(-2. * BOV * STL2) * SUMF2R * ALATT * DDD
      ELSE
         EF = EFP
         ENDIF
      SINGPK = SINGPK + EFP
      XH = 0.0
      DELXH = HKLX(1,1) * PI02 / CELL(1)
      DO 240 I=1,11
      PATX(I) = PATX(I) + EFP*COS(XH)
  240 XH = XH + DELXH
      IF (EF.GE.0.0) THEN
          PHAMP = 0.
          ELSE
          PHAMP = 180.
          EF = -EF
        ENDIF
      NNNN(2) = NNNN(2) + 1
      IF (EF.LT.EFMIN) RETURN
      IF (SWPRI .AND. NNNN(2).EQ.1) THEN
         IF (EF.GT.1000.) DEL10 = 100.
         WRITE (8, FMT='(''+'',27X,''(AMPL/'',F4.0,'')'',/)') DEL10
         ENDIF
      CALL KERNAB (HKLX, FITFFT, 3)
      FITFFT(4) = EF
      FITFFT(5) = PHAMP
      CALL BINOFF (0, IBINFF, 'BINFFT', FITFFT, NITFFT, BUFFFT, KENDFF)
      IF (.NOT. SWPRI) RETURN
      IF (NNNN(2)/NPP*NPP .NE. NNNN(2)) RETURN
      EF = EF / DEL10
      CALL LINPRI (0, FITFFT, 5)
      RETURN
  260 IF (SWPRI) CALL LINPRI (-1, FITFFT, 5)
      CALL BINOFF (-1, IBINFF, 'BINFFT', FITFFT, NITFFT, BUFFFT, KENDFF)
      SINGPK = SINGPK * 2. * ASYMM / VOLUM
      SUMAL = 0
      DO 265 I=1,NTYPE
      IF (CELATY(I) .NE. 'H ') SUMAL = SUMAL + CELALL(I)
  265 CONTINUE
      SINGPK = SINGPK / SUMAL
      PATX1 = PATX(1) * 2. * ASYMM / VOLUM
      WRITE(24, 270) SCALE, BPATT
  270 FORMAT (/' Origin removed sharpened PATTERSON function', /
     *        ' ((', F7.4, '*Fobs)**2 - ORIGIN) * (0.2+STL)**2 * exp(',
     *        F6.3, '*STL2)')
      CALL WR24
      WRITE (8, 280)  PATX1, SINGPK
  280 FORMAT (' Output ORIENT parameters:'/
     *        ' Patterson origin peak height =', F9.2 /
     *        ' Averaged single peak maximum =', F9.2 )
      DO 290 I=2,11
      IF (PATX(I) .LT. 0.) PATX(I) = 0.
  290 PATX(I) = PATX(I) / PATX(1)
      PATX(1) = 1.0
      WRITE(24, 300) PATX
  300 FORMAT (' Observed Patterson peak shape' /
     *        '   xa = 0.0  0.1   0.2   0.3   0.4   0.5 ',
     *                 '  0.6   0.7   0.8   0.9   1.0 A' /
     *        ' P(xa)=', F5.2, 10F6.3 )
      ORIGIN = PATX1
      CALL KERNAB (PATX(2), PATP, 8)
      DO 320 I = 2, 8
      IF (PATP(I) .LT. 0.) PATP(I) = 0.
      IF (PATP(I-1) .LT. 0.2) THEN
         PATP(I-1) = PATP(I-1) * 0.9
         PATP(I) = AMIN1 (0.99, PATP(I))
         ENDIF
  320 PATP(I) = AMIN1 (PATP(I), PATP(I-1) * (1. - 0.02 * FLOAT(I)))
      WRITE(24, 323) PATP
  323 FORMAT (/' Peak profile (smoothed):'/
     * ' for x.a = 0.0   0.1   0.2   0.3   0.4   0.5   0.6   0.7   0.8'/
     * ' shape   = 1.000', 8F6.3 )
      CALL WR24
      NNNN(1) = NNNN(2) - NR
      NNNN(2) = NR
      WRITE (8, 410) NNNN(1), EFMIN, NNNN(2)
  410 FORMAT (/I8, ' Reflections with amplitude <', F5.2, ' skipped',
     *    /   I8, ' Reflections accepted (written to BINFFT file)')
      IF (NNNN(2) .LT. 10) CALL KERNER (320, 'DIPATT')
      RETURN
      END
      SUBROUTINE WILSIN (KEY)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      EQUIVALENCE (KEYWIL, KSTAT(17))
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zwils.inc'
      PARAMETER  (NRS = 9, NRF = 7)
      LOGICAL     SWIL
      DATA SWIL / .FALSE. /
      DATA FNRF1, STLM2, FNRS3 / 0.0, 0.0, 0.0/
      IF (KEY .EQ. 999) THEN
         SWIL = .FALSE.
         RETURN
         ENDIF
      IF (SWIL) GOTO 180
      SWIL = .TRUE.
      EPMIN = 9999.
      EPMAX =-9999.
      CALL KERNZI (0 , NOW, NRS)
      CALL KERNZI (0 , NUW, NRS)
      CALL KERNZA (0.,  AW, NRS)
      CALL KERNZA (0., AAW, NRS)
      CALL KERNZA (0.,  BW, NRS)
      CALL KERNZI (0 , NOV, NRF * NRF)
      CALL KERNZI (0 , NUV, NRF * NRF)
      CALL KERNZA (0.,  VA, NRF * NRF)
      CALL KERNZA (0.,  VB, NRF * NRF)
      CALL KERNZA (0.,  VC, NRF * NRF)
      CALL KERNZA (0.,  VS, NRF * NRF)
      FHMN = 0.
      BPINP = BP
      BRINP = BR
      FNRF1  = FLOAT(NRF+1)
      FNRS3  = FLOAT(NRS+1)
      STLM2  = STLMAX**2
  180 IF (KEYWIL .EQ. 4) RETURN
      CALL HKLEX2 (HKLX, IDHKL, IEPS, IEPS2)
      EPSIL = FLOAT(IEPS)
      TUMF2 = SUMF2(ISS) * EPSIL * ALATT
      TUMF2P = SUMF2P(ISS) * EPSIL * ALATT
      TUMF2R = (TUMF2 - TUMF2P) * EXPBR(ISS)**2
      K = (STL2/STLM2) * FNRS3 + 1.
      IF (K.GT.NRS) K = NRS
      NOW(K) = NOW(K) + 1
      IF (FOBS .LT. 5.*SIG)  NUW(K) = NUW(K) + 1
      AW(K)  = AW(K)  + FOBS**2 / TUMF2
      AAW(K) = AAW(K) + (FP**2 + TUMF2R) / TUMF2
      BW(K) = BW(K) + STL2
      IF (KEYWIL .EQ. -2) RETURN
      FPW = FP /  EXPBP(ISS)
      FHMN = FHMN + FPW**2 / TUMF2
      EP = FPW / SQRT(TUMF2P)
      EPMIN = AMIN1 (EPMIN, EP)
      EPMAX = AMAX1 (EPMAX, EP)
      IF (ABS(EP).GT.6.)  EP = 6.0
      K =  (STL2/STLM2)**1.5  * FNRF1
      L = (1.0 - EXP(-EP*EP)) * FNRF1
      IF (ICENT.EQ.2)  L = ERFU(EP/1.414) * FNRF1
      DO 220 IK=0,1
      I = K + IK
      IF (I.GT.NRF .OR. I.LT.1)  GOTO 220
      DO 210 IL=0,1
      J = L + IL
      IF (J.GT.NRF .OR. J.LT.1)  GOTO 210
      VA(I,J) = VA(I,J) + FOBS**2 / TUMF2
      VB(I,J) = VB(I,J) + FP**2 / TUMF2
      VC(I,J) = VC(I,J) + TUMF2R / TUMF2
      VS(I,J) = VS(I,J) + STL2
      NOV(I,J) = NOV(I,J) + 1
      IF (FOBS .LT. 5.*SIG)  NUV(I,J) = NUV(I,J) + 1
  210 CONTINUE
  220 CONTINUE
      RETURN
      END
      SUBROUTINE WIL2DI
      INCLUDE 'Zaaaa.inc'
      EQUIVALENCE (KEYWIL, KSTAT(17))
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zwils.inc'
      CALL WR24
      BMAXD = 1.0 - AMIN1 (1.0, PSQ)
      BDMAX = AMIN1 (1.00, 1.5 * BMAXD)
      CALL WIL2DC (NRF, IWILP)
         WRITE (8, FMT='('' $TE SCALE W.2D '',I3,2F6.3,F8.4,2F6.3, I5)')
     *       NRECYR, PSQ, R2X, SCALE, BP, BR, KEYWIL
      WRITE (24, 200)
  200 FORMAT (1X/' Parameters after two-dim. refinement:')
      IF (IWILP.EQ.1)  THEN
         WRITE (24, 210) SCALE, BP, BR
  210    FORMAT (' .... not acceptable . Use old parameters:'/
     *      15X,' Scale= ',F9.5,'   Bp= ',F6.3, '  Br= ',F6.3/1X)
         RETURN
         ENDIF
      BPMAX = BPINP + BMAXD
      BPMIN = AMAX1 (BPINP - BMAXD, 0.0)
      BRMAX = BRINP + BMAXD
      BRMIN = AMAX1 (BRINP - BMAXD, 0.0)
      IF (KEYWIL.NE.2 .AND. KEYWIL.NE.0) THEN
         BP = BPINP
         BPMAX = BP
         BPMIN = BP
         ENDIF
      IF (KEYWIL.NE.1 .AND. KEYWIL.NE.0) THEN
         BR = BRINP
         BRMAX = BR
         BRMIN = BR
         ENDIF
      IF (KEYWIL.EQ.0 .OR. KEYWIL.EQ.1) THEN
         BRMAX = AMIN1(BRMAX, BRINP+BDMAX)
         BRMIN = AMAX1(BRMIN, BRINP-BDMAX)
         ENDIF
      IF (KEYWIL.EQ.0 .OR. KEYWIL.EQ.2) THEN
         BPMAX = AMIN1(BPMAX, BPINP+BDMAX)
         BPMIN = AMAX1(BPMIN, BPINP-BDMAX)
         ENDIF
      BD = BP - BR
      SD = SIGN(1.0,BD)
      BD = ABS (BD)
      IF (BP.LE.BPMAX .AND. BP.GE.BPMIN .AND. BD.LE.BDMAX .AND.
     *    BR.LE.BRMAX .AND. BR.GE.BRMIN) RETURN
      BP = AMIN1(BP,BPMAX)
      BP = AMAX1(BP,BPMIN)
      BR = AMIN1(BR,BRMAX)
      BR = AMAX1(BR,BRMIN)
      IF (KEYWIL.GE.3) GOTO 230
      BD = BP - BR
      SD = SIGN(1.0,BD)
      BD = ABS (BD)
      IF (BD.LT.BDMAX) GOTO 230
      FHMN = FHMN / FLOAT(NREFL)
      IF (KEYWIL.EQ.1) FHMN = 1.
      IF (KEYWIL.EQ.2) FHMN = 0.
      BM = BP*FHMN + BR*(1.0-FHMN)
      BP = BM + SD*(1.0-FHMN)*BDMAX
      BR = BM - SD*FHMN*BDMAX
  230 SCNUM = 0.0
      SCDEN = 0.0
      DO 240 I=1,NRF
      DO 240 J=1,NRF
      IF (NOV(I,J).LT.10) GOTO 240
      SCDEN = SCDEN + VA(I,J)
      X = (BP-BPINP) * VS(I,J)
      Y = (BR-BRINP) * VS(I,J)
      IF (X.GT.50.) X = 50.
      IF (Y.GT.50.) Y = 50.
      SCNUM = SCNUM + VB(I,J)*EXP(-X) + VC(I,J)*EXP(-Y)
  240 CONTINUE
      SCALE = SQRT (SCNUM/SCDEN)
      WRITE (24, 250) SCALE, BP, BR
  250 FORMAT (' Resetting of parameters required,'/
     *   13X, ' new values are:'
     *   ,'    Scale=',F9.5,'  Bp= ',F6.3, '  Br= ',F6.3)
      CALL WR24
      WRITE (8, FMT='('' $TE SCALE ---: '',I3,2F6.3,F8.4,2F6.3, I5)')
     *       NRECYR, PSQ, R2X, SCALE, BP, BR, KEYWIL
      RETURN
      END
      SUBROUTINE WIL2DC (NRF, IWILP)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      LOGICAL SWIPRI
      EQUIVALENCE (SWIPRI, SWITCH(10))
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zwils.inc'
      DIMENSION IY(9), STLRAN(8), EPRAN1(2,7), EPRAN2(2,7), EPRANG(2,7)
      DIMENSION D(3,7,7), AMAT(3,3), AMATIN(3,3), V(3), SH(3),
     *         ERR(3), PA(3), AC(7,7)
      EQUIVALENCE (SC, PA(1))
      DIMENSION NPERCA(7), NPERCU(7), PERCU(7)
      CHARACTER *8  VARI(3)
      DATA VARI / '      K', 'delta BP', 'delta BR' /
      DATA EPRAN1 / 0.00, 0.53,  0.36, 0.68,  0.54, 0.83,  0.69, 0.99,
     *              0.84, 1.17,  1.00, 1.44,  1.18, 4.26 /
      DATA EPRAN2 / 0.00, 0.31,  0.15, 0.48,  0.32, 0.67,  0.49, 0.88,
     *              0.68, 1.15,  0.89, 1.53,  1.16, 3.50 /
      DATA PSC /0.0/
      CALL WR24
      NRF = 7
      IF (NREFL.GT.400) GOTO 190
      K = 0
      DO 170 I=1, (NRF-1), 2
      K = K + 1
      IJ = 0
      DO 170 J=1, (NRF-1), 2
      IJ = IJ + 1
      NOV(IJ,K) = NOV(J,I) + NOV(J+1,I) + NOV(J,I+1) + NOV(J+1,I+1)
      NUV(IJ,K) = NUV(J,I) + NUV(J+1,I) + NUV(J,I+1) + NUV(J+1,I+1)
      VA(IJ,K)  = VA(J,I)  + VA(J+1,I)  + VA(J,I+1)  + VA(J+1,I+1)
      VB(IJ,K)  = VB(J,I)  + VB(J+1,I)  + VB(J,I+1)  + VB(J+1,I+1)
      VC(IJ,K)  = VC(J,I)  + VC(J+1,I)  + VC(J,I+1)  + VC(J+1,I+1)
  170 VS(IJ,K)  = VS(J,I)  + VS(J+1,I)  + VS(J,I+1)  + VS(J+1,I+1)
      IJ = 0
      DO 180 I=1, (NRF-1), 2
      IJ = IJ + 1
      NOV(IJ,K) = NOV(IJ,K) + NOV(I,NRF) + NOV(I+1,NRF)
      NOV(K,IJ) = NOV(K,IJ) + NOV(NRF,I) + NOV(NRF,I+1)
      NUV(IJ,K) = NUV(IJ,K) + NUV(I,NRF) + NUV(I+1,NRF)
      NUV(K,IJ) = NUV(K,IJ) + NUV(NRF,I) + NUV(NRF,I+1)
      VA(IJ,K)  = VA(IJ,K)  + VA(I,NRF)  + VA(I+1,NRF)
      VA(K,IJ)  = VA(K,IJ)  + VA(NRF,I)  + VA(NRF,I+1)
      VB(IJ,K)  = VB(IJ,K)  + VB(I,NRF)  + VB(I+1,NRF)
      VB(K,IJ)  = VB(K,IJ)  + VB(NRF,I)  + VB(NRF,I+1)
      VC(IJ,K)  = VC(IJ,K)  + VC(I,NRF)  + VC(I+1,NRF)
      VC(K,IJ)  = VC(K,IJ)  + VC(NRF,I)  + VC(NRF,I+1)
      VS(IJ,K)  = VS(IJ,K)  + VS(I,NRF)  + VS(I+1,NRF)
  180 VS(K,IJ)  = VS(K,IJ)  + VS(NRF,I)  + VS(NRF,I+1)
      NOV(K,K)  = NOV(K,K)  + NOV(NRF,NRF)
      NUV(K,K)  = NUV(K,K)  + NUV(NRF,NRF)
      VA(K,K)   = VA(K,K)   + VA(NRF,NRF)
      VB(K,K)   = VB(K,K)   + VB(NRF,NRF)
      VC(K,K)   = VC(K,K)   + VC(NRF,NRF)
      VS(K,K)   = VS(K,K)   + VS(NRF,NRF)
      NRF = K
  190 CONTINUE
      CALL WR24
      WRITE (24, 201)
  201 FORMAT (/' Two-dimensional refinement of BP and BR' /)
      FNRF1  = FLOAT(NRF+1)
      F13 = 1. / 3.
      DO 205 I=1,NRF
  205 STLRAN(I) = STLMAX * (FLOAT(I)/FNRF1)**F13
      STLRAN(NRF+1) = STLMAX
      CALL KERNZI (0, NPERCU, NRF)
      CALL KERNZI (1, NPERCA, NRF)
      DO 207 I = 1, NRF
      DO 207 J = 1, NRF
      NPERCA(I) = NPERCA(I) + NOV(I,J)
  207 NPERCU(I) = NPERCU(I) + NUV(I,J)
      PERCUM = 0.0
      DO 208 I = 1, NRF
      PERCU(I) = 100. * FLOAT(NPERCU(I)) / FLOAT(NPERCA(I))
      IF (PERCU(I) .GT. PERCUM) PERCUM = PERCU(I)
  208 CONTINUE
      IF (PERCUM .LE. 30.) GOTO 214
      WRITE(24, 210) STLRAN(2), (STLRAN(I), STLRAN(I+2), I=1,NRF-1)
  210 FORMAT (/' sinTH/L range:  0.0-', F3.2, 6(1X, F3.2,'-', F3.2),
     *                                         1X, F3.2,'-', F4.2 )
      WRITE(24, 212) (PERCU(I), I = 1, NRF)
  212 FORMAT (' Percentage unobs:', 7(F6.0,2X))
  214 CONTINUE
      CALL WR24
      WRITE (8, 215)
  215 FORMAT (/' Distribution of reflections (and unobs.) in array')
      WRITE (8, 210) STLRAN(2), (STLRAN(I), STLRAN(I+2), I=1,NRF-1)
      CALL KERNAB (EPRAN1, EPRANG, 14)
      IF (ICENT .EQ. 2) CALL KERNAB (EPRAN2, EPRANG, 14)
      EPRANG(1,1) = AMAX1 (EPRANG(1,1), EPMIN)
      EPRANG(2,NRF) = AMIN1 (EPRANG(2,NRF), EPMAX)
      WRITE (8, 220)
  220 FORMAT (' Ep range=')
      DO 260 J=1,NRF
      WRITE (8, 230) (EPRANG(I2,J),I2=1,2), (NOV(I,J), I=1,NRF)
  230 FORMAT (/' ', F4.2, '-', F4.2, '  All ', 7I8)
      WRITE (8, 240) (NUV(I,J), I=1,NRF)
  240 FORMAT (10X, 'Unobs ', 7I8)
      DO 260 I=1,NRF
      XN = NOV(I,J)
      IF (XN.LT.1.0) XN = 1.0
      IF (NOV(I,J).GT.10) GOTO 250
      NOV(I,J) = 0
      NUV(I,J) = 0
      VA(I,J) = 0.0
      AC(I,J) = 0.0
      VB(I,J) = 0.0
      VC(I,J) = 0.0
      VS(I,J) = 0.0
      GOTO 260
  250 VA(I,J) = VA(I,J) / XN
      VB(I,J) = VB(I,J) / XN
      VC(I,J) = VC(I,J) / XN
      VS(I,J) = VS(I,J) / XN * 2.0
  260 CONTINUE
      KEYNRS = 0
  270 KEYNRS = KEYNRS + 1
      SC = 1.0 / SCALE**2
      PA(2) = 0.
      PA(3) = 0.
      NY = 0
      IWILP = 0
      DO 290 J=1,NRF
      NX = 0
      IY(J) = 0
      DO 280 I=1,NRF
      NX = NX + NOV(I,J)
  280 CONTINUE
      IF (NX.EQ.0) GOTO 290
      NY = NY + 1
      IY(NY) = J
  290 CONTINUE
      IF (NY.GT.2) GOTO 330
      IF (NY.EQ.2) GOTO 320
  300 IWILP = 1
      WRITE (8, 310)
  310 FORMAT (' Refining scale and temperature factors seperately' /
     *        ' is impossible for this problem: use old parameters.')
      RETURN
  320 IF ((IY(2)-IY(1)) .EQ. 1) GOTO 300
  330 SIG = 10000.0
      WRITE(24, 333) SCALE, BPINP, BRINP
  333 FORMAT (/' Input for 2-dim. refinement:',
     * '    Scale=', F9.5 , '  Bp=', F7.3,'  Br=', F7.3/)
      CALL WR24
      NCYC = 10
      NP  = 3
      PCYMAX = 1.2
      DO 490 NC=1,NCYC
      SIGOLD = SIG
      SIG = 0.0
      CALL KERNZA (0., AMAT, 9)
      CALL KERNZA (0.,   V, 3)
      DO 370 I=1,NRF
      DO 370 J=1,NRF
      IF (NOV(I,J).EQ.0) GOTO 370
      P = EXP (-PA(2)*VS(I,J))
      Q = EXP (-PA(3)*VS(I,J))
      D(1,I,J) = VB(I,J)*P + VC(I,J)*Q
      D(2,I,J) = -VB(I,J) * VS(I,J) * P * SC
      D(3,I,J) = -VC(I,J) * VS(I,J) * Q * SC
      AC(I,J) = VA(I,J) - SC*D(1,I,J)
      XN = 100.0 / NOV(I,J)
      IF (XN.LT.1.0) XN = 1.0
      DO 360 K=1,NP
      DO 350 L=1,NP
  350 AMAT(K,L) = AMAT(K,L) + D(K,I,J)*D(L,I,J)/XN
      V(K) = V(K) + D(K,I,J)*AC(I,J)/XN
      SIG = SIG + AC(I,J)**2/XN
  360 CONTINUE
  370 CONTINUE
      SIG = SQRT (SIG / (NRF*NRF-NP))
      IF (SWIPRI) WRITE (8, 380) NC, SIG
  380 FORMAT (' Cycle', I2, ' Sigma   =', G12.4)
      CALL MATINV (AMAT, AMATIN, DMAT, KEND)
      IF (DMAT .LT. 10.E-9) WRITE (8, 381)
  381 FORMAT (' Warning: small determinant, results unreliable?')
      IF (KEND.EQ.-99) GOTO 545
      DO 390 I=1,NP
      SH(I) = 0.0
      ERR(I) = SQRT (AMATIN(I,I))
      DO 390 J=1,NP
  390 SH(I) = SH(I) + AMATIN(I,J)*V(J)
      DO 400 I=1,NP
      DO 400 J=1,NP
  400 AMATIN(I,J) = AMATIN(I,J) / (ERR(I) * ERR(J))
      DO 410 I=1,NP
  410 ERR(I) = ERR(I) * SIG
      IF (SWIPRI) WRITE (8, 420)
  420 FORMAT (30X, ' Par', 5X, 'Old', 5X, 'Shift', 5X, 'New',5X,'Error')
      DO 470 J=1,3
      P = SH(J)
      IF (NC.LE.3) P = P * .9
      IF (J.EQ.1) GOTO 430
      IF (P.GT.PCYMAX) P = PCYMAX
      IF (P.LT.-PCYMAX) P = -PCYMAX
  430 X = PA(J) + P
      IF (J .EQ. 1) X = AMAX1 (X, PA(1) / 5.)
      IF (SWIPRI) WRITE (8, 450) VARI(J), PA(J), SH(J), X, ERR(J)
  450 FORMAT (27X, A8, 4F9.4)
      PA(J) = X
      IF (J.GT.1) GOTO 470
      PSC = 1. / SQRT(ABS(X))
      IF (SWIPRI) WRITE (8, 460) PSC
  460 FORMAT (1H+, 8X, 'SC(new) =', F7.4)
  470 CONTINUE
      WRITE (8, 480) NC, PSC, BPINP+PA(2), BRINP+PA(3)
  480 FORMAT ('    Cycle', I2, '    Scale =', F9.5,
     *   '  New Bp =', F7.3, '  Br =', F7.3 )
      IF (NC.LT.4) GOTO 489
      IF (ABS(SIGOLD-SIG).LT.0.01*SIG) GOTO 590
      IF (SIG.GT.1.5*SIGOLD) GOTO 550
      IF ((PA(2)+BPINP).LT.-5. .OR. (PA(2)+BPINP).GT.30. .OR.
     *    (PA(3)+BRINP).LT.-5. .OR. (PA(3)+BRINP).GT.30.) GOTO 530
      IF (SC.LT.0.0000001) GOTO 530
  489 PCYMAX = PCYMAX + .15
  490 CONTINUE
      WRITE (8, 500) NCYC
  500 FORMAT (' Series is still unconverged after', I3, ' cycles')
      GOTO 570
  530 WRITE (8, 540)
  540 FORMAT (' Unreasonable results' )
      GOTO 570
  545 WRITE (8, 546)
  546 FORMAT (' Determinant is zero: no 2-dimens. Bp Br Sc ref. plot ')
      GOTO 570
  550 WRITE (8, 560)
  560 FORMAT (' Series is diverging seriously')
  570 IWILP = 1
      IF (KEYNRS.GT.1 .OR. NRF.LE.6) GOTO 610
      WRITE(24, 580)
      WRITE (8, 580)
  580 FORMAT (' Try again; skip high order refl.')
      NRF = NRF-2
      GOTO 270
  590 WRITE (8, 595) NC
  595 FORMAT (' Series has converged after', I3, ' cycles')
      IF (KEYNRS.GT.1 .OR. NRF.LE.6) GOTO 610
      IF (ABS(PA(2)) .LT. 2.5) GOTO 610
      WRITE (8, 600)
  600 FORMAT (' A large change of BP, too large.')
      GOTO 570
  610 IF (IWILP.GT.0) RETURN
      IF (SWIPRI)
     * WRITE (8, 620) VARI, (VARI(I), (AMATIN(I,J), J=1,NP), I=1,NP)
  620 FORMAT (' Correlation matrix',12X,A8,4X,A8,2X,A8 /(22X,A8,3F10.4))
      SCALE = 1.0 / SQRT(SC)
      BP = PA(2) + BPINP
      BR = PA(3) + BRINP
      RETURN
      END
      SUBROUTINE MERBIN
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zbinx.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zwils.inc'
      EQUIVALENCE (IDDL, IFILE(1))
      EQUIVALENCE (KEYWIL, KSTAT(17))
      DIMENSION HKL(3)
      EQUIVALENCE (HKL(1), HKLX(1,1))
      PARAMETER (MAXA = 10000)
      COMMON /BLANK/ AREF(4, MAXA), DUMMY(120000)
      PARAMETER (AMAX = 10000.)
      DIMENSION HMAX(3), HMIN(3), HCON(3)
      LOGICAL FRIE
      DIMENSION ITEMP(9)
      DATA FRIE /.TRUE./
      DATA IREF /0/
      CALL WR24
      CALL KERNZA (  9999., HMIN, 3)
      CALL KERNZA ( -9999., HMAX, 3)
      HKMAX =  0.0
      HCODMI = 4.0 * 256.**3
      HCODMA = - HCODMI
      STLCON = 9999.9
      IF (STLMAX .GT. 0.00001) STLCON = STLMAX
      STLMAX = 0.
      DO 230 I=1,3
      HCON(I) = 9999.
      IF (HKLMAX(I) .GT. 0.1) HCON(I) = HKLMAX(I)
  230 CONTINUE
      NREF = 0
      MREF = 0
      MREF99 = 0
      IEND = 1
  240 CALL MEREAD (HKL, JC, FOBS, SIG, IEND)
      IF (IEND .LT. 0) GOTO 270
      MREF = MREF + 1
      CALL HKLAXT (HKL, KEND)
      IF (KEND.LT.0) GOTO 240
      CALL HKLEXT (HKL, KEND)
      IF (KEND.LT.0) GOTO 240
      IF (ABS(HKL(1)).GT.HCON(1) .OR. ABS(HKL(2)).GT.HCON(2) .OR.
     *    ABS(HKL(3)).GT.HCON(3)) GOTO 240
      CALL HKLSTL (HKL, STL, STL2)
      IF (STL .GT. STLCON) GOTO 240
      MREF99 = MREF99 + 1
      IF (ABS (HKL(1)) .GT. 99. .OR. ABS (HKL(2)) .GT. 99. .OR.
     *    ABS (HKL(3)) .GT. 99. ) GOTO 240
      STLMAX = AMAX1 (STLMAX, STL)
      NREF = NREF + 1
      CALL HKLEXS (FRIE, HKL, HCODE)
      FOBS = AMAX1 (FOBS, 0.01)
      SIG  = AMAX1 (SIG, FOBS / 100. , 0.01)
      IF (JC .EQ. 2) SIG = AMAX1(FOBS/6.0, SIG)
      CALL WRPEAK(0)
      SIG = SIG * 2. * FOBS
      FOBS = FOBS ** 2
      HCODMI = AMIN1(HCODMI, HCODE)
      HCODMA = AMAX1(HCODMA, HCODE)
      CALL HKLC1U (HCODE, HKL)
      DO 260 I =1,3
      HMAX(I) = AMAX1 (HKL(I),HMAX(I))
  260 HMIN(I) = AMIN1 (HKL(I),HMIN(I))
      HKMAX  = AMAX1 (HKMAX, ABS(HKL(1)+HKL(2)) )
      FBINX(4,NREF) = HCODE
      FBINX(5,NREF) = FOBS
      FBINX(6,NREF) = SIG
      IF (NREF .EQ. MBINX) STOP 230
      GOTO 240
  270 CONTINUE
      FBINX(4,NREF+1) = 0.
      FBINX(5,NREF+1) = -1.
      FBINX(6,NREF+1) = 0.
      CALL KERNZA (0., ATXYZ, 10)
      IZAT(1) = 1
      STLMAX = STLMAX + 0.00001
      NAT = 1
      CALL FCALCI (ATXYZ, IZAT, ITAT, 1)
      CALL HKLSYX (ISYST, HMAX, HMIN, HKMAX, HKLMAX)
      WRITE(24, 292) MREF
  292 FORMAT (' Number of input reflections:    ', I17)
      IF (MREF-NREF .GT. 0) WRITE(24, 294) NREF
  294 FORMAT (' Number of relections accepted:  ', I17)
      MREF99 = MREF99 - NREF
      IF (MREF99 .GT. 0) WRITE (9, 295) MREF99
  295 FORMAT (' Number of relections with hkl exceeding 99:  ', I7/
     *        ' WARNING: these reflections are not used in DIRDIF !'/1X)
      CALL KERF2I (HMAX, ITEMP, 3)
      CALL KERF2I (HMIN, ITEMP(4), 3)
      CALL KERF2I (HKLMAX, ITEMP(7), 3)
      WRITE(24, 300) ITEMP, STLMAX
  300 FORMAT (10X, ' Maximum indices output: ', 3I5 /
     *        10X, ' Minimum indices output: ', 3I5 /
     *        10X, ' HKLmax  incl. symmetry: ', 3I5 /
     *        10X, ' Maximum sin(TH/LAMBDA): ', F15.5 )
      CALL WR24
      IF (KSTAT(13) .LE. 0) KSTAT(13) = 1
      SUMRN1 = 0.
      SUMRN2 = 0.
      NSUMR  = 0
      CALL HKLC2I (HMIN, HMAX)
      CALL HKLC1U (HCODMI, HKL)
      CALL HKLC2  (HKL, ACODMI)
      IREFX = 0
  310 AF = ACODMI - 1.1
      CALL HKLC2U (ACODMI + AMAX - 1., HKL)
      CALL HKLC1  (HKL, HCODEL)
      CALL KERNZA (0.0, AREF, 4 * MAXA)
  320 CONTINUE
      IF (IREFX .GE. NREF) GOTO 330
      IREFX = IREFX + 1
      HCODE = FBINX(4,IREFX)
      FOBS = FBINX(5,IREFX)
      SIG = FBINX(6,IREFX)
      IF (FOBS.LT.0.) GOTO 330
      IF (HCODE.LT.HCODMI .OR. HCODE.GT.HCODEL) GOTO 320
      CALL HKLC1U (HCODE, HKL)
      CALL HKLC2  (HKL, ACODE)
      IA = IFIX (ACODE - AF)
      AREF(1,IA) = AREF(1,IA) + 1.
      IF (NINT(AREF(1,IA)) .EQ. 2) THEN
         SUMRN1 = SUMRN1 + ABS(AREF(3,IA)-FOBS)
         SUMRN2 = SUMRN2 +     AREF(3,IA)+FOBS
         NSUMR = NSUMR + 1
         ENDIF
      AREF(2,IA) = HCODE
      AREF(3,IA) = AREF(3,IA) + FOBS
      AREF(4,IA) = AREF(4,IA) + SIG
      GOTO 320
  330 DO 340 I = 1,MAXA
      IF (AREF(1,I).LE.0.1) GOTO 340
      TOT = AREF(1,I)
      HCODE = AREF(2,I)
      FOBS  = AREF(3,I) / TOT
      SIG   = AREF(4,I) / TOT **1.5
      FOBS = SQRT(FOBS)
      SIG  = SIG / (2. * FOBS)
      IREF = IREF + 1
      FBINX(1,IREF) = HCODE
      FBINX(2,IREF) = FOBS
      FBINX(3,IREF) = SIG
      CALL HKLC1U (HCODE, HKL)
      CALL HKLSTL (HKL, STL, STL2)
      CALL WILSIM
  340 CONTINUE
      IF (HCODEL.GE.HCODMA) GOTO 350
      ACODMI = ACODMI + AMAX
      CALL HKLC2U (ACODMI, HKL)
      CALL HKLC1 (HKL, HCODMI)
      GOTO 310
  350 CONTINUE
      FBINX(1,IREF+1) = 0.
      FBINX(2,IREF+1) = -1.
      FBINX(3,IREF+1) = 0.
      WRITE (9, 360) IREF
  360 FORMAT (' Number of reflections (merged) output: ' , I8/1X)
      IF (IREF .LE. 0) CALL KERROR ('Number of refl. = 0',0,'MERBIN')
      NREFL = IREF
      IF (NSUMR .GT. 10) THEN
         SUMRN1 = SUMRN1 / SUMRN2
         WRITE (24, 401) NSUMR, SUMRN1
  401    FORMAT (' R-merge  on F**2 for',I5,' reflections is R=',F6.2)
         ENDIF
      CALL WR24
      WRITE (8,490)
  490 FORMAT (/' Least squares Wilson plot' /
     *   ' Range  Sin(Th/Lambda)**2   Number  <|Fobs|**2/F2>' )
      STLM2  = STLMAX**2 / 9.
      NOWT = 0
      DO 560 I=1,9
      NOWT = NOW(I) + NOWT
      STMIN= FLOAT(I-1)  * STLM2
      STMAX= FLOAT(I)    * STLM2
      AWNOW = 0.
      IF (NOW(I) .GT. 0) AWNOW = AW(I)/NOW(I)
      WRITE(8,550) I, STMIN, STMAX, NOW(I), AWNOW
  550 FORMAT(I5,F10.4,' - ',F6.4,I10,F14.6)
  560 CONTINUE
      WRITE(8,570) NOWT
  570 FORMAT(/' Total number of reflections:', I5/)
      CALL WILPAR
      CALL WR24
      SCAMER = SCALE
      BOVMER = BOV
      CALL LOGMER (IREF, HMAX, HMIN, HKLMAX, STLMAX, SCALE, BP)
      CALL WRPEAK(NREF)
      CALL FILCLO (IDDL, 'KEEP')
      CALL WR24
      WRITE (8, 603)
  603 FORMAT( /' ==== END OF SUB-PROGRAM MERBIN ==== '//)
      RETURN
      END
      SUBROUTINE MEREAD (HKL, JC, FOBS, SIG, IEND)
      DIMENSION HKL(3)
      INCLUDE 'Zsyst.inc'
      EQUIVALENCE (IDDL, IFILE(1))
      EQUIVALENCE (ICRIN,IFILE(4)), (IHKL,IFILE(11)), (ISHEL,IFILE(12))
      DIMENSION HH(3,3), HT(3)
      CHARACTER IE *1
      CHARACTER *6 XHKL(7)
      CHARACTER *80 CHINA
      LOGICAL FIRST, F2, TRANS
      DATA XHKL / 'HKL', 'SHELX'  ,
     *            'FREFB', 'FREFC', 'FREFA', 'FREF', 'CIF' /
      DATA FIRST /.FALSE./
      IF (IEND .EQ. 1) THEN
         IEND = 0
         FIRST = .FALSE.
         F2 = .FALSE.
         TRANS = .FALSE.
         IDNUM = 0
         ENDIF
      IF (FIRST) GOTO 310
      FIRST = .TRUE.
      DO 110 ID = 1, 7
      CALL FILINQ (IHKL, XHKL(ID), 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .EQ. 0) GOTO 120
  110 CONTINUE
      CALL KERROR ('No reflection file found', 0, 'MERBIN')
  119 CONTINUE
      CALL KERROR(' Empty refl.data file', 119, 'MEREAD')
  120 IF (ID .EQ. 7) GOTO 180
      IDNUM = 1
      CHIN = ' '
      READ (IHKL, FMT='(A28)', END=119) CHIN(1:28)
      WRITE (24, 140) XHKL(ID), CHIN(1:28)
  140 FORMAT (1X/' Input data file: ', A6, ' Header: ', A28)
      CALL KERINB (LIT, 1)
      IF (ID .LE. 2) GOTO 145
      IF (ID .LE. 6 .AND. LIT(1)(1:4) .NE. 'FREF')
     *   CALL KERROR ('File name and header inconsistent' , 0, 'MERBIN')
      IF (LIT(2) .NE. CCODE)
     *   CALL KERROR ('Input file has incorrect CCODE', -6, 'MERBIN')
      IDNUM=1
      GOTO 310
  145 IDNUM = 3
      INUM = 0
      IHKLF = 0
      CHINA = CHIN
      IF (LIT(1) .EQ. ' ') THEN
         BACKSPACE IHKL
         GOTO 148
      ELSE
         IF (CHIN(1:4) .NE. 'HKLF') THEN
            CALL FILCLO (IHKL, 'KEEP')
            CALL KERROR ('Incorrect header record', 167, 'MEREAD')
            ENDIF
         ENDIF
      KINS = -1
      CALL KERINB (LIT, 1)
      INUM = NINT(FNUM(1))
      IHKLF = 1
      GOTO 152
  148 CONTINUE
      CALL FILINQ (ISHEL, 'INS', 'FORMATTED', 'INPUT', KINS)
      IF (KINS .EQ. 0) GOTO 151
      CALL FILINQ (ISHEL, 'RES', 'FORMATTED', 'INPUT', KINS)
      IF (KINS .NE. 0) GOTO 152
  151 READ (ISHEL, END = 1152, FMT = '(A80)') CHIN
      IF (CHIN(1:4) .EQ. 'HKLF') THEN
         CALL FILCLO (ISHEL, 'KEEP')
         CALL KERINB (LIT, 1)
         INUM = NINT(FNUM(1))
         IHKLF = 2
         GOTO 1152
         ENDIF
      GOTO 151
 1152 CALL FILCLO (ISHEL, 'KEEP')
  152 CONTINUE
      CALL FILCLO (ICRIN, 'KEEP')
      CALL FILINQ (ICRIN, 'CRYSIN', 'FORMATTED', 'INPUT', KINCR)
      IF (KINCR .NE. 0) THEN
         WRITE (9,*) 'CRYSIN file not found: rerun CRYSDA !'
         GOTO 1155
         ENDIF
  153 READ (ICRIN, END = 1155, FMT = '(A80)') CHIN
      IF (CHIN(1:4) .EQ. 'HKLF') THEN
         CALL FILCLO (ICRIN, 'KEEP')
         CALL KERINB (LIT, 1)
         INUMX = NINT(FNUM(1))
         IF (IHKLF .GT. 0 .AND. INUM .NE. INUMX) THEN
            WRITE (9,*) 'HKLF on CRYSIN incorrect / discarded '
         ELSEIF (INUM .EQ. 0) THEN
            INUM = INUMX
            IHKLF = 3
         ELSE
            IHKLF = 3
            ENDIF
         GOTO 1155
         ENDIF
      GOTO 153
 1155 CONTINUE
      IF (INUM .NE. 0 .AND. IHKLF .GT. 0) GOTO 156
  155 WRITE (9,2155)
      WRITE(24,2155)
 2155 FORMAT (' The reflection file may contain F or F**2 values;'/
     *   ' but no HKLF record was found.'/
     *   ' your hkl file is assumed to have F**2 values.')
      F2 = .TRUE.
      CHIN = CHINA
      INUM = 4
      IHKLF = 4
  156 IF (IABS (INUM) .NE. 3 .AND. IABS (INUM) .NE. 4) THEN
         WRITE (9, FMT='('' input: HKLF'', I3, '' ??'')') INUM
         GOTO 155
         ENDIF
      IF (KINCR .NE. 0 .OR. IHKLF .EQ. 3) GOTO 163
      CALL FILINQ (ICRIN, 'CRYSIN', 'FORMATTED', 'OUTPUT', KINCR)
      CALL FILINQ (ISHEL, 'PAULTB', 'FORMATTED', 'SCRATCH', IIIII)
  157 READ (ICRIN, END = 158, FMT = '(A80)') CHIN
      IF (CHIN(1:4) .EQ. 'HKLF') GOTO 157
      WRITE (ISHEL, FMT = '(A80)') CHIN
      IF (CHIN(1:4) .EQ. 'END ') GOTO 158
      GOTO 157
  158 REWIND ICRIN
      REWIND ISHEL
 1157 READ (ISHEL, END = 1158, FMT = '(A80)') CHIN
      IF (CHIN(1:4) .EQ. 'END ') GOTO 1158
      WRITE (ICRIN, FMT = '(A80)') CHIN
      GOTO 1157
 1158 WRITE (ICRIN, FMT='(''HKLF'', I4 / ''END'' )') INUM
      WRITE (9, FMT='('' HKLF'', I3,
     *   ''  :  written to the CRYSIN file'')') INUM
      CALL FILCLO (ICRIN, 'KEEP')
      CALL FILCLO (ISHEL, 'DELETE')
 163  INUM = IABS (INUM)
      WRITE (CHOUT, 162) INUM
 162  FORMAT ('HKLF', I4, ' .. HKLF number for SHELX data file')
      CALL LOGWR (IDDL)
      IF (INUM.EQ.3) THEN
         WRITE(24, 165)
 165     FORMAT(' Input SHELXL or HKL file: SHELX format (Fobs values)')
      ELSEIF (INUM.EQ.4) THEN
         WRITE(24, FMT=
     *   '('' Input SHELX or HKL file with Fobs**2 values '')')
         F2 = .TRUE.
      ELSE
         CALL KERROR ('Unknown contents of SHELX or HKL file ...', 165,
     *      'MEREAD')
         ENDIF
      IF (NFNUM .GE. 11) THEN
         TRANS = .TRUE.
         DO 175  I = 1, 3
         DO 175  J = 1, 3
  175    HH(I,J) = FNUM(3*I + J -1)
         ENDIF
      GOTO 310
  180 IDNUM = 4
  190 CALL KERINA( IHKL, LIT, 1, KEND)
      IF (KEND .NE. 0) CALL KERROR ('Incorrect CIF file', 190, 'MEREAD')
      IF (CHIN(1:5) .EQ. 'data_') THEN
         IF (CHIN(6:11) .NE. CCODE) WRITE(24, FMT=
     *       '('' Warning: input CIF file has incorrect CCODE'')')
         GOTO 190
         ENDIF
      IF (CHIN(1:13) .EQ.'_refln_F_calc') THEN
         WRITE(24, FMT='('' Input CIF file with Fobs values '')')
         GOTO 190
         ENDIF
      IF (CHIN(1:21) .EQ.'_refln_F_squared_calc') THEN
         WRITE(24, FMT='('' Input CIF file with Fobs**2 values '')')
         F2 = .TRUE.
         GOTO 190
         ENDIF
      IF (CHIN(1:21) .EQ.'_refln_intensity_calc') THEN
         CALL KERROR ('CIF file with intensities', 190, 'MEREAD')
         ENDIF
      IF (CHIN(1:23) .NE.'_refln_scale_group_code') GOTO 190
  310 IEND = 0
      GOTO (410,  420, 430,  440), IDNUM
  410 READ (IHKL, 415, END=418) IE, HKL, JC, FOBS, SIG
  415 FORMAT (A1, 3F3.0 ,I2, F9.2, F7.2)
      IF (IE .NE. 'E') RETURN
  417 CALL FILCLO (IHKL, 'KEEP')
      IEND = -1
      RETURN
  418 WRITE (9,FMT='(A)') ' Warning: sentinel E missing on FREF file !'
      GOTO 417
  419 WRITE (9,FMT='(A)') ' Warning: sentinel 000 missing on HKL file !'
      GOTO 417
  420 WRITE (9,FMT='(A)') ' CARD3 refl.file is obsolete !'
      STOP 420
  430 READ (IHKL, 435, END=419) HKL, FOBS, SIG
  435 FORMAT (3F4.0, 2F8.2)
      IF (ABS(HKL(1)) + ABS(HKL(2)) + ABS(HKL(3)) .LT. 0.1) GOTO 417
      IF (TRANS) THEN
         CALL KERNAB (HKL, HT, 3)
         DO 437 I = 1,3
         HKL(I) = 0.0
         DO 437 J = 1,3
  437    HKL(I) = HKL(I) + HT(J) * HH(I,J)
         ENDIF
      JC = 0
  438 IF (.NOT. F2) RETURN
      FOBS = AMAX1 (FOBS, SIG / 100. , 0.0001)
      FOBS = SQRT(FOBS)
      SIG  = SIG / (2. * FOBS)
      RETURN
  440 CALL KERINA( IHKL, LIT, 1, KEND)
      IF (KEND .NE. 0 .OR. CHIN(1:6) .EQ. '_publ_')  GOTO 417
      CALL KERNAB (FNUM, HKL, 3)
      FOBS = FNUM(4)
      SIG =  FNUM(5)
      GOTO 438
      END
      SUBROUTINE LOGMER (NREF, HMAX, HMIN, HKLMAX, STLMAX, SCALE, BOV)
      DIMENSION HMAX(3), HMIN(3), HKLMAX(3)
      INCLUDE 'Zsyst.inc'
      EQUIVALENCE (IDDL, IFILE(1))
      CALL LOGRD (IDDL, 'MERBSC', KLOG)
      IF (KLOG .LT. 0 .OR. LIT(2) .NE. 'SCALE') GOTO 188
      IF (NINT (10000.*SCALE) .NE. NINT(10000.*FNUM(2)) ) GOTO 188
      IF (NINT (1000.*BOV) .NE. NINT(1000.*FNUM(3)) ) GOTO 188
      CALL LOGRD (IDDL, 'NREF', KLOG)
      IF (KLOG .LT. 0 .OR. FNUM(2) .LT. 0.9) GOTO 188
      IF (NREF .NE. NINT(FNUM(2)) ) GOTO 188
      RETURN
  188 WRITE (CHOUT, 200) NREF, HMAX, HMIN
  200 FORMAT ('NREF ', I6, '    HMAX  ', 3F5.0, ' HMIN', 3F5.0)
      CALL LOGWR (IDDL)
      WRITE (CHOUT, 220) STLMAX, HKLMAX
  220 FORMAT ('STLMAX ', F7.5, ' HKLMAX', 3F5.0)
      CALL LOGWR (IDDL)
      WRITE (CHOUT, 230) SCALE, BOV
  230 FORMAT ('SCALE ', F14.7, ' BOV ', F10.5, 14X, ' MERBSC')
      CALL LOGWR (IDDL)
      RETURN
      END
      SUBROUTINE WILSIM
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zwils.inc'
      EQUIVALENCE (KEYWIL, KSTAT(17))
      PARAMETER  (NRS = 9)
      LOGICAL     SWIL
      DATA SWIL / .FALSE. /
      DATA  STLM2, FNRS3 / 0.0 , 0.0 /
      IF (SWIL) GOTO 180
      SWIL = .TRUE.
      KEYWIL =-1
      EPMIN = 9999.
      EPMAX =-9999.
      CALL KERNZI (0 , NOW, NRS)
      CALL KERNZI (0 , NUW, NRS)
      CALL KERNZA (0.,  AW, NRS)
      CALL KERNZA (0., AAW, NRS)
      CALL KERNZA (0.,  BW, NRS)
      FHMN = 0.
      FNRS3  = FLOAT(NRS+1)
      STLM2  = STLMAX**2
      BPINP = 2.0
      IF (NINT(10000.*BOV) .NE. 20000 ) BPINP = BOV
      BRINP = BPINP
      BPMAX = 10.
      BPMIN =  0.
      BRMAX = 10.
      BRMIN =  0.
  180 ISS = IFIX (STL * 400. + 1.5)
      FOBS = FOBS / EXPBR(ISS)
      CALL HKLEX1 (HKLX, HKLX)
      CALL HKLEX2 (HKLX, IDHKL, IEPS, IEPS2)
      EPSIL = FLOAT(IEPS)
      TUMF2 = SUMF2(ISS) * EPSIL
      K = (STL2/STLM2) * FNRS3 + 1.
      IF (K.GT.NRS) K = NRS
      NOW(K) = NOW(K) + 1
      IF (FOBS .LT. 5.*SIG)  NUW(K) = NUW(K) + 1
      FOBS = FOBS**2 / TUMF2 / ALATT
      AW(K) = AW(K)  + FOBS
      BW(K) = BW(K) + STL2
      RETURN
      END
      SUBROUTINE WRPEAK (KEY)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zbinx.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zatomx.inc'
      EQUIVALENCE (IDDL, IFILE(1))
      DIMENSION FBOV(5), RHO(10,5)
      EQUIVALENCE (FBOV, BFAC), (RHO, PHFAC)
      DIMENSION HKL(3)
      EQUIVALENCE (HKL(1), HKLX(1,1))
      PARAMETER (MAXA = 10000)
      COMMON /BLANK/ AREF(4, MAXA), DUMMY(120000)
      DIMENSION FH(5,10), FHSUM(5,10), FHSYS(5,10)
      DIMENSION IKSYS(3), ISYSAR(111)
      DIMENSION NWRP(100,2)
      DATA NCALL /0/
      IF (NCALL .EQ. 2) RETURN
      IF (KEY .GT. 0) GOTO 151
      IF (NCALL .EQ. 0) THEN
         CALL KERNZI (0, NWRP, 200)
         CALL WR24
         NCALL = 1
         ENDIF
      IPH = IFIX (STL * 100. + 1.5)
      IF (IPH .GT. 100) IPH = 100
      IF (FOBS .GT. 2. * SIG) THEN
         NWRP(IPH, 1) = NWRP(IPH, 1) + 1
      ELSE
         NWRP(IPH, 2) = NWRP(IPH, 2) + 1
         ENDIF
      RETURN
  151 CONTINUE
      STLPH = STLMAX
      IF (KEY .LT. 500) GOTO 166
      I1 = IFIX (STLMAX * 100. + 1.5) / 2
      DO 158 I = I1, 100
      IF (NWRP(I, 1) + NWRP(I, 2) .LT. 10) GOTO 158
      IF (NWRP(I, 1) .LT. NWRP(I, 2)) THEN
         STLPH = FLOAT(I-1) / 100.
         GOTO 166
         ENDIF
  158 CONTINUE
  166 CONTINUE
      CALL KERNZA (0., FH, 50)
      CALL KERNZA (0., FHSUM, 50)
      CALL KERNZA (0., RHO, 50)
      INREPS = 0
      IREFX = 0
  201 CONTINUE
      IREFX = IREFX + 1
      HCODE = FBINX(1,IREFX)
      FOBS = FBINX(2,IREFX)
      IF (FOBS .LT. 0.) GOTO 220
      SIG = FBINX(3,IREFX)
      CALL HKLC1U (HCODE, HKLX)
      CALL HKLSTL (HKLX, STL, STL2)
      ISS = IFIX (STL * 400. + 1.5)
      IF (STL .GT. STLPH) GOTO 201
      CALL HKLEX1 (HKLX, HKLX)
      CALL HKLEX2 (HKLX, IDHKL, IEPS, IEPS2)
      EPSIL = FLOAT(IEPS)
      DO 205 I = 1,5
      FACBOV = I-3
      FBOV(I) = BOV + FACBOV * 0.1 * BOV
      EXPBOV = EXP(- FBOV(I) * STL2)
      DO 205 J = 1,NTYPE
      FH(I,J) = FF(ISS,J) * EXPBOV
      FHSUM(I,J) = FHSUM(I,J) + (FH(I,J)/EPSIL)
      IF (EPSIL.GT.1.01) INREPS = INREPS + 1
  205 CONTINUE
      INREPS = INREPS / 5
      GOTO 201
  220 CALL KERNZA (0.,FHSYS,50)
      CALL KERNZI (0,ISYSAR,111)
      IF (ISYST.EQ.1) GOTO 230
      IF (ISYST.EQ.2) THEN
         CALL KERNZI (0,IKSYS,3)
         IKSYS(IUNIQ)=1
         CALL SYSEX (IKSYS,    FHSYS,ISYSAR, STLPH)
         CALL KERNZI (1,IKSYS,3)
         IKSYS(IUNIQ)=0
         CALL SYSEX (IKSYS,  FHSYS,ISYSAR, STLPH)
         ENDIF
      IF (ISYST.EQ.3) THEN
         DO 225 IC = 1,3
         CALL KERNZI (1,IKSYS,3)
         IKSYS(IC) = 0
         CALL SYSEX (IKSYS,  FHSYS,ISYSAR, STLPH)
  225    CONTINUE
         ENDIF
      IF (ISYST.GE.4) THEN
         CALL KERNZI (1,IKSYS,3)
         CALL SYSEX (IKSYS,  FHSYS,ISYSAR, STLPH)
         ENDIF
  230 FMULTT = FLOAT( 2 * NSYMM * NLATT )
      DO 240 I = 1, 5
      DO 240 J = 1, NTYPE
      RHO(J,I) = (FLOAT(IZTYPE(J)) +
     *   ((FMULTT * FHSUM(I,J)) + (2. * FHSYS(I,J)))  )/ VOLUM
  240 CONTINUE
      WRITE (8, FMT='(/'' WRPEAK: expected atomic peak heights'',
     *       '' for five isotropic B values:''/)')
      WRITE (8,FMT='(''    for B =   '',5F7.3/
     *      '' Atom         '', 35(''-'')) ') FBOV
      DO 260 J = 1,NTYPE
      WRITE(8,FMT='('' Type'',I2,3X,A2,1X,5F7.2)') J,CELATY(J),
     *         (RHO(J,I), I=1,5)
  260 CONTINUE
      WRITE(8,FMT='(/'' Type   h  k  l   nr of syst.ext. refl'',/
     *                 '' --------------   for hemisphere H > 0'')')
      DO 270 I=0,1
      DO 270 J=0,1
      DO 270 K=0,1
      IKCODE = (100*I)+(10*J)+K
      IF (IKCODE.EQ.0) GOTO 270
      IF (ISYSAR(IKCODE) .GT. 0)
     *   WRITE (8,265)I,J,K,ISYSAR(IKCODE)
  265 FORMAT (' Refl:',3I3,I10)
  270 CONTINUE
      WRITE(8,FMT='(/'' Nr refl. with Epsilon>1.0 :'', I6)') INREPS
      NCALL = 2
      RETURN
      END
      SUBROUTINE SYSEX (IKSYS,   FHSYS,ISYSAR, STLPH)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zatomx.inc'
      EQUIVALENCE (IDDL, IFILE(1))
      DIMENSION HKL(3), FH(5,10), FHSYS(5,10)
      DIMENSION IHMAXT(3), IKSYS(3), ISYSAR(111)
      CALL KERNZA (0., FH, 50)
      DO 200 I=1,3
      IF (IKSYS(I).EQ.0) THEN
         IHMAXT(I) = 0
      ELSE
         IHMAXT(I) = NINT(HKLMAX(I)) - 1
         ENDIF
  200 CONTINUE
      STLMT = AMIN1 (0.90 * STLMAX, STLPH)
      DO 229 IH=0,IHMAXT(1)
      IF ((ISYST.EQ.3).AND.(IH.EQ.0)) THEN
         IF ((IKSYS(2).EQ.0).OR.(IKSYS(3).EQ.0)) GOTO 229
         ENDIF
      HKL(1)=IH
      DO 228 IK=-IHMAXT(2),IHMAXT(2)
      IF ((ISYST.EQ.3).AND.(IKSYS(3).EQ.0).AND.(IK.EQ.0)) GOTO 228
      HKL(2)=IK
      DO 227 IL=-IHMAXT(3),IHMAXT(3)
      HKL(3)=IL
      CALL HKLSTL (HKL, STL, STL2)
      IF (STL.GT.STLMT) GOTO 227
      ISS = IFIX (STL * 400. + 1.5)
      CALL HKLC1(HKL,HCODE)
      CALL HKLAXT (HKL, KEND)
      IF (KEND.LT.0) GOTO 227
      CALL HKLEXT (HKL, KEND)
      IF (KEND.LT.0) THEN
         IKCODE = 0
         IF (NINT(HKL(1)).NE.0) IKCODE = IKCODE + 100
         IF (NINT(HKL(2)).NE.0) IKCODE = IKCODE + 10
         IF (NINT(HKL(3)).NE.0) IKCODE = IKCODE + 1
         ISYSAR(IKCODE) = ISYSAR(IKCODE) + 1
         DO 223 I = 1,5
         FACBOV = I-3
         BOVMOD = BOV + FACBOV * 0.1 * BOV
         EXPBOV = EXP(- BOVMOD * STL2)
         DO 223 J = 1,NTYPE
         FH(I,J) = FF(ISS,J) * EXPBOV
         FHSYS(I,J) = FHSYS(I,J) + FH(I,J)
  223    CONTINUE
         ENDIF
  227 CONTINUE
  228 CONTINUE
  229 CONTINUE
      RETURN
      END
      SUBROUTINE WILPAR
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      LOGICAL SWIPRI
      EQUIVALENCE (SWIPRI, SWITCH(10))
      EQUIVALENCE (KEYWIL, KSTAT(17))
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zwils.inc'
      CALL WR24
      IF (KEYWIL.EQ.4) RETURN
      IF (.NOT. SWIPRI) GOTO 220
      IF (KEYWIL.NE.-1) THEN
         WRITE (8, 200)
  200    FORMAT(/ ' Data for WILSON-PARTHASARATHY plot:', /,
     *          ' Range  NOBS NUNOBS  <FO2/F2>  <(FP2+F2R)/F2>  STL2 ',
     *          ' ln<FO2/(FP2+F2R)>')
      ELSE
         WRITE (8, 210)
  210    FORMAT(/ ' Data for WILSON plot:', /,
     *          ' Range  NOBS NUNOBS  <FO2/F2>  STL2  ln<FO2/F2>')
         ENDIF
  220 NRS = 9
      NNOW = 0
      DO 230 I=1,NRS
  230 NNOW = NNOW + NOW(I)
      IF (NNOW.GT. 399) GOTO 250
      J = 0
      DO 240 I=1,(NRS-1),2
      J = J + 1
      NOW(J) = NOW(I) + NOW(I+1)
      NUW(J) = NUW(I) + NUW(I+1)
      AW(J)  = AW(I)  + AW(I+1)
      AAW(J) = AAW(I) + AAW(I+1)
  240 BW(J)  = BW(I)  + BW(I+1)
      NOW(J) = NOW(J) + NOW(NRS)
      NUW(J) = NUW(J) + NUW(NRS)
      AW(J)  = AW(J)  + AW(NRS)
      AAW(J) = AAW(J) + AAW(NRS)
      BW(J)  = BW(J)  + BW(NRS)
      NRS = J
  250 I = 1
  260 IF (NNOW.GT.399 .AND. NOW(I).GT.25) GOTO 280
      IF (NNOW.LE.399 .AND. NOW(I).GT.NNOW/20) GOTO 280
      NRS = NRS - 1
      IF (I.GT.NRS) GOTO 320
      DO 270 J=I,NRS
      NOW(J) = NOW(J+1)
      NUW(J) = NUW(J+1)
      AW(J)  = AW(J+1)
      AAW(J) = AAW(J+1)
  270 BW(J)  = BW(J+1)
      GOTO 260
  280 AW(I)  = AW(I)  / NOW(I)
      AAW(I) = AAW(I) / NOW(I)
      BW(I)  = BW(I)  / NOW(I)
      IF (AAW(I).LT.0.001 .OR. KEYWIL.EQ.-1) AAW(I) = 1.0
      IF (AW(I) .LT. 0.0001) AW(I) = 0.0001
      X1 = ALOG(AW(I) / AAW(I))
      IF (.NOT. SWIPRI) GOTO 310
      IF (KEYWIL.NE.-1) THEN
          WRITE (8, 290) I, NOW(I), NUW(I), AW(I), AAW(I), BW(I), X1
  290     FORMAT (1X, I3, I8, I5, F11.4, F13.4, F11.4, F13.4)
      ELSE
          WRITE (8, 300) I, NOW(I), NUW(I), AW(I), BW(I), X1
  300     FORMAT (1X, I3, I8, I5, F11.4, F8.4, F10.4)
          ENDIF
  310 AW(I) = X1
      I = I + 1
      IF (I.LE.NRS)  GOTO 260
  320 IF (NRS.LE.1)  THEN
          WRITE(24, 330) NRS
          WRITE (8, 330) NRS
  330     FORMAT (' WILSON-PARTHASARATHY plot not possible, number of',
     *            ' ranges: ', I3)
          RETURN
          ENDIF
      IF (KEYWIL .NE. -1) THEN
         WRITE (8, 339)  BP, BR
  339    FORMAT (/' Input values for WILSON-PARTHASARATHY',
     *           ' plot: Bp=', F7.3, '  Br=', F7.3/)
         WRITE (8, 340)
  340    FORMAT (/' WILSON-PARTHASARATHY plot '/
     *            ' LN <FO**2/(FP**2+F2R)>')
         WRITE(24, FMT='(/ A)') ' WILSON-PARTHASARATHY plot results'
      ELSE
         WRITE (8, FMT='('' Input values for WILSON plot:  '',
     *     '' Overall B ='',F7.3,''  Scale SC ='',F9.5/)') BOV, SCALE
         WRITE (8, 350)
  350    FORMAT (' WILSON plot' / ' LN <FO**2/F2>')
         ENDIF
      CALL WILDUP (AW, BW, NOW, NUW, NRS, C, S)
      SCALET = EXP(-0.5 * C)
      IF (SCALET .LT. 0.001) THEN
         WRITE (24, FMT='('' WIL-PAR Scale:'', F10.6,
     *      '' not accepted '')') SCALET
         WRITE (8, FMT='('' $TE SCALE W.P.x'',I3,2F6.3,F8.4,12X, I5 )')
     *       NRECYR, PSQ, R2X, SCALET, KEYWIL
         RETURN
         ENDIF
      IF (KEYWIL .NE. -1) THEN
         SCALE = SCALET
      ELSE
         IF (NINT(10000.*SCALE) .EQ. 10000 ) THEN
            SCALE = SCALET
         ELSE
            KEYWIL = -4
         WRITE (24, FMT='('' CONDAT Scale:'', F8.4,
     *      '' retained '')') SCALE
            ENDIF
         ENDIF
      BD = -0.5 * S
      BPT = BP + BD
      IF (BPT .GT. 25. .OR. BPT .LE. 0.001) THEN
         WRITE (24, FMT='('' WIL-PAR Scale+Bov:'', F8.4, F7.3,
     *      '' not accepted '')') SCALE, BPT
      WRITE (8, FMT='('' $TE SCALE W.P.x'',I3,2F6.3,F8.4, 12X, I5)')
     *       NRECYR, PSQ, R2X, SCALE, KEYWIL
         IF (KEYWIL .EQ. -4) KEYWIL = -1
         RETURN
         ENDIF
      WRITE (8, FMT='('' $TE SCALE W.P. '',I3,2F6.3,F8.4, ''  Bov='',
     *   F6.3, I5)')  NRECYR, PSQ, R2X, SCALE, BPT, KEYWIL
      IF (KEYWIL .EQ. -1  .OR. KEYWIL .EQ. -4) THEN
         IF (NINT(10000.*BOV) .EQ. 20000 ) THEN
            BOV = BPT
         ELSE
            WRITE (24, FMT='('' CONDAT B-0v: '', F8.4,
     *         '' retained '')') BOV
            ENDIF
         WRITE (24, 360) SCALE, BOV
  360    FORMAT (/' Wilson scale and overall temperat. factor:',
     *          '  Scale=', F9.5, '  Bov=', F6.3)
         IF (KEYWIL .EQ. -4) KEYWIL = 4
         IF (KEYWIL .EQ. -1) KEYWIL = 0
         SCAMER = SCALE
         BOVMER = BOV
         RETURN
      ELSE
         IF (ABS(BP - BR) .LT. 0.0001) THEN
            BP = BPT
            BR = BP
            WRITE (24, 370) SCALE, BP
  370          FORMAT (/' WIL-PAR  Scale and Bov-value:   Scale=',
     *          F9.5, '  Bov=', F6.3)
         ELSE
            BRT = BR + BD
            WRITE (24, 372) SCALE, BRT
  372 FORMAT (/' WIL-PAR  Scale =',
     *          F9.5, ' (but new Bov=', F6.3, ' is ignored)')
            ENDIF
         ENDIF
      RETURN
      END
      SUBROUTINE WILDUP (Y, X, NOW, NUW, N, C, S)
      DIMENSION X(N), Y(N), NOW(N), NUW(N)
      INCLUDE 'Zsyst.inc'
      LOGICAL SWIPRI
      EQUIVALENCE (SWIPRI, SWITCH(10))
      DIMENSION YAXIS(6), XAXIS(6)
      CHARACTER * 1  BLANK, STAR, CH(78)
      DATA BLANK, STAR / ' ', '*' /
      SY  = 0.0
      SYY = 0.0
      SX  = 0.0
      SXX = 0.0
      SXY = 0.0
      YMIN = Y(1)
      YMAX = YMIN
      XMAX = X(N) * 1.125
      WWW = 0.
      DO 150  I=1,N
      WW = MAX0 (1, NOW(I) - NUW(I) )
      WWW = WWW + WW
      IF (Y(I).LT.YMIN)  YMIN = Y(I)
      IF (YMAX.LT.Y(I))  YMAX = Y(I)
      SY  = SY  + WW * Y(I)
      SYY = SYY + WW * Y(I)**2
      SX  = SX  + WW * X(I)
      SXX = SXX + WW * X(I)**2
  150 SXY = SXY + WW * X(I)*Y(I)
      S = (SY*SX - WWW*SXY) / (SX*SX - WWW*SXX)
      C = (SY - S*SX) / WWW
      YSCAL = 0.2 * (YMAX-YMIN)
      YMAX = YMAX + YSCAL
      YMIN = YMIN - YSCAL
      YSCAL = YMAX - YMIN
      YFAC = 20./YSCAL
      XFAC = 80./XMAX
      YAXIS(1) = YMAX
      XAXIS(1) = 0.00001
      DO 210  I=2,6
      FI1 = FLOAT(I-1)
      XAXIS(I) = XMAX/5.0*FI1
  210 YAXIS(I) = YMAX - (YSCAL/5.*FI1)
      CALL KERNZ1 (STAR, CH, 78)
      WRITE (8, 220)  STAR, YAXIS(1), (CH(II),II=7,78)
  220 FORMAT (' ', A1, F5.2, ' ', 72A1)
      M = 2
      DO 260  I=2,19
      FI20 = FLOAT(20 - I)
      CALL KERNZ1 (BLANK, CH, 78)
      CH(1) = '*'
      L  = ((YMIN + (YSCAL*  FI20)     /20.) -C)/S*XFAC + 0.5
      L1 = ((YMIN + (YSCAL* (FI20-1.)) /20.) -C)/S*XFAC + 0.5
      IF (L.GT.0 .AND. L.LE.78) CH(L) = '.'
      IF (ABS(L1-L).LE.5) GOTO 229
      IF (S.LT.0.00001) THEN
          I1 = L + 3
          I2 = L1 - 3
      ELSE
          I1 = L1 + 3
          I2 = L - 3
          ENDIF
      IF (I1.LE. 1) I1 = 2
      IF (I2.GT.78) I2 = 78
      DO 225 I12=I1,I2,3
  225 CH(I12) = '.'
  229 DO 230  J=1,N
      K = (Y(J)-YMIN)*YFAC + 0.5 + FLOAT(I)
      L = X(J)*XFAC + 0.5
      IF (K.EQ.20 .AND. L.LE.78)  CH(L) = 'X'
      IF (K.EQ.20 .AND. L.GT.78)  CH(78)= '+'
  230 CONTINUE
      IF (I/4*4.EQ.I)  GOTO 250
      WRITE (8, 240)  CH
  240 FORMAT (1H , 78A1)
      GOTO 260
  250 WRITE (8, 220)  STAR, YAXIS(M), (CH(II), II=7,78)
      M = M + 1
  260 CONTINUE
      CALL KERNZ1 (STAR, CH, 78)
      WRITE (8, 220)  STAR, YAXIS(6), (CH(II), II=7,78)
      WRITE (8, 270)  (XAXIS(II), II=2,6)
  270 FORMAT (F15.3, 4F16.3)
      WRITE (8, 280)
  280 FORMAT (60X, '(sinTHETA/LAMBDA)**2')
      IF (SWIPRI)  WRITE (8, 290) N, S, C
  290 FORMAT (/' Line based on', I10, ' points,    slope is ', F10.4, /
     *        ' intercept is ', F10.4)
      RETURN
      END
      SUBROUTINE HKLSYX (ISYST, HMAX, HMIN, HKMAX, HKLMAX)
      DIMENSION HMAX(3), HMIN(3), HKLMAX(3)
      DO 280 I=1,3
  280 HKLMAX(I) = AMAX1 (ABS(HMAX(I)), ABS(HMIN(I)) )
      IF (ISYST.LE.3) RETURN
      IF (HKMAX .GT. 99) HKMAX = 99
      IF (ISYST.EQ.6 .OR. ISYST.EQ.7)
     *                HKLMAX(1) = AMAX1 (HKLMAX(1), HKMAX)
      IF (ISYST.EQ.5 .OR. ISYST.EQ.8)
     *                HKLMAX(1) = AMAX1 (HKLMAX(1), HKLMAX(3))
      HKLMAX(1) = AMAX1 (HKLMAX(1),HKLMAX(2))
      HKLMAX(2) = HKLMAX(1)
      IF (ISYST.EQ.5 .OR. ISYST.EQ.8) HKLMAX(3) = HKLMAX(1)
      RETURN
      END
       SUBROUTINE FOUR
      INCLUDE 'Zaaaa.inc'
      EQUIVALENCE (IDOKA, KEYS(10)), (IRUN, KSTAT(13))
      PARAMETER (KUSER2=30000, KUSER1=KUSER2/3)
      CALL KEPROG('FOUR')
      WRITE(24, FMT = '(65X, ''RUN'', I4)') IRUN
      IF ( MPAT .NE. 0 .AND. MPAT .NE. -99) THEN
         WRITE(24, FMT = '(59X, ''atoms set'', I4)') IPAT
         ENDIF
      CALL FFTIN(KUSER1)
      CALL PP1
      CALL SEARCH
      IF (IDOKA .EQ. 17) RETURN
      CALL KEPROX
      RETURN
      END
      SUBROUTINE FFTIN (KUSER1)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zsear.inc'
      INCLUDE 'Zbuff.inc'
      EQUIVALENCE (ICRYS, IFILE(3)), (ICOND, IFILE(4))
      EQUIVALENCE (IBINFF, IFILE(16)), (IFMAP,  IFILE(17))
      EQUIVALENCE (ISCRA,  IFILE(18))
      EQUIVALENCE (KEYDS, KSTAT(20))
      EQUIVALENCE (KEYS(28), IHALF)
      LOGICAL      SWPRI, PRIMAP, SWRECY, NORECY
      EQUIVALENCE (SWRECY, SWITCH(7)), (NORECY, SWITCH(8))
      EQUIVALENCE (SWPRI, SWITCH(10)), (PRIMAP, SWITCH(11))
      EQUIVALENCE (IMAP, KSTAT(7))
      COMMON /FFTDA/ SCALEW, MH(3), NPP(3), XLMIN(3), XLMAX(3)
      DIMENSION IGM3(3)
      PARAMETER (LCMAX = 16)
      CHARACTER * 6 LCONDA(LCMAX)
      DATA LCONDA / 'FOUR',   'PRIMAP', 'GRID' , 'MAXXYZ', 'MINXYZ',
     *              'MAXHKL', 'GRIDMO', 'PEAKS', 'PROJEC', 'DOUT',
     *              'DMIN',   'DMAX',   'AMIN',  'AMAX',   'dummy$',
     *              'NORECY'/
      CALL WR24
      IACTOR  = 0
      FACTOR  = 0.25
      CALL KERNZA (0.0, XLMIN, 3)
      CALL KERNZA (1.0, XLMAX, 3)
      IGM3(1) = 1
      IGM3(2) = 1
      IGM3(3) = 2
      NPIC = 0
      NATIN = 0
      DMOUT = -1.
      DMINB = -1.
      DMAXB = -1.
      ANGM(1) = -1.
      ANGM(2) = -1.
      NAT = 0
      NATREC = 0
      NATX = 0
      NATSN = 0
  85  CALL RDCOND (ICOND, LCONDA, LCMAX , KEND)
      IF (KEND.LE.0) GOTO 101
      GOTO (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 85, 16), KEND
  1   CONTINUE
      GOTO 85
  2   PRIMAP = .TRUE.
      GOTO 85
  3   FACTOR = FNUM(1)
      IACTOR  = 1
      GOTO 85
  4   XLMAX(1) = AMIN1 (FNUM(1), 1.0)
      XLMAX(2) = AMIN1 (FNUM(2), 1.0)
      XLMAX(3) = AMIN1 (FNUM(3), 1.0)
      GOTO 85
  5   XLMIN(1) = AMAX1 (FNUM(1), 0.0)
      XLMIN(2) = AMAX1 (FNUM(2), 0.0)
      XLMIN(3) = AMAX1 (FNUM(3), 0.0)
      GOTO 85
   6   GOTO 85
  7   DO 707 I=1,3
      IF (FNUM(I).GE.1.0) IGM3(I) = NINT (FNUM(I))
      IF (IGM3(I).EQ.5 .OR. IGM3(I).GE.7)
     *    CALL KERROR ('BAD GRIDMO CARD', 6, 'FFTIN')
  707 CONTINUE
      GOTO 85
  8   NPIC = IFIX(FNUM(1))
      GOTO 85
  9   NATIN = IFIX(FNUM(1))
      GOTO 85
  10  DMOUT = FNUM(1)
      GOTO 85
  11  DMINB = FNUM(1)
      GOTO 85
  12  DMAXB = FNUM(1)
      GOTO 85
  13  ANGM(1) = FNUM(1)
      GOTO 85
  14  ANGM(2) = FNUM(1)
      GOTO 85
  16  NORECY = .TRUE.
      GOTO 85
  101 CALL FILCLO (ICOND, 'KEEP')
      WRITE (8, FMT='('' Option IMAP = '', I2)') IMAP
      IF (R2X .GT. 0.001 .AND. R2X .LT. 99.) THEN
         WRITE (24, FMT='(48X, '' ----------   R2 ='', F6.3)') R2X
         ENDIF
      CALL FILINQ (ISCRA, 'BINBIG', 'UNFORMATTED', 'OUTPUT', KINQ)
      IF (IMAP .NE. 5) THEN
         CALL FILINQ (IFMAP, 'FMAP',  'UNFORMATTED', 'OUTPUT', KINQ)
      ELSE
         CALL FILINQ (IFMAP, 'FMAPT', 'UNFORMATTED', 'OUTPUT', KINQ)
         ENDIF
      CALL KERF2I (HKLMAX, MH, 3)
      CALL RDCRYS (ICRYS)
      IHALF = 0
      GOTO (110, 120, 130, 130, 215, 120), IMAP
      STOP 302
  110 WRITE (24,111) CCODE
  111 FORMAT (' Fourier in space group P1 for compound ', A6)
      IF (ILATT.NE.1) WRITE (24, 112)
  112 FORMAT ('+', 47X, 'in non-promitive setting')
      NSYMM = 1
      IMULT = NLATT
      ICENT = 1
      ILAUE = 1
      NORECY = .TRUE.
      SWRECY = .FALSE.
      GOTO 190
  120 ICENT = 2
      IMULT = NSYMM * ICENT * NLATT
      CALL KERNZA(0.0, TSYMM, 72)
      IF (IMAP .EQ. 2) WRITE (24, 121)
  121 FORMAT (1X/' PATOR: sharpened Patterson for program ORIENT')
      IF (IMAP .EQ. 6) WRITE (24, 122)
  122 FORMAT (1X/' Sharpened Patterson for program PATTY')
      IF (ILAUE.EQ.2 .AND. IUNIQ.EQ.3) GOTO 220
      IF (ILAUE.EQ.1 .OR. ILAUE.EQ.4) GOTO 220
      IF (ILAUE.GE.6 .AND. ILAUE.LE.12) GOTO 220
      IHALF = -1
      GOTO 220
  130 IF (ICENT.EQ.2) THEN
         IHALF = -1
         GOTO 220
         ENDIF
  190 GOTO (192,191,192,191,191,191,191), ILATT
  191 IHALF = 1
      GOTO 220
  192 IF (IMAP.EQ.1) GOTO 220
      DO 197 II=1,NSYMM
      IF (IRSYMM(2,2,II).EQ.-1 .AND. TSYMM(2,II).LT.0.01) IHALF = -1
  197 IF (IRSYMM(2,2,II).EQ.1 .AND. (ABS(TSYMM(2,II)-0.5)).LT.0.01)
     *   IHALF = 1
      GOTO 220
  215 CONTINUE
      CALL KERROR (' IMAP=5 not accepted!', 215, 'FFTIN')
  220 IF (IACTOR .EQ.1) GOTO 230
      IF (IMAP .NE. 2 .AND. IMAP .NE. 6) GOTO 223
      IF (VOLUM .LE. 4000.) GOTO 223
      RESOL = ALOG(VOLUM/4000.) / 3.
      RESOL = 0.3 * EXP(RESOL)
      IF (RESOL.LT.FACTOR) GOTO 223
      FACTOR = RESOL
      WRITE (8, 222) FACTOR
  222 FORMAT (' The GRID spacing is approximately', F6.3, ' Angstrom')
  223 RESOL = AMIN1 (CELL(1) / FLOAT(MH(1)),
     +               CELL(2) / FLOAT(MH(2)),
     +               CELL(3) / FLOAT(MH(3))) * 0.25
      IF (RESOL .GE. FACTOR) THEN
         IF (RESOL .LT. FACTOR + 0.06) RESOL = FACTOR + 0.01
         IF (RESOL .GE. FACTOR + 0.06) RESOL = RESOL - 0.05
         FACTOR = RESOL
         WRITE(24, 222) FACTOR
         ENDIF
  230 IF (IHALF.NE.0 .AND. IGM3(3).EQ.1) IGM3(2) = 2
  240 DO 241 I=1,3
  241 NPP(I) = CELL(I) / FACTOR + 0.5
      DO 280 I=1,3
      ISGG = MOD (NPP(I), IGM3(I))
      IF (ISGG.NE.0) NPP(I) = NPP(I) + IGM3(I) - ISGG
  250 NTEST = NPP(I)
      DO 270 J=2,5
  260 IF (NTEST.NE.(NTEST/J)*J) GOTO 270
      NTEST = NTEST / J
      IF (NTEST.EQ.1) GOTO 280
      GOTO 260
  270 CONTINUE
      NPP(I) = NPP(I) + IGM3(I)
      GOTO 250
  280 CONTINUE
      WRITE (8, 222) FACTOR
      IF (NPP(1) .LE. 250) GOTO 400
      WRITE (8, 320)
  320 FORMAT (' NX GREATER THAN 250 (SEE SUBR. -OUTPUT-). RESET.'/)
      FACTOR = FACTOR * FLOAT(NPP(1)) / 245.
      GOTO 240
  400 I = (NPP(1)+2) * (NPP(3)+2)
      IF (I.LT.KUSER1) GOTO 406
      FACTOR = FACTOR * 1.02 * SQRT(FLOAT(I)/FLOAT(KUSER1))
      WRITE(24, 405)
      WRITE (8, 405)
  405 FORMAT (' TOO MANY GRID POINTS FOR PEAK SEARCH. RESET.'/)
      GOTO 240
  406 WRITE (8, 407) MH, NPP
  407 FORMAT (
     + ' Maximum indices allowed   h:', I4, '    k:', I4, '    l:', I4/
     + ' Number of grid points    Nx:', I4, '   Ny:', I4, '   Nz:', I4)
      DO 408 I = 1,3
      IF (NPP(I) .GE. 2 * MH(I) + 2) GOTO 408
      MH(I) = NPP(I) / 2 -1
      WRITE (8, FMT='(/'' Reset MAXHKL:'')')
      GOTO 406
  408 CONTINUE
      IF (SWPRI .AND. PRIMAP) WRITE (8, 410) XLMAX
  410 FORMAT (' FOURIER MAP TO BE PRINTED FROM:'/' X =  0.0  TO',
     +         F7.3,',  Y =  0.0  TO',F7.3,',  Z =  0.0  TO',F7.3)
      RETURN
      END
      SUBROUTINE SEARCH
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zsear.inc'
      COMMON /BLANK/ IFRAG(MAXAT), ISYM(MAXAT),     IDUM(MAXAT),
     *               DUM(MAXAT),   IBOND(MAXAT*10), JBOND(MAXAT*10),
     *               XXXGEO(135520)
      COMMON /SIZEX/ KFRAG(20), NFRAG, LFRAG(20), NOFRAG, NNA
      COMMON /DIRBFA/ NCELTY(10), NCELLZ(10), NCELIN(10), NCELIX(10)
      COMMON /DIRBFB/ ACELTY(10)
      CHARACTER ACELTY *2
      EQUIVALENCE (IATOMS, IFILE(1))
      EQUIVALENCE (IFMAP, IFILE(17))
      EQUIVALENCE (IDOKA, KEYS(10)), (KEYS(28), IHALF)
      LOGICAL SWRECY, NORECY, DMAXCH
      EQUIVALENCE (SWRECY, SWITCH(7)), (NORECY, SWITCH(8))
      EQUIVALENCE (SWITCH(28), DMAXCH)
      EQUIVALENCE (IMAP, KSTAT(7))
      CHARACTER SYMB(10) *2
      EQUIVALENCE (CHIN, SYMB(1))
      DIMENSION  XLOCK(3), CELPAR(10), BUFFOX(10)
      CALL WR24
      CALL GEOFOB (0, 0, 0.)
      IPRY = 24
      SCALAT = 0.
      NPROJ  = 2
      IF (NATIN .GT. 0) THEN
         IF (NATIN.EQ.1 .OR. NATIN.EQ.3) NPROJ = NATIN
         NATIN = 0
         ENDIF
      NPC = MIN0 (NPIC, MAXAT-50)
      IF (DMAXB .LT. 0.) THEN
         DMAXB  = 1.95
      ELSE
         IF (DMAXB .GT. 1.95) DMAXCH = .TRUE.
         ENDIF
      IF (ANGM(1) .LT. 0.) ANGM(1) = 80.0
      IF (ANGM(2) .LT. 0.) ANGM(2) = 145.0
      IF (DMINB .LT. 0.) DMINB = 0.90
      IF (DMOUT .LT. 0.) DMOUT = 2.40
      DMPIC  = 0.85
      REWIND IFMAP
      READ (IFMAP) SCALOR, IMAP, IHALF
      WRITE (8, FMT='('' OPTION IMAP = '', I2)') IMAP
      IF (IMAP .LE. 0 .OR. IMAP .EQ. 5 .OR. IMAP.GE.7) CALL KERROR
     *  ('Error reading output Fourier map for search', 0, 'SEARCH')
      IF (IMAP .EQ. 2) GOTO 120
      IF (IMAP .NE. 6) THEN
         CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'INPUT', KINQ)
         IF (KINQ.NE.0) CALL KERROR ('No atoms file found', 0, 'SEARCH')
      ELSE
         CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'OUTPUT', KINQ)
         ENDIF
  120 IF (IMAP.EQ.2 .OR. IMAP.EQ.6) GOTO 190
      CALL ATOMIN (IATOMS, ATXYZ, ATNAME, IZAT, MAXAT, NATIN, KEYT)
      REWIND IATOMS
      IF (NFNUM .GT. 0 .AND. NLIT .GT. 0) THEN
         IF (LIT(NLIT). EQ. 'SC=' .AND.
     *      FNUM(NFNUM) .GT. 0.0001) SCALAT = FNUM(NFNUM)
         ENDIF
      NATQ = NATIN
      NATH = 0
      N = 1
  131 CONTINUE
      IF (NRECYR.NE.0 .AND.ATNAME(N)(1:1).EQ.'H'.AND.IZAT(N).EQ.1) THEN
         NATH = NATH + 1
         ATNAME(N)(1:1) = 'Q'
         ENDIF
      IF (ATNAME(N)(1:1) .EQ. 'Q') THEN
         IF (N .EQ. NATIN) GOTO 135
         DO 133 N1 = N, NATIN - 1
         CALL KERNAB (ATXYZ(1,N1+1), ATXYZ(1,N1), 10)
         ATNAME(N1) = ATNAME(N1+1)
  133    IZAT(N1) = IZAT(N1+1)
  135    NATIN = NATIN - 1
         N = N - 1
         ENDIF
      N = N + 1
      IF (N .LE. NATIN) GOTO 131
      IF (NATIN.LT.NATQ) THEN
         NATQ = NATQ - NATIN - NATH
         IF (NATH .GT. 0) WRITE (8, FMT=
     *      '('' Nr of H atoms rejected:'', I3)') NATH
         IF (NATH .GT. 0) WRITE (8, FMT=
     *      '('' Nr of Q-atoms (= peaks) rejected:'', I3)') NATQ
         IF (NATIN.LE.0) CALL KERROR ('No atoms left!', 135, 'SEARCH')
         WRITE (8, FMT='(1X)')
         ENDIF
      IF (KSTAT(1) .NE. 12357) GOTO 7167
      IF (NRECYR .LE. 1) GOTO 7167
      CALL KERNZI (0, IZTYPE, 10)
      DO 7157 J=1,NTYPE
      CALL ATOMIZ (CELATY(J), NLET, IZ)
      IZTYPE(J) = IZ
 7157 CONTINUE
      CALL KERNZA (0.0, CELPAR, 10)
      DO 7161 I=1,NATIN
      DO 7160 J=1,NTYPE
      IF (IZAT(I).NE.IZTYPE(J)) GOTO 7160
      CELPAR(J) = CELPAR(J) + ATXYZ(4,I) * AMULT
 7160 CONTINUE
 7161 CONTINUE
      IIII = 0
      DO 136 J=1,NTYPE
      IF ( ( IZTYPE(J) .GE. 10 .AND. CELPAR(J) .GT. CELALL(J)
     *       .AND. NRECYS .GE. 6 ) .OR.
     *     ( IZTYPE(J) .GE. 2 .AND. CELPAR(J) .GT. CELALL(J)
     *       .AND. NRECYR .GE. 8) ) THEN
         CELALL(J) = CELPAR(J)
         IIII = 1
         ENDIF
  136 CONTINUE
      IF (IIII .EQ. 0) GOTO 7167
      DO 7165 I=1,NTYPE
 7165 BUFFOX(I) = CELALL(I) / ZET
      I = NTYPE
      J = NINT(ZET)
      WRITE(24, 7166) J, (CELATY(K), BUFFOX(K), K=1,I)
 7166 FORMAT (/' NOTE: Cell Contents reset [ output DDMAIN! ] :'/
     *  ' Z:', I3 / ' FORMUL:', 6(2X,A2,F6.1) /
     *                           ( 8X, 6(2X,A2,F6.1))/)
 7167 CONTINUE
      CALL CELZAT (ACELTY, NCELTY, NCELLZ)
      CALL CELZIN (ATXYZ, IZAT, NATIN, NCELLZ, NCELIN)
      WRITE (8, FMT='('' = symmetry included ='')')
      CALL KERNZI (0, NCELIX, 10)
      DO 137 I = 1, NTYPE
      NCELIX(I) = NCELTY(I)
  137 CONTINUE
      WRITE(24, 139) NATIN
  139 FORMAT (/' Number of atoms input:',I5)
      NATTR = 0
      NATTH = 0
      NATTHA= 0
      NATR = 0
      NATH = 0
      DO 140 I=1,NTYPE
      IF (NCELLZ(I) .NE. 1) THEN
         NATTR = NATTR + NCELTY(I)
         NATR = NATR + NCELIN(I)
         IF (NCELLZ(I) .GT. 40) NATTHA = NATTHA + NCELTY(I)
      ELSE
         NATTH = NATTH + NCELTY(I)
         NATH = NATH + NCELIN(I)
         ENDIF
  140 CONTINUE
      IF (NATTHA .GE. 1) NATTHA = NATTR / NATTHA
      IF (NATH .GT. 0) THEN
         NATR = NATR + NATH
         NATTR = NATTR + NATTH
         ENDIF
      NATX = MAX0(0, (NATTR - NATR)/IMULT)
      IF (NRECYR .GE. 3) THEN
         DO 147 I = 1, NTYPE
         NCELIX(I) = MAX0 (NCELTY(I), NCELIN(I))
  147    CONTINUE
         ENDIF
      WRITE (8, 154) NATIN, NATX
  154 FORMAT (/' Number of atoms input:', I5/
     + ' NUMBER OF NEW ATOMS TO BE FOUND IS',I6, ' (if on genl posn)')
      NATXX = NATX + NATIN
      IF (DMAXB .GT. DMOUT) DMOUT = DMAXB
      IF (DMAXB .LT. DMINB) THEN
         DMINB   = 0.
         ANGM(1) = 0.
         ANGM(2) = 180.
         ENDIF
      IF (NPC .GT. 0) THEN
         NPIC = NPC
         NATX = NPC
         WRITE (8, 163) NATX
  163    FORMAT (' NUMBER OF ATOMS (PEAKS) TO BE CONSIDERED IS', I5)
      ELSE
         NATX = MIN0((20*NATXX + 5)/19, MAXAT-50) + 2
         NPIC = MIN0((15*NATXX + 6)/14, MAXAT-50) + 1
         NPIC = MAX0(NPIC, MIN0(20, NATTR) +3)
         IF (NATTHA .GT. 0)
     *      NPIC = NPIC + MIN0 (7 * (NATIN + NATX) / NATTHA, NATX/2)
         IF (NPIC .EQ. NATX) NPIC = NPIC + 1
         WRITE (8, 172) NATX, NPIC
  172    FORMAT (' NUMBER OF ATOMS TO BE CONSIDERED IS', I5/
     +           ' NUMBER OF PEAKS to be searched is ',I6)
            III = MAX0(150, NATIN * 3/2)
            IF (IMAP .EQ. 1 .AND. NATX .GT. III) THEN
            WRITE (8, 174) III
  174       FORMAT (' because of DIRP1 this is reduced to:', I4)
            NPIC = III + 1
            NATX = III
            ENDIF
         ENDIF
      WRITE (8, 184) DMINB, DMAXB, ANGM
  184 FORMAT (' STEREOCHEMICAL CRITERIA'/ ' For molecular clusters:',
     *   15X, 'MINIMUM BONDING DISTANCE  =', F6.2 /
     *  ' defaults, or',  26X, 'MAXIMUM BONDING DISTANCE  =', F6.2 /
     *  ' user-defined;', 31X, 'MINIMUM BOND ANGLE  =', F6.1 /
     *  ' may be modified later.', 22X, 'MAXIMUM BOND ANGLE  =', F6.1 )
      IF (NPROJ .NE. 2) WRITE (8, 186) NPROJ
  186 FORMAT (9X,'NUMBER OF PROJECTIONS OF EACH CLUSTER TO BE OUTPUT',
     +' IS',I3)
      GOTO 200
  190 IF (NPC .LE. 0) NPIC = 60
      NATX = NPIC
      NATIN = 0
  200 D2R = ATAN(1.0) / 45.0
      NAT = NATIN
      CALL PKSRCH (ATX4, MAXAT, IHALF, IFMAP)
      DMAXLI = 0.5
      IF (IMAP .NE. 3) DMAXLI = 0.1
      DO 225 I = 1, NPIC
      CALL LOCKIN ( ATX4(1,I), DMAXLI, XLOCK, DISTLI, NPOSLI )
      IF (DISTLI .GT. 0.15)
     *   WRITE(24,223) I, DISTLI, (ATX4(J,I),J=1,3), XLOCK
  223 FORMAT (' Atom ',I3,' locked in: peak shifted over', F6.2,
     *   ' Angstrom' / ' Peak xyz:',3F9.5, '  LOCKED xyz:',3F9.5)
  225 IF (NPOSLI .GT. 1) CALL KERNAB (XLOCK, ATX4(1,I), 3)
      IF (IMAP .EQ. 2 .OR. IMAP .EQ. 6) THEN
         CALL FILCLO (IFMAP, 'KEEP')
      ELSE
         CALL FILCLO (IFMAP, 'DELETE')
         ENDIF
      CALL DIRBON (IMAP, ZSCAL)
      IF (IDOKA .EQ. 17) RETURN
      NNA = 0
      CALL CLSTRS
      IF (MCON.GT.0) GOTO 350
      WRITE(24, 227) ((ATX4(J,I),J=1,4),I=1,NAT)
      WRITE (8, 227) ((ATX4(J,I),J=1,4),I=1,NAT)
  227 FORMAT (' NO BONDS FOUND'//
     + ' ATOMIC POSITIONS'//46X,'X',9X,'Y',9X,'Z',3X,
     + 'HEIGHT'/(41X,3F10.4,F8.0))
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'OUTPUT', KINQ)
      CHOUT = ' Uninterpreted peaks, denoted C-atoms'
      CALL ATOMWA (IATOMS)
      DO 344 I=1,NAT
  344 WRITE (IATOMS, 341) I, (ATX4(J,I),J=1,3)
  341 FORMAT ('ATOM   C', I3, 2X, 3F8.5)
      WRITE (IATOMS, FMT = '(''END'')')
      CALL FILCLO(IATOMS, 'KEEP')
      WRITE (9,*)
     *' Warning: No atoms interpretation; No recycling: check file!'
      IF (MPAT .LE. -2 .AND. MPAT .GT. -99) CALL ATPATS(1)
      CALL KERROR
     * ('Savety stop: peaks output to ATOMS file.', 0, 'SEARCH')
  350 CONTINUE
      DO 600 NOFRG=1,NFRAG
      NOFRAG = NOFRG
      IF (NOFRAG .EQ. 20) GOTO 600
      IF (KFRAG(NOFRAG) .LT. 4) GOTO 600
      CALL PICTUR (NPROJ)
  600 CONTINUE
      CALL SCHOUT (SCALAT, ZSCAL)
      IF (NRECYR .LE. 0) RETURN
      WRITE (24, FMT='('' Cycle'',I2,'' is finished'')')  NRECYR
      IF (NORECY) THEN
         WRITE (24,*) ' Fourier recycling procedure completed'
         IF (NRECYR .GT. 1) WRITE (24,*)
     *    ' ATOMS from the each cycle written to the ATTEM file.'
         WRITE (24,*)
     *    ' Final atomic parameters written to the ATOMS file'
         ENDIF
      CALL WR24
      RETURN
      END
      SUBROUTINE PKSRCH (X, MAXAT, IHALF, LIN)
      DIMENSION  X(4, MAXAT)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zsear.inc'
      PARAMETER (KUSER2=30000)
      COMMON /BLANK/ NR3D, DUMMY(145000)
      INTEGER*2 NR3D(KUSER2)
      DIMENSION XS(3), X1(3), IDIFF(19), B(19)
      DIMENSION DXYZM(3)
      CALL WR24
      MAX = 0
      E = 0.0
      D = 0.0
      DO 101 I = 1, 3
  101 DXYZM(I) = DMPIC * RCELL(I)
      READ (LIN) NNX, NNZ, NNY, NNYT
      NNYOLD=NNY
      IF (IHALF.NE.0) NNY=NNY-3
      NNXP2 = NNX + 2
      NXZ = NNXP2 * (NNZ + 2)
      NXZ3 = 3 * NXZ
      DX = 1.0 / FLOAT(NNX)
      DY = 1.0 / FLOAT(NNYT)
      DZ = 1.0 / FLOAT(NNZ)
      LEVEL = 0
      LIMIT = MIN0(MAXAT, 2*NATX)
 1100 IDIFF(1) = -NXZ - 1
      IDIFF(2) = -NXZ - NNXP2
      IDIFF(3) = -NXZ
      IDIFF(4) = -NXZ + NNXP2
      IDIFF(5) = -NXZ + 1
      IDIFF(6) = -NNXP2 - 1
      IDIFF(7) = -1
      IDIFF(8) = NNXP2 - 1
      IDIFF(9) = -NNXP2
      IDIFF(10) = 0
      DO 1120 I=1,9
      J=20-I
      IDIFF(J) = -IDIFF(I)
 1120 CONTINUE
      NO = 0
      IY = -1
      NY = 0
 1200 REWIND LIN
      READ(LIN) SCALOR, IMAP
      READ(LIN)
      IF (IMAP.EQ.1 .OR. IMAP.EQ.3 .OR. IMAP.EQ.4) THEN
         RESCAL = 4000. / VOLUM / SCALOR
      ELSE
         RESCAL = 1.
         IMAP = 0
         ENDIF
      IF (IY+2.EQ.NNYOLD) GOTO 1400
      MAX=NXZ
      ISKIP = (NNYOLD-1) * NNZ
      DO 1305 I=1,ISKIP
 1305 READ (LIN)
      CALL RDSECT (MAX, NNXP2, NNZ, NXZ3, LIN)
      REWIND LIN
      READ(LIN)
      READ(LIN)
      CALL RDSECT (MAX, NNXP2, NNZ, NXZ3, LIN)
 1400 MX = MAX - NXZ + NNX + 1
      CALL RDSECT (MAX, NNXP2, NNZ, NXZ3, LIN)
      IY = IY + 1
      NY = MOD(NY+2, 3) - 1
      KK = NXZ3
      IF (NY) 1440, 1460, 1500
 1440 KK = -NXZ3
 1460 DO 1480 I=1,5
      IDIFF(I) = IDIFF(I) - KK
 1480 CONTINUE
      IF (NY .EQ. 0) GO TO 1540
 1500 DO 1520 I=15,19
      IDIFF(I) = IDIFF(I) - KK
 1520 CONTINUE
 1540 DO 2000 IZ=1,NNZ
      MN = MX + 3
      MX = MX + NNXP2
      DO 1980 IX=MN,MX
      IF (NR3D(IX) .LT. LEVEL) GO TO 1980
      DO 1560 I=1,9
      J = IDIFF(I) + IX
      IF (NR3D(IX) .LE. NR3D(J)) GO TO 1980
 1560 CONTINUE
      DO 1580 I=11,19
      J = IDIFF(I) + IX
      IF (NR3D(IX) .LT. NR3D(J)) GO TO 1980
 1580 CONTINUE
      DO 1600 I=1,19
      J = IDIFF(I) + IX
      B(I) = NR3D(J)
 1600 CONTINUE
      B1 = B(3) + B(7) + B(9) + B(11) + B(13) + B(17)
      B2 = B(1) + B(2) + B(4) + B(5) + B(6) + B(8) + B(12) + B(14) +
     +  B(15) + B(16) + B(18) + B(19)
      F = (30.0 * B(10) + 11.0 * B1 - 8.0 * B2) / 63.0
      C = (B(5)+B(12)+B(13)+B(14)+B(19)-B(1)-B(6)-B(7)-B(8)-B(15))/10.0
      IF ( ABS(C) .GT. ABS(F) ) GOTO 1620
      DELTAX = C / F
      D = (B(15)+B(16)+B(17)+B(18)+B(19)-B(1)-B(2)-B(3)-B(4)-B(5))/10.0
      IF ( ABS(D) .GT. ABS(F) ) GOTO 1620
      DELTAY = D / F
      E = (B(4)+B(8)+B(11)+B(14)+B(18)-B(2)-B(6)-B(9)-B(12)-B(16))/10.0
      IF ( ABS(E) .GT. ABS(F) ) GOTO 1620
      DELTAZ = E / F
      GOTO 1640
 1620 DELTAX = 0.0
      DELTAY = 0.0
      DELTAZ = 0.0
 1640 XX = (FLOAT(IX-MN+1) + DELTAX) * DX
      YY = (FLOAT(IY) + DELTAY) * DY
      ZZ = (FLOAT(IZ) + DELTAZ) * DZ
      A = (9.0 * B(10) + 4.0 * B1 - B2) / 21.0
      BINT = A + 0.5 * (C * DELTAX + D * DELTAY + E * DELTAZ)
      IF (BINT .GT. 1.1 * B(10)) BINT = 1.1 * B(10)
      B10 = B(10)
      B(10) =  AMAX1(B(10), BINT)
      IF (IMAP .EQ. 0) GOTO 1660
      IF (B(10) .LT. 1.) B(10) = 1.
      B(10) = SQRT (B(10) * RESCAL)
      BSUM = B(10)
      IF (B1 .LT. 0.0 .OR. B2 .LT. 0.) GOTO 1650
      B30 = 0.
      BX2 = B(3)  + B(2)  + B(4)  + B(1)  + B(5)
      BX3 = B10   + B(9)  + B(11) + B(7)  + B(13)
      BX4 = B(17) + B(16) + B(18) + B(15) + B(19)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B30 = B30 + BX1 + BX5
      BX2 = B(9)  + B(6)  + B(12) + B(2)  + B(16)
      BX3 = B10   + B(7)  + B(13) + B(3)  + B(17)
      BX4 = B(11) + B(8)  + B(14) + B(4)  + B(18)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B30 = B30 + BX1 + BX5
      BX2 = B(13) + B(12) + B(14) + B(5)  + B(19)
      BX3 = B10   + B(9)  + B(11) + B(3)  + B(17)
      BX4 = B(7)  + B(6)  + B(8)  + B(1)  + B(15)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B30 = B30 + BX1 + BX5
      B8 = 0.
      BX2 = B(1)  + B(2)
      BX3 = B(3) * 2.
      BX4 = B(4)  + B(5)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(1)  + B(4)
      BX4 = B(2)  + B(5)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(15)  + B(16)
      BX3 = B(17) * 2.
      BX4 = B(18)  + B(19)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(15)  + B(18)
      BX4 = B(16)  + B(19)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(1)   + B(6)
      BX3 = B(7) * 2.
      BX4 = B(8)  + B(15)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(1)  + B(8)
      BX4 = B(6)  + B(15)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(5)  + B(12)
      BX3 = B(13) * 2.
      BX4 = B(14) + B(19)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(5)  + B(14)
      BX4 = B(12) + B(19)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(8)  + B(18)
      BX3 = B(11) * 2.
      BX4 = B(14) + B(4)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(18) + B(14)
      BX4 = B(8) + B(4)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(6)  + B(16)
      BX3 = B(9) * 2.
      BX4 = B(12) + B(2)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(12) + B(16)
      BX4 = B(6) + B(2)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      B8 = B8 / 6.
      PX2 = B10
      PX3 = (B1+B2) / 18.
      PX4 = (B8+B30)/ 38.
      CALL EXTPOL (PX2, PX3, PX4, PX1, PX5)
      PX5 = AMIN1(PX5, 0.3 * PX4)
      B58  = 29. * PX5
      BSUM = B10 + B1 + B2 + B30 + B8 + B58
 1650 CONTINUE
      IF (BSUM .LT. 1.) BSUM = 1.
      BSUM = SQRT(BSUM)
      IF (BSUM .GT. 999.) BSUM = 999.
      I10 = NINT(B(10))
      B(10) = FLOAT(I10) + BSUM / 1000.
 1660 NOP1 = NO + 1
      IF(NOP1.GT.MAXAT) GOTO 1821
      X(1,NOP1) = XX
      X(2,NOP1) = YY
      X(3,NOP1) = ZZ
      X(4,NOP1) = B(10)
      IF (NO .EQ. 0) GO TO 1820
      IR=0
      DO 1800 K=1, IMULT
      CALL OPER1 (K, XS, X(1,NOP1))
      DO 1780 I=1,NO
      DO 1720 L=1,3
      X1(L) = X(L,I) - XS(L)
 1680 IF (ABS(X1(L)) .LE. 0.5) GO TO 1700
      X1(L) = X1(L) - SIGN(1.0, X1(L))
      GO TO 1680
 1700 IF (ABS(X1(L)) .GT. DXYZM(L)) GO TO 1780
 1720 CONTINUE
      IF (QUAD2 (X1, X1) .GT. DMPIC) GOTO 1780
      IF (IR.GT.0) X(4,IR)=0.0
      IR=0
      IF (B(10) .LE. X(4,I)) GOTO 1980
      X(1,I) = XX
      X(2,I) = YY
      X(3,I) = ZZ
      X(4,I) = B(10)
      IR=I
 1780 CONTINUE
 1800 CONTINUE
      IF(IR.GT.0) GO TO 1980
 1820 NO = NOP1
 1821 IF (NO .LT. LIMIT) GO TO 1980
      CALL SORT (X, MAXAT, NO, 4)
      NO = LIMIT
      NPIC = NO
      IF (IMAP .EQ. 0) THEN
         LEVEL = X(4,NPIC) + 0.5
      ELSE
         LEVEL = X(4,NPIC)**2 / RESCAL + 0.5
         ENDIF
 1980 CONTINUE
 2000 CONTINUE
      IF (IY .GE. NNY) GO TO 2100
      IF (IY - NNYOLD + 2) 1400, 1200, 1400
 2100 CONTINUE
      IF (IMAP .NE. 1 .AND. IMAP .NE. 3) GOTO 2200
      DO 2155 I = 1, NO
      I10 = X(4,I)
      ITOT = X(4,I) * 10000.
      ISUM = ITOT - 10000 * I10
      IF (I10 .GT. 999) I10 = 999
      X(4,I) = FLOAT(ISUM) + FLOAT(I10)/1000.
 2155 CONTINUE
 2200 CALL SORT (X, MAXAT, NO, 4)
      NNN = MIN0 (NO, NPIC)
      IF (NNN .EQ. NPIC) GOTO 3000
      LEVEL = LEVEL - 100
      IF(LEVEL.GE.(-200)) GO TO 1100
      NPIC=NO
 3000 CONTINUE
      RETURN
      END
      SUBROUTINE EXTPOL (BX2, BX3, BX4, BX1, BX5)
      A = BX3
      B = (BX4 - BX2) / 2.0
      C = BX4 - A - B
      BX1 = A - 2.0 * B + 4.0 * C
      BX5 = A + 2.0 * B + 4.0 * C
      IF (BX1 .GT. BX2) BX1 = BX2
      IF (BX1 .LT. 0.0) BX1 = 0.0
      IF (BX5 .GT. BX4) BX5 = BX4
      IF (BX5 .LT. 0.0) BX5 = 0.0
      RETURN
      END
      SUBROUTINE DIRBON (IMAP, ZSCAL)
      CALL WR24
      GOTO (1,   2,   1,   4,   5,   2), IMAP
  1   CALL DIRBF (ZSCAL)
      GOTO 100
  4   CALL DIRBD
  100 CALL DIRBB
      RETURN
  2   CALL DIRBP
  5   RETURN
      END
      SUBROUTINE DIRBF (ZSCAL)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zsear.inc'
      COMMON /BLANK/ IFRAG(MAXAT), ISYM(MAXAT),     IDUM(MAXAT),
     *               DUM(MAXAT),   IBOND(MAXAT*10), JBOND(MAXAT*10),
     *               XXXGEO(135520)
      DIMENSION LW(MAXAT), JCON(MAXAT), XDUM(MAXAT)
      EQUIVALENCE (LW(1),IFRAG(1)), (JCON(1),ISYM(1)),(XDUM(1),IDUM(1))
      COMMON /DIRBFA/ NCELTY(10), NCELLZ(10), NCELIN(10), NCELIX(10)
      COMMON /DIRBFB/ ACELTY(10)
      CHARACTER ACELTY *2
      EQUIVALENCE (NOPHAS, KSTAT(3))
      EQUIVALENCE (IDDL, IFILE(1)), (IDDS, IFILE(2)), (ICRYS,IFILE(3))
      EQUIVALENCE (ICOND,IFILE(4))
      EQUIVALENCE (NTYPEZ, KEYS(4))
      EQUIVALENCE (KEYD, KSTAT(19))
      EQUIVALENCE (KEYDS, KSTAT(20))
      EQUIVALENCE (IRUN, KSTAT(13))
      EQUIVALENCE (KPROG, KSTAT(18))
      LOGICAL SWRECY, NORECY, REN98, NOFREE
      EQUIVALENCE (SWITCH(9), NOFREE)
      EQUIVALENCE (SWITCH(16), REN98)
      EQUIVALENCE (SWITCH(7), SWRECY), (SWITCH(8), NORECY)
      DIMENSION XS(3), XST(3), XSHIFT(3)
      CHARACTER ATNAM *6 , ATNAMX(MAXAT) *6
      DIMENSION RCELTY(10), WCELTY(10), TCELTY(10), LCELTY(10)
      DIMENSION SATLD(133), ISATL(133), JSATL(133)
       DIMENSION XBTEMP(MAXAT), IZTEMP(MAXAT)
      DIMENSION IOCC(1), IRECY(8)
      LOGICAL SWMATE
      CHARACTER ZZZ *1
      BOV = BOVMER
      DPAR2 = 0.
      II = 0
      NTYPEZ = NTYPE
  101 IF (ACELTY(NTYPEZ) .EQ. ' ') THEN
         NTYPEZ = NTYPEZ - 1
         GOTO 101
         ENDIF
      DAV = 0.48
      DAV2 = DAV * DAV
      NQQQ = 0
      CALL KERNZI (0, LW, MAXAT)
      IF ((KPROG .GE. 4 .AND. KPROG .LE. 6) .OR.
     *     KPROG .EQ. 8 .OR. KPROG .GE. 11) KPROG = 0
      IF (NATS .LE. 0) NATS = NATIN
      IF (NATS .GT. NATIN) NATS = NATIN
      WRITE (8, FMT='('' ***** DIRBF  *****''/ 20X, ''KEYD='', I2,
     *   '' KEYDS='', I2 , '' SWRECY=TRUE, NORECY=FALSE?  IPAT='',
     *   I2)') KEYD, KEYDS, IPAT
      IF (.NOT. SWRECY) WRITE (8, FMT='(/ 36X, '' SWRECY=FALSE'')')
      IF (NORECY) WRITE (8, FMT='(/ 48X, ''NORECY=TRUE'')')
      KEYDSS = KEYD * 10 + KEYDS
      IF (KEYDSS.GT. 30 .AND. KEYDSS .LT. 40) THEN
         SWRECY = .FALSE.
         NORECY = .TRUE.
         ENDIF
      REN98 = .FALSE.
      IF (.NOT.NOFREE .AND. NRECYS .GE. 8) THEN
         REN98 = .TRUE.
         NATS = 0
         IF (NRECYS .GE. 8) GOTO 112
         WRITE (24, FMT='(
     *     '' From now on all input atoms may be renamed!''/
     *     '' -------------------------------------------'' )')
         ENDIF
  112 IF (NOFREE) THEN
         WRITE(24,*)
     *      ' $TE All input atoms are renamed following CRYSIN data!'
         NATS = 0
         ENDIF
      IF (NORECY) THEN
         IPRY=24
      ELSEIF (NRECYR .LE. 1) THEN
         IPRY=8
      ELSE
         IPRY=0
         ENDIF
      NATSN = NATS
      SUMBZ = 0.
      SUMZ = 0.
      DO 121 I = 1, NATIN
      Z2 = FLOAT ( IZAT(I))
      SUMZ = SUMZ + Z2
      SUMBZ = SUMBZ + Z2 * ATXYZ(5,I)
  121 CONTINUE
      BAV = SUMBZ / SUMZ
      SUMZ = 0.
      DO 122 I = 1, NATIN
      SUMZ = SUMZ + (ATXYZ(5,I) - BAV)**2
  122 CONTINUE
      BPSD = SQRT ( SUMZ / FLOAT(NATIN) )
      IF ((NRECYR .EQ. 2 .OR. NRECYR .EQ. 3) .AND. BAV .GT. BR) BR = BAV
      IF (FLOAT(NATIN) / FLOAT(NATX) .GT. 0.70 .AND.
     *    PSQ .GT. 0.85 .AND. NRECYR .GE. 4) BR = BAV + BPSD
      IF (PSQ .GT. 0.95 .AND. NRECYR .GE. 8) BR = BAV + 1.5 * BPSD
      IF (BPAV .LT. 0.0001) BPAV = BP
      WRITE (8, 124) NRECYR, PSQ, R2X, BAV, BPAV, BPSD, BR
  124 FORMAT (' $TE >Ncy PSQ R2X BAV BPAV sd BR=', I3, 6F6.3)
      IF (NATIN .NE. -12359) GOTO 134
      IF (.NOT. REN98) GOTO 134
      BOVBAV = BOV / BAV
      IF (BOVBAV .GT. 1.07) BOVBAV = 1.07
      IF (BOVBAV .LT. 0.93) BOVBAV = 0.93
      BB7 = 0.07*BOV
      DO 125 I = 1, NATIN
      A123 = ATXYZ(5,I)*BOVBAV
      B123 = ATXYZ(5,I)+BB7
      C123 = ATXYZ(5,I)
      ATXYZ(5,I) = AMIN1 (ATXYZ(5,I)*BOVBAV , ATXYZ(5,I)+BB7 )
      WRITE (8,FMT='('' $TE B '' ,4F7.3)') C123,A123,B123,ATXYZ(5,I)
  125 CONTINUE
  134 CONTINUE
      CALL FILINQ (ICRYS, 'CRYSDA', 'FORMATTED', 'INPUT', KINQ)
      DO 159 N = 1, NTYPE
      CALL RDCRYB (ICRYS, 'ELEM' , KEND)
      IF (KEND.LE.0) THEN
         WRITE (CHOUT, 142) N
  142    FORMAT (' CRYSDA file: ELEM for atom No ', I2, ' not found')
         CALL KERROR (CHOUT, 142, 'DIRBF')
         ENDIF
      CALL KERINB (LIT, 1)
      IZ = NINT(FNUM(1))
      DO 153 I = 1, NTYPE
      IF (NCELLZ(I) .EQ. IZ) GOTO 154
  153 CONTINUE
      CALL KERROR ('Atom-type conflict', 153, 'DIRBF')
  154 RCELTY(I) = AMIN1 (FNUM(4), FNUM(5), FNUM(6))
      IF (NCELLZ(I) .GT. 18) RCELTY(I) = RCELTY(I) + 0.35
      IF (NCELLZ(I) .LT. 10) RCELTY(I) = 0.01
  159 CONTINUE
      NSATL = 0
      NNOMAT = 0
      NNOMAS = 0
      NNOMAX = 0
      NNOMAW = 0
      CALL KERNZI (0, JCON, NPIC)
      MSGT = 0
      MSGS = 0
      ZSCAL = 100. * NCELLZ(1) / ATX4(4,1) ** 2
      ZSCALA = 0.
      ZSCALX = 0.
      CALL EXPEAK(0, 0, 0, IPPQQ)
      IF (IPPQQ .EQ. -123499) GOTO 160
      QPPQQ = FLOAT(IPPQQ) / 1000.
      SCALEX = 1.0000000
      IF (QPPQQ .GT. 1.0 .AND. SCALEX .GT. 0.0001) THEN
         WRITE (8, FMT='('' $TEX scale /QPPQQ , old SCALE'',
     *      2F9.4)') QPPQQ, SCALEX
         IF (QPPQQ .GT. 1.05) QPPQQ = 1.05
         IF (QPPQQ .LT. 0.95) QPPQQ = 0.95
         SCALEX = SCALEX / QPPQQ
         WRITE (8, FMT='('' $TEX scale /QPPQQ: new SCALE='',
     *      2F9.4)') QPPQQ, SCALEX
         WRITE (CHOUT,FMT='(''RUN '',I3, '' CY'', I3,
     *     '' SCALEX '', F10.5)') IRUN, NRECYR, SCALEX
         CALL LOGWR (IDDL)
         CALL FILCLO (IDDL, 'KEEP')
         ENDIF
  160 CONTINUE
      CALL KERNZI (0, IRECY, 8)
      IRECYD = 0
      CALL KERNZA (0.0, XBTEMP, MAXAT)
      CALL KERNZI (0  , IZTEMP, MAXAT)
      DO 420 I= 1, NATIN
      SWMATE = .FALSE.
      LW(I) = 0
      IBOND(I) = 0
      ATNAMX(I) = ATNAME(I)
      DUM(I) = 0.
      XDUM(I) = 0.
      CALL ATOMOC (0, ATXYZ(1,I), IOCC, 1)
      ATXYZ(9,I) = IMULT/IOCC(1)
      DO 310 N = 1, NTYPE
      IF (NCELLZ(N) .NE. IZAT(I)) GOTO 310
      ATXYZ(10,I) = FLOAT(N)
      DPAR = RCELTY(N)
      DPAR2 = DPAR * DPAR
      DTEST = AMAX1 (DPAR, DAV)
      GOTO 312
  310 CONTINUE
      CALL KERROR (' Impossible...', 310, 'DIRBF')
  312 DO 410 J = 1, NPIC
      IF (ATX4(4,J) .LE. 0.1) GOTO 410
      DO 400 IS = 1, NSYMM
      CALL SYMOP1 (IS, ATX4(1,J), XS)
      DO 400 IC = 1, ICENT
      DO 400 IL = 1, NLATT
      CALL SYMOP2 (IC, IL, XS, XST)
      CALL DISTSQ (ATXYZ(1,I), XST, DTEST, XSHIFT, DIST2)
      IF (DIST2 .GT. DAV2) GOTO 380
      DIST = SQRT(DIST2)
      IF (DIST .GT. 0.20) GOTO 330
      WAV = 1.
      IF (DIST .GT. 0.05 .AND. DIST .LT. 0.10) WAV = 0.1 / DIST
      IF (DIST .LE. 0.05) WAV = 2.
      GOTO 340
  330 WAV = 5. * DIST
      WRED = AMIN1(6.0, FLOAT(J-NATIN-1)/2.0)
      IF (WRED.GT.1.0) WAV = AMIN1 (WRED*WAV - WRED + 1., DIST/0.08)
  340 DO 350 L = 1, 3
  350 ATXYZ(L,I) = ATXYZ(L,I) + XSHIFT(L) / WAV
      SHIFT = DIST / WAV
      IF (DIST.GT.0.2298 .AND. DIST.LT.0.2302) DIST = 0.2298
      SWMATE = .TRUE.
      DUM(I) = DIST
      XDUM(I) = SHIFT
      IF (DIST .GT. 0.05) IRECYD = IRECYD + 1
      ATXYZ(6,I) = ABS (ATX4(4,J))
      ATXYZ(8,I) = ATX4(4,J) ** 2 * ZSCAL
      ATX4(4,J) = - ABS(ATX4(4,J))
      LW(I) = J
      IF (JCON(J) .LT. 0) WRITE(24, 357) ATNAME(I), I
  357 FORMAT (' Warning: suspect input atom ', A6, ' (number', I3,
     *        ') : check bonds' )
      JCON(J) = I
      IF (DIST .GT. 0.23) THEN
         MSGT = MSGT + 1
         IF (I .LE. NATS) MSGS = MSGS + 1
         ENDIF
      CALL EXPEAK(1, I, NATSN, IZOLD)
      IF (IZOLD .NE. 0) THEN
         ATNAMX(I) = ATNAME(I)
         IRECY(1) = IRECY(1) + 1
         ENDIF
      ZSCALA = ZSCALA + FLOAT(IZAT(I))
      ZSCALX = ZSCALX + ATX4(4,J) ** 2
      IF (IZAT(I) .GT. 18) GOTO 410
      IF (IZAT(I) .GT. 10 .AND. I .LE. NATS) GOTO 410
      IF (IZAT(I) .GT. 10 .AND. REN98) GOTO 410
      GOTO 420
  380 IF (IZAT(I) .LE. 10) GOTO 400
      IF (IZAT(I) .LE. 18 .AND. I .GT. NATS .AND. .NOT. REN98) GOTO 400
      IF (DIST2 .GT. DPAR2 .OR. ATX4(4,J) .LE. 0.1) GOTO 400
      IF (ABS(ATX4(4,J)) .GT. 0.25 * ATXYZ(6,I)) THEN
         IRECY(2) = IRECY(2) + 1
         IF (ABS(ATX4(4,J)) .GT. 0.50 * ATXYZ(6,I)) THEN
            WRITE(24, 383) J, I, ATNAME(I)
  383       FORMAT (' WARNING: strong peak',I3, '  close to heavy atom',
     *      ' (nr',I3, ' = ', A6,')  retained' )
            GOTO 400
         ELSE
            WRITE(24, 384) J, I, ATNAME(I)
  384       FORMAT (' WARNING: strong peak',I3, '  close to heavy atom',
     *      ' (nr',I3, ' = ', A6,')  deleted' )
            ENDIF
         ENDIF
      NSATL = MIN0 (NSATL+1, 133)
      SATLD(NSATL) = SQRT(DIST2)
      ISATL(NSATL) = I
      JSATL(NSATL) = J
      ATX4(4,J) = -ABS(ATX4(4,J))
      JCON(J) = -I
  400 CONTINUE
  410 CONTINUE
      IF (SWMATE) GOTO 420
      ATXYZ(8,I) = -0.0001
      NNOMAT = NNOMAT + 1
      IRECY(3) = IRECY(3) + 1
      IF (LW(I) .NE. 0) STOP 307
      IF (I .LE. NATS) THEN
         NNOMAS = NNOMAS + 1
         IF (NRECYR .GT. 1) THEN
            IF ( NATS  .GT. 1) THEN
               NNOMAX = NNOMAX + 1
               LW(I) = -1
            ELSE
               LW(I) = -4
               ATXYZ(8,I) = 0.0001
               ENDIF
            ENDIF
         ENDIF
      ATXYZ(6,I) = ATXYZ(8,I)
  420 CONTINUE
      IF (NSATL .EQ. 0) GOTO 460
      IF (NATIN .GT. NATS .AND. .NOT. REN98) WRITE (8, 431)
  431 FORMAT (/' (May be based on the tentative chemical assignement:)')
      WRITE (8, 433) NSATL
  433 FORMAT (' We have removed ', I4,
     *   ' peaks from the Fourier-peaklist,' /
     *   '    because they are too close to the input heavy atom.  ',
     *   '   They are:' /
     *   '  No. peakhght     x       y       z     close to atom:  No.')
      WRITE(24, 435) NSATL
  435 FORMAT (' We have removed ', I4, ' peaks from the peaklist,' /
     * '    because they are too close to the heavy atom: see LIS2' )
      DO 440 N = 1, NSATL
      I = ISATL(N)
      J = JSATL(N)
      DDSATL = ABS ( ATX4(4,J)) ** 2 * ZSCAL
      WRITE (8, 439) J, DDSATL, (ATX4(NN,J), NN=1,3),
     *   ATNAME(I), I, SATLD(N)
  439 FORMAT (I5, F8.0, 3F8.4, '  close to ', A6, I5, '   Dist=', F5.2)
  440 CONTINUE
  460 IF (NRECYR .LE. 1) GOTO 478
      IF (REN98 .OR. NOFREE) GOTO 492
      CALL KERNZA (0.0,  WCELTY, 10)
      CALL KERNZA (0.01, TCELTY, 10)
      DO 471 I = 1, NATIN
      IF (ATXYZ(8,I) .LE. 0.1) GOTO 471
      N = NINT(ATXYZ(10,I))
      IF (TCELTY(N) .GT. 8.5) THEN
         WCELTY(N) = 0.9 * (WCELTY(N) + ATXYZ(8,I))
      ELSE
         WCELTY(N) = WCELTY(N) + ATXYZ(8,I)
         TCELTY(N) = TCELTY(N) + 1.
         ENDIF
  471 CONTINUE
      DO 472 N = 1, NTYPE
  472 WCELTY(N) = WCELTY(N) / TCELTY(N)
      DO 477 I = 1, NATS
      IF (ATXYZ(8,I) .LT. 0.1) GOTO 477
      IF (NRECYR.EQ.3 .AND. IZAT(I).GE.5 .AND. IZAT(I).LE.9
     *    .AND. ATXYZ(8,I) .LT. 200.) NQQQ = 1
      N = NINT(ATXYZ(10,I))
      IF (ATXYZ(8,I) .LT. 0.3 * WCELTY(N)) THEN
         ATXYZ(8,I) = - ABS(ATXYZ(8,I))
         ATXYZ(6,I) = - ABS(ATXYZ(6,I))
         J = LW(I)
         IF (J .LE. 0) GOTO 477
         ATX4(4,J) = - ABS(ATX4(4,J))
         LW(I) = -2
         NNOMAW = NNOMAW + 1
         ENDIF
  477 CONTINUE
      NQQQ = NQQQ + NNOMAW + NNOMAX
  478 CONTINUE
      IF (NATS .EQ. 1 .AND. NATIN .LE. 10) THEN
         IBOND(1) = 1
         GOTO 489
         ENDIF
      II = 0
      DO 487 I= 1, NATS
      J = LW(I)
      IF (J .LT. 0 .AND. J .NE. -4) GOTO 487
      II = II + 1
      IBOND(I) = II
      IF (I .GT. II) THEN
         CALL KERNAB (ATXYZ(1,I), ATXYZ(1,II), 10)
         IZAT(II) = IZAT(I)
         ATNAME(II) = ATNAME(I)
         JCON(J) = II
         ENDIF
  487 CONTINUE
      NATSN  = II
      IF (II .NE. NATS - NNOMAX - NNOMAW) WRITE(24,
     *   FMT= '(/'' Error in count of messages.. ''/)')
  489 IF (NATS .GE. NATIN) GOTO 502
  492 CONTINUE
      DO 501 I = NATS + 1 , NATIN
      J = LW(I)
      IF (J .LE. 0) GOTO 501
      IF (JCON(J) .LT. 0) GOTO 501
      ATX4(1,J) = ATXYZ(1,I)
      ATX4(2,J) = ATXYZ(2,I)
      ATX4(3,J) = ATXYZ(3,I)
      ATX4(4,J) = ATXYZ(6,I)
      XBTEMP(J) = ATXYZ(5,I)
      IZTEMP(J) = IZAT(I)
  501 CONTINUE
  502 CONTINUE
      IF (REN98 .OR. NOFREE) GOTO 8505
      WRITE (8, 503) (ACELTY(I), I=1, NTYPE)
  503 FORMAT (/' Cell contents:  atoms:  ', 10(3X, A2))
      WRITE (8, FMT='('' Count  original input,'')')
      CALL CELZIN (ATXYZ, IZAT, NATSN, NCELLZ, NCELIN)
      WRITE (8, FMT='('' = symmetry included ='')')
      IF (NCELLZ(1) .GE. 10) WRITE (8, 504) (RCELTY(I), I=1, NTYPEZ)
  504 FORMAT (' Satellite skip-distance ', 10F5.2)
 8505 CONTINUE
      DO 505 N = 1, NTYPE
      RCELTY(N) = 1.25
      IF (NCELLZ(N) .LE. 12) RCELTY(N) = 1.55
      IF (NCELLZ(N) .LT. 10) RCELTY(N) = 0.85
      IF (NCELLZ(N) .GT. 18) RCELTY(N) = 1.60
  505 CONTINUE
      WRITE (8, 508) (ACELTY(I), I=1, NTYPE)
  508 FORMAT (/'             For atom type: ', 10(1X,A2,2X))
      WRITE (8, 507) (RCELTY(I), I=1, NTYPE)
  507 FORMAT (' Approximate atomic radius: ', 10F5.2)
      IF (NNOMAW .GT. 0) WRITE (8, 511) (WCELTY(I), I=1, NTYPE)
  511 FORMAT (' Averaged low peak level:    ', 10F5.0)
      WRITE (8, FMT='('' '')')
      IF (NNOMAT .EQ. 0) THEN
         WRITE (24, *) 'Results: all input atoms recognized.'
      ELSE
         WRITE (24, FMT='('' Nr of input atoms'',
     *     '' rejected because no mate was found:'',I4)')  NNOMAT
         IF (NNOMAS .GT. 0 .AND. NNOMAT .GT. NNOMAS) THEN
            WRITE (24, FMT='(I6, '' of these belong to the'',
     *           '' original list of input atoms'')')  NNOMAS
            ENDIF
         ENDIF
      IF (NNOMAW .GT. 0) THEN
         WRITE (24, 515) NNOMAW
  515    FORMAT (' Nr of original input atoms rejected: ',
     *       'too low Peakheight:', I3)
         IRECY(4) = IRECY(4) + NNOMAW
         ENDIF
      I = NNOMAX + NNOMAW
      IF (I .GT. 0) THEN
         WRITE(24, 517) I
         WRITE (8, 517) I
  517 FORMAT (' Because', I3,
     *       ' of the original input atoms will be rejected,' /
     *       ' the original input atoms have been reordered.'/
     *       ' The atom-names are not changed  '/
     *       '    except when the atom type is changed !  .' )
         ENDIF
      ZSCAL1 = ZSCAL
      IF (ZSCALX .LT. 0.0001) GOTO 1532
      ZSCAL = 100. * ZSCALA / ZSCALX
      WRITE (8, 1531) ZSCAL1, ZSCAL
 1531 FORMAT (/' $TEMP :   old and new ZSCAL =', 2F15.7)
 1532 CONTINUE
      CALL WR24
      WRITE (8, 531)
  531 FORMAT (/' Table 307     INPUT ATOMS AND THEIR AVERAGED MATES'//
     +   '   ATOM        PEAK        modified coordinates   ',
     *   ' mate atom-  (input:)'/
     +   '  No. NAME    No. Integr.   x        y        z   ',
     *   '-DIST SHIFT  No. NAME' )
      IF (MSGS .GT. 0 .OR. NNOMAS + NNOMAW .GT. 0) WRITE(24, 533)
  533 FORMAT (1X/'  No. ATOM    No. PEAK')
      IF (REN98 .OR. NOFREE) GOTO 592
      DO 570 I = 1, NATS
      ABSX = -1.
      II = IBOND(I)
      IF (II .EQ. 0) GOTO 553
      IF (ABS(ATXYZ(8,II)) .GT. 1.)
     *   ATXYZ(8,II) = ATXYZ(8,II) * ZSCAL / ZSCAL1
      IF (I .LE. 0) CALL KERROR ('kanniet', 545, 'DIRBF')
      J = LW(I)
      ABSX = ABS(ATXYZ(8,II))
      IF (II .EQ. I) THEN
         WRITE (8, 545) II, ATNAMX(I), J, ABSX,
     *      (ATXYZ(K,II),K=1,3), DUM(I), XDUM(I)
  545    FORMAT (I5, 1X, A6, I4, F7.0, 1X, 3F9.5, 2F5.2, 1X, I4, 1X, A6)
      ELSE
         WRITE (8, 545) II, ATNAME(II), J, ABSX,
     *      (ATXYZ(K,II),K=1,3), DUM(I), XDUM(I), I, ATNAMX(I)
         ENDIF
      IF (DUM(I) .GT. 0.23) THEN
         WRITE (8, 547)
  547    FORMAT (53X, '----', 8X, 'WARNING')
         WRITE(24, 549) II, ATNAME(I), J, ABSX, I, DUM(I)
  549    FORMAT (I5, 1X, A6, I5, F7.0, ' MATE FOR INPUT ATOM No.',
     *      I4, ' found at DIST = ', F4.2 )
         ENDIF
      IF (J .EQ. -4) THEN
         WRITE (24,
     *      FMT = '(12X, ''  This only input atom is not rejected'')')
         GOTO 570
         ENDIF
      GOTO 570
  553 IF (J .EQ. -2) GOTO 564
      III = II
      IF (J .EQ. -1) III = 0
      WRITE (8, 555) III, ATNAMX(I), I, ATNAMX(I)
      WRITE(24, 555) III, ATNAMX(I), I, ATNAMX(I)
  555 FORMAT (I5, 1X, A6, '  WARNING: no mate found for input atom', I4/
     *      ' ---> ', A6, '  will be removed from',
     *        ' the list of original input atoms')
      IF (J .EQ. 0) CALL KERROR ('KANNIET', 555, 'DIRBF')
      GOTO 570
  564 WRITE(24, 566) ATNAMX(I), ABSX, I
      WRITE (8, 566) ATNAMX(I), ABSX, I
  566 FORMAT (4X, '0', 1X, A6, F6.0,
     *  ' : peak height is too low for input atom', I3)
  570 CONTINUE
      IF (NRECYR .LE. 1) THEN
         WRITE(24, 572)
         WRITE (8, 572)
  572    FORMAT (/' The input atoms are appended by the remaining ',
     *    '(unidentified) peaks,' / ' the tentative chemical ',
     *    ' assignment is based on the CRYSDA file' /
     *    ' and the peak height, not on any chemical argument.' / )
      ELSEIF (NRECYR .EQ. 2) THEN
         WRITE(24, 575)
         WRITE (8, 575)
  575    FORMAT (/' Note: the secondary input atoms, tentatively',
     *      ' assigned and added to' / ' the original list in',
     *      ' the foregoing cycle(s), are now merged with the '/
     *      ' new (unidentified) peaks, sorted',
     *      ' to peakheight, and reinterpreted.'/)
         ENDIF
  592 CALL KERNZI (0, LCELTY, 10)
      LCELTY(NTYPEZ) = LCELTY(NTYPEZ) + 9999
      L = 0
      IF (REN98 .OR. NOFREE) CALL KERNZI (0, NCELIN, 10)
      DO 600 N = 1, NTYPEZ
      LCELTY(N) = LCELTY(N) + NCELTY(N) - NCELIN(N)
      IF (LCELTY(N) .LT. 0) THEN
         LCELTY(N+1) = LCELTY(N+1) + LCELTY(N)
         LCELTY(N) = 0
         ENDIF
      IF (L .EQ. 0 .AND. LCELTY(N) .GT. 0) L = N
  600 CONTINUE
      LH = 3
      IF (ACELTY(NTYPEZ) .NE. 'H ') LH = 0
      NPC = NPIC - NATX
      NATXX = 99
      IF (NPC .NE. 0) NATXX = MAX0(5, (NATX-NATS)/7 +3)
      NAT = NATSN
      DO 603 J = 1, NPIC
      IF (ATX4(4,J) .LE. 0.1) GOTO 603
      PEAKI = ATX4(4,J) **2 * ZSCAL
      IF (PEAKI . LT. 50.) GOTO 604
      NAT = NAT + 1
      CALL KERNAB (ATX4(1,J), ATXYZ(1,NAT), 3)
      ATXYZ(4,NAT) = 1.
      CALL KERNZA (0., ATXYZ(5,NAT), 6)
      ATXYZ(5,NAT) = XBTEMP(J)
      ATXYZ(6,NAT) = ATX4(4,J)
      ATXYZ(8,NAT) = PEAKI
      ATXYZ(7,NAT) = FLOAT(J)
  603 CONTINUE
  604 CONTINUE
      NAT = MIN0 (NAT, NATX)
      NATNOH = NATSN
      DO 620 I = NATSN + 1, NAT
      CALL ATOMOC (0, ATXYZ(1,I), IOCC, 1)
      LLL = L
      IF (L .EQ. NTYPEZ.AND. LH .GT. 0 .AND. ATXYZ(8,I) .GT. 200.) THEN
         LLL = L - 1
         LH = LH - 1
         ENDIF
      CALL ATN4CN (ACELTY(LLL), I, I-1, ATNAME, I, ATNAME(I))
      J = NINT (ATXYZ(7,I))
      ATXYZ(7,I) = 0.
      N = JCON(J)
      KEY = 2
      IF (N .LE. 0) KEY = 3
      IF (REN98) KEY = 4
      IZAT(I) = NCELLZ(L)
      ATXYZ(10,I) = L
      CALL EXPEAK(KEY, I, I-1, IZOLD)
      IF (IZOLD .NE. 0) IRECY(5) = IRECY(5) + 1
      IF (N .GT. 0) THEN
         LW(N) = -3
         WRITE (8, 545) I, ATNAME(I),J,ATXYZ(8,I),(ATX4(K,J), K=1,3),
     *      DUM(N), XDUM(N), N, ATNAMX(N)
         IF (NRECYR .LE. 2) GOTO 610
         IF (ATNAME(I)(1:1) .EQ. ATNAMX(N)(1:1) ) GOTO 610
         CALL ATCHK (ATNAME(I), NLET, IZZ)
         CALL ATCHK (ATNAMX(N), NLET, NZZ)
  610    CONTINUE
      ELSE
         WRITE (8, 545) I, ATNAME(I), J, ATXYZ(8,I)
         ATXYZ(5,I) = BR
         ENDIF
      LIOCC = IMULT/IOCC(1)
      ATXYZ(9,I) = LIOCC
      LCELTY(L) = LCELTY(L) - LIOCC
      IF (IZAT(I) .NE. 1) NATNOH = NATNOH + 1
  615 IF (LCELTY(L) .LE. 0) THEN
         L = L + 1
         LCELTY(L) = LCELTY(L) + LCELTY(L-1)
         IF (LCELTY(L) .LE. 0) GOTO 615
         ENDIF
      IF (L .LT. NTYPEZ) GOTO 620
      IF (NCELIN(L).GT.0 .AND. LCELTY(L) .GT. 9999) GOTO 620
      IF (IZAT(I) .GT. 1) GOTO 620
      NATXX = NATXX - 1
      IF (NATXX .LE. 0) THEN
         NAT = I
         GOTO 640
         ENDIF
  620 CONTINUE
  640 CONTINUE
      I = MSGT - MSGS
      IF (I .GT. 0) WRITE(24, 641) I
  641 FORMAT (/' Of the atoms tentatively added in the forgoing cycle'/
     *       I5, ' were found at distances larger than 0.23 Angstrom.')
      IF (NATIN .LE. NATS) GOTO 666
      II = 0
      DO 643 I = NATS+1, NATIN
      IF (LW(I) .LT. 0) GOTO 643
      II = II + 1
  643 CONTINUE
      IF (II .EQ. 0) GOTO 666
      WRITE(24, 644) II
  644 FORMAT (' Of the atoms tentatively added in the forgoing cycle'/
     *    I5, ' is(are) left out: no mate found or too weak to use.')
      WRITE (8, 645)
  645 FORMAT (/' Of the atoms tentatively added in the forgoing cycle'
     *        /' some were found at distances > 0.23 angstrom, and/or'
     *        /' some are left out: no mate found or too weak to use:'/
     *        /' old No.  old name   PEAK  ATXYZ(8,I)  ATX4(4,J)')
      DO 647 I = NATS+1, NATIN
      IF (LW(I) .EQ. 0) WRITE (8, 646) I, ATNAMX(I)
  646 FORMAT (I8, 4X, A6, I7, 4X, F6.0, F13.5)
      IF (LW(I) .LE. 0) GOTO 647
      J = LW(I)
      BSUM = ATXYZ(8,I)
      WRITE (8, 646) I, ATNAMX(I), J, BSUM, ATX4(4,J)
  647 CONTINUE
  666 IRECY(6) = NQQQ
      I = 15 * IRECYD / NAT
      IRECY(8) = I
      I = IFIX ((ATXYZ(8,NAT) - 70.) / 50.)
      IF (I .GT. 0) IRECY(7) = I
      IRECYS = 0
      DO 677 I = 1, 8
      IRECYS = IRECYS + IRECY(I)
  677 CONTINUE
      CALL NNRECY(99)
      IF (NRECYS .GT. 90) IPRY = 24
      IF (.NOT. REN98 .AND. .NOT.NOFREE) CALL EXPEAK(-1, 0, 0, IDUMM)
      IF (NORECY) GOTO 690
      PSQN = 1.0
      IF (PSQ .LT. 0.30) PSQN = AMIN1 (0.70, 3. * PSQ)
      IF (PSQ .LT. 0.07) PSQN = 0.20
      NNNN = 0
      DO 682 N = 1, NTYPE
  682 NNNN = NNNN + NCELTY(N) * NCELLZ(N) ** 2
      NNNR = FLOAT (NNNN) * PSQN * 1.00001
      N = 0
  685 N = N + 1
      IF (N .GT. NAT) GOTO 687
      ITYPE = NINT(ATXYZ(10,N))
      IF (ITYPE .EQ. 0) GOTO 687
      IF (NCELLZ(ITYPE) .EQ. 1) GOTO 687
      NNNR = NNNR - NINT(ATXYZ(9,N)) * NCELLZ(ITYPE) ** 2
      IF (NNNR .LT. 0) GOTO 687
      GOTO 685
  687 NATPSQ = N - 1
      NDIFF = MIN0 (MAX0 (2, NATX-NATIN) * 30 / 40, 50)
      NATDIF = NATPSQ
      IF (NDIFF .GT. 30) NATDIF = NATIN + NDIFF
      NATREC = MIN0 (NAT, NATPSQ, NATNOH, NATDIF)
      IF (NATNOH .LE. NATREC * 20 /18) NATREC = NATNOH
      NATREC = MAX0 (NATIN, NATREC)
      IF (NRECYR .LE. 3) GOTO 690
      KSTAT(4) = NATNOH
      CALL NNRECY (5)
  690 CONTINUE
      IF (MPAT .LT. 0  .AND. NRECYR .GE. 13) THEN
         NORECY = .TRUE.
         SWRECY = .FALSE.
         ENDIF
      IF (MPAT .EQ. 0) KSTAT(14) = 1
      IF (NORECY) THEN
         KEYOPT = 0
      ELSEIF (KPROG .GT. 0 .AND. KPROG .NE. 9 .AND. NRECYR.LE.3
     *      .AND. NOPHAS .EQ. 0) THEN
         KEYOPT = 1
      ELSE
         KEYOPT = 2
         ENDIF
      CALL XCONDA (ICOND, IDDS, ICENT, KEYOPT)
      NATL = NATIN
      RTYMAX = 0.0
      DO 800 I = 1, NAT
      CALL KERNAB (ATXYZ(1,I), ATX4(1,I), 3)
      ATX4(4,I) = ATXYZ(6,I)
      IF (ATXYZ(8,I) .GT. 0.0) GOTO 798
      ATX4(4,J) = -ATXYZ(6,I)
      IF (ATXYZ(8,I) .GT. -1.1) ATX4(4,J) = ATXYZ(8,I)
  798 N = NINT(ATXYZ(10,I))
      IF (N .EQ. 0) GOTO 800
      IF (RCELTY(N) .GT. RTYMAX) RTYMAX = RCELTY(N)
      ATXYZ(7,I) = RCELTY(N)
  800 CONTINUE
      NAT = MIN0 (NAT, NATNOH + 2 + NATNOH / 30)
      NPIC = NAT
      RTYMAX = 2.0 * RTYMAX
      IF (RTYMAX .GT. DMAXB .AND. ABS(1.95 - DMAXB) .LT. 0.001) THEN
         DMAXB = RTYMAX
         IF (DMAXB .GT. DMOUT) DMOUT = DMAXB
         ENDIF
      NNNN = 0
      DO 812 N = 1, NTYPE
      IF (NCELLZ(N) .NE. 1) NNNN = NNNN + NCELTY(N) * NCELLZ(N) ** 2
  812 CONTINUE
      ILAST = 1
      NNNR = 0
      DO 822 I =1, NAT
      IF (IZAT(I) .NE. 1) NNNR = NNNR + NINT(ATXYZ(9,I)) * IZAT(I) ** 2
      IF (IZAT(I) .NE. 1 .AND. NNNR .LE. NNNN) GOTO 820
      IF (NNNR .LE. NNNN*125/100) GOTO 820
      ATNAME(I) (1:1)  = 'Q'
      ATNAM = ATNAME(I) (3:6)
      ZZZ = ATNAME(I)(2:2)
      CALL KERC2I (ZZZ, LEND)
      IF (LEND.LT.0 .OR. LEND.GT.9) ATNAME(I)(2:6) = ATNAM
      IZAT(I) = 1
  820 CONTINUE
      IF (IFIX(ATXYZ(8,I)) .GE. 100) ILAST = I
      IF (NRECYR .LE. 2 .AND. IFIX(ATXYZ(8,I)) .GE. 60) ILAST = I
      IF (NRECYR .LE. 1 .AND. IFIX(ATXYZ(8,I)) .GE. 40) ILAST = I
  822 CONTINUE
      NAT = ILAST
      IF (NRECYR .EQ.1) WRITE (8, FMT='('' $TEM NRECYR'')')
      WRITE (8, 833)  NRECYR, IRECY, IRECYD, IRECYS
  833 FORMAT (/ ' $TEM NRECYR', I3,' IRECY(8) IRECYD IRECYS ', 8I3, 2I4)
      IF (NRECYS .LT. 7) RETURN
      SUMB2Z = 0.
      ISUMZ = 0
      DO 901 I=1, NAT
      CALL EXPEAK(5, I, 0, IB100)
      FB100 = FLOAT (IB100) / 100.
      B2Z = FLOAT( IZAT(I) ) * FB100 * FB100
      IF (IB100 .LT. 0) B2Z = -B2Z
      SUMB2Z = SUMB2Z + B2Z
      ISUMZ = ISUMZ + IZAT(I)
  901 CONTINUE
      SUMB2Z = SUMB2Z / FLOAT (ISUMZ)
      SUMB2S = SQRT ( ABS (SUMB2Z) )
      IF (SUMB2Z .LT. 0.0) SUMB2S = - SUMB2S
      WRITE (8, FMT='('' $TE AVERAGE B SHIFT IS:'', F7.3,
     *   '' reset !''  )') SUMB2S
      DO 905 I=1, NAT
      ATXYZ(5,I) = ATXYZ(5,I) - SUMB2S
  905 CONTINUE
      IF (NORECY .OR. NRECYS .LT. 8) RETURN
      WRITE (8, FMT='('' $TEMPPP last line DIRBF '')')
      RETURN
      END
      SUBROUTINE XCONDA (ICOND, IDDS, ICENT, KEYOPT)
      INCLUDE 'Zaaaa.inc'
      CALL WR24
      WRITE (8, FMT='(/'' ***** XCONDA *****''/
     *   20X, ''KEYOPT='' ,I3, ''  MPAT='',I3 / )') KEYOPT, MPAT
      CALL FILCLO (IDDS, 'KEEP')
      CALL FILINQ (IDDS, 'DDSYST', 'FORMATTED', 'OUTPUT', KINQ)
      CALL FILINQ (ICOND, 'CONDA', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (ICOND,
     *      FMT = '(''CONDA  '', A6, '' generated by XCONDA'' )') CCODE
      IF (KEYOPT .EQ. 0) THEN
         IF (MPAT .GT. -99 .AND. MPAT .LE. -2) CALL ATPATS(1)
         WRITE (24, *) 'Final SF'
      ELSEIF (KEYOPT .EQ. 1) THEN
         WRITE (ICOND, FMT = '(''PROGRAM DDMAIN'')')
         WRITE (ICOND, FMT = '(''OPTION 1 PHASEX 0 '')')
         WRITE (IDDS,  FMT = '(''DDMAIN'')')
         WRITE (ICOND, FMT = '(''PROGRAM  PHASEX  '')')
         WRITE (IDDS,  FMT = '(''PHASEX'')')
         WRITE (ICOND, FMT = '(''PROGRAM  DDMAIN  '')')
         WRITE (ICOND, FMT = '(''OPTION 2 FOUR.PH 0 '')')
         WRITE (IDDS,  FMT = '(''DDMAIN'')')
         WRITE (ICOND, FMT = '(''PROGRAM  FOUR '')')
         WRITE (IDDS,  FMT = '(''FOUR'')')
      ELSEIF (KEYOPT .GE. 2) THEN
         WRITE (ICOND, FMT ='(''PROGRAM DDMAIN'')')
         WRITE (ICOND, FMT = '(''OPTION 3 FOUR 0 '')')
         WRITE (IDDS, FMT = '(''DDMAIN'')')
         WRITE (ICOND, FMT = '(''PROGRAM  FOUR '')')
         WRITE (IDDS,  FMT = '(''FOUR'')')
         ENDIF
      WRITE (ICOND, FMT ='(''PROGRAM DDMAIN'')')
      WRITE (ICOND, FMT ='(''OPTION 0 FCALC'')')
      WRITE (IDDS, FMT = '(''DDMAIN'')')
      IF (ICENT.EQ.1 .AND. KEYOPT.EQ.0 .AND. R2X.LE.0.33) THEN
         KSTAT(14) = 1
         WRITE (ICOND, FMT ='(''PROGRAM NUTS BIJVOET'')')
         WRITE (IDDS,  FMT ='(''NUTS'')')
         ENDIF
      WRITE (ICOND, FMT ='(''PROGRAM NUTS AT2X'' / ''FINISH'')')
      WRITE (IDDS,  FMT ='(''NUTS''/''STOP'')')
      CALL FILCLO (ICOND, 'KEEP')
      CALL FILCLO (IDDS, 'KEEP')
      RETURN
      END
      SUBROUTINE ATN4CN (CHEM, NUMB, KEY, ATNAME, NAT, ATNEW)
      CHARACTER*2 CHEM
      CHARACTER*6 ATNAME(NAT), ATNEW, C, CNUMB
      ATNEW = ' '
      N = NUMB
  607 CALL KERI2C (N, CNUMB, 6)
      C(1:2) = CHEM
      C(3:6) = CNUMB
      IF (C(2:2) .EQ. ' ') C(2:6) = CNUMB
      IF (KEY .LE. 0) GOTO 999
      CALL KEREQ6 (C, ATNAME, KEY, KEND)
      IF (KEND .LE. 0) GOTO 999
      N = N + 100
      IF (N .LT. 300) N = N + 100
      IF (N .LT. 300) N = N + 100
      GOTO 607
  999 ATNEW = C
      RETURN
      END
      SUBROUTINE ATN2CN (ATNAM, CHEM, NUMB)
      CHARACTER*2 CHEM
      CHARACTER*6 ATNAM
      CHARACTER*1 Z, ZZ
      CHEM = ATNAM(1:2)
      NUMB = 0
      IF (CHEM(2:2) .EQ. ' ') RETURN
      I = 1
      Z = ATNAM(2:2)
      CALL KERC2I (Z, LEND)
      IF (LEND.LT.0 .OR. LEND.GT.9) I=2
      IF (I .EQ. 1) CHEM(2:2) = ' '
      DO 101 N = I+1, 6
      ZZ = ATNAM(2:2)
      CALL KERC2I (ZZ, LEND)
      IF (LEND .EQ. 10) RETURN
      IF (LEND.GE.0 .AND. LEND.LE.9) THEN
         NUMB = 10*NUMB + LEND
      ELSE
         IF (NUMB .EQ. 0) NUMB = 999
         NUMB = - NUMB
         RETURN
         ENDIF
  101 CONTINUE
      RETURN
      END
      SUBROUTINE ATN24X (ATNAM, ATNAME, NAT, ATNEW)
      CHARACTER*6 ATNAME(NAT), ATNAM, ATNEW, C
      CHARACTER*2 CHEM
      C = ATNAM
      ATNEW = ' '
      CALL KEREQ6 (C, ATNAME, NAT, KEND)
      IF (KEND .LE. 0) THEN
         ATNEW = C
         RETURN
         ENDIF
      CALL ATN2CN (C, CHEM, NUMB)
      N = IABS(NUMB)
      CALL ATN4CN (CHEM, N, NAT, ATNAME, NAT, ATNEW)
      RETURN
      END
      SUBROUTINE EXPEAK(KEY, IAT, MIAT, IZOLD)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      EQUIVALENCE (IDDL, IFILE(1))
      EQUIVALENCE (NTYPEZ, KEYS(4))
      EQUIVALENCE (IMAP, KSTAT(7))
      LOGICAL SWRECY
      EQUIVALENCE (SWITCH(7), SWRECY)
      DIMENSION PH(10,5)
      EQUIVALENCE (PH(1,1), PHFAC(1,1))
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zsear.inc'
      COMMON /DIRBFA/ NCELTY(10), NCELLZ(10), NCELIN(10), NCELIX(10)
      COMMON /DIRBFB/ ACELTY(10)
      CHARACTER ACELTY *2
      DIMENSION SUM1(10,2), SUM2(10,2), SUM3(10,2), EXPP(10), EXPP2(10)
      DIMENSION RSUM(10,2), TSUM1(2), TSUM2(2), TSUM3(2)
      DIMENSION NCELIC(10), DBDP(10)
      CHARACTER *6 ATOLD
      CHARACTER *2 AC
      IZOLD = 0
      MTYPE = NTYPEZ
      IF (ACELTY(NTYPE) .EQ. 'H ') MTYPE = MTYPE - 1
      IF (KEY .GT. 0) GOTO 203
      IF (KEY .LT. 0) GOTO 603
      ISKIP = 0
      BDELTN = 0.
      TPH = 8.
      ATOLD = ' '
      NUMB = 0
      XPPXX = 0.80
      NPRINT = 0
      CALL KERNZI (0, NCELIC, 10)
      IF (NRECYR .LE. 1)  WRITE(8,FMT='( / '' EXPH:'' ,
     *   '' Expected peak heights of atoms for five B values:''/)')
      IF (NRECYR .LE. 1) THEN
         WRITE (8,FMT='(''    for B =   '',5F7.3/
     *      '' Atom         '', 35(''-'')) ') BFAC
         DO 166 J=1,NTYPE
         WRITE(8,FMT='('' Type'',I2,3X,A2,1X,5F7.2)') J,CELATY(J),
     *         (PH(J,IH), IH=1,5)
  166    CONTINUE
         ENDIF
      BDELTN = BFAC(2)-BFAC(1)
      BNMIN = AMAX1 (0.9, 0.9 * BFAC(1))
      BNMAX = AMIN1 (9.9, 1.1 * BFAC(5))
      ISKIP = 1
      CALL KERNZA (0.0, SUM1, 20)
      CALL KERNZA (0.0, SUM2, 20)
      CALL KERNZA (0.0, SUM3, 20)
      CALL KERNZA (0.0, RSUM, 20)
      CALL KERNZA (1.0, EXPP, 10)
      CALL KERNZA (1.0, EXPP2, 10)
      CALL KERNZA (0.1, DBDP, 10)
      DO 171 JTYPE = 1, NTYPE
      AC = ACELTY(JTYPE)
      IF   (AC.EQ.'P ' .OR. AC.EQ.'S ' .OR. AC.EQ.'CL' .OR. AC.EQ.'SE'
     * .OR. AC.EQ.'F ' .OR. AC.EQ.'BR' .OR. AC.EQ.'I ') EXPP(JTYPE)=.90
      IF   (AC.EQ.'O ' .OR. AC.EQ.'N ' .OR. AC.EQ.'C ') EXPP(JTYPE)=.80
      DBDP(JTYPE)=BDELTN/
     *   AMIN1(-0.005, (PH(JTYPE,4)-PH(JTYPE,3))) /200.
  171 CONTINUE
      EXPP(NTYPEZ)= 0.70
      EXPP(MTYPE) = 0.70
      IF (NRECYR .LE. 1) WRITE(8,FMT=
     *   '(/'' EXPP atoms :'', 10(4X,A2))') (ACELTY(J), J=1,NTYPE)
      IF (NRECYR .LE. 1) WRITE(8,FMT=
     *   '( '' EXPP relax :'', 10F6.2 )') (EXPP(J), J=1,NTYPE)
      QQN = 0.
      QQS = 0.
      WQQN = 0.
      WQQS = 0.
      DO 172 I = 1, NTYPEZ
      IF (PH(I,3) .LT. 3.0) GOTO 172
      QQS = QQS + PH(I,3) * CELALL(I)
      QQN = QQN + CELALL(I)
      IF (CELATY(I) .EQ. 'C' .OR. CELATY(I) .EQ. 'N' .OR.
     *   (CELATY(I) .EQ. 'O' )) GOTO 172
      WQQS = WQQS + PH(I,3) * CELALL(I)
      WQQN = WQQN + CELALL(I)
  172 CONTINUE
      QQA = QQS/QQN
      WQQA = - 1.0
      IF (WQQN .GT. 9.) WQQA = WQQS / WQQN
      IQQ = NPIC * 95 / 100
      QQN = 0.
      QQS = 0.
      WQQN = 0.
      WQQS = 0.
      DO 174 J = 1, IQQ
      QQQ = ABS ( ATX4(4,J) )
      KK = QQQ * 10000.
      KK = KK - IFIX ( QQQ ) * 10000
      KK = ( FLOAT(KK) )**2 / 4000.
      FKK = KK
      IF (FKK .LT. 250.) GOTO 174
      QQS = QQS + FKK / 100.
      QQN = QQN + 1.
      WQQS = WQQS + FKK / 100.
      WQQN = WQQN + 1.
  174 CONTINUE
      IF (ABS(QQN) .GT. 0.1) THEN
         QQB = QQS/QQN
      ELSE
         QQB = 1.
         ENDIF
      QPPQQ = QQB / QQA
      WRITE (8, FMT ='(
     *   '' $TEMP Aver.[PH/EXPH=XPPF] = QPPQQ ='', F 6.3)') QPPQQ
      IF (WQQA .LT. 0.001) GOTO 184
      IF (WQQN .LT. 17.) GOTO 184
      WQQB = WQQS/WQQN
      WPPQQ = WQQB / WQQA
      IZOLD = NINT (1000. * WPPQQ)
  184 XPPXX = QPPQQ * 0.90
      IF (NRECYR .LE. 1) THEN
         XPPXX = QPPQQ * 0.60
         IF (NATS .LT. NPIC/5 .OR. PSQ .LT. 0.30) XPPXX = QPPQQ * 0.40
         IF (PSQ .LT. 0.20)  XPPXX = QPPQQ * 0.25
      ELSEIF (PSQ .LT. 0.50) THEN
         XPPXX = QPPQQ * 0.50
      ELSEIF (NRECYS.LE.4) THEN
         XPPXX = QPPQQ * 0.60
      ELSEIF (NRECYS.LE.8) THEN
         XPPXX = QPPQQ * 0.70
      ELSE
         XPPXX = QPPQQ * 0.75
         ENDIF
      IF (IMAP .EQ. 1) XPPXX = 0.25
      DO 194 JTYPE = 1, NTYPE
      EXPP2(JTYPE) = EXPP(JTYPE) * XPPXX
  194 CONTINUE
      WRITE (8, FMT='('' $TEMP EXPP2'', 10F6.2)')
     *   (EXPP2(IJ), IJ = 1, NTYPE)
      RETURN
  203 CONTINUE
      IF (ISKIP .EQ. 0) RETURN
      TT44 = 1.0
      IF (ABS(ATXYZ(4,IAT)) .LT. 0.9) THEN
         TT44 = ABS(ATXYZ(4,IAT))
         IF (TT44 .LT. 0.3333) TT44 = 0.3333
         IF (IPRY .GT. 0) WRITE(24, 205) IAT, ATNAME(IAT), TT44
         WRITE(24, 205) IAT, ATNAME(IAT), TT44
  205    FORMAT (' Warning: reduced occupancy of atom', I4,
     *     ' = ', A6,'  is',F7.4)
         ENDIF
      KK = ATXYZ(6,IAT) * 10000.
      KK = KK - IFIX ( ATXYZ(6,IAT)) * 10000
      KK = ( FLOAT(KK) )**2 / 4000.
      FKK = KK
      JNAT = 1
      IF (KEY .EQ. 3) JNAT = 2
      MIATX = MIAT
      IF (KEY .GE. 4) MIATX = 0
      XPPXX2 = 0.90
      IF (JNAT .EQ. 2) XPPXX2 = 0.85
      IF (NRECYR .LE. 1 .AND. JNAT .EQ. 2) XPPXX2 = 0.70
      IF (NRECYS .EQ. 2 .AND. JNAT .EQ. 2) XPPXX2 = 0.80
      IZOLD = 0
      NAGAIN = 0
  209 N = NINT(ATXYZ(10,IAT))
      DO 210 JTYPE = 1,NTYPEZ
      IF (CELATY(JTYPE) .EQ. ACELTY(N)) GOTO 215
  210 CONTINUE
  215 CONTINUE
      BTEMP = ATXYZ(5,IAT)
      IF (BTEMP .LE. 0.0001) BTEMP = BR
      IF (BTEMP .LE. BFAC(1)) THEN
         TPH = PH(JTYPE,1)
      ELSEIF (BTEMP .GE. BFAC(5)) THEN
         TPH = PH(JTYPE,5)
      ELSE
         IF (ABS(BDELTN) .LT. 0.01) STOP 31202
         DO 300 IB = 2,5
         IF (BTEMP .LE. BFAC(IB)) THEN
            BRATIO = (BTEMP - BFAC(IB-1)) / BDELTN
            TPH = PH(JTYPE,IB-1)+((PH(JTYPE,IB)-PH(JTYPE,IB-1))*BRATIO)
            GOTO 325
            ENDIF
  300    CONTINUE
         ENDIF
  325 CONTINUE
      IF (TPH .LT. 0.1) TPH = 0.7
      EXPH = TPH * 100.
      EXPH = TT44 * EXPH
      XPPF = FKK/EXPH
      IF (KEY .EQ. 5) GOTO 551
      IF (NAGAIN .NE. 0 .OR. IPRY .EQ. 0) GOTO 1234
      IF (IZAT(IAT) .LE. 6) GOTO 1234
      IF (KEY .EQ. 1 .AND. IAT .GT. MIAT) GOTO 1234
      IF ((IZAT(IAT).GT.8  .AND. XPPF .LT. 0.5) .OR.
     *    (IZAT(IAT).GT.20 .AND. XPPF .LT. 0.6))
     *    WRITE (8,350) IAT, ATNAME(IAT), FKK, EXPH
  350 FORMAT (' $TEMP WARNING PkHeight of atom',I4,
     *     ' = ', A6,' is',F6.0, ' Expected:', F6.0)
 1234 CONTINUE
      XPP = EXPP2(N) * XPPXX2
      IF (NAGAIN .LT. 0) GOTO 524
      IF (N .GE. MTYPE) GOTO 404
      IF (XPPF .GE. XPP) GOTO 404
      IF (NAGAIN .EQ. 0) THEN
         WRITE (8,351) IAT, ATNAME(IAT), FKK, EXPH, XPPF
  351    FORMAT (' $TE7 atom', I4, 1X, A6,' PH, exPH :', 2F7.0,
     *      ' PH/exPH factor =', F5.2)
         RSUM(N,JNAT) = RSUM(N,JNAT) + 1.
         IZOLD = IZAT(IAT)
         ATOLD = ATNAME(IAT)
         NAGAIN = 1
         ENDIF
      N = N + 1
      IZAT(IAT) = NCELLZ(N)
      ATXYZ(10,IAT) = N
      IF (KEY .EQ. 1 .AND. MIAT.NE.0) THEN
         CALL ATN2CN (ATOLD, AC, NUMB)
         NUMB = IABS (NUMB)
         IF (NUMB .EQ. 0 .OR. NUMB .GE. 999) NUMB = IAT
      ELSE
         NUMB = IAT
         ENDIF
      CALL ATN4CN (ACELTY(N), NUMB, MIATX, ATNAME, MIATX, ATNAME(IAT))
      GOTO 209
  404 IF (NAGAIN .GT. 0) THEN
         WRITE (8,407) IAT, ATNAME(IAT)
  407    FORMAT (' New name',I4, ' = ', A6)
         IF (IAT .LE. NATSN) WRITE(24, 408) IAT, ATOLD, ATNAME(IAT)
  408    FORMAT (/' Original input atom ',I4, ' = ', A6,
     *      ' renamed to ', A6, ' LOW PEAK HEIGHT'/)
         ENDIF
      IF (KEY .EQ. 2) GOTO 422
      SUM1(N,JNAT) = SUM1(N,JNAT) + FKK
      SUM2(N,JNAT) = SUM2(N,JNAT) + EXPH
      SUM3(N,JNAT) = SUM3(N,JNAT) + 1.
  422 CONTINUE
      IF (IMAP .EQ. 1) GOTO 444
      IF (NAGAIN .GE. 1 .OR. N .LE. 1 .OR. NRECYR .LE. 2
     *   .OR. PSQ .LE. 0.85 .OR. XPPF .LT. 0.90*EXPP(N)) GOTO 444
      IF (XPPF .LT. 1.20 * QPPQQ) GOTO 444
      IF (ABS(XPPXX) .LT. 0.01) STOP 33444
      XPPNEW = QPPQQ * EXPP2(N-1) / XPPXX
      DO 425 JT = 1,NTYPEZ
      IF (CELATY(JT) .EQ. ACELTY(N-1)) GOTO 426
  425 CONTINUE
  426 CONTINUE
      EXPHNW = EXPH * PH(JT,3) / PH(JTYPE,3)
      XPPFNW = FKK / EXPHNW
      IF (XPPFNW .GT. 1.70 * XPPNEW ) THEN
         IF (NPRINT .EQ. 0) THEN
            WRITE (8, FMT='('' $TEM FLIPZ Cy  -atom-    FKK   '',
     *         '' EXPHNW  XPPFNW  XPPNEW   new at.name?'' )')
            NPRINT = 1
            ENDIF
         IF (XPPFNW .LT. 1.80 * XPPNEW) THEN
            WRITE (8,432)
     *      NRECYR, IAT, ATNAME(IAT), FKK, EXPHNW, XPPFNW, XPPNEW
  432       FORMAT (' $TEM FLIPZ', I3, I4, 1X, A6, 2F7.0, 2F7.2,
     *         5X, A2)
            GOTO 444
            ENDIF
         WRITE (8,432)
     *      NRECYR, IAT, ATNAME(IAT), FKK, EXPHNW, XPPFNW, XPPNEW,
     *      CELATY(JT)
         III = MAX0 (2, NCELIX(N-1)/20)
         IF (NCELIC(N-1) .GE. III) GOTO 444
         IF ( PSQ.LE.0.85 .OR. NRECYS.LE.3 ) GOTO 444
         IF ( NRECYS.LE.4 .AND. XPPF.GT.2.5) GOTO 500
         IF ( NRECYS.LE.6 .AND. XPPF.GT.2.0 .AND. R2X.LT.0.30) GOTO 500
         IF ( NRECYS.LE.8 .AND. XPPF.GT.1.8 .AND. R2X.LT.0.20) GOTO 500
         IF ( NRECYS.LE.10.AND. XPPF.GT.1.6 .AND. R2X.LT.0.20) GOTO 500
         IF ( NRECYS.LE.18.AND. XPPF.GT.1.5 .AND. R2X.LT.0.15) GOTO 500
         ENDIF
  444 RETURN
  500 CONTINUE
      IZOLD = IZAT(IAT)
      FKKOLD = FKK
      XPPFOL = XPPF
      ATOLD = ATNAME(IAT)
      NAGAIN = -1
      N = N - 1
      IZAT(IAT) = NCELLZ(N)
      ATXYZ(10,IAT) = N
         IF (KEY .EQ. 1 .AND. MIAT.NE.0) THEN
         CALL ATN2CN (ATOLD, AC, NUMB)
         NUMB = IABS (NUMB)
         IF (NUMB .EQ. 0 .OR. NUMB .GE. 999) NUMB = IAT
      ELSE
         NUMB = IAT
         ENDIF
      CALL ATN4CN (ACELTY(N), NUMB, MIATX, ATNAME, MIATX, ATNAME(IAT))
      GOTO 209
  524 CONTINUE
      IF (XPPF .GE. XPP + 0.20) GOTO 544
      IF (NRECYR .GE. 6 .AND. XPPF .GE. XPP + 0.15) GOTO 544
      WRITE (8, FMT='('' $TE UPGRADE? No: atom name not changed'')')
      IZAT(IAT) = IZOLD
      IZOLD = 0
      ATNAME(IAT) = ATOLD
      N = N + 1
      ATXYZ(10,IAT) = N
      GOTO 444
  544 CONTINUE
      WRITE (8, FMT='('' $TE new name: Cy'',I3,'' atom '', I4, 1X,
     *   A6, '' R2'', F5.2, '' PH XPPF'',F6.0, F5.2, '' >> '',A6 )')
     *   NRECYR, IAT, ATOLD, R2X, FKKOLD, XPPFOL, ATNAME(IAT)
      IF (IAT .LE. NATSN) WRITE(24, 548) IAT, ATOLD, ATNAME(IAT)
  548 FORMAT (/' Original input atom ',I4, ' = ', A6,
     *   ' renamed to ', A6, ' HIGH PEAK HEIGHT'/)
      RETURN
  551 CONTINUE
      IZOLD = 0
      IF (NPRINT .NE. -12459) RETURN
      DELB = DBDP(JTYPE) * ( FKK - QPPQQ * EXPH )
      BNEW = BTEMP + DELB
      IF (BNEW .LT. BNMIN) BNEW = BNMIN
      IF (BNEW .GT. BNMAX) BNEW = BNMAX
      WRITE (8, 1551) BTEMP, BR, BNEW, XPPF, QPPQQ, IZAT(IAT)
 1551 FORMAT (' $TE modify B!  B BR BNEW XPPF QPPQQ Z', 5F5.2, I4)
      BNEW = 0.75 * BTEMP + 0.25 * BNEW
      ATXYZ(5,IAT) = BNEW
      DELB = BNEW - BTEMP
      IZOLD = NINT ( DELB * 100. )
      RETURN
  603 CONTINUE
      WRITE (8, FMT='(//'' EXPEAK entry -1 (print) '', I2//)') ISKIP
      IF (ISKIP .EQ. 0) RETURN
      DO 614 JNAT = 1, 2
      TSUM1(JNAT) = 0.0
      TSUM2(JNAT) = 0.0
      TSUM3(JNAT) = 0.0
      DO 613 J = 1, NTYPEZ
      TSUM1(JNAT) = TSUM1(JNAT) + SUM1(J,JNAT)
      TSUM2(JNAT) = TSUM2(JNAT) + SUM2(J,JNAT)
      TSUM3(JNAT) = TSUM3(JNAT) + SUM3(J,JNAT)
      IF (SUM3(J,JNAT) .LT. 0.5) THEN
         SUM1(J,JNAT) = 0.0
      ELSE
         SUM1(J,JNAT) = SUM1(J,JNAT) / SUM3(J,JNAT)
         ENDIF
      IF (SUM3(J,JNAT) .LT. 0.5) THEN
         SUM2(J,JNAT) = 0.0
      ELSE
         SUM2(J,JNAT) = SUM2(J,JNAT) / SUM3(J,JNAT)
         ENDIF
  613 CONTINUE
      IF (TSUM3(JNAT) .LT. 0.5) THEN
         TSUM1(JNAT) = 0.0
         TSUM2(JNAT) = 0.0
      ELSE
         TSUM1(JNAT) = TSUM1(JNAT) / TSUM3(JNAT)
         TSUM2(JNAT) = TSUM2(JNAT) / TSUM3(JNAT)
         ENDIF
  614 CONTINUE
      ATOLD = 'all'
      WRITE (8, 643)
  643 FORMAT (/' Statistics for PH (Peak height), EXPH (Expected PH),'
     *  /' (averaged) for input atoms (INPUT) and new peak (PEAKS) with'
     *  /' expected ratios PH/EXPH, and applied factor for Z-reduction')
      WRITE (8, 644) (ACELTY(I), I=1,NTYPEZ), ATOLD
  644 FORMAT (/' For atom types: ', 11(3X, A3))
      WRITE (8, 645) (SUM3(I,1), I=1,NTYPEZ), TSUM3(1)
  645 FORMAT ( ' nr.atoms: INPUT ', 11F6.0)
      WRITE (8, 646) (SUM3(I,2), I=1,NTYPEZ), TSUM3(2)
  646 FORMAT ( '     + new PEAKS ', 11F6.0)
      WRITE (8, 647) (SUM1(I,1), I=1,NTYPEZ), TSUM1(1)
  647 FORMAT (/' aver. PH: INPUT ', 11F6.0)
      WRITE (8, 648) (SUM1(I,2), I=1,NTYPEZ), TSUM1(2)
  648 FORMAT ( '           PEAKS ', 11F6.0)
      WRITE (8, 649) (SUM2(I,1), I=1,NTYPEZ), TSUM2(1)
  649 FORMAT (/' av. EXPH: INPUT ', 11F6.0)
      WRITE (8, 650) (SUM2(I,2), I=1,NTYPEZ), TSUM2(2)
  650 FORMAT ( '           PEAKS ', 11F6.0)
      DO 664 JNAT = 1, 2
      DO 663 J = 1, NTYPEZ
      IF (SUM2(J,JNAT) .GT. 0.1) THEN
         SUM1(J,JNAT) = SUM1(J,JNAT) / SUM2(J,JNAT)
      ELSE
         SUM1(J,JNAT) = 0.0
         ENDIF
  663 CONTINUE
      IF (TSUM2(JNAT) .GT. 0.1) THEN
         TSUM1(JNAT) = TSUM1(JNAT) / TSUM2(JNAT)
      ELSE
         TSUM1(JNAT) = 0.0
         ENDIF
  664 CONTINUE
      WRITE (8, 675) (SUM1(I,1), I=1,NTYPEZ), TSUM1(1)
  675 FORMAT (/'  PH/EXPH::INPUT ', 11F6.2)
      WRITE (8, 676) (SUM1(I,2), I=1,NTYPEZ), TSUM1(2)
  676 FORMAT ( '           PEAKS ', 11F6.2)
      WRITE (8, 691) (EXPP2(I), I=1,NTYPEZ)
  691 FORMAT (/' minimum PH/EXPH'  /' required: INPUT ', 11F6.2)
      RSUM1 = 0.
      RSUM2 = 0.
      DO 693 N = 1, NTYPEZ
      RSUM1 = RSUM1 + RSUM(N,1)
      RSUM2 = RSUM2 + RSUM(N,2)
      EXPP2(N) = XPPXX2 * EXPP2(N)
  693 CONTINUE
      WRITE (8, 695) (EXPP2(I), I=1,NTYPEZ)
  695 FORMAT ( '   for new PEAKS ', 11F6.2)
      WRITE (8, 697) (RSUM(I,1), I=1,NTYPEZ), RSUM1
  697 FORMAT (/' Nr of atoms with'
     *        /' reduced Z INPUT ', 11F6.0)
      WRITE (8, 698) (RSUM(I,2), I=1,NTYPEZ), RSUM2
  698 FORMAT ( ' reduced Z PEAKS ', 11F6.0)
      WRITE (8, FMT='(1X)')
      RETURN
      END
      SUBROUTINE DIRBD
      INCLUDE 'Zsyst.inc'
      WRITE(24, 1)
      WRITE (8, 1)
   1  FORMAT (/' WARNING !!, INPUT ATOMS ARE NOT AVERAGED WITH'/
     + ' PEAK POSITIONS:  LOOK AT YOUR HEAVY ATOM SHIFTS'/
     + ' ESPECIALLY WITH VERY STRONG "RESIDUAL" PEAKS...'/)
      RETURN
      END
      SUBROUTINE DIRBP
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zsear.inc'
      EQUIVALENCE (IATOMS, IFILE(1))
      EQUIVALENCE (IMAP, KSTAT(7))
      DIMENSION XS(3)
      IF (IMAP .EQ. 6 )  WRITE(24, 1)
      IF (IMAP .EQ. 6 )  WRITE (8, 1)
   1  FORMAT (' Patterson peak coordinates written to file ATOMS')
      WRITE(24, 2)
   2  FORMAT (' List of ten highest Patterson peaks and their vector',
     + ' length',/,
     +        '    Peak  height ',4X,'x',7X,'y',7X,'z    length'/)
      WRITE (8, 3)
   3  FORMAT (' List of Patterson peaks and their vector length'/
     +        '    Peak  height ',4X,'x',7X,'y',7X,'z    length'/)
      NPEAK = 1
      IF (IMAP .EQ. 6) THEN
         CHOUT = 'Patterson peaks (not atoms !)'
         CALL ATOMWA (IATOMS)
         ENDIF
      NAT = MIN0 (NPIC, NATX)
      DO 50 I = 1,NAT
      IF (ATX4(4,I) .LE. 0.5) GOTO 333
      DDIST=999.
      DO 3040 II = NLATT,1,-1
      DO 30 L = 1,3
      XS(L) = ATX4(L,I)-TLATT(L,II)
      IF (ABS(XS(L)) .GT. 0.5) XS(L) = XS(L) - SIGN(1.0,XS(L))
   30 CONTINUE
      DIST = SQRT ( QUAD2 (XS, XS) )
 3040 DDIST = AMIN1(DIST,DDIST)
      IF (I .LE. 10) WRITE(24,  35) NPEAK, ATX4(4,I), XS, DDIST
      WRITE (8,  35) NPEAK, ATX4(4,I), XS, DDIST
   35 FORMAT (I8, F8.0, 3F8.4, F8.2)
      IF (IMAP .EQ. 6) WRITE (IATOMS, 36) NPEAK, XS, ATX4(4,I)
   36 FORMAT ('ATOM   Q', I3, 2X, 3F8.5, ' Peakheight ', F8.0)
      NPEAK = NPEAK + 1
   50 CONTINUE
  333 IF (IMAP .EQ. 6) WRITE (IATOMS, FMT='(''END'')')
      CALL FILCLO( IATOMS, 'KEEP')
      CALL KEPROX
      KEYS(10) = 17
      RETURN
      END
      SUBROUTINE DIRBB
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zsear.inc'
      COMMON /BLANK/ IFRAG(MAXAT), ISYM(MAXAT),     IDUM(MAXAT),
     *               DUM(MAXAT),   IBOND(MAXAT*10), JBOND(MAXAT*10),
     *               XXXGEO(135520)
      DIMENSION JCON(MAXAT)
      EQUIVALENCE (JCON(1), ISYM(1))
      COMMON /XXANG/ KANG(64), LANG(64), KLANG(64)
      LOGICAL SWRECY, NORECY, REN98
      EQUIVALENCE (SWITCH(16), REN98)
      EQUIVALENCE (SWRECY, SWITCH(7)), (NORECY, SWITCH(8))
      DIMENSION XS(3), XST(3), XSHIFT(3)
      DIMENSION VEC(3,9)
      LOGICAL ID
      DATA ID / .FALSE. /
      CALL WR24
      WRITE (8, 106) NRECYR, NRECYS, NRECYT
  106 FORMAT (/' ***** DIRBB  *****', 29X,'[cycle', I3, ' /',I3,I2,']'/)
      IF (IPRY.NE.0) WRITE (IPRY, 200)
  200 FORMAT (/' Table 315-1  Interatomic bonding distances  (Angstrom)'
     *  //'      Atom    peak',
     *   /'  No. name  integr N1 dist  N2 dist  N3 dist  ....'
     *   /'              x100'/)
      NMAX = 0
      IANG = 1
      DO 500 I = 1, NAT
      IF (IPRY.NE.0 .AND. I.EQ.NATSN+1 .AND. NRECYR .LE. 1)
     *   WRITE (IPRY, FMT = '('' New atoms:'')')
      IF (IPRY.NE.0 .AND. I.EQ.NATSN+1 .AND. NRECYR .GT. 1)
     *   WRITE (IPRY, FMT = '('' New atoms, including those added '',
     *      '' earlier (resorted/renamed):'')')
      RTYI = ATXYZ(7,I)
      N = 0
      II= 0
      DO 430 J = 1, NAT
      DAV2 = (ATXYZ(7,J) + RTYI) **2
      IF (I .EQ. J) ID = .TRUE.
      DO 400 IS = 1, NSYMM
      CALL SYMOP1 (IS, ATX4(1,J), XS)
      DO 400 IC = 1, ICENT
      DO 400 IL = 1, NLATT
      IF (ID) THEN
         ID = .FALSE.
         GOTO 400
         ENDIF
      CALL SYMOP2 (IC, IL, XS, XST)
      CALL DISTSQ (ATXYZ(1,I), XST, DMAXB, XSHIFT, DIST2)
      IF (DIST2 .GT. DAV2) GOTO 400
      IF (I .NE. J) GOTO 350
      II = 1
      IF (DIST2 .LT. 0.04) GOTO 400
      II = 2
  350 N = N + 1
      IDUM(N) = J
      DUM(N) = SQRT(DIST2)
      IF (DUM(N) .LT. 0.85  .AND. IPRY.NE.0) THEN
         WRITE (IPRY, 355) I, J
         IF (I .LE. NATSN .AND. J .LE. NATSN) WRITE (IPRY, 356)
  355    FORMAT (I5, ' short contact with No.' , I4)
  356    FORMAT ('+', 30X, '... possible input error ... ')
         ENDIF
      IF (N .LE. 9) THEN
         CALL KERNAB (XSHIFT, VEC(1,N), 3)
      ELSE
         NMAX = 10
         ENDIF
  400 CONTINUE
  430 CONTINUE
      IFRAG(I) = N
      JCON(I) = 0
      IF (IPRY.NE.0) THEN
      IF (II .EQ. 1) WRITE (IPRY, 441) I
  441 FORMAT (/ I5,' lies on a symmetry element')
      IF (II .EQ. 2) WRITE (IPRY, 442) I
  442 FORMAT (/ I5,' is close to a symm. element')
      IF (N .EQ. 0) WRITE (IPRY, 443) I, ATNAME(I), ATXYZ(8,I)
  443 FORMAT (I5, 1X, A6, F6.0, ' *')
      ENDIF
      IF (N .LE. 0) GOTO 500
      IF (IPRY.NE.0)
     * WRITE (IPRY,445) I, ATNAME(I), ATXYZ(8,I), (IDUM(K),DUM(K),K=1,N)
  445 FORMAT (I5, 1X, A6, F6.0, 6(I4,F5.2)/ (18X, 6(I4,F5.2)) )
      IF (N .GT. 0) CALL GEOFOB (0, I, 0.0)
      IF (N .LE. 1) GOTO 500
      IF (IANG .GE. 10*MAXAT - 64) GOTO 500
      N = MIN0 (N, 9)
      IFRAG(I) = N
      IBAD= 10*I - 9
      CALL KERNAI (IDUM, IBOND(IBAD), N)
      JCON(I) = IANG
      DO 458 K = 1, N-1
      QK = DUM(K)
      QK2 = QK * QK
      DO 457 L = K+1, N
      QL = DUM(L)
      IF (QL .LT. 0.3 .OR. QK .LT. 0.3) THEN
         JBOND(IANG) = 0
         GOTO 453
         ENDIF
      DO 450 J = 1, 3
  450 XSHIFT(J) = VEC(J,L) - VEC(J,K)
      CALL VMATV1 (XSHIFT, RRMAT, XSHIFT, QJ2)
      JBOND(IANG) = NINT (
     *   ACOS ((QK2 + QL*QL - QJ2) / (2.00001 * QK*QL)) / D2R  )
  453 IANG = IANG + 1
  457 CONTINUE
  458 CONTINUE
  500 CONTINUE
      IF (IPRY.NE.0 .AND. NMAX .GT. 9) WRITE (IPRY, 502)
  502 FORMAT (/
     *  ' Note: angles are calculated only for the first 9 contacts')
      IANG = 1
      IF (NORECY) WRITE (8, FMT='(  '' For distances and angles,
     * plots and COORDINATES see LIS1'')')
      IF (IPRY.NE.0) THEN
         IF (NAT. LE. 99) WRITE (IPRY, 510)
  510 FORMAT (/' Table 315-2    Interatomic bonding angles'/
     *   /'     Atom   peak'
     *   /'  No name integr  N1-No-N2 ang  N1-No-N3 ang  ......'
     *   /'            x100'/)
         IF (NAT. GT. 99) WRITE (IPRY, 511)
  511 FORMAT (/' Table 315-2    Interatomic bonding angles'/
     *   /'      Atom    peak'
     *   /'   No name  integr     N1-No-N2  ang      N1-No-N3 ang  ...'
     *   /'             x100'/)
         ENDIF
      DO 800 I = 1, NAT
      IF (IPRY.NE.0 .AND. I .EQ. NATSN+1 .AND. NRECYR .LE. 1)
     *   WRITE (IPRY, FMT = '('' New atoms:'')')
      IF (IPRY.NE.0 .AND. I .EQ. NATSN+1 .AND. NRECYR .GT. 1)
     *   WRITE (IPRY, FMT = '('' New atoms, including those added '',
     *      '' earlier (resorted/renamed):'')')
      M = 0
      IF (JCON(I) .LE. 0) GOTO 790
      N = IFRAG(I)
      IBAD= 10*I - 9
      CALL KERNAI (IBOND(IBAD), IDUM, N)
      DO 758 K = 1, N-1
      DO 757 L = K+1, N
      IF (JBOND(IANG) .EQ. 0) GOTO 753
      M = M + 1
      KLANG(M) = JBOND(IANG)
      KANG(M) = IDUM(K)
      LANG(M) = IDUM(L)
  753 IANG = IANG + 1
  757 CONTINUE
  758 CONTINUE
  790 IF (M .LE. 0) THEN
         IF (IPRY.NE.0) THEN
           IF (NAT. LE. 99) WRITE (IPRY, 791) I, ATNAME(I), ATXYZ(8,I)
  791      FORMAT (I4, 1X, A6, F5.0, 1X, '*')
           IF (NAT. GT. 99) WRITE (IPRY, 792) I, ATNAME(I), ATXYZ(8,I)
  792      FORMAT (I5, 2X, A6, F6.0, 1X, '*')
           ENDIF
         GOTO 800
         ENDIF
      IF (NAT .LE. 99) THEN
         IF(IPRY.NE.0) WRITE (IPRY, 794) I, ATNAME(I), ATXYZ(8,I),
     *     (KANG(J), I, LANG(J), KLANG(J), J=1,M)
  794    FORMAT (I4, 1X, A6, F5.0, 4(I4,2I3,I4) / (16X, 4(I4,2I3,I4) ))
      ELSE
         IF(IPRY.NE.0) WRITE (IPRY, 795) I, ATNAME(I), ATXYZ(8,I),
     *     (KANG(J), LANG(J), KLANG(J), J=1,M)
  795    FORMAT (I5, 2X, A6, F6.0, 4(3I4, '.') / (19X, 4(3I4, '.') ))
         ENDIF
      CALL GEOFOB (M, I, 0.0)
  800 CONTINUE
      CALL FCALR2
      RETURN
      END
      SUBROUTINE GEOFOB (KEYGEO, IGEO, ZSCAL)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zsear.inc'
      INCLUDE 'Zatomx.inc'
      COMMON /BLANK/ IFRAG(MAXAT), ISYM(MAXAT),     IDUM(MAXAT),
     *               DUM(MAXAT),   IBOND(MAXAT*10), JBOND(MAXAT*10),
     *               IFOB(3,1000), AFOB(1000),      IFOBC(10,100),
     *               WFOB(MAXAT),  WFOBA(MAXAT),    WFOBC(MAXAT),
     *               XXGEO(127460)
      COMMON /XXANG/ KANG(64), LANG(64), KLANG(64)
      LOGICAL REN98, SWRECY
      EQUIVALENCE (SWITCH(16), REN98), (SWITCH(7), SWRECY)
      LOGICAL CONT
      CHARACTER ZZZ *1
      DATA DMINX, DMIN, DMAX, DMAXX / 1.10, 1.20, 1.57, 1.70 /
      DATA EMINX, EMIN, EMAX, EMAXX /  90., 103., 126., 139. /
      DATA WANG / 0.5 /
      DATA DELMIN, DELMAX, ELMIN, ELMAX / .15, .15, 10., 10. /
      DATA LFOB, LFOBC, M / 0, 0, 0 /
      IF (KEYGEO .EQ. 0 .AND. IGEO .EQ. 0) THEN
         CONT = .FALSE.
         RETURN
         ENDIF
      IF (REN98) THEN
         IF (KEYGEO .LT. 0) KEYS(24) = 0
         RETURN
         ENDIF
      IF (CONT) GOTO 111
      CONT = .TRUE.
      CALL KERNZI (0, IFOB, 3000)
      CALL KERNZA (0., AFOB, 1000)
      CALL KERNZI (0, IFOBC, 1000)
      LFOB = 0
      LFOBC = 0
      DELMIN = DMIN - DMINX
      DELMAX = DMAXX - DMAX
      ELMIN = EMIN - EMINX
      ELMAX = EMAXX - EMAX
  111 I = IGEO
      IF (KEYGEO) 517, 117, 317
  117 CONTINUE
      IF (IZAT(I) .GT. 9) RETURN
      M = IFRAG(I)
      IF (LFOB .EQ. 1000) GOTO 138
      DO 137 N = 1, M
      J = IDUM(N)
      IF (IZAT(J) .GT. 9) GOTO 137
      IF (J .LT. I) GOTO 137
      IF (DUM(N).GT.DMIN .AND. DUM(N).LT.DMAX) GOTO 137
      IF (DUM(N) .GT. 1.35) THEN
         FOB = AMIN1 (1.4, (DUM(N)-DMAX) / DELMAX)
      ELSE
         FOB = AMIN1 (1.4, (DMIN-DUM(N)) / DELMIN)
         ENDIF
      IF (FOB .LT. 0.1) GOTO 137
      LFOB = LFOB + 1
      IFOB(1,LFOB) = 0
      IFOB(2,LFOB) = I
      IFOB(3,LFOB) = J
      AFOB(LFOB) = FOB
  137 CONTINUE
  138 IF (M .LE. 4) RETURN
      IF (LFOBC .EQ. 100) RETURN
      M = MIN0 (M, 9)
      LFOBC = LFOBC + 1
      IFOBC(1, LFOBC) = I
      CALL KERNAI (IDUM(1), IFOBC(2, LFOBC), M)
      RETURN
  317 CONTINUE
      IF (IZAT(I) .GT. 9) RETURN
      IF (LFOB .EQ. 1000) RETURN
      M = KEYGEO
      DO 337 N = 1, M
      ANG = KLANG(N)
      IF (ANG.GT.EMIN .AND. ANG.LT.EMAX) GOTO 337
      K = KANG(N)
      IF (IZAT(K) .GT. 9) GOTO 337
      J = LANG(N)
      IF (IZAT(J) .GT. 9) GOTO 337
      IF (ANG .GT. 115) THEN
         FOB = AMIN1 (1.4, (ANG-EMAX) / ELMAX)
      ELSE
         FOB = AMIN1 (1.4, (EMIN-ANG) / ELMIN)
         ENDIF
      IF (FOB .LT. 0.1) GOTO 337
      LFOB = LFOB + 1
      IFOB(1,LFOB) = K
      IFOB(2,LFOB) = I
      IFOB(3,LFOB) = J
      AFOB(LFOB) = FOB * WANG
  337 CONTINUE
      RETURN
  517 CONTINUE
      IF (NAT .LE. 5) RETURN
      IF (NRECYR .LE. 1) THEN
         MSKIP = (NAT - NATS + 3) / 4
      ELSE
         MSKIP = NAT / 4
         ENDIF
      SCFOB = SQRT(600./ZSCAL)
      NSKIP = 0
      NSKIPT = 0
  555 CALL KERNZA (0., WFOB, NAT)
      CALL KERNZA (0., WFOBA, NAT)
      CALL KERNZA (0., WFOBC, NAT)
      IF (LFOB+LFOBC .EQ. 0) GOTO 901
      IF (LFOB .EQ. 0) GOTO 578
      DO 577 N = 1, LFOB
      K = IFOB(1,N)
      I = IFOB(2,N)
      J = IFOB(3,N)
      IF (I .LE. 0 .OR. J .EQ. 0) GOTO 577
      IF (I .GT. MAXAT) GOTO 577
      IF (IZAT(I) .GT. 9) THEN
          IFOB(2,N) = 0
          GOTO 577
          ENDIF
      IF (K .EQ. 0) THEN
         WFOB(I) = SQRT(WFOB(I)**2 + AFOB(N)**2)
         WFOB(J) = SQRT(WFOB(J)**2 + AFOB(N)**2)
      ELSE
         IF ( K .GT. MAXAT .OR. J .GT. MAXAT ) GOTO 577
         IF ( K .LT. 0 .OR. J .LE. 0 ) GOTO 577
         WFOBA(I) = SQRT(WFOBA(I)**2 + AFOB(N)**2)
         WFOBA(J) = SQRT(WFOBA(J)**2 + AFOB(N)**2)
         WFOBA(K) = SQRT(WFOBA(K)**2 + AFOB(N)**2)
         ENDIF
  577 CONTINUE
  578 CONTINUE
      IF (LFOBC .EQ. 0) GOTO 598
      DO 587 N = 1, LFOBC
      I = IFOBC(1, N)
      IF (I .EQ. 0) GOTO 587
      IF (IZAT(I) .GT. 9) THEN
          IFOBC(1,N) = 0
          GOTO 587
          ENDIF
      WFOBC(I) = WFOBC(I) + 1.
      DO 581 NN = 2, 10
      NNN = IFOBC(NN, N)
      IF (NNN .EQ. 0) GOTO 581
      WFOBC(NNN) = WFOBC(NNN) + 1.
  581 CONTINUE
  587 CONTINUE
  598 CONTINUE
      XMAX = 0.
      IXMAX = 0
      DO 625 I = 1, NAT
      IF (IZAT(I).GT.9) GOTO 625
      XX = (WFOB(I) + WFOBA(I) + WFOBC(I))*SCFOB/ATX4(4,I)
      IF (I .LT. 10) XX = XX * FLOAT(I) / 10.
      IF (XX .GT. XMAX) THEN
         XMAX = XX
         IXMAX = I
         ENDIF
  625 CONTINUE
      I = IXMAX
      IF (I .EQ. 0) GOTO 901
      IF (XMAX .LT. 0.9) GOTO 901
      CALL WR24
      IF (SWRECY .AND. (NRECYR .GT. 1 .OR. I .GT. NATSN)) THEN
         IF (ATNAME(I)(1:1) .NE. 'Q')
     *      WRITE (8, FMT='('' Bad geometry: atom'',I4, 1X, A6,
     *      '' GEOFOB ='',F6.2,'' atom rejected :Q'')') I,ATNAME(I),XMAX
         IF (I .LE. NATSN) THEN
            NSKIP = NSKIP + 1
            write(24, FMT='('' Bad geometry: atom'',I4, 1X, A6,
     *          '' is rejected !'' )') I,ATNAME(I)
            ENDIF
         ATNAME(I)(1:1) = 'Q'
         ZZZ = ATNAME(I)(2:2)
         CALL KERC2I (ZZZ, LEND)
         IF ((LEND.LT.0).OR.(LEND.GT.9)) ATNAME(I)(2:6) = ATNAME(I)(3:6)
         IZAT(I) = 1
         IF (I .LE. NATREC + NSKIPT) NSKIPT = NSKIPT + 1
      ELSE
         IF (I .LE. NATSN .OR. I .LE. (NATREC*10)/11 )
     *      write(24, FMT='('' Bad geometry for atom'',I4, 1X, A6,
     *          ''  but atom is retained !'' )') I,ATNAME(I)
         WRITE (8, FMT='('' Bad geometry: atom'',I4, 1X, A6,
     *   '' GEOFOB ='', F6.2, '' atom retained !!'' )') I,ATNAME(I),XMAX
         ENDIF
      IF (NSKIPT .GE. MSKIP) GOTO 901
      IF (LFOB .EQ. 0) GOTO 638
      NC = 0
      DO 637 N = 1, LFOB
      IF (IFOB(1,N).EQ.I .OR. IFOB(2,N).EQ.I .OR. IFOB(3,N).EQ.I)
     *   IFOB(2,N) = 0
      IF (IFOB(2,N) .EQ. 0) NC = NC + 1
  637 CONTINUE
      IF (NC .EQ. LFOB) LFOB = 0
  638 CONTINUE
      IF (LFOBC .EQ. 0) GOTO 698
      NC = 0
      DO 687 N = 1, LFOBC
      IF (IFOBC(1, N    ) .EQ. I) IFOBC(1, N    ) = 0
      IF (IFOBC(1, N    ) .EQ. 0) THEN
         NC = NC+ 1
         GOTO 687
         ENDIF
      NNC = 0
      DO 681 NN = 2, 10
      IF (IFOBC(NN, N    ) .EQ. I) IFOBC(NN, N    ) = 0
      IF (IFOBC(NN, N    ) .GT. 0) NNC = NNC + 1
  681 CONTINUE
      IF (NNC .GT. 4) GOTO 687
      IFOBC(1,LFOBC) = 0
      NC = NC + 1
  687 CONTINUE
      IF (NC .EQ. LFOBC) LFOBC = 0
  698 CONTINUE
      GOTO 555
  901 CONTINUE
      IF (NSKIPT .GT. NSKIP) WRITE(24, 903) NSKIPT
  903    FORMAT (' Nr of peaks not output because of bad geometry:', I4)
      KEYS(24) = NSKIP
      RETURN
      END
      SUBROUTINE FCALR2
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zbinx.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zbuff.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zsear.inc'
      COMMON /BLANK/ DUMFC(19630),
     *               ITATQQ(MAXAT),    ITAT1(MAXAT),   ITAT3(MAXAT),
     *               ACI(3,3,MAXAT), BCI(3,3,MAXAT), DUMMY(118950)
      COMMON /DIRBFA/ NCELTY(10), NCELLZ(10), NCELIN(10), NCELIX(10)
      COMMON /DIRBFB/ ACELTY(10)
      CHARACTER ACELTY *2
      EQUIVALENCE (ICRYS, IFILE(3))
      DIMENSION NCELL1(10), NCELL3(10), IZTYP1(10), IZTYP3(10)
      DIMENSION BMINX(3), R2MINX(3)
      DOUBLEPRECISION SUMEO4, SUMTR1, SUMTR2, SUMTR3, SUMEC4, SUMEE4
      CHARACTER ATTEMP *6
      DIMENSION SK(4,9)
      DIMENSION ECI4(3,3,MAXAT)
      DIMENSION ECI22(3,3,MAXAT)
      DOUBLEPRECISION ECI22, ECI4, SK
      DIMENSION BNEWZ(3, MAXAT)
      EQUIVALENCE (BNEWZ(1,1), ECI22(1,1,1))
      DIMENSION ACALC(MAXAT), BCALC(MAXAT), BNEWR2(MAXAT), R2MIN2(MAXAT)
      DIMENSION EXPB9(500,9), B9(9)
      DIMENSION IZZM(2,3,15), FZZM(2,3,15)
      DIMENSION FFF(10), ADTRIG(24)
      DATA ADTRIG / 24*0.0 /
      DATA NCALL, NCYOLD / 0, 999 /
      DATA B9I /0.03/
      DATA LSMINB / 0 /
      IF (NRECYS .LT. 4) LSMINB = 0
      IF (NRECYS .LE. 3 .OR. (NRECYS.EQ.4 .AND. PSQ.LT.0.90) ) RETURN
      DO 10 K=1,9
   10 B9(K) = FLOAT(K-5) * B9I * BP
      ISMAX = IFIX (STLMAX * 400. + 0.0001) + 2
      DO 11 IS=1,ISMAX
      STL = FLOAT(IS-1) * 0.0025
      STL2 = STL * STL
      DO 11 K = 1,9
      EXPB9(IS,K) = EXP(-B9(K) * STL2)
   11 CONTINUE
      DO 12 I=1,4
      DO 12 K=1,9
      SK(I,K) = 0.0
   12 CONTINUE
      DELB = 0.25 * BP
      IF (DELB .GT. 2.) DELB = 2.
      NCALL = NCALL + 1
      IF (NCYOLD .GT. NRECYR) NCALL = 1
      NCYOLD = NRECYR
      CALL WR24
      WRITE(24,101) NCALL, NRECYR, NRECYS, NRECYT
  101 FORMAT ( / ' ***** FCALR2 *****  subr 317 call', I2, 12X,
     *    '[cycle', I3, ' /', I3, I2, ']'/ )
      CALL WR24
      WRITE (8, 102) SCALE, BOV, DELB
  102 FORMAT (/' Structure factor calculation for FCALR2 refinement'/
     *         ' FCALR2 input data : Scale =', F9.5, ' Bov:', F6.3,
     *         ' delta-B:', F6.3 /)
      CALL FILINQ (ICRYS, 'CRYSDA', 'FORMATTED', 'INPUT', KINQ)
      CALL FCALCI (ATXYZ, IZAT, ITAT, NAT)
      BSYMCL = ASYMCL**2
      NREFL  = 0
      IREFL  = 0
      SUMTR1 = 0.
      SUMTR2 = 0.
      SUMTR3 = 0.
      SUMEO4 = 0.
      SUMEC4 = 0.
      SUMEE4 = 0.
      SUMEO2 = 0.
      SUMEC2 = 0.
      NAT9 = 9 * NAT
      EFBP = 0.
      DO 104 I3 = 1,NAT
      BNEWR2(I3) = 0.
      R2MIN2(I3) = 0.
      DO 104 I2 = 1,3
      DO 104 I1 = 1,3
      ECI22(I1,I2,I3) = 0.
      ECI4(I1,I2,I3) = -0.0001
  104 CONTINUE
      NCELL1(10) = 0
      NCELL3(1) = 0
      DO 105 M = 1, 9
      NCELL1(M) = NCELLZ(M+1)
      NCELL3(M+1) = NCELLZ(M)
  105 CONTINUE
      DO 106 M = 1, 10
      IZTYP1(M) = 0
      IZTYP3(M) = 0
      IF (NCELLZ(M) .LE. 1) THEN
         NCELL1(M) = 0
         NCELL3(M) = 0
         GOTO 106
         ENDIF
      IF (NCELL1(M) .EQ. 1) NCELL1(M) = 0
      IF (NCELL3(M) .EQ. 1) NCELL3(M) = 0
      IF (NCELLZ(M) .LT. 10) THEN
         IF ( NCELLZ(M) .GT. 3 + NCELL1(M) ) NCELL1(M) = 0
         IF ( NCELL3(M) .GT. 3 + NCELLZ(M) ) NCELL3(M) = 0
      ELSE
         IF ( 4*NCELLZ(M) .GT. 5*NCELL1(M) ) NCELL1(M) = 0
         IF ( 4*NCELL3(M) .GT. 5*NCELLZ(M) ) NCELL3(M) = 0
         ENDIF
  106 CONTINUE
      IF (NCALL .LE. 2) WRITE (8, 107) ACELTY, NCELLZ, NCELL1, NCELL3
  107 FORMAT (/' Atomic Z and next LOWER and HIGHER Z :'
     *        /' ACELTY ', 10 (1X, A2),
     *        /' NCELLZ', 10I3/' NCELL1', 10I3/' NCELL3', 10I3)
      DO 114 J = 1, 10
      IZ = IZTYPE(J)
      IF (IZ .LE. 1) GOTO 114
      DO 110 M = 1, 10
      IF (NCELLZ(M) .EQ. IZ) GOTO 111
  110 CONTINUE
  111 CONTINUE
      IZTYP1(J) = NCELL1(M)
      IZTYP3(J) = NCELL3(M)
  114 CONTINUE
      IF (NCALL .LE. 2) WRITE (8, 115) CELATY, IZTYPE, IZTYP1, IZTYP3
  115 FORMAT (/' Atoms with atom type reference numbers : '
     *        /' CELATY ', 10 (1X, A2),
     *        /' IZTYPE', 10I3/' IZTYP1', 10I3/' IZTYP3', 10I3)
      IZ2 = 0
      NZ2 = 0
      DO 119 I = 1, NAT
      IF (ATXYZ(5,I) .LE. 0.001) ATXYZ(5,I) = BR
      ITAT3(I) = 0
      IF (IZAT(I) .NE. IZ2) THEN
         IZ2 = IZAT(I)
         NZ2 = 1
      ELSE
         NZ2 = NZ2 + 1
         IF (NZ2 .GE. 27) GOTO 119
         ENDIF
      J = ITAT(I)
      IZ3 = IZTYP3(J)
      DO 117 M = 1, NTYPE
      IF (IZTYPE(M) .EQ. IZ3) THEN
         ITAT3(I) = M
         GOTO 119
         ENDIF
  117 CONTINUE
  119 CONTINUE
      IZ2 = 0
      NZ2 = 0
      DO 123 I = NAT, 1, -1
      ITAT1(I) = 0
      IF (IZAT(I) .NE. IZ2) THEN
         IZ2 = IZAT(I)
         NZ2 = 1
      ELSE
         NZ2 = NZ2 + 1
         IF (NZ2 .GE. 10) GOTO 123
         ENDIF
      J = ITAT(I)
      IZ1 = IZTYP1(J)
      DO 121 M = 1, NTYPE
      IF (IZTYPE(M) .EQ. IZ1) THEN
         ITAT1(I) = M
         GOTO 123
         ENDIF
  121 CONTINUE
  123 CONTINUE
      IF (NCALL .LE. 2) THEN
         NATLIM = MIN0 (NAT, 20)
         WRITE (8, FMT='(/ '' TEST pointers to CELATY tables:''/
     *      '' Atomic Z   JTYPE       J-       J+    '',
     *      '' top 20 atoms:'')')
         DO 127 I = 1, NATLIM
         WRITE (8, 125) IZAT(I), ITAT(I), ITAT1(I), ITAT3(I)
  125    FORMAT (' IZAT', I4,' ITAT', I3,' ITAT1', I3,' ITAT3', I3)
  127    CONTINUE
         ENDIF
  130 CONTINUE
      NREFL = NREFL + 1
      HCODE = FBINX(1,NREFL)
      FOBS = FBINX(2,NREFL)
      IF (FOBS .LT. 0.) GOTO 400
      SIG = FBINX(3,NREFL)
      CALL HKLC1U (HCODE, HKLX)
      CALL HKLSTL (HKLX, STL, STL2)
      S = STL * 400. + 1.
      IS = IFIX(S)
      STLDEL = S - FLOAT(IS)
      ISS = NINT(S)
      SF2 = SUMF2 (ISS)
      GNORM = SQRT (SF2) * EXP ( - BP * STL2 )
      EOBS2 = ( SCALE * FOBS / GNORM )**2
      EOBS4 = EOBS2**2
      IREFL = IREFL + 1
      DO 135 J=1,NTYPE
      FFF(J) = ( FF(IS,J) + (FF(IS+1,J)-FF(IS,J)) * STLDEL ) / GNORM
  135 CONTINUE
      Q5 = EXP (- DELB * STL2)
      Q4 = 1./ Q5
      CALL HKLEX1 (HKLX, HKLX)
      IF (NSYMM.EQ.1) GOTO 150
      DO 140 J=2,NSYMM
      IF (ITRS(J).EQ.0) GOTO 140
      ADTRIG(J) = HKLX(1,1)*TSYMM(1,J) + HKLX(2,1)*TSYMM(2,J) +
     *            HKLX(3,1)*TSYMM(3,J)
  140 CONTINUE
  150 FAP = 0.0
      FBP = 0.0
      CALL KERNZA (0.0, ACI, NAT9)
      IF (ICENT.EQ.1) CALL KERNZA (0.0, BCI, NAT9)
      DO 250 I=1,NAT
      A1 = 0.
      B2 = 0.
      DO 200 J=1,NSYMM
      TRIG = HKLX(1,J)*ATXYZ(1,I) + HKLX(2,J)*ATXYZ(2,I) +
     *       HKLX(3,J)*ATXYZ(3,I) + ADTRIG(J)
      IF (TRIG.LT.0.0) TRIG = TRIG - 0.00010
      ITRIG = MOD ( IFIX(TRIG * 10000. + 0.5), 10000)
      IF (ITRIG.LE.0) ITRIG = ITRIG + 10000
      A1 = A1 + SICO(ITRIG + 2500)
      IF (ICENT.EQ.1) B2 = B2 + SICO(ITRIG)
  200 CONTINUE
      IJ = ITAT(I)
      TF = ATXYZ(4,I) * EXP (- ATXYZ(5,I) * STL2)
      A1 = A1 * TF
      ACALC(I) = A1 * FFF(IJ)
      FAP = FAP + ACALC(I)
      IF (ICENT .EQ. 1) THEN
         B2 = B2 * TF
         BCALC(I) = B2 * FFF(IJ)
         FBP = FBP + BCALC(I)
         ENDIF
      DO 220 M = 1, 3
      IF (M .EQ. 1) IJ = ITAT1(I)
      IF (M .EQ. 2) IJ = ITAT(I)
      IF (M .EQ. 3) IJ = ITAT3(I)
      IF (IJ .EQ. 0) GOTO 220
      A1FFF = A1 * FFF(IJ)
      ACI(1,M,I) = A1FFF * Q4
      ACI(2,M,I) = A1FFF
      ACI(3,M,I) = A1FFF * Q5
      IF (ICENT .EQ. 2) GOTO 220
      B2FFF = B2 * FFF(IJ)
      BCI(1,M,I) = B2FFF * Q4
      BCI(2,M,I) = B2FFF
      BCI(3,M,I) = B2FFF * Q5
  220 CONTINUE
  250 CONTINUE
      EC2 = BSYMCL * (FAP*FAP + FBP*FBP)
      SUMTR1 = SUMTR1 + (0.99 * EOBS2 - EC2)**2
      SUMTR2 = SUMTR2 + (EOBS2 - EC2)**2
      SUMTR3 = SUMTR3 + (1.01 * EOBS2 - EC2)**2
      SUMEO4 = SUMEO4 + EOBS4
      SUMEC4 = SUMEC4 + EC2*EC2
      SUMEE4 = SUMEE4 + EC2*EOBS2
      SUMEO2 = SUMEO2 + EOBS2
      SUMEC2 = SUMEC2 + EC2
      DO 307 I = 1, NAT
      DO 305 M = 1, 3
      IF (M .EQ. 1 .AND. ITAT1(I) .EQ. 0) GOTO 305
      IF (M .EQ. 3 .AND. ITAT3(I) .EQ. 0) GOTO 305
      DO 303 L = 1, 3
      EFAP = FAP - ACALC(I) + ACI(L,M,I)
      IF (ICENT .EQ. 1) EFBP = FBP - BCALC(I) + BCI(L,M,I)
      ECI2 = BSYMCL * (EFAP*EFAP + EFBP*EFBP)
      ECI22(L,M,I) = ECI22(L,M,I) + EOBS2 * ECI2
      ECI4(L,M,I) = ECI4(L,M,I) + ECI2 * ECI2
  303 CONTINUE
  305 CONTINUE
  307 CONTINUE
      S1 = SQRT(EOBS2 * EC2)
      S2 = EC2
      S3 = STL2 * S1
      S4 = STL2 * S2
      DO 320 K = 1,9
      T = EXPB9(ISS, K)
      T2 = T * T
      SK(1,K) = SK(1,K) + T  * S1
      SK(2,K) = SK(2,K) + T2 * S2
      SK(3,K) = SK(3,K) + T  * S3
      SK(4,K) = SK(4,K) + T2 * S4
  320 CONTINUE
      GOTO 130
  400 CONTINUE
      DO 429 K = 1,9
      SK(1,K) = SK(1,K) / SK(2,K)
      SK(2,K) = SK(3,K) / SK(4,K)
      SK(3,K) = SK(1,K) - SK(2,K)
      IF (K .EQ. 1) SK(4,K) = 99999.
      IF (K .GT. 1) SK(4,K) = SK(3,K) - SK(3,K-1)
  429 CONTINUE
      WRITE (8, 430) B9, (SK(1,K), K=1,9), (SK(2,K), K=1,9),
     *    (SK(3,K), K=1,9), (SK(4,K), K=2,9)
  430 FORMAT (/' LSCALB results:'//' delta B', 9(F7.3)/
     *  '      K1', 9F7.4/ '      K2', 9F7.4/
     *  '   K1-K2', 9F7.4/ ' increment     ', 8F7.4/)
      KK  = 5
      DO 433 K = 1,9
      IF (ABS (SK(3,K)) .LT. 0.00001) THEN
         KK = K
         GOTO 450
         ENDIF
  433 CONTINUE
      IF ( SK(3,1) * SK(4,2) .GT. 0. ) THEN
         KK = 1
         GOTO 450
         ENDIF
      IF ( SK(3,9) * SK(4,9) .LT. 0. ) THEN
         KK = 9
         GOTO 450
         ENDIF
      DO 437 K = 1,8
      IF (SK(3,K) * SK(3,K+1) .LT. 0.) GOTO 440
  437 CONTINUE
      GOTO 450
  440 QQ = ABS ( SK(3,K) / ( SK(3,K) - SK(3,K+1) ) )
      SCALK = SK(1,K) + QQ * ( SK(1,K+1) - SK(1,K) )
      B9K = B9(K) + QQ * ( B9(K+1) - B9(K) )
      GOTO 460
  450 SCALK = SK(1,KK)
      B9K = B9(KK)
  460 SCALEK = SCALE / SCALK
      BPK = BP + B9K
      WRITE (8, 465) SCALK, SCALE, SCALEK, B9K, BP, BPK
  465 FORMAT (/' Interpolated reciprocal scale multiplier:  ', F8.4/
     *         '    old scale: ', F8.4,'  new scale:', F8.4/
     *         ' change of average atomic temperature factor', F8.4/
     *         '       old Bp: ', F8.4,'     new Bp:', F8.4/ )
      WRITE (8, FMT='('' $TE SCALE LS-B '',I3,2F6.3,F8.4,2F6.3,
     *   '' NcyS='',I2)') NRECYR, PSQ, R2X, SCALEK, BPK, BR, NRECYS
      R1 = SUMTR1 / (SUMEO4 * 0.96)
      R2 = SUMTR2 / SUMEO4
      R3 = SUMTR3 / (SUMEO4 * 1.04)
      WRITE (8, 503) R2, NREFL, R1, R2, R3
  503 FORMAT (/' FCALR2 :  R2 =', F8.4, ' for ', I5, ' reflections',
     * //      ' For SCALE * [ 0.99  1.00 1.01  ], R2 =:', 3F8.4 )
      SCALE4 = SUMEC4 / SUMEE4
      SCALE2 = SUMEC2 / SUMEO2
      SCALE1 = SCALE * SQRT (SCALE4)
      WRITE (8, FMT='(/'' test FCALR2 : SCALE1,2,4 ='', 3F9.4)')
     *   SCALE1, SCALE2, SCALE4
      R2NEW = 1. - SUMEE4**2 / SUMEO4 / SUMEC4
      WRITE (8, FMT='('' test FCALR2 : with SCALE1 ='', F7.4,
     *   '' R2-theor. ='', F7.4, '' ???'')') SCALE1, R2NEW
      TESTA = SUMEO4 / SCALK**4
      TESTB = SUMEE4 / SCALK**2
      R2TEST = 1. -2. * TESTB / TESTA + SUMEC4 /TESTA
      WRITE (8, FMT='('' test FCALR2 : LS-B scale ='', F7.4,
     *   '' New R2-theor. ='', F7.4, '' !!!''/)') SCALEK, R2TEST
      SC2K2 = 2. / ( SUMEO4 * SCALK**2 )
      SCK4 = 1. / (  SUMEO4 * SCALK**4 )
      RDIFF1 = 0.0
      RDIFF3 = 0.0
      SDIFF1 = 0.0
      SDIFF3 = 0.0
      RDIFF2 = 0.0
      SDIFF2 = 0.0
      BOVPLU = DELB
      BOVMIN = - DELB
      BOVNUL = 0.
      WRITE (8, FMT='(//'' Tab 317-1 [ cy'', 2I3, I2, '' ]''//
     *   ''    Results atoms B refinements:''//
     *   '' Nr atom     Z     --- R2-theor. ---     B    Booth''/ 12X,
     *   ''  dB= '', 3F6.3, ''   input   B    R2-theor. del-R2''/)')
     *   NRECYR, NRECYS, NRECYT, BOVMIN, BOVNUL, BOVPLU
      BNEWRD = 0.0
      BNEWRA = 0.0
      BNEWRE = 0.0
      BNEWRB = 0.0
      DO 517 I = 1, NAT
      DO 515 M = 1, 3
      IF (M .EQ. 1 .AND. ITAT1(I) .EQ. 0) GOTO 515
      IF (M .EQ. 3 .AND. ITAT3(I) .EQ. 0) GOTO 515
      DO 513 L = 1, 3
      ECI4(L,M,I) = 1. + SCK4 * ECI4(L,M,I) - SC2K2 * ECI22(L,M,I)
  513 CONTINUE
      IF (M .NE. 2) GOTO 515
      RR1 = ECI4(1,M,I)
      RR2 = ECI4(2,M,I)
      RR3 = ECI4(3,M,I)
      CALL BOOTH (RR1, RR2, RR3, ATXYZ(5,I), DELB, BBOOTH, R2MIN)
      BNEWR2(I) = BBOOTH
      R2MIN2(I) = R2MIN
      DELR2 = BBOOTH - ATXYZ(5,I)
      BNEWRD = BNEWRD + DELR2
      BNEWRA = BNEWRA + ABS (DELR2)
      BNEWRE = BNEWRE + DELR2 - B9K
      BNEWRB = BNEWRB + ABS (DELR2 - B9K)
      DELR2 = R2MIN - RR2
      IZ = IZAT(I)
      WRITE (8, 514) I, ATNAME(I), IZ, ( ECI4(L,M,I), L=1,3 ),
     *   ATXYZ(5,I), BBOOTH, R2MIN, DELR2
  514 FORMAT (I4, 1X, A6, I3, 4X, 3(1X,F5.4), 2X, 2F6.2, 2F9.5)
      RDIFF2 = RDIFF2 + R2MIN - ECI4(2,2,I)
      SDIFF2 = SDIFF2 + 1.
  515 CONTINUE
  517 CONTINUE
      BNEWRD = BNEWRD / FLOAT(NAT)
      BNEWRA = BNEWRA / FLOAT(NAT)
      BNEWRE = BNEWRE / FLOAT(NAT)
      BNEWRB = BNEWRB / FLOAT(NAT)
      WRITE (8,FMT='( /'' Booth interpolation for B: ''/
     *   '' Averaged change in B (delB) and aver abs delB: '', 2F8.4/
     *   '' Averaged valuies after LS-B Bp-new correction: '', 2F8.4)')
     *   BNEWRD, BNEWRA, BNEWRE, BNEWRB
      IF (SDIFF2 .GT. 0.5) RDIFF2 = RDIFF2 / SDIFF2
      WRITE (8,FMT='(/
     *    '' If B(Booth) is accepted: average change in R2: '',F8.4
     *   /''                               number of terms: '',F8.0/)')
     *   RDIFF2, SDIFF2
      WRITE (8, FMT='(//'' Tab 317-2 [ cy'', 2I3, I2, '' ]''//
     *   ''    Results atoms Z refinements:''//
     *   '' Nr atom new-Z     --- R2-theor. ---     B    Booth''/ 12X,
     *   ''  dB= '', 3F6.3, ''   input   B    R2-theor. del-R2''/)')
     *   NRECYR, NRECYS, NRECYT, BOVMIN, BOVNUL, BOVPLU
      CALL KERNZI (0, IZZM, 90)
      CALL KERNZA (999., FZZM, 90)
      DO 627 I = 1, NAT
      BMINX(2) = BNEWR2(I)
      R2MINX(2) = R2MIN2(I)
      DELR2 = 0.
      DO 618 M = 1, 3, 2
      BMINX(M) = -1.
      R2MINX(M) = 999.
      IF (M .EQ. 1 .AND. ITAT1(I) .EQ. 0) GOTO 618
      IF (M .EQ. 3 .AND. ITAT3(I) .EQ. 0) GOTO 618
      RR1 = ECI4(1,M,I)
      RR2 = ECI4(2,M,I)
      RR3 = ECI4(3,M,I)
      CALL BOOTH (RR1, RR2, RR3, ATXYZ(5,I), DELB, BBOOTH, R2MIN)
         IF (M .EQ. 1 ) THEN
         DELR2 = R2MIN - R2MINX(2)
         IF (DELR2 .GT. -0.0000001) GOTO 604
         RDIFF1 = RDIFF1 + DELR2
         SDIFF1 = SDIFF1 + 1.0
      ELSEIF (M .EQ. 3 ) THEN
         DELR2 = R2MIN - R2MINX(2)
         IF (DELR2 .GT. -0.0000001) GOTO 604
         RDIFF3 = RDIFF3 + DELR2
         SDIFF3 = SDIFF3 + 1.0
         ENDIF
  604 CONTINUE
      BMINX(M) = BBOOTH
      R2MINX(M) = R2MIN
      IF (M .EQ. 1) II = ITAT1(I)
      IF (M .EQ. 3) II = ITAT3(I)
      IZ = IZTYPE(II)
      IF (DELR2 .LE. -0.000001)
     *   WRITE (8,614) I, ATNAME(I), IZ, ( ECI4(L,M,I), L=1,3 ),
     *   ATXYZ(5,I), BBOOTH, R2MIN, DELR2
  614 FORMAT (I4,1X, A6,'?',I2,4X,3(1X,F5.4), 2X, 2F6.2, 2F9.5, ' ??')
  618 CONTINUE
      BNEWZ(2,I) = 0.
      BNEWZ(1,I) = -999.
      IF (BMINX(1) .LT. 0. .AND. BMINX(3) .LT. 0.) GOTO 624
      M = 0
      IF (BMINX(1) .GT. 0. .AND. BMINX(3) .GT. 0.) THEN
         IF (R2MINX(1) .LT. R2MINX(3)) THEN
            M=1
         ELSE
            M=3
            ENDIF
      ELSE
         M=3
         IF (R2MINX(1) .LT. R2MINX(3)) M=1
         ENDIF
      IF (M .EQ. 0) GOTO 624
      IF (M .EQ. 1) II = ITAT1(I)
      IF (M .EQ. 3) II = ITAT3(I)
      R2DEL = R2MINX(M) - R2MINX(2)
      IF (R2DEL .GE. FZZM(1,M,15)) GOTO 624
      DO 620 NZZ = 14, 1, -1
      IF (R2DEL .GE. FZZM(1,M,NZZ)) GOTO 621
  620 CONTINUE
      NZZ = 0
  621 CONTINUE
      NZZ = NZZ + 1
      DO 622 NZZ2 = 14, NZZ, -1
      IZZM(1,M,NZZ2+1) = IZZM(1,M,NZZ2)
      IZZM(2,M,NZZ2+1) = IZZM(2,M,NZZ2)
      FZZM(1,M,NZZ2+1) = FZZM(1,M,NZZ2)
      FZZM(2,M,NZZ2+1) = FZZM(2,M,NZZ2)
  622 CONTINUE
      IZZM(1,M,NZZ) = I
      IZZM(2,M,NZZ) = II
      FZZM(1,M,NZZ) = R2DEL
      FZZM(2,M,NZZ) = BMINX(M)
      IF (R2DEL .GT. -0.0000001) GOTO 624
      BNEWZ(1,I) = FLOAT(II)
      BNEWZ(2,I) = R2DEL
      BNEWZ(3,I) = BMINX(M)
  624 CONTINUE
  627 CONTINUE
      IF (SDIFF1 .GT. 0.5) RDIFF1 = RDIFF1 / SDIFF1
      IF (SDIFF3 .GT. 0.5) RDIFF3 = RDIFF3 / SDIFF3
      WRITE (8,FMT='(/ '' If all negative terms are accepted:''
     *   /'' averaged change in R2 by smaller Z: '', F8.5,
     *    '' or larger Z: '', F8.5
     *   /''    number of terms: '', 17X, F8.0, 14X, F8.0 )')
     *   RDIFF1, RDIFF3, SDIFF1, SDIFF3
      TDIFF1 = 0.00001
      TDIFF3 = 0.00001
      SDIFF1 = 0.
      SDIFF3 = 0.
      DO 628 I = 1, NAT
      IF (ECI4(1,1,I) .GT. 0.0) THEN
         TDIFF1 = TDIFF1 + ECI4(2,1,I) - ECI4(2,2,I)
         SDIFF1 = SDIFF1 + 1.
         ENDIF
      IF (ECI4(3,3,I) .GT. 0.0) THEN
         TDIFF3 = TDIFF3 + ECI4(2,3,I) - ECI4(2,2,I)
         SDIFF3 = SDIFF3 + 1.
         ENDIF
  628 CONTINUE
      IF (SDIFF1 .GT. 0.5) TDIFF1 =  (TDIFF1 / SDIFF1)
      IF (SDIFF3 .GT. 0.5) TDIFF3 =  (TDIFF3 / SDIFF3)
      WRITE (8,FMT='(/ '' If all term (+/-) are included:''
     *   /'' averaged change in R2 by smaller Z: '', F8.5,
     *    '' or larger Z: '', F8.5
     *   /''    number of terms: '', 17X, F8.0, 14X, F8.0 )')
     *   TDIFF1, TDIFF3, SDIFF1, SDIFF3
      WRITE (8,FMT='(/ '' Iat, II, R2-del, new-B  '')')
      DO 629 I = 1, NAT
      II = NINT(BNEWZ(1,I))
      IF (II .GT. 0)  WRITE (8,FMT='(
     *   2I4, F9.5, F6.3)') I, II, BNEWZ(2,I), BNEWZ(3,I)
      BNEWZ(3,I) = ATXYZ(5,I)
  629 CONTINUE
      WRITE (8,FMT='( / '' Z refine:''/
     *   '' Nat  IZ  IZ-       R2      B'', 5X,
     *   '' Nat  IZ  IZ+       R2      B''/)')
      DO 1630 I=1,15
      IZ1 = IZZM(1,1,I)
      IF (IZ1 .GT. 0) IZ1 = IZAT(IZ1)
      IZM1 = IZZM(2,1,I)
      IF (IZM1 .GT. 0) IZM1 = IZTYPE(IZM1)
      IZ3 = IZZM(1,3,I)
      IF (IZ3 .GT. 0) IZ3 = IZAT(IZ3)
      IZM3 = IZZM(2,3,I)
      IF (IZM3 .GT. 0) IZM3 = IZTYPE(IZM3)
      WRITE (8, 630)
     *   IZZM(1,1,I), IZ1, IZM1, FZZM(1,1,I), FZZM(2,1,I),
     *   IZZM(1,3,I), IZ3, IZM3, FZZM(1,3,I), FZZM(2,3,I)
  630 FORMAT (2 (3I4, F10.5, F8.4, 4X) )
 1630 CONTINUE
      WRITE (8,FMT='(/ '' Atom pairs suitable for switching ''/)')
      IZZTOT = 0
      DO 633 K1=1,15
      I1 = IZZM(1,1,K1)
      IF (I1 .LE. 0) GOTO 633
      IZ1 = IZAT(I1)
      IZM1 = IZZM(2,1,K1)
      IF (IZM1 .GT. 0) IZM1 = IZTYPE(IZM1)
      DO 632 K3=1,15
      I3 = IZZM(1,3,K3)
      IF (I3 .LE. 0) GOTO 632
      IZ3 = IZAT(I3)
      IZM3 = IZZM(2,3,K3)
      IF (IZM3 .GT. 0) IZM3 = IZTYPE(IZM3)
      IF (IZM3 .NE. IZ1 .OR. IZ3 .NE. IZM1) GOTO 632
      IF (FZZM(1,1,K1) + FZZM(1,3,K3) .LE. 0.) THEN
         WRITE (8, 630)
     *      I1, IZ1, IZM1, FZZM(1,1,K1), FZZM(2,1,K1),
     *      I3, IZ3, IZM3, FZZM(1,3,K3), FZZM(2,3,K3)
         IZZM(1,1,K1) = -IZZM(1,1,K1)
         IZZM(1,3,K3) = -IZZM(1,3,K3)
         IZZTOT = IZZTOT + 2
         GOTO 633
         ENDIF
  632 CONTINUE
  633 CONTINUE
      IF (IZZTOT .GT. 0) THEN
         WRITE (8, FMT='(/I3,'' renames accepted'')') IZZTOT
      ELSE
         WRITE (8, FMT='('' -------------> none''/)')
         ENDIF
      IF (NRECYS .GT. 5) THEN
         LSMINB = LSMINB + 1
         IF (LSMINB .EQ. 1) SCALE = 0.5 * (SCALE + SCALEK)
         IF (LSMINB .EQ. 2) SCALE = (2. * SCALE + SCALEK) / 3.
         IF (LSMINB .GT. 2) SCALE = (3. * SCALE + SCALEK) / 4.
         WRITE (8, FMT='('' $TE scale LS+B '',I3,2F6.3,F8.4,2F6.3,
     *   '' NcyS='',I2)') NRECYR, PSQ, R2X, SCALE, BPK, BR, NRECYS
         ENDIF
      XXX = AMAX1 (0.4, 0.1 * BP)
      IF (NRECYS .GE. 8) XXX = 0.3
      FAC2 = 0.80
      IF (NRECYS .GE. 5) FAC2 = 0.50
      IF (NRECYS .GE. 8) FAC2 = 0.30
      WRITE(24, FMT='('' '')')
      WRITE (8,FMT='( /'' B values:    B-old  Booth  B-del  B-new ''/
     *   42X, '' lim=   *fac=   B9K=''/42X, F6.3, F6.1, F9.3)')
     *   XXX, FAC2, B9K
      DO 649 I = 1, NAT
      TEMPAB = ATXYZ(5,I)
      TEMPAC = TEMPAB + 0.5 * BNEWRD
      IF (NRECYS .GE. 5) TEMPAC = TEMPAB + B9K
      BDELR2 = (BNEWR2(I) - ATXYZ(5,I) - BNEWRD)
      IF (BDELR2 .GT. XXX) BDELR2 = XXX
      IF (BDELR2 .LT. -XXX) BDELR2 = -XXX
      ATXYZ(5,I) = TEMPAC + FAC2 * BDELR2
      WRITE (8, 637) I, ATNAME(I), TEMPAB, BNEWR2(I), BDELR2, ATXYZ(5,I)
  637 FORMAT (I4, 1X, A6, '=', 4F7.3)
  649 CONTINUE
      IF (IZZTOT .LE. 0) GOTO 740
      CALL WR24
      IF (NRECYS .GT. 5) THEN
         IF (LSMINB .GT. 1) B9K = B9K / FLOAT(LSMINB)
         WRITE (8, FMT='('' $TE LS+B, B9K ='', F9.4, F6.3,
     *   ''   Ncy, NcyS='',2I3)') SCALE, B9K, NRECYR, NRECYS
         ENDIF
      WRITE(24, FMT='('' '')')
      WRITE (8, FMT='(/'' test Z refine ''//
     *   '' Atnr Z --> Z-new  R-del B-new    name ---> new name''/)')
      WRITE(24, FMT='(/'' Z refinement ''/
     *   '' Atnr  name   renamed'', 3X,''R2-del     B-old  B-new ''/)')
      DO 730 M=1,3,2
      DO 730 K1=1,15
      I = IZZM(1,M,K1)
      IF (I .GE. 0) GOTO 730
      I = - I
      IZ1 = IZAT(I)
      II = IZZM(2,M,K1)
      IZM1 = IZTYPE(II)
      WRITE (8, FMT='(3I4, F10.5, F8.4, 4X, A6, 1X, A2)')
     *   I, IZ1, IZM1, FZZM(1,M,K1), FZZM(2,M,K1), ATNAME(I), CELATY(II)
      IZAT(I) = IZM1
      BOLD9 = BNEWZ(3,I)
      BDIF9 = 0.3
      IF (NRECYS .LE. 4) BDIF9 = 0.1
      IF (NRECYS .GE. 8) BDIF9 = 0.2
      IF (IZM1 .LT. IZ1) BDIF9 = - BDIF9
      ADD9 = B9K
      IF (NRECYS .GE. 8) ADD9 = 0.5 * B9K
      ATXYZ(5,I) = BNEWZ(3,I)
      BDIF9 = 0.3
      IF (NRECYS .GE. 5) BDIF9 = 0.2
      IF (NRECYS .GE. 8) BDIF9 = 0.1
      IF (IZM1 .GT. IZ1) BDIF9 = - BDIF9
      ADD9 = B9K
      IF (NRECYS .GE. 5) ADD9 = 0.5 * B9K
      IF (NRECYS .GE. 8) ADD9 = 0.1 * B9K
      ATXYZ(5,I) = BNEWZ(3,I) + ADD9 + BDIF9
      ATTEMP = ATNAME(I)
      CALL ATN4CN (CELATY(II), I, NAT, ATNAME, NAT, ATNAME(I))
      WRITE(24, 644) I, ATTEMP, ATNAME(I), FZZM(1,M,K1),
     *   BOLD9, ATXYZ(5,I)
  644 FORMAT (I4, 3X, A6, 1X, A6, F10.5, 3X, 2F7.3)
  730 CONTINUE
  740 CONTINUE
      CALL WR24
      CALL ATOMOC (2, ATXYZ, ITAT, NAT)
      WRITE (8, FMT='(//'' FCALR2 finished '' //)')
      RETURN
      END
      SUBROUTINE BOOTH (R1, R2, R3, X2, DELX, XM, RM)
      X1 = X2 - DELX
      X3 = X2 + DELX
      C = ( R1 +R3 -R2 -R2 ) / (2. * DELX * DELX)
      B = ( R3 - R1 ) / (2. * DELX) - C * 2. * X2
      IF (C .LT. 0.0001) THEN
         XM = X2
         RM = R2
         IF (B .GT. 0.0001 .AND. R1 .LT. R2) THEN
            XM = X1
            RM = R1
         ELSEIF (B .LT. -0.0001 .AND. R3 .LT. R2) THEN
            XM = X3
            RM = R3
            ENDIF
         GOTO 111
         ENDIF
      XM = - 0.5 * B / C
      IF (XM .GT. X3) THEN
         XM = X3
         RM = R3
      ELSEIF (XM .LT. X1) THEN
         XM = X1
         RM = R1
      ELSE
         RM = R2 + B * (XM-X2) + C * (XM*XM-X2*X2)
         ENDIF
  111 CONTINUE
      IF (XM .LT. 0.5) XM = 0.5
      RETURN
      END
      SUBROUTINE CLSTRS
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zatomx.inc'
      COMMON /BLANK/ IFRAG(MAXAT), ISYM(MAXAT),     IDUM(MAXAT),
     *               DUM(MAXAT),   IBOND(MAXAT*10), JBOND(MAXAT*10),
     *               XXXGEO(135520)
      DIMENSION LW(MAXAT), LR(MAXAT)
      EQUIVALENCE (LW(1), IDUM(1)), (LR(1), DUM(1))
      COMMON /SIZEX/ KFRAG(20), NFRAG, LFRAG(20), NOFRAG, NNA
      INCLUDE 'Zsear.inc'
      DIMENSION   IB(3), XS(3), X1(3), XSTOR(3)
      LOGICAL ISWFRM
      DATA    ISWFRM  /.FALSE./
      CALL WR24
      DFRG = 2.80
      IF (DMAXB .GT. DFRG) DFRG = DMAXB
      DFRG2 = DFRG * DFRG
      DMAXB2 = DMAXB * DMAXB
      ICHECK=0
      GOTO 1010
 1000 NAT = NPIC
 1010 NNA = 0
      MCON=0
      DO 1020 I=1,NAT
      IFRAG(I)=0
      LW(I) = 0
 1020 LR(I) = 0
      NFRAG=0
      NOFRAG=0
      NAT1=NAT-1
      DO 1180 II=1,NAT1
      IF (IFRAG(II).EQ.(-1000)) GOTO 1030
      IF (ICHECK.EQ.1.OR.IFRAG(II).NE.0) GOTO 1180
      IF (NOFRAG .LT. 20) THEN
         NOFRAG = NOFRAG + 1
         NFRAG = NFRAG + 1
         ENDIF
      IF (NOFRAG .EQ. 20 .AND. .NOT. ISWFRM) THEN
         WRITE (8, FMT='('' Warning: 20 or more fragments '')')
         ISWFRM = .TRUE.
         ENDIF
 1030 ICHECK=0
      IFRAG(II)=NOFRAG
      KOUNT=1
      I=II
      IBEGIN=II
 1040 DO 1140 J=IBEGIN,NAT
      IF (IFRAG(J).LT.0.AND.IFRAG(J).NE.(-1000)) GOTO 1140
      JMOVE = 0
      KSYM=0
      DO 1120 K =1, IMULT
      IF (I.EQ.J.AND.K.EQ.1) GOTO 1120
      IF (JSYMM(I,J,K,IB,XS,X1).NE.0) GOTO 1120
      DIST2 = QUAD2 (X1, X1)
      IF (DIST2 .GT. DFRG2) GOTO 1120
      LR(J)=1
      IF (DIST2 .GT. DMAXB2) GOTO 1120
      IF (DIST2 .GT. (ATXYZ(7,I) + ATXYZ(7,J)) **2 ) GOTO 1120
      IF (I .EQ. J .AND. DIST2 .LT. 0.04) GOTO 1120
      IF (IABS(IFRAG(J)).EQ.NOFRAG) GOTO 1080
      IF (IFRAG(J).EQ.(-1000)) GOTO 1060
      JMOVE=1
      KSYM=K
      DO 1050 L=1,3
 1050 XSTOR(L)=XS(L)
 1060 IFRAG(J)=NOFRAG
      KOUNT=KOUNT+1
      IF (KSYM.EQ.K) GOTO 1100
 1080 JBND=100000*IB(1)+10000*IB(2)+1000*IB(3)+K
      IF (JBND.EQ.555001) GOTO 1100
      IF (NNA .EQ. MAXAT-1) WRITE (8, 1085) NOFRAG, MAXAT-1
 1085 FORMAT (/' CLUSTER ',I3,' BONDS ',I4,' TIMES TO ITSELF')
      IF (NNA .LE. MAXAT-1) NNA = NNA + 1
      IF (I.LT.J) ISYM(NNA)=250000*NOFRAG+500*I+J
      IF (I .GE. J) ISYM(NNA) = 250000*NOFRAG + 500*J + I
      GOTO 1120
 1100 IF (I.EQ.J) GOTO 1120
      IDIST = 1000.0 * SQRT(DIST2) + 0.5
      MCON=MCON+1
      IBOND(MCON)=(512*I+J)*8192+IDIST
      MCON=MCON+1
      IBOND(MCON)=(512*J+I)*8192+IDIST
 1120 CONTINUE
      IF (JMOVE .EQ. 0) GOTO 1140
      DO 1125 L=1,3
      ATX4(L,J) = XSTOR(L)
 1125 CONTINUE
 1140 CONTINUE
      IFRAG(I)=-IFRAG(I)
      DO 1160 I=1,NAT
      IF (IFRAG(I).EQ.NOFRAG)GOTO 1040
 1160 CONTINUE
      IF (NAT .EQ. NPIC) GOTO 1178
      DO 1175 I=1,NAT
      IF (KOUNT.LT.4) GOTO 1170
      IF (IABS(IFRAG(I)) .NE. NOFRAG) GOTO 1165
      IF (LW(I) .EQ. 0) GOTO 1170
      GOTO 1000
 1165 IF (LW(I) .EQ. 0) LW(I) = LR(I)
 1170 LR(I) = 0
 1175 CONTINUE
 1178 IF (KOUNT.EQ.1)GOTO 1179
      KFRAG(NOFRAG)=KOUNT
      GOTO 1180
 1179 IFRAG(II)=0
      NFRAG=NFRAG-1
      NOFRAG=NOFRAG-1
 1180 CONTINUE
      DO 1240 I=1,NAT
      IFRAG(I)=IABS(IFRAG(I))
 1240 CONTINUE
      IF (MCON.GT.0) CALL ISORT(IBOND,MCON)
      RETURN
      END
      SUBROUTINE PICTUR (NPROJ)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zsear.inc'
      COMMON /BLANK/ IFRAG(MAXAT), ISYM(MAXAT),     IDUM(MAXAT),
     *               DUM(MAXAT),   IBOND(MAXAT*10), JBOND(MAXAT*10),
     *               XXXGEO(135520)
      DIMENSION XA(3,MAXAT), XB(4,MAXAT)
      PARAMETER (MX7=3*MAXAT+1)
      EQUIVALENCE (XA(1,1), IBOND(1)), (XB(1,1), IBOND(MX7))
      COMMON /SIZEX/ KFRAG(20), NFRAG, LFRAG(20), NOFRAG, NNA
      CHARACTER *124 CLINE1
      CHARACTER *6 CL
      DIMENSION B(3,3), V(3,3), IND(3), SUM(3), XMAX(3), XMIN(3)
      CALL WR24
      IF (IPRY.EQ.0)  RETURN
      NUM = KFRAG(NOFRAG)
      IF (NUM .LT. 4) RETURN
      ANUM = NUM
      COSW = (COS(D2R*CELL(5)) - COS(D2R*CELL(6))*COS(D2R*CELL(4))) /
     *                          (SIN(D2R*CELL(6))*SIN(D2R*CELL(4)))
      SINW=SQRT(1.0-COSW**2)
      A11=CELL(1)*SINW*SIN(D2R*CELL(6))
      A21=CELL(1)*COS(D2R*CELL(6))
      A22=CELL(2)
      A23=CELL(3)*COS(D2R*CELL(4))
      A31=CELL(1)*COSW*SIN(D2R*CELL(6))
      A33 = CELL(3) * SIN(D2R*CELL(4))
      CALL KERNZA (0.0, SUM, 3)
      CALL KERNZA (-10000.0, XMAX, 3)
      CALL KERNZA ( 10000.0, XMIN, 3)
      CALL KERNZA (0.0, B, 9)
      DO 108 I=1,NAT
      IF (IFRAG(I).NE.NOFRAG)GOTO 108
      XA(1,I)=ATX4(1,I)*A11
      XA(2,I)=ATX4(1,I)*A21+ATX4(2,I)*A22+ATX4(3,I)*A23
      XA(3,I)=ATX4(1,I)*A31+ATX4(3,I)*A33
      DO 106 J=1,3
      SUM(J)=SUM(J)+XA(J,I)
      DO 106 K=1,3
  106 B(J,K)=B(J,K)+XA(J,I)*XA(K,I)
  108 CONTINUE
      DO 120 J=1,3
      DO 120 K=1,3
  120 B(J,K)=B(J,K)-SUM(J)*SUM(K)/ANUM
      CALL EIGEN(B,V,IND)
      K=0
      DO 180 I=1,NAT
      IF (IFRAG(I).NE.NOFRAG) GOTO 180
      K=K+1
      XB(4,K)=I
      DO 140 J=1,3
      L=IND(J)
      XB(J,K)=XA(1,I)*V(1,L)+XA(2,I)*V(2,L)+XA(3,I)*V(3,L)
      XMAX(J)=AMAX1(XMAX(J),XB(J,K))
  140 XMIN(J)=AMIN1(XMIN(J),XB(J,K))
  180 CONTINUE
      NNN = 0
      N1 = 2
      N2 = 1
      IF (115.0/(XMAX(1)-XMIN(1)) .GE. 2.0/0.254) GOTO 190
      N1 = 1
      N2 = 2
  190 AMAX = AMAX1(XMAX(N2)-XMIN(N2), XMAX(N2+1)-XMIN(N2+1))
      SCALEP = AMIN1(115.0/AMAX, 2.5/0.254)
      SCL = 0.254 * SCALEP
  200 CALL SORT (XB, MAXAT, NUM, N1)
  210 NNN = NNN + 1
      WRITE (IPRY, 220) NOFRAG
  220 FORMAT (/// ' ', 72('+')// ' Cluster ',I3)
      GOTO (240, 280, 320), NNN
  240 WRITE (IPRY, 260) SCL
  260 FORMAT ('+', 17X, ' Plot on least squares plane,   scale  ='
     +,F6.2,'  cm /A' /)
      GOTO 360
  280 WRITE (IPRY, 300)
  300 FORMAT ('+', 17X, ' Plot on plane orthogonal to l.s. plane' /)
      GOTO 360
  320 WRITE (IPRY, 340)
  340 FORMAT ('+', 17X, ' Plot on most squares plane' )
  360 IX=0
      OFFSET = 2.5
      ALN = 6.
      CLINE1 = ' '
      DO 460 I =1, NUM
      IXREL = 0.1 * ALN * SCALEP * (XMAX(N1)-XB(N1,I)) - FLOAT(IX) +0.5
      IF (IXREL .LE. 0) GOTO 420
      WRITE (IPRY, 402) CLINE1
  402 FORMAT (A124)
      CLINE1 = ' '
      IX = IX + IXREL
      IF (IXREL .EQ. 1) GOTO 420
      DO 410 J = 1, IXREL-1
  410 WRITE (IPRY, 402) CLINE1
  420 IY=SCALEP*(XB(N2,I)-XMIN(N2))+OFFSET
      K = XB(4,I) + 0.5
      CALL KERI2C (K, CL, 3)
      IYE = IY + 1
      IF (K .GT. 99) IYE = IY + 2
      IF (K .LE.  9) IYE = IY
      ICL = 1 + IYE - IY
      IF (CLINE1(IY:IYE) .NE. ' ') GOTO 430
      CLINE1(IY:IYE) = CL(1:ICL)
      GOTO 460
  430 CLINE1(IY:IY) = '*'
  460 CONTINUE
      WRITE (IPRY, 402) CLINE1
      IF (NPROJ .GT. NNN) GOTO 500
      IF (NPROJ .GT. 0 .OR. NNN .GE. 2) GOTO 600
      NTEMP = 4-NNN
      IND1 = IND(NTEMP)
      IND2 = IND(NTEMP-1)
      IF (B(IND2,IND2) .GT. 2.0*B(IND1,IND1)) GOTO 600
  500 IF (NNN .EQ. 2) GOTO 540
      IF (N1 .EQ. 2) GOTO 560
      N2 = 3
      GOTO 210
  540 N2 = 2
      IF (N1 .EQ. 3) GOTO 210
  560 N1 = 3
      GOTO 200
  600 CONTINUE
      RETURN
      END
      SUBROUTINE SCHOUT (SCALAT, ZSCAL)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zsear.inc'
      PARAMETER (IP1=1)
      PARAMETER (IDUMAM=24*MAXAT+1)
      PARAMETER (IP160=160000, IPDUM=IP160-IP1-IDUMAM)
      COMMON /BLANK/ DUMMM(IP1), IFRAG(MAXAT), ISYM(MAXAT), IDUM(MAXAT),
     *               DUM(MAXAT), IBOND(MAXAT*10), JBOND(MAXAT*10), XGEO,
     *               DUMMY(IPDUM)
      DIMENSION LW(MAXAT)
      EQUIVALENCE (LW(1), IDUM(1))
      COMMON /SIZEX/ KFRAG(20), NFRAG, LFRAG(20), NOFRAG, NNA
      COMMON /DIRBFA/ NCELTY(10), NCELLZ(10), NCELIN(10), NCELIX(10)
      COMMON /DIRBFB/ ACELTY(10)
      CHARACTER ACELTY *2
      CHARACTER * 2   AQQQ
      EQUIVALENCE (IATOMS, IFILE(1)), (IDDL, IFILE(2))
      EQUIVALENCE (ISPEK, IFILE(4))
      EQUIVALENCE (IATOLD, IFILE(10))
      EQUIVALENCE (NTYPEZ, KEYS(4))
      EQUIVALENCE (IRUN, KSTAT(13))
      EQUIVALENCE (KPROG, KSTAT(18))
      EQUIVALENCE (IMAP, KSTAT(7))
      LOGICAL NOFREE
      EQUIVALENCE (SWITCH(9), NOFREE)
      LOGICAL DMAXCH, SWRECY
      EQUIVALENCE (SWITCH(28), DMAXCH), (SWITCH(7), SWRECY)
      CHARACTER *6 CFRAG, RFAC6
      CHARACTER *12 CFRAGX
      CHARACTER *4 RFAC
      CHARACTER ZZZ *1
      LOGICAL SPEK
      SPEK = .TRUE.
      CALL WR24
      WRITE (8, FMT='(/'' ***** SCHOUT *****''/)')
      NRFAC = 0
      IF (IPRY.NE.0) WRITE (IPRY, 101)
  101 FORMAT (/ 1X,71('-')/)
      IF (SWRECY) CALL DDRECY
      CALL FILINQ (ISPEK,  'SPF',   'FORMATTED', 'OUTPUT', KINQ)
      WRITE (ISPEK, 117) CCODE
  117 FORMAT ('TITL  : DIRDIF output for : ',A6)
      WRITE (ISPEK, 119) CELL
  119 FORMAT ('CELL  ',6F10.5)
      WRITE (ISPEK, 121) SPGR
  121 FORMAT ('SPGR  ',A16)
      IF (SPEK) WRITE(24, FMT='(/'' Output atomic parameter file '',
     *   A6, ''.spf  for PLUTON''/)') CCODER
      CALL FILCLO (IATOMS, 'KEEP')
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'OUTPUT', KINQ)
      REWIND IATOMS
      R2 = 9.99
      IF (R2X .GT. 0.0002) R2 = R2X
      IF (NRECY .GE. 1) SCALAT = SCALE
      WRITE (CHOUT, 7102) CCODE, KSTAT(13), NRECYR, R2, SCALAT
 7102 FORMAT ('ATOMS ', A6, ' < FOUR 0 ',
     *   ' RUN', I4, ' CY=', I3, ' R2X=', F6.3, '  SC=', F12.8 )
      WRITE (8, 7103) CHOUT
 7103 FORMAT (63X,'[321-121]'/' Output ATOMS:'/ 1X, A72/)
      IF (SCALAT .LE. 0.001) CHOUT(52:72) = ' '
      WRITE (IATOMS, FMT = '(A72)') CHOUT
      WRITE (IATOMS, 123) NRECYR
  123 FORMAT ('REMARK OUTPUT FOURIER CYCLE', I3, ' [ R2X = R2(input) ]')
       IF (NATREC .EQ. 0) NATREC = NAT
      NQQQ = 0
      AQQQ = ACELTY(NTYPEZ)
      IF (AQQQ .EQ. 'H') AQQQ = ACELTY(NTYPEZ-1)
      CALL GEOFOB (-1, 0, ZSCAL)
      IILWM = 1.0 + VOLUM / 17.
      CALL ATOMOC (0, ATXYZ, LW, NAT)
      IILW = 0
      DO 127 I = 1, NAT
      LW(I) = (NSYMM * NLATT) / LW(I)
      IILW = IILW + ATXYZ(4,I) * LW(I)
      IF (IILW .GT. IILWM .AND. I .LT. NAT) THEN
         WRITE (8, FMT='('' Limit NAT because at.vol. = 17 Ang3'')')
         GOTO 129
         ENDIF
  127 CONTINUE
      WIILW = VOLUM / FLOAT(IILW)
      WRITE(8,FMT='('' $TE NAT, Volume/atom:'',I4,F5.1)') NAT,WIILW
  129 II = 0
      IF (IPRY.NE.0) WRITE (IPRY, 3109)
 3109 FORMAT (/' Table 321   COORDINATES of atoms and (interpreted)',
     *  ' peaks'//
     *  ' N# name PKintegr PKheight    x',8X,'y',8X,'z',6X,'B', 4X,
     *     'cluster'/ 13X, 'x100  x100', 38X, 'number'/)
      DO 180 I=1, NAT
      IFRAG(I)=IABS(IFRAG(I))
      CALL KERI2C (IFRAG(I), CFRAG, 2)
      IF (IFRAG(I) .EQ. 0) CFRAG = '0 '
      N=MIN0(IFRAG(I)+1,11)
      CFRAGX = ' '
      CFRAGX(N:N+1) = CFRAG
      RFAC = ' '
      IF (ATXYZ(9,I) .LT. 0.0001) THEN
         WRITE(8, FMT = '('' occ. factor = 0: '', A6)') ATNAME(I)
      ELSE
         IRFAC = IMULT / NINT (ATXYZ(9,I))
         IF (IRFAC .GT. 1) THEN
            CALL KERI2C (IRFAC, RFAC6, 2)
            RFAC(2:4) = RFAC6
            RFAC(4:4) = 'R'
            IF (RFAC(3:3) .EQ. ' ') RFAC(3:3) = ':'
            NRFAC = NRFAC + 1
            ENDIF
         ENDIF
      K  = ATX4(4,I) **2 * ZSCAL
      KK = ATX4(4,I) * 10000.
      KK = KK - IFIX ( ATX4(4,I)) * 10000
      KK = ( FLOAT(KK) )**2 / 4000.
      IF (SWRECY .AND. I.LE.NATSN .AND. NRECYR.GE.3 .AND.
     *      IZAT(I).GE.5 .AND. IZAT(I).LE.9 .AND. K.LT.200) THEN
         IF (IPRY .GT. 0) WRITE (IPRY, FMT='('' Following weak atom '',
     *      A6, '' denoted Q !!!'')') ATNAME(I)
         IF (IPRY .EQ. 0) WRITE(24, FMT='('' Initial weak atom '',
     *      A6, '' rejected, i.e. denoted Q !!!'')') ATNAME(I)
         ATNAME(I)(1:1) = 'Q'
         ZZZ = ATNAME(I)(2:2)
         CALL KERC2I (ZZZ, LEND)
         IF ((LEND.LT.0).OR.(LEND.GT.9)) ATNAME(I)(2:2) = '0'
         IZAT(I) = 1
         NQQQ = NQQQ + 1
         ENDIF
      IF (I.GT.NATSN .AND. NRECYR.GE.3 .AND. I*100/95.GE.NAT .AND.
     *   ATNAME(I)(1:1) .EQ. 'Q' .AND. K.GT.111 .AND. NQQQ.GE.-2) THEN
         IF (IPRY .GT. 0) WRITE (IPRY, FMT=
     *      '('' Following tail (Q) atom accepted  !!!'')')
         ATNAME(I)(1:1) = AQQQ(1:1)
         IF (AQQQ(2:2) .NE. ' ') THEN
            RFAC6 = ATNAME(I)
            ATNAME(I)(1:2) = AQQQ
            ATNAME(I)(3:6) = RFAC6(2:6)
            ENDIF
         IZAT(I) = NCELLZ(NTYPEZ)
         IF (IZAT(I) .EQ. 1) IZAT(I) = NCELLZ(NTYPEZ-1)
         NQQQ = NQQQ - 1
         ENDIF
      IF (I.LE.NATSN .AND. ATXYZ(5,I).LT.0.0001) ATXYZ(5,I) = BP
      IF (I.GT.NATSN .AND. ATXYZ(5,I).LT.0.0001) ATXYZ(5,I) = BR
      IF (I.GT.NATSN .AND. ATNAME(I)(1:1).EQ.'Q' .AND. K.LT.99) GOTO 136
      IF (K .LT. 1) GOTO 136
      IF (II .GE. NATREC) THEN
         ATNAME(I)(1:1) = 'Q'
         ZZZ = ATNAME(I)(2:2)
         CALL KERC2I (ZZZ, LEND)
         IF ((LEND.LT.0).OR.(LEND.GT.9)) ATNAME(I)(2:6) = ATNAME(I)(3:6)
         IZAT(I) = 1
         ENDIF
  136 IF (IPRY.NE.0) THEN
         WRITE (IPRY, 137) I,ATNAME(I),K,KK, RFAC,(ATX4(J,I),J=1,3),
     *      ATXYZ(5,I), CFRAGX
  137    FORMAT (I4, 1X, A6, 2I6, A4, 3F9.5, F5.2, 1X, A12)
         IF (K .LT. 100 .AND. I .GT. NATSN) WRITE (IPRY, FMT=
     *       '(8X, A6, '' <---- not output ----'')') ATNAME(I)
         ENDIF
      IF (K .LT. 1) GOTO 180
      IF (K .GT. 100 .OR. I .LE. NATSN) THEN
         IF (IMAP .EQ. 1) ATXYZ(5,I) = 0.0
         WRITE (IATOMS, 173)
     *      ATNAME(I), (ATX4(J,I),J=1,3), (ATXYZ(J,I),J=4,5), K, CFRAG
  173    FORMAT ('ATOM   ', A6, 5F9.5, 3X, I6, '$', A6)
         IF (SPEK) WRITE (ISPEK, 174) ATNAME(I), (ATXYZ(J,I),J=1,3)
  174    FORMAT (A6,2X,3F10.5)
         IF (ATNAME(I)(1:1).NE.'Q') THEN
            II = II + 1
            IF (IPRY.NE.0 .AND. SWRECY .AND. II.EQ.NATREC) WRITE (IPRY,
     *         FMT='('' Following peaks not output for recycling'')')
            ENDIF
         ENDIF
  180 CONTINUE
      WRITE (IATOMS, FMT = '(''END'')')
      CALL COPY80 (IATOMS, 'ATOMS', 10, 'ATTEM')
      CALL FILCLO (IATOMS, 'KEEP')
      IF (SPEK) CALL FILCLO (ISPEK, 'KEEP')
      IF (NRFAC .GT. 0 .AND. IPRY.NE.0) WRITE (IPRY, 236) NRFAC
  236 FORMAT (/ ' :R =', ' symmetry reduction factor for',
     *         I3, ' atoms at special positions ')
      NATSN = NATSN - KEYS(24)
      IF (NATSN.NE.NATS) THEN
         WRITE (CHOUT,FMT='(''RUN '',I3,'' NEW   NAT= '',I4,
     *       '' KPROG '', I3)') IRUN, NATSN, KPROG
         CALL LOGWR (IDDL)
         CALL FILCLO (IDDL, 'KEEP')
         ENDIF
      NATS = NATSN
      IF (SWRECY) THEN
         NATREC = II
         WRITE(24, 242) NATREC
  242    FORMAT (' Number of atoms output  for Fourier recycling :',I4)
         ENDIF
      IF (NNA .LE. 0) GOTO 1900
      IF (NNA .GT. 1) CALL ISORT (ISYM, NNA)
      ISYM(NNA + 1) = 0
      JJ=0
      K=0
      DO 1890 I = 1, NNA
      II=ISYM(I)/250000
      IF (IPRY.NE.0 .AND. II.NE.JJ) WRITE (IPRY, 1860) II
 1860 FORMAT (/' Cluster', I3, '  joins to itself through the peak',
     *          'pairs)')
      JJ=II
      K=K+2
      LW(K-1)=MOD(ISYM(I),250000)/500
      LW(K)=MOD(ISYM(I),500)
      IF (K .GT. 2) THEN
         IF (LW(K) .EQ. LW(K-2)) K = K - 2
         ENDIF
      IF (K.LT.12.AND.II.EQ.ISYM(I+1)/250000) GOTO 1890
      IF (IPRY.NE.0) WRITE (IPRY, 1870) (LW(J),J=1,K)
 1870 FORMAT (1X, 6(I7,',',I3))
      K=0
 1890 CONTINUE
 1900 RETURN
      END
      SUBROUTINE DDRECY
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      LOGICAL SWRECY
      EQUIVALENCE   (SWITCH(7),SWRECY)
      EQUIVALENCE (IHELP, IFILE(10))
      EQUIVALENCE (NTYPEZ, KEYS(4))
      INCLUDE 'Zatomx.inc'
      PARAMETER (IP1=1)
      PARAMETER (IDUMAM=24*MAXAT+1)
      PARAMETER (IP160=160000, IPDUM=IP160-IP1-IDUMAM)
      COMMON /BLANK/ DUMMM(IP1), IFRAG(MAXAT), ISYM(MAXAT), IDUM(MAXAT),
     *               DUM(MAXAT), IBOND(MAXAT*10), JBOND(MAXAT*10), XGEO,
     *               DUMMY(IPDUM)
      INCLUDE 'Zsear.inc'
      COMMON /DIRBFA/ NCELTY(10), NCELLZ(10), NCELIN(10), NCELIX(10)
      COMMON /DIRBFB/ ACELTY(10)
      CHARACTER ACELTY *2
      CHARACTER CAT *2
      CHARACTER*4 ATNAM
      LOGICAL FIRST
      CHARACTER ZZZ *1
      DATA JZAT / 1 /
      DATA NCALL / 0 /
      NCALL = NCALL + 1
      FIRST = .FALSE.
      CALL WR24
      IF (NRECYR.LE.1 .OR. (NRECYR.EQ.2 .AND. NATREC-NATSN .GT. 30))
     *   FIRST = .TRUE.
      IF (NRECYR .LE. 1 .AND. NCALL .EQ. 1) WRITE(24, 101)
  101 FORMAT (' NOTE about the RECYCLING procedure with PHASEX and',
     * ' FOUR.'/ ' Usually, the R2 driven dual space',
     * ' recycling strategy, with'/' atom clean-up based upon expected',
     * ' peak heights and molecular geometry,'/
     * ' leads to completeness of the structure in 10 - 20 cycles.'/
     * ' If almost correct, you may rename atoms and reconsider the'/
     * ' unit cell contents, and continue with:  DIRDIF CCODE FOUR'/)
      NCAT = NTYPEZ
      IF (ACELTY(NCAT) .EQ. 'H' .AND. NCAT .GT. 1) NCAT = NCAT - 1
      IF (NCELLZ(NCAT) .GT. 6) RETURN
      CAT = ACELTY(NCAT)
      IRESET = 0
      IF (.NOT. FIRST) GOTO 500
      DO 300 I = NATSN + 1, NATREC
      IF (IRESET .GT. 0) GOTO 250
      IF (IZAT(I) .GT. 18) GOTO 300
      IF (IZAT(I) .LE. 14) GOTO 300
      IF (ATXYZ(8,I) .GT. 0.5 * FLOAT(IZAT(I)) ) GOTO 300
      IRESET = I
      WRITE (8, FMT='('' $TEMP .... P .. S .. CL  low peak >?'')')
  250 IZAT(I) = NCELLZ(NCAT)
      ZZZ = ATNAME(I)(2:2)
      CALL KERC2I (ZZZ, KEND)
      ATNAM = ATNAME(I) (2:5)
      IF (KEND .GE. 10) ATNAM = ATNAME(I) (3:6)
      ATNAME(I) (1:2) = CAT
      ATNAME(I) (3:6) = ATNAM
      IF (ATNAME(I) (2:2) .EQ. ' ') ATNAME(I) (2:6) = ATNAM
      CALL ATN24X (ATNAME(I), ATNAME, NATREC, ATNAME(I))
  300 CONTINUE
  400 IF (IPRY.NE.0 .AND. IRESET .GT. 0)
     *  WRITE (IPRY, 402) IRESET, CAT
  402 FORMAT (/' Note about the recycling strategy:'/
     *        /' Starting from peak number' , I3,
     *  ' all peaks have been named ', A2/)
      RETURN
  500 NPK = 0
      PK = 0.
      DO 510 I = NATSN + 1, NATREC
      IF (IZAT(I) .GT. 10 .OR. IZAT(I) .LE. 1) GOTO 510
      NPK = NPK + 1
      PK = PK + ATXYZ(8,I)
      IF (NPK .GT. 1) GOTO 510
      JZAT = IZAT(I)
      CAT = ATNAME(I) (1:2)
      ZZZ = ATNAME(I)(2:2)
      CALL KERC2I (ZZZ, KEND)
      IF (KEND .LE. 10 .OR. KEND .GE. 37) CAT(2:2) = ' '
  510 CONTINUE
      IF (NPK .LE. 4) RETURN
      PK = PK / FLOAT(NPK)
      DO 600 I = NATSN + 1, NATREC
      IF (IZAT(I) .GT. 18 .OR. IZAT(I) .LT. 10) GOTO 600
      IF (ATXYZ(8,I) .GT. 1.5 * PK) GOTO 600
      IF (IRESET .EQ. 0) IRESET = I
      IZAT(I) = JZAT
      ZZZ = ATNAME(I)(2:2)
      CALL KERC2I (ZZZ, KEND)
      ATNAM = ATNAME(I) (2:5)
      IF (KEND .GE. 10) ATNAM = ATNAME(I) (3:6)
      ATNAME(I) (1:2) = CAT
      ATNAME(I) (3:6) = ATNAM
      IF (ATNAME(I) (2:2) .EQ. ' ') ATNAME(I) (2:6) = ATNAM
  600 CONTINUE
      GOTO 400
      END
      SUBROUTINE ISORT (N, M)
      DIMENSION N(M)
      INT=2
 1000 INT=INT+INT
      IF (INT.LT.M) GOTO 1000
      INT=MIN0(M,(3*INT)/4-1)
 1020 INT=INT/2
      IFIN=M-INT
      DO 1200 II=1,IFIN
      I=II
      J=I+INT
      IF (N(I).LE.N(J)) GOTO 1200
      IT=N(J)
 1080 N(J)=N(I)
      J=I
      I=I-INT
      IF (I.LE.0) GOTO 1090
      IF (N(I).GT.IT) GOTO 1080
 1090 CONTINUE
      N(J)=IT
 1200 CONTINUE
      IF (INT.NE.1) GOTO 1020
      RETURN
      END
      FUNCTION JSYMM(I,J,K,IB,XS,X1)
      DIMENSION IB(3),XS(3),X1(3)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zsear.inc'
      DIMENSION DXYZM(3)
      LOGICAL CONT
      DATA CONT / .FALSE. /
      IF (CONT) GOTO 111
      CONT = .TRUE.
      DM = AMAX1 (2.8, DMAXB)
      DO 101 L = 1, 3
  101 DXYZM(L) = DM * RCELL(L)
  111 JSYMM = 0
      CALL OPER1 (K, XS, ATX4(1,J))
      DO 1080 L=1,3
      IB(L)=5
 1060 X1(L)=ATX4(L,I)-XS(L)
      IF (ABS(X1(L)).LE.0.5)GOTO 1070
      XS(L)=XS(L)+SIGN(1.0,X1(L))
      IB(L)=IB(L)+ISIGN(1,IFIX(2.0*X1(L)))
      GOTO 1060
 1070 IF (ABS(X1(L)) .GT. DXYZM(L)) GOTO 1100
 1080 CONTINUE
      RETURN
 1100 JSYMM = 1
      RETURN
      END
      SUBROUTINE EIGEN (B, V, IND)
      DIMENSION B(3,3),V(3,3),IND(3)
      DATA ZERO / 1.0E-12 /
      DO 1020 I=1,3
      DO 1000 J=1,3
      V(I,J)=0.0
 1000 CONTINUE
      V(I,I)=1.0
 1020 CONTINUE
      NNN = 17
 1040 KNT=0
      NNN = NNN - 1
      IND1=1
      IND3=1
      DO 1500 I=1,2
      IP1=I+1
      DO 1460 J=IP1,3
      IF (ABS(B(I,J)) .LT. 0.000001 * B(IND1,IND1)) KNT = KNT + 1
      BIJ=B(I,I)-B(J,J)
      IF (ABS(B(I,J)).LT.ABS(BIJ))GOTO 1100
      IF (ABS(BIJ).LT.ZERO) THEN
         BIJ = 0.0
         T = 1.
      ELSE
         T=SIGN(1.0,B(I,J)*BIJ)
         ENDIF
      GOTO 1180
 1100 CONTINUE
      T=B(I,J)/BIJ
 1180 CONTINUE
      IF (ABS(T) .GT. 1.E-6) THEN
         G=T/(2.0+2.0*T*T)
         SN=2.0*G/(1.0+G*G)
         CS=1.0-G*SN
      ELSE
         SN = 0.
         CS = 1.
         ENDIF
      DO 1200 K=1,3
      BIK=B(I,K)
      B(I,K)=CS*B(I,K)+SN*B(J,K)
      B(J,K)=CS*B(J,K)-SN*BIK
 1200 CONTINUE
      DO 1220 K=1,3
      BKI=B(K,I)
      B(K,I)=CS*B(K,I)+SN*B(K,J)
      B(K,J)=CS*B(K,J)-SN*BKI
      VKI=V(K,I)
      V(K,I)=CS*V(K,I)+SN*V(K,J)
      V(K,J)=CS*V(K,J)-SN*VKI
 1220 CONTINUE
 1460 CONTINUE
      IF (B(IP1,IP1).GT.B(IND1,IND1))IND1=IP1
      IF (B(IND3,IND3).GT.B(IP1,IP1))IND3=IP1
 1500 CONTINUE
      IF (KNT.LT.3 .AND. NNN.GT.0) GOTO 1040
      IND(1)=IND1
      IND(2)=1
      IND(3)=IND3
      IF (IND1.EQ.IND(2).OR.IND3.EQ.IND(2))IND(2)=2
      IF (IND1.EQ.IND(2).OR.IND3.EQ.IND(2))IND(2)=3
      DET = V(1,1)*(V(2,2)*V(3,3)-V(2,3)*V(3,2))+V(1,2)*(V(2,3)*V(3,1)
     1  -V(2,1)*V(3,3))+V(1,3)*(V(2,1)*V(3,2)-V(2,2)*V(3,1))
      IF (DET .GT. 0.0) RETURN
      DO 1520 I=1,3
      V(I,3) = -V(I,3)
 1520 CONTINUE
      RETURN
      END
      SUBROUTINE PP1
      INCLUDE 'Zaaaa.inc'
      EQUIVALENCE (IFMAP, IFILE(17)), (ISCRA, IFILE(18))
      EQUIVALENCE (KEYS(28), IHALF)
      COMMON /FFTDA/ SCALEW, MH(3), NPP(3), XLMIN(3), XLMAX(3)
      EQUIVALENCE (IMAP, KSTAT(7))
      PARAMETER (KUSER2=30000, LUSER2=15000)
      COMMON /BLANK/ X(KUSER2), DUMMY(130000)
      COMPLEX YCOM(LUSER2)
      EQUIVALENCE (X(1), YCOM(1))
      INTEGER  P1, P2, R, SKIP, RECS,  D(5)
      DATA NCALL /0/
      NCALL = NCALL + 1
      NSIZE = KUSER2 - 1
      NX = NPP(1)
      NY = NPP(2)
      NZ = NPP(3)
      RECMAX = 32000.
      MAXSIZ = IFIX ( SQRT (RECMAX * 0.25 * FLOAT (NX*NY*NZ)) )
      NSIZE  = MIN0 (NSIZE, MAXSIZ)
      P1 = NSIZE / (2*NY*(MH(3) + 1))
      P2 = NSIZE / (NX*NZ)
      MPASS = MAX0 (1, NX / MAX0 (1, P1) )
      NBYTES = P1 * P2 * (MH(3)+1) * 8 + 8
      IF (NCALL .GE. 3) GOTO 103
      WRITE (8, 101) NBYTES
  101 FORMAT (' Scratch file has max.', I6, ' bytes per record')
      IF (NRECYR .LE. 1 .AND. MPASS .GT. 2) WRITE (24, 102) MPASS
  102 FORMAT (' Appr. nr of intermediate Fourier-transform passes:', I3)
      MPASS = MPASS / MAX0 (1, MPASS/4)
  103 CONTINUE
      NPASS = 0
      NEX = -1
      REWIND ISCRA
      R = -MH(1)
  111 CONTINUE
      IF (R+P1 .GT. MH(1)) P1 = MH(1) + 1 - R
      CALL RDHKL (NEX, YCOM, NY, MH(3)+1, P1, R)
      D(1) = 2*(NY*P1*(MH(3)+1))
      D(2) = 2
      D(3) = D(1)
      D(4) = D(1)
      D(5) = 2*NY
      CALL CMPLFT (X(1), X(2), NSIZE, NY, D)
      CALL WRITEY (YCOM, NY, MH(3)+1, P1, P2, ISCRA)
      NPASS = NPASS + 1
      IF (MPASS .GT. 1 .AND. NRECYR .LE. 1 .AND.
     *   MOD (NPASS, MPASS) .EQ. 0 .AND. NCALL .LE. 2)
     *   WRITE (24, FMT=
     *   '(1X/'' Intermediate Fourier transform,  pass'', I2)') NPASS
      CALL WR24
      R = R + P1
      IF (R .LE. MH(1)) GOTO 111
      IF (IMAP.EQ.5) THEN
         SCALEW = 500.0 / SCALEW
      ELSE
         SCALEW = 3000.0 / SCALEW
         ENDIF
      SCALOR = SCALEW
      REWIND IFMAP
      NYNEW = NY
      WRITE (IFMAP) SCALOR, IMAP, IHALF
      IF (IHALF.NE.0) NYNEW = MIN0 (NY-NY/2+3, NY)
      WRITE (IFMAP) NX,NZ,NYNEW,NY
      REWIND ISCRA
      SKIP = 0
      R = 0
      P1 = NSIZE / (2*NY*(MH(3) + 1))
      RECS = (NY - 1)/P2
      NPASS = 0
  200 IF (R+P2 .GT. NY) P2 = NY - R
      CALL READHL (YCOM, NX,NZ/2, P2,MH(1),MH(3),P1,SKIP,RECS,ISCRA)
      IF (R + P2 .LT. NY) REWIND ISCRA
      SKIP = SKIP + 1
      D(1) = NX * NZ * P2
      D(2) = NZ
      D(3) = NZ * NX
      D(4) = 2 * (MH(3) + 1)
      D(5) = 2
      CALL CMPLFT (X(1), X(2), NSIZE, NX, D)
      D(2) = 2
      D(3) = D(1)
      D(4) = D(1)
      D(5) = NZ
      CALL HERMFT (X(1), X(2), NSIZE, NZ/2, D)
      CALL OUTPUT (X, NZ, NX, P2, R, NY)
      NPASS = NPASS + 1
      IF (MPASS .GT. 1 .AND. NRECYR .LE. 1 .AND.
     *   MOD (NPASS, MPASS) .EQ. 0 .AND. NCALL .LE. 2)
     *   WRITE (24, FMT=
     *   '(16X, ''  Final transform,  pass'', I2)') NPASS
      CALL WR24
      R = R + P2
      IF (R .LT. NY) GOTO 200
      CALL FILCLO (ISCRA, 'DELETE')
      RETURN
      END
      SUBROUTINE RDHKL (NEX, X, NY, NZ, NX, HS)
      INTEGER HS
      COMPLEX X(NY,NZ,NX)
      INCLUDE 'Zsyst.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zbuff.inc'
      EQUIVALENCE (IBINFF, IFILE(16))
      EQUIVALENCE (IMAP, KSTAT(7))
      COMMON /FFTDA/ SCALEW, MH(3), NPP(3), XLMIN(3), XLMAX(3)
      EQUIVALENCE (FITFFT(4),EI), (FITFFT(5),PHI)
      INTEGER H, HM, HL
      DIMENSION IHKLX(3,24), PHX(24), NSYMEX(24), GRI(2,24), TAB(15)
      DIMENSION IHKLI(3), ITSYMM(3,24), NRCO(5)
      D2R = ATAN(1.0) / 45.0
      CALL WR24
      IF (NEX .GE. 0) GOTO 210
      NEX = 0
      NPASS = 0
      SCALEW = 0.0
      CALL KERNZI (0, NRCO, 5)
      DO 110 I=1,15
  110 TAB(I) = SIN (FLOAT(30*I) * D2R)
      DO 113 J=1,NSYMM
      DO 113 I=1,3
  113 ITSYMM(I,J) = NINT (TSYMM(I,J) * 12.0)
  210 CONTINUE
      CALL BINIFF (1, IBINFF, 'BINFFT', FITFFT, NITFFT, BUFFFT, NEND)
      NPASS = NPASS + 1
      HM = HS + NX - 1
      HL = HS
      IDISC = HL * HM
      IHMAX = MAX0 (IABS(HL), IABS(HM))
      IHMIN = MIN0 (IABS(HL), IABS(HM))
      DO 220 H=1,NX
      DO 220 L=1,NZ
      DO 220 K=1,NY
  220 X(K,L,H) = CMPLX(0.0,0.0)
  320 CALL BINIFF (0, IBINFF, 'BINFFT', FITFFT, NITFFT, BUFFFT, NEND)
      IF (NEND.LT.0) GOTO 500
      IF (NPASS .GT. 1) GOTO 330
      NRCO(1) = NRCO(1) + 1
      IF (EI .LT. 0.0) THEN
         NRCO(2) = NRCO(2) + 1
         GOTO 320
         ENDIF
  330 CALL KERF2I(FITFFT, IHKLI, 3)
      IF (ISYST.GT.4 .AND. ISYST.LT.8) GOTO 360
      INMAX = MAX0 (IABS(IHKLI(1)), IABS(IHKLI(2)), IABS(IHKLI(3)))
      INMIN = MIN0 (IABS(IHKLI(1)), IABS(IHKLI(2)), IABS(IHKLI(3)))
      IF (IDISC.LT.0) GOTO 360
      IF (INMIN.GT.IHMAX .OR. INMAX.LT.IHMIN) GOTO 320
  360 CALL FEXPAN (IHKLI, IHKLX, PHX, NSYMEX, NEXP)
      PHI = PHI * D2R
      EC  = EI * COS(PHI)
      ES  = EI * SIN(PHI)
      DO 380 J=1,NEXP
      H = IHKLX(1,J)
      IF (H.GT.HM .OR. H.LT.HL) GOTO 380
      IF (IABS(H) .GE. NPP(1)/2 .OR. IABS(H) .GT. MH(1)) THEN
         NRCO(3) = NRCO(3) + 1
         GOTO 380
         ENDIF
      K = IHKLX(2,J)
      IF (IABS(K) .GE. NPP(2)/2 .OR. IABS(K) .GT. MH(2)) THEN
         NRCO(4) = NRCO(4) + 1
         GOTO 380
         ENDIF
      L = IHKLX(3,J)
      IF (IABS(L) .GE. NPP(3)/2 .OR. IABS(L) .GT. MH(3)) THEN
         NRCO(5) = NRCO(5) + 1
         GOTO 380
         ENDIF
      NU = 0
      IF (IMAP.LE.0 .OR. IMAP.EQ.2 .OR. IMAP.GE.5) GOTO 370
      NSYMX = NSYMEX(J)
      NU = - IHKLI(1)*ITSYMM(1,NSYMX) - IHKLI(2)*ITSYMM(2,NSYMX)
     *     - IHKLI(3)*ITSYMM(3,NSYMX)
      NU = MOD(NU,12)
  370 IF (NU.LE.0) NU = NU + 12
      XS = TAB(NU)
      XC = TAB(NU+3)
      GRI(1,J) =  XC*EC - XS*ES
      GRI(2,J) = (XS*EC + XC*ES) * PHX(J)
      NEX = NEX + 1
      SCALEW = SCALEW + SQRT(GRI(1,J)*GRI(1,J)+GRI(2,J)*GRI(2,J))
      NOKO = 0
      IF (H.EQ.0 .AND. L.EQ.0 .AND. K.NE.0) NOKO = NY - K + 1
      H = H - HS + 1
      IF (K.LT.0) K = NY + K
      K = K + 1
      L = L + 1
      X(K,L,H) = CMPLX(GRI(1,J),GRI(2,J))
      IF (NOKO.NE.0) X(NOKO,L,H) = CONJG(X(K,L,H))
  380 CONTINUE
      GOTO 320
  500 CONTINUE
      IF (NX + HS .LE. MH(1)) RETURN
      CALL FILCLO (IBINFF, 'DELETE')
      WRITE (8, 631) NPASS
  631 FORMAT (' Intermediate transforms required ', I3, ' passes')
      WRITE (8, 690) NRCO(1)
  690 FORMAT (' Number of reflections from input file   =',I7)
      IF (NRCO(2) .GT. 0) WRITE (8, 691) NRCO(2)
  691 FORMAT (' of which',I7,' were rejected'/)
      WRITE (8, 692) NEX
  692 FORMAT (' Number of reflections in one hemisphere =',I7)
      IF (NEX .EQ. 0) CALL KERROR ('No reflections found', 0,'RDHKL')
      IF (NRCO(3).GT.0 .OR. NRCO(4).GT.0 .OR. NRCO(5).GT.0)
     *    WRITE (8, 693)
  693 FORMAT (' not included in calculations, because: '/)
      IF (NRCO(3).GT.0) WRITE (8, 694) MH(1), NRCO(3)
  694 FORMAT (8X,' having H greater than ',I3,'  were ',I6/)
      IF (NRCO(4).GT.0) WRITE (8, 695) MH(2), NRCO(4)
  695 FORMAT (8X,' having K greater than ',I3,'  were ',I6/)
      IF (NRCO(5).GT.0) WRITE (8, 696) MH(3), NRCO(5)
  696 FORMAT (8X,' having L greater than ',I3,'  were ',I6/)
      RETURN
      END
      SUBROUTINE FEXPAN (IHKLI, IHKLX, PHX, NSYMEX, NEXP)
      DIMENSION IHKLI(3), IHKLX(3,24), PHX(24), NSYMEX(24)
      INCLUDE 'Zcrys.inc'
      DIMENSION IHKLS(3)
      NEXP = 0
      DO 3900 J=1,NSYMM
      CALL VXMATI (IHKLI, IRSYMM(1,1,J), IHKLS)
      B1 = 1.0
      IF (IHKLS(3)) 1590, 1570, 1600
 1570 IF (IHKLS(1)) 1590, 1580, 1600
 1580 IF (IHKLS(2)) 1590, 1600, 1600
 1590 B1 = -1.0
      DO 3610 I=1,3
 3610 IHKLS(I) = -IHKLS(I)
 1600 CONTINUE
      IF (J.EQ.1) GOTO 1630
      DO 3620 JJ=1, NEXP
      IF (IHKLX(1,JJ) .EQ. IHKLS(1) .AND. IHKLX(2,JJ) .EQ. IHKLS(2)
     *   .AND. IHKLX(3,JJ) .EQ. IHKLS(3)) GOTO 3900
 3620 CONTINUE
 1630 NEXP = NEXP + 1
      CALL KERNAI (IHKLS, IHKLX(1, NEXP), 3)
      PHX(NEXP) = B1
      NSYMEX(NEXP) = J
 3900 CONTINUE
      RETURN
      END
      SUBROUTINE WRITEY (X, NY, NZ, NX, SIZE, ISCRA)
      COMPLEX X(NY,NZ,NX)
      INTEGER SIZE, H, P, Q, R
      P = SIZE
      Q = 0
  100 R = Q + 1
      IF (Q+P .GT. NY) P = NY - Q
      Q = Q + P
      WRITE (ISCRA) (((X(K,L,H), H=1,NX), K=R,Q), L=1,NZ)
      IF (Q .LT. NY) GOTO 100
      RETURN
      END
      SUBROUTINE READHL (X,NX,NZ,NY,HMAX,LMAX,SIZE,SKIP,RECS,ISCRA)
      INTEGER HMAX, SIZE, SKIP ,RECS, H, HL, HU, P, Q
      COMPLEX X(NZ,NX,NY)
      LM = LMAX + 1
      P = SIZE
      HU = NX - HMAX
      IF (SKIP .LE. 0) GOTO 200
      DO 100 Q=1,SKIP
      READ (ISCRA)
  100 CONTINUE
  200 IF (HU + P .GT. NX) GOTO 400
      HL = HU + 1
      HU = HU + P
      READ (ISCRA) (((X(L,H,K), H=HL,HU), K=1,NY), L=1,LM)
      IF (RECS .LE. 0) GOTO 200
      DO 300 Q=1,RECS
      READ (ISCRA)
  300 CONTINUE
      GOTO 200
  400 IF (HU .NE. NX) GOTO 700
      HU = 0
  500 IF (HU+P .GT. HMAX+1) P = HMAX + 1 - HU
      HL = HU + 1
      HU = HU + P
      READ (ISCRA) (((X(L,H,K), H=HL,HU), K=1,NY), L=1,LM)
  550 IF (HU .EQ. HMAX + 1) GOTO 800
      IF (RECS .LE. 0) GOTO 500
      DO 600 Q=1,RECS
      READ (ISCRA)
  600 CONTINUE
      GOTO 500
  700 HL = HU + 1
      HU = HU + P - NX
      IF (HU .GT. HMAX+1) HU = HMAX + 1
      READ (ISCRA) (((X(L,H,K), H=HL,NX), (X(L,H,K), H=1,HU),
     *   K=1,NY), L=1,LM)
      GOTO 550
  800 DO 900 H=2,HU
      HL = NX + 2 - H
      DO 900 K=1,NY
      X(1,HL,K) = CONJG(X(1,H,K))
  900 CONTINUE
      HL = HMAX + 2
      HU = NX - HMAX
      IF (HU .LT. HL) GOTO 920
      DO 910 L=1,LM
      DO 910 K=1,NY
      DO 910 H=HL,HU
      X(L,H,K) = CMPLX(0.0,0.0)
  910 CONTINUE
  920 IF (LM .GE. NZ) GOTO 940
      P = LM + 1
      DO 930 K=1,NY
      DO 930 L=P,NZ
      DO 930 H=1,NX
      X(L,H,K) = CMPLX(0.0,0.0)
  930 CONTINUE
  940 RETURN
      END
      SUBROUTINE OUTPUT (X, NZ, NX, NY, Y, NYT)
      REAL X(NZ,NX,NY)
      INTEGER Y
      INCLUDE 'Zsyst.inc'
      EQUIVALENCE (IFMAP, IFILE(17))
      EQUIVALENCE (KEYS(28), IHALF)
      LOGICAL PRIMAP
      EQUIVALENCE (PRIMAP, SWITCH(11))
      COMMON /FFTDA/ SCALEW, MH(3), NPP(3), XLMIN(3), XLMAX(3)
      INTEGER SEC, XL, XU
      INTEGER*2 INUT(250)
      DIMENSION LINE(50)
      DATA NCOL /36/
      CALL WR24
      IF (IHALF.NE.0)THEN
         NSECO = MIN0 (NYT-NYT/2+2, NYT)
         XLMAX(2) = AMIN1 (XLMAX(2), 0.5)
      ELSE
         NSECO = NYT
         ENDIF
      NXM = MIN0 (NX,  INT(XLMAX(1)*FLOAT(NX)) +1)
      NYM = MIN0 (NYT, INT(XLMAX(2)*FLOAT(NYT))+1)
      NZM = MIN0 (NZ,  INT(XLMAX(3)*FLOAT(NZ)) +1)
      ASC = 1000.0 / FLOAT(NX)
      DO 900 K=1,NY
      SEC = Y + K - 1
      NRSEC = SEC + 1
      DO 350 J=1,NZ
      DO 330 I=1,NX
      X(J,I,K) = X(J,I,K) * SCALEW
      INUT4 = MIN0 (NINT (X(J,I,K)), 32767)
      INUT4 = MAX0 (INUT4, -32767)
  330 INUT(I) = INUT4
      IF (NRSEC.LE.NSECO) WRITE (IFMAP) SEC, J, NX, (INUT(I),I=1,NX)
      IF (NRSEC.EQ.NYT .AND. IHALF.NE.0)
     +WRITE (IFMAP) SEC, J, NX, (INUT(I),I=1,NX)
  350 CONTINUE
      IF (.NOT. PRIMAP) GOTO 900
      XU = 0
  450 XL = XU + 1
      XU = XU + NCOL
      IF (XU.GT.NXM) XU = NXM
      DO 460 L=XL,XU
      INUT(L) = FLOAT((L-1))*ASC + 0.5
  460 CONTINUE
      NEC = 1000.*(FLOAT(SEC))/(FLOAT(NYT)) + 0.5
      WRITE (8, 480) NEC
  480 FORMAT ('1SECTION  Y = ', I4 /)
      WRITE (8, 500) (INUT(NN), NN=XL,XU,2)
  500 FORMAT (8X,'X =',I4,17I6)
      ILIM = XL + 1
      WRITE (8, 520) (INUT(NN), NN=ILIM,XU,2)
  520 FORMAT (12X,18I6)
      WRITE (8, 530)
  530 FORMAT ('0')
      DO 700 I=1,NZM
      LINE(1) = FLOAT((I-1))*1000./FLOAT(NZ) + 0.5
      L = 1
      DO 600 J=XL,XU
      L = L + 1
      LINE(L) = NINT (0.1 * X(I,J,K))
      IF (LINE(L) .LT. -99) LINE(L) = -99
  600 CONTINUE
      WRITE (8, 630) (LINE(J), J=1,L)
  630 FORMAT (' Z =',I4,' *  ',36I3)
  700 CONTINUE
      IF (XU.LT.NXM)GOTO 450
      IF (SEC.GE.NYM) PRIMAP = .FALSE.
  900 CONTINUE
      RETURN
      END
      SUBROUTINE CMPLFT (X, Y, NSIZE, N, D)
      REAL X(NSIZE), Y(NSIZE)
      INTEGER D(5),PMAX,PSYM,TWOGRP,FACTOR(15),SYM(15),UNSYM(15)
      PMAX   = 5
      TWOGRP = 4
      CALL SRFP (N, PMAX, TWOGRP, FACTOR, SYM, PSYM, UNSYM)
      CALL MDFTKD (N, FACTOR, D, X, Y, NSIZE)
      CALL DIPRP (N, SYM, PSYM, UNSYM, D, X, Y, NSIZE)
      RETURN
      END
      SUBROUTINE SRFP (PTS,PMAX,TWOGRP,FACTOR,SYM,PSYM,UNSYM)
      INTEGER PTS,PMAX,TWOGRP,PSYM, FACTOR(15), SYM(15), UNSYM(15)
      INTEGER PP(14), QQ(7), F, P, PTWO, Q, R
      N = PTS
      PSYM = 1
      F = 2
      P = 0
      Q = 0
  100 IF (N.LE.1) GOTO 500
      DO 200 J=F,PMAX
      IF (N.EQ.(N/J)*J) GOTO 300
  200 CONTINUE
      CALL KERNER (200, 'SRFP')
  300 F = J
      N = N / F
      IF (N.EQ.(N/F)*F) GOTO 400
      Q = Q + 1
      QQ(Q) = F
      GOTO 100
  400 N = N / F
      P = P + 1
      PP(P) = F
      PSYM = PSYM * F
      GOTO 100
  500 R = 1
      IF (Q.EQ.0) R = 0
      IF (P.LT.1) GOTO 700
      DO 600 J=1,P
      JJ = P + 1 - J
      SYM(J) = PP(JJ)
      FACTOR(J) = PP(JJ)
      JJ = P + Q + J
      FACTOR(JJ) = PP(J)
      JJ = P + R + J
      SYM(JJ) = PP(J)
  600 CONTINUE
  700 IF (Q.LT.1) GOTO 900
      DO 800 J=1,Q
      JJ = P + J
      UNSYM(J) = QQ(J)
      FACTOR(JJ) = QQ(J)
  800 CONTINUE
      SYM(P+1) = PTS / PSYM**2
  900 JJ = 2*P + Q
      FACTOR(JJ+1) = 0
      PTWO = 1
      J = 0
 1000 J = J + 1
      IF (FACTOR(J).EQ.0) GOTO 1200
      IF (FACTOR(J).NE.2) GOTO 1000
      PTWO = PTWO * 2
      FACTOR(J) = 1
      IF (PTWO .GE. TWOGRP) GOTO 1100
      IF (FACTOR(J+1).EQ.2) GOTO 1000
 1100 FACTOR(J) = PTWO
      PTWO = 1
      GOTO 1000
 1200 IF (P.EQ.0) R = 0
      JJ = 2*P + R
      SYM(JJ+1) = 0
      IF (Q.LE.1) Q = 0
      UNSYM(Q+1) = 0
      RETURN
      END
      SUBROUTINE DIPRP (PTS, SYM, PSYM, UNSYM, DIM, X, Y, NSIZE)
      REAL X(NSIZE), Y(NSIZE)
      INTEGER SYM(15), UNSYM(15), DIM(5), PTS, PSYM, DK, PUNSYM, TEST
      LOGICAL ONEMOD
      INTEGER SEP, DELTA, P, P0, P1, P2, P3, P4, P5, SIZE
      INTEGER V(14), MODULO(14), S(14), U(14)
      DATA MODS / 0 /
      NEST = 14
      NT = DIM(1)
      SEP = DIM(2)
      P2 = DIM(3)
      SIZE = DIM(4) - 1
      P4 = DIM(5)
      IF (SYM(1).EQ.0) GOTO 500
      DO 100 J=1,NEST
      U(J) = 1
      S(J) = 1
  100 CONTINUE
      N = PTS
      DO 200 J=1,NEST
      IF (SYM(J).EQ.0) GOTO 300
      JJ = NEST + 1 - J
      U(JJ) = N
      N = N / SYM(J)
      S(JJ) = N
  200 CONTINUE
  300 JJ = 0
      L = 1
      V(1) = 1
  310 L = L + 1
      V(L) = V(L-1)
  320 IF (L.LT.NEST) GOTO 310
      N = V(NEST)
      JJ = JJ + 1
      IF (JJ.GE.N) GOTO 400
      DELTA = (N-JJ) * SEP
      P1 = (JJ-1)*SEP + 1
      DO 350 P0=P1,NT,P2
      P3 = P0 + SIZE
      DO 350 P=P0,P3,P4
      P5 = P + DELTA
      T = X(P)
      X(P) = X(P5)
      X(P5) = T
      T = Y(P)
      Y(P) = Y(P5)
      Y(P5) = T
  350 CONTINUE
  400 V(L) = V(L) + S(L)
      IF (V(L).LE.U(L)) GOTO 320
      L = L - 1
      IF (L.NE.0) GOTO 400
  500 IF (UNSYM(1).EQ.0) GOTO 1900
      PUNSYM = PTS / PSYM**2
      MULT = PUNSYM / UNSYM(1)
      TEST = (UNSYM(1)*UNSYM(2)-1) * MULT * PSYM
      LK = MULT
      DK = MULT
      DO 600 K=2,NEST
      IF (UNSYM(K).EQ.0) GOTO 700
      LK = LK * UNSYM(K-1)
      DK = DK / UNSYM(K)
      U(K) = (LK-DK) * PSYM
      MODS = K
  600 CONTINUE
  700 ONEMOD = MODS.LT.3
      IF (ONEMOD) GOTO 900
      DO 800 J=3,MODS
      JJ = MODS + 3 - J
      MODULO(JJ) = U(J)
  800 CONTINUE
  900 MODULO(2) = U(2)
      JL = (PUNSYM-3) * PSYM
      MS = PUNSYM * PSYM
      DO 1800 J=PSYM,JL,PSYM
      K = J
 1000 K = K * MULT
      IF (ONEMOD) GOTO 1200
      DO 1100 I=3,MODS
      K = K - (K/MODULO(I))*MODULO(I)
 1100 CONTINUE
 1200 IF (K.GE.TEST) GOTO 1300
      K = K - (K/MODULO(2))*MODULO(2)
      GOTO 1400
 1300 K = K - (K/MODULO(2))*MODULO(2)+MODULO(2)
 1400 IF (K.LT.J) GOTO 1000
      IF (K.EQ.J) GOTO 1800
      DELTA = (K-J) * SEP
      DO 1600 L=1,PSYM
      DO 1500 M=L,PTS,MS
      P1 = (M+J-1)*SEP + 1
      DO 1500 P0=P1,NT,P2
      P3 = P0 + SIZE
      DO 1500 JJ=P0,P3,P4
      KK = JJ + DELTA
      T = X(JJ)
      X(JJ) = X(KK)
      X(KK) = T
      T = Y(JJ)
      Y(JJ) = Y(KK)
      Y(KK) = T
 1500 CONTINUE
 1600 CONTINUE
 1800 CONTINUE
 1900 RETURN
      END
      SUBROUTINE MDFTKD (N, FACTOR, DIM, X, Y, NSIZE)
      INTEGER FACTOR(15), DIM(5), F, P, R, S
      REAL X(NSIZE), Y(NSIZE)
      S = DIM(2)
      F = 0
      M = N
  100 F = F + 1
      P = FACTOR(F)
      IF (P.EQ.0) RETURN
      M = M / P
      R = M * S
      NDIR1 = NSIZE - R
      NDIR2 = NDIR1 - R
      NDIR3 = NDIR2 - R
      NDIR4 = NDIR3 - R
      GOTO (100, 200, 300, 400, 500), P
  200 CALL R2CFTK (N, M, X(1), Y(1), X(R+1), Y(R+1), DIM, NSIZE, NDIR1)
      GOTO 100
  300 CONTINUE
      CALL R3CFTK(N, M, X(1), Y(1), X(R+1), Y(R+1), X(2*R+1), Y(2*R+1)
     ., DIM, NSIZE, NDIR1, NDIR2)
      GOTO 100
  400 CALL R4CFTK (N, M, X(1), Y(1), X(R+1), Y(R+1), X(2*R+1), Y(2*R+1)
     ., X(3*R+1), Y(3*R+1), DIM, NSIZE, NDIR1, NDIR2, NDIR3)
      GOTO 100
  500 CALL R5CFTK (N, M, X(1), Y(1), X(R+1), Y(R+1), X(2*R+1), Y(2*R+1)
     ., X(3*R+1), Y(3*R+1), X(4*R+1), Y(4*R+1), DIM, NSIZE, NDIR1,
     +  NDIR2, NDIR3, NDIR4)
      GOTO 100
      END
      SUBROUTINE R2CFTK (N, M, X0, Y0, X1, Y1, DIM, NDIR0, NDIR1)
      INTEGER DIM(5), SIZE, SEP
      REAL X0(NDIR0), Y0(NDIR0), X1(NDIR1), Y1(NDIR1), IS, IU
      LOGICAL FOLD,ZERO
      DATA TWOPI / 6.2831853 /
      DATA C, S / 0.0, 0.0 /
      DATA ZEROX / 1.0E-12 /
      NT = DIM(1)
      SEP = DIM(2)
      L1 = DIM(3)
      SIZE = DIM(4) - 1
      K2 = DIM(5)
      NS = N * SEP
      M2 = M * 2
      FM2 = FLOAT(M2)
      MOVER2 = M/2 + 1
      MM2 = SEP * M2
      FJM1 = -1.0
      DO 600 J=1, MOVER2
      FOLD = J.GT.1 .AND. 2*J.LT.M+2
      K0 = (J-1)*SEP + 1
      FJM1 = FJM1 + 1.0
      ANGLE = TWOPI * FJM1 / FM2
      ZERO = ABS(ANGLE).LT.ZEROX
      IF (ZERO) GOTO 200
      C = COS(ANGLE)
      S = SIN(ANGLE)
      GOTO 200
  100 FOLD = .FALSE.
      K0 = (M+1-J)*SEP + 1
      C = -C
  200 DO 500 KK=K0,NS,MM2
      DO 440 L=KK,NT,L1
      K1 = L + SIZE
      DO 420 K=L,K1,K2
      RS = X0(K) + X1(K)
      IS = Y0(K) + Y1(K)
      RU = X0(K) - X1(K)
      IU = Y0(K) - Y1(K)
      X0(K) = RS
      Y0(K) = IS
      IF (ZERO) GOTO 300
      X1(K) = RU*C + IU*S
      Y1(K) = IU*C - RU*S
      GOTO 420
  300 X1(K) = RU
      Y1(K) = IU
  420 CONTINUE
  440 CONTINUE
  500 CONTINUE
      IF (FOLD) GOTO 100
  600 CONTINUE
      RETURN
      END
      SUBROUTINE R3CFTK (N, M, X0, Y0, X1, Y1, X2, Y2, DIM,
     +     NDIR0, NDIR1, NDIR2)
      REAL X0(NDIR0),Y0(NDIR0),X1(NDIR1),Y1(NDIR1),X2(NDIR2),Y2(NDIR2),
     +      I0,I1,I2,IA,IB,IS
      LOGICAL FOLD,ZERO
      INTEGER DIM(5), SIZE, SEP
      DATA TWOPI / 6.2831853 /
      DATA A/-0.5/, B/0.866/
      DATA C1, S1, C2, S2 / 0.0, 0.0, 0.0, 0.0 /
      DATA ZEROX / 1.0E-12 /
      NT = DIM(1)
      SEP = DIM(2)
      L1 = DIM(3)
      SIZE = DIM(4) - 1
      K2 = DIM(5)
      NS = N * SEP
      M3 = M * 3
      FM3 = FLOAT(M3)
      MM3 = SEP * M3
      MOVER2 = M/2 + 1
      FJM1 = -1.0
      DO 600 J=1, MOVER2
      FOLD = J.GT.1 .AND. 2*J.LT.M+2
      K0 = (J-1)*SEP + 1
      FJM1 = FJM1 + 1.0
      ANGLE = TWOPI * FJM1 / FM3
      ZERO = ABS(ANGLE).LT.ZEROX
      IF (ZERO) GOTO 200
      C1 = COS(ANGLE)
      S1 = SIN(ANGLE)
      C2 = C1*C1 - S1*S1
      S2 = S1*C1 + C1*S1
      GOTO 200
  100 FOLD = .FALSE.
      K0 = (M+1-J)*SEP + 1
      T = C1*A + S1*B
      S1 = C1*B - S1*A
      C1 = T
      T = C2*A - S2*B
      S2 = -C2*B - S2*A
      C2 = T
  200 DO 500 KK=K0,NS,MM3
      DO 440 L=KK,NT,L1
      K1 = L + SIZE
      DO 420 K=L,K1,K2
      R0 = X0(K)
      I0 = Y0(K)
      RS = X1(K) + X2(K)
      IS = Y1(K) + Y2(K)
      X0(K) = R0 + RS
      Y0(K) = I0 + IS
      RA = R0 + RS*A
      IA = I0 + IS*A
      RB = (X1(K)-X2(K)) * B
      IB = (Y1(K)-Y2(K)) * B
      IF (ZERO) GOTO 300
      R1 = RA + IB
      I1 = IA - RB
      R2 = RA - IB
      I2 = IA + RB
      X1(K) = R1*C1 + I1*S1
      Y1(K) = I1*C1 - R1*S1
      X2(K) = R2*C2 + I2*S2
      Y2(K) = I2*C2 - R2*S2
      GOTO 420
  300 X1(K) = RA + IB
      Y1(K) = IA - RB
      X2(K) = RA - IB
      Y2(K) = IA + RB
  420 CONTINUE
  440 CONTINUE
  500 CONTINUE
      IF (FOLD) GOTO 100
  600 CONTINUE
      RETURN
      END
      SUBROUTINE R4CFTK (N, M, X0, Y0, X1, Y1, X2, Y2, X3, Y3, DIM,
     +   NDIR0, NDIR1, NDIR2, NDIR3)
      REAL X0(NDIR0),Y0(NDIR0),X1(NDIR1),Y1(NDIR1),
     +     X2(NDIR2),Y2(NDIR2),X3(NDIR3),Y3(NDIR3)
      INTEGER DIM(5), SIZE, SEP
      LOGICAL FOLD,ZERO
      REAL I1,I2,I3,IS0,IS1,IU0,IU1
      DATA TWOPI / 6.2831853 /
      DATA C1, S1, C2, S2, C3, S3 / 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 /
      DATA ZEROX / 1.0E-12 /
      NT = DIM(1)
      SEP = DIM(2)
      L1 = DIM(3)
      SIZE = DIM(4) - 1
      K2 = DIM(5)
      NS = N * SEP
      M4 = M * 4
      FM4 = FLOAT(M4)
      MM4 = SEP * M4
      MOVER2 = M/2 + 1
      FJM1 = -1.0
      DO 600 J=1, MOVER2
      FOLD = J.GT.1 .AND. 2*J.LT.M+2
      K0 = (J-1)*SEP + 1
      FJM1 = FJM1 + 1.0
      ANGLE = TWOPI * FJM1 / FM4
      ZERO = ABS(ANGLE).LT.ZEROX
      IF (ZERO) GOTO 200
      C1 = COS(ANGLE)
      S1 = SIN(ANGLE)
      C2 = C1*C1 - S1*S1
      S2 = S1*C1 + C1*S1
      C3 = C2*C1 - S2*S1
      S3 = S2*C1 + C2*S1
      GOTO 200
  100 FOLD = .FALSE.
      K0 = (M+1-J)*SEP + 1
      T = C1
      C1 = S1
      S1 = T
      C2 = -C2
      T = C3
      C3 = -S3
      S3 = -T
  200 DO 500 KK=K0,NS,MM4
      DO 440 L=KK,NT,L1
      K1 = L + SIZE
      DO 420 K=L,K1,K2
      RS0 = X0(K) + X2(K)
      IS0 = Y0(K) + Y2(K)
      RU0 = X0(K) - X2(K)
      IU0 = Y0(K) - Y2(K)
      RS1 = X1(K) + X3(K)
      IS1 = Y1(K) + Y3(K)
      RU1 = X1(K) - X3(K)
      IU1 = Y1(K) - Y3(K)
      X0(K) = RS0 + RS1
      Y0(K) = IS0 + IS1
      IF (ZERO) GOTO 300
      R1 = RU0 + IU1
      I1 = IU0 - RU1
      R2 = RS0 - RS1
      I2 = IS0 - IS1
      R3 = RU0 - IU1
      I3 = IU0 + RU1
      X2(K) = R1*C1 + I1*S1
      Y2(K) = I1*C1 - R1*S1
      X1(K) = R2*C2 + I2*S2
      Y1(K) = I2*C2 - R2*S2
      X3(K) = R3*C3 + I3*S3
      Y3(K) = I3*C3 - R3*S3
      GOTO 420
  300 X2(K) = RU0 + IU1
      Y2(K) = IU0 - RU1
      X1(K) = RS0 - RS1
      Y1(K) = IS0 - IS1
      X3(K) = RU0 - IU1
      Y3(K) = IU0 + RU1
  420 CONTINUE
  440 CONTINUE
  500 CONTINUE
      IF (FOLD) GOTO 100
  600 CONTINUE
      RETURN
      END
      SUBROUTINE R5CFTK (N, M, X0, Y0, X1, Y1, X2, Y2, X3, Y3, X4, Y4,
     *                   DIM, NDIR0, NDIR1, NDIR2, NDIR3, NDIR4)
      REAL X0(NDIR0),Y0(NDIR0),X1(NDIR1),Y1(NDIR1),X2(NDIR2),
     +     Y2(NDIR2),X3(NDIR3),Y3(NDIR3),X4(NDIR4),Y4(NDIR4),
     +     I0,I1,I2,I3,I4,IA1,IA2,IB1,IB2,IS1,IS2,IU1,IU2
      INTEGER DIM(5), SIZE, SEP
      LOGICAL FOLD,ZERO
      DATA TWOPI / 6.2831853 /
      DATA A1/0.30902/   ,B1/0.95106/   ,A2/-0.80902/   ,B2/0.58779/
      DATA C1, S1, C2, S2, C3, S3, C4, S4 / 0.,0.,0.,0.,0.,0.,0.,0. /
      DATA ZEROX / 1.0E-12 /
      NT = DIM(1)
      SEP = DIM(2)
      L1 = DIM(3)
      SIZE = DIM(4) - 1
      K2 = DIM(5)
      NS = N * SEP
      M5 = M * 5
      FM5 = FLOAT(M5)
      MM5 = SEP*M5
      MOVER2 = M/2 + 1
      FJM1 = -1.0
      DO 600 J=1, MOVER2
      FOLD = J.GT.1 .AND. 2*J.LT.M+2
      K0 = (J-1)*SEP + 1
      FJM1 = FJM1 + 1.0
      ANGLE = TWOPI * FJM1 / FM5
      ZERO = ABS(ANGLE).LT.ZEROX
      IF (ZERO) GOTO 200
      C1 = COS(ANGLE)
      S1 = SIN(ANGLE)
      C2 = C1*C1 - S1*S1
      S2 = S1*C1 + C1*S1
      C3 = C2*C1 - S2*S1
      S3 = S2*C1 + C2*S1
      C4 = C2*C2 - S2*S2
      S4 = S2*C2 + C2*S2
      GOTO 200
  100 FOLD = .FALSE.
      K0 = (M+1-J)*SEP + 1
      T = C1*A1 + S1*B1
      S1 = C1*B1 - S1*A1
      C1 = T
      T = C2*A2 + S2*B2
      S2 = C2*B2 - S2*A2
      C2 = T
      T = C3*A2 - S3*B2
      S3 = -C3*B2 - S3*A2
      C3 = T
      T = C4*A1 - S4*B1
      S4 = -C4*B1 - S4*A1
      C4 = T
  200 DO 500 KK=K0,NS,MM5
      DO 440 L=KK,NT,L1
      K1 = L + SIZE
      DO 420 K=L,K1,K2
      R0 = X0(K)
      I0 = Y0(K)
      RS1 = X1(K) + X4(K)
      IS1 = Y1(K) + Y4(K)
      RU1 = X1(K) - X4(K)
      IU1 = Y1(K) - Y4(K)
      RS2 = X2(K) + X3(K)
      IS2 = Y2(K) + Y3(K)
      RU2 = X2(K) - X3(K)
      IU2 = Y2(K) - Y3(K)
      X0(K) = R0 + RS1+RS2
      Y0(K) = I0 + IS1+IS2
      RA1 = R0 + RS1*A1+RS2*A2
      IA1 = I0 + IS1*A1+IS2*A2
      RA2 = R0 + RS1*A2+RS2*A1
      IA2 = I0 + IS1*A2+IS2*A1
      RB1 = RU1*B1 + RU2*B2
      IB1 = IU1*B1 + IU2*B2
      RB2 = RU1*B2 - RU2*B1
      IB2 = IU1*B2 - IU2*B1
      IF (ZERO) GOTO 300
      R1 = RA1 + IB1
      I1 = IA1 - RB1
      R2 = RA2 + IB2
      I2 = IA2 - RB2
      R3 = RA2 - IB2
      I3 = IA2 + RB2
      R4 = RA1 - IB1
      I4 = IA1 + RB1
      X1(K) = R1*C1 + I1*S1
      Y1(K) = I1*C1 - R1*S1
      X2(K) = R2*C2 + I2*S2
      Y2(K) = I2*C2 - R2*S2
      X3(K) = R3*C3 + I3*S3
      Y3(K) = I3*C3 - R3*S3
      X4(K) = R4*C4 + I4*S4
      Y4(K) = I4*C4 - R4*S4
      GOTO 420
  300 X1(K) = RA1 + IB1
      Y1(K) = IA1 - RB1
      X2(K) = RA2 + IB2
      Y2(K) = IA2 - RB2
      X3(K) = RA2 - IB2
      Y3(K) = IA2 + RB2
      X4(K) = RA1 - IB1
      Y4(K) = IA1 + RB1
  420 CONTINUE
  440 CONTINUE
  500 CONTINUE
      IF (FOLD) GOTO 100
  600 CONTINUE
      RETURN
      END
      SUBROUTINE HERMFT (X, Y, NSIZE, N, DIM)
      REAL X(NSIZE), Y(NSIZE)
      INTEGER DIM(5), D2, D3, D4, D5
      DATA TWOPI / 6.2831853 /
      TWON = FLOAT(2*N)
      NT = DIM(1)
      D2 = DIM(2)
      D3 = DIM(3)
      D4 = DIM(4) - 1
      D5 = DIM(5)
      DO 100 I0=1,NT,D3
      I1 = I0 + D4
      DO 100 I=I0,I1,D5
      A = X(I)
      B = Y(I)
      X(I) = A + B
      Y(I) = A - B
  100 CONTINUE
      NOVER2 = N/2 + 1
      IF (NOVER2 .LT. 2) GOTO 500
      DO 400 I0 = 2, NOVER2
      ANGLE = TWOPI * FLOAT(I0-1) / TWON
      CO = COS(ANGLE)
      SI = SIN(ANGLE)
      K = (N + 2 - 2*I0)*D2
      K1 = (I0 - 1)*D2 + 1
      DO 300 I1=K1,NT,D3
      I2 = I1 + D4
      DO 200 I=I1,I2,D5
      J = I + K
      A = X(I) + X(J)
      B = X(I) - X(J)
      C = Y(I) + Y(J)
      D = Y(I) - Y(J)
      E = B*CO + C*SI
      F = B*SI - C*CO
      X(I) = A + F
      X(J) = A - F
      Y(I) = E + D
      Y(J) = E - D
  200 CONTINUE
  300 CONTINUE
  400 CONTINUE
      CALL CMPLFT (X, Y, NSIZE, N, DIM)
  500 RETURN
      END
      SUBROUTINE RDSECT (MAX, NNXP2, NNZ, NXZ3, LIN)
      PARAMETER (KUSER2=30000)
      COMMON /BLANK/ NR3D, DUMMY(145000)
      INTEGER*2 NR3D(KUSER2)
      IF (MAX .GE. NXZ3) MAX = 0
      MX = MAX
      MAX = MAX - 2
      DO 1320 IZ=1,NNZ
      MIN = MAX + 3
      MAX = MAX + NNXP2
      READ (LIN) IYSEC, IZLIN, IXTOT, (NR3D(IX),IX=MIN,MAX)
      NR3D(MAX+1) = NR3D(MIN)
      NR3D(MAX+2) = NR3D(MIN+1)
 1320 CONTINUE
      MIN = MAX + 3
      MAX = MAX + NNXP2 + NNXP2 + 2
      DO 1340 IX=MIN,MAX
      MX = MX + 1
      NR3D(IX) = NR3D(MX)
 1340 CONTINUE
      RETURN
      END
      SUBROUTINE SORT (X, MAXAT, NAT, N)
      DIMENSION X(4,MAXAT), T(4)
      INT=2
 1000 INT=INT+INT
      IF(INT.LT.NAT)GO TO 1000
      INT = MIN0 (NAT, (3*INT)/4-1)
 1020 INT=INT/2
      IFIN=NAT-INT
      DO 1200 II=1,IFIN
      I=II
      J=I+INT
      IF (X(N,I) .GE. X(N,J)) GOTO 1200
      DO 1060 K=1,4
      T(K) = X(K,J)
 1060 CONTINUE
 1080 DO 1100 K=1,4
      X(K,J) = X(K,I)
 1100 CONTINUE
      J=I
      I=I-INT
      IF (I) 1140, 1140, 1120
 1120 IF (X(N,I) .LT. T(N)) GOTO 1080
 1140 DO 1160 K=1,4
      X(K,J) = T(K)
 1160 CONTINUE
 1200 CONTINUE
      IF(INT.NE.1)GO TO 1020
      RETURN
      END
      FUNCTION QUAD2 (X1, X2)
      DIMENSION X1(3), X2(3)
      INCLUDE 'Zcrys.inc'
      CALL VMATV1 (X1, RRMAT, X2, DIST2)
      QUAD2 = DIST2
      RETURN
      END
      SUBROUTINE OPER1 (J, XN, XYZ)
      DIMENSION XN(3), XYZ(3)
      INCLUDE 'Zcrys.inc'
      DIMENSION FS(3,3,24)
      LOGICAL CONT
      DATA CONT / .FALSE. /
      IF (CONT) GOTO 111
      CONT = .TRUE.
      CALL KERI2F (IRSYMM, FS, 9*NSYMM)
  111 ISYM = MOD(J,NSYMM)
      IF (ISYM .EQ. 0) ISYM = NSYMM
      IP = (J-1) / NSYMM
      ILAT = MOD(IP,NLATT) + 1
      IF (IP .LT. NLATT) THEN
         DO 120 I = 1,3
  120    XN(I) = XYZ(1) * FS(I,1,ISYM)
     *         + XYZ(2) * FS(I,2,ISYM)
     *         + XYZ(3) * FS(I,3,ISYM) + TSYMM(I,ISYM) + TLATT(I,ILAT)
      ELSE
         DO 130 I = 1,3
  130    XN(I) =-XYZ(1) * FS(I,1,ISYM)
     *         - XYZ(2) * FS(I,2,ISYM)
     *         - XYZ(3) * FS(I,3,ISYM) - TSYMM(I,ISYM) + TLATT(I,ILAT)
         ENDIF
      RETURN
      END
      SUBROUTINE PHASEX
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      DATA NCALL / 0 /
      NCALL = NCALL + 1
      CALL KEPROG ('PHASEX')
      KSTAT(5) = 0
      IF (NCALL .EQ. 1)
     *   WRITE(24, FMT='(/'' The program  PHASEX  performs the'',
     *    '' DIRDIF phase expansion and ''/ '' refinement'',
     *    '' procedure by application of''/'' direct metods to'',
     *    '' difference structure factors''/)')
      CALL DIFTIN
      IPSQ = 0
      CALL DDOP
      IF (IDC .GT. 0) CALL DACOP
      IF (IDC .GT. 1) CALL DAMAIN
      IF (IDC .EQ. 1) CALL DCMAIN
      IF (IDC .GT. 0) CALL DACEND
      CALL DDTAN
      CALL KEPROX
      RETURN
      END
      SUBROUTINE DIFTIN
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zbuff.inc'
      LOGICAL SWIPRI, EXPAND
      EQUIVALENCE   (SWIPRI, SWITCH(10)), (EXPAND, SWITCH(23))
      EQUIVALENCE (IDDL,   IFILE( 1)), (ICRYS,  IFILE( 3))
      EQUIVALENCE (ICON,   IFILE( 4))
      EQUIVALENCE (IE100,  IFILE(10))
      EQUIVALENCE (IBINDU, IFILE(14))
      EQUIVALENCE (NBINDU, KEYS (14))
      INCLUDE 'Zdifta.inc'
      EQUIVALENCE (MAXHKL(1),MAXH), (MAXHKL(2),MAXK), (MAXHKL(3),MAXL)
      EQUIVALENCE (FITDUA(1), HCODE), (FITDUA(2), E1), (FITDUA(3), E2),
     *            (FITDUA(5), P1),    (FITDUA(6), P2), (FITDUA(7), W1)
      DIMENSION KARR(100), MAXHC(3), IHKL(3), HKL(3)
      PARAMETER (LCMAX = 8)
      CHARACTER LCONDA(LCMAX) *6
      DATA LCONDA / 'PHASEX', 'NCEST', 'ACCEPT', 'LOCCEN', 'STLMAX',
     *              'MAXHKL', 'DIRP1', 'PRINT' /
      DATA K, IBIG, NN / 0, 0, 0/
      CALL WR24
      NITDUA = 7
      EMIN  = 0.9
      MAXREF = 2047
      CALL KERNZI (0,  MAXHKL, 3)
      CALL KERNZA (0.,     TO, 3)
      CALL KERNZA (0., ESTART, 5)
      CALL KERNZA (0.,   E2AG, 7)
      CALL KERNZA (0.,   E2CG, 7)
      DO 190 I=1,ISIZ
  190 ITAB(I) = 0
      WRITE (8, 200) ISIZ
  200 FORMAT (/' Available storage: ', I6)
      NC =  0
      E2AGE = 0.0
      E2CGE = 0.0
      NR  = 0
      IDC = 0
      QEET = 0.8
      MAXT = 60
      CALL KERNZI (0, MAXHC,  3)
      CALL RDCRYS (ICRYS)
      KEYS(19) = ICENT
  210 CALL RDCOND (ICON, LCONDA, LCMAX, KEND)
      GOTO (210, 211, 212, 213, 214, 215, 216, 217) KEND
      IF (KEND .EQ. 0) GOTO 260
      CALL KERROR ('Error reading CONDA file', 0, 'DIFTIN')
  211 IF (NFNUM .NE. 6) CALL KERNER (211, 'DIFTIN')
      NC = IFIX(FNUM(1))
      IF (NC .GT. 5) NC = 5
      CALL KERNAB (FNUM(2), ESTART, 5)
      GOTO 210
  212 IF (NFNUM .NE. 2) CALL KERNER (212, 'DIFTIN')
      QEET = FNUM(1)
      IF (QEET .LT. 0.5) QEET = 0.5
      MAXT = IFIX(FNUM(2))
      IF (MAXT .LT. 10)  MAXT = 60
      GOTO 210
  213 IF (NFNUM .NE. 3) CALL KERNER (213, 'DIFTIN')
      CALL KERNAB (FNUM, TO, 3)
      IDC = 1
      GOTO 210
  214 IF (NFNUM .NE. 1) CALL KERNER (214, 'DIFTIN')
      STLMAX = FNUM(1)
      GOTO 210
  215 IF (NFNUM .NE. 3) CALL KERNER (215, 'DIFTIN')
      CALL KERF2I (FNUM, MAXHC, 3)
      GOTO 210
  216 EXPAND = .TRUE.
      GOTO 210
  217 SWIPRI = .TRUE.
      GOTO 210
  260 CALL FILINQ (IE100, 'E100', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .NE. 0) CALL KERROR ('No E100 file found', 0, 'DIFTIN')
      CALL KERINA (IE100, LIT, 1, LEND)
      IF (LIT(1).NE.'E100' .OR. LIT(2).NE.CCODE) CALL KERROR
     *   ('Error reading E100 file', 0, 'DIFTIN')
      NGN = IFIX(FNUM(1))
      NSP = IFIX(FNUM(2))
      E2ALE = FNUM(3)
      E2CLE = FNUM(4)
      CALL LOGRD (IDDL, 'PHASEX', KLOG)
      CALL FILCLO (IDDL, 'KEEP')
      IF (KLOG.LE.0 .OR. LIT(5).NE.'MHKL' .OR. LIT(6).NE.'NREFL1')
     *    CALL KERROR ('Error reading DDLOG file', 0, 'DIFTIN')
      CALL KERF2I (FNUM(4), MAXHKL, 3)
      NR = IFIX(FNUM(7))
      IF (MAXHKL(1).EQ.0 .AND. MAXHKL(2).EQ.0 .AND. MAXHKL(3).EQ.0)
     *    CALL KERROR ('No MAXHKL given on DDLOG file', 0, 'DIFTIN')
      IF (NR .EQ. 0)
     *    CALL KERROR ('No NREFL1 given on DDLOG file', 0, 'DIFTIN')
      IF (NGN.EQ.0 .AND. NSP.EQ.0)
     *    CALL KERROR ('No NGN or NSP given on E100 file', 0, 'DIFTIN')
      IF (E2ALE.LT.0.01 .AND. E2CLE.LT.0.01) CALL KERROR
     *           ('No E2ACLE or E2CLE given on E100 file', 0, 'DIFTIN')
      DO 265 I=1,3
  265 IF (MAXHC(I) .GT. 0) MAXHKL(I) = MIN0(MAXHKL(I), MAXHC(I))
      KORIS = 0
      IICENT = ICENT
      IF (EXPAND) IICENT = 1
      IF (IDC .EQ. 0) CALL LOCCEN (IDC, TO)
      IF (IDC .GT. 0) THEN
         KORIS = 1
         IDC = 1
         ENDIF
      IF (IDC .EQ. 0) GOTO 310
      IF (IICENT .EQ. 1) GOTO 280
      WRITE (8, 270)
  270 FORMAT (' Input LOCCEN ignored' /)
      IDC = 0
      KORIS = 0
      GOTO 310
  280 WRITE(24, 285)
      WRITE (8, 285)
  285 FORMAT (/ ' ***** Enantiomorph fixation *****' /)
      IF (ABS(TO(1)).LT..001 .AND. ABS(TO(2)).LT..001 .AND.
     *   ABS(TO(3)).LT..001) THEN
         KORIS = 0
         GOTO 310
         ENDIF
      WRITE(24, 290) TO
      WRITE (8, 290) TO
  290 FORMAT (' The origin is shifted over a vector (',3(F6.3,','),')')
      WRITE (8, 300)
  300 FORMAT(' All phases printed by PHASEX are in agreement with the',
     *       ' new origin', / ' phases on the final output file are',
     *       ' set back to the original origin')
      CALL PSEUDO (TO)
  310 CALL BINIFF (1, IBINDU, 'BINDUA', FITDUA, NITDUA, BUFDUA, KENDUA)
      WRITE (8, FMT='('' Input atoms resulted in R2 ='',F6.3)') R2X
      IF (PSQ .GT. 0.99) CALL KERROR ('PSQ too big...', 310, 'DIFTIN')
      IF (NC .GT. 0) GOTO 320
      IF (IDC .EQ. 1) NC = 2
      NC = 3
      IF (NR .LT. 200) NC = 2
  320 IDC3 = IDC + 1
      IF (ESTART(1) .GT. 0.1) GOTO 340
      XX = 1.3
      IF (IICENT .EQ. 2) XX = 1.5
      DO 330 I=1,NC
  330 ESTART(I) = XX - 0.1*(I/2)
  340 WRITE (8, 350) EMIN, NC, (ESTART(I), I=1,NC)
  350 FORMAT (/ ' Start    E1min = ', F4.2, '       Tangent formula:' /
     *        29X, 'minimum Er for', I2, ' cycles :   ', 5F5.2)
      IF (IDC .NE. 1) GOTO 370
      ESTART(1) = ESTART(1) - 0.1
      ESTAR1 = ESTART(1)
      WRITE (8, 360) ESTAR1
  360 FORMAT (26X, 'Min E1 for cycle zero (with symbols): ', F4.2)
  370 WRITE (8, FMT='('' MAXHKL:'', 3I4)') MAXHKL
      MCTMAX = 32767
      I34 = 1
      I35 = 1
      MCTLAT = 1
      FR = 1.
      M = 0
      MS = 1
      CALL KERNAI (MAXHKL, IHKL, 3)
  380 GOTO (410, 400, 390), I35
  390 IF (MOD(MAXL,3) .GT. 0) MAXL = MAXL + 3 - MOD(MAXL,3)
      GOTO 410
  400 MAXL = MAXL + MOD(MAXL,2)
  410 MCK = 2*MAXL/I35 + 1
      IF (I34 .EQ. 2) MAXK = MAXK + MOD(MAXK,2)
      MCH = MCK * (2*MAXK/I34+1)
      MCT = MCH*MAXH + MCK*MAXK/I34 + MAXL/I35
      IF (MCT .LE. MCTMAX) GOTO 470
      GOTO (420, 430, 430, 460), MS
  420 MS = 2
      IF (MCT .LE. 5*MCTMAX/4) GOTO 430
      IF (ILATT.EQ.1) GOTO 430
      MCTLAT = ILATT
      IF (ILATT.EQ.6 .AND. MCT.LE.7*MCTMAX/3) MCTLAT = 3
      IF (MCTLAT.EQ.6 .OR. MCTLAT.EQ.4) I34 = 2
      IF (MCTLAT .NE. 4) I35 = 2
      IF (MCTLAT .EQ. 7) I35 = 3
      GOTO 380
  430 M = 1
      FR = FR * ( (FLOAT(MCT)/MCTMAX - 1.)/3. + 1. )
      DO 450 N=1,3
  450 MAXHKL(N) = IHKL(N)/FR + 1.
      IF (MS .LT. 4) MS = MS + 1
      GOTO 380
  460 FR = FR * 1.02
      GOTO 430
  470 IF (M .GT. 0) WRITE (8, 480) MAXHKL
  480 FORMAT (' Storage too small; new MAXHKL: ', 3I3)
      WRITE (8, 500) MCH, MCK, I34, I35, MCT
  500 FORMAT (' Packed indices are', I14, '*H + ', I4, '*K/', I1,
     *   ' + L/', I1, /, ' Dimension of address table is', I22)
      I34 = MAXK / I34
      I35 = MAXL / I35
      KK = 0
      ICR = 9
      NTAL = ISIZ - ICR
      MAXRE = (ISIZ-MCT) / 10
      IF (MAXRE .GT. MAXREF-5) MAXRE = MAXREF - 5
      WRITE (8, 503) MAXRE
  503 FORMAT (' Dimension of reflection table is', I19)
      EMINO = EMIN
      EMAX = EMIN + 0.9
      CALL VALDIS (-1, EMIN, EMAX, KARR, 100, NREFDI)
      MMS = 1
      NCOUNT = 500
      NBINDU = 0
  510 CALL BINIFF (0, IBINDU, 'BINDUA', FITDUA, NITDUA, BUFDUA, KENDUA)
      IF (KENDUA .LT. 0) GOTO 580
      NBINDU = NBINDU + 1
      CALL HKLC1U (HCODE, HKL)
      CALL HKLSTL (HKL, STL, STL2)
      IT = 1
      IF (.NOT. EXPAND) IT = IPHFIX (HKL)
      ITP = IT - 1
      EEX = E2EXP (ITP, E1, E2)
      CALL KERF2I (HKL, IHKL, 3)
      IF (MAXH.LT.IABS(IHKL(1)) .OR. MAXK.LT.IABS(IHKL(2)) .OR.
     *    MAXL.LT.IABS(IHKL(3)) .OR. E1.LT.EMIN .OR.
     *    STL.GT.STLMAX) GOTO 570
      ITAB(NCOUNT+1) = IHKL(1)
      ITAB(NCOUNT+2) = IHKL(2)
      ITAB(NCOUNT+3) = IHKL(3)
      ITAB(NCOUNT+4) = NINT (100.*E1)
      ITAB(NCOUNT+5) = NINT (100.*E2)
      IF (ABS(P1-P2) .LT. 5.) ITAB(NCOUNT+5) = -ITAB(NCOUNT+5)
      IF (KORIS .EQ. 1) CALL ORSHIF (HKL, TO, P1, P2, 0., KORIS)
      ITAB(NCOUNT+6) = NINT (P1)
      IF (ITAB(NCOUNT+6) .GE. 360) ITAB(NCOUNT+6) = ITAB(NCOUNT+6) - 360
      ITAB(NCOUNT+7) = NINT (1000.*W1)
      ITAB(NCOUNT+8) = IT
      ITAB(NCOUNT+9) = NINT (100.*EEX)
      CALL VALDIS (0, E1, 0., KARR, 100, NREFDI)
      NCOUNT = NCOUNT + ICR
      IF (NCOUNT .LT. NTAL-ICR) GOTO 510
      CALL VALDIS (MAXRE, EMIN, 0., KARR, 100, NREFDI)
      WRITE (8, 520) EMIN
  520 FORMAT (' Too many refl.; new E1min =', F5.2)
      IF (EMIN .GT. EMAX) THEN
         WRITE(24, 522) EMAX-1., EMAX-0.99, EMAX-0.98, EMAX-0.97,
     *      (KARR(I), I= 1,100)
         WRITE (8, 522) EMAX-1., EMAX-0.99, EMAX-0.98, EMAX-0.97,
     *      (KARR(I), I= 1,100)
  522    FORMAT (' Expected scaling error: distribution of E1 values:'/
     *      3X, 4F5.2, '  ....'/ (5X, 12I5) )
         EMIN = EMAX
         WRITE (8, 524) EMIN
  524    FORMAT (' Reset: ........ new E1min =', F5.2)
         IF (EMIN .GT. EMINO + 1.0) WRITE (24,*)
     *      'Too many tryals: scaling error!: see what happens.'
         ENDIF
      EMAX = EMIN + 0.9
      CALL VALDIS (-1, EMIN, EMAX, KARR, 100, NREFDI)
      KK = NCOUNT
      NCOUNT  = 500
      K  = 500
      MMS = 2
  530 E1 = ITAB(K+4) / 100.
      IF (E1 .GE. EMIN) GOTO 540
      EEX = ITAB(K+9) / 100.
      IT = ITAB(K+8)
      K = K + ICR
      GOTO 570
  540 DO 550 I=1,9
      K = K + 1
      NCOUNT = NCOUNT + 1
  550 ITAB(NCOUNT) = ITAB(K)
      CALL VALDIS (0, E1, 0., KARR, 100, NREFDI)
  560 IF (K .LT. KK) GOTO 530
      MMS = 1
      GOTO 510
  570 IF (IT .EQ. 1) E2ALE = E2ALE + EEX
      IF (IT .GT. 1) E2CLE = E2CLE + EEX
      GOTO (510, 560, 660), MMS
  580 CONTINUE
      WRITE (8, 581) NBINDU
  581 FORMAT (' Number of reflections input from file BINDUA:', I6)
      IF (NREFDI .LT. MAXRE+5) GOTO 600
      CALL VALDIS (MAXRE, EMIN, 0., KARR, 100, NREFDI)
      WRITE (8, 520) EMIN
      MAXRE = (ISIZ - NCOUNT) / 8   - 5
      MAXRE = MIN0 (MAXRE, MAXREF)
  600 KK = NCOUNT
      IF (MCT .GT. NCOUNT) NCOUNT = MCT
      IBIG = NCOUNT
      NN = NCOUNT + 8*(MAXRE+5)
      K = 500
      MMS = 3
  610 E1  = ITAB(K+4) / 100.
      EEX = ITAB(K+9) / 100.
      IT  = ITAB(K+8)
      IF (E1 .GE. EMIN) GOTO 620
      K = K + ICR
      GOTO 570
  620 IF (IT.GT.1) GOTO 630
      E2AGE = E2AGE + EEX
      E2AG(1) = E2AG(1) + E1*E1
      GOTO 640
  630 E2CGE = E2CGE + EEX
      E2CG(1) = E2CG(1) + E1*E1
  640 DO 650 I=1,8
      K = K + 1
      NCOUNT = NCOUNT + 1
  650 ITAB(NCOUNT) = ITAB(K)
      K = K + 1
  660 IF (K.LT.KK .AND. NCOUNT.LT.NN) GOTO 610
      IF (IBIG .EQ. MCT) GOTO 680
      KK = NCOUNT
      NCOUNT = MCT
      K = IBIG + 1
      DO 670 I=K,KK
      NCOUNT = NCOUNT + 1
  670 ITAB(NCOUNT) = ITAB(I)
  680 NCT = NCOUNT - 8
      ICR = 8
      RETURN
      END
      SUBROUTINE DDOP
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zbuff.inc'
      LOGICAL SWIPRI, EXPAND
      EQUIVALENCE   (SWIPRI, SWITCH(10)), (EXPAND, SWITCH(23))
      EQUIVALENCE (IBINDO, IFILE(13))
      INCLUDE 'Zdifta.inc'
      COMMON /SINCOS/ IDEG(8), ISCT
      INTEGER*2 ISCT(450)
      COMMON /KLAD/ ICODE(4,48), ISHIFT(48)
      DIMENSION IPG1(8), KARR(100), IHKL(3)
      DIMENSION FKLAD(100)
      CHARACTER LITOUT *25
      CHARACTER LETT(5) *2
      DATA LETT / '. ', 'S ', 'R ', 'SR', 'C ' /
      CALL WR24
      CALL BINOFF (1, IBINDO, 'BINDOP', FITDOP, NITDOP, BUFDOP, KENDOP)
      EWMIN = ESTART(1) * 0.16 - 0.01
      CALL VALDIS (-1, 0.03, 2. , KARR, 80, MST)
      MR = (NCT-MCT)/ICR + 1
      MSMAX = MIN0 (400, (ISIZ - NCT + MR) / 12)
      WRITE (8, 200) MR
  200 FORMAT (' Number of reflections to be refined: ', I6)
      NR = MR
      NLINPR = 0
      IF (.NOT. SWIPRI) GOTO 240
      WRITE (8, 210)
  210 FORMAT (/' Reflection table (max. 300 refl. printed)', /,
     *        ' R = restricted phase (Fp .gt. Fobs)')
      IF (IICENT .EQ. 1) WRITE (8, 220)
  220 FORMAT (' S = special reflection (two possible phase values)')
      WRITE (8, 230)
  230 FORMAT ( /' ', 5('  H  K  L  E1   P1   W1  ') /)
      CHOUT = '(5A25)'
      CALL LINPRX (8, LITOUT, 25, 5)
  240 MS = 0
      NWZ = 0
      DO 260 K=MCT,NCT,ICR
      IHKL(1) = ITAB(K+1)
      IHKL(2) = ITAB(K+2)
      IHKL(3) = ITAB(K+3)
      E1      = ITAB(K+4)/100.
      E2      = ABS(ITAB(K+5)/100.)
      P1      = ITAB(K+6)
      W1      = ITAB(K+7)/1000.
      IF (W1 .LT. 0.01) NWZ = NWZ + 1
      IT      = ITAB(K+8)
      PHREST  = 180.
      IF (ITAB(K+5) .LT. 0) PHREST = 57.296 *
     *                    ASIN ((E2-E1) / (E2+E1))
      EW = E1 * W1
      IF (EW .GE. 0.03) CALL VALDIS (0, EW, 0., KARR, 80, MST)
      IF (E1.LT.ESTART(1) .OR. W1.LT.0.16) GOTO 250
      EW = EW + 10.
      MS = MS + 1
  250 LET = 0
      IF (IICENT .NE. 1) LET = -1
      IF (IT .NE. 1) LET = LET + 2
      IF (ITAB(K+5) .LT. 0) LET = LET + 2
      CALL KERI2F (IHKL, FITDOP(1), 3)
      FITDOP(4) = E1
      FITDOP(5) = E2
      FITDOP(6) = P1
      FITDOP(7) = W1
      FITDOP(8) = FLOAT(IT)
      FITDOP(9) = PHREST
      CALL BINOFF (0, IBINDO, 'BINDOP', FITDOP, NITDOP, BUFDOP, KENDOP)
      IF (SWIPRI .AND. NLINPR.LT.300) THEN
         NLINPR = NLINPR + 1
         IP1 = NINT(P1)
         LET = MAX0 (1, LET)
         WRITE (LITOUT, FMT='(1X, 3I3, F5.2, I4, A2, F4.2)')
     *                        IHKL, E1, IP1, LETT(LET), W1
         CALL LINPRX (0, LITOUT, 25, 5)
      ENDIF
      ITAB(K+5) = EW*1000. + .5
  260 CONTINUE
      IF (SWIPRI) CALL LINPRX (-1, LITOUT, 25, 5)
      CALL BINOFF (-1,IBINDO, 'BINDOP', FITDOP, NITDOP, BUFDOP, KENDOP)
      IF (MS.LE.MSMAX .AND. MS.GE.MSMAX/4) GOTO 280
      MSMAXT = MSMAX
      IF (MS .LE. MSMAX) MSMAXT = MSMAX / 4
      CALL VALDIS (MSMAXT, EW, 0., KARR, 80, MST)
      WRITE (8, 270) EW
  270 FORMAT (/' New starting set limitations;' /
     *        '     minimum E1 * W1 is: ', F6.3)
      EWMIN = EW - 0.001
      MST = 0
  280 CONTINUE
      NCOUNT = MCT
      MS = 0
      DO 290 K=MCT,NCT,ICR
      ITAB(NCOUNT+1) = ITAB(K+1)
      ITAB(NCOUNT+2) = ITAB(K+2)
      ITAB(NCOUNT+3) = ITAB(K+3)
      ITAB(NCOUNT+4) = ITAB(K+4)
      EW = ITAB(K+5) / 1000.
      ITAB(NCOUNT+5) = ITAB(K+8)
      ITAB(NCOUNT+6) = ITAB(K+6)
      ITAB(NCOUNT+7) = ITAB(K+7)
      IF (MST.GT.0 .AND. EW.LT.10.) GOTO 290
      IF (MST.EQ.0 .AND. EW.GT.10.) EW = EW - 10.
      IF (EW .LT. EWMIN) GOTO 290
      ITAB(NCOUNT+5) = -ITAB(NCOUNT+5)
      MS = MS + 1
  290 NCOUNT = NCOUNT + 7
      ICR = 7
      NCT = NCOUNT - ICR
      INCA4 = 4
      MARKA4 = NCOUNT - INCA4
      MAXA4 = ISIZ - INCA4
      ISTO4 = MARKA4
      MSMAX = MIN0 (MS, MSMAX+10)
      WRITE (8, 300) MSMAX
  300 FORMAT (' Number of reflections in starting set: ', I4)
      IF (.NOT. SWIPRI) GOTO 320
      WRITE (8, FMT='(/'' Starting set (max. 200 refl. printed)'')')
      NLINPR = 0
      WRITE (8, 230)
  320 DO 330 I=1,MCT
  330 ITAB(I) = 0
      CALL KERNZI (0, IPG1, 8)
      CALL KERNZI (0, IPG2, 8)
      IILAUE = ILAUE
      IF (EXPAND) ILAUE = 1
      LET = 1
      MS = 0
      MR = 0
      MITAB = 0
      E1MIN = 0.9
      E1MAX = 3.0
      CALL VALDIS (-1, E1MIN, E1MAX, KARR, 100, NRE1)
      DO 370 NCOUNT=MCT,NCT,ICR
      MR = MR + 1
      IHKL(1) = ITAB(NCOUNT+1)
      IHKL(2) = ITAB(NCOUNT+2)
      IHKL(3) = ITAB(NCOUNT+3)
      W1      = ITAB(NCOUNT+7) / 1000.
      ITAB(NCOUNT+1) = INPACK(IHKL)
      ITAB(NCOUNT+2) = W1 * ITAB(NCOUNT+4) +.5
      ITAB(NCOUNT+3) = ITAB(NCOUNT+6)
      ITAB(NCOUNT+7) = ITAB(NCOUNT+4)
      E1 = ITAB(NCOUNT+4) / 100.
      CALL VALDIS (0, E1, 0., KARR, 100, NRE1)
      I = IGROUP (IHKL)
      IPG2(I) = IPG2(I) + 1
      IP1 = ITAB(NCOUNT+6)
      IF (ITAB(NCOUNT+5) .GT. 0) GOTO 340
      IF (MS .GE. MSMAX) GOTO 350
      IF (SWIPRI .AND. NLINPR.LT.200) THEN
         NLINPR = NLINPR + 1
         WRITE (LITOUT, FMT='(1X, 3I3, F5.2, I4, A2, F4.2)')
     *                        IHKL, E1, IP1, LETT(LET), W1
         CALL LINPRX (0, LITOUT, 25, 5)
      ENDIF
      CALL IITAB4 (IHKL, NCOUNT)
      IPG1(I) = IPG1(I) + 1
      ITAB(NCOUNT+2) = -ITAB(NCOUNT+2)
      MS = MS + 1
      GOTO 350
  340 ITAB(NCOUNT+5) = -ITAB(NCOUNT+5)
  350 ITAB(NCOUNT+6) = I
      NE = 1
      CALL SYMEQ (IHKL, NE)
      ITAB(NCOUNT+4) = NE
      DO 360 I=1,NE
      IADR = ICODE(4,I)
      ISIG = ISIGN(1,IADR)
      IADR = IABS(IADR)
      JSI  = ISHIFT(I) - 1
      ITAB(IADR) = ISIG*(4096*JSI+MR)
      MITAB = MITAB + 1
  360 CONTINUE
  370 CONTINUE
      ILAUE = IILAUE
      IF (SWIPRI) CALL LINPRX (-1, LITOUT, 25, 5)
      WRITE (8, 400) IPG1, IPG2
  400 FORMAT(/' Distribution of reflections in parity groups or equiva',
     *       'lent.', /, ' Group 1 is the seminvariant group', /
     *        16X, '    1    2    3    4    5    6    7    8', /
     *        16X, '   ggg  ugg  gug  uug  ggu  ugu  guu  uuu', /
     *       ' in starting set ', 8I5, /, ' in entire table ', 8I5)
      NPG1 = 0
      NPG2 = 0
      ISIG = 1
      IF (MS .LT. 20) ISIG = 0
      DO 410 IPG=1,8
      IF (IPG2(IPG) .GT. ISIG) NPG2 = NPG2 + 1
      IPG2(IPG) = 0
      IF (IPG1(IPG).LE.ISIG) GOTO 410
      IPG2(IPG) = -1
      NPG1 = NPG1 + 1
  410 CONTINUE
      IF (FLOAT(NPG2)/NPG1 .GT. 1.65) IDC = IDC + 2*IICENT
      NWZ = 100 * NWZ / MR
      IF (IDC.LE.1 .AND. NWZ.GT.40) IDC = IDC + 2*IICENT
      PSQMAX = 0.15
      IF (IPSQ .LT. 0) PSQMAX = 0.0
      IF (IDC.EQ.0 .AND. PSQ.LT.PSQMAX) THEN
         IDC = IICENT*2
         IPSQ = 1
         MAXE1 = MIN0 (NRE1, 1000)
      ENDIF
      IF (IPSQ .EQ. 0) GOTO 470
      MAXE5 = MIN0 (500, NRE1)
      CALL VALDIS (MAXE5, E500, 0., KARR, 100, NRE1)
      MAXE1 = MIN0 (1000, NRE1)
      CALL VALDIS (MAXE1, E1000, 0., KARR, 100, NRE1)
      WRITE (8, 420) NRE1, MAXE5, E500, MAXE1, E1000, E1MAX
  420 FORMAT (' Total number of refl.:           ', I5, /,
     *        ' E1min for', I5, ' strongest refl.:  ', F5.3, /
     *        ' E1min for', I5, ' strongest refl.:  ', F5.3, /
     *        ' E1max:                           ', F5.3)
      VINC = (E1MAX - E1MIN) / 98.
      VSUB = E1MIN - 2.*VINC
      WRITE (8, FMT='(/'' Distribution of E1:''/)')
      DO 425 I= 1, 96, 12
      DO 422 LUTZ = I , I+11
      FKLAD(LUTZ) = VSUB + VINC * FLOAT (LUTZ)
  422 CONTINUE
      WRITE (8, FMT='('' E1 '', 12F5.2)') (FKLAD(J), J=I,I+11)
  425 WRITE (8, FMT='('' NR'', 12I5/)') (KARR(J), J=I,I+11)
      CALL VALDIS (MAXE1, E1MIN, 0., KARR, 100, NRE1)
      WRITE (8, FMT='('' E1min for FOMs for '', I5,
     *                   '' strongest refl.: '', F5.3)') MAXE1, E1MIN
      I100 = MIN0 (MAXE1, 100)
      CALL VALDIS (I100, E1100, 0., KARR, 100, NRE1)
      WRITE (8, FMT='('' E1min for FOMs for '', I5,
     *                   '' strongest refl.: '', F5.3)') I100, E1100
  470 CONTINUE
      IF (IDC .GT. 1) GOTO 490
      DO 480 NCOUNT=MCT,NCT,ICR
      ITAB(NCOUNT+4) = 0
      ITAB(NCOUNT+5) = 0
      ITAB(NCOUNT+6) = 0
  480 IF (ITAB(NCOUNT+2).LT.0) ITAB(NCOUNT+2) = -ITAB(NCOUNT+2)
  490 E2AGE   = (E2AGE   + E2ALE)/(MAX0(1,NGN))
      E2CGE   = (E2CGE   + E2CLE)/(MAX0(1,NSP))
      E2AG(1) = (E2AG(1) + E2ALE)/(MAX0(1,NGN))
      E2CG(1) = (E2CG(1) + E2CLE)/(MAX0(1,NSP))
      CALL DD38
      IF (IDC.LE.1 .OR. IPSQ.EQ.1) RETURN
      WRITE(24, 500)
      WRITE (8, 500)
  500 FORMAT (/, ' ***** Origin fixation *****', /)
      RETURN
      END
      SUBROUTINE DDTAN
      INCLUDE 'Zaaaa.inc'
      LOGICAL SWIPRI
      EQUIVALENCE   (SWIPRI, SWITCH(10))
      EQUIVALENCE (IBINDI, IFILE(15)), (IBINDO, IFILE(13))
      EQUIVALENCE (NBINDU, KEYS(14))
      EQUIVALENCE (ICENT, KEYS(19))
      INCLUDE 'Zdifta.inc'
      INCLUDE 'Zbuff.inc'
      EQUIVALENCE (FITDIF(1), HCODE), (FITDIF(2), EL), (FITDIF(3), PL),
     *            (FITDIF(4), WL)
      DIMENSION IHKL(3), HKL(3), E2TOT(7)
      CHARACTER LITOUT *25
      CHARACTER LETT(5) *2
      DATA LETT / '. ', '* ', 'R ', '*R', 'C ' /
      DATA NLINPR / 0 /
      CALL WR24
      WRITE(24, FMT='(/'' Tangent refinement:''/)')
      call wr24
      NC = NC + 1
      DO 200 ICYC=2,NC
      CALL GENER
      CALL STARTS (ICYC)
      E2AG(ICYC) = (E2AG(ICYC) + E2ALE) / (MAX0(1,NGN))
  200 E2CG(ICYC) = (E2CG(ICYC) + E2CLE) / (MAX0(1,NSP))
      CALL FILCLO (IBINDO, 'DELETE')
      CALL BINOFF (1, IBINDI, 'BINDIF', FITDIF, NITDIF, BUFDIF, KENDIF)
      NBINDI = 0
      IF (KORIS .NE. 1) GOTO 220
      DO 210 I=1,3
  210 TO(I) = -TO(I)
      KORIS = 2
      CALL PSEUDO (TO)
  220 IF (SWIPRI) THEN
         WRITE (8, 230)
  230 FORMAT (/ ' The following table gives the final result of the',
     *           ' program PHASEX.', /,
     *     ' The reflections are marked (max. 300 refl. printed):' /
     *     '  *  =  refl. with total phase shift of 90 degrees or more',
     *    /'  R  =  refl. with WS.lt.0.9 (unreliable)', /,
     *      ' ', 5('  H  K  L  EL   PL   WL  ') /)
         NLINPR = 0
         CHOUT = '(5A25)'
         CALL LINPRX (8, LITOUT, 25, 5)
      ENDIF
      IPMIN = 0
      NPMIN = 0
      NCOUNT = MCT - ICR
  240 NCOUNT = NCOUNT + ICR
      IPACK = ITAB(NCOUNT+1)
      CALL XUNPAK (IPACK, IHKL)
      CALL KERI2F (IHKL, HKL, 3)
      LET = 1
      IP1 = ITAB(NCOUNT+4)
      IPS = ITAB(NCOUNT+3)
      EL  = ITAB(NCOUNT+7)/100.
      WS  = ABS (ITAB(NCOUNT+2) * 0.01/EL)
      IF (WS .GT. 1.0) WS = 1.0
      PL = IPS
      IF (IDC .NE. 1) GOTO 260
      PL  = PL / 57.29
      AEL = EL * COS(PL)
      BEL = EL * SIN(PL) * 2.00
      EL  = SQRT(AEL**2 + BEL**2)
      PL  = ATAN2(BEL,AEL) * 57.29
      IF (PL .LT. 0.) PL = PL + 360.
  260 WL = WS
      IF (KORIS .EQ. 2) CALL ORSHIF (HKL, TO, 0., 0., PL, KORIS)
      IF (WS .LT. 0.9) LET = 3
      IF (ITAB(NCOUNT+5) .GE. 0) GOTO 270
      LET = 5
      GOTO 280
  270 IDIF = IABS(IPS-IP1)
      IDIF = MIN0(IDIF, 360-IDIF)
      IF (IDIF .GT. 89) LET = LET + 1
  280 IPS = INT(PL)
      IPMIN = IPMIN + MIN0(IABS(IPS), IABS(IABS(IPS)-180))
      NPMIN = NPMIN + 1
      NBINDI = NBINDI + 1
      CALL HKLC1 (HKL, HCODE)
      CALL BINOFF (0, IBINDI, 'BINDIF', FITDIF, NITDIF, BUFDIF, KENDIF)
      IF (.NOT. SWIPRI) GOTO 290
      IF (SWIPRI .AND. NLINPR.LT.300) THEN
         NLINPR = NLINPR + 1
         WRITE (LITOUT, FMT='(1X, 3I3, F5.2, I4, A2, F4.2)')
     *                        IHKL, EL, IPS, LETT(LET), WL
         CALL LINPRX (0, LITOUT, 25, 5)
         ENDIF
  290 IF (NCOUNT .LT. NCT) GOTO 240
      CALL BINOFF (-1, IBINDI, 'BINDIF', FITDIF, NITDIF, BUFDIF, KENDIF)
      IF (SWIPRI) CALL LINPRX (-1, LITOUT, 25, 5)
      call wr24
      WRITE (8, 291) NBINDI
  291 FORMAT (' Number of reflections output to  file BINDIF:', I6)
      IPMIN = IPMIN / NPMIN
      IF (ICENT .EQ. 1) WRITE(8, FMT = '(/
     * '' Average deviation from 0 degrees (or 180 degrees)'' /
     * '' for phases used in PHASEX '', I3  , '' degrees '')')  IPMIN
      NBINDI = NBINDU - NBINDI
      IF (NBINDI .NE. 0) WRITE (8, 292) NBINDI
  292 FORMAT (' Number of reflections skipped by PHASEX:     ', I6)
      IF (KORIS .EQ. 2) write(24, 310)
      IF (KORIS .EQ. 2) WRITE (8, 310)
  310 FORMAT (' ----- Origin shifted back ----'/)
      NTOT  = NGN + NSP
      ANGN  = FLOAT (MAX0(1,NGN))
      ANSP  = FLOAT (MAX0(1,NSP))
      ANTOT = FLOAT (NTOT)
      E2TOTE = (E2AGE*ANGN + E2CGE*ANSP) / ANTOT
      DO 320 I=1,7
  320 E2TOT(I) = (E2AG(I)*ANGN + E2CG(I)*ANSP) / ANTOT
      IF (IDC .EQ. 0) THEN
          write(24, 330) E2TOTE, (I, E2TOT(I), I=1,NC-1)
  330 FORMAT(' Values for average E**2', /
     *       ' a priori expectation values   ', F8.3, /,
     *      (' calculated before cycle', I5, 6X, F13.3))
          WRITE (8, 335) NTOT, E2TOTE, (I, E2TOT(I), I=1,NC-1)
  335 FORMAT(' Values for average E**2 for all (', I5, ') reflections'/
     *       ' a priori expectation values   ', F7.3, /,
     *      (' calculated before cycle', I5, 6X, F13.3))
          IF (IICENT .EQ. 1)
     *    WRITE (8, 340) NGN, NSP, E2AGE, E2CGE,
     *                    (I, E2AG(I), E2CG(I), I=1,NC-1)
  340 FORMAT(' Values for average E**2 for', I5, ' general refl. and',
     *   I4, ' special refl.:' /
     *       ' a priori expectation values   ', F7.3, 19X, F5.3 /
     *      (' calculated before cycle', I5, 6X, F13.3, 12X, F12.3))
        ELSE
          write(24, 350) E2TOTE, E2TOT(1), E2TOT(7),
     *                     (I, E2TOT(I), I=2,NC-1)
  350 FORMAT(' Values for average E**2' /
     *       ' a priori expectation values   ', F7.3 /
     *       ' calculated at start    ',    11X, F13.3 /
     *       ' calculated after symbols',   10X, F13.3 /
     *      (' calculated before cycle', I5, 6X, F13.3))
          WRITE (8, 355) NTOT, E2TOTE, E2TOT(1), E2TOT(7),
     *                     (I, E2TOT(I), I=2,NC-1)
  355 FORMAT(/' Values for average E**2 for all (', I5, ') reflections'/
     *       ' a priori expectation values   ', F7.3 /
     *       ' calculated at start    ',    11X, F13.3 /
     *       ' calculated after symbols',   10X, F13.3 /
     *      (' calculated before cycle', I5, 6X, F13.3))
          IF (IICENT .EQ. 1)
     *    WRITE (8, 360) NGN, NSP, E2AGE, E2CGE, E2AG(1), E2CG(1),
     *           E2AG(7), E2CG(7), (I, E2AG(I), E2CG(I), I=2,NC-1)
  360 FORMAT(' Values for average E**2 for general refl. (', I5,
     *      ') and special refl. (', I4, ')'  /
     *       ' a priori expectation values   ', F7.3, 19X, F5.3 /
     *       ' calculated at start    ',    11X, F13.3, 12X, F12.3 /
     *       ' calculated after symbols',   10X, F13.3, 12X, F12.3 /
     *      (' calculated before cycle', I5, 6X, F13.3, 12X, F12.3))
      ENDIF
      write(24, 370) NC-1, E2TOT(NC)
  370 FORMAT(' calculated after  cycle', I5, 6X, F13.3)
      WRITE (8, 370) NC-1, E2TOT(NC)
      IF (IICENT .EQ. 1) WRITE (8, 380) NC-1, E2AG(NC), E2CG(NC)
  380 FORMAT(' calculated after  cycle', I5, 6X, F13.3, 12X, F12.3)
      call wr24
      RETURN
      END
      SUBROUTINE GENER
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      COMMON /KLAD/ ICODE(4,48), ISHIFT(48)
      COMMON /SINCOS/ IDEG(8), ISCT
      INTEGER*2 ISCT(450)
      DIMENSION  IHKL(3), IHKL3(3),  LHIT(48)
      EQUIVALENCE (IHKL3(1), JJH1), (IHKL3(2), JJH2), (IHKL3(3), JJH3),
     *            (MAXHKL(1),MAXH), (MAXHKL(2),MAXK), (MAXHKL(3),MAXL)
      DATA K,KTEST / 0, 0/
      ISTR1 = MARKA4 + INCA4 + INCA4
      ISTR2 = MARKA4 + INCA4
      DO 280 I41=ISTR1,ISTO4,INCA4
      IR1 = ITAB(I41+4) + MCT
      IEW1 = ITAB(IR1+2)
      IPH1 = ITAB(IR1+3)
      DO 200 I=1,3
  200 IHKL(I) = ITAB(I41+I)
      NEQ = 2
      CALL SYMEQ (IHKL, NEQ)
      DO 210 I=1,NEQ
      IS2 = ISHIFT(I)
      ISHIFT(I) = IPH1 + IDEG(IS2)
  210 ISHIFT(I+NEQ) = -ISHIFT(I)
      ISTOP = I41 - INCA4
      NEQ2 = NEQ * 2
      DO 270 I42=ISTR2,ISTOP,INCA4
      JH1 = ITAB(I42+1)
      JH2 = ITAB(I42+2)
      JH3 = ITAB(I42+3)
      IR2 = ITAB(I42+4) + MCT
      IPH2 = ITAB(IR2+3)
      IWEE = IEW1 * ITAB(IR2+2)
      J = ITAB(IR2+1)
      NHIT = 0
      DO 260 I11=1,NEQ2
      IF (MCTLAT .GT. 1) GOTO 220
      I = ICODE (4, I11)
      KTEST = I + J
      K = IABS(KTEST)
      IF (K .EQ. 0) GOTO 260
      IF (K .GT. MCT) GOTO 260
      IF (ITAB(K) .EQ. 0) GOTO 260
  220 JJH1 = ICODE(1,I11) + JH1
      IF (IABS(JJH1) .GT. MAXH) GOTO 260
      JJH2 = ICODE(2,I11) + JH2
      IF (IABS(JJH2) .GT. MAXK) GOTO 260
      JJH3 = ICODE(3,I11) + JH3
      IF (IABS(JJH3) .GT. MAXL) GOTO 260
      IF (MCTLAT .EQ. 1) GOTO 230
      KTEST = INPACK(IHKL3)
      K = IABS(KTEST)
      IF (K .EQ. 0) GOTO 260
      IF (ITAB(K) .EQ. 0) GOTO 260
  230 K = ITAB(K)
      LTEST = IABS(K)
      L = LTEST / 4096
      IR3 = (LTEST-L*4096-1)*ICR + MCT
      IF (IR3.EQ.IR2 .OR. IR3.EQ.IR1) GOTO 260
      IF (NHIT .EQ. 0) GOTO 250
      DO 240 IHIT=1,NHIT
      IF (IR3 .EQ. LHIT(IHIT)) GOTO 260
  240 CONTINUE
  250 NHIT = NHIT + 1
      LHIT(NHIT) = IR3
      L = L + 1
      IPH3 = ISIGN(1,K)*ISIGN(1,KTEST)*(ISHIFT(I11)+IPH2) - IDEG(L)
      IPH3 = MOD(IPH3,360)
      IF (IPH3 .LE. 0) IPH3 = IPH3 + 360
      IF (ITAB(IR3+6) .GT. 32000) GOTO 260
      ITAB(IR3+4) = ITAB(IR3+4) + IWEE*ISCT(450-IPH3)/1000000
      ITAB(IR3+5) = ITAB(IR3+5) + IWEE*ISCT(IPH3)/1000000
      ITAB(IR3+6) = ITAB(IR3+6) + IWEE/1000
  260 CONTINUE
  270 CONTINUE
  280 CONTINUE
      RETURN
      END
      SUBROUTINE STARTS (ICYC)
      INCLUDE 'Zaaaa.inc'
      LOGICAL SWIPRI
      EQUIVALENCE   (SWIPRI, SWITCH(10))
      EQUIVALENCE (IBINDO, IFILE(13))
      INCLUDE 'Zdifta.inc'
      INCLUDE 'Zbuff.inc'
      CHARACTER LITOUT *38
      DIMENSION  IHKL(3)
      COMMON /EPWCO/ IP1, IPHS, IREST, IT, W1, WS, E1, E2, EL, EEE
      DATA NLINPR / 0 /
      CALL WR24
      NITDOP = 9
      CALL BINIFF (1, IBINDO, 'BINDOP', FITDOP, NITDOP, BUFDOP, KENDOP)
      ISTO4 = MARKA4
      LLMAX = MAXA4 - INCA4
      NSPEC = 0
      NGEN = 0
      NFLIP = 0
      NSHIFT = 0
      XNUM = 0.0
      XDEN = 0.0
      IIASUM = 0
      IISSUM = 0
      IIASN = 0
      JCYC = ICYC - 1
      IF (.NOT. SWIPRI) GOTO 210
      WRITE (8, 200) JCYC
  200 FORMAT (/, ' In cycle ', I2, ' the following reflections had',
     *           ' shifts of more than 45 degress',
     *           ' (max. 100 refl. printed):', //
     *        3 ('  H  K  L Eold Enew Pold Pnew  Wnew   '), /)
      NLINPR = 0
      CHOUT = '(3A38)'
      CALL LINPRX (8, LITOUT, 38, 3)
  210 DO 310 NCOUNT=MCT,NCT,ICR
      CALL BINIFF (0, IBINDO, 'BINDOP', FITDOP, NITDOP, BUFDOP, KENDOP)
      IF (KENDOP .LT. 0) GOTO 320
      CALL KERF2I (FITDOP(1), IHKL(1), 3)
      E1 = FITDOP(4)
      EL = E1
      E2 = FITDOP(5)
      IP1 = NINT(FITDOP(6))
      IPHS = IP1
      W1 = FITDOP(7)
      IT = NINT(FITDOP(8))
      IREST = NINT(FITDOP(9))
      EOLD = ITAB(NCOUNT+7) / 100.0
      EWOLD = ITAB(NCOUNT+2) / 100.0
      WOLD = EWOLD / EOLD
      IPHO = ITAB(NCOUNT+3)
      ICS4 = ITAB(NCOUNT+4)
      ICS5 = ITAB(NCOUNT+5)
      ICS6 = ITAB(NCOUNT+6)
      IF (ICS4.EQ.0 .AND. ICS5.EQ.0 .AND. ICS6.EQ.0) THEN
          IDABS = 0
          EL = EOLD
          WS = WOLD
          IPHS = IPHO
          GOTO 265
      ENDIF
      XEE = EOLD / 10.
      AEE = ITAB(NCOUNT+4) * XEE
      BEE = ITAB(NCOUNT+5) * XEE
      FEE = ITAB(NCOUNT+6) * XEE
      EEE = SQRT(AEE*AEE + BEE*BEE)
      XNUM = XNUM + EEE
      XDEN = XDEN + FEE
      WS = (TANH(EEE/E000R))**2
      IF (EEE.LT.0.01 .OR. WS.LT.0.01) GOTO 260
      PHS = 57.29 * ATAN2(BEE,AEE)
      IF (PHS .LT. 0.) PHS = PHS + 360.
      IPHS = PHS + 0.5
      IF (IT.GT.1 .OR. WOLD.LT.0.1) GOTO 250
      IF (IDC3.EQ.1 .OR. (180-IPHO)*(180-IPHS).GT.0)  GOTO 220
      IF (MIN0(IPHS, 360-IPHS, IABS(180-IPHS)).GT.30) GOTO 250
      IPHS = 180 * MOD((IPHS+90)/180, 2)
      IF (IPHS.EQ.0 .AND. IPHO.GT.180) IPHS = 358
  220 CALL PHDIF (IPHS, IPHO, II, IIA)
      IF (PSQ .LT. 0.20)
     * IPHS=MOD(360+IPHO+ISIGN(MIN0(IIA,MAX1(47.,80.-10.*WOLD)),II),360)
      IF (IDC3 .EQ. 1) GOTO 250
      IIS = MIN0 (IPHS, 360-IPHS)
      IF (IDC3 .EQ. 2) IIS = MIN0 (IIS, IABS(180-IPHS))
      IIA = MIN0 (IPHO, 360-IPHO)
      IF (IDC3 .EQ. 2) IIA = MIN0 (IIA, IABS(180-IPHO))
      IIASUM = IIASUM + IIA
      IISSUM = IISSUM + IIS
      IIASN = IIASN + 1
      IF (IIS.GE.IIA .OR. IIS.GE.45) GOTO 250
      IF (IISSUM/IIASN .LT. 35) IPHS = ((IPHS+IPHO)/180) * 90 + 45
      IF (IIA .GT. 45) GOTO 250
      IF (IIA .LT. 20) GOTO 240
      IPHS = (IPHO+IPHS) / 2
      GOTO 250
  240 IPHS = IPHO + ISIGN(15, 90 - MOD(IPHO,180))
  250 CALL EPW
  260 CALL PHDIF (IPHS, IPHO, IDIF, IDABS)
      IF (WOLD .LT. 0.1) IDABS = 0
  265 IF (IT .GT. 1) GOTO 270
      NGEN = NGEN + 1
      NSHIFT = NSHIFT + IDABS
      E2AG(ICYC) = E2AG(ICYC) + EL*EL
      GOTO 280
  270 IF (IDABS .GT. 90) NFLIP = NFLIP + 1
      NSPEC = NSPEC + 1
      E2CG(ICYC) = E2CG(ICYC) + EL*EL
  280 IF (IDABS.LT.45 .OR. .NOT.SWIPRI) GOTO 290
      IF (SWIPRI .AND. NLINPR.LT.100) THEN
         NLINPR = NLINPR + 1
         WRITE (LITOUT, FMT='(1X, 3I3, 2F5.2, 2(I4,''.''), F6.3, 2X)')
     *                        IHKL, EOLD, EL, IPHO, IPHS, WS
         CALL LINPRX (0, LITOUT, 38, 3)
      ENDIF
  290 ITAB(NCOUNT+2) = 100.0*EL*AMAX1(W1,WS) + 0.5
      ITAB(NCOUNT+3) = IPHS
      ITAB(NCOUNT+4) = 0
      ITAB(NCOUNT+5) = 0
      ITAB(NCOUNT+6) = 0
      ITAB(NCOUNT+7) = 100.*EL + 0.5
      IF (ICYC .LT. NC) GOTO 300
      ITAB(NCOUNT+4) = IP1
      ITAB(NCOUNT+5) = IREST
  300 IF (EL .LT. ESTART(ICYC)) GOTO 310
      IF (ISTO4 .GT. LLMAX) GOTO 310
      CALL IITAB4 (IHKL, NCOUNT)
  310 CONTINUE
  320 IF (SWIPRI) CALL LINPRX (-1, LITOUT, 38, 3)
      IF (ISTO4 .GT. LLMAX) WRITE(24, 330) ICYC
  330 FORMAT(' **** WARNING: the basic set for cycle', I2,
     *       ' is not complete; table ITAB is too small')
      MS = (ISTO4-MARKA4) / INCA4
      IF (NGEN .GT. 0) NSHIFT = FLOAT(NSHIFT)/NGEN + .5
      IF (IICENT .EQ. 1) THEN
         WRITE (8, 340) JCYC, NGEN, NSHIFT, NFLIP, NSPEC
  340    FORMAT (' Statistics for cycle ', I3, ':', /,
     *        I5, ' general reflections gave average phase shift of ',
     *        I4, ' degrees', /, I5, ' special reflections out of',
     *        ' a total of', I5, '  shifted by 180 degrees')
      ELSE
         WRITE (8, 342) JCYC, NFLIP, NSPEC
  342    FORMAT (' Statistics for cycle ', I3, ':', /,
     *         I5, ' reflections out of a total of',
     *         I5, '  gave a phase shift of 180 degrees')
         ENDIF
      IF (XDEN .LT. 0.00001) GOTO 355
      XDEN = XNUM / XDEN
      WRITE(24, FMT='('' Cycle'', I3, '': Sigma2 - consistency  '',
     *                   F6.3)') JCYC, XDEN
      WRITE (8, FMT='('' Sigma2 - consistency: '', F6.3)') XDEN
  355 IF (IDC3 .EQ. 1) GOTO 370
      IIASN  = MAX0 (1, IIASN)
      IIASUM = IIASUM / IIASN
      IISSUM = IISSUM / IIASN
      WRITE (8, 360) IIASUM, IISSUM
  360 FORMAT (/' Average deviation from 0 degrees (or 180 degrees)' /
     *        ' for phases used in the last cycle: ', I3  , ' degrees '/
     *        ' for new phases (before resetting): ', I3  , ' degrees ')
  370 CONTINUE
      IF (ICYC .LT. NC) WRITE (8, 380) MS, ICYC
  380 FORMAT(/' There are', I5, ' reflections in the basic set',
     *             ' for cycle', I3)
      RETURN
      END
      SUBROUTINE ORSHIF (HKL, TO, P1, P2, PL, KORIS)
      DIMENSION HKL(3), TO(3)
      PHT = 0.0
      DO 110 I=1,3
  110 PHT = PHT + TO(I)*HKL(I)
      PHT = AMOD(PHT,1.) * 360.
      IF (PHT .LT. 0.0) PHT = PHT + 360.
      IF (KORIS .NE. 1) GOTO 120
      P1 = P1 - PHT
      P2 = P2 - PHT
      IF (P1 .LT. 0.0) P1 = P1 + 360.
      IF (P2 .LT. 0.0) P2 = P2 + 360.
      GOTO 130
  120 PL = PL - PHT
      IF (PL .LT. 0.0) PL = PL + 360.
  130 RETURN
      END
      SUBROUTINE PSEUDO (TO)
      INCLUDE 'Zsyst.inc'
      INCLUDE 'Zcrys.inc'
      LOGICAL EXPAND
      EQUIVALENCE   (EXPAND, SWITCH(23))
      DIMENSION  TO(3), RSYMM(3,3,24)
      NNSYMM = NSYMM
      IF (EXPAND) NNSYMM = 1
      CALL KERI2F (IRSYMM, RSYMM, 9*NNSYMM)
      DO 130 K=1,NNSYMM
      DO 130 I=1,3
      TMA = 0.0
      DO 120 J=1,3
  120 TMA = TMA + RSYMM(I,J,K)*TO(J)
  130 TSYMM(I,K) = TMA + TSYMM(I,K) - TO(I)
      RETURN
      END
      SUBROUTINE IITAB4 (IHKL, K)
      DIMENSION IHKL(3)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      ISTO4 = ISTO4 + INCA4
      ITAB(ISTO4+1) = IHKL(1)
      ITAB(ISTO4+2) = IHKL(2)
      ITAB(ISTO4+3) = IHKL(3)
      ITAB(ISTO4+4) = K - MCT
      RETURN
      END
      INTEGER FUNCTION INPACK (I)
      DIMENSION I(3)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      IF (MCTLAT .GT. 1) GOTO 100
      INPACK = MCH*I(1) + MCK*I(2) + I(3)
      RETURN
  100 K2 = I(2)
      K3 = I(3)
      GOTO (1,  2,  2,  4,  2,  6,  7  ), MCTLAT
    2 IF (K3 .NE. 0) K3 = (K3 + ISIGN(1,K3))/2
      GOTO 1
    6 IF (K2 .NE. 0) K2 = (K2 + ISIGN(1,K2))/2
      GOTO 2
    7 IF (K3 .NE. 0) K3 = (K3 + ISIGN(2,K3))/3
      GOTO 1
    4 IF (K2 .NE. 0) K2 = (K2 + ISIGN(1,K2))/2
    1 INPACK = MCH*I(1) + MCK*K2 + K3
      RETURN
      END
      SUBROUTINE XUNPAK (IPACK, IHKL)
      DIMENSION IHKL(3)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      EQUIVALENCE (MAXHKL(1),MAXH), (MAXHKL(2),MAXK), (MAXHKL(3),MAXL)
      I1 = IPACK + MCT
      I2 = I1 / MCH
      IHKL(1) = I2 - MAXH
      I1 = I1 - I2*MCH
      I2 = I1 / MCK
      IHKL(2) = I2 - I34
      IHKL(3) = I1 - I2*MCK - I35
      GOTO (9,  2,  3,  4,  5,  7,  6  ), MCTLAT
    2 KH = IABS(IHKL(2))
      GOTO 110
    3 KH = IABS(IHKL(1))
      GOTO 110
    5 KH = IABS(IHKL(1)+IHKL(2))
  110 IF (IHKL(3) .NE. 0) IHKL(3) = 2*IHKL(3) - ISIGN(MOD(KH,2),IHKL(3))
      GOTO 9
    7 KH = IHKL(3)*3
      GOTO (120, 9, 130), KH
  120 IHKL(3) = KH + MOD(300+IHKL(1)-IHKL(2),3)
      GOTO 9
  130 IHKL(3) = KH - MOD(300-IHKL(1)+IHKL(2),3)
      GOTO 9
    6 KH = IABS(IHKL(1))
      IF (IHKL(3) .NE. 0) IHKL(3) = 2*IHKL(3) - ISIGN(MOD(KH,2),IHKL(3))
    4 KH = IABS(IHKL(1))
      IF (IHKL(2) .NE. 0) IHKL(2) = 2*IHKL(2) - ISIGN(MOD(KH,2),IHKL(2))
    9 RETURN
      END
      FUNCTION IGROUP (IHKL)
      INCLUDE 'Zcrys.inc'
      DIMENSION IHKL(3), ICODE(24)
      DATA ICODE / 1,2,3,4,3,4,1,2,1,2,3,4,2,1,4,3,1,2,2,1,3,4,4,3 /
      IGROUP = 0
      DO 100 I=1,3
  100 IGROUP = IGROUP + IABS(MOD(IHKL(I),2))*2 **I
      IGROUP = IGROUP/2 +1
      GOTO (3, 3, 3, 2, 2, 5, 5, 4, 4, 4, 4, 4, 5, 5), ILAUE
    2 I = 8*(IUNIQ-1) + IGROUP
      IGROUP = ICODE(I)
    3 RETURN
    4 IGROUP = IABS(MOD(IHKL(IUNIQ),2)) +1
      RETURN
    5 IGROUP = 0
      DO 110 I=1,3
  110 IGROUP = IGROUP + IHKL(I)
      IGROUP = IABS(MOD(IGROUP,2)) + 1
      RETURN
      END
      SUBROUTINE SYMEQ (IHKL, N)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      LOGICAL EXPAND
      EQUIVALENCE   (EXPAND, SWITCH(23))
      INCLUDE 'Zdifta.inc'
      COMMON /KLAD/ IC(4,48), IS(48)
      DIMENSION ICODE(13), IHKL(3), ITEMP(24)
      DATA ICODE / 1, 0, 2, 3, 4, 0, 5, 0, 6, 7, 8, 0, 1 /
      NNSYMM = NSYMM
      IF (EXPAND) NNSYMM = 1
      M = N
      N = 1
      CALL KERNZI (0, ITEMP, 24)
      DO 150 I=1,NNSYMM
      XTEST = 0.0
      DO 120 K=1,3
      IC(K,N) = 0
      DO 110 L=1,3
  110 IC(K,N) = IC(K,N) + IHKL(L)*IRSYMM(L,K,I)
  120 XTEST = XTEST - IHKL(K)*TSYMM(K,I)
      IC(4,N) = INPACK(IC(1,N))
      ITEMP(N) = IABS(IC(4,N))
      IF (N.EQ.1) GOTO 140
      K = N - 1
      DO 130 L=1,K
  130 IF (ITEMP(L) .EQ. ITEMP(N)) GOTO 150
  140 XTEST = XTEST - IFIX(XTEST)
      IF (XTEST .LT. -0.01) XTEST = XTEST + 1.0
      J = IFIX(12.*XTEST+0.01) + 1
      IS(N) = ICODE(J)
      N = N + 1
  150 CONTINUE
      N = N - 1
      IF (M .EQ. 1) GOTO 170
      DO 160 J=1,N
      DO 160 I=1,4
  160 IC(I,J+N) = -IC(I,J)
  170 RETURN
      END
      SUBROUTINE DD38
      COMMON /SINCOS/ IDEG(8), ISCT
      INTEGER*2 ISCT(450)
      IDEG(1) = 0
      IDEG(2) = 60
      IDEG(3) = 90
      IDEG(4) = 120
      IDEG(5) = 180
      IDEG(6) = 240
      IDEG(7) = 270
      IDEG(8) = 300
      P = 0.0
      DO 100 I=1,90
      P = P + 0.0174532925
      IP = SIN(P)*1000. + 0.5
      ISCT(I) = IP
      ISCT(180-I) = IP
      ISCT(180+I) = -IP
      ISCT(360-I) = -IP
      ISCT(360+I) = IP
  100 CONTINUE
      ISCT(360) = 0
      ISCT(180) = 0
      RETURN
      END
      SUBROUTINE PHDIF (IPHS, IP, IDIF, IDABS)
      IDIF = IPHS-IP
      IF (IDIF .LT. -179) IDIF = IDIF + 360
      IF (IDIF .GT.  180) IDIF = IDIF - 360
      IDABS = IABS(IDIF)
      RETURN
      END
      SUBROUTINE EPW
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      COMMON /EPWCO/ IP1, IPHS, IREST, IT, W1, WS, E1, E2, EL, EEE
      CALL PHDIF (IPHS, IP1, IDIF, IDABS)
      IF (IREST .LT. 100) GOTO 220
      IF (IT .EQ. 1) GOTO 200
      EEE = ABS (EEE * COS(IDIF/57.29))
      WS = TANH (EEE/E000R)**2
      IDIF = 0
      IF (WS.LT.W1 .OR. EEE.LT.0.01) GOTO 250
      IF (IDABS .LT. 90) GOTO 250
      IDIF = 180
      EL = E2
      GOTO 250
  200 IF (IDIF .EQ. 0) GOTO 250
      IF (W1 .LT. 0.1) GOTO 210
      IF (WS .LT. W1) IDIF = IDIF*WS/W1 + 0.5
  210 COSD = COS(IDIF/57.29) * (E2-E1)
      EL = 0.5 * ABS(COSD - SQRT(COSD**2+4.*E1*E2))
      GOTO 250
  220 IF (IT .NE. 1) GOTO 240
      IF (IDABS .LT. IREST) GOTO 230
      IDIF = ISIGN (IREST,IDIF)
      EEE = ABS (EEE * COS((IDABS-IREST)/57.29))
      WS = TANH (EEE/E000R)**2
      IF (WS.LT.W1 .OR. EEE.LT.0.01) GOTO 240
      EL = SQRT (E1*E2)
      GOTO 250
  230 IF (IDIF .EQ. 0) GOTO 260
      IF (WS .LT. W1) GOTO 240
      COSD = COS (IDIF/57.29) * (E2+E1)
      EL = 0.5 * ABS (COSD - SQRT(COSD**2-4.*E1*E2))
      GOTO 250
  240 IDIF = 0
  250 IPHS = IP1 + IDIF
      IF (IPHS .GE. 360) IPHS = IPHS - 360
      IF (IPHS .LT. 0)   IPHS = IPHS + 360
  260 CONTINUE
      RETURN
      END
      SUBROUTINE LOCCEN (KEY, CENTER)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      DIMENSION CENTER(3)
      LOGICAL EXPAND
      EQUIVALENCE   (EXPAND, SWITCH(23))
      EQUIVALENCE (IATOMS, IFILE(1))
      INCLUDE 'Zdifta.inc'
      INCLUDE 'Zatomx.inc'
      COMMON /LOCPC1/
     *          XY(3,400), NIZ(400), NDEL(400), SYMXYZ(3),
     *          DLIM(6), CEN2(3)
      CALL WR24
      IF (KEY .GT. 0) RETURN
      IF (IICENT .EQ. 2) RETURN
      NSLOC = NSYMM
      IF (EXPAND) NSLOC = 1
      IF (NSLOC .NE. NSYMM) THEN
         WRITE (8, 200)
  200    FORMAT (/' Search for LOCCEN in triclinic symmetry:' /
     *       ' Results correct only after execution of program EXPAND')
      ELSE
         WRITE (8, 210)
  210    FORMAT (/' Search for LOCCEN (symm.center in model struct.?))')
         ENDIF
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .NE. 0) CALL KERROR ('No ATOMS file found', 0, 'LOCCEN')
      CALL ATOMIN (IATOMS, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      CALL FILCLO (IATOMS, 'KEEP')
      N = NAT * NSLOC * NLATT
      IF (N .LE. 400) GOTO 260
      WRITE(24, 240) N
      WRITE (8, 240) N
  240 FORMAT (' No search for LOCCEN: too many atoms in the unit cell'/
     *        ' Allowed: maximum 400 , input (symmetry inluded):', I5  /
     *        ' If enantiomorph problem: do supply a LOCCEN card')
      RETURN
  260 DO 270 I=1,3
      DLIM(I) = 0.20 / CELL(I)
  270 DLIM(I+3) = 1.0 - DLIM(I)
      K = 1
      DO 320 LA=1,NAT
      DO 320 LL=1,NLATT
      DO 320 LS=1,NSLOC
      DO 280  I=1,3
      XY(I,K) = TSYMM(I,LS) + TLATT(I,LL)
      DO 280  J=1,3
  280 XY(I,K) = XY(I,K) + ATXYZ(J,LA)*IRSYMM(I,J,LS)
      DO 310  I=1,3
  290 IF (XY(I,K) .GT. 0.5) GOTO 300
      IF (XY(I,K) .GT. -.5) GOTO 310
      XY(I,K) = XY(I,K) + 1.0
      GOTO 290
  300 XY(I,K) = XY(I,K) - 1.0
      GOTO 290
  310 CONTINUE
      NIZ(K) = IZAT(LA)
  320 K = K + 1
      DO 410 L=1,N
      IF (IABS(NIZ(1)-NIZ(L)) .GT. 2) GOTO 410
      DO 340 I=1,3
      CEN2(I) = XY(I,1) + XY(I,L)
      IF (CEN2(I) .GT. 0.7) CEN2(I) = CEN2(I) - 1.0
      IF (CEN2(I) .LE. -.3) CEN2(I) = CEN2(I) + 1.0
  340 CENTER(I) = CEN2(I)
      J = 2
      CALL KERNZI (0, NDEL, N)
      NDEL(1) = 1
      NDEL(L) = 1
      DO 390 LC=1,N
      IF (NDEL(LC) .EQ. 1) GOTO 390
      DO 350 I=1,3
  350 SYMXYZ(I) = CEN2(I) - XY(I,LC)
      DO 380 LR=1,N
      IF (NDEL(LR) .EQ. 1) GOTO 380
      IF (IABS(NIZ(LR)-NIZ(LC)) .GT. 2) GOTO 380
      DO 360 I=1,3
      DIST = ABS(SYMXYZ(I) - XY(I,LR))
      IF (DIST.GT.DLIM(I) .AND. DIST.LT.DLIM(I+3)) GOTO 380
  360 CONTINUE
      J = J + 2
      DO 370 I = 1,3
      DIST = XY(I,LC) + XY(I,LR)
      IF (DIST-CEN2(I) .LT. -.1) DIST = DIST + 1.0
      IF (DIST-CEN2(I) .GT. 0.1) DIST = DIST - 1.0
  370 CENTER(I) = CENTER(I) + DIST
      NDEL(LC) = 1
      NDEL(LR) = 1
      GOTO 390
  380 CONTINUE
      GOTO 410
  390 CONTINUE
      DO 400 I=1,3
  400 CENTER(I) = CENTER(I) / J
      GOTO 430
  410 CONTINUE
      WRITE (8, 420)
  420 FORMAT (' No center of symmetry found')
      RETURN
  430 WRITE(24, 440) (CENTER(I), I=1,3)
  440 FORMAT (' Center of symmetry found at ', 3F7.4)
      KEY = 1
      RETURN
      END
      SUBROUTINE LINPRX (KEY, LITOUT, LOUT, NIT)
      CHARACTER LITOUT *(*)
      INCLUDE 'Zsyst.inc'
      CHARACTER PRFORM *72
      PARAMETER (MAXLIN = 20, MAXCHA = 100)
      CHARACTER LITLIN(MAXLIN) *100
      DATA LITNIT, NITMAX, IPR / 0, 0, 0/
      CALL WR24
      IF (KEY) 230, 220, 200
  200 IPR = KEY
      PRFORM = CHOUT
      CHOUT = ' '
      NITMAX = NIT
      IF (NITMAX .GT. MAXLIN) CALL KERNER (4, 'LINPRX')
      IF (LOUT .GT. MAXCHA) CALL KERNER (4, 'LINPRX')
  210 CONTINUE
         DO 211 I = 1, NIT
  211    LITLIN(I) = ' '
      LITNIT = 0
      RETURN
  220 IF (LITNIT+1 .GT. NITMAX) THEN
         WRITE (IPR, FMT=PRFORM) (LITLIN(ILIT), ILIT=1,LITNIT)
         DO 221 I = 1, NITMAX
  221    LITLIN(I) = ' '
         LITNIT = 0
         ENDIF
      LITNIT = LITNIT + 1
      LITLIN(LITNIT) = LITOUT
      RETURN
  230 IF (LITNIT .GT. 0)
     *    WRITE (IPR, FMT=PRFORM) (LITLIN(ILIT), ILIT=1,LITNIT)
      GOTO 210
      END
      SUBROUTINE DACOP
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      INCLUDE 'Zdiftb.inc'
      COMMON /KLADC/ CHAR(12)
      CHARACTER CHARR(12) *1, CHAR *1
      DATA CHARR / 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J',
     *             '-', ' '/
      CALL WR24
      DO 110 I=1,5*ISIZ5
  110 ITAB5(I) = 0
      INCA5 = 5
      DO 120 I=1,12
  120 CHAR(I) = CHARR(I)
      II = (MAXA4-ISTO4) / 50
      I = MS
      IF (IDC.EQ.1 .AND. I.GT.200) I = 100 + I/2
      MAXA4N = MARKA4 + I*INCA4
      I5 = I / 2
      I5 = MIN0(I5,II,MAXT) + 14
      MAXT = MIN0(I5,MAXT)
      IF (MS .LT. 500) I5 = 500 - MS
      MAXA4 = MAXA4N +  I5 * INCA4
      WRITE (8, FMT='('' Limitations:'')')
      IF (IDC .EQ. 1) WRITE (8, 140) I
  140 FORMAT (' New basic set with numeric phases: ', I5)
      WRITE (8, 150) I5, II
  150 FORMAT (' in basic set with symbolic phases: ', I5/
     *        ' maximum number of symbolic phases: ', I5)
      RETURN
      END
      SUBROUTINE DAMAIN
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      INCLUDE 'Zdiftb.inc'
      DIMENSION KPGE(8), KPG(8), IDUMMY(10)
      CALL WR24
      CALL REDSYM (-1, IDUMMY, 0)
      JSYMB = 0
      JOLD  = 0
      JSMAX = 10
      IF (IPSQ .EQ. 1) JSMAX = 15
      DO 210 K=MCT,NCT,ICR
      IF (ITAB(K+2) .GE. 0) GOTO 200
      ITAB(K+4) = -(1000.*ITAB(K+2)) / ITAB(K+7)
      GOTO 210
  200 WNE = ITAB(K+4)
      ITAB(K+4) = SQRT(WNE) * (ITAB(K+7)-ITAB(K+2))
  210 CONTINUE
      ISTA4 = ISTO4 + INCA4
      ISTO5 = 0
      WRITE (8, 220)
  220 FORMAT (' Ambiguity choices', /, 5X, 'H   K   L    E1  Symbol')
      DO 270 KK=1,2
  230 CALL KERNZI (0, KPGE(1), 8)
      CALL KERNZI (0,  KPG(1), 8)
      KTEST = 0
      DO 240 K=MCT,NCT,ICR
      IF (IPSQ.EQ.1 .AND. IICENT.EQ.1 .AND. ITAB(K+5).NE.-1) GOTO 240
      IF (ITAB(K+2).LT.0 .OR. ITAB(K+6).LT.0) GOTO 240
      IF (IPSQ.EQ.0 .AND. ITAB(K+2).GT.2 .AND. KK.EQ.2) GOTO 240
      IPG = ITAB(K+6)
      IF (IPG2(IPG).LT.0 .AND. KK.EQ.1) GOTO 240
      IF (ITAB(K+4) .LE. KPGE(IPG)) GOTO 240
      KPGE(IPG) = ITAB(K+4)
      KPG(IPG)  = K
      KTEST = KTEST + 1
  240 CONTINUE
      DO 250 IPG=1,8
      IF (KPG(IPG) .LE. 0) GOTO 250
      K = KPG(IPG)
      IF (IICENT.EQ.2 .OR. ITAB(K+5).EQ.-1) CALL DACAS (K)
      IF (ITAB(K+7) .GT. 0) ITAB(K+6) = -1
      IF (JSYMB .EQ. JSMAX) GOTO 280
  250 CONTINUE
      IF (JOLD .EQ. JSYMB) GOTO 260
      JOLD = JSYMB
      GOTO 230
  260 IF (JSYMB .GT. 0) GOTO 280
      IF (KTEST.EQ.0 .AND. KK.EQ.2) GOTO 275
  270 CONTINUE
  275 IF (JSYMB .EQ. 0) GOTO 300
  280 IF (JSYMB .GT. 10) JSYMB = 10
      DO 290 K=MCT,NCT,ICR
      IF (ITAB(K+7) .GT. 0) ITAB(K+6) = 0
      IF (ITAB(K+2) .GT. 0) ITAB(K+4) = 0
  290 CONTINUE
  300 IF (JSYMB .EQ. 0) CALL KERROR ('No symbols', 0, 'DAMAIN')
      WRITE(24, 310) JSYMB
      WRITE (8, 310) JSYMB
  310 FORMAT (' Number of ambiguity symbolic choices (primary',
     *        ' set):', I6)
      RETURN
      END
      SUBROUTINE DACAS (K)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      INCLUDE 'Zdiftb.inc'
      COMMON /KLADC/ CHAR(12)
      CHARACTER CHAR *1
      DIMENSION IHKL(3), ISTOR(10)
      IPACK = ITAB(K+1)
      CALL XUNPAK (IPACK, IHKL)
      E1 = ITAB(K+7) / 100.
      IF (JSYMB .LT. 2) GOTO 200
      CALL GENERB (IHKL, K, ISW)
      IF (ISW .EQ. -1) RETURN
  200 IF (IPSQ .EQ. 0) GOTO 220
      EW = ITAB(K+2) / 100.
      W1 = EW / E1
      DO 210 I7=1,7
  210 ISTOR(I7) = ITAB(K+I7)
      ISTOR(4) = W1
      CALL KERNAI (IHKL, ISTOR(8), 3)
      CALL REDSYM (0, ISTOR, K)
  220 JSYMB = JSYMB + 1
      IF (JSYMB .GT .10) RETURN
      CALL IITAB4 (IHKL, K)
      ITAB(K+7) = -ITAB(K+7)
      ITAB(K+2) =  ITAB(K+7)
      ITAB(K+3) = 0
      ITAB(K+4) = 1000
      ISTO5 = ISTO5 + INCA5
      ITAB(K+6)  = ISTO5 / 5
      ITAB5(ISTO5+1) = 32767
      ITAB5(ISTO5+4) = 0
      ITAB5(ISTO5+5) = JSYMB
      IF (IDC .EQ. 1) GOTO 240
      WRITE (8, 230) IHKL, E1, CHAR(JSYMB)
  230 FORMAT (2X, 3I4, F7.2, 4X, A1, I8)
      RETURN
  240 WRITE (8, 230) IHKL, E1, CHAR(JSYMB), ITAB(K+5)
      RETURN
      END
      SUBROUTINE GENERB (IHKL, IR1, ISW)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      INCLUDE 'Zdiftb.inc'
      COMMON /KLAD/ ICODE(4,48), ISHIFT(48)
      DIMENSION IHKL(3), IHKL3(3)
      EQUIVALENCE (IHKL3(1), JJH1), (IHKL3(2), JJH2), (IHKL3(3), JJH3)
      EQUIVALENCE (MAXHKL(1),MAXH), (MAXHKL(2),MAXK), (MAXHKL(3),MAXL)
      DATA K / 0 /
      NEQ = 2
      CALL SYMEQ (IHKL, NEQ)
      NEQ2 = NEQ * 2
      DO 240 I42=ISTA4,ISTO4,INCA4
      JH1 = ITAB(I42+1)
      JH2 = ITAB(I42+2)
      JH3 = ITAB(I42+3)
      IR2 = ITAB(I42+4) + MCT
      J = ITAB(IR2+1)
      DO 230 I11=1,NEQ2
      IF (MCTLAT .GT. 1) GOTO 200
      I = ICODE(4,I11)
      KTEST = I + J
      K = IABS(KTEST)
      IF (K .EQ. 0) GOTO 230
      IF (K .GT. MCT) GOTO 230
      IF (ITAB(K) .EQ. 0) GOTO 230
  200 JJH1 = ICODE(1,I11) + JH1
      IF (IABS(JJH1) .GT. MAXH) GOTO 230
      JJH2 = ICODE(2,I11) + JH2
      IF (IABS(JJH2) .GT. MAXK) GOTO 230
      JJH3 = ICODE(3,I11) + JH3
      IF (IABS(JJH3) .GT. MAXL) GOTO 230
      IF (MCTLAT .EQ. 1) GOTO 210
      KTEST = INPACK(IHKL3)
      K = IABS(KTEST)
      IF (K .EQ. 0) GOTO 230
      IF (ITAB(K) .EQ. 0) GOTO 230
  210 K = ITAB(K)
      LTEST = IABS(K)
      L = LTEST / 4096
      IR3 = (LTEST-L*4096-1)*ICR + MCT
      IF (IR3 .EQ. IR1) GOTO 250
      IR3 = IR3 - MCT
      DO 220 I=ISTA4,ISTO4,INCA4
      IRB = ITAB(I+4)
      IF(IR3 .EQ. IRB) GOTO 250
  220 CONTINUE
  230 CONTINUE
  240 CONTINUE
      ISW = 0
      RETURN
  250 ISW = -1
      RETURN
      END
      SUBROUTINE DCMAIN
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zbuff.inc'
      LOGICAL SWIPRI
      EQUIVALENCE   (SWIPRI, SWITCH(10))
      EQUIVALENCE (IBINDO, IFILE(13))
      INCLUDE 'Zdifta.inc'
      INCLUDE 'Zdiftb.inc'
      DIMENSION IHKL(3), KARR(100)
      DIMENSION CC(25), ICC(25), IB(25)
      CHARACTER LITOUT *32
      CALL KERNZA (0., CC, 25)
      CALL KERNZI (0, ICC, 25)
      CALL WR24
      CALL GENER
      NAVG = 0
      CAVG = 0.0
      NAVG2 = 0
      CAVG2 = 0.0
      CALL BINIFF (1, IBINDO, 'BINDOP', FITDOP, NITDOP, BUFDOP, KENDOP)
      DO 240 K=MCT,NCT,ICR
      CALL BINIFF (0, IBINDO, 'BINDOP', FITDOP, NITDOP, BUFDOP, KENDOP)
      IF (KENDOP .LT. 0) GOTO 250
      E1     = FITDOP(4)
      W1     = FITDOP(7)
      IT     = FITDOP(8)
      PHREST = FITDOP(9)
      AEE = ITAB(K+4)
      BEE = ITAB(K+5)
      SEE = ITAB(K+6)
      ITAB(K+4) = W1 * 1000.
      ITAB(K+5) = 0
      ITAB(K+6) = 0
      IF (IT .GT. 1) GOTO 230
      IF (PHREST.LT.150. .OR. E1.GT.3.999) GOTO 240
      IF (W1 .LT. 0.16) GOTO 200
      IP1 = ITAB(K+3)
      IP1 = MOD(IP1,180)
      CALL PHDIF (IP1, 90, IDIF, IDABS)
      IF (IDABS .GT. 45) GOTO 200
      ITAB(K+4) = ITAB(K+4) + 1000
      GOTO 240
  200 EEE = SQRT(AEE*AEE+BEE*BEE)
      IF (EEE .LT. 1.) EEE = 1.
      QEE = SEE / EEE
      IF (QEE .GT. 5.) QEE = 5.
      C = QEE * E1 * (SEE-EEE)/10.
      NAVG = NAVG + 1
      IF (C .GT. 32767.) C = 32767.
      CAVG = CAVG + C
      IF (C .LT. 1.) GOTO 240
      ITAB(K+5) = C + 0.5
      IF (W1 .GT. 0.9) GOTO 240
      NAVG2 = NAVG2 + 1
      CAVG2 = CAVG2 + C
      C = C * E1
      IF (C .LE. CC(25)) GOTO 240
      II = 25
  210 JJ = II - 1
      IF (C .LE. CC(JJ)) GOTO 220
      CC(II)  = CC(JJ)
      ICC(II) = ICC(JJ)
      II = JJ
      IF (II .GT. 1) GOTO 210
  220 CC(II)  = C
      ICC(II) = K
      GOTO 240
  230 ITAB(K+5) = -IT
  240 CONTINUE
  250 CONTINUE
      CAVG = CAVG / NAVG
      IF (NAVG2 .GT. 0) CAVG2 = CAVG2 / NAVG2
      WRITE (8, 260) CAVG, NAVG, CAVG2, NAVG2
  260 FORMAT(' The averaged value of the enantiomorph discriminator',
     *       ' (C): ', F7.2,/,3X, '(calculated on', I5, ' reflections)',
     *  /,   '                                                     ',
     *       ' (C): ', F7.2,/,3X, '(calculated on', I5,
     * ' unphased reflections)')
      NAVG = CAVG/2.0 + 0.5
      NAVG2 = CAVG2/2.0 + 0.5
      IF (NAVG2 .GT. 0) GOTO 280
      NAVG = 0
      WRITE (8, 270)
  270 FORMAT (/' === C-formula not valid === use: E1/W1**2 ===')
      IDC3 = 3
  280 NREFM = (NCT-MCT) / ICR / 5
      NREFM = MIN0(NREFM,80)
      NREFMA = (MAXA4N - MARKA4) / INCA4
      IW = 990
      IESTR = 80
      NN = 0
      NN2 = 0
      DO 290 K=MCT,NCT,ICR
      IF (ITAB(K+4).LT.500 .OR. ITAB(K+5).GT.NAVG) GOTO 290
      IF (ITAB(K+4) .GE. 990) NN2 = NN2 + 1
      NN = NN + 1
  290 CONTINUE
      IF (NN2 .GT. NREFMA) GOTO 310
      IF (NN2 .GE. NREFM)  GOTO 330
      IW = 500
      IF (NN .LE. NREFM) GOTO 330
      CALL VALDIS (-1, 500., 1000., KARR, 100, NUMA4)
      DO 300 K=MCT,NCT,ICR
      IF (ITAB(K+4).LT.500 .OR. ITAB(K+5).GT.NAVG) GOTO 300
      W1 = ITAB(K+4)
      CALL VALDIS (0, W1, 0., KARR, 100, NUMA4)
  300 CONTINUE
      CALL VALDIS (NREFM, W1, 0., KARR, 100, NUMA4)
      IW = W1 + .5
      GOTO 330
  310 CALL VALDIS (-1, 80., 400., KARR, 100, NUMA4)
      DO 320 K=MCT,NCT,ICR
      IF (ITAB(K+4).LT.990 .OR. ITAB(K+5).GT.NAVG) GOTO 320
      E1 = ITAB(K+7)
      CALL VALDIS (0, E1, 0., KARR, 100, NUMA4)
  320 CONTINUE
      CALL VALDIS (NREFMA, E1, 0., KARR, 100, NUMA4)
      IESTR = E1 + .5
  330 W1 = FLOAT(IW) / 1000.
      E1 = FLOAT(IESTR) / 100.
      WRITE (8, 340) W1, E1
  340 FORMAT (/' Select new basic set, W1min = ',F6.3, ' E1min = ',F5.2)
      IF (SWIPRI) THEN
         WRITE (8, 350)
  350    FORMAT (/' New basic set reflections with numeric phases', /
     *            ' ', 4 ('  H  K  L  E1   P1   W1    C    '), /)
         CHOUT = '(4A32)'
         CALL LINPRX (8, LITOUT, 32, 4)
         ENDIF
      ISTO4 = MARKA4
      DO 360 K=MCT,NCT,ICR
      IF (ITAB(K+7).LT.IESTR .OR. ITAB(K+4).LT.IW
     *                       .OR. ITAB(K+5).GT.NAVG) GOTO 360
      IF (ISTO4 .GE. MAXA4N) GOTO 370
      IP = ITAB(K+1)
      CALL XUNPAK (IP, IHKL)
      CALL IITAB4 (IHKL, K)
      ITAB(K+2) = -ITAB(K+2)
      IF (SWIPRI) THEN
         E1  = ITAB(K+7) / 100.
         IP1 = ITAB(K+3)
         W   = ITAB(K+4) / 1000.
         IF (ITAB(K+4) .GT. 1000) W = W - 1.
         ICX = ITAB(K+5)
         WRITE (LITOUT, FMT='(1X, 3I3, F5.2, I4, ''.'', F5.2, I4, 3X)')
     *                        IHKL, E1, IP1, W, ICX
         CALL LINPRX (0, LITOUT, 32, 4)
         ENDIF
  360 CONTINUE
  370 IF (SWIPRI) CALL LINPRX (-1, LITOUT, 32, 4)
      NUMA4 = (ISTO4-MARKA4) / INCA4
      WRITE (8, 380) NUMA4
  380 FORMAT (/' There are ', I5, ' reflections with numeric phases',
     *        ' in the new basic set')
      NIB = 25
      IF (NAVG .GT. 0) GOTO 430
      IE4 = 399
  383 CALL KERNZI (0, IB, 25)
      NIB = 0
      DO 420 K=MCT,NCT,ICR
      IF (ITAB(K+4).GT.IW .OR. ITAB(K+5).LT.0) GOTO 420
      IF (ITAB(K+7) .GT. IE4) GOTO 420
      I = ITAB(K+4)
      I = ITAB(K+7) * 100000 / MAX0(10,I)**2
      IF (I .LE. IB(25)) GOTO 420
      NIB = MIN0 (NIB +1, 25)
      JJ = 25
      DO 390 II=1,25
      IF (I-IB(II)) 390, 390, 410
  390 CONTINUE
  400 IB(JJ)  = IB(JJ-1)
      ICC(JJ) = ICC(JJ-1)
      JJ = JJ - 1
  410 IF (II .LT. JJ) GOTO 400
      IB(II)  = I
      ICC(II) = K
  420 CONTINUE
      IF (NIB .LT. 25) THEN
         WRITE (8, 421) NIB
  421    FORMAT (' Only ', I3, ' enant.discr. refl. accepted:')
         IF (NIB .GT. 0) WRITE (8, 422) IB(NIB)
  422    FORMAT (' the weakest having IE1 / IW1 =', I7)
         IF (NIB .GE. 15) GOTO 430
         IF (IE4 .LT. 500) THEN
            IE4 = IE4 + 200
            IW = IW * 2
            WRITE (8, FMT='('' try again ... ??'')')
            GOTO 383
            ENDIF
         IF (NIB .GE. 1) GOTO 430
         CALL KERROR ('No enant.discr.refl. found', 422, 'DCMAIN')
         ENDIF
  430 DO 440 K=MCT,NCT,ICR
      IF (ITAB(K+4) .GT. 1000) ITAB(K+4) = ITAB(K+4) - 1000
  440 CONTINUE
      ISTA4 = ISTO4 + INCA4
      ISTO5 = 0
      WRITE (8, 450)
  450 FORMAT (/' Enantiomorph discrimination reflections and',
     *        ' assignement of symbols', /, 5X,
     *        'H   K   L    E1  symbol    C')
      JSYMB = 0
      JSMAX = 10
      IF (IPSQ .EQ. 1) JSMAX = 15
      JSMAX = MIN0 (NIB, JSMAX)
      DO 460 I=1,NIB
      IF (JSYMB .EQ. JSMAX) GOTO 470
      K = ICC(I)
      CALL DACAS (K)
  460 CONTINUE
  470 WRITE(24, 480) JSYMB
      WRITE (8, 480) JSYMB
  480 FORMAT (' Number of ambiguity symbolic choices (primary',
     *        ' set):', I6)
      RETURN
      END
      SUBROUTINE DACEND
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      INCLUDE 'Zdiftb.inc'
      DIMENSION NLET(10), ISOL(10,2)
      CALL WR24
      FAKWS = 1.
      REDUS = .FALSE.
      IF (IPSQ.EQ.1 .AND. JSYMB.GT.3) REDUS = .TRUE.
  200 ISTA42 = ISTA4
      CALL GENERC
      CALL REAR
      CALL KERNZI (0, NLET, 10)
      CALL KERNZI (1, NLET, JSYMB)
      CALL TACCEP (NLET, NTEMP)
      IF (NTEMP .LE. 0) GOTO 211
      IF (REDUS) THEN
         KRED = 0
         CALL REDSYM (1, NLET, KRED)
         IF (KRED .EQ. 1) REDUS = .FALSE.
         GOTO 200
         ENDIF
      CALL REAR2
      CALL GENERC
      CALL REAR
  211 CALL SYMREL (ISOL)
      IF (IPSQ .EQ. 0) GOTO 320
      KBEST = ISOL(1,2)
      DO 260 J=1,JSYMB
      ISOL(J,1) = KB10X(J,KBEST)
  260 ISOL(J,2) = 0
  320 ILINK = 0
      CALL XXLINK (ISOL, ILINK)
      RETURN
      END
      SUBROUTINE REDSYM (KEY, ISTOR, K)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      INCLUDE 'Zdiftb.inc'
      COMMON /KLADC/ CHAR(12)
      CHARACTER CHAR *1
      DIMENSION ISTOR(10), ISTOR1(11,15), IHKL(3)
      LOGICAL   FIRST
      DATA FIRST / .FALSE. /
      DATA NSYMB, KTEST, ISMAX / 0, 0, 0 /
      IF (KEY .EQ. -1) THEN
         FIRST = .FALSE.
         RETURN
         ENDIF
      IF (FIRST) GOTO 200
      ISMAX = 1
      KTEST = 0
      NSYMB = 0
      FIRST = .TRUE.
  200 IF (KEY .EQ. 1) GOTO 210
      NSYMB = NSYMB + 1
      CALL KERNAI (ISTOR(1), ISTOR1(1,NSYMB), 10)
      ISTOR1(11,NSYMB) = K
      RETURN
  210 CONTINUE
      WRITE (8, FMT='('' Reduced ambiguity choices'', //,
     *       5X, ''H   K   L    E1  Symbol'')')
      KTEST = KTEST + 1
      MSYMB = 0
      ISTO4 = ISTA4 - INCA4
      ISTO5 = 0
      DO 250 I=MCT,NCT,ICR
  250 ITAB(I+6) = 0
      DO 270 I=1,JSYMB
      K = ISTOR1(11,I)
      IF (ISTOR(I) .LE. ISMAX) THEN
          ITAB(K+2) = ISTOR1(2,I)
          ITAB(K+3) = ISTOR1(3,I)
          ITAB(K+4) = ISTOR1(4,I)
          IF (ITAB(K+2) .GE. 0) ITAB(K+4) = 0
          ITAB(K+7) = ISTOR1(7,I)
          ISTOR1(11,I) = -1
          GOTO 270
      ENDIF
      MSYMB = MSYMB + 1
      CALL KERNAI (ISTOR1(8,I), IHKL, 3)
      CALL IITAB4 (IHKL,K)
      ITAB(K+3) = 0
      ITAB(K+4) = 1000
      ISTO5 = ISTO5 + INCA5
      ITAB(K+6) = (ISTO5) / 5
      ITAB5(ISTO5+1) = 32767
      ITAB5(ISTO5+4) = 0
      ITAB5(ISTO5+5) = MSYMB
      E1 = FLOAT(ISTOR1(7,I)) / 100.
      WRITE (8, 260) IHKL, E1, CHAR(MSYMB)
  260 FORMAT (2X, 3I4, F7.2, 4X, A1)
  270 CONTINUE
      K = 1
      IF (NSYMB .LE. JSYMB) GOTO 350
      DO 280 I=JSYMB+1,NSYMB
      K = ISTOR1(11,I)
      MSYMB = MSYMB + 1
      CALL KERNAI (ISTOR1(8,I), IHKL, 3)
      CALL IITAB4 (IHKL, K)
      ITAB(K+3) = 0
      ITAB(K+4) = 1000
      ITAB(K+7) = -ITAB(K+7)
      ITAB(K+2) =  ITAB(K+7)
      ISTO5 = ISTO5 + INCA5
      ITAB(K+6) = ISTO5 / 5
      ITAB5(ISTO5+1) = 32767
      ITAB5(ISTO5+4) = 0
      ITAB5(ISTO5+5) = MSYMB
      E1 = FLOAT(ISTOR1(7,I)) / 100.
      WRITE (8, 260) IHKL, E1, CHAR(MSYMB)
  280 IF (MSYMB .EQ. JSYMB) GOTO 290
  290 K = 0
      I = 0
  310 I = I + 1
  320 IF (ISTOR1(11,I) .GT. 0) GOTO 340
      NSYMB = NSYMB - 1
      DO 330 J=I,NSYMB
  330 CALL KERNAI (ISTOR1(1,J+1), ISTOR1(1,J), 11)
      GOTO 320
  340 IF (I .LE. JSYMB) GOTO 310
  350 JSYMB = MSYMB
      DO 360 I=ISTO4+INCA4+1,ISIZ
  360 ITAB(I) = 0
      DO 370 I=ISTO5+INCA5+1,5*ISIZ5
  370 ITAB5(I) = 0
      WRITE(24, 380) JSYMB
      WRITE (8, 380) JSYMB
  380 FORMAT (' Number of ambiguity symb. choices (reduced sec.',
     *         'set):', I5)
      IF (KTEST .EQ. 2) K = 1
      RETURN
      END
      SUBROUTINE SYMREL (ISOL)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      INCLUDE 'Zdiftb.inc'
      COMMON /KLAD/ ICODE(4,48), ISHIFT(48)
      COMMON /KLADC/ CHAR(12)
      CHARACTER CHAR *1
      DIMENSION I2XI(2,10), IXI(10), ISOL(10,2), IXXI(40)
      EQUIVALENCE (IXXI(11), IXI(1)), (IXXI(21), I2XI(1,1))
      DIMENSION KSY(10), KA(1023), KAA(1024), KAAA(1025)
      EQUIVALENCE (KA(1), KAA(2), KAAA(3))
      DIMENSION KBB(110), LET1(4)
      DATA KBMAX1, KBMAX2 / 0, 0 /
      WRITE(24, 200)
      WRITE (8, 200)
  200 FORMAT (/' Analysis of the symbolic phases  A, B, ....')
      FAK = 2. / E000R
      CALL KERNZI (0,   IXXI,  40)
      CALL KERNZI (0,  KB10X, 15*25)
      CALL KERNZI (0, KB10XX, 15*25)
      IC123 = 0
      KAAA(1) = JSYMB
      KMAX = 2**JSYMB
      KSY(1) = KMAX / 2
      DO 210 I=2,JSYMB
  210 KSY(I) = KSY(I-1) / 2
      CALL KERNZI (0, KAA, KMAX)
      CALL KERNZI (0, KBB, 110)
      DO 370 K=MCT,NCT,ICR
      K51 = ITAB(K+6)
      IF (K51 .EQ. 0) GOTO 370
      IF (IDC .GT. 1) GOTO 220
      ITIP = ITAB(K+5)
      IF (ITIP.GE.0 .OR. ITAB(K+2).LT.0) GOTO 220
      IF (ITIP.GT.-4 .OR. ITIP.LT.-8) GOTO 370
  220 I51 = K51*INCA5
      IF (ITAB(K+2).LT.0 .AND. ITAB(K+7).GT.0) GOTO 320
      GOTO 240
  230 K51 = IITAB5(I51,I51)
  240 IF (IITAB5(I51,I52) .EQ. 0) GOTO 370
      IF (ITAB5(I51+1) .NE. 32767) THEN
          IE1 = ALPS(I51)
          IF (IE1 .LE. 0) GOTO 230
          IP1 = ITAB5(I51+2)
          ELSE
          IP1 = ITAB(K+3)
          IE1 = 32767 * FAK
      ENDIF
      ICOL1 = ITAB5(I51+5)
      CALL DECOL2 (ICOL1, LET1)
      IC1 = IABS(LET1(1))
      IC3 = IABS(LET1(2))
      IADR1 = KSY(IC1)
      IF (IC1 .EQ. IC3) GOTO 230
      IF (IC3.NE.0 .AND. IDC.EQ.1) GOTO 230
      IF (IC3 .GT. 0) IADR1 = IADR1 + KSY(IC3)
      IF (IC3 .NE. 0) GOTO 280
      IP2 = ITAB(K+3)
      CALL PHDIF (IP2, IP1, IP12, IP2)
      I = MIN0(IP2,180-IP2)
      IF (I .LT. 5) GOTO 280
      I = ISIGN(I,IP12)
      Q = ITAB(K+2)
      IF (Q .LT. 2.5) GOTO 280
      I = FLOAT(I * IE1) * SQRT(Q) /100.
      IXXI(IC1) = IXXI(IC1) + ISIGN(1,ICOL1) * I
      GOTO 280
  270 IF (IITAB5(I52,I52) .EQ. 0) GOTO 230
  280 IE2 = ALPS(I52)
      IE2 = IALP(IE1,IE2)
      IF (IE2 .LE. 0) GOTO 270
      IP2 = ITAB5(I52+2)
      ICOL2 = ITAB5(I52+5)
      CALL DECOL2 (ICOL2, LET1)
      IC2 = IABS(LET1(1))
      IC4 = IABS(LET1(2))
      IADR2 = KSY(IC2)
      IF (IC3.NE.0 .AND. IC4.NE.0) GOTO 270
      IF (IC4 .GT. 0) IADR2 = IADR2 + KSY(IC4)
      IF (IC2 .EQ. IC4) GOTO 270
      CALL PHDIF (IP1, IP2, IP12, IP2)
      IE2 = IE2 * (90-IP2)
      IF (ICOL1+ICOL2 .EQ. 0) GOTO 310
      IADR = IADR1 + IADR2
      IF (IC3.EQ.0 .AND. IC4.EQ.0) GOTO 300
      IC123 = IC123 + 1
      IF (IC4 .EQ. 0) GOTO 290
      IF (IC2.EQ.IC1 .OR. IC4.EQ.IC1) IADR = IADR - 2*KSY(IC1)
      GOTO 300
  290 IF (IC1.EQ.IC2 .OR. IC3.EQ.IC2) IADR = IADR - 2*KSY(IC2)
  300 KA(IADR) = KA(IADR) + IE2
      IF (IDC .EQ. 4) GOTO 270
      IF (IC3.NE.0 .OR. IC4.NE.0) GOTO 270
      IF (ICOL1*ICOL2 .LT. 0) IE2 = -IE2
      I = 10*IC1 + IC2
      KBB(I) = KBB(I) + IE2
      GOTO 270
  310 I2XI(2,IC1) = I2XI(2,IC1) + IABS(IE2)
      I2XI(1,IC1) = I2XI(1,IC1) + IE2
      GOTO 270
  320 IP1 = ITAB(K+3)
      GOTO 340
  330 IF (IITAB5(I51,I51) .EQ. 0) GOTO 370
  340 IP2 = ITAB5(I51+2)
      ICOL1 = ITAB5(I51+5)
      IC1 = IABS(ICOL1)
      EI2 = ALPS(I51) * 0.25
      IF (EI2 .LT. 0.) GOTO 330
      CALL PHDIF (IP1, IP2, IP12, IP2)
      IE2 = EI2 * (90.-FLOAT(IP2))
      IF (IC1 .GT. 10) GOTO 350
      IXI(IC1) = IXI(IC1) + IE2
      I = MIN0(IP2,180-IP2)
      IF (I .LT. 5) GOTO 330
      Q = ISIGN(I,IP12)
      IE2 = EI2 * Q
      IXXI(IC1) = IXXI(IC1) + ISIGN(1,ICOL1) * IE2
      GOTO 330
  350 CALL DECOL2 (ICOL1, LET1)
      IC1 = IABS(LET1(1))
      IC2 = IABS(LET1(2))
      IF (LET1(1) .EQ. LET1(2)) GOTO 360
      IADR = KSY(IC1) + KSY(IC2)
      KA(IADR) = KA(IADR) + IE2
      IF (IDC .EQ. 4) GOTO 330
      IF (LET1(1)* LET1(2).GT.0) IE2 = -IE2
      I = 10*IC1 + IC2
      KBB(I) = KBB(I) + IE2
      GOTO 330
  360 I2XI(2,IC1) = I2XI(2,IC1) + IABS(IE2)
      I2XI(1,IC1) = I2XI(1,IC1) + IE2
      GOTO 330
  370 CONTINUE
      IF (IDC .EQ. 1) GOTO 400
      WRITE (8, 380) IC123
  380 FORMAT (' ', I5, ' 3-letter-relations used')
      CALL SYMANA (0, IXI, KAAA, KSY, KB10X, KBMAX1)
      IF (IPSQ .EQ. 0) WRITE(24, 390)
      IF (IPSQ .EQ. 0) WRITE (8, 390)
  390 FORMAT (' ***** Origin fixed *****')
  400 IF (IDC .EQ. 4) GOTO 430
      CALL KERNZI (0, KAA, KMAX)
      DO 410 I=1,JSYMB
      DO 410 J=1,JSYMB
      IF (I .EQ. J) GOTO 410
      IC1 = 10*I + J
      IADR = KSY(I) + KSY(J)
      KA(IADR) = KA(IADR) + KBB(IC1)
  410 CONTINUE
      CALL SYMANA (90, IXXI, KAAA, KSY, KB10XX, KBMAX2)
      IF (IDC.EQ.2 .OR. IPSQ.EQ.0) GOTO 425
      WRITE (8, 420)
  420 FORMAT (' ***** Enantiomorph fixed *****')
  425 IF (IDC .GT. 1)  ESTAR1 = ESTART(1) - 0.1
  430 IF (IPSQ .EQ. 0) GOTO 460
      KBMAX1 = MAX0 (KBMAX1, 1)
      KBMAX2 = MAX0 (KBMAX2, 1)
      KBMAX = KBMAX1 * KBMAX2
      KBMAX = MIN0 (KBMAX, 25)
      ILDUMP = 0
      CALL DAFOMS (KBMAX, E1100, NR, 0., 0., 0, ILDUMP)
      IF (IDC .NE. 1) GOTO 450
      DO 440 I=1,KBMAX2
  440 CALL KERNAI (KB10XX(1,I), KB10X(1,I), 12)
  450 CALL SOLCOM (KBMAX1, KBMAX2, KB10X, KB10XX, IDC, JSYMB)
      ILINK = 0
      ELDAF = 0.0
      IPHDAF = 0
      CALL DAFOMS (0, ELDAF, IPHDAF, 0., 0., 0, ILINK)
      ILINK = MAX0 (ILINK, 1)
      ISOL(1,2) = ILINK
      DO 455 I=1,JSYMB
  455 ISOL(I,1) = KB10X(I,ILINK)
      GOTO 600
  460 DO 470 I=1,JSYMB
      IXI(I) = KB10X(I,1)
  470 IXXI(I) = KB10XX(I,1)
      IF (IDC .EQ. 1) CALL KERNAI (IXXI, IXI, 10)
      IF (IDC .EQ. 4) CALL KERNAI (IXI, IXXI, 10)
      J = IDC - 1
      DO 480 I=1,JSYMB
      IF (IXI(I).EQ.0 .AND. IXXI(I).EQ.270) IXI(I) = 360
  480 ISOL(I,1) = (IXI(I) + J * IXXI(I)) / IDC
  600 IF (IPSQ .EQ. 0) THEN
         WRITE(24, 610)
         WRITE (8, 610)
  610    FORMAT (' Results of the symbolic addition method for',
     *           ' the symbolic phases:')
      ELSE
         WRITE(24, 620)
         WRITE (8, 620)
  620    FORMAT(' Results of the PSI0 and negative quartet FOMs',
     *           ' for the symbolic phases:')
         ENDIF
      WRITE(24, 630) (CHAR(I), ISOL(I,1), I=1,JSYMB)
      WRITE (8, 630) (CHAR(I), ISOL(I,1), I=1,JSYMB)
  630 FORMAT (3X, 10(A1,'=',I3,2X))
      RETURN
      END
      SUBROUTINE SYMANA (KEY, KB, KAAA, KSY, KB10, KBMAXX)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      INCLUDE 'Zdiftb.inc'
      COMMON /KLAD/  ICODE(4,48), ISHIFT(48)
      DIMENSION KB(10), KAAA(1025), KSY(10), K10(2,200)
      DIMENSION KB10(15,25)
      DATA KADR / 0 /
      CALL KERNZI (0,    K10, 2*200)
      CALL KERNZI (0,   KB10, 15*25)
      K5 = 1
      IF (IPSQ .EQ. 1) K5 = 25
      KBMAXX = 0
      KX = 2**JSYMB + 1
      DO 200 I=1,JSYMB
      IADR = KSY(I) + 2
  200 KAAA(IADR) = KAAA(IADR) + KB(I)/10
      K = 0
      DO 210 I=2,KX
  210 K = K + IABS(KAAA(I))
      IF (K .GT. 0) GOTO 230
      WRITE(24, 220)
  220 FORMAT (/' ***** ERROR: no symbol relations; rerun PHASEX', /,
     *        ' *****        with lower E-min values   *********' /)
      GOTO 250
  230 Q = 32001. / FLOAT(K)
      DO 240 I=2,KX
  240 KAAA(I) = FLOAT(KAAA(I)) * Q
      CALL SYMAN (KAAA)
  250 KMAX = -32100
      DO 260 J=2,KX
      IF (KAAA(J) .LT. KMAX) GOTO 260
      KMAX = KAAA(J)
      KADR = J
  260 CONTINUE
      MAXR = KMAX * 100 / 32000
      MAXADR = KADR - 2
      KMIN = MIN0 (KMAX, 22400) * 7 / 10
      KBMAX1 = 1
      IF (IPSQ .EQ. 0) THEN
          K10(1,1) = KMAX
          K10(2,1) = KADR
          GOTO 305
      ENDIF
      DO 300 I=2,KX
      IF (KAAA(I) .LE. KMIN) GOTO 300
      DO 270 J=1,KBMAX1
      IF (KAAA(I) .LE. K10(1,J)) GOTO 270
      JJ = J
      GOTO 280
  270 CONTINUE
      GOTO 300
  280 DO 290 K=KBMAX1,JJ+1,-1
      K10(1,K) = K10(1,K-1)
  290 K10(2,K) = K10(2,K-1)
      K10(1,JJ) = KAAA(I)
      K10(2,JJ) = I
      KBMAX1 = KBMAX1 + 1
      IF (KBMAX1 .GT. 200) KBMAX1 = 200
  300 CONTINUE
      IF (KBMAX1 .NE. 200) KBMAX1 = KBMAX1 - 1
  305 DO 360 J=1,KBMAX1
      KADR = K10(2,J)
      MAXADR = KADR - 2
      K = K10(1,J)
      MAXR = K * 100 / 3200
      DO 320 I=1,JSYMB
      JJ = MAXADR / KSY(I)
      IF (JJ .EQ. 0) GOTO 310
      KB(I) = KEY + 180
      MAXADR = MAXADR - KSY(I)
      GOTO 320
  310 KB(I) = KEY
  320 CONTINUE
      JLINK = -J
      IF (IPSQ .EQ. 0) THEN
         JLINK = J
      ELSE
         CALL PHCOM1 (KB, JLINK)
         ENDIF
      IF (JLINK .EQ. J) THEN
         KBMAXX = KBMAXX + 1
         CALL KERNAI (KB, KB10(1,KBMAXX), 10)
         KB10(11,KBMAXX) = J
         KB10(12,KBMAXX) = MAXR
         IF (KBMAXX .EQ. K5) RETURN
         ENDIF
  360 CONTINUE
      RETURN
      END
      SUBROUTINE XXLINK (ISOL, ILINK)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zbuff.inc'
      LOGICAL        SWIPRI
      EQUIVALENCE   (SWIPRI, SWITCH(10))
      EQUIVALENCE (IBINDO, IFILE(13))
      INCLUDE 'Zdifta.inc'
      INCLUDE 'Zdiftb.inc'
      COMMON /SINCOS/ IDEG(8), ISCT
      INTEGER*2 ISCT(450)
      DIMENSION IHKL(3), ISOL(10,2)
      COMMON /EPWCO/ IP1, IPHS, IREST, IT, W1, WS, E1, E2, EL, EEE
      DIMENSION ITYP(4)
      CHARACTER LETT(4) *2, LITOUT *25
      DATA LETT  / '. ', 'S ', '* ', '*S' /
      DATA NLINPR / 0 /
      EEESUM = 0.
      ABSUM = 0.
      AB1SUM = 0.
      CALL KERNZI (0, ITYP, 4)
      NUMK = 0
      MAXA4 = ISIZ
      ESTAR1 = ESTART(1) + 0.1
      ISTO4 = MARKA4
      IF (ILINK.EQ.0 .AND. MS.LT.700) MAXA4 = MAXA4 + (700-MS)*INCA4
      ISW = 0
      IF (ILINK .NE. 0) ISW = 1
      EB = 100. * E000R
      ISL = 0
      IF (SWIPRI) ISL = 1
      SWIPRI = .FALSE.
      CALL BINIFF (1, IBINDO, 'BINDOP', FITDOP, NITDOP, BUFDOP, KENDOP)
      IF (ISL .EQ. 1) SWIPRI = .TRUE.
      IF (.NOT.SWIPRI .OR. ILINK.NE.0) GOTO 230
      WRITE (8, 200) ESTAR1
  200 FORMAT (' Results from DIRDIF.Special (end of PHASEX cycle 0),',
     *        ' max. 300 refl. printed' /
     *     /  ' * = accepted for basic set:  W1.gt.0.16, EL.gt.', F4.2)
      IF (IDC .NE. 4) WRITE (8, 210)
  210 FORMAT (' S = special reflection (two possible phase values)')
      WRITE (8, 220)
  220 FORMAT (/1X, 5('  H  K  L  EL   PL   WS  ') /)
      NLINPR = 0
      CHOUT = '(5A25)'
      CALL LINPRX (8, LITOUT, 25, 5)
  230 IREFL = 0
      DO 320 K=MCT,NCT,ICR
      LET = 1
      CALL BINIFF (0, IBINDO, 'BINDOP', FITDOP, NITDOP, BUFDOP, KENDOP)
      IF (KENDOP .LT. 0) GOTO 330
      IREFL = IREFL + 1
      CALL KERF2I (FITDOP(1), IHKL(1), 3)
      E1     = FITDOP(4)
      IF (ILINK.GT.0 .AND. E1.LE.E1MIN) GOTO 320
      E2     = FITDOP(5)
      IP1    = NINT(FITDOP(6))
      W1     = FITDOP(7)
      IT     = FITDOP(8)
      IREST  = NINT(FITDOP(9))
      NUMK = NUMK + 1
      EL = E1
      WS = W1
      IF (IP1 .LE. 0) IP1 = IP1 + 360
      IPHS = IP1
      K51 = ITAB(K+6)
      KEY = 1
      IF (K51 .EQ. 0) GOTO 280
      LIBS = 0
      KEY = 2
      AEE = 0.0
      BEE = 0.0
      I51 = K51*INCA5
      GOTO 245
  240 I51 = K51*INCA5 + I51
  245 IP  = ITAB5(I51+2)
      EEE = ITAB5(I51+1)
      IF (EEE .LT. 32766.) GOTO 250
      EEE = EB
      IP = ITAB(K+3)
  250 ICOL = ITAB5(I51+5)
      I = IABS(ICOL)
      IF (I .GT. JSYMB) GOTO 260
      KEY = 3
      IP = IP + ISIGN(ISOL(I,1),ICOL)
      IP = MOD(IP,360)
      IF (IP .LE. 0) IP = IP + 360
      AEE = AEE + EEE*ISCT(450-IP)/1000.
      BEE = BEE + EEE*ISCT(IP)/1000.
      EEESUM = EEESUM + EEE
      LIBS = LIBS + 1
  260 K51 = ITAB5(I51+4)
      IF (K51 .NE. 0) GOTO 240
      IF (LIBS .EQ. 0) GOTO 280
      ITYP(4) = ITYP(4) + LIBS
      EEE = SQRT(AEE*AEE + BEE*BEE)
      ABSUM = ABSUM + EEE
      WW = W1 / 1000.
      IF (ITAB(K+2).LT.0 .AND. ITAB(K+7).GT.0) GOTO 270
      IF (IT .NE. 1) GOTO 270
      WW = WW*2. / IDC3**2
  270 AEE = (AEE + EEE*ISCT(450-IP1)*WW)/10.
      BEE = (BEE + EEE*ISCT(IP1)*WW)/10.
      EEE = SQRT(AEE*AEE + BEE*BEE)
      IF (EEE .LT. 0.001) AEE = 0.1
      PHS = ATAN2(BEE,AEE) * 57.2958
      IF (PHS .LT. 0.) PHS = PHS + 360.
      IPHS = PHS + 0.5
      WS = TANH(EEE/E000R)**2
      CALL EPW
      AB1SUM = AB1SUM + EEE
      WS = AMAX1 (W1, WS)
  280 IF (IT .EQ. 1) THEN
         E2AG(7) = E2AG(7) + EL*EL
      ELSE
         E2CG(7) = E2CG(7) + EL*EL
         ENDIF
      IF (ILINK .EQ. 0) THEN
         ITAB(K+2) = 100.*EL*WS + 0.5
         ITAB(K+3) = IPHS
         ITAB(K+7) = 100.*EL + 0.5
      ELSE
         CALL PHCOM2 (IPHS, ILINK)
         ENDIF
      ITYP(KEY) = ITYP(KEY) + 1
      IF (EL.LT.ESTAR1 .OR. WS.LT.0.16) GOTO 290
      IF (ISW .EQ. 1) GOTO 290
      IF (ISTO4 .GT. MAXA4) GOTO 300
      IF (ILINK .EQ. 0) CALL IITAB4 (IHKL, K)
      LET = LET + 2
  290 ITAB1 = ITAB(K+1)
      IF (ILINK .EQ. 0) THEN
         ITAB(K+4) = 0
         ITAB(K+5) = 0
         ITAB(K+6) = 0
         IF (ITAB(K+7) .LT. 0) ITAB(K+7) = -ITAB(K+7)
      ELSE
         CALL DAFOMS (ITAB1, EL, IPHS, WS, E1, IREFL, ILINK)
         ENDIF
      IF (.NOT.SWIPRI .OR. ILINK.GT.0) GOTO 320
      IF (IT.NE.1 .AND. IDC.NE.4) LET = LET + 1
      IF (SWIPRI .AND. NLINPR.LT.300) THEN
         NLINPR = NLINPR + 1
         WRITE (LITOUT, FMT='(1X, 3I3, F5.2, I4, A2, F4.2)')
     *                        IHKL, EL, IPHS, LETT(LET), WS
         CALL LINPRX (0, LITOUT, 25, 5)
      ENDIF
      GOTO 320
  300 WRITE(24, 310)
  310 FORMAT(' ******** WARNING: the basic set is not complete' )
      ISW = 1
      GOTO 290
  320 CONTINUE
  330 IF (SWIPRI .AND. ILINK.EQ.0) CALL LINPRX (-1, LITOUT, 25, 5)
      E2AG(7) = (E2AG(7) + E2ALE) / MAX0(1,NGN)
      E2CG(7) = (E2CG(7) + E2CLE) / MAX0(1,NSP)
      IF (EEESUM .LT. 0.0001) EEESUM = 1.
      C1EE = 10. * AB1SUM / EEESUM
      IF (ILINK .EQ. 0) GOTO 336
      ISOL(1,2) = NINT(C1EE*1000.)
      I2000 = -2000
      CALL PHCOM2 (IPHS, I2000)
      ILINK = I2000
      RETURN
  336 ITYP(3) = MAX0(1, ITYP(3))
      WW = FLOAT(ITYP(4)) / ITYP(3)
      WRITE (8, 340) (ITYP(I),I=1,3), WW
  340 FORMAT (/' Number of refl. without symbolic phase: ', I11 /
     *        ' Number of refl. without single-letter phase: ', I6 /
     *        ' Number of refl. with N single-letter phases: ', I6 /
     *        ' (N = 1 or more,  average N =  ', F5.2, ' )')
      MAXA4 = ISIZ - INCA4
      MS = (ISTO4-MARKA4) / INCA4
      WRITE (8, 350) MS
  350 FORMAT (/' Number of refl. in new basic set: ', I5 )
      RETURN
      END
      SUBROUTINE SOLCOM (KBMAX1, KBMAX2, KB10X, KB10XX, IDC, JSYMB)
      INCLUDE 'Zsyst.inc'
      PARAMETER (KBMAX = 25)
      DIMENSION KB10X(15,KBMAX), KB10XX(15,KBMAX), IXI(10), IXXI(10),
     *          IX(10,2), KBXX(15,KBMAX)
      COMMON /SOLCPC/ KBTEMP(12,KBMAX*KBMAX), KBORD(12,KBMAX*KBMAX)
      WRITE (8, FMT='(I6, '' solutions for the symmetrical'',
     *                   '' part '')') KBMAX1
      CALL PHCOM2 (0, 0)
      ICONS2 = 0
      CALL KERNZI (0, KBXX, 15*KBMAX)
      IF (IDC.EQ.2 .OR. IDC.EQ.3) GOTO 240
      ICONS1 = KB10X (12,1)
      KBMAX1 = MAX0 (KBMAX1, KBMAX2)
      IACC = 0
      DO 230 I=1,KBMAX1
      DO 210 J=1,JSYMB
  210 IX(J,1) = KB10X(J,I)
      ILINK = I
      CALL XXLINK (IX, ILINK)
      IF (ILINK .NE. I) GOTO 230
      IACC = IACC + 1
      CALL KERNAI (IX(1,1), KBXX(1,IACC), JSYMB)
      KBXX(11,IACC) = I
      CI = FLOAT(KB10X (12,I)) / FLOAT(ICONS1)
      KBXX(12,IACC) = NINT(CI * 1000.)
      KBXX(13,IACC) = IX(1,2)
      ICONS2 = MAX0 (ICONS2, IX(1,2))
  230 CONTINUE
      GOTO 330
  240 WRITE (8, FMT='(I6, '' solutions for the'',
     *       '' antisymmetrical part '')')  KBMAX2
      WRITE (8, FMT='(1X)')
      CALL KERNZI (0, KBTEMP, 12*KBMAX*KBMAX)
      CALL KERNZI (0, KBORD,  12*KBMAX*KBMAX)
      JDC = IDC - 1
      JALL = 0
      CONMAX = FLOAT (KB10X(12,1) + KB10XX(12,1)) / 1000.
      DO 252 I=1,KBMAX1
      CALL KERNAI (KB10X(1,I), IXI(1), JSYMB)
      DO 251 J=1,KBMAX2
      CALL KERNAI (KB10XX(1,J), IXXI(1), JSYMB)
      JALL = JALL + 1
      KBTEMP(11,JALL) = JALL
      CONS = FLOAT (KB10X(12,I) + KB10XX(12,J)) / CONMAX
      KBTEMP(12,JALL) = NINT (CONS)
      DO 250 IN=1,JSYMB
      IXI1 = IXI(IN)
      IF (IXI1.EQ.0 .AND. IXXI(IN).EQ.270) IXI1 = 360
      KBTEMP(IN,JALL) = (IXI1 + JDC*IXXI(IN)) / IDC
  250 CONTINUE
  251 CONTINUE
  252 CONTINUE
      JJ = 1
      DO 300 I=1,JALL
      IF (I .EQ. 1) GOTO 290
      DO 260 J=1,I-1
      IF (KBTEMP(12,I) .LT. KBORD(12,J)) GOTO 260
      JJ = J
      GOTO 270
  260 CONTINUE
      JJ = I
      GOTO 290
  270 DO 280 K=I,JJ+1,-1
  280 CALL KERNAI (KBORD(1,K-1), KBORD(1,K), 12)
  290 CALL KERNAI (KBTEMP(1,I), KBORD(1,JJ), 12)
  300 CONTINUE
      JSOL = 0
      IACC = 0
      DO 320 I=1,JALL
      CALL KERNAI (KBORD(1,I), IX(1,1), JSYMB)
      JSOL = JSOL + 1
      ISOL = JSOL
      CALL XXLINK (IX, ISOL)
      IF (JSOL .EQ. ISOL) THEN
         IACC = IACC + 1
         CALL KERNAI (IX(1,1), KBXX(1,IACC), JSYMB)
         KBXX(11,IACC) = KBORD(11,I)
         KBXX(12,IACC) = KBORD(12,I)
         ELSE
         GOTO 320
         ENDIF
      KBXX(13,IACC) = IX(1,2)
      ICONS2 = MAX0 (ICONS2, IX(1,2))
      IF (IACC .EQ. KBMAX) GOTO 330
  320 CONTINUE
  330 CALL KERNZI (0, KB10X, 15*KBMAX)
      DO 340 I=1,IACC
      CALL KERNAI (KBXX(1,I), KB10X(1,I), 15)
      CI = FLOAT(KB10X(13,I)) / FLOAT(ICONS2)
  340 KB10X(13,I) = NINT(CI * 1000.)
      KBMAX1 = IACC
      IF (IDC.EQ.2 .OR. IDC.EQ.3) THEN
        WRITE (8, FMT='(/I5, '' combined solutions'',
     *       '' (symmetrical and antisymmetrical part)'')') KBMAX1
      ELSE
         WRITE (8, FMT='(1X)')
         ENDIF
      WRITE (8, FMT='(5X, ''    A    B    C    D    E    F    G'',
     *                 ''    H    I    J   No CONS1 CONS2'',/,
     *                  (I3, '') '', 13I5))')
     *                  (I1, (KB10X(I13,I1), I13=1,13), I1=1,KBMAX1)
      RETURN
      END
      SUBROUTINE PHCOM1 (KB, ICOM)
      INCLUDE 'Zaaaa.inc'
      LOGICAL SWIPRI
      EQUIVALENCE (SWIPRI, SWITCH(10))
      INCLUDE 'Zdifta.inc'
      INCLUDE 'Zdiftb.inc'
      COMMON /KLADC/ CHAR(12)
      CHARACTER CHAR *1
      PARAMETER (IACC = 25)
      DIMENSION KB(10), KLET(10), PLET(10), KACC(11,IACC), LET(4)
      LOGICAL FIRST
      DATA FIRST / .FALSE. /
      DATA JACC, PMAX / 0, 0.0 /
      IF (FIRST) GOTO 250
      FIRST = .TRUE.
      CALL KERNZA (0., PLET, 10)
      CALL KERNZI (0, KLET, 10)
      NSYMB = 0
      DO 200 K=MCT,NCT,ICR
      K5 = ITAB(K+6)
      IF (K5 .EQ. 0) GOTO 200
      NSYMB = NSYMB + 1
      I5 = K5 * INCA5
      GOTO 185
  180 I5 = K5*INCA5 + I5
  185 ICOL = ITAB5(I5+5)
      I = IABS(ICOL)
      IF (I .LE. JSYMB) GOTO 186
      CALL DECOL2 (I, LET)
      I = IABS(LET(1))
      KLET(I) = KLET(I) + 1
      I = IABS(LET(2))
      KLET(I) = KLET(I) + 1
      GOTO 190
  186 KLET(I) = KLET(I) + 1
  190 K5 = ITAB5(I5+4)
      IF (K5 .NE. 0) GOTO 180
  200 CONTINUE
      NSUM = 0
      DO 210 I=1,JSYMB
  210 NSUM = NSUM + KLET(I)
      PSUM = 100. / FLOAT(NSUM)
      PMAX = 0.
      DO 220 I=1,JSYMB
      PLET(I) = FLOAT(KLET(I)) * PSUM
  220 PMAX = MAX (PLET(I), PMAX)
      WRITE (8, 230) NSYMB, (CHAR(I),I=1,JSYMB)
  230 FORMAT (' Symbol frequency for ', I5, ' reflections: ', /,
     *          10X, 10(4X,A1))
      WRITE (8, FMT='(11X, 10I5)')   (KLET(I),I=1,JSYMB)
      WRITE (8,FMT='(''   (in %) '', 1X, 10F5.1)')
     *                 (PLET(I), I=1,JSYMB)
      I = INT(PMAX)
      PMAX = FLOAT(I)
      IF (SWIPRI)
     *    WRITE (8, FMT='('' Two solutions are equal, if the symbol''
     *                     ,'' changes'', /, ''    between them are'',
     *                      '' less than '', F5.1, '' %'')') PMAX
  250 IACOM = IABS(ICOM)
      IF (IACOM .EQ. 1) THEN
         CALL KERNZI (0, KACC, 11*IACC)
         JACC = 1
         ICOM = IACOM
         CALL KERNAI (KB(1), KACC(1,JACC), JSYMB)
         KACC(11, JACC) = IACOM
         RETURN
         ENDIF
      DO 280 I=1,JACC
      PSUM = 0.
      DO 260 J=1,JSYMB
      IDIF = IABS(KACC(J,I) - KB(J))
      DIF  = FLOAT (IDIF)
      MULT = MIN (1.0, DIF)
  260 PSUM = PSUM + FLOAT(MULT) * PLET(J)
      IF (PSUM.LT.PMAX) RETURN
  280 CONTINUE
      ICOM = IACOM
      JACC = JACC + 1
      IF (JACC .GT. IACC) CALL KERROR ('Too many solutions',0, 'PHCOM1')
      CALL KERNAI (KB(1), KACC(1,JACC), JSYMB)
      KACC(11, JACC) = IACOM
      RETURN
      END
      SUBROUTINE PHCOM2 (IPHS, ILINK)
      INCLUDE 'Zsyst.inc'
      INCLUDE 'Zcrys.inc'
      LOGICAL EXPAND
      EQUIVALENCE (EXPAND, SWITCH(23))
      PARAMETER (NIPH = 1000, KBMAX = 25,
     *           MAXD1 = 10,  MAXD2 = 15)
      COMMON /PHC2PC/
     *          IPH(NIPH,KBMAX), IDIF(KBMAX), NDIF(KBMAX)
      DATA JSOL, NPH, JLINK, MAXDIF / 0, 0, 0, 0  /
      IF (ILINK .NE. 0) GOTO 200
      MAXDIF = MAXD2
      IF (ICENT.EQ.1 .OR. EXPAND) MAXDIF = MAXD1
      CALL KERNZI (0, IPH,  NIPH*KBMAX)
      CALL KERNZI (0, IDIF,      KBMAX)
      NPH  = 0
      JSOL = 1
      RETURN
  200 IF (ILINK .EQ. -2000) GOTO 220
      IF (JSOL .GT. KBMAX)
     *    CALL KERROR (' To much solutions stored', 0, 'PHCOM2')
      NPH = NPH + 1
      IF (NPH .GT. NIPH) THEN
          NPH = NIPH
          RETURN
      ENDIF
      JLINK = ILINK
      IPH(NPH,JSOL) = IPHS
      RETURN
  220 IF (JLINK .EQ. 1) GOTO 270
      DO 230 I=1,JSOL-1
      DO 230 J=1,NPH
      IPH12 = IABS (IPH(J,I) - IPH(J,JSOL))
      IF (IPH12 .GT. 180) IPH12 = 360 - IPH12
  230 IDIF(I) = IDIF(I) + IPH12
      ITEST = 0
      DO 260 I=1,JSOL-1
      MDIF = IDIF(I) / NPH
      IF (MDIF .LT. MAXDIF) ITEST = -1
      IF (ITEST .EQ. -1) GOTO 265
  260 CONTINUE
      GOTO 270
  265 ILINK = -ILINK
      ELDAF = 0.0
      IPHDAF = 0
      CALL DAFOMS (0, ELDAF, IPHDAF, 0., 0., 0, -1)
      GOTO 280
  270 NDIF(JSOL) = JLINK
      JSOL = JSOL + 1
      ILINK = JLINK
  280 NPH = 0
      CALL KERNZI (0, IDIF, KBMAX)
      RETURN
      END
      SUBROUTINE GENERC
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      INCLUDE 'Zdiftb.inc'
      COMMON /SINCOS/ IDEG(8), ISCT
      COMMON /KLAD/   ICODE(4,48), ISHIFT(48)
      INTEGER*2 ISCT(450)
      DIMENSION IHKL(3), IHKL3(3),  LHIT(48)
      EQUIVALENCE (IHKL3(1),  JJH1), (IHKL3(2),  JJH2), (IHKL3(3),JJH3),
     *            (MAXHKL(1), MAXH), (MAXHKL(2), MAXK), (MAXHKL(3),MAXL)
      DIMENSION LET1(4), LET1R(4), LET2(4)
      DATA K, NUMB, KTEST / 0, 0, 0/
      MAXA5 = ISIZ5*INCA5 - INCA5
      IF (ISTA4 .EQ. ISTA42) NUMB = 0
      NUMBM = MAXA5 / INCA5
      IF (NUMBM .GT. ISIZ5+INCA5) NUMBM = ISIZ5 - INCA5
      ISTR1 = ISTA42
      ISTR2 = MARKA4 + INCA4
      MAX5  = MAXA5  - INCA5
      ICENTR = 2*IICENT - 3
      CALL KERNZI (0,  LET1, 4)
      CALL KERNZI (0, LET1R, 4)
      CALL KERNZI (0,  LET2, 4)
      DO 390 I41=ISTR1,ISTO4,INCA4
      DO 200 I=1,3
  200 IHKL(I) = ITAB(I41+I)
      NEQ = 2
      CALL SYMEQ (IHKL, NEQ)
      IR1  = ITAB(I41+4) + MCT
      IE1  = ITAB(IR1+2)
      IPH1 = ITAB(IR1+3)
      DO 210 I=1,NEQ
      IS2 = ISHIFT(I)
      ISHIFT(I) = IPH1 + IDEG(IS2)
      ISHIFT(I+NEQ) = -ISHIFT(I)
  210 CONTINUE
      K51S = ITAB(IR1+6)*INCA5 + INCA5
      ICOL1 = ITAB5(K51S)
      ICOL1R = ICENTR * ICOL1
      CALL DECOL2 (ICOL1, LET1)
      LET1R(1) = ICENTR * LET1(1)
      LET1R(2) = ICENTR * LET1(2)
      ISTOP = I41 - INCA4
      NEQ2  = NEQ * 2
      DO 380 I42=ISTR2,ISTOP,INCA4
      JH1 = ITAB(I42+1)
      JH2 = ITAB(I42+2)
      JH3 = ITAB(I42+3)
      IR2 = ITAB(I42+4) + MCT
      IF (I42 .LT. ISTA4) GOTO 220
      K52S = ITAB(IR2+6)*INCA5 + INCA5
      ICOL2 = ITAB5(K52S)
      CALL DECOL2 (ICOL2, LET2)
      CALL COLAD  (LET1,  LET2, ICOL,  IICENT)
      CALL COLAD  (LET1R, LET2, ICOLR, IICENT)
      IF (ICOL.EQ.0 .AND. ICOLR.EQ.0) GOTO 380
      GOTO 230
  220 ICOL  = ICOL1
      ICOLR = ICOL1R
  230 IPH2  = ITAB(IR2+3)
      IWEE  = IE1 * ITAB(IR2+2)
      J = ITAB(IR2+1)
      NHIT = 0
      NQQ1 = 1
      NQQ2 = NEQ
      IF (ICOL .EQ. 0) GOTO 370
  240 DO 360 I11 = NQQ1,NQQ2
      IF (MCTLAT .GT. 1) GOTO 250
      I = ICODE(4,I11)
      KTEST = I + J
      K = IABS(KTEST)
      IF (K .EQ. 0) GOTO 360
      IF (K .GT. MCT) GOTO 360
      IF (ITAB(K) .EQ. 0) GOTO 360
  250 JJH1 = ICODE(1,I11) + JH1
      IF (IABS(JJH1) .GT. MAXH) GOTO 360
      JJH2 = ICODE(2,I11) + JH2
      IF (IABS(JJH2) .GT. MAXK) GOTO 360
      JJH3 = ICODE(3,I11) + JH3
      IF (IABS(JJH3) .GT. MAXL) GOTO 360
      IF (MCTLAT .EQ. 1) GOTO 260
      KTEST = INPACK(IHKL3)
      K = IABS(KTEST)
      IF (K .EQ. 0) GOTO 360
      IF (ITAB(K) .EQ. 0) GOTO 360
  260 K = ITAB(K)
      LTEST = IABS(K)
      L = LTEST / 4096
      IR3 = (LTEST-L*4096-1)*ICR + MCT
      IF (IR3.EQ.IR2 .OR. IR3.EQ.IR1) GOTO 360
      IF (NHIT .EQ. 0) GOTO 280
      DO 270 IHIT=1,NHIT
      IF (IR3 .EQ. LHIT(IHIT)) GOTO 360
  270 CONTINUE
  280 NHIT = NHIT + 1
      LHIT(NHIT) = IR3
      L = L + 1
      ISS  = ISIGN(1,K) * ISIGN(1,KTEST)
      IPH3 = ISS * (ISHIFT(I11)+IPH2)-IDEG(L)
      IF (ISS .EQ. 1) GOTO 290
      ICOL3 = ICENTR * ICOL
      GOTO 300
  290 ICOL3 = ICOL
  300 IPH3 = MOD(IPH3,360)
      IF (IPH3 .LE. 0) IPH3 = IPH3 + 360
      K53 = ITAB(IR3+6)
      IF (K53 .NE. 0) GOTO 310
      IF (NUMB+JSYMB .GE. NUMBM) GOTO 400
      ISTO5 = ISTO5 + INCA5
      ITAB(IR3+6) = ISTO5 / INCA5
      GOTO 340
  310 I53 = K53*INCA5
      IF (ITAB5(I53+5) .NE. ICOL3) GOTO 330
      IF (ITAB5(I53+1) .EQ. 32767) GOTO 360
      GOTO 350
  320 I53 = K53*INCA5 + I53
      IF (ITAB5(I53+5) .EQ. ICOL3) GOTO 350
  330 K53 = ITAB5(I53+4)
      IF (K53 .NE. 0) GOTO 320
      IF (ISTO5.GT.MAX5 .OR. (NUMB+JSYMB).GE.NUMBM) GOTO 400
      ISTO5 = ISTO5 + INCA5
      ITAB5(I53+4)   = (ISTO5 - I53) / 5
  340 ITAB5(ISTO5+1) = IWEE * ISCT(450-IPH3)/1000000
      ITAB5(ISTO5+2) = IWEE * ISCT(IPH3)/1000000
      ITAB5(ISTO5+3) = IWEE / 1000
      ITAB5(ISTO5+4) = 0
      ITAB5(ISTO5+5) = ICOL3
      NUMB = NUMB + 1
      GOTO 360
  350 ITAB5(I53+1) = ITAB5(I53+1) + IWEE*ISCT(450-IPH3)/1000000
      ITAB5(I53+2) = ITAB5(I53+2) + IWEE*ISCT(IPH3)/1000000
      ITAB5(I53+3) = ITAB5(I53+3) + IWEE/1000
  360 CONTINUE
  370 IF (NQQ2.EQ.NEQ2 .OR. ICOLR.EQ.0) GOTO 380
      ICOL = ICOLR
      NQQ1 = NEQ+1
      NQQ2 = NEQ2
      GOTO 240
  380 CONTINUE
  390 CONTINUE
      GOTO 420
  400 WRITE (8, 410) NUMB+JSYMB, NUMBM
  410 FORMAT (/' There is not enough storage (subr. GENERC):', /,
     *        ' Number of relations (', I5, ') .GE. max. number of',
     *        ' relations (', I5, ')')
      WRITE (8, FMT='('' Generation is stopped at reflection : '',
     *       3I4, ''   (='', I4, ''. refl. in secondary set)'')')
     *      (ITAB(I41+I3), I3=1,3), (I41-ISTR1)/4
  420 WRITE(24, 430) NUMB+JSYMB
      WRITE (8, 430) NUMB+JSYMB
  430 FORMAT (' Total number of phases with symbols:', I21)
      RETURN
      END
      SUBROUTINE DECOL2 (ICOL, LET)
      DIMENSION LET(4)
      IF (IABS(ICOL) .LE. 10) GOTO 100
      LET(1) = (ICOL+220) / 21 - 10
      LET(2) = ICOL - LET(1)*21
      RETURN
  100 LET(2) = 0
      LET(1) = ICOL
      RETURN
      END
      SUBROUTINE COLAD (LET1, LET2, ICOL, ICENT)
      DIMENSION LET1(4), LET2(4)
      DATA N / 2 /
      ICOL = 0
      I1 = 1
      I2 = 1
      I = 0
  200 IF (IABS(LET1(I1)) - IABS(LET2(I2))) 210, 240, 230
  210 IF (I .EQ. N) GOTO 250
      ICOL = ICOL * 21 + LET2(I2)
      I2 = I2 + 1
  220 I = I + 1
      GOTO 200
  230 IF (I .EQ. N) GOTO 250
      ICOL = ICOL * 21 + LET1(I1)
      I1 = I1 + 1
      GOTO 220
  240 IF (LET1(I1) .EQ. 0) RETURN
      IF (ICENT.EQ.1 .AND. LET1(I1).EQ.LET2(I2)) GOTO 210
      I1 = I1 + 1
      I2 = I2 + 1
      GOTO 200
  250 ICOL = 0
      RETURN
      END
      SUBROUTINE REAR
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      INCLUDE 'Zdiftb.inc'
      FAK = 1.
      DO 260 K=MCT,NCT,ICR
      IF (ITAB(K+6) .EQ. 0) GOTO 260
      E1 = ITAB(K+7) / 100.
      IF (E1 .LT. 0.0) E1 = -E1
      J  = ITAB(K+6)*INCA5
      IMAX = J
      II = J
      IF (ITAB5(J+1) .NE. 32767) GOTO 200
      AX = 32767.
      GOTO 230
  200 AX = 0.0
  210 AEE = ITAB5(II+1)
      BEE = ITAB5(II+2)
      EEE = SQRT(AEE*AEE+BEE*BEE) * E1
      IF (EEE .LT. 0.001) AEE = 1.0
      PH3 = ATAN2(BEE,AEE)
      IEE = EEE + 1.0
      IWEE = ITAB5(II+3)*E1 + 0.5
      ITAB5(II+1) = MIN0(IEE,IWEE)
      ITAB5(II+3) = MAX0(1,IWEE)
      EEE = ALPS(II)
      IF (EEE .LE. AX) GOTO 220
      AX = EEE
      IMAX = II
  220 PH3 = PH3 * 57.2958
      IF (PH3 .LT. 0.0) PH3 = PH3 + 360.
      ITAB5(II+2) = PH3 + 0.5
  230 CONTINUE
      IJ = II
      II = ITAB5(II+4)
      IF (II .EQ. 0) GOTO 240
      II = II*INCA5 + IJ
      GOTO 210
  240 IF (J .EQ. IMAX) GOTO 260
      DO 250 I=1,5
      IF (I .EQ. 4) GOTO 250
      II = IMAX + I
      JJ = J + I
      MAX = ITAB5(II)
      ITAB5(II) = ITAB5(JJ)
      ITAB5(JJ) = MAX
  250 CONTINUE
  260 CONTINUE
      RETURN
      END
      FUNCTION ALPS (I51)
      INCLUDE 'Zdiftb.inc'
      A = ITAB5(I51+1)
      B = ITAB5(I51+3)
      ALPS = (2.*A/B - 1.) * A * FAK
      RETURN
      END
      SUBROUTINE TACCEP (NLET, NTEMP)
      INCLUDE 'Zaaaa.inc'
      LOGICAL SWIPRI
      EQUIVALENCE   (SWIPRI, SWITCH(10))
      INCLUDE 'Zdifta.inc'
      INCLUDE 'Zdiftb.inc'
      COMMON /KLAD/ ICODE(4,48), ISHIFT(48)
      COMMON /KLADC/ CHAR(12)
      CHARACTER CHAR *1
      DIMENSION IHKL(3), NLET(10), ISYMB(4), LET1(4), KARR(100)
      CHARACTER LITOUT *32
      DATA AEMIN / 0.0 /
      QEETO = QEET
  111 CONTINUE
      CALL KERNZI (0, LET1, 4)
      MAXX = (MAXA4-ISTO4) / INCA4
      IF (MAXT .GT. MAXX) MAXT = MAXX
      ISTA42 = ISTO4 + INCA4
      ISW = 1
      AMIN = 0.1
      AMAX = 5.0
  200 CALL VALDIS (-1, AMIN, AMAX, KARR, 100, NTEMP)
      FAK  = 0.2 / E000R
      FAK1 = FAK / 2.
      FAKA = FAK / 100.
      IQEET = 100. * QEET
      AMINE = 1000.
      AMAXE = 0.
  210 NTEMP = 0
      IF (ISW .NE. 3) GOTO 240
      WRITE (8, 220) AEMIN
  220 FORMAT (' For temporarily accepted reflections:',
     *        ' minimum  Alpha * E1 = ', F6.3)
      IF (.NOT. SWIPRI) GOTO 240
      WRITE (8, 230)
  230 FORMAT (/' Temporarily accepted reflections = secondary set:' /
     *        ' ', 4('  H  K  L  E1  symb.phase  W    ') /)
      CHOUT = '(4A32)'
      CALL LINPRX (8, LITOUT, 32, 4)
  240 DO 300 K=MCT,NCT,ICR
      IEW = ITAB(K+2)
      IF (IEW .LT. 0) GOTO 300
      K5 = ITAB(K+6)
      IF (K5 .EQ. 0) GOTO 300
      I5 = K5*INCA5
      IEEE = ITAB5(I5+1)
      IE = ITAB(K+7)
      IF (IDC .GT. 1) GOTO 250
      ITIP = ITAB(K+5)
      IF (ITIP .GT. -1) GOTO 250
      IF (ITIP.GT.-5 .OR. ITIP.LT.-7) GOTO 300
  250 IF (IE .GT. 399) GOTO 300
      I = IQEET * ITAB5(I5+3)
      IF (I .GT. 100*IEEE) GOTO 300
      AE = IE * IEEE
      AE = AE * FAKA
      IF (ISW .GE. 2) GOTO 260
      CALL VALDIS (0, AE, 0., KARR, 100, NTEMP)
      AMINE = AMIN1 (AMINE, AE)
      AMAXE = AMAX1 (AMAXE, AE)
      GOTO 300
  260 IF (AE .LT. AEMIN) GOTO 300
      ICOL = ITAB5(I5+5)
      CALL DECOL2 (ICOL, LET1)
      LL1 = IABS(LET1(1))
      LL2 = IABS(LET1(2))
      IF (ISW .EQ. 3) GOTO 280
      NTEMP = NTEMP + 1
      NLET(LL1) = NLET(LL1) + 1
      IF (LL2 .NE. 0) NLET(LL2) = NLET(LL2) + 1
      GOTO 300
  280 IF (NLET(LL1) .LT. 1) GOTO 300
      IF (LL2 .EQ. 0) GOTO 290
      IF (NLET(LL2) .LT. 1) GOTO 300
  290 IF (NTEMP .GE. MAXT) GOTO 350
      NTEMP = NTEMP + 1
      NLET(LL1) = NLET(LL1) + 1
      IF (LL2 .GT. 0) NLET(LL2) = NLET(LL2) + 1
      ICHKL = ITAB(K+1)
      CALL XUNPAK (ICHKL, IHKL)
      CALL IITAB4 (IHKL, K)
      W = TANH(IEEE*FAK1)**2
      FAKWS = FAKWS + W
      E1 = IE / 100.
      IE = -IE
      IF (REDUS) GOTO 295
      ITAB(K+7) = IE
      ITAB(K+2) = IE*W - 0.5
      ITAB(K+4) = 1000. * W
      ITAB(K+3) = ITAB5(I5+2)
  295 IF (.NOT. SWIPRI) GOTO 300
      CALL KERNZI (12, ISYMB(1), 4)
      IF (LET1(1) .LT. 0) ISYMB(1) = 11
      ISYMB(2) = LL1
      IF (LET1(2) .LT. 0) ISYMB(3) = 11
      IF (LL2 .GT. 0)     ISYMB(4) = LL2
      IP = ITAB5(I5+2)
      WRITE (LITOUT, FMT='(1X,3I3,F5.2,1X,4A1,'' +'',I3,''.'',F5.2,1X)')
     *               IHKL, E1, CHAR(ISYMB(1)), CHAR(ISYMB(2)),
     *               CHAR(ISYMB(3)), CHAR(ISYMB(4)), IP, W
      CALL LINPRX (0, LITOUT, 32, 4)
  300 CONTINUE
      GOTO (310, 320, 350), ISW
  310 I = MAXT + 10
      IF (KARR(1).GT.I .OR. KARR(100).GT.I) THEN
         AMIN = AMINE - 0.1
         AMAX = AMAXE + 0.1
         GOTO 200
      ENDIF
      ISW = 2
      CALL VALDIS (I, AEMIN, 0., KARR, 100, NTEMP)
      GOTO 210
  320 ISW = 3
      NLETM = 4
      IF (MS .LE. 20) NLETM = 1
      DO 340 I=1,10
      IF (NLET(I) .GE. NLETM) GOTO 330
      IF (NLET(I) .EQ. 0) GOTO 340
      NLET(I) = -1
      GOTO 340
  330 NLET(I) = 1
  340 CONTINUE
      ITEST = 0
      DO 345 I=1,10
  345 IF (NLET(I) .LT. 1) ITEST = 1
      IF (ITEST .EQ. 0) REDUS = .FALSE.
      GOTO 210
  350 IF (SWIPRI) CALL LINPRX (-1, LITOUT, 32, 4)
      WRITE(24, 360) NTEMP
  360 FORMAT (' Number of temporarily accepted refl. (secondary set):',
     *          I4)
      IF (NTEMP .LE. 0) THEN
        WRITE (24,*) 'No temp. acc. refl. found, decrease QEET and try.'
         QEET = 0.5 * QEET -0.01
         IF (QEET .GT. 0.4 * QEETO) GOTO 111
         WRITE (24,*)'Again no temp. acc. refl. found: scaling error?'
         WRITE (24,*) 'Continuation may be unreliable, but we will try!'
         ENDIF
      FAKWS = AMAX1 (2., 0.3 * NTEMP / FAKWS)
      DO 380 I=1,10
      IF (NLET(I) .LT. 0) NLET(I) = 1
  380 CONTINUE
      WRITE (8, 390) (CHAR(I),I=1,JSYMB)
  390 FORMAT (' Symbol frequency in basic set', /, 1X, 10(3X, A1))
      WRITE (8, FMT='(1X, 10I4)') (NLET(I), I=1,JSYMB)
      RETURN
      END
      SUBROUTINE REAR2
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      INCLUDE 'Zdiftb.inc'
      COMMON /SINCOS/ IDEG(8), ISCT
      INTEGER*2 ISCT(450)
      DO 220 K=MCT,NCT,ICR
      K5 = ITAB(K+6)
      IF (K5 .EQ. 0) GOTO 220
      E1 = ITAB(K+7) * 10.
      IF (E1 .LT. 0.0) E1 = -E1
      KK5 = K5 * INCA5
      IF (ITAB5(KK5+1) .EQ. 32767) GOTO 210
  200 EEE = ITAB5(KK5+1) / E1
      IPH = ITAB5(KK5+2)
      IF (IPH .LE. 0) IPH = IPH + 360
      ITAB5(KK5+1) = EEE * ISCT(450-IPH)
      ITAB5(KK5+2) = EEE * ISCT(IPH)
      ITAB5(KK5+3) = ITAB5(KK5+3) / E1*1000.
  210 K5 = ITAB5(KK5+4)
      IF (K5 .EQ. 0) GOTO 220
      KK5 = K5*INCA5 + KK5
      GOTO 200
  220 CONTINUE
      RETURN
      END
      SUBROUTINE SYMAN (A)
      INTEGER A(1025)
      NSY = A(1)
      M = 2**NSY
      KM = M * 2
      DO 100 I = 1, NSY
      KM = KM / 2
      LM = KM / 2
      DO 100 K=1,M,KM
      N = K + LM
      DO 100 L=1,LM
      IA = A(K+L)
      A(K+L) = IA + A(N+L)
  100 A(N+L) = IA - A(N+L)
      RETURN
      END
      INTEGER FUNCTION IITAB5 (I51, I52)
      INCLUDE 'Zdiftb.inc'
      I52 = ITAB5(I51+4)*INCA5 + I51
      IITAB5 = ITAB5(I51+4)
      RETURN
      END
      FUNCTION IALP (IA, IB)
      DIMENSION IK(50)
      DATA IK / 10149, 9510, 8887, 8286, 7711, 7161, 6641, 6151, 5693,
     *           5266, 4871, 4505, 4169, 3863, 3581, 3324, 3090, 2878,
     *           2685, 2510, 2350, 2206, 2075, 1956, 1848, 1749, 1659,
     *           1577, 1502, 1433, 1388, 1332, 1296, 1243, 1190, 1139,
     *           1089, 1056, 1008,  961,  941,  920,  899,  879,  866,
     *            853,  840,  827,  814,  801 /
      IC = MAX0(IA,IB)
      IF (IC .LT. 51) GOTO 200
      IALP = MIN0 (IA, IB, (IA+IB)/4)
      GOTO 240
  200 M = MIN0 (IA, IB)
      IF (M .LT. 3) GOTO 220
      K = IK(IA) + IK(IB)
      IF (K .GT. 10149) GOTO 220
      N = M - 1
      DO 210 I=2,N
      II = M - I
      IF (IK(II) .GT. K) GOTO 230
  210 CONTINUE
  220 IALP = 0
      GOTO 240
  230 IALP = II
  240 RETURN
      END
      SUBROUTINE DAFOMS (INCODE, EL, IPH, WS, E1, IREFL, ILINK)
      INCLUDE 'Zsyst.inc'
      INCLUDE 'Zcrys.inc'
      LOGICAL SWIPRI, EXPAND
      EQUIVALENCE   (SWIPRI, SWITCH(10)), (EXPAND, SWITCH(23))
      EQUIVALENCE (IE100, IFILE(10))
      COMMON /KLAD/ ICODE(4,48), ISHIFT(48)
      COMMON /SINCOS/ IDEG(8), ISCT
      INTEGER*2 ISCT(450)
      PARAMETER (MAXNR = 1000, MAXADR = 4000, IBEMAX = 25)
      COMMON /DAFOPC/
     *          ITAB25(4,MAXNR,IBEMAX), IWEAK(4,100), DIF(4,IBEMAX),
     *          WEAKR(4,100,IBEMAX), ITAD(-1:MAXADR), QEST(3,IBEMAX),
     *          KARR(100),  IH(3), IK(3), IL(3), IHPK(3),
     *          IHKL(3), IHPL(3), IKPL(3), IHML(3), ICODEH(3,48),
     *          P1SOL(IBEMAX),  IP1SOL(IBEMAX), P2SOL(IBEMAX),
     *          IP2SOL(IBEMAX), Q1SOL(IBEMAX),  IQ1SOL(IBEMAX),
     *          Q2SOL(IBEMAX),  IQ2SOL(IBEMAX), IPQSOL(IBEMAX)
      LOGICAL FIRST, LAUEP, PSIZ
      DATA    FIRST, LAUEP, PSIZ / .FALSE., .FALSE., .TRUE. /
      DATA MINTRI / 10 /
      DATA IBEST, IKEND, IREF, IRED, IOLD, NNSYMM / 0, 0, 0, 0, 0, 0/
      DATA J12, IICENT, NREFL, E1100, KBMAX / 0, 0, 0, 0.0, 0/
      IF (KSTAT(5) .EQ. 0) THEN
         KSTAT(5) = 1
         FIRST = .FALSE.
         ENDIF
      IF (FIRST) GOTO 210
      FIRST = .TRUE.
      KBMAX = MIN0 (INCODE, IBEMAX)
      IF (ILAUE.GT.3 .AND. .NOT.EXPAND) LAUEP = .TRUE.
      E1100 = EL
      NREFL = IPH
      IF (NREFL.GT.MAXADR) CALL KERROR
     *   ('Reduce number of reflections to MAXADR (= 4000)', 0,'DAFOMS')
      NNSYMM = NSYMM
      IICENT = ICENT
      IF (EXPAND) THEN
         NNSYMM = 1
         IICENT = 1
      ENDIF
      IBEST = 1
      IOLD = 1
      IKEND = 0
      ITAD(0)  = 0
      ITAD(-1) = 0
      IRED = 0
      CALL KERNZI (0, ITAB25, 4*MAXNR*IBEMAX)
      CALL KERNZA (0., WEAKR, 400*IBEMAX)
      CALL KERNZA (0.,  QEST, 3*IBEMAX)
      CALL KERNZI (0,  ITAD,  MAXADR)
      CALL KERNZI (0,  IWEAK,    400)
      CALL KERNZI (0,   IHKL,      3)
      RETURN
  210 IF (ILINK) 330, 340, 220
  220 IF (IOLD .NE. ILINK) GOTO 270
      IF (IKEND .GE. MAXNR) RETURN
      IF (IKEND .GE. NREFL) THEN
         WRITE (24,*) 'too many symbols. Scaling error ?? Try to go on'
            GOTO 330
         ENDIF
      IKEND = IKEND + 1
      ITAB25(1,IKEND,IBEST) = INCODE
      ITAB25(2,IKEND,IBEST) = NINT(EL*1000.)
      ITAB25(4,IKEND,IBEST) = NINT(WS*1000.)
      ITAB25(3,IKEND,IBEST) = IPH
      IF (IBEST .GT. 1) RETURN
      ITAB25(3,IKEND,1) = IPH + 370*IREFL
      IF (E1.LE.E1100 .OR. IRED.EQ.100) RETURN
      IRED = IRED + 1
      ITAB25(2,IKEND,1) = -ITAB25(2,IKEND,1)
      RETURN
  270 IF (IBEST .GT. 1) GOTO 320
      DO 310 I=1,IKEND
      IADR = ITAB25(3,I,1) / 370
      ITAB25(3,I,1) = ITAB25(3,I,1) - IADR*370
      ITAD(IADR) = I
  310 CONTINUE
      IREF = IKEND
  320 IBEST = IBEST + 1
      IF (IBEST .LE. KBMAX) THEN
          IKEND = 0
          IOLD  = ILINK
          GOTO 210
          ENDIF
      IF (KSTAT(5) .LE. 5) THEN
         KSTAT(5) = KSTAT(5) + 1
         WRITE (8, FMT='(/'' NGUY error ... after quartet problems''/)')
         ENDIF
  330 IOLD  = IOLD  + 1
      IKEND = 0
      RETURN
  340 IF (IKEND .EQ. 0) IBEST = IBEST - 1
      WRITE(24, FMT='('' Psi0 FOM and negative quartet FOM:'')')
      WRITE (8, FMT='(/'' Psi0 FOM and negative quartet FOM:'')')
      WRITE (8, 345) IREF, IRED
  345 FORMAT (' Number of reflections stored in table:  ', I4, /,
     *        ' Number of reflections in reduced table: ', I4,
     *        '  (= strongest refl.)')
      IF (IBEST .EQ. 1) THEN
          ILINK = 1
          RETURN
          ENDIF
      READ (IE100, FMT='(A80)') CHIN
      IF (SWIPRI) WRITE (8, FMT='(A80)') CHIN
      READ (CHIN, FMT='(5X, I3)') N100
      IF (N100 .LE. 10) GOTO 330
      N100 = MIN0 (N100, 100)
      DO 380 I=1,N100
      READ (IE100, FMT='(3I4)') (IWEAK(J,I), J=1,3)
      CALL KERNAI (IWEAK(1,I), IHKL, 3)
  380 IWEAK(4,I) = IGROUP(IHKL) - 1
      IF (.NOT. SWIPRI) GOTO 395
      WRITE (8, FMT='(''    (G = parity group)'')')
      WRITE (8, 385) ((IWEAK(I4,I), I4=1,4), I=1,N100)
  385 FORMAT ('   H  K  L G', / (10(1X,3I3,I2)))
      WRITE (8, 390) IREF, IRED, E1100
  390 FORMAT (' The table of ', I4, ' reflections is reduced to',
     *         I4, ' strongest reflections (min E1 = ', F5.3, ')')
      WRITE (8, FMT='('' The '', I4, '' strongest reflections:'',
     *                     /, ''   No   H  K  L'')') IREF
      DO 394 I=0,IREF-1,12
      DO 391 J=1,12
      IF (I+J .GT. IREF) GOTO 392
      J12 = J
      CALL XUNPAK (ITAB25(1,I+J,1), IHKL)
  391 CALL KERNAI (IHKL, ICODEH(1,J), 3)
  392 WRITE (8, 393) I+1, ((ICODEH(I3,I12), I3=1,3), I12=1,J12)
  393 FORMAT (I5, 12(1X,3I3))
  394 CONTINUE
  395 CALL KERNZI (0, ICODEH, 3*48)
      NREL = 0
      CALL KERNZI (0, KARR, 100)
      DO 431 IJ=1,IREF
      IF (ITAB25(2,IJ,1) .GT. 0) GOTO 431
      ITAB25(2,IJ,1) = IABS (ITAB25(2,IJ,1))
      IF (NREL .GT. 5000) GOTO 435
      CALL XUNPAK (ITAB25(1,IJ,1), IK)
      NEQ = 2
      CALL SYMEQ (IK, NEQ)
      IF (NEQ .NE. NNSYMM) GOTO 431
      NEQ2 = NEQ * 2
      DO 400 INEQ=1,NEQ
      ISHIFT(INEQ) = IDEG(ISHIFT(INEQ))
  400 ISHIFT(INEQ+NEQ) = -ISHIFT(INEQ)
      DO 430 I=1,N100
      CALL KERNAI (IWEAK(1,I), IH, 3)
      IHIT = 0
      CALL KERNZA (0., DIF, 4*IBEMAX)
      DO 410 II=1,NEQ2
      ISK = 1
      IF (II .GT. NEQ) ISK = -1
      CALL KERNAI (ICODE(1,II), IK, 3)
      CALL GENERP (IH, IK, IADR, ISHMK)
      IADR = ITAD(IADR)
      IF (IADR .EQ. 0) GOTO 415
      ISS = ISIGN(1,ISHMK)
      ISHMK = IDEG(IABS(ISHMK))
      IHIT = IHIT + 1
      DO 405 J=1,IBEST
      IPK = ISK * (ITAB25(3,IJ,J) + ISHIFT(II))
      IPHMK = ISS * (ITAB25(3,IADR,J) + ISHMK)
      IPHK = IPHMK + IPK
      IPHK = MOD(IPHK, 360)
      IF (IPHK .LE. 0) IPHK = 360 + IPHK
      EH = FLOAT (ITAB25(2,IJ,J)) / 1000.
      EK = FLOAT (ITAB25(2,IADR,J)) / 1000.
      EHEK = EH * EK
      ICOSHK = ISCT(450-IPHK)
      COSHK = FLOAT(ICOSHK) / 1000.
      EHEKC = EHEK * COSHK
      DIF(1,J) = DIF(1,J) + EHEKC
      IF (IICENT .EQ. 1) THEN
          ISINHK = ISCT(IPHK)
          SINHK = FLOAT(ISINHK) / 1000.
          EHEKS = EHEK * SINHK
          EHEK2 = EHEKC**2 + EHEKS**2
          DIF(2,J) = DIF(2,J) + EHEKS
          DIF(3,J) = DIF(3,J) + SQRT(EHEK2)
          DIF(4,J) = DIF(4,J) + EHEK2
      ELSE
          DIF(3,J) = DIF(3,J) + ABS(EHEKC)
          DIF(4,J) = DIF(4,J) + EHEKC**2
          ENDIF
  405 CONTINUE
  410 CONTINUE
  415 CONTINUE
      IF (IHIT .GT. 0) THEN
          KARR(I) = KARR(I) + IHIT
          NREL = NREL + IHIT
          DO 420 J=1,IBEST
          WEAKR(1,I,J) = WEAKR(1,I,J) + DIF(1,J)
          WEAKR(2,I,J) = WEAKR(2,I,J) + DIF(2,J)
          WEAKR(3,I,J) = WEAKR(3,I,J) + DIF(3,J)
  420     WEAKR(4,I,J) = WEAKR(4,I,J) + SQRT(DIF(4,J))
          ENDIF
  430 CONTINUE
  431 CONTINUE
      GOTO 437
  435 WRITE (8, FMT='('' PSI0 generation is stopped at refl. No.'',
     *                     I3, 2X, 3I4)') IJ, IK
      DO 436 I=IJ,IREF
  436 ITAB25(2,I,1) = IABS (ITAB25(2,I,1))
  437 WRITE(24, 440) N100, NREL
      WRITE (8, 440) N100, NREL
  440 FORMAT (' The ', I3, ' weakest reflections take part in', I5,
     *        ' triplet relationships.')
      IHIT = 0
      JREFL = 0
      CALL KERNZA (0.0001, DIF, 4*IBEMAX)
      DO 460 I=1,N100
      IF (KARR(I) .LT. MINTRI) GOTO 460
      JREFL = JREFL + 1
      IHIT = IHIT + KARR(I)
      DO 450 J=1,IBEST
      WEAKR(1,I,J) = SQRT(WEAKR(1,I,J)**2 + WEAKR(2,I,J)**2)
      DIF(1,J) = DIF(1,J) + WEAKR(1,I,J)
      DIF(2,J) = DIF(2,J) + WEAKR(3,I,J)
      DIF(3,J) = DIF(3,J) + WEAKR(4,I,J)
  450 CONTINUE
  460 CONTINUE
      IF (IHIT .EQ. 0) THEN
          WRITE (8, 470)
  470     FORMAT (/' Sory, PSIzero FOM not possible, there are not ',
     *            'enough hits (10) per weak refl.')
          NREL = 0
          PSIZ = .FALSE.
          GOTO 530
          ENDIF
      HIT = FLOAT(IHIT) / FLOAT(JREFL)
      WRITE (8, 480) IBEST, JREFL, HIT
  480 FORMAT (/' PSIzero FOM for the ', I2, ' best solutions',
     *        ' (with old solution numbers)', /,
     *        '    (for ',I3, ' weak reflections and number of hits',
     *        ' per reflection is ', F5.1, '):', /,
     *        '    PSIzero(1) = sum |sum(E(K) * E(H-K))| / sum(sum|',
     *        'E(K) * E(H-K)|)', /,
     *        '    PSIzero(2) = sum |sum(E(K) * E(H-K))| / sum(sum|',
     *        'E(K) * E(H-K)|**2)**1/2')
      WRITE (8, FMT='(20X, ''PSI(1)'', 11X, ''PSI(2)'')')
      DO 490 J=1,IBEST
      DIF12    = DIF(1,J) / DIF(2,J)
      DIF13    = DIF(1,J) / DIF(3,J)
      DIF(1,J) = DIF12
      DIF(2,J) = DIF13
      P1SOL(J) = DIF12
  490 P2SOL(J) = DIF13
      CALL ORDTAB (P1SOL, IP1SOL, IBEST)
      CALL ORDTAB (P2SOL, IP2SOL, IBEST)
      P2MIN = P2SOL(1)
      DO 510 J=1,IBEST
      WRITE (8, 500) J, P1SOL(J), IP1SOL(J), P2SOL(J), IP2SOL(J)
  500 FORMAT (1X, I2, '. solution: ', 2(F9.4, ' - ', I2, 3X))
      P1SOL(J) =  P2MIN / DIF(2,J)
  510 CONTINUE
  530 CONTINUE
      E4MIN = 0.0
      NEGQ = 0
      DO 621 I=1,N100-2
      IF (NEGQ .GT. 500) GOTO 630
      CALL KERNAI (IWEAK(1,I), IHPK, 3)
      NEQI = 1
      CALL SYMEQ (IHPK, NEQI)
      IF (NEQI .NE. NNSYMM) GOTO 621
      DO 560 INEQ=1,NEQI
      DO 560 I3=1,3
  560 ICODEH(I3,INEQ) = ICODE(I3,INEQ)
      IPHPK = IWEAK(4,I)
      DO 622 II=I+1,N100-1
      CALL KERNAI (IWEAK(1,II), IHPL, 3)
      NEQII = 1
      CALL SYMEQ (IHPL, NEQII)
      IF (NEQII .NE. NNSYMM) GOTO 622
      IPHPL = IWEAK(4,II)
      IPKPL = IPHPK + IPHPL
      IPKPL = MIN0 (IPKPL, 14-IPKPL)
      IF (IPHPK-IPHPL .EQ. 0) IPKPL = 0
      DO 623 IIN=1,NEQII
      CALL KERNAI (ICODE(1,IIN), IHPL, 3)
      DO 624 III=II+1,N100
      IF (.NOT. LAUEP .AND. IWEAK(4,III).NE.IPKPL) GOTO 624
      CALL KERNAI (IWEAK(1,III), IKPL, 3)
      DO 620 IN=1,NEQI
      DO 570 I3=1,3
      IHPK(I3) = ICODEH(I3,IN)
      IHML(I3) = IHPK(I3) - IKPL(I3)
      IL(I3) = IHPL(I3) - IHML(I3)
      IF (.NOT. LAUEP) GOTO 570
      IF (MOD(IL(I3),2) .NE. 0) GOTO 620
  570 IL(I3) = IL(I3) / 2
      CALL GENERQ (IL, ISHL, IADL)
      IADL = ITAD(IADL)
      IF (IADL .EQ. 0) GOTO 620
      DO 580 I3=1,3
  580 IK(I3) = IKPL(I3) - IL(I3)
      CALL GENERQ (IK, ISHK, IADK)
      IADK = ITAD(IADK)
      IF (IADK .EQ. 0) GOTO 620
      DO 590 I3=1,3
  590 IH(I3) = IHPL(I3) - IL(I3)
      CALL GENERQ (IH, ISHH, IADH)
      IADH = ITAD(IADH)
      IF (IADH .EQ. 0) GOTO 620
      DO 600 I3=1,3
  600 IHKL(I3) = -IHPL(I3) - IK(I3)
      CALL GENERQ (IHKL, ISHHKL, IADHKL)
      IADHKL = ITAD(IADHKL)
      IF (IADHKL .EQ. 0) GOTO 620
      NEGQ = NEGQ + 1
      ISSH = ISIGN(1,ISHH)
      ISHH = IDEG(IABS(ISHH))
      ISSK = ISIGN(1,ISHK)
      ISHK = IDEG(IABS(ISHK))
      ISSL = ISIGN(1,ISHL)
      ISHL = IDEG(IABS(ISHL))
      ISSHKL = ISIGN(1,ISHHKL)
      ISHHKL = IDEG(IABS(ISHHKL))
      DO 610 J=1,IBEST
      EH = FLOAT (ITAB25(2,IADH,J)) / 1000.
      EK = FLOAT (ITAB25(2,IADK,J)) / 1000.
      EL = FLOAT (ITAB25(2,IADL,J)) / 1000.
      EHKL = FLOAT (ITAB25(2,IADHKL,J)) / 1000.
      E4  = EH * EK * EL * EHKL
      IF (E4 .LT. E4MIN) GOTO 610
      IPH = ISSH * (ITAB25(3,IADH,J) + ISHH)
      IPK = ISSK * (ITAB25(3,IADK,J) + ISHK)
      IPL = ISSL * (ITAB25(3,IADL,J) + ISHL)
      IPHKL = ISSHKL * (ITAB25(3,IADHKL,J) + ISHHKL)
      IPH4 = IPH + IPK + IPL + IPHKL
      IPH4 = MOD(IPH4, 360)
      IF (IPH4 .LE. 0) IPH4 = 360 + IPH4
      ICOS4 = ISCT(450-IPH4)
      COS4 = FLOAT(ICOS4) / 1000.
      ISIN4 = ISCT(IPH4)
      SIN4 = FLOAT(ISIN4) / 1000.
      E4 = SQRT((E4*COS4)**2 + (E4*SIN4)**2)
      QEST(1,J) = QEST(1,J) + E4*COS4
      QEST(2,J) = QEST(2,J) + E4
      QEST(3,J) = QEST(3,J) + E4*ABS(180.-FLOAT(IPH4))
  610 CONTINUE
  620 CONTINUE
  624 CONTINUE
  623 CONTINUE
  622 CONTINUE
  621 CONTINUE
      GOTO 631
  630 WRITE (8, FMT='(/'' Negative quartet generation is stopped'',
     *  '' at weak refl. No.'', I3, 2X, 3I4)')  I, (IWEAK(I3,I), I3=1,3)
  631 IF (NEGQ .LT. 5) THEN
          WRITE (8, 640) NEGQ
  640     FORMAT (/' Sorry, Negative Quartet FOM not possible, there',
     *            ' are only ', I1, ' hits ')
          IF (.NOT. PSIZ) RETURN
          CALL KERNZA (0.0, Q1SOL, IBEST)
          GOTO 690
          ENDIF
      WRITE(24, 645) N100, NEGQ
  645 FORMAT (' The ', I3, ' weakest reflections take part in', I5,
     *        ' negative quartets.' )
      WRITE (8, 650) N100, NEGQ
  650 FORMAT (/' The ', I3, ' weakest reflections take part in', I4,
     *        ' negative quartets.' /
     *        ' Negative quartet FOMs (with old solution numbers):', /,
     *        '  Hauptman: NQEST = sum (E4 * cos(PH4)) / sum E4 ',
     *        '   (here: NQEST + 1)', /,
     *        '  Schenk:   NQC   = sum (E4 * |180-PH4|)         ',
     *        '   (here: NQC / sum E4 * 180)', /,
     *        20X, 'NQEST', 11X, 'NQC')
      DO 660 J=1,IBEST
      QEST(1,J) = 1. + QEST(1,J) / QEST(2,J)
      QEST(2,J) = QEST(3,J) / (QEST(2,J) * 180.)
      Q1SOL(J) = QEST(1,J)
  660 Q2SOL(J) = QEST(2,J)
      CALL ORDTAB (Q1SOL, IQ1SOL, IBEST)
      CALL ORDTAB (Q2SOL, IQ2SOL, IBEST)
      Q1MIN = Q1SOL(1)
      Q2MIN = Q2SOL(1)
      DO 680 J=1,IBEST
      WRITE (8, 670) J, Q1SOL(J), IQ1SOL(J), Q2SOL(J), IQ2SOL(J)
  670 FORMAT (I3, '. solution: ', 2(F9.4, ' - ', I2, 3X))
      IF (QEST(1,J) .LE. 0. .OR. QEST(2,J) .LE. 0.) THEN
      WRITE (8, FMT='('' negative quartets: zero QUEST error'')')
          Q1SOL(J) = 0.1111
      ELSE
      Q1SOL(J) = (Q1MIN/QEST(1,J) + Q2MIN/QEST(2,J)) / 2.
         ENDIF
  680 CONTINUE
  690 IPQSOL(1) = NREL
      IPQSOL(2) = NEGQ
      CALL COMFOM (P1SOL, Q1SOL, IPQSOL, IBEST)
      ILINK = IPQSOL(1)
      WRITE (8, FMT='( '' Combined FOM: best solution is solution'',
     *       '' No. '', I3)') ILINK
      FIRST = .FALSE.
      RETURN
      END
      SUBROUTINE GENERP (IH, IK, IADR, ISHMK)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      DIMENSION IH(3), IK(3), IHMK(3)
      IADR = -1
      DO 200 I=1,3
      IHMK(I) = IH(I) - IK(I)
  200 IF (IABS(IHMK(I)) .GT. MAXHKL(I)) GOTO 230
      ICOHMK = INPACK(IHMK)
      KC = IABS(ICOHMK)
      IF (KC.EQ.0 .OR. KC.GT.MCT) GOTO 230
      K = ITAB(KC)
      IF (K .EQ. 0) GOTO 230
      L = IABS(K) / 4096
      ISHMK = (L + 1) * ISIGN(1,K) * ISIGN(1,ICOHMK)
      IADR = IABS(K) - 4096*L
  230 RETURN
      END
      SUBROUTINE GENERQ (IHKL, ISHIFT, IADR)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zdifta.inc'
      DIMENSION IHKL(3)
      IADR = -1
      DO 210 I=1,3
  210 IF (IABS(IHKL(I)) .GT. MAXHKL(I)) GOTO 230
      ICODE = INPACK(IHKL)
      KC = IABS(ICODE)
      IF (KC.EQ.0 .OR. KC.GT.MCT) GOTO 230
      K = ITAB(KC)
      IF (K .EQ. 0) GOTO 230
      L = IABS(K) / 4096
      ISHIFT = (L + 1) * ISIGN(1,K) * ISIGN(1,ICODE)
      IADR = IABS(K) - 4096*L
  230 RETURN
      END
      SUBROUTINE ORDTAB (URD, IORD, IOMAX)
      INCLUDE 'Zsyst.inc'
      PARAMETER (IMAX = 25)
      DIMENSION URD(IMAX), IORD(IMAX), ORD(IMAX)
      IOMAX = MIN0 (IOMAX, MIN0 (IOMAX,IMAX))
      CALL KERNZI (0, IORD, IOMAX)
      CALL KERNZA (0., ORD, IOMAX)
      JJ = 1
      DO 250 I=1,IOMAX
      IF (I .EQ. 1) GOTO 240
      DO 210 J=1,I-1
      IF (URD(I) .GT. ORD(J)) GOTO 210
      JJ = J
      GOTO 220
  210 CONTINUE
      JJ = I
      GOTO 240
  220 DO 230 K=I,JJ+1,-1
      ORD(K)   = ORD(K-1)
  230 IORD(K)  = IORD(K-1)
  240 ORD(JJ)  = URD(I)
      IORD(JJ) = I
  250 CONTINUE
      CALL KERNAB (ORD(1), URD(1), IOMAX)
      RETURN
      END
      SUBROUTINE COMFOM (P1SOL, Q1SOL, IPQSOL, IBEST)
      INCLUDE 'Zsyst.inc'
      INCLUDE 'Zdiftb.inc'
      PARAMETER (IBEMAX = 25)
      DIMENSION P1SOL(IBEMAX), Q1SOL(IBEMAX), IPQSOL(IBEMAX),
     *          C1SOL(IBEMAX), C2SOL(IBEMAX),  C3SOL(IBEMAX),
     *          CFSOL(IBEMAX)
      DATA WC1, WC2, WPSI, WNEQ / 2., 4., 4., 6. /
      IF (IPQSOL(1) .LT.  20) WPSI = 2.
      IF (IPQSOL(1) .EQ.   0) WPSI = 0.
      IF (IPQSOL(2) .GT. 290) WNEQ = 7.
      IF (IPQSOL(2) .LT.  20) WNEQ = 2.
      IF (IPQSOL(2) .LT.   5) WNEQ = 0.
      WSUM = WC1 + WC2 + WPSI + WNEQ
      WC1  = WC1  / WSUM
      WC2  = WC2  / WSUM
      WPSI = WPSI / WSUM
      WNEQ = WNEQ / WSUM
      CALL KERNZI (0, IPQSOL, IBEST)
      DO 200 I=1,IBEST
      C1SOL(I) = FLOAT(KB10X(12,I)) / 1000.
      C2SOL(I) = FLOAT(KB10X(13,I)) / 1000.
  200 CFSOL(I) = C1SOL(I) * WC1   +  C2SOL(I) * WC2  +
     *           P1SOL(I) * WPSI  +  Q1SOL(I) * WNEQ
      CALL KERNZA (0., C3SOL, IBEST)
      JJ = 1
      DO 250 I=1,IBEST
      IF (I .EQ. 1) GOTO 240
      DO 210 J=1,I-1
      IF (CFSOL(I) .LT. C3SOL(J)) GOTO 210
      JJ = J
      GOTO 220
  210 CONTINUE
      JJ = I
      GOTO 240
  220 DO 230 K=I,JJ+1,-1
      C3SOL(K)  = C3SOL(K-1)
  230 IPQSOL(K) = IPQSOL(K-1)
  240 IPQSOL(JJ) = I
      C3SOL(JJ)  = CFSOL(I)
  250 CONTINUE
      CALL KERNZA (0., C3SOL, IBEST)
      DO 260 I=1,IBEST
  260 C3SOL(IPQSOL(I)) = FLOAT(I)
      CALL KERF2I (C3SOL, IPQSOL, IBEST)
      WRITE (8, FMT = '('' Combined FOM:'', /,
     *  ''                 CONS1   CONS2    PSI0    NEQ ''/
     *  '' Rel.weights '', 4F8.3 /
     *  '' No  orig.No'' , 40X, ''CFOM  Range'')')
     *                      WC1, WC2, WPSI, WNEQ
      IPQMIN = IBEST
      DO 270 J=1,IBEST
      IF (IPQSOL(J) .LT. IPQSOL(IPQMIN)) IPQMIN = J
      N = KB10X(11,J)
  270 WRITE (8, 280) J, N, C1SOL(J), C2SOL(J), P1SOL(J), Q1SOL(J),
     *                 CFSOL(J), IPQSOL(J)
  280 FORMAT (I3, I6, F13.3, 4F8.3, I4)
      IPQSOL(1) = IPQMIN
      RETURN
      END
      SUBROUTINE NUTS
      INCLUDE 'Zsyst.inc'
      EQUIVALENCE (ICRYS, IFILE(3)), (ICON, IFILE(4))
      EQUIVALENCE (IDOKA, KEYS(10))
      EQUIVALENCE (IRUN, KSTAT(13))
      CHARACTER * 2 ISTAR
      CHARACTER *6 L(20), LL
      CHARACTER *72 FMHELP(4)
      DATA LMAX, LMAXP / 20, 16/
      DATA L    /  'NUTS'  , 'AT2X'  , 'X2AT'  , 'FR2HKL', '$$PTB$',
     *             'BIJVOE', 'SHAT'  , 'EULER' , 'INVERT', '$$PTB$',
     *             '$$PTB$', 'SHELIN', 'SELECT', 'PRIFC' , 'SHELXL',
     *             'FCALG' , '$$PTB$', 'R'     , 'H'     , 'Q'       /
      DATA ISTAR / '**' /
      DATA FMHELP /
     *' AT2X, X2AT : transform ATOMS file to SHELX XYZN file, and v.v.',
     *' SHAT, EULER and INVERT : shift, rotate or invert atomic coords',
     *' PRIFC   : print FC: temp: exit',
     *' BIJVOET : calc. Bijvoet coefficients, find absolute structure'/
      ICONT = 0
      CALL KEPROG ('NUTS')
      LL  = LITJ2
      IF (LL .EQ. 'NUTS') LL = LITJ3
      IF (LL .EQ. ' ') GOTO 107
      CALL KEREQ6 (LL, L, LMAXP, KEND)
      IF (KEND .LE. 0 .OR. KEND .GT. LMAXP) GOTO 107
      GOTO 206
  107 CALL RDCOND (ICON, L, 1, KEND)
      LL = LIT(2)
      IF (LL .EQ. 'NUTS') LL = LIT(3)
      IF (KEND .EQ. 1) CALL RDCOND (ICON, L, 1, KKKK)
      CALL FILCLO (ICON, 'KEEP')
      IF (KEND .NE. 1) GOTO 110
      IF (LL .EQ.  ' ') GOTO 110
      CALL KEREQ6 (LL, L, LMAXP, KEND)
      IF (KEND .LE. 0 .OR. KEND .GT. LMAXP) GOTO 110
      GOTO 206
  110 ICONT = 1
      WRITE (9, 112) (L(J), J=2,LMAXP)
  112 FORMAT (' Select one of the following options (or R or H or Q):'
     *         /  10 (1X, A6) )
      CALL KETERM (0, 1, KEND)
      IF (KEND .LT. 0) GOTO 110
      LL = LIT(1)
      IF (LL .EQ. 'Q') GOTO 990
      IF (LL .EQ. 'R') GOTO 110
      IF (LL .EQ. 'H') THEN
         DO 114 I = 1, 4
  114    WRITE (9, FMT = '(A72)') FMHELP(I)
         GOTO 110
         ENDIF
      CALL KEREQ6 (LL, L, LMAX, KEND)
      IF (KEND.LE.1) THEN
         WRITE (9, 202)
  202    FORMAT (' Answer not understood: please, try again:')
         GOTO 110
         ENDIF
  206 PROGNM = LL
      CALL WR24
      WRITE (9, FMT='(1X /'' ============ Program '', A8)') PROGNM
      IF (PROGNM .EQ. 'BIJVOE') PROGNM = 'BIJVOET'
      WRITE (24, 207) (ISTAR, I=1,23), PROGNM, (ISTAR, I=1,23)
  207 FORMAT (/ 1X, 23A2 / ' ****', 38X, '****' / ' ****', 16X, A8,
     +       14X, '****' / ' ****', 38X, '****' / 1X, 23A2 / 1X )
      GOTO (2,2,3,4,5,6,7,8,9, 5,5, 12,13,14,15,16,18,18,19,20), KEND
  2   CALL AT2X
      IF (LITJ2 .EQ. 'NUTS' .OR. LITJ2 .EQ. 'AT2X') GOTO 770
      CALL COMPAT
      GOTO 770
  3   CALL X2AT
      GOTO 770
  4   CALL FR2HKL
      GOTO 770
  5   STOP 501
  6   CALL BIJVOE
      IF (IDOKA .EQ. 17) RETURN
      GOTO 770
  7   CALL SHAT
      GOTO 770
  8   CALL EULER
      GOTO 770
  9   CALL INVERT
      IF (KSTAT(14) .EQ. 1) RETURN
      GOTO 770
  12  CONTINUE
      WRITE (9, 212)
  212 FORMAT (
     *' Various output files with atomic parameters.'/
     *' Note: XYZN = control data + atomic params for SHELXL !'/
     *'       and CCODE.res is a copy of  XYZN  .')
      CALL AT2X
      GOTO 770
  13  CALL SELECT
      GOTO 770
  14  CALL PRIFC
      GOTO 770
  15  CONTINUE
      CALL AT2X
      GOTO 770
  16  CALL FCALG
      GOTO 990
  18  IF (ICONT.EQ.0) GOTO 800
      GOTO 110
  19  IF (ICONT.EQ.0) GOTO 800
      WRITE (9, 719)
  719 FORMAT (' Possible options are:'/
     *  ' AT2X   = convert ATOMS file to eXternal par. file format' /
     *  ' X2AT   = convert SHELX param. file to ATOMS file' /
     *  ' BIJVOET  calc. Bijvoet coefficients, find absolute structure'/
     *  ' etc.  ,  please try again:')
      GOTO 110
  20  IF (ICONT.EQ.0) GOTO 800
      WRITE (9, 720)
  720 FORMAT (' So you quit.')
      GOTO 990
  770 IF (ICONT .EQ. 0) GOTO 990
      WRITE (9, 777)
  777 FORMAT (' DONE'/1X/' Do you wish to run more options? Say Q or:')
      GOTO 110
  800 CALL KERROR ('Illegal parameter', 800, 'NUTS')
  990 WRITE(24, 992) PROGNM
  992 FORMAT (/' End of program ', A8)
      IF (KSTAT(14) .EQ. 1) GOTO 995
         CALL KERASE ('CONDA')
  995 PROGNM = 'NUTS'
      CALL KEPROX
      RETURN
      END
      SUBROUTINE AT2X
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      EQUIVALENCE (IDDL, IFILE(1)), (ICRIN, IFILE(4))
      EQUIVALENCE (IATOMS, IFILE(2)), (ICRYS, IFILE(3))
      EQUIVALENCE (IATOLD, IFILE(10))
      EQUIVALENCE (ISPEK, IFILE(14)), (ISHEL, IFILE(11))
      EQUIVALENCE (ISCHAK, IFILE(12))
      EQUIVALENCE (IRUN, KSTAT(13))
      EQUIVALENCE (KPROG, KSTAT(18))
      DIMENSION IUNIT(10),LATT(7)
      PARAMETER (MAXAT=2513)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT), PTBXX(2),
     *               DUMMYT(110212)
      COMMON /ATNAMB/ ATNAME(MAXAT)
      CHARACTER*6   ATNAME
      CHARACTER*1 LRR
      DIMENSION IZTYPA(10)
      PARAMETER (U2B = 8. * 3.141593 **2)
      DATA LATT / 1,5,6,7,2,4,3 /
      DATA TF / 0.06/
      CALL RDCRYS (ICRYS)
      DO 110 I= 1, NTYPE
  110 CALL ATOMIZ (CELATY(I), NLET, IZTYPA(I))
      CALL FILINQ (ISCHAK, 'SCHAKL', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (ISCHAK, 217) CCODE
      WRITE (ISCHAK, 219) CELL
      WRITE(24, FMT='(
     *   '' Output SCHAKAL file is denoted  SCHAKL'')')
      WRITE(24, FMT='(
     *   '' Output SHELX file is '', A6, ''.res'')') CCODER
      CALL FILINQ (ISHEL, 'RES' , 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (ISHEL, FMT = '(''TITL file '', A6,''.res = '',
     *   ''= DIRDIF output for SHELX'')') CCODER
      WRITE (ISHEL,115) WAVE, CELL
  115 FORMAT ('CELL  ',F8.5,2X,3F9.5,3F9.4)
      WRITE (ISHEL,125) ZET, CELLSD
  125 FORMAT ('ZERR ',F9.3,2X,3F9.5,3F9.4)
         LRR = '+'
      IF (ICENT .EQ. 1) LRR = '-'
      WRITE (ISHEL, FMT = '(''LATT  '', A1, I1)') LRR, LATT(ILATT)
      IF (NSYMM .EQ. 1) GOTO 140
      CALL RDCRYB (ICRYS, 'SYMIT', KEND)
      DO 135 I = 2,NSYMM
      READ (ICRYS, FMT = '(A80)') CHIN
  135 WRITE (ISHEL, FMT = '(''SYMM  '', A60)') CHIN(11:70)
  140 WRITE (ISHEL, 145) (CELATY(I), I=1,NTYPE)
  145 FORMAT('SFAC      ',10(A2,3X))
      DO 190 I = 1,NTYPE
  190 IUNIT(I) = IFIX (CELALL(I) + 0.5)
      WRITE (ISHEL, FMT = '(''UNIT  '', 10I5)') (IUNIT(I),I=1,NTYPE)
      WRITE (ISHEL, FMT = '(''L.S.  3'')')
      CHOUT = 'REM      use BOND for distances and angles:'
      WRITE (ISHEL, FMT = '(A72)') CHOUT
      WRITE (ISHEL, FMT = '(''BOND'')')
      CHOUT='REM      FMAP 3 = electr.dens.,    FMAP 2:  Fo-Fc Fourier'
      WRITE (ISHEL, FMT = '(A72)') CHOUT
      WRITE (ISHEL, FMT = '(''FMAP  3'')')
      CHOUT = 'REM      Plan  n: print n additional Fourier peaks'
      WRITE (ISHEL, FMT = '(A72)') CHOUT
      CHOUT = 'REM      Plan -n: print includes connectivity'
      WRITE (ISHEL, FMT = '(A72)') CHOUT
      WRITE (ISHEL, FMT = '(''PLAN  -10'')')
      CHOUT='REM      TEMP nn = Temperature of data collect. in Celcius'
      WRITE (ISHEL, FMT = '(A72)') CHOUT
      WRITE (ISHEL, FMT = '(''REM      TEMP 20'')')
      CHOUT = 'REM      SIZE = crystal size in mm :'
      WRITE (ISHEL, FMT = '(A72)') CHOUT
      WRITE (ISHEL, FMT = '(''REM      SIZE 0.5 0.5 0.5 '')')
      WRITE (ISHEL, FMT = '(''REM      crystal color and shape ?'')')
      CHOUT = 'REM      Write atoms file in PDB format (with H) :'
      WRITE (ISHEL, FMT = '(A72)') CHOUT
      WRITE (ISHEL, FMT = '(''WPDB  -1 '')')
      WRITE (ISHEL, FMT= '(''REM      Warning: check HKLF below !! '')')
      WRITE (ISHEL, FMT= '(''REM      ---------------------------- '')')
      WRITE (ISHEL, FMT= '(''REM      3=Fobs, 4=FobsSQ, > HKL file '')')
      CHOUT = ' '
      WRITE(24, FMT='('' Output file for PLUTON (Spek) is  '',A6,
     *   ''.spf''/)') CCODER
      CALL FILINQ (ISPEK,  'SPF',   'FORMATTED', 'OUTPUT', KINQ)
      WRITE (ISPEK, 217) CCODE
  217 FORMAT ('TITL  : DIRDIF output for : ',A6)
      WRITE (ISPEK, 219) CELL
  219 FORMAT ('CELL  ',6F10.5)
      WRITE (ISPEK, 221) SPGR
  221 FORMAT ('SPGR  ',A16)
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.EQ.-1) CALL KERROR (' No ATOMS file found',
     *   221, 'AT2X')
      FVAR = - 999.
      CALL ATOMIN (IATOMS, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      WRITE (24,*) 'Transform ATOMS parameter file format to: '
      WRITE (24,*) '     SPF, SCHAKAL and RES files'
      IF (NFNUM .LE. 0) GOTO 231
      IF (LIT(NLIT). EQ. 'SC=' .AND. FNUM(NFNUM) .GT. 0.001) THEN
         FVAR = 1. / FNUM(NFNUM)
         WRITE (24,*) '      FVAR = 1 / SCALE from the ATOMS file '
         ENDIF
  231 CALL LOGRD (IDDL, 'MERBSC', KLOG)
      CALL FILCLO (IDDL, 'KEEP')
      IF (KLOG .GT. 0 .AND. LIT(2) .EQ. 'SCALE') THEN
         IF (FVAR .LT. 0.0) THEN
            FVAR  = 1. / FNUM(2)
            CHOUT='      FVAR = 1 / MERBIN scale (from the DDLOG file)'
            WRITE(24, FMT = '(A72)') CHOUT
            ENDIF
         TF = FNUM(3) /U2B
         WRITE (24,*) '      MERBIN U(iso) (from the DDLOG file)'
         ENDIF
      IF (FVAR .LT. 0.0) FVAR = 1.
      WRITE(ISHEL, FMT = '(''FVAR  '', F10.5)') FVAR
      CALL ATOMST (1, ATXYZ, NAT, KEYT)
      CALL WR24
      DO 300 I = 1,NAT
      ISF = 0
      DO 235 J=1,NTYPE
      IF (IZAT(I) .EQ. IZTYPA(J)) THEN
         ISF = J
         GOTO 250
         ENDIF
  235 CONTINUE
      WRITE (CHOUT, 240) ATNAME(I)
  240 FORMAT (' Atom ', A6,' not found in CRYSDA file',
     *' ISFAC=0 was assigned' )
      IF (ATNAME(I)(1:1).EQ.'Q') CHOUT(14:38) = ' is a peak (disorder?)'
      WRITE (9, FMT='(A)') CHOUT
  250 IF (ATXYZ(5,I) .LE. 0.0001) ATXYZ(5,I) = TF
      ATXYZ(4,I) = 11.0
      KK = 10
      IF (ATXYZ(6,I) .LE. 0.00001) KK = 5
      WRITE (ISHEL, 260) ATNAME(I)(1:4), ISF, (ATXYZ(K,I) ,K=1,KK)
  260 FORMAT (A4, I5, 6F10.5, ' =' / 9X, 4F10.5 )
      WRITE (ISPEK, 276) ATNAME(I), (ATXYZ(J,I),J=1,3)
  276 FORMAT (A6,2X,3F10.5)
      WRITE (ISCHAK, 277) ATNAME(I), (ATXYZ(K,I),K=1,3)
  277 FORMAT ('ATOM ',A6,2X,3F10.5)
  300 CONTINUE
      CALL FILCLO (ICRIN, 'KEEP')
      CALL FILINQ (ICRIN, 'CRYSIN', 'FORMATTED', 'INPUT', KCRIN)
      IHKLF = 0
      IF (KINQ.EQ.-1) GOTO 304
  301 CALL KERINA (ICRIN, LIT, 1, LEND)
      IF (LEND .NE. 0) GOTO 304
      IF (CHIN(1:4) .NE. 'HKLF') GOTO 301
      IF (NFNUM .LE. 0) GOTO 304
      IHKLF = IABS (NINT (FNUM(1)))
  304 CALL FILCLO (ICRIN, 'KEEP')
      IF (IHKLF .EQ. 0) THEN
         WRITE (ISHEL, FMT = '(''REM   HKLF   ??  '')')
      ELSE
         WRITE (ISHEL, FMT = '(''HKLF  '',I3)') IHKLF
         ENDIF
      WRITE (ISHEL, FMT = '(''END       '')')
      CALL FILCLO (ISHEL, 'KEEP')
         WRITE (ISPEK, 311)
  311    FORMAT ('LABELS OFF'/'BOX OFF'/'EXCL Q'/'STRAW COL'/'PLOT')
         CALL FILCLO (ISPEK, 'KEEP')
      CALL FILCLO (ISCHAK, 'KEEP')
      REWIND ICRYS
      CALL FILCLO (IATOMS, 'KEEP')
      WRITE (9, 412) CCODER
  412 FORMAT (14X,
     *   'Output file for use in SHELX : file ', A6, '.res')
      CALL FILINQ (ISHEL,  'RES',   'FORMATTED', 'INPUT', KINQ)
      CALL FILINQ (ISCHAK, 'MERCUR','FORMATTED', 'OUTPUT', KINQ)
  511 READ  (ISHEL, FMT='(A80)', END=512) CHIN
      WRITE (ISCHAK, FMT='(A80)') CHIN
      GOTO 511
  512 CONTINUE
      CALL FILCLO (ISHEL, 'KEEP')
      CALL FILCLO (ISCHAK, 'KEEP')
      RETURN
      END
      SUBROUTINE X2AT
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      EQUIVALENCE (IXYZN,  IFILE(1) )
      EQUIVALENCE (IATOMS, IFILE(2) )
      EQUIVALENCE (ICRYS,  IFILE(3) )
      EQUIVALENCE (IATOLD, IFILE(10))
      PARAMETER (MAXAT=2513)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT), PTBXX(2),
     *               DUMMYT(110212)
      COMMON /ATNAMB/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      DIMENSION   B(MAXAT), NLET(10), IZTYPA(10)
      DIMENSION  HU(MAXAT)
      CHARACTER * 1 ISF
      CALL RDCRYS (ICRYS)
      CALL FILCLO (IXYZN, 'KEEP')
      CALL FILINQ (IXYZN, 'INS', 'FORMATTED', 'INPUT', KINQI)
      IF (KINQI .EQ. 0) THEN
         WRITE (9, FMT='('' Input file : '', A6, ''.ins '')') CCODE
         GOTO 100
         ENDIF
      CALL FILCLO (IXYZN, 'KEEP')
      CALL FILINQ (IXYZN, 'RES', 'FORMATTED', 'INPUT', KINQR)
      IF (KINQR .EQ. 0) THEN
         WRITE (9, FMT='(1X/'' Program change March 2008: ''/
     * '' Shelx file ccode.ins should be used as input file,''/
     * '' the file ccode.res is used as an output file.''/
     * '' Sorry for the inconvenience!''/)')
         CALL KERNER ( -2, 'X2AT')
         ENDIF
      CALL FILCLO (IXYZN, 'KEEP')
      CALL FILINQ (IXYZN, 'XYZN', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .EQ. 0) THEN
         WRITE (9, FMT='(1X/'' Program change March 2008: ''/
     * '' Parameter file XYZN  is obsolete! ''/
     * '' Shelx file ccode.ins should be used as input file,''/
     * '' the file ccode.res is used as an output file.''/
     * '' Sorry for the inconvenience!''/1X)')
         CALL KERNER ( -2, 'X2AT')
         ENDIF
  100 CONTINUE
      CALL COPY80 (IATOMS, 'ATOMS', IATOLD, 'ATOLD')
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (IATOMS, 110) CCODE
  110 FORMAT ('ATOMS', 5X, A6)
      DO 140  I=1,NTYPE
      CALL ATOMIZ (CELATY(I), NLET(I), IZTYPA(I))
  140 CONTINUE
      CALL ATSHEL (IXYZN, ATXYZ, ATNAME, IZAT, MAXAT, NAT)
      IF (NAT .LE. 0)  GOTO 250
      CALL KERNZA( 0.0, HU, NAT)
      DO 150   I =1, NAT
      IF (ATXYZ(5,I) .LT. 0.0) HU(I) = ABS(ATXYZ(5,I))
 150  CONTINUE
      BCRES = 0.0
      CALL ATOMST (2, ATXYZ, NAT, KEYT)
      IF (KEYT .EQ. 3) CALL ATBEQ (ATXYZ, B, NAT)
      CALL ATOMOC (2, ATXYZ, ITAT, NAT)
      DO 210  I=1,NAT
      ISF = ' '
      DO 160 J=1,NTYPE
  160 IF (IZAT(I).EQ.IZTYPA(J))  GOTO 180
      WRITE (9, 170)  ATNAME(I)
  170 FORMAT (' ATOM ' , A6, ' not found in CRYSDA file,',
     +        ' ISFAC = X was assigned ')
      ISF = 'X'
  180 NN = 10
      IF (ATXYZ(6,I) .LE. 0.) NN = 5
      IF (NN .EQ. 5) B(I) = ATXYZ(5,I)
      IF (HU(I) .LE. 0.0005) THEN
         BCRES = B(I)
      ELSE
         B(I) = HU(I) * BCRES
         ENDIF
      WRITE (IATOMS, 190)  ATNAME(I), (ATXYZ(K,I),K=1,4), B(I), ISF
  190 FORMAT ('ATOM', 1X, A6, 1X, 5F10.5, 4X, A1)
      IF (NN.EQ.5) GOTO 210
      WRITE (IATOMS, 200)  (ATXYZ(K,I), K=5,10)
  200 FORMAT ('BIJ', 9X, 6F10.5)
  210 CONTINUE
      WRITE (IATOMS, 230)
  230 FORMAT ('END')
      CALL FILCLO (IXYZN,  'KEEP')
      CALL FILCLO (IATOMS, 'KEEP')
      WRITE(24, 240)  NAT
  240 FORMAT (' AT2X: Number of atoms input is',  I5 )
      RETURN
  250 CALL KERROR ('Input file  incorrect',0,'X2AT')
      RETURN
      END
      SUBROUTINE ATSHEL (IXYZN, ATXYZ, ATNAME, IZAT, MAXAT, NAT)
      DIMENSION ATXYZ (10, MAXAT), IZAT(MAXAT)
      CHARACTER * 6  ATNAME(MAXAT)
      INCLUDE 'Zsyst.inc'
      CHARACTER * 6  L(74)
      DATA  LMAX / 74 /
      DATA   L    / 'SHEL', 'DUMM', 'SFAC', 'FVAR', 'BLOC',
     *              'WGHT', 'AFIX', 'DFIX', '='   , 'ANIS' ,
     * 'ACTA', 'BASF', 'BIND', 'BOND', 'BUMP', 'CELL', 'CGLS', 'CHIV',
     * 'CONF', 'CONN', 'DAMP', 'DEFS', 'DELU', 'DISP', 'EADP', 'END ',
     * 'EQIV', 'EXTI', 'EXYZ', 'FEND', 'FLAT', 'FMAP', 'FRAG', 'FREE',
     * 'GRID', 'HFIX', 'HKLF', 'ISOR', 'L.S.', 'LATT', 'LAUE', 'LIST',
     * 'MERG', 'MOLE', 'MORE', 'MOVE', 'MPLA', 'OMIT', 'PART', 'PLAN',
     * 'REM ', 'RESI', 'RTAB', 'SADI', 'SAME', 'SIMU', 'SIZE', 'SLIM',
     * 'SPEC', 'SUMP', 'SWAT', 'SYMM', 'TEMP', 'TIME', 'TITL', 'TWIN',
     * 'UNIT', 'WPDB', 'ZERR', 'DANG', 'HOPE', 'HTAB', 'NCSY', 'STIR' /
      CALL ATOMIS (IXYZN, L, LMAX, ATXYZ, ATNAME, IZAT, MAXAT, NAT)
      RETURN
      END
      SUBROUTINE ATOMIS (IXYZN, L, LMAX, ATXYZ, ATNAME, IZAT, MAXAT,NAT)
      CHARACTER * 6  L(LMAX)
      DIMENSION ATXYZ (10, MAXAT), IZAT(MAXAT)
      CHARACTER * 6  ATNAME(MAXAT)
      INCLUDE 'Zsyst.inc'
      DIMENSION FVAR(99)
      DATA MFVAR / 99 /
      DATA I / 0 /
      CALL KERNZA (0.0, FVAR, MFVAR)
      IFVAR  = 0
      KELAST = 0
      KEACT  = 0
      NAT    = 0
  100 CALL KERIFF (IXYZN, L, LMAX, LEND)
      IF (LEND.NE.0) GOTO 190
      KELAST = KEACT
      KEACT  = 0
      IF (KELAST.NE.9) GOTO 120
      I1 = 1
  110 I = I + 1
      IF (I .GT. 10) GOTO 180
      ATXYZ(I,NAT) = FNUM(I1)
      I1 = I1 + 1
      GOTO 110
  120 IF (CHIN(1:4) .EQ. ' ') GOTO 100
      IF (CHIN(1:3) .EQ. 'REM') GOTO 100
      KEY1 = NLUSER(1)
      IF (KEY1 .GT. 10) GOTO 100
      IF (KEY1.NE.4) GOTO 160
      IF (CHIN(73:80) .EQ. ' ') GOTO 129
      IF (NFNUM .LT. 6) CALL KERROR(' FORMAT error on FVAR', 0, 'X2AT')
      READ (CHIN, 128) (FNUM(I), I=1,7)
  128 FORMAT (10X, 7F10.5)
      NFNUM = 7
  129 CONTINUE
      DO 130 I=1,NFNUM
      IF (I.GT.MFVAR) GOTO 140
  130 FVAR(I+IFVAR) = FNUM(I)
      IFVAR = IFVAR + NFNUM
      GOTO 160
  140 WRITE (9,150) MFVAR
  150 FORMAT (' TOO MANY FREE VARIABLES, MAXIMUN ', I2)
      GOTO 200
  160 CONTINUE
      IF (KEY1 .GT. 0) GOTO 100
      KEACT = 0
      IF (NLIT.GT.1) KEACT = NLUSER(NLIT)
      NAT = NAT + 1
      IF (NAT.GT.MAXAT) CALL KERROR
     *   ('Too many atoms on Shelx atoms file', 160, 'ATOMIS')
      CALL ATOMSH (IZAT(NAT), ISFAC)
      IF (IZAT(NAT).LE.0) GOTO 200
      ATNAME(NAT) = LIT(1)
      CALL KERNZA (0., ATXYZ(4,NAT), 7)
      I = 0
  170 I = I + 1
      I1 = I + 1
      IF (I.LE.3 .AND. NCOLN(I1).LE.0) GOTO 200
      IF (I.GT.3 .AND. NCOLN(I1).LE.0) THEN
         I = I - 1
         GOTO 180
         ENDIF
      ATXYZ(I,NAT) = FNUM(I1)
      IF (I .LT. 10) GOTO 170
  180 CONTINUE
      IF (KEACT.EQ.9) GOTO 100
      NVAR = I
      IF (NVAR .GT. 10) NVAR = 10
      CALL ATOSHX (FVAR, MFVAR, NVAR, ATXYZ, MAXAT, NAT, KI)
      IF (KI.LT.0) GOTO 200
      GOTO 100
  190 IF (NAT.LE.0) CALL KERROR ('No atoms found', 190, 'ATOMIS')
      RETURN
  200 CALL KERROR  ('Error in SHELX atom record', 0, 'ATOMIS')
      END
      SUBROUTINE ATOMSH (IZ, ISFAC)
      INCLUDE 'Zsyst.inc'
      CHARACTER ZZZ *1, ZZZZ *2
      IZ = 0
      IF (NFDOL(1).GE.0) RETURN
      I = NCOLL(1)
      ZZZZ = CHIN(I:I+1)
      CALL ATOMIZ (ZZZZ, NLET, IZ)
      IF (IZ.LE.0) RETURN
      I = NLET + 1
      IF (I.GT.5) GOTO 150
      IF (CHIN(4:4).NE.' ' .AND. CHIN(5:5).NE.' ') GOTO 150
      IF (I.EQ.5) GOTO 140
      IF (CHIN(3:3).EQ.' ') CHIN(3:4) = CHIN(4:4)
      IF (CHIN(2:2).EQ.' ') CHIN(2:4) = CHIN(3:4)
      IF (CHIN(1:1).EQ.' ') CHIN(1:4) = CHIN(2:4)
      ZZZZ = CHIN(1:2)
      CALL ATOMIZ (ZZZZ, NLET, I)
      IF (I.NE.IZ) GOTO 150
      I = NLET + 1
      IF (CHIN(I:I).EQ.' ') GOTO 140
      ZZZ = CHIN(I:I)
      CALL KERC2I (ZZZ, NEN)
      IF (NEN.EQ.37 .OR. NEN.EQ.38) NEN = 0
      IF (NEN.EQ.45 .OR. NEN.EQ.46) NEN = 0
      IF (NEN.LT.0 .OR. NEN.GT.9) GOTO 150
      CALL KERINB (LIT, 1)
  140 IF (NFDOT(1).NE.1) GOTO 150
      ISFAC = NINT (FNUM(1))
      IF (ISFAC.LE.0) GOTO 150
      RETURN
  150 IZ = 0
      RETURN
      END
      SUBROUTINE ATOSHX (FVAR, MFVAR, NVAR, ATXYZ, MAXAT, NAT,KI)
      DIMENSION ATXYZ (10, MAXAT)
      DIMENSION FVAR(MFVAR)
      DO 150 I=1,NVAR
      IF (ABS(ATXYZ(I,NAT)).LT.5.0) GOTO 150
      IF (ATXYZ(I,NAT).GT.10.0) GOTO 100
      IF (ATXYZ(I,NAT).LT.-10.0) GOTO 110
      ATXYZ(I,NAT) = ATXYZ(I,NAT) - 10.0
      GOTO 150
  100 IX = IFIX( ATXYZ(I,NAT) / 10.0 + .05)
      VALP = ATXYZ(I,NAT) - FLOAT(IX*10)
      IF (IX.GT.1) GOTO 130
      ATXYZ(I,NAT) = ATXYZ(I,NAT) - 10.0
      GOTO 150
  110 IX = IFIX( ABS(ATXYZ(I,NAT)) / 10.0 + .05)
      VALN = ATXYZ(I,NAT) + FLOAT(IX*10)
      IF (IX.LE.1) GOTO 160
      IF (ABS(FVAR(IX)).LT.0.000001) GOTO 160
      ATXYZ(I,NAT) = (FVAR(IX)-1.0) * VALN
      IF (ABS(FVAR(IX)).LT.5.0) GOTO 150
      IF (FVAR(IX).GT.10.0) GOTO 120
      ATXYZ(I,NAT) = FVAR(IX) - 10.0
      ATXYZ(I,NAT) = (ATXYZ(I,NAT) - 1.0) * VALN
      GOTO 150
  120 ATXYZ(I,NAT) = FVAR(IX) - 10.0
      ATXYZ(I,NAT) = (ATXYZ(I,NAT) - 1.0) * VALN
      GOTO 150
  130 CONTINUE
      IF (ABS(FVAR(IX)).LT.0.000001) GOTO 160
      ATXYZ(I,NAT) = FVAR(IX) * VALP
      IF (ABS(FVAR(IX)).LT.5.0) GOTO 150
      IF (FVAR(IX).GT.10.0) GOTO 140
      ATXYZ(I,NAT) = (10.0 - FVAR(IX)) * VALP
      GOTO 150
  140 ATXYZ(I,NAT) = (FVAR(IX) - 10.0) * VALP
  150 CONTINUE
      KI = 1
      RETURN
  160 KI = -1
      RETURN
      END
      SUBROUTINE FR2HKL
      INCLUDE 'Zsyst.inc'
      DIMENSION NHKL(3)
      CHARACTER IE *1
      CHARACTER *6 XHKL(4)
      DATA XHKL / 'FREFB', 'FREFC', 'FREFA', 'FREF' /
      CALL FILCLO (11, 'KEEP')
      DO 110 ID = 1, 4
      CALL FILINQ (11, XHKL(ID), 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .EQ. 0) GOTO 120
  110 CONTINUE
      CALL KERROR ('No FREF file found', 0, 'FR2HKL')
  119 CONTINUE
      CALL KERROR(' Empty FREF file', 119, 'FR2HKL')
  120 CONTINUE
      CHIN = ' '
      READ (11, FMT='(A28)', END=119) CHIN(1:28)
      WRITE (9, 140) XHKL(ID), CHIN(1:28)
  140 FORMAT (' Input data file: ', A6, ' Header: ', A28)
      CALL KERINB (LIT, 1)
      IF (LIT(1)(1:4) .NE. 'FREF')
     *   CALL KERROR ('File name and header inconsistent' , 0, 'FR2HKL')
      IF (LIT(2) .NE. CCODE)
     *    CALL KERROR ('Input file has incorrect CCODE', -6, 'FR2HKL')
      CALL FILCLO (12, 'KEEP')
      CALL FILINQ (12, 'HKL', 'FORMATTED', 'OUTPUT', KINQ)
  410 READ (11, 415, END=418) IE, NHKL, JC, FOBS, SIG
  415 FORMAT (A1, 3I3 ,I2, F9.2, F7.2)
      IF (FOBS .LT. 0.001) FOBS = 0.001
      SIG  = AMAX1 (SIG, FOBS / 1000. , 0.001)
      IF (JC .EQ. 2) THEN
         SIG1 = AMAX1(FOBS/6.0, SIG)
         SIG = SIG1 * (2. * FOBS + SIG1)
         IF (FOBS .LT. SIG1) SIG = 10. * SIG1
      ELSE
         SIG = SIG * 2. * FOBS
         ENDIF
      FOBS = FOBS**2
      WRITE (12, 435) NHKL, FOBS, SIG
  435 FORMAT (3I4, 2F8.2)
      IF (IE .NE. 'E') GOTO 410
  417 CALL FILCLO (11, 'KEEP')
      WRITE (9, FMT='('' Output file: '',A6,''.hkl'')')  CCODE
      CALL FILCLO (12, 'KEEP')
      CALL WR24
      RETURN
  418 WRITE (9, FMT='('' Warning: sentinel E missing on FREF file '')')
      GOTO 417
      END
      SUBROUTINE PRIFC
      WRITE (6, FMT='('' PRIFC temp out of order... sorry'')')
      STOP 510
      END
      SUBROUTINE BIJVOE
      INCLUDE 'Zsyst.inc'
      EQUIVALENCE (IXYZN,  IFILE(1) ), (IATOMS, IFILE(2) )
      EQUIVALENCE (IDOKA,  KEYS(10))
      IF (KSTAT(14) .EQ. 1) GOTO 200
      CALL FILINQ (IXYZN, 'INS', 'FORMATTED', 'INPUT', KINIXI)
      CALL FILCLO (IXYZN, 'KEEP')
      WRITE (9, 113)
  113 FORMAT (1X/' Program change March 2008:'/
     * ' XXX  Use SHELX file ccode.ins as input for BIJVOET. '/
     * ' XXX  File ccode.res is used as output file only in case the'/
     * ' XXX  absolute structure is inverted bij the program BIJVOET.'/
     * ' XXX  If ccode.ins does not exist: use atoms for input.'/1X)
      WRITE (24, 114)
  114 FORMAT (1X/' The program Bijvoet determines the'/
     * ' absolute configuration or "absolute structure" of a crystal,'/
     * ' expressed by the weighted Bijvoet-coefficient B:'/
     * '    B = sum(w * dFc * dFo) / sum(w * abs(dFc * dFo))'/
     * '    where w = 1 / sig(dFo)**2 = variance of dFo, ' /
     * '    dFc = Fc(h)-Fc(-h), dFo = Fo(h)-Fo(-h) [c=calc, o=obs]'/)
      IF (KINIXI .NE. 0 ) THEN
         WRITE (9, *) 'No ccode.ins file present: use atoms file'
         GOTO 200
         ENDIF
      WRITE (9, *) 'Transform ccode.ins file to the atoms file'
      CALL X2AT
  200 CONTINUE
      CALL WR24
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'INPUT', KINIA)
      IF (KINIA .NE. 0) CALL KERROR(' ATOMS file missing', 0, 'BIJVOE')
      CALL MERBIB
      IF (IDOKA .EQ. 17) RETURN
      CALL FCALCB
      CALL BIJVOX
      RETURN
      END
      SUBROUTINE MERBIB
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zbuff.inc'
      INCLUDE 'Zbinx1.inc'
      INCLUDE 'Zcrys.inc'
      EQUIVALENCE (IDDL,  IFILE(1))
      EQUIVALENCE (ICRYS, IFILE(3))
      EQUIVALENCE (IDOKA, KEYS(10))
      PARAMETER (MAXA=6000)
      COMMON /BLANK/ AREF(7, MAXA), DUMMY(118000)
      PARAMETER (FMAXA=6000.)
      DIMENSION HKL(3), HKL2(3), HMAX(3), HMIN(3)
      LOGICAL FRIE
      DATA FRIE /.FALSE./
      CALL WR24
      NITB = 5
      CALL KERNZA (  9999., HMIN, 3)
      CALL KERNZA ( -9999., HMAX, 3)
      STLCON = 0.9
      IF (STLMAX .GT. 0.00001) STLCON = STLMAX
      IF (STLCON .GT. 0.9) STLCON = 0.9
      STLMAX = 0.
      HCODMI = 4.0 * 256.**3
      HCODMA = - HCODMI
      CALL RDCRYS (ICRYS)
      WRITE (24, FMT='(66X, A6)') CCODE
      WRITE (8, FMT='(1X / '' SUBROUTINE MERBIB''/)')
      IF (ICENT.EQ.2) CALL KERROR (' Space group is centrosymmetric, no
     +further calculations', 0, 'MERBIB')
      WRITE (24,FMT='('' Wavelength of radiation'',41X,F7.5)') WAVE
      NREF = 0
      NNREF = 0
      MREF99 = 0
      NJC2 = 0
      SJC2 = 0.
      IEND = 1
  130 CALL MEREAD (HKL, JC, FOBS, SIG, IEND)
      IF (IEND .LT. 0) GOTO 200
      CALL HKLAXT (HKL, KEND)
      IF (KEND.LT.0) GOTO 130
      CALL HKLEXT (HKL, KEND)
      IF (KEND.LT.0) GOTO 130
      IF (ABS (HKL(1)) .GT. 99. .OR. ABS (HKL(2)) .GT. 99. .OR.
     *    ABS (HKL(3)) .GT. 99. ) THEN
         MREF99 = MREF99 + 1
         GOTO 130
         ENDIF
      CALL HKLSTL (HKL, STL, STL2)
      IF (STL .GT. STLCON) GOTO 130
      DO 143 I=1,3
  143 HKL2(I)= -HKL(I)
      CALL HKLEXS (FRIE, HKL , HCODE1)
      CALL HKLEXS (FRIE, HKL2, HCODE2)
      IF (ILAUE .GE. 6 .AND. ILAUE .LE. 12) THEN
         H99 = AMAX1 ( ABS(HCODE1), ABS(HCODE2) )
         IF (H99 .GT. 3920000.) GOTO 130
         ENDIF
      NREF = NREF + 1
      IF (NINT(HCODE1) .EQ. NINT(HCODE2)) GOTO 130
      IF (HCODE1.GT.HCODE2)  THEN
         HCODEX = HCODE1
      ELSE
         HCODEX = -HCODE2
         ENDIF
      HCODEF = ABS(HCODEX)
      IF (FOBS .LT. 0.001) FOBS = 0.001
      IF (SIG .LT. 0.001) SIG = 0.001
      IF (SIG .LT. FOBS / 1000. ) SIG = FOBS / 1000.
      IF (JC .EQ. 2) THEN
         NJC2 = NJC2 + 1
         SJC2 = SJC2 + SIG
         SIG = - SIG
      ELSE
         SIG = SIG * 2. * FOBS
         ENDIF
      FOBS = FOBS**2
      HCODMI = AMIN1(HCODMI, HCODEF)
      HCODMA = AMAX1(HCODMA, HCODEF)
      CALL HKLC1U (HCODEF, HKL)
      DO 150 I =1,3
      HMAX(I) = AMAX1 (HKL(I),HMAX(I))
  150 HMIN(I) = AMIN1 (HKL(I),HMIN(I))
      STLMAX = AMAX1(STLMAX, STL)
      NNREF = NNREF + 1
      FBINX(1,NNREF) = HCODEX
      FBINX(2,NNREF) = FOBS
      FBINX(3,NNREF) = SIG
      IF (NNREF .EQ. MBINX) STOP 513
      GOTO 130
  200 FBINX(1,NNREF+1) = 0.
      FBINX(2,NNREF+1) = -1.
      FBINX(3,NNREF+1) = 0.
      WRITE (24, 301) NREF
  301 FORMAT(' Number of reflections from input file ', 27X, I6)
      IF (MREF99 .GT. 0) WRITE (24, 303) MREF99
  303 FORMAT (' Number of relections with hkl exceeding 99:  ', I7/
     *        ' WARNING: these reflections are not used in BIJVOET!'/)
      WRITE (24, 302) NNREF, STLMAX
  302 FORMAT(' Number of reflections stored          ', 27X, I6 /
     *       ' Maximum value of sin(th)/lambda)      ', 27X, F6.4)
      CALL WR24
      IF (NJC2 .EQ. 0) GOTO 309
      SJC2 = SJC2 / FLOAT(NJC2)
      WRITE (24, 304) NJC2, SJC2
  304 FORMAT(' For', I4, ' JC=2 -reflections, av SIG =', F6.2)
      SJC2 = 0.5 * SJC2
      SJC4 = ( 0.5 * SJC2 )**2
      DO 307 I = 1, NNREF
      IF (FBINX(3, I) .GT. 0.) GOTO 307
      FBINX(3, I) = - FBINX(3, I)
      IF (FBINX(3, I) .LT. SJC2) FBINX(3, I) = SJC2
      IF (FBINX(2, I) .LT. SJC4) FBINX(2, I) = SJC4
  307 CONTINUE
  309 CONTINUE
      CALL HKLC2I (HMIN, HMAX)
      CALL HKLC1U (HCODMI, HKL)
      CALL HKLC2  (HKL, ACODMI)
      NREW = 0
      NPAIR = 0
      FOBSAB (2, NPAIR+1) = -999.
  310 AF = ACODMI - 1.1
      CALL HKLC2U (ACODMI + FMAXA - 1., HKL)
      CALL HKLC1  (HKL, HCODEL)
      CALL KERNZA (0.0, AREF, 7 * MAXA)
      IREFX = 0
  320 CONTINUE
      IF (IREFX .EQ. NNREF ) GOTO 325
      IREFX = IREFX + 1
      HCODEX = FBINX(1,IREFX)
      HCODEF = ABS(HCODEX)
      IF (HCODEF.LT.HCODMI .OR.
     *    HCODEF.GT.HCODEL) GOTO 320
      CALL HKLC1U (HCODEF, HKL)
      CALL HKLC2  (HKL, ACODE)
      IA = IFIX (ACODE - AF)
      AREF(1,IA) = HCODEF
      FOBS = FBINX(2,IREFX)
      SIG = FBINX(3,IREFX)
      IF (HCODEX.LT.0.1) GOTO 323
      AREF(2,IA) = AREF(2,IA) + 1.
      AREF(3,IA) = AREF(3,IA) + FOBS
      AREF(4,IA) = AREF(4,IA) + SIG
      GOTO 320
  323 AREF(5,IA) = AREF(5,IA) + 1.
      AREF(6,IA) = AREF(6,IA) + FOBS
      AREF(7,IA) = AREF(7,IA) + SIG
      GOTO 320
  325 CONTINUE
      IF (NREW .GT. 0) GOTO 330
      NREW = NREW + 1
  330 CONTINUE
      WRITE (8, FMT='('' Input refl cycle'', I3)') NREW
      DO 340 I = 1,MAXA
      IF (AREF(2,I) .LE. 0.1 .OR. AREF(5,I).LE.0.1) GOTO 340
      HCODEF = AREF(1,I)
      FOBSA  = SQRT( AREF(3,I) / AREF(2,I) )
      SIGA   = AREF(4,I) / AREF(2,I)**1.5  / (2. * FOBSA)
      FOBSB  = SQRT( AREF(6,I) / AREF(5,I) )
      SIGB   = AREF(7,I) / AREF(5,I)**1.5  / (2. * FOBSB)
      NPAIR = NPAIR + 1
      FOBSAB (1, NPAIR) = HCODEF
      FOBSAB (2, NPAIR) = FOBSA
      FOBSAB (3, NPAIR) = SIGA
      FOBSAB (4, NPAIR) = FOBSB
      FOBSAB (5, NPAIR) = SIGB
  340 CONTINUE
      IF (HCODEL.GE.HCODMA) GOTO 350
      ACODMI = ACODMI + FMAXA
      CALL HKLC2U (ACODMI, HKL)
      CALL HKLC1 (HKL, HCODMI)
      GOTO 310
  350 FOBSAB (2, NPAIR+1) = -999.
      IF (NPAIR.EQ.0) THEN
         IF (KSTAT(14) .EQ. 1) THEN
            WRITE (9, FMT='(14X, ''The Bijvoet coefficient can'',
     *          '' not be calculated.'' / )')
            IDOKA = 17
            RETURN
         ELSE
            CALL KERROR
     *         (' No Bijvoet pairs found, no further calculations',
     *            0, 'MERBIB')
            ENDIF
         ENDIF
      WRITE (24, 352) NPAIR
  352 FORMAT (35X, 'Number of Bijvoet pairs found: ', I6)
      CALL WR24
      WRITE (25, FMT='(/I6, '' Bijvoet pairs '')') NPAIR
      RETURN
      END
      SUBROUTINE FCALCB
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zbinx1.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zbuff.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zatomx.inc'
      EQUIVALENCE (IATOMS, IFILE(2)), (ICRYS, IFILE(3))
      PARAMETER (MAXP=6000)
      COMMON /BLANK/ DUMFC(19630), DUMAT(11918), PAIRS (6,MAXP),
     *               MPAIR, DFCMAX, DUMSCS(5999), DUMMY( 86451)
      DIMENSION  FITB(6)
      CALL KERNZA (0., PAIRS, 6*MAXP)
      WRITE (8, FMT='(/ '' SUBROUTINE FCALCB''/)')
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .NE. 0) CALL KERROR ('No ATOMS file found', 0, 'FCALCB')
      CALL ATOMIN (IATOMS, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      CALL ATOMPR (8, 2, ATXYZ, ATNAME, IZAT, NAT)
      CALL FILCLO (IATOMS, 'KEEP')
      WRITE (24, 115) NAT
  115 FORMAT (' Number of atoms from input file', I40)
      IF (KEYT.EQ.1) CALL KERROR
     *   ('No temp.factors given: no further calculations', 0, 'FCALCB')
      CHOUT = '    Atoms have mixed/anisotropic temperature factors '
      IF (KEYT.EQ.2) CHOUT =
     *   '    Atoms have individual isotropic temperature factors'
      WRITE (24, FMT='(A)') CHOUT
      CALL WR24
      BDFT = 0.
      BDFN = 0.
      DO 110 I=1,NTYPE
      CALL RDCRYB(ICRYS, 'ELEM ', KEND)
      IF (KEND .LE. 0) CALL KERROR ('Error in CRYSDA file', 0, 'FCALCB')
      READ (CHIN, FMT='(10X, 2X, I8)') IZTYPE(I)
      CALL RDCRYX (ICRYS, 'SFAC  ', SFAC(1,I), 13)
      BDFT = BDFT + CELALL(I) * SFAC(11,I)**2
      BDFN = BDFN + CELALL(I) * IZTYPE(I)**2
  110 CONTINUE
      BDF= SQRT(BDFT / BDFN)
      WRITE (8, FMT='(/,'' Anomalous scattering fraction '',
     * ''of the structure '' , /,
     * 3X, '' sqrt(sum(Df"**2) / sum(Z**2)) ='', 29X, F8.5)') BDF
      NPAIR = 0
      CALL FCALCI (ATXYZ, IZAT, ITAT, NAT)
      MPAIR = 0
      SUMFC = 0.
      SUMFO = 0.
      BQ1 = 0.
      BQ2 = 0.
      DFCMAX = 0.
  200 CONTINUE
      IF (FOBSAB(2, NPAIR+1) .LT. -1.) GOTO 220
      NPAIR = NPAIR + 1
      HCODEF = FOBSAB (1, NPAIR)
      FOBSA = FOBSAB (2, NPAIR)
      SIGA = FOBSAB (3, NPAIR)
      FOBSB = FOBSAB (4, NPAIR)
      SIGB = FOBSAB (5, NPAIR)
      DFO = FOBSA - FOBSB
      SIG2 = SIGA**2 + SIGB**2
      CALL HKLC1U (HCODEF, HKLX)
      CALL HKLSTL (HKLX, STL, STL2)
      CALL FCALB1 (ATXYZ, ITAT, NAT)
      FPF = PHIP
      DFC = FP - FPF
      IF (ABS(DFC) .GT. DFCMAX) DFCMAX = ABS(DFC)
      FITB(1) = ABS(DFC * DFO / SIG2)
      FITB(2) = HCODEF
      FITB(3) = DFC
      FITB(4) = DFO
      FITB(5) = SIG2
      FITB(6) = (FP**2 + FPF**2) * 0.5
      CALL SORTP(FITB, 6, PAIRS, MAXP, MPAIR)
      SUMFC = SUMFC + FP + FPF
      SUMFO = SUMFO + FOBSA + FOBSB
      BQ1 = BQ1 + DFC**2
      BQ2 = BQ2 + FITB(6)
      GOTO 200
  220 CONTINUE
      DFCLOW = DFCMAX / 16.
      SC = SUMFC / SUMFO
      BQ = SQRT (BQ1 / BQ2)
      WRITE (8, FMT = '( /
     * '' Anomalous scattering '',
     * ''fraction for the selected Bijvoet pairs'',
     * /,3X, '' sqrt(sum(dFc**2) / sum(Fc)**2) ='', 28X, F8.5)') BQ
      WRITE (8, FMT = '( /,
     * '' Scale factor'', /
     * 4X, ''SC = sumFc / sumFo = '', 39X, F8.4)')  SC
      WRITE (8, FMT = '( /
     * '' Sorting Bijvoet pairs on |Bt|=|dFc*dFo/sig(dFo)**2|'')')
      L = 0
      NLOW = 0
      DO 230 I=1,MPAIR
      IF (ABS(PAIRS(3,I)) .LT. DFCLOW) THEN
         NLOW = NLOW + 1
         GOTO 230
         ENDIF
      L = L + 1
      PAIRS(2,L) = PAIRS(2,I)
      PAIRS(3,L) = PAIRS(3,I)
      PAIRS(4,L) = PAIRS(4,I) * SC
      PAIRS(5,L) = PAIRS(5,I) * SC * SC
      PAIRS(6,L) = PAIRS(6,I)
      PAIRS(1,L) = PAIRS(3,L) * PAIRS(4,L) / PAIRS(5,L)
  230 CONTINUE
      WRITE (8, FMT = '(/, '' Selection of Bijvoet pairs on '',
     * ''dFc = Fc(h) - Fc(-h)'')')
      WRITE (8, FMT='('' Number of Bijvoet pairs with abs(dFc) <'',
     * F7.4, '' rejected:'', 9X, I6)') DFCLOW, NLOW
      WRITE (8, 232) L
  232 FORMAT (' Number of Bijvoet pairs selected:',
     * 32X, I6)
      MPAIR = L
      SOMDFO = 0.
      SOMDFC = 0.
      SOMSIG = 0.
      FMPAIR = FLOAT (MPAIR)
      DO 250 I=1,MPAIR
      IF (PAIRS(3,I) .GT. 0.) THEN
         SOMDFC = SOMDFC + PAIRS(3,I)
         SOMDFO = SOMDFO + PAIRS(4,I)
      ELSE
         SOMDFC = SOMDFC - PAIRS(3,I)
         SOMDFO = SOMDFO - PAIRS(4,I)
         ENDIF
      SOMSIG = SOMSIG + PAIRS(5,I)
  250 CONTINUE
      SOMDFC = SOMDFC / FMPAIR
      SOMDFO = SOMDFO / FMPAIR
      SOMSIG = SQRT (SOMSIG / FMPAIR)
      SOMSG  = SOMSIG / SQRT (FMPAIR)
      WRITE (25, FMT='( I6, '' pairs, '',
     *   '' Av. dFc dFo SIG:'', 3F6.3 )')
     *   MPAIR, SOMDFC, SOMDFO, SOMSIG
      CALL WR24
      WRITE (8, FMT='(1X/'' for '', I6, '' pairs, '',
     *   '' <dFc> <dFo <sig> (su) = '', 3F6.3, ''('', F5.3, '')'' )')
     *   MPAIR, SOMDFC, SOMDFO, SOMSIG, SOMSG
      RETURN
      END
      SUBROUTINE FCALB1 (ATXYZ, ITAT, NAT9)
      DIMENSION ATXYZ(10,NAT9), ITAT(NAT9)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      EQUIVALENCE (PHIP, FPF)
      DIMENSION FFF(10), ADTRIG(24)
      DATA FFF / 10*0.0 /
      DATA  ADTRIG / 24*0.0 /
      S = STL * 400. + 1.
      IS = IFIX(S)
      STLDEL = S - FLOAT(IS)
      ISS = NINT(S)
      DO 110 J=1,NTYPE
      IF (CELPAR(J).LE.0.0) GOTO 110
      FFF(J) = FF(IS,J) + (FF(IS+1,J)-FF(IS,J)) * STLDEL
  110 CONTINUE
      CALL HKLEX1 (HKLX, HKLX)
      IF (NSYMM.EQ.1) GOTO 150
      DO 140 J=2,NSYMM
      IF (ITRS(J).EQ.0) GOTO 140
      ADTRIG(J) = HKLX(1,1)*TSYMM(1,J) + HKLX(2,1)*TSYMM(2,J) +
     *            HKLX(3,1)*TSYMM(3,J)
  140 CONTINUE
  150 A = 0.0
      B = 0.0
      AF = 0.0
      BF = 0.0
      DO 250 I=1,NAT
      A1 = 0.
      B1 = 0.
      A2 = 0.
      B2 = 0.
      DO 200 J=1,NSYMM
      TRIG = HKLX(1,J)*ATXYZ(1,I) + HKLX(2,J)*ATXYZ(2,I) +
     *       HKLX(3,J)*ATXYZ(3,I) + ADTRIG(J)
      IF (TRIG.LT.0.0) TRIG = TRIG - 0.00010
      ITRIG = MOD ( IFIX(TRIG * 10000. + 0.5), 10000)
      IF (ITRIG.LE.0) ITRIG = ITRIG + 10000
      IF (ATXYZ(6,I) .GT. 0.0) GOTO 180
      A1 = A1 + SICO(ITRIG + 2500)
      B1 = B1 + SICO(ITRIG + 2500)
      A2 = A2 - SICO(ITRIG)
      B2 = B2 + SICO(ITRIG)
      GOTO 200
  180 X1 = HKLX(1,J) * ATXYZ (5,I)
     *   + HKLX(2,J) * ATXYZ(10,I)
     *   + HKLX(3,J) * ATXYZ (9,I)
      X2 = HKLX(2,J) * ATXYZ (6,I)
     *   + HKLX(3,J) * ATXYZ (8,I)
      X3 = HKLX(3,J) * ATXYZ (7,I)
      TF = EXP(-0.25 * ( X1*HKLX(1,J) + X2*HKLX(2,J) + X3*HKLX(3,J)))
      A1 = A1 + SICO(ITRIG + 2500) * TF
      B1 = B1 + SICO(ITRIG + 2500) * TF
      A2 = A2 - SICO(ITRIG) * TF
      B2 = B2 + SICO(ITRIG) * TF
  200 CONTINUE
      IJ = ITAT(I)
      IF (ATXYZ(6,I) .LT. 0.0) THEN
         TF = ATXYZ(4,I) * EXP (-STL2 * ATXYZ(5,I))
      ELSE
         TF = ATXYZ(4,I)
         ENDIF
      A  = A + A1 * FFF(IJ)     * TF
      B  = B + B1 * SFAC(11,IJ) * TF
      AF = AF+ A2 * SFAC(11,IJ) * TF
      BF = BF+ B2 * FFF(IJ)     * TF
  250 CONTINUE
      FP = ASYMCL * SQRT((A + AF)**2 + (B + BF)**2)
      FPF= ASYMCL * SQRT((A - AF)**2 + (B - BF)**2)
      RETURN
      END
      SUBROUTINE SORTP (A, NA, B, NB, M)
      DIMENSION A(NA), B(NA, NB)
      IF (M .EQ. NB) THEN
         IF (A(1) .LE. B(1, NB)) RETURN
         GOTO 400
         ENDIF
      M = M + 1
      IF (M .EQ. 1) GOTO 482
  400 DO 480 K = M, 2, -1
      IF (A(1) .LE. B(1, K-1)) GOTO 483
      CALL KERNAB (B(1, K-1), B(1, K), NA)
  480 CONTINUE
  482 K = 1
  483 CALL KERNAB (A, B(1, K), NA)
      RETURN
      END
      SUBROUTINE BIJVOX
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zatomx.inc'
      PARAMETER (MAXP=6000)
      COMMON /BLANK/ DUMFC(19630), DUMAT(11918), PAIRS (6,MAXP),
     *               MPAIR, DFCMAX, DUMSCS(5999), DUMMY( 86451)
      DIMENSION TABDFC(9, 15), IIDFC(100), XXDFC(100)
      DIMENSION HKLT(3), IHKL(3)
      CHARACTER ADFO *1, ABTAV *1
      DIMENSION MODA(5), MODB(5), MODC(5)
      DATA MODA /  3,  5,  8,  12,  18 /
      DATA MODB /  3,  8, 16,  28,  46 /
      DATA MODC / 30, 50, 90, 150, 230 /
      DATA MSEL, BSEL, SIGSEL, PSEL / 0, 0., 0., 0. /
      ADFC = 99.999 / DFCMAX
      CALL KERNZI (0, IIDFC, 100)
      CALL KERNZA (0., XXDFC, 100)
      CALL KERNZA (0., TABDFC, 15*9)
      DO 100 I = 1, MPAIR
      ABSDFC  = ABS(PAIRS(3,I))
      K = INT ( ABSDFC * ADFC ) + 1
      IIDFC(K) = IIDFC(K) + 1
      XXDFC(K) = XXDFC(K) + ABSDFC
  100 CONTINUE
      NXTOT = MPAIR / 15
      NXSUM = 0
      NX = 0
      XDFC = 0.
      IDFC = 1
      DO 101 K = 1, 100
      NX = NX + IIDFC(K)
      XDFC = XDFC + XXDFC(K)
      IIDFC(K) = IDFC
      IF (NX .GE. NXTOT .OR. K .EQ. 100) THEN
         TABDFC(1,IDFC) = FLOAT(NX)
         TABDFC(2,IDFC) = XDFC / FLOAT(NX)
         NXSUM = NXSUM + NX
         IDFC  = IDFC + 1
         IF (IDFC .GE. 15) THEN
            NXTOT = MPAIR + 1
         ELSE
            NXTOT = (MPAIR-NXSUM) / (16-IDFC)
            ENDIF
         NX = 0
         XDFC = 0.
         ENDIF
  101 CONTINUE
      BTAV1 = 0.
      II = MIN0(25, MPAIR)
      DO 104 I = 1,II
  104 BTAV1 = BTAV1 + ABS(PAIRS(1,I))
      BTMIN1 = 2.*BTAV1/FLOAT(II)
      BTAV2 = 0.
      DO 106 I = 1,II
  106 BTAV2 = BTAV2 + AMIN1(BTMIN1, ABS(PAIRS(1,I)))
      BTMIN = 2.*BTAV2/FLOAT(II)
      WRITE (8, FMT='(/ '' SUBROUTINE BIJVOX''/)')
      WRITE (8, FMT='('' Bijvoet calculations'' / )')
      WRITE (24, FMT='(/'' Notation:''/
     * ''   dFc = Fc(h) - Fc(-h) is the calulated Bijvoet difference'' /
     * ''   dFo = Fo(h) - Fo(-h) is the observed value'' /
     * ''   w = 1/sig(dFo)**2 with sig from counting statistics''/
     * ''   Bt  = w * |dFc*dFo| is the sorting key'' //
     * ''   B   = sum (w * dFc*dFo) / sum (Bt) ''/
     * ''       is the weighted Bijvoet coefficient,  where sum(-)''/
     * ''       is the summation over the participating Bijvoet pairs.''
     *    /)')
      CALL WR24
      WRITE (8, FMT='('' Values of abs(dFo) if >'',
     * '' abs(dFc) + 3 sig(dFo) are cut off to this value '' )')
      WRITE (8, FMT='('' Values of '',
     * ''|BT|=|dFc*dFo|/sig(dFo)**2 >'', F7.2,
     * '' are cut off to this value'')') BTMIN
      WRITE (8, FMT='(/,'' Table 517.1    Statistics of the first 50 '',
     * '' Bijvoet pairs'' / 44X, ''cut off values are marked x'')')
      WRITE (8, FMT='( ''    H  K  L       <Fc>      dFc      dFo'',
     * ''   sig(dFo)   dd/sig     BT'')')
      II = MIN0(50, MPAIR)
      BTLIM = 0.1 * ABS (PAIRS(1,II-1))
      SLOBT = 0.
      SLOBN = 0.
      DO 109 I = 1, MPAIR
      BT   = PAIRS(1,I)
      DFC  = PAIRS(3,I)
      ABSDFC = ABS(DFC)
      DFO  = PAIRS(4,I)
      ABSDFO = ABS(DFO)
      SIG2 = PAIRS(5,I)
      SIG  = SQRT(SIG2)
      IF (ABSDFO .GT. ABSDFC + 3.* SIG)  THEN
         DFO = (ABSDFC + 3. * SIG) * DFO / ABSDFO
         ABSDFO = ABS(DFO)
         PAIRS(4,I) = DFO
         BT = DFC * DFO / SIG2
         PAIRS(1,I) = BT
         ADFO = 'x'
      ELSE
         ADFO = ' '
         ENDIF
      IF (ABS(BT) .LT. 0.00001) THEN
         MPAIR = I - 1
         WRITE (8, FMT='(/'' Number of pairs limited to'', I5)') MPAIR
         GOTO 1109
         ENDIF
      QQ = ABS(BTMIN/BT)
      IF(QQ .LT. 1.) THEN
         BT = BT * QQ
         PAIRS(1,I) = BT
         ABTAV = 'x'
      ELSE
         ABTAV = ' '
         ENDIF
      K = INT ( ABSDFC * ADFC ) + 1
      IDFC = IIDFC(K)
      IF (DFC .GE. 0.) THEN
         TABDFC(3,IDFC) = TABDFC(3,IDFC) + DFO
         TABDFC(4,IDFC) = TABDFC(4,IDFC) + (TABDFC(2,IDFC)-DFO)**2
         TABDFC(5,IDFC) = TABDFC(5,IDFC) + (TABDFC(2,IDFC)+DFO)**2
      ELSE
         TABDFC(3,IDFC) = TABDFC(3,IDFC) - DFO
         TABDFC(4,IDFC) = TABDFC(4,IDFC) + (TABDFC(2,IDFC)+DFO)**2
         TABDFC(5,IDFC) = TABDFC(5,IDFC) + (TABDFC(2,IDFC)-DFO)**2
         ENDIF
      TABDFC(6,IDFC) = TABDFC(6,IDFC) + DFC * DFO
      TABDFC(7,IDFC) = TABDFC(7,IDFC) + ABSDFC * ABSDFO
      SLOBT = SLOBT + BT
      SLOBN = SLOBN + DFC**2 / SIG2
      IF (I .GT. II) GOTO 109
      DDSIG =  DFC * DFO / SIG
      HCODEF = PAIRS(2,I)
      SQ = SQRT(PAIRS(6,I))
      CALL HKLC1U (HCODEF, HKLT)
      CALL KERF2I (HKLT, IHKL, 3)
      WRITE (8, FMT='(1X, I4, 2I3, 3X, 3F9.4, A1, F8.4, 2F10.4, A1)')
     *    (IHKL(J), J=1,3), SQ, DFC, DFO, ADFO, SIG, DDSIG, BT, ABTAV
  109 CONTINUE
 1109 CONTINUE
      SLOB = SLOBT / SLOBN
      SLOBST = 0.
      SLOBSW = 0.
      SLOBSN = 0.
      DO 2109 I = 1, MPAIR
      DFC  = PAIRS(3,I)
      DFO  = PAIRS(4,I)
      W = 1. / PAIRS(5,I)
      SLOBST = SLOBST + (( DFO - SLOB *  DFC ) * W )**2
      SLOBSW = SLOBSW + W
      SLOBSN = SLOBSN + W * DFC
 2109 CONTINUE
      SLOBSD = SQRT ( SLOBST / ( SLOBSW * SLOBN - SLOBSN**2 ))
      WRITE (9,FMT='(1X/
     *   '' The slope of the function dFo = B * dFc is B^ ='',
     *  F6.3,''('',F5.3,'')'')') SLOB, SLOBSD
      WRITE (9,FMT='(''    [ For error free data, B^ = +1 or -1 ]'')')
      WRITE (25,FMT='('' Slope (dFo=B*dFc) B='',F6.3,''('',F5.3,'')'')')
     *  SLOB, SLOBSD
      CALL WR24
      DO 110 IDFC = 1, 15
      FN = TABDFC(1,IDFC)
      IF (FN .LT. 0.1) GOTO 110
      TABDFC(3,IDFC) = TABDFC(3,IDFC) / FN
      TABDFC(4,IDFC) = SQRT ( TABDFC(4,IDFC) / FN )
      TABDFC(5,IDFC) = SQRT ( TABDFC(5,IDFC) / FN )
      TABDFC(6,IDFC) = TABDFC(6,IDFC) / FN
      TABDFC(7,IDFC) = TABDFC(7,IDFC) / FN
      IF (TABDFC(7,IDFC) .GT. 0.00001)
     *   TABDFC(8,IDFC) = TABDFC(6,IDFC) / TABDFC(7,IDFC)
  110 CONTINUE
      BIJM = 0.
      BIJT = 0.
      BIJN = 0.
      DO 111 IDFC = 15, 9, -1
      FN = TABDFC(1,IDFC)
      IF (FN .LT. 0.1) GOTO 111
      BIJM = BIJM + FN
      TABDFC(9, IDFC-7) = BIJM
      BIJT = BIJT + TABDFC(6,IDFC)
      BIJN = BIJN + TABDFC(7,IDFC)
      IF (BIJN .LT. 0.00001) THEN
         IF (IDFC .EQ. 15) GOTO 111
         TABDFC(9,IDFC) = TABDFC(9,IDFC+1)
            ELSE
         TABDFC(9,IDFC) = BIJT / BIJN
         ENDIF
  111 CONTINUE
      WRITE (8, FMT='(/'' Table TABDFC  = '',
     *   '' Statistics sorted on decreasing |dFc|''//
     *   '' 1: nr of pairs '', 8F7.0 / 23X, 7F7.0 //
     *   '' 2: < |dFc| >   '', 8F7.3 / 23X, 7F7.3 //
     *   '' 3: < S dFo >   '', 8F7.3 / 23X, 7F7.3 )')
     *   (TABDFC(1,I),I=15,1,-1), (TABDFC(2,I),I=15,1,-1),
     *   (TABDFC(3,I),I=15,1,-1)
      WRITE (8, FMT='(/
     *   '' 4: sd(dFo) true'', 8F7.3 / 23X, 7F7.3 //
     *   '' 5: sd -inverted'', 8F7.3 / 23X, 7F7.3 )')
     *   (TABDFC(4,I),I=15,1,-1), (TABDFC(5,I),I=15,1,-1)
      WRITE (8, FMT='(/
     *   '' 6: < dFc.dFo > '', 8F7.4 / 23X, 7F7.4 //
     *   '' 7: <|dFc.dFo|> '', 8F7.4 / 23X, 7F7.4 //
     *   '' 8: B unweighted'', 8F7.3 / 23X, 7F7.3 )')
     *   (TABDFC(6,I),I=15,1,-1), (TABDFC(7,I),I=15,1,-1),
     *   (TABDFC(8,I),I=15,1,-1)
      WRITE (24, FMT='(1X /'' cumulative results for'',
     *   '' decreasing |dFc| ''/
     *   '' 9: nr of pairs '',  7F7.0 /
     *   '' 9: B unweighted'',  7F7.3 )')
     *   (TABDFC(9,I),I=8,2,-1), (TABDFC(9,I),I=15,9,-1)
      FN = 0.
      BIJ9 = 0.
      III = 15
      DO 1111 I = 15,9,-1
      IF (FN .LT. 100. .OR. TABDFC(9,I) .GT. BIJ9 ) THEN
         FN = TABDFC(9,I-7)
         BIJ9 = TABDFC(9,I)
         III = I
         ENDIF
 1111 CONTINUE
      NBIJ9 = NINT(FN)
      WRITE (24, FMT='('' For'', I5,
     *   '' Bijvoet pairs, the unweighted B ='',
     *   F6.3 )') NBIJ9, BIJ9
      WRITE (25, FMT='(I6, '' pairs,  unweighted B ='',
     *   F6.3)') NBIJ9, BIJ9
      CALL WR24
      BIJT = 0.
      BIJN = 0.
      DO 112 IDFC = III, 15
      W  =  TABDFC(1,IDFC) * TABDFC(2,IDFC)
      BIJT = BIJT + TABDFC(8,IDFC) * W
      BIJN = BIJN + W
  112 CONTINUE
      BIJAV = BIJT / BIJN
      BIJM = 0.
      BIJT = 0.
      DO 113 IDFC = III, 15
      BIJM = BIJM + TABDFC(1,IDFC)
      W  =  TABDFC(1,IDFC) * TABDFC(2,IDFC)
      BIJT = BIJT + W * ( TABDFC(8,IDFC) - BIJAV )**2
  113 CONTINUE
      BIJSD = SQRT (BIJT / BIJN / 6. )
      N = NINT (BIJM)
      WRITE (24, FMT='(1X / '' For'', I5,
     *   '' pairs, the <|dFc|>-weighted B ='',
     *   F6.3, ''('', F5.3, '')'' /)') N, BIJAV, BIJSD
      WRITE (25, FMT='(I6, '' pairs,  unweighted B ='',
     *   F6.3, ''('', F5.3, '')'' )') N, BIJAV, BIJSD
      CALL WR24
      WRITE (8, FMT='(/'' Table 517.2    Statistics for'', I5,
     * '' pairs in batches of 25 '', //
     * ''    dFc    average |Fc(h) - Fc(-h)|'',/
     * ''    dFo    average |Fo(h) - Fo(-h)|'',/
     * ''    dF0/s  average |Fo(h) - Fo(-h)| /sig(dFo)'')') MPAIR
      WRITE (8, FMT='(
     * ''    dFc/F  average |dFc| / SQRT (sum dFc**2 / sum Fc**2) '' /
     * ''    |Bt|   average |dFc * dFo| /sig(dFo)**2 '',/
     * ''    %B+    percentage of positive values of Bt'',/
     * ''    Bt/s   average |Bt| /sig(dFo) '')')
      WRITE (8, FMT='(/ ''     ----------individual badges-----------'',
     * ''---------   ---cumulative--- '' /
     * ''      dFc dFo  dFo/s dFc/F  |Bt|    %B+  Bt    Bt/s'',
     * ''     %B+  Bt    Bt/s  '')')
  116 FORMAT (I4, 2F5.2, F6.2, 1X, F4.3, F8.3, 2( F7.1, F6.2, F6.2))
      SUMDFC = 0.
      SUMDFO = 0.
      SUMDS = 0.
      T5T = 0.
      T5N = 0.
      SUMBTA = 0.
      SUMPER = 0.
      SUMBT = 0.
      SUMBTS = 0.
      CUMPER = 0.
      CUMBT = 0.
      CUMBTS = 0.
      FMPAIR = FLOAT(MPAIR)
      DO 117 I = 1, MPAIR
      SUMDFC = SUMDFC + ABS(PAIRS(3,I))
      SUMDFO = SUMDFO + ABS(PAIRS(4,I))
      SUMDS = SUMDS + ABS(PAIRS(4,I)) / SQRT(PAIRS(5,I))
      T5T = T5T + PAIRS(3,I)**2
      T5N = T5N + PAIRS(6,I)
      TBT = PAIRS(3,I) * PAIRS(4,I)
      SUMBTA = SUMBTA + ABS(TBT)
      IF (TBT .GT. 0.) SUMPER = SUMPER + 1.
      SUMBT = SUMBT + TBT
      SUMBTS = SUMBTS + TBT / SQRT(PAIRS(5,I))
      IF (TBT .GT. 0.) CUMPER = CUMPER + 1.
      CUMBT = CUMBT + TBT
      CUMBTS = CUMBTS + TBT / SQRT(PAIRS(5,I))
      IF (I.EQ.MPAIR) GOTO 115
      IF (MOD(I, 25) .NE. 0) GOTO 117
  115 T1  = SUMDFC / 25.
      T2  = SUMDFO / 25.
      T4  = SUMDS  / 25.
      T5 = SQRT (T5T / T5N)
      S1 = SUMBTA / 25
      S2 = 100. * SUMPER / 25
      S3 = SUMBT / 25
      S4 = SUMBTS / 25
      FLI = FLOAT(I)
      CS2 = 100. * CUMPER / FLI
      CS3 = CUMBT / FLI
      CS4 = CUMBTS / FLI
      WRITE (8, 116) I,T1,T2,T4,    T5,    S1, S2,S3,S4, CS2,CS3,CS4
      SUMDFC = 0.
      SUMDFO = 0.
      SUMDS = 0.
      T5T = 0.
      T5N = 0.
      SUMBTA = 0.
      SUMPER = 0.
      SUMBT = 0.
      SUMBTS = 0.
  117 CONTINUE
      WRITE (24, FMT='(1X/'' Calculation of BIJVOET'',
     * '' coefficients (B) and their probabilities (Prob)'')')
      WRITE (24,FMT='(/,'' Table 517.3    Bijvoet results in batches'',
     * '' of 25 pairs'',/ ''        -----cumulative-------------'',
     * ''     ---individual-batches---'')')
      WRITE (24,FMT='('' pairs'', 5X,''B   sig(B)  B/sig(B)'',
     * '' Prob        B   sig(B)  B/sig(B)''/)')
      MFR = 0
      MFR25 = 0
      I25 = 0
      SUMP = 0.0
      SUMQ = 0.0
      SUMR = 0.0
      SUMP25 = 0.0
      SUMQ25 = 0.0
      SUMR25 = 0.0
      LIS = 24
      DO 150 I=1,MPAIR
      MFR  = MFR + 1
      MFR25  = MFR25 + 1
      BT   = PAIRS(1,I)
      DFC  = PAIRS(3,I)
      DFO  = PAIRS(4,I)
      SIG2 = PAIRS(5,I)
      SIG  = SQRT(SIG2)
      SUMP = SUMP + BT
      SUMQ = SUMQ + ABS(BT)
      SUMR = SUMR + DFC**2 / SIG2
      SUMP25 = SUMP25 + BT
      SUMQ25 = SUMQ25 + ABS(BT)
      SUMR25 = SUMR25 + DFC**2 / SIG2
      IF (I .EQ. MPAIR) GOTO 147
      IF (MOD(MFR, 25) .NE. 0) GOTO 150
  147 I25 = I25 + 1
      B = SUMP/SUMQ
      SIGB = (1. - ABS(B)) * SQRT(SUMR)/SUMQ
      IF (SIGB .LT. 0.0001) SIGB = 0.0001
      BS = 2. * B / SIGB
      BS = B / SIGB
      ARGPA = 0.707107 * ABS(BS)
      PPA = 0.5 + 0.5 * ERFU(ARGPA)
      B25 = SUMP25/SUMQ25
      SIGB25 = (1. - ABS(B25)) * SQRT(SUMR25)/SUMQ25
      IF (SIGB25 .LT. 0.0001) SIGB25 = 0.0001
      BS25 = B25 / SIGB25
      MFR25 = 0
      SUMP25 = 0.0
      SUMQ25 = 0.0
      SUMR25 = 0.0
      IF (BS .GT. 999.9) BS = 999.99
      IF (BS25 .GT. 999.9) BS25 = 999.99
      IF (BS .LT. -999.9) BS = -999.99
      IF (BS25 .LT. -999.9) BS25 = -999.99
      WRITE (LIS, FMT=' (I5, F8.3, F7.3, F9.2, F6.3, 3X,
     *  F8.3, F7.3, F9.2)')
     *    MFR, B, SIGB, BS, PPA, B25, SIGB25, BS25
      IF (MFR .EQ. 200) THEN
         LIS = 8
         CALL WR24
         ENDIF
      IF (MFR .NE. 100) GOTO 150
      MSEL = 100
      BSEL = B
      SIGSEL = SIGB
      PSEL = PPA
  150 CONTINUE
      WRITE (24,FMT='(1X/'' Table 517.4  Another choice of batches:'')')
      DO 200 I = 1, 5
      IF (MODC(I) .GE. MPAIR) GOTO 202
  200 CONTINUE
      I = 5
      MPAIR = MODC(5)
  202 MODC(I) = MPAIR
      IF (I .EQ. 1) GOTO 210
      DO 204 K = 1, I-1
      MODC(K) = NINT (FLOAT(MPAIR * MODA(K)) / FLOAT(MODB(I)))
  204 MODC(I) = MODC(I) - MODC(K)
  210 MODB(1) = MODC(1)
      IF (I .EQ. 1) GOTO 220
      DO 214 K = 2, I
  214 MODB(K) = MODB(K-1) + MODC(K)
  220 NBAT = I
      SUMP = 0.
      SUMQ = 0.
      SUMR = 0.
      IPAIR = 0
      WRITE (24, 222) NBAT
  222 FORMAT (/ ' ----------cumulative--------------    --------',
     * I2, ' individual batches----' /
     *  ' pairs    B   sig(B)  B/sig(B) Prob ',
     * '  pairs    B   sig(B)  B/sig(B) Prob '/)
      NFINAL = MPAIR / 10
      IF (NFINAL .GT. 100) NFINAL = 100
      IF (NFINAL .LT. 50) NFINAL = 50
      DO 320 I = 1, NBAT
      BSUMP = 0.
      BSUMQ = 0.
      BSUMR = 0.
      KBAT = MODB(I)
      KBBAT = MODC(I)
  310 IPAIR = IPAIR + 1
      BSUMP = BSUMP + PAIRS(1,IPAIR)
      BSUMQ = BSUMQ + ABS(PAIRS(1,IPAIR))
      BSUMR = BSUMR + PAIRS(3,IPAIR)**2 / PAIRS(5,IPAIR)
      IF (IPAIR .LT. KBAT) GOTO 310
      SUMP = SUMP + BSUMP
      SUMQ = SUMQ + BSUMQ
      SUMR = SUMR + BSUMR
      BBAT = SUMP / SUMQ
      SIGB = (1. - ABS(BBAT)) * SQRT (SUMR) / SUMQ
      SIGM = AMAX1(SIGB, 0.002 * ABS(BBAT))
      BBSS = BBAT / SIGM
      IF (BBSS .GT. 999.99) BBSS = 999.99
      IF (BBSS .LT.-999.99) BBSS =-999.99
      IF (SIGB .LT. 0.0001) SIGB = 0.0001
      ARGPA = 0.707107 * ABS(BBSS)
      PA = 0.5 + 0.5 * ERFU(ARGPA)
      BBBAT = BSUMP / BSUMQ
      BSIGB = (1. - ABS(BBBAT)) * SQRT (BSUMR) / BSUMQ
      BSIGM = AMAX1(BSIGB, 0.002 * ABS(BBBAT))
      BBBSS = BBBAT / BSIGM
      IF (BBBSS .GT. 999.99) BBBSS = 999.99
      IF (BBBSS .LT.-999.99) BBBSS =-999.99
      IF (BSIGB .LT. 0.0001) BSIGB = 0.0001
      ARGPA = 0.707107 * ABS(BBBSS)
      BPA = 0.5 + 0.5 * ERFU(ARGPA)
      WRITE (24, 318) KBAT, BBAT, SIGB, BBSS,  PA,
     * KBBAT, BBBAT, BSIGB, BBBSS, BPA
  318 FORMAT ( 2(I5, F8.3, F7.3, F8.2,  F7.3, 2X))
      IF (I .LT. NBAT) GOTO 320
      IF (MPAIR .GT. NFINAL) GOTO 320
      MSEL = MPAIR
      BSEL = BBAT
      SIGSEL = SIGB
      PSEL = PA
  320 CONTINUE
      WRITE (24,*) ' '
      CALL WR24
      WRITE (25, 9321) MSEL, BSEL, SIGSEL, PSEL
 9321 FORMAT (I6, ' pairs,  B = ' ,   F6.3,'(', F5.3,')  P = ' , F6.3 )
      WRITE (9, 321) MSEL, BSEL, SIGSEL, PSEL
  321 FORMAT (1X/' The Bijvoet coefficient for the strongest', I4,
     * ' Bijvoet pairs is' / '    B = ' ,   F6.3,'(', F5.3,')  ',
     * ' and its probability is ' ,   F6.3 )
      WRITE (9, FMT='(1X /''    For more statistics, see file LIS1'')')
      BFLACK = ( 1.0 - BSEL ) / 2.
      SFLACK = SIGSEL / 2.
      WRITE(9, 322) BSEL, SIGSEL, BFLACK, SFLACK
  322 FORMAT (1X/
     * '    Conversion of B  to Flack parameter F   (0=OK, 1=wrong):'/
     * '    B = ',F6.3,'(', F5.3,') corresponds to F = ',
     *         F6.3,'(', F5.3,')' /)
      IF (PSEL .GE. 0.999) THEN
         IF (BSEL .GT. 0.0) THEN
            WRITE (9, 325)
  325     FORMAT (' The atomic parameters of the structure are in ',
     *        'agreement with' / ' its absolute configuration.' )
         ELSE
            WRITE (9, 326)
  326     FORMAT (1X/' The atomic parameters of the structure have '
     *        ,'to be inverted' /
     *         ' to be in agreement with its absolute configuration:'/
     *         ' this will be done now!!' )
            CALL INVERT
            ENDIF
         CALL WR24
         RETURN
         ENDIF
      IF (BSEL .GT. 0.0) THEN
         WRITE (9, 327)
  327    FORMAT (1X/' The atomic parameters of the structure are in ',
     *   'agreement with' / ' its absolute configuration, but inspect' /
     *   ' the Bijvoet coefficients (LIS1) to judge the validity.'/1X)
      ELSE
         WRITE (9, 329)
  329    FORMAT (1X/' The atomic parameters of the structure have ',
     *      'to be inverted to be' /
     *   ' in agreement with its absolute configuration, but inspect' /
     *   ' the Bijvoet coefficients (LIS1) to judge the validity.'/1X)
         IF (PSEL .GT. .95) THEN
            WRITE (9,FMT='(A)') ' Inversion will be done now anyhow!'
            CALL INVERT
            ENDIF
         ENDIF
      IF (PSEL .LE. 0.98) THEN
         WRITE (9, 425)
  425    FORMAT (' Be careful !' /1X)
         IF (KSTAT(14) .EQ. 1) WRITE (9, 426)
  426    FORMAT (' After refinement of the structure,',
     *             'you are welcome to recall BIJVOET !')
         ENDIF
      CALL WR24
      RETURN
      END
      SUBROUTINE SHAT
      INCLUDE 'Zaaaa.inc'
      EQUIVALENCE (IATOMS, IFILE(2) )
      EQUIVALENCE (IATOLD, IFILE(10))
      PARAMETER (MAXAT=2513)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT), PTBXX(2),
     *               DUMMYT(110212)
      COMMON /ATNAMB/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      DIMENSION SHIFT (3)
      CALL WR24
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .EQ. -1) CALL KERROR(' No ATOMS file found', 0,' SHAT')
      CALL ATOMIN (IATOMS, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      CALL ATOMPR (7, 7, ATXYZ, ATNAME, IZAT, NAT)
  120 WRITE (9, FMT = '('' Enter the shift vector (tx ty tz)'')')
      CALL KETERM (3, -1, KEND)
      IF (KEND .LT. 0 ) GOTO 120
      CALL KERNAB (FNUM, SHIFT, 3)
      WRITE (24, FMT = '('' Shift vector applied: '',3F8.4)') SHIFT
      REWIND IATOMS
      DO 200 J = 1,NAT
      DO 200 I = 1,3
  200 ATXYZ(I,J) = ATXYZ(I,J) + SHIFT(I)
      WRITE (CHOUT, FMT = '(''REMARK Shift vector: '',3F8.2)') SHIFT
      CALL ATOMPR (7, 7, ATXYZ, ATNAME, IZAT, NAT)
      CALL ATOMWR (IATOMS, ATXYZ, ATNAME, NAT)
      CALL FILCLO (IATOMS, 'KEEP')
      RETURN
      END
      SUBROUTINE EULER
      INCLUDE 'Zsyst.inc'
      INCLUDE 'Zcrys.inc'
      EQUIVALENCE (IATMOD, IFILE(1)), (IATOMS, IFILE(2))
      EQUIVALENCE (IATOLD, IFILE(10))
      EQUIVALENCE (ICRYS,  IFILE(3))
      PARAMETER (MAXAT=2513)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT), PTBXX(2),
     *               DUMMYT(110212)
      COMMON /ATNAMB/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      DIMENSION  RR(3,3)
      WRITE(9, FMT = '('' Preliminary version'')')
      CALL RDCRYS (ICRYS)
      CALL FILINQ (IATMOD, 'ATMOD', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .LT.  0) CALL KERROR ('No ATMOD file', 0, 'EULER')
      CALL ATOMIN (IATMOD, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      CALL KERINB (LIT, 1)
      IF (LIT(2) .NE. 'CARTX' .AND. LIT(2) .NE. 'CART')
     *   CALL KERROR ('No CART or CARTX on ATMOD header', 0, 'EULER')
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .GE. 0) THEN
         CALL COPY80 (IATOMS, 'ATOMS', IATOLD, 'ATOLD')
         ENDIF
      CALL ATOMPR (7, 7, ATXYZ, ATNAME, IZAT, NAT)
  260 WRITE (9, FMT = '('' Please, supply three Eulerian angles'')')
      CALL KETERM ( 3, 0, KEND)
      IF (KEND .LT. 0) GOTO 260
      AIN = FNUM(1)
      BIN = FNUM(2)
      CIN = FNUM(3)
      WRITE(24, FMT = '('' Euler angles: '',3F7.2)') AIN, BIN, CIN
      CALL MATABC (AIN, BIN, CIN, RR)
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (CHOUT, FMT = '('' ABC = '', 3F7.2)') AIN, BIN, CIN
      CALL ATOMWA (IATOMS)
      DO 300 I = 1,NAT
      CALL MATXV3 (RR, ATXYZ(1,I), ATXYZ(5,I))
      CALL MAT6XV (CART2F, ATXYZ(5,I), ATXYZ(8,I))
      WRITE (8,  FMT = '(3X, A6, 2X,3F8.4, F5.0,2(2X,3F8.4))')
     * ATNAME(I), (ATXYZ(J,I), J=1,10)
      WRITE(24,  FMT = '(3X, A6, 2X,3F8.4)')
     * ATNAME(I), (ATXYZ(J,I), J=8,10)
      WRITE (IATOMS,  FMT = '(''ATOM'', 3X, A6, 2X,3F8.4)')
     * ATNAME(I), (ATXYZ(J,I), J=8,10)
300   CONTINUE
      WRITE(IATOMS, FMT = '(''END'')')
      CALL FILCLO (IATOMS, 'KEEP')
      CALL FILCLO (IATMOD, 'KEEP')
      RETURN
      END
      SUBROUTINE INVERT
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zch80.inc'
      EQUIVALENCE (IXYZN,  IFILE(1))
      EQUIVALENCE (IATOMS, IFILE(2)), (ICRYS, IFILE(3))
      PARAMETER (MAXAT=2513)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT), PTBXX(2),
     *               DUMMYT(110212)
      COMMON /ATNAMB/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      DIMENSION ZZ(3), AA(3), BB(3), CC(3)
      CHARACTER*6 SPGRIP(7)
      DIMENSION POINTI(3,7)
      INCLUDE 'Zena1.inc'
      DATA NCALL /1/
      DATA SPGRIP /'FDD2','I41','I4122','I41MD','I41CD','I-42D','F4132'/
      DATA POINTI / 0.25, 0.25, 1.00  ,   1.00, 0.50, 1.00  ,
     *              1.00, 0.50, 0.25  ,   1.00, 0.50, 1.00  ,
     *              1.00, 0.50, 1.00  ,   1.00, 0.50, 0.25  ,
     *              0.25, 0.25, 0.50   /
      WRITE (24, FMT='('' INVERT JOB params:'', 6(1X, A6))') LITJ
      CALL RDCRYS (ICRYS)
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'INPUT', KINIA)
      IF (KINIA .NE. 0) CALL KERROR(' No ATOMS file present',0,'INVERT')
      WRITE (9, 101)
  101    FORMAT (1X/' INVERT operates on input file ATOMS,   but'/
     *   ' inverted atomic parameters are also written to ccode.res'/1X)
      CALL ATOMIN (IATOMS, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      REWIND IATOMS
      INCLUDE 'Zena2.inc'
  149 FORMAT (/ ' Space group ',A9, ' is the enantiomer of ', A9/
     *    ' and inversion is done by the mirror x,y,z -> x,y,1-z !'/)
      CALL WR24
      IF (KSPGR .EQ. 0) GOTO 9149
      DO 1149 II = 1,NAT
      ATXYZ(3,II) = 1.0 - ATXYZ(3,II)
 1149 CONTINUE
      WRITE (CHOUT, FMT = '('' Atoms mirrored: x,y,z -> x,y,1-z'')')
      CALL ATOMWR (IATOMS, ATXYZ, ATNAME, NAT)
      CALL FILCLO (IATOMS, 'KEEP')
      IF (KSTAT(14) .EQ. 1) THEN
         WRITE (9, 2149) SPGROT(I), SPGROT(J)
         WRITE(24, 2149) SPGROT(I), SPGROT(J)
 2149 FORMAT (1X/ ' NOTE !! space group ',A9 /
     *  ' MUST !! be changed to the enantiomorphous space group ', A9/
     *  ' NOTE !! DIRDIF changed the symmetry in CRYSIN and in RES !'/
     *  ' ----------------------------------------------------------'
     *    /1X)
         CALL FILCLO (3, 'KEEP')
         CALL FILINQ (3, 'CRYSIN', 'FORMATTED', 'INPUT', KIDDS)
         NCH = 0
  301    CALL KERINA (3, LIT, 1, LEND)
         IF (LEND .EQ. -1) GOTO 307
         NCH = NCH + 1
         CH80(NCH) = CHIN
         IF (LIT(1) .EQ. 'SPGR') ISPGR = NCH
         GOTO 301
  307    REWIND 3
         DO 308 ICH = 1, NCH
         IF (ICH .EQ. ISPGR) THEN
            WRITE (3, FMT='(''SPGR      '', A9)')  SPGROT(J)
         ELSE
            WRITE (3, FMT = '(A80) ') CH80(ICH)
            ENDIF
  308    CONTINUE
         CALL FILCLO (3, 'KEEP')
         CALL CRYSDA
         CALL RDCRYS (ICRYS)
      ELSE
         WRITE (9, 3149) SPGROT(I), SPGROT(J)
         WRITE(24, 3149) SPGROT(I), SPGROT(J)
 3149 FORMAT (1X/ ' NOTE !! inversion in space group ',A9 /
     *  ' implies a change to the enantiomorphous space group ', A9/
     *  ' but DIRDIF did NOT change CRYSIN or the symmetry in RES !'/,
     *  ' ---------------------------------------------------------'
     *    /1X)
         ENDIF
      GOTO 900
 9149 CONTINUE
      SPGRX = SPGR
      DO 1144 I = 1, 11
      IF (SPGRX(I:I) .EQ. ' ') THEN
         SPGRT(1:16-I) = SPGRX(I+1:16)
         SPGRX(I:15) = SPGRT(1:16-I)
         ENDIF
 1144 CONTINUE
      SPGRX(10:16) = ' '
      DO 1145 I = 1, 7
      IF (SPGRX(1:6) .EQ. SPGRIP(I)) GOTO 1147
 1145 CONTINUE
      GOTO 1148
 1147 CONTINUE
      AA(1) = POINTI(1,I)
      AA(2) = POINTI(2,I)
      AA(3) = POINTI(3,I)
      GOTO 200
 1148 CONTINUE
      CALL KERNZA (0.0, ZZ, 3)
      DO 150 I = 1,NAT
      DO 150 J = 1,3
  150 ZZ(J) = ZZ(J) + ATXYZ(J,I)
      DO 160 J =1,3
      ZZ(J) = ZZ(J) / FLOAT(NAT)
      BB(J) = 1.0
      IF (ZZ(J) .LT. 0.2) BB(J) = 0.5
      IF (ZZ(J) .GT. 0.8) BB(J) = 1.5
      CC(J) = ZZ(J) + 0.5
      AA(J) = 1.0
      IF (IPOLA .EQ. 7) AA(J) = CC(J)
  160 CONTINUE
      GOTO     (171, 171, 173, 171, 173, 173, 200, 200), IPOLA
      GOTO 191
  171 I = IPOLA
      IF (I.EQ.4) I=3
      AA(I) = CC(I)
      GOTO 192
  173 I = 8 - IPOLA
      IF (I.EQ.5) I=1
      AA(I) = CC(I)
      J = MOD (I, 3) + 1
      AA(J) = CC(J)
      GOTO 193
  191 IF (ISYST .GT. 3) GOTO 200
      I = 1
      AA(I) = BB(I)
  192 IF (ISYST .GT. 3) GOTO 200
      J = MOD (I, 3) + 1
      AA(J) = BB(J)
  193 IF (ISYST .GT. 3) GOTO 200
      K = MOD (J, 3) + 1
      AA(K) = BB(K)
  200 DO 210 J = 1,3
  210 ZZ(J) = AA(J) / 2.
      WRITE (9, FMT = '('' Inversion point: '', 3F9.5)') ZZ
      DO 250  I = 1,NAT
      DO 250  J = 1,3
  250 ATXYZ(J,I) = AA(J) - ATXYZ(J,I)
      WRITE (CHOUT, FMT = '('' Inversion point: '', 3F9.5)') ZZ
      CALL ATOMWR (IATOMS, ATXYZ, ATNAME, NAT)
      CALL FILCLO (IATOMS, 'KEEP')
  900 CONTINUE
      IF (NRECY .EQ. 0 ) THEN
         WRITE (9, 910)
         WRITE (24, 910)
  910    FORMAT (1X/ ' The output ccode.res file contains' /
     *      ' inverted atomic parameters, however, SHELX control'/
     *      ' information on the file may be lost.'/1X)
         ENDIF
      CALL AT2X
      RETURN
      END
      SUBROUTINE SELECT
      INCLUDE 'Zaaaa.inc'
      EQUIVALENCE (IATOMS, IFILE(2)), (IDDS, IFILE(1))
      EQUIVALENCE (ICON,   IFILE(4)), (IATOLD, IFILE(10))
      PARAMETER (MAXAT=2513)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT), PTBXX(2),
     *               DUMMYT(110212)
      COMMON /ATNAMB/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      CHARACTER * 80  CHINR
      LOGICAL        SWRUN
      CALL WR24
      SWRUN = .FALSE.
      JRUN = -1
      CALL COPY80 (IATOMS, 'ATOMS', IATOLD, 'ATOLD')
      CALL FILINQ (IATOLD, 'ATOLD', 'FORMATTED', 'INPUT ', KINQ)
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'OUTPUT', KINQ)
  105 WRITE (9,
     *    FMT = '('' Enter IRUN (run number) to find ATOMS set '')')
      CALL KETERM (1, 0, KEND)
      IF (KEND .LT. 0) GOTO 105
      JRUN = NINT(FNUM(1))
  110 CALL KERINA (IATOLD, LIT, 1, LEND)
      IF (LEND .EQ. -1) GOTO 300
      IF (SWRUN) GOTO 120
      IF (LIT(1) .EQ. 'Next' .OR. LIT(1) .EQ. 'NEXT') THEN
         IIRUN = NINT(FNUM(4))
         IF (IIRUN .GT. JRUN) THEN
            WRITE(9, FMT = '('' No success '')')
            RETURN
            ENDIF
         IF (JRUN .NE. IIRUN) GOTO 110
         SWRUN = .TRUE.
         WRITE (9, FMT = '(2X, A70)') CHIN(1:70)
      ENDIF
      GOTO 110
 120  IF (LIT(1) .EQ. 'ATOMS' .OR. LIT(1) .EQ. 'ATMOD') GOTO 125
      GOTO 110
 125  CCODE = LIT(2)
      WRITE (9, FMT = '(2X, A70)') CHIN(1:70)
      READ (IATOLD, FMT = '(A80)') CHINR
      IF (CHINR(1:6) .EQ. 'REMARK') THEN
         WRITE (9, FMT = '(2X,A70)') CHINR(1:70)
      ELSE
      BACKSPACE IATOLD
         CHINR = ' '
      ENDIF
  130 WRITE (9,
     *    FMT = '(1X/, '' Do you want this atom set ?(Y/N,Q)'')')
      CALL KETERM (0, 1, KEND)
      IF (KEND .LT. 0) GOTO 130
      IF (LIT(1) .EQ. 'N') THEN
         SWRUN = .FALSE.
         GOTO 110
      ENDIF
      IF (LIT(1) .EQ. 'Q') RETURN
      IF (LIT(1) .NE. 'Y') GOTO 130
      NAT = 1
      BACKSPACE IATOLD
      READ (IATOLD, FMT = '(A80)') CHIN
      LEND = 999
  150 CALL ATOMIA (IATOLD, ATXYZ, ATNAME, IZAT, MAXAT, NAT, LEND)
      IF (LEND . EQ .0) THEN
         NAT = NAT + 1
         GOTO 150
      ENDIF
      NAT = NAT - 1
      CHOUT = ' '
      IF (CHINR(1:6) .EQ. 'REMARK') CHOUT(1:72) = CHINR(8:80)
      CALL ATOMWR (IATOMS, ATXYZ, ATNAME, NAT)
      CALL FILCLO(IATOMS, 'KEEP')
      CALL FILINQ (IDDS, 'DDSYST', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (9, FMT = 211)
  211 FORMAT(' Do you want to continue with program: TRACOR, PHASEX, ...
     * ....')
  212 WRITE (9, FMT = 213)
  213 FORMAT(' Type a program name or Q for stop')
      CALL KETERM (0, 1, KEND)
      IF (KEND .LT. 0) GOTO 212
      IF (LIT(1) .EQ. 'Q') THEN
         WRITE(IDDS, FMT = '(''STOP'')')
         REWIND IDDS
         CALL FILCLO (IDDS, 'KEEP')
      ELSE
         WRITE(IDDS, FMT = '(''STOP'')')
         REWIND IDDS
         CALL FILCLO(IDDS, 'KEEP')
         CALL KERASE ('CONDA')
         ENDIF
      GOTO 400
  300 WRITE (CHOUT, FMT = '('' End of the ATOLD file '')')
  400 CALL FILCLO(IATOLD, 'KEEP')
      RETURN
      END
      SUBROUTINE WRLIS5
      INCLUDE 'Zsyst.inc'
      INCLUDE 'Zch80.inc'
      CHARACTER T *8
      I = 1
      WRITE (8, FMT='(/ ''$FINISH'')')
      REWIND 8
  111 READ (8, FMT = '(A80)', END = 119) CHIN
      IF (CHIN(1:8) .EQ. '$FINISH ') GOTO 121
      IF (I .EQ. MCH80) GOTO 111
      IF (CHIN(1:4) .NE. ' $TE') GOTO 111
      CH80(I) = CHIN
      I = I + 1
      GOTO 111
  119 STOP 524
  121 CH80(I) = ' '
      IF (I .EQ. MCH80)
     *    WRITE (4, FMT='(/'' input nr of lines limited to'',I4/)') I
      N = I
      I1 = 1
  200 T = ' '
      DO 225 I = I1, N
      IF (CH80(I)(1:4) .EQ. ' $TE') THEN
         T = CH80(I) (3:10)
         WRITE (4, FMT = '(/'' $'',A8, ''----------------------'')') T
         I2 = I
         GOTO 300
         ENDIF
  225 CONTINUE
      GOTO 900
  300 DO 325 I = I2, N
      IF (CH80(I)(3:10) .EQ. T) THEN
         WRITE (4, FMT = '(A80)') CH80(I)
         CH80(I)(1:4) = '    '
         ENDIF
  325 CONTINUE
      I1 = I2
      GOTO 200
  900 WRITE (4, FMT = '(/'' $ ----------------------------- '')')
      RETURN
      END
      SUBROUTINE COMPAT
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zatom7.inc'
      COMMON /BLANK7/
     *                ORGVEC(3, 32), NORIG, DMAX, DMAX2,
     *       NSUM(32), DSUM(32), PSHIF(3,32), ISHIF(32), ZSHIF(32),
     *       ZSUMA, ISC(32, MAXAT), DSC(32, MAXAT),
     *       IP(3), DELXYZ(3, 32, MAXAT), IZXYZ(32, MAXAT),
     *       XR(3,MAXAT), XS(3), XS1(3), XS2(3), XS3(3), XSHIFT(3)
     *     , ZFAMA, ZFAMB
      PARAMETER (MORE = 32 * MAXAT)
      CHARACTER*4 POLAR(8)
      DATA POLAR  / 'x   ',   'y   ',   'x y ',   'z   ',   'x z ',
     *              'y z ',   'xyz ',   '111 ' /
      DATA IATLIT, IATOMS, ICRYS /1, 2, 3/
      DATA NCALL, LIS6 / 0, 26 /
      IF (NCALL .LT. 0) RETURN
      CALL WR24
      CALL FILINQ (IATLIT, 'ATLIT', 'FORMATTED', 'INPUT', KINQ)
      IF (NCALL .EQ. 0) THEN
         IF (KINQ.EQ.-1) THEN
            WRITE (8, FMT='(/'' COMPAT called:''/
     *                       '' No COMPAT:  ATLIT file not found'')')
            NCALL = -1
            RETURN
            ENDIF
         ENDIF
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.EQ.-1) THEN
         WRITE (8, FMT='(/'' COMPAT called:''/
     *                    '' No COMPAT:  ATOMS file not found'')')
         RETURN
         ENDIF
      NCALL = NCALL + 1
      WRITE(24,FMT='(/'' COMPAT called: see file LIS6''/)')
      IF (NCALL .GT. 1) GOTO 107
      CALL FILCLO (LIS6, 'KEEP')
      CALL KERASE ('LIS6')
      OPEN (UNIT = LIS6, FORM = 'FORMATTED', FILE='lis6',STATUS = 'NEW')
      WRITE (LIS6, FMT='(''LIS6 '', A6 /1X/
     *      '' COMPAT: compare files ATLIT and ATOMS''/
     *      '' =====================================''/1X)') CCODE
      CALL RDCRYS (ICRYS)
      WRITE (LIS6, FMT='('' NSYMM, ICENT, NLATT, IPOLA: '', 4I2)')
     *    NSYMM, ICENT, NLATT, IPOLA
      CALL RDCRYB (ICRYS, 'NORIG', KEND)
      IF (KEND .EQ. -1)
     *   CALL KERROR ('No NORIG record on CRYSDA file', 0, 'COMPAT')
      BACKSPACE ICRYS
      READ(ICRYS, FMT = '(10X, I10)') NORIG
      WRITE (LIS6, FMT='('' Nr of origin vectors NORIG: '', I2/)') NORIG
      DO 105 N = 1,NORIG
      READ (ICRYS, FMT = '(10X, 3F10.7)') (ORGVEC(J,N), J= 1,3)
  105 CONTINUE
      CALL FILCLO (ICRYS, 'KEEP')
      IF (IPOLA .EQ. 0) GOTO 107
      IF (IPOLA .GE. 7) THEN
         WRITE (LIS6,FMT='('' COMPAT: present sp.gr. not programmed'')')
      CALL FILCLO (IATOMS, 'KEEP')
      CALL FILCLO (IATLIT, 'KEEP')
         NCALL = -1
         RETURN
         ENDIF
      IF (IPOLA .EQ. 3 .OR. IPOLA.GE.5) THEN
         WRITE (LIS6,FMT='('' COMPAT: not completed !!'')')
      CALL FILCLO (IATOMS, 'KEEP')
      CALL FILCLO (IATLIT, 'KEEP')
         NCALL = -1
         RETURN
         ENDIF
      CALL KERNZI ( 0, IP, 3)
      IF (IPOLA .EQ. 1 .OR. IPOLA .EQ. 3 .OR. IPOLA .EQ. 5) IP(1) = 1
      IF (IPOLA .EQ. 2 .OR. IPOLA .EQ. 3 .OR. IPOLA .EQ. 6) IP(2) = 1
      IF (IPOLA .EQ. 4 .OR. IPOLA .EQ. 5 .OR. IPOLA .EQ. 6) IP(3) = 1
      WRITE(LIS6, FMT= '('' Polar direction(s): '', A4)') POLAR(IPOLA)
  107 CONTINUE
      REWIND IATLIT
      CALL ATOMIN (IATLIT, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      CALL FILCLO (IATLIT, 'KEEP')
      IF (NCALL .GT. 1) WRITE (LIS6,FMT=
     *  '(//'' COMPAT ------------------------- CALL nr'', I3//)') NCALL
      WRITE(LIS6, FMT = '(28X,
     *    '' Number of atoms present    in ATLIT  : '',I4 /)') NAT
      CALL ATOMOC (1, ATXYZ, IZAT, NAT)
      ZSUMA = 0.0
      ZFAMA = 0.0
      ZFAMB = 0.0
      ZSUM1 = 0.0001
      DO 140 I =  1,NAT
      ZSUMA = ZSUMA + ATXYZ(4,I) * FLOAT( IZAT(I)**2 )
      ZSUM1 = ZSUM1 + ATXYZ(4,I)
      ZFAMA = ZFAMA + FLOAT( IZAT(I) )
      ZFAMB = ZFAMB + FLOAT( IZAT(I)**2 )
      CALL KERNAB (ATXYZ(1,I), XR(1,I), 3)
  140 CONTINUE
      ZSUMAV = SQRT ( ZSUMA / ZSUM1 )
      IF (NCALL .EQ. 1) WRITE(LIS6, FMT = '(
     *   '' rms Z from ATLIT is : '', F7.3 )') ZSUMAV
      CALL ATOMIN (IATOMS, OTXYZ, OTNAME, IZOT, MAXAT, NOT, KEYT)
      CALL FILCLO (IATOMS, 'KEEP')
      WRITE(LIS6, FMT = '(28X,
     *   '' Number of atoms in the model (ATOMS) : '',I4 )') NOT
      CALL ATOMOC (1, OTXYZ, IZOT, NOT)
      DMAX = 0.4
      DMAX2 = DMAX * DMAX
      CALL KERNZI (0, ISC, MORE)
      CALL KERNZA (0.0, DSC, MORE)
      CALL KERNZI (0, NSUM, 32)
      IF (IPOLA. EQ. 0) THEN
         CALL COMPOR
      ELSE
         CALL COMPOL
         ENDIF
      WRITE (LIS6,FMT='(/'' COMPAT finished '')')
      RETURN
      END
      SUBROUTINE COMPOR
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zatom7.inc'
      COMMON /BLANK7/
     *                ORGVEC(3, 32), NORIG, DMAX, DMAX2,
     *       NSUM(32), DSUM(32), PSHIF(3,32), ISHIF(32), ZSHIF(32),
     *       ZSUMA, ISC(32, MAXAT), DSC(32, MAXAT),
     *       IP(3), DELXYZ(3, 32, MAXAT), IZXYZ(32, MAXAT),
     *       XR(3,MAXAT), XS(3), XS1(3), XS2(3), XS3(3), XSHIFT(3)
     *     , ZFAMA, ZFAMB
      DATA LIS6 / 26 /
      DO 290 IOR = 1, NORIG
      DO 280 IO = 1, NOT
      DO 180  J = 1, 3
  180 XS(J) = OTXYZ(J,IO)
      DO 190 J = 1, 3
  190 XS1(J)= XS(J) + ORGVEC(J,IOR)
      DO 270 IS = 1, NSYMM
      CALL SYMOP1 (IS, XS1, XS2)
      DO 260 IC = 1, 2
      JOR = IOR
      IF (ICENT.EQ.1 .AND. IC.EQ.2) JOR = IOR + NORIG
      DO 250 IL = 1, NLATT
      CALL SYMOP2 (IC, IL, XS2, XS3)
      DO 240 IA = 1, NAT
      CALL DISTSQ (XR(1,IA), XS3, DMAX, XSHIFT, DIST2)
      IF (DIST2 .GT. DMAX2) GOTO 240
      DIST = SQRT (DIST2)
      IF (ISC(JOR, IO) .NE. 0) THEN
         IF (DIST .GT. DSC(JOR, IO)) GOTO 240
      ELSE
         NSUM(JOR) = NSUM(JOR) + 1
         ENDIF
      ISC(JOR, IO) = IA
      DSC(JOR, IO) = DIST
  240 CONTINUE
  250 CONTINUE
  260 CONTINUE
  270 CONTINUE
  280 CONTINUE
  290 CONTINUE
      JORP = 2 * NORIG
      WRITE (LIS6, FMT='(/'' nr of hits for each origin shift:''/
     *     16I3/)') (NSUM(I), I=1,JORP)
      CALL COMPRI (JORP)
      RETURN
      END
      SUBROUTINE COMPRI (JORP)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zatom7.inc'
      COMMON /BLANK7/
     *                ORGVEC(3, 32), NORIG, DMAX, DMAX2,
     *       NSUM(32), DSUM(32), PSHIF(3,32), ISHIF(32), ZSHIF(32),
     *       ZSUMA, ISC(32, MAXAT), DSC(32, MAXAT),
     *       IP(3), DELXYZ(3, 32, MAXAT), IZXYZ(32, MAXAT),
     *       XR(3,MAXAT), XS(3), XS1(3), XS2(3), XS3(3), XSHIFT(3)
     *     , ZFAMA, ZFAMB
      DIMENSION IAS(MAXAT)
      CHARACTER * 72 TEXT1, TEXT2, TEXT3
      DATA LIS6 / 26 /
      JBEST = 1
      NBEST = 0
      NBEST3= 0
      WBEST = 0.
      DBEST = 0.
      DISSD = 0.
      ZBEST = 0.
      ZMAX = 0.
      IZ4BES = 0
      ZFOMA = 0.
      ZFOMB = 0.
      DO 320 JOR = 1, JORP
      WSUM = 0.
      DIS2 = 0.
      DISMAX = 0.
      ZSUM = 0.
      IZ4 = 0
      NSUM3 = 0
      IF (NSUM(JOR) .EQ. 0) GOTO 320
      IF (NSUM(JOR) .LT. NBEST) GOTO 320
      DO 310 IO  = 1, NOT
      IF (ISC(JOR, IO) .EQ. 0) GOTO 310
      DIST = DSC(JOR, IO)
      IF (DIST .GT. DISMAX) DISMAX = DIST
      IF (DIST .LE. 0.4) IZ4 = IZ4 + 1
      IF (DIST .LE. 0.3) THEN
         W = 1.0
         NSUM3 = NSUM3 + 1
      ELSEIF (DIST .LE. 0.4) THEN
         W = (0.4 - DIST) * 10.
      ELSE
         W = 0.0
         ENDIF
      IA = ISC(JOR, IO)
      TTT = FLOAT(IZOT(IO)) / FLOAT(IZAT(IA))
      IF (TTT .GT. 1.) TTT = 1. / TTT
      W = W * W
      WSUM = WSUM + W
      DIS2 = DIS2 + DIST * DIST
      ZSUM = ZSUM + W * OTXYZ(4,IO) * FLOAT( IZOT(IO)**2 )
      ZFOMA = ZFOMA + W *  FLOAT( IZOT(IO) )
      ZFOMB = ZFOMB + W *  FLOAT( IZOT(IO)**2 )
  310 CONTINUE
      IF (ZSUM .GT. ZMAX) ZMAX = ZSUM
      IF (NSUM(JOR) .EQ. NBEST .AND. WSUM .LT. WBEST)  GOTO 320
      JBEST = JOR
      WBEST = WSUM
      NBEST = NSUM(JOR)
      DBEST = DISMAX
      ZBEST = ZSUM
      IZ4BES = IZ4
      NBEST3 = NSUM3
      IF (DIS2 . GT. 0.0001) DIS2 = SQRT (DIS2 / FLOAT(NBEST))
      DISSD = DIS2
  320 CONTINUE
      ZBEST = ZBEST / ZSUMA
      ZMAX = ZMAX / ZSUMA
      WRITE(LIS6, FMT = '(
     *     28X, '' Nr of atoms identified within 0.3 A  : '',I4 /
     *          '' Atoms < 0.6 A  : '',I4 ,
     *     ''  Stand. dev. ='', F5.2,
     *     ''  Max. dev. = '', F4.2 /
     *     28X, '' Nr of atoms identified within 0.4 A  : '',I4 )')
     *   NBEST3, NSUM(JBEST), DISSD, DBEST, IZ4BES
      WRITE(LIS6, FMT =
     *   '('' W(dev =0.3-->0.4) = 1-->0 :'' ,
     *     '' Weighted number of hits (< 0.4 A)  :'',F7.2 /
     *     '' FOM based on dev. and Z ==>'' ,
     *     '' Relative SUM (W Z**2) of model ====>'',F7.3 )')
     *   WBEST, ZBEST
      IF (ZMAX .GT. ZBEST+0.01) WRITE (8, FMT =
     *   '(//'' WARNING: the heavy atoms are not so good !!!!!!!!!!!''/
     *   '' Largest Relative SUM (W Z**2) of model found ======>'',F7.3/
     *   '' =======   ''//)')   ZMAX
      IF (NAT .LT. NOT/2) GOTO 500
      N1 = 1
  480 N2 = N1 +  9
      IF (N2 .GT. NOT) N2 = NOT
      TEXT1       = ' '
      TEXT2       = ' '
      TEXT3       = ' '
      IF (N1 .EQ. 1 ) THEN
         TEXT1(1:12) = ' ATOMS atom '
         TEXT2(1:12) = ' ATLIT atom '
         TEXT3(1:12) = ' distance '
         ENDIF
      I1 = 13
      DO 490 IO = N1,N2
      I2 = I1 + 5
      TEXT1(I1:I2) = OTNAME(IO)
      IA = ISC(JBEST, IO)
      IF (IA .GT. 0) THEN
         I3 = I1 -1
         TEXT2(I1:I2) = ATNAME(IA)
         IF (IZAT(IA) .NE. IZOT(IO)) TEXT2(I3:I3) = '*'
         WRITE (TEXT3(I3:I2), FMT = '(F4.2,3X)') DSC(JBEST,IO)
         TEXT3(I3:I3) = ' '
         IF (DSC(JBEST,IO) .GT. 0.2) TEXT3(I3:I3) = 'x'
         IF (DSC(JBEST,IO) .GT. 0.3) TEXT3(I3:I3) = 'X'
      ELSE
         TEXT2(I1:I1) = '?'
         ENDIF
      I1 = I2 + 1
  490 CONTINUE
      WRITE(LIS6, FMT = '(/ A72)') TEXT1
      WRITE(LIS6, FMT = '(A72)') TEXT2
      WRITE(LIS6, FMT = '(A72)') TEXT3
      N1 = N2+1
      IF (N1 .LE. NOT) GOTO 480
  500 CONTINUE
      CALL KERNZI (0, IAS, NAT)
      DO 575 IO  = 1,NOT
      IA = ISC(JBEST, IO)
      IF (IA .GT. 0) IAS(IA) = IO
  575 CONTINUE
      IF (NAT .GT. 2*NOT) GOTO 600
      N1 = 1
  580 N2 = N1 +  9
      IF (N2 .GT. NAT) N2 = NAT
      TEXT1       = ' '
      TEXT2       = ' '
      TEXT3       = ' '
      IF (N1 .EQ. 1 ) THEN
         TEXT1(1:12) = ' ATLIT atom '
         TEXT2(1:12) = ' ATOMS atom '
         TEXT3(1:12) = ' distance '
         ENDIF
      I1 = 13
      DO 590 IA = N1,N2
      I2 = I1 + 5
      TEXT1(I1:I2) = ATNAME(IA)
      IO   =  IAS(IA)
      IF (IO .GT. 0) THEN
         I3 = I1 -1
         TEXT2(I1:I2) = OTNAME(IO)
         IF (IZAT(IA) .NE. IZOT(IO)) TEXT2(I3:I3) = '*'
         WRITE (TEXT3(I3:I2), FMT = '(F4.2,3X)') DSC(JBEST,IO)
         TEXT3(I3:I3) = ' '
         IF (DSC(JBEST,IO) .GT. 0.2) TEXT3(I3:I3) = 'x'
         IF (DSC(JBEST,IO) .GT. 0.3) TEXT3(I3:I3) = 'X'
      ELSE
         TEXT2(I1:I1) = '?'
         ENDIF
      I1 = I2 + 1
  590 CONTINUE
      WRITE(LIS6, FMT = '(/ A72)') TEXT1
      WRITE(LIS6, FMT = '(A72)') TEXT2
      WRITE(LIS6, FMT = '(A72)') TEXT3
      N1 = N2+1
      IF (N1 .LE. NAT) GOTO  580
  600 CONTINUE
      N = 0
      DO 610 IA = 1, NAT
      IO = IAS(IA)
      IF (IO .GT. 0) THEN
         IF (IZAT(IA) .NE. IZOT(IO)) THEN
            IF (N .EQ. 0) WRITE
     *     (LIS6,FMT='(/'' Atom nomination ATLIT - ATOMS changed:''/)')
            N = N + 1
            WRITE (LIS6, 603) IA, ATNAME(IA), IO, OTNAME(IO)
  603       FORMAT (10X, 'nr', I4, 1X, A6, I3, 1X, A6)
            ENDIF
         ENDIF
  610 CONTINUE
      IF (N .EQ. 0) WRITE
     *   (LIS6, FMT='(1X/ '' All atom nominations are correct.''/)')
      WSUM3 = FLOAT(NSUM3)  / FLOAT(NAT) *100.
      WSUM4 = FLOAT(IZ4BES) / FLOAT(NAT) *100.
      IF (ZFAMA .GT. ZFOMA) THEN
         ZFOMA = ZFOMA / ZFAMA * 100.
         ZFOMB = ZFOMB / ZFAMB * 100.
      ELSE
         ZFOMA = ZFAMA / ZFOMA * 100.
         ZFOMB = ZFAMB / ZFOMB * 100.
         ENDIF
      ZBEST = ZBEST * 100.
      ZFOM  = ( WSUM3 + WSUM4 + ZFOMA + ZFOMB + ZBEST)  / 5.
      CALL WR24
  704 FORMAT (1X/' Figures Of Merrit from COMPAT:      (IPAT=',I2,')'//
     *   '  WSUM3  WSUM4  ZFOMA  ZFOMB  ZBEST   CFOM   (%) '/
     *   1X, 6F7.0 //)
      WRITE (8, 704) IPAT, WSUM3, WSUM4, ZFOMA, ZFOMB, ZBEST, ZFOM
      WRITE (LIS6, 704) IPAT, WSUM3, WSUM4, ZFOMA, ZFOMB, ZBEST, ZFOM
      WRITE (25,704) IPAT, WSUM3, WSUM4, ZFOMA, ZFOMB, ZBEST, ZFOM
      WRITE (8, 705) IPAT, WSUM3, WSUM4, ZFOMA, ZFOMB, ZBEST, ZFOM
  705 FORMAT (/' $TE COMPAT  IPAT=',I2,3X,5F5.0, '  FOM=', F5.0 /)
      RETURN
      END
      SUBROUTINE COMPOL
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zatom7.inc'
      COMMON /BLANK7/
     *                ORGVEC(3, 32), NORIG, DMAX, DMAX2,
     *       NSUM(32), DSUM(32), PSHIF(3,32), ISHIF(32), ZSHIF(32),
     *       ZSUMA, ISC(32, MAXAT), DSC(32, MAXAT),
     *       IP(3), DELXYZ(3, 32, MAXAT), IZXYZ(32, MAXAT),
     *       XR(3,MAXAT), XS(3), XS1(3), XS2(3), XS3(3), XSHIFT(3)
     *     , ZFAMA, ZFAMB
      PARAMETER (MORE = 32 * MAXAT)
      DIMENSION XS4(3), XS5(3)
      DIMENSION ACELTY(10), NCELTY(10), NCELLZ(10)
      CHARACTER ACELTY *2
      DATA LIS6 / 26 /
      WENDO = 0.0
      DMAXP = 0.3
      DMAXP2 = DMAXP **2
      CALL CELZAT (ACELTY, NCELTY, NCELLZ)
      AVZ = 0.0
      TATOMS= 0.0
      DO 110 N=1,NTYPE
      IF (NCELLZ(N).GE. 2) THEN
         AVZ = AVZ + FLOAT( NCELLZ(N)*NCELTY(N) )
         TATOMS = TATOMS + FLOAT( NCELTY(N) )
         ENDIF
  110 CONTINUE
      ZMAX = NCELLZ(1)
      AVZ =AVZ / TATOMS
      IZMAX =  INT((AVZ + ZMAX)/2.)
      IF (IZMAX .LT. 20) IZMAX = 4
      WRITE(LIS6, FMT= '('' Threshold: Z(min) ='', I3)') IZMAX
      CALL KERNZA (0.0, XS4, 3)
      CALL KERNZA (0.0, XS5, 3)
      CALL KERNZI (0, IZXYZ, MORE)
      CALL KERNZA (0.0, PSHIF, 3*32)
      DO 290 IOR = 1, NORIG
      DO 280 IO = 1, NOT
      IF (IZOT(IO). LT. IZMAX) GOTO 280
      DO 180  J = 1, 3
  180 XS(J) = OTXYZ(J,IO)
      DO 190 J = 1, 3
  190 XS1(J)= XS(J) + ORGVEC(J,IOR)
      DO 270 IS = 1, NSYMM
      CALL SYMOP1 (IS, XS1, XS2)
      DO 260 IC = 1, 2
      JOR = IOR
      IF (IC.EQ.2) JOR = IOR + NORIG
      DO 250 IL = 1, NLATT
      CALL SYMOP2 (IC, IL, XS2, XS3)
      DO 240 IA = 1, NAT
      IF (IZAT(IA). LT. IZMAX) GOTO 240
      DO 195 I = 1,3
      IF (IP(I) .EQ. 1) GOTO 195
      XS4(I) = XS3(I)
      XS5(I) = XR(I,IA)
  195 CONTINUE
      CALL DISTSQ (XS4, XS5, DMAXP, XSHIFT, DIST2)
      IF (DIST2 .GT. DMAXP2) GOTO 240
      DIST = SQRT (DIST2)
      IF (DIST .LE. 0.2) THEN
         W = 1.0
      ELSE
         W = (0.4 - DIST) * 5.
         ENDIF
      IW = NINT (W * ATXYZ(4,IA) * FLOAT( IZAT(IA) * IZOT(IO) ) )
      NSUM(JOR) = NSUM(JOR) + 1
      IOX = NSUM(JOR)
      IZXYZ (JOR, IOX) = IW
      DO 210 I = 1,3
      DELXYZ(I,JOR,IOX) = 0.0
      IF (IP(I) .EQ. 0) GOTO 210
      DELXYZ(I,JOR,IOX) = AMOD (XS3(I) - XR(I,IA) +  3.0 , 1.0)
  210 CONTINUE
  240 CONTINUE
  250 CONTINUE
  260 CONTINUE
  270 CONTINUE
  280 CONTINUE
  290 CONTINUE
      JORBES = 0
      DSUMM = -1.
      DO 350 JOR = 1, 2 * NORIG
      DSUM(JOR) = 0.0
      IF (NSUM(JOR) .EQ. 0) GOTO 350
      IOX = NSUM(JOR)
      DO 330 IX = 1,IOX
      DSUM(JOR) = DSUM(JOR) + FLOAT ( IZXYZ(JOR,IX) )
  330 CONTINUE
      IF (DSUM(JOR) .GT. DSUMM) THEN
         DSUMM = DSUM(JOR)
         JORBES = JOR
         ENDIF
  350 CONTINUE
      IF (DSUMM .LT. 0.) THEN
         WRITE(LIS6,  FMT = '('' Not a single hit ! '')')
         RETURN
         ENDIF
      DSUMM = 0.30 * DSUMM
      JORP = 0
      CALL SHIFTP (JORBES, JORP, WENDO)
      IF (JORP .EQ. 0) THEN
         WRITE(LIS6,  FMT = '('' No suitable shift found ! '')')
         RETURN
         ENDIF
      DO 391 JOR = 1, 2*NORIG
      IF (JOR .EQ. JORBES) GOTO 391
      IF ( DSUM(JOR) .LT. DSUMM) GOTO 391
      CALL SHIFTP (JOR, JORP, WENDO)
  391 CONTINUE
      CALL KERNZI (0, ISC, MORE)
      CALL KERNZA (0.0, DSC, MORE)
      CALL KERNZI (0, NSUM, 32)
      DO 490 IOX = 1, JORP
      JOR = ISHIF(IOX)
      IOR = JOR
      IC = 1
      IF (JOR .GT. NORIG) THEN
         IOR = JOR - NORIG
         IC = 2
         ENDIF
      DO 480 IO = 1, NOT
      DO 408  J = 1, 3
  408 XS(J) = OTXYZ(J,IO)
      DO 409 J = 1, 3
  409 XS1(J)= XS(J) + ORGVEC(J,IOR)
      DO 470 IS = 1, NSYMM
      CALL SYMOP1 (IS, XS1, XS2)
      DO 450 IL = 1, NLATT
      CALL SYMOP2 (IC, IL, XS2, XS3)
      DO 419 J = 1, 3
  419 XS3(J)= XS3(J) - PSHIF(J,IOX)
      DO 440 IA = 1, NAT
      CALL DISTSQ (XR(1,IA), XS3, DMAX, XSHIFT, DIST2)
      IF (DIST2 .GT. DMAX2) GOTO 440
      DIST = SQRT (DIST2)
      IF (ISC(IOX, IO) .NE. 0) THEN
         IF (DIST .GT. DSC(IOX, IO)) GOTO 440
      ELSE
         NSUM(IOX) = NSUM(IOX) + 1
         ENDIF
      ISC(IOX, IO) = IA
      DSC(IOX, IO) = DIST
  440 CONTINUE
  450 CONTINUE
  470 CONTINUE
  480 CONTINUE
  490 CONTINUE
      CALL COMPRI (JORP)
      RETURN
      END
      SUBROUTINE SHIFTP (JOR, JORP, WENDO)
      INCLUDE 'Zcrys.inc'
      IF (IPOLA.LE.2 .OR. IPOLA.EQ.4) THEN
         CALL SHIFT1 (JOR, JORP, WENDO)
      ELSE
         CALL SHIFT2 (JOR, JORP, WENDO)
         ENDIF
      RETURN
      END
      SUBROUTINE SHIFT1 (JOR, JORP, WENDO)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zatom7.inc'
      COMMON /BLANK7/
     *                ORGVEC(3, 32), NORIG, DMAX, DMAX2,
     *       NSUM(32), DSUM(32), PSHIF(3,32), ISHIF(32), ZSHIF(32),
     *       ZSUMA, ISC(32, MAXAT), DSC(32, MAXAT),
     *       IP(3), DELXYZ(3, 32, MAXAT), IZXYZ(32, MAXAT),
     *       XR(3,MAXAT), XS(3), XS1(3), XS2(3), XS3(3), XSHIFT(3)
     *     , ZFAMA, ZFAMB
      DIMENSION KMAX(3), XYZINC(3), KSHIF(3), WSHIF(3),
     *       SKARR(3,500), WKARR(3,500), TKARR(3,500), VKARR(3,500)
      IF (JORP .GE. 32) THEN
         WRITE (8, FMT='('' More then 32 shift vectors! reduce..'')')
         RETURN
         ENDIF
      CALL KERNZA (0.0, SKARR, 1500)
      CALL KERNZA (0.0, WKARR, 1500)
      DO 110 I = 1, 3
      T = 0.2 / CELL(I)
      KMAX(I) = NINT (1./ T)
      XYZINC(I) = 1. / FLOAT(KMAX(I))
  110 CONTINUE
      IOX = NSUM(JOR)
      DO 130 IX = 1, IOX
      DO 120 I = 1, 3
      IF (IP(I) .EQ. 0) GOTO 120
      K = INT (DELXYZ(I, JOR, IX) / XYZINC(I) ) + 1
      SKARR(I,K) = SKARR(I,K) + DELXYZ(I,JOR,IX) * IZXYZ(JOR, IX)
      WKARR(I,K) = WKARR(I,K) + FLOAT ( IZXYZ(JOR, IX) )
  120 CONTINUE
  130 CONTINUE
      WEND = 0.0
      DO 150  I = 1,3
      KSHIF(I) = 0
      WSHIF(I) = 0.0
      IF (IP(I) .EQ. 0 ) GOTO 150
      KM = KMAX(I)
      SKARR(I,KM) = SKARR(I,KM) + SKARR(I, KM+1)
      WKARR(I,KM) = WKARR(I,KM) + WKARR(I, KM+1)
      SKARR(I,KM+1) = SKARR(I,1)
      WKARR(I,KM+1) = WKARR(I,1)
      SKARR(I,KM+2) = SKARR(I,2)
      WKARR(I,KM+2) = WKARR(I,2)
      DO 140 K = 1,KM
      TKARR(I,K) = SKARR(I,K) + SKARR(I,K+1) + SKARR(I,K+2)
      VKARR(I,K) = WKARR(I,K) + WKARR(I,K+1) + WKARR(I,K+2)
      IF (VKARR(I,K) .GT. 1.) TKARR(I,K) = TKARR(I,K) / VKARR(I,K)
      IF (VKARR(I,K) .GT. WSHIF(I)) THEN
         WSHIF(I) = VKARR(I,K)
         KSHIF(I) = K
         ENDIF
  140 CONTINUE
      K = KSHIF(I)
      IF (K .EQ. 0) RETURN
      WEND = WSHIF(I)
      IF (WEND .LT. 0.30 * WENDO) RETURN
      JORP = JORP + 1
      IF (JORP .GT. 32) THEN
         WEND = 0.0
         WRITE (8, FMT='('' > 32 shift vectors! out of bonds'')')
         RETURN
         ENDIF
      PSHIF(I, JORP) = TKARR(I,K)
      ZSHIF(JORP) = WEND
      ISHIF(JORP) = JOR
      IF (WEND .GT. WENDO) WENDO = WEND
  150 CONTINUE
  200 WEND = -1.
      DO 250  I = 1,3
      IF (IP(I) .EQ. 0 ) GOTO 250
      K = KSHIF(I)
      KSHIF(I) = 0
      WSHIF(I) = 0.0
      KM = KMAX(I)
      WKARR(I,K) = 0.
      SKARR(I,K) = 0.
      K1 = MOD (K, KM) + 1
      WKARR(I,K1) = 0.
      SKARR(I,K1) = 0.
      K2 = MOD (K1, KM) + 1
      WKARR(I,K2) = 0.
      SKARR(I,K2) = 0.
      WKARR(I,KM+1) = WKARR(I,1)
      SKARR(I,KM+1) = SKARR(I,1)
      WKARR(I,KM+2) = WKARR(I,2)
      SKARR(I,KM+2) = SKARR(I,2)
      DO 240 K = 1,KM
      TKARR(I,K) = SKARR(I,K) + SKARR(I,K+1) + SKARR(I,K+2)
      VKARR(I,K) = WKARR(I,K) + WKARR(I,K+1) + WKARR(I,K+2)
      IF (VKARR(I,K) .GT. 1.) TKARR(I,K) = TKARR(I,K) / VKARR(I,K)
      IF (VKARR(I,K) .GT. WSHIF(I)) THEN
         WSHIF(I) = VKARR(I,K)
         KSHIF(I) = K
         ENDIF
  240 CONTINUE
      K = KSHIF(I)
      IF (K .EQ. 0) RETURN
      WEND = WSHIF(I)
      IF (WEND .LT. 0.30 * WENDO) RETURN
      JORP = JORP + 1
      PSHIF(I, JORP) = TKARR(I,K)
      ZSHIF(JORP) = WEND
      ISHIF(JORP) = JOR
  250 CONTINUE
      IF (JORP .LT. 32) GOTO 200
      RETURN
      END
      SUBROUTINE SHIFT2 (JOR, JORP, WENDO)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zatom7.inc'
      COMMON /BLANK7/
     *                ORGVEC(3, 32), NORIG, DMAX, DMAX2,
     *       NSUM(32), DSUM(32), PSHIF(3,32), ISHIF(32), ZSHIF(32),
     *       ZSUMA, ISC(32, MAXAT), DSC(32, MAXAT),
     *       IP(3), DELXYZ(3, 32, MAXAT), IZXYZ(32, MAXAT),
     *       XR(3,MAXAT), XS(3), XS1(3), XS2(3), XS3(3), XSHIFT(3)
     *     , ZFAMA, ZFAMB
      PARAMETER (MQ = 150)
      DIMENSION KMAX(3), XYZINC(3), KSHIF(3), WSHIF(3),
     *       SKARR(MQ,MQ), WKARR(MQ,MQ), TKARR(MQ,MQ), VKARR(MQ,MQ)
      PARAMETER (MQM = MQ - 2, MQMQ = MQ * MQ)
      DATA LIS6 / 26 /
      WRITE (8,FMT='('' TEST start SHIFT2 JOR JORP'',3I4)') JOR, JORP
      CALL KERNZA (0.0, SKARR, MQMQ)
      CALL KERNZA (0.0, WKARR, MQMQ)
      DO 110 I = 1, 3
      T = 0.2 / CELL(I)
      KMAX(I) = NINT (1./ T)
      IF (KMAX(I) .GT. MQM) KMAX(I) = MQM
      XYZINC(I) = 1. / FLOAT(KMAX(I))
  110 CONTINUE
      WRITE (LIS6, FMT='('' Grid increments, KMAX'', 3F7.4, 9X, 3I4)')
      I1 = 1
      I2 = 3
      IF (IUNIQ .EQ. 1) I1 = 2
      IF (IUNIQ .EQ. 3) I2 = 2
      IOX = NSUM(JOR)
      WRITE (LIS6, FMT='('' TEST in SHIFT               '',  3I3)')
      WRITE (LIS6, FMT='('' TEST IOX = NSUM() nr of hits'',  3I3)') IOX
      DO 130 IX = 1, IOX
      K1 = INT (DELXYZ(I1, JOR, IX) / XYZINC(I1) ) + 1
      K2 = INT (DELXYZ(I2, JOR, IX) / XYZINC(I2) ) + 1
      WKARR(K1,K2) = WKARR(K1,K2) + IZXYZ(JOR, IX)
  130 CONTINUE
      WEND = 0.0
      CALL KERNZI (0, KSHIF, 3)
      CALL KERNZA (0.0, WSHIF, 3)
      KM1 = KMAX(I1)
      KM2 = KMAX(I2)
      WRITE (LIS6, FMT='('' TEST samenst.  KM1, KM2 '',3I3)') KM1, KM2
      DO 134 K1 = 1, KM1 + 1
      WKARR(K1,KM2) = WKARR(K1,KM2) + WKARR(K1, KM2+1)
  134 CONTINUE
      DO 135 K2 = 1, KM2
      WKARR(K2,KM1) = WKARR(K2,KM1) + WKARR(K2, KM1+1)
  135 CONTINUE
      DO 136 K1 = 1, KM1
      WKARR(K1,KM2+1) = WKARR(K1,1)
      WKARR(K1,KM2+2) = WKARR(K1,2)
  136 CONTINUE
      DO 137 K2 = 1, KM2 + 2
      WKARR(K2,KM1+1) = WKARR(K2,1)
      WKARR(K2,KM1+2) = WKARR(K2,2)
  137 CONTINUE
      CALL KERROR (' Call PTB !!', 0, 'SHIFT2')
      DO 140 K = 1,KM
      TKARR(I,K) = SKARR(I,K) + SKARR(I,K+1) + SKARR(I,K+2)
      VKARR(I,K) = WKARR(I,K) + WKARR(I,K+1) + WKARR(I,K+2)
      IF (VKARR(I,K) .GT. 1.) TKARR(I,K) = TKARR(I,K) / VKARR(I,K)
      IF (VKARR(I,K) .GT. WSHIF(I)) THEN
         WSHIF(I) = VKARR(I,K)
         KSHIF(I) = K
         ENDIF
  140 CONTINUE
      K = KSHIF(I)
      IF (K .EQ. 0) RETURN
      WEND = WSHIF(I)
      IF (WEND .LT. 0.30 * WENDO) RETURN
      IF (IPOLA.LE.2 .OR. IPOLA.EQ.4) THEN
         JORP = JORP + 1
         PSHIF(I, JORP) = TKARR(I,K)
         ZSHIF(JORP) = WEND
         ISHIF(JORP) = JOR
      IF (WEND .GT. WENDO) WENDO = WEND
         ENDIF
  200 WEND = -1.
      DO 250  I = 1,3
      IF (IP(I) .EQ. 0 ) GOTO 250
      K = KSHIF(I)
      KSHIF(I) = 0
      WSHIF(I) = 0.0
      KM = KMAX(I)
      WKARR(I,K) = 0.
      SKARR(I,K) = 0.
      K1 = MOD (K, KM) + 1
      WKARR(I,K1) = 0.
      SKARR(I,K1) = 0.
      K2 = MOD (K1, KM) + 1
      WKARR(I,K2) = 0.
      SKARR(I,K2) = 0.
      WKARR(I,KM+1) = WKARR(I,1)
      SKARR(I,KM+1) = SKARR(I,1)
      WKARR(I,KM+2) = WKARR(I,2)
      SKARR(I,KM+2) = SKARR(I,2)
      DO 240 K = 1,KM
      TKARR(I,K) = SKARR(I,K) + SKARR(I,K+1) + SKARR(I,K+2)
      VKARR(I,K) = WKARR(I,K) + WKARR(I,K+1) + WKARR(I,K+2)
      IF (VKARR(I,K) .GT. 1.) TKARR(I,K) = TKARR(I,K) / VKARR(I,K)
      IF (VKARR(I,K) .GT. WSHIF(I)) THEN
         WSHIF(I) = VKARR(I,K)
         KSHIF(I) = K
         ENDIF
  240 CONTINUE
      K = KSHIF(I)
      IF (K .EQ. 0) RETURN
      WEND = WSHIF(I)
      IF (WEND .LT. 0.30 * WENDO) RETURN
      JORP = JORP + 1
      PSHIF(I, JORP) = TKARR(I,K)
      ZSHIF(JORP) = WEND
      ISHIF(JORP) = JOR
  250 CONTINUE
      IF (JORP .LT. 32) GOTO 200
      RETURN
      END
