      PROGRAM DIRDIF
C-----------------------------------------------------------------------
CPROGRAM DIRDIF                unified version                      2008
C                              subfile DIRDIF1.FOR
C                              contents:   DIRDIF-main  +  NIJX routines
C-----------------------------------------------------------------------
C dirdif MAIN program contains:
C - some COMMON bloks definitions
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zatomx.inc'
      INCLUDE 'Zatq2.inc'
      INCLUDE 'Zbinx.inc'
      INCLUDE 'Zbuff.inc'
      INCLUDE 'Zch80.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zfcala.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zwils.inc'
      COMMON /FFTDA/ SCALEW, MH(3), NPP(3), XLMIN(3), XLMAX(3)
      COMMON /SINGP/ SINGPK, ORIGIN, PATP(8)
      COMMON /BLANK/ ITAB4(160000)
      KEYT = 1
      DATUM = ' version 2008.3   updt 15 Aug. 2008 '
      CALL DDUNIF
      END
      SUBROUTINE CONDAT
      INCLUDE 'Zaaaa.inc'
      PARAMETER (KEND = 20)
      CHARACTER*6 CONDA(KEND)
      SAVE NCALL
      DATA CONDA / 'STLMAX', 'HKLMAX', 'SCALE' , 'BOV'   , 'BP'
     *           , 'BR',     '$DUMM$', 'PARAMS', 'VMAX'  , 'MIN'
     *           , 'PRINT' , 'PRIMAP', 'LOCCEN', 'NCEST' , 'ACCEPT'
     *           , 'EMIN'  , 'SCSG'  , 'BHSG'  , 'DAMP'  , 'PRIMAP'/
      DATA NCALL /0/
      IF (NCALL .GT. 0) RETURN
      NCALL = NCALL + 1
      MESS = 0
      STLMAX = 0.0
      CALL KERNZA (0.0, HKLMAX, 3)
      SCALE = 1.0
      BOV = 2.0
      BP = 2.0
      BR = 2.0
      LEVEL = 0
      LEV6 = 24
      LEV7 = 8
      LEV8 = 27
      CALL FILINQ (13, 'CONDAT', 'FORMATTED', 'INPUT', K)
      IF (K .EQ. -1) GOTO 400
      I = 0
  100 CONTINUE
      CALL KERINA (13, CONDA, KEND, K)
      IF (K .NE. 0) GOTO 300
      I = I + 1
      IF (I .GT. 1) GOTO 200
      IF (LIT(1) .NE. 'CONDAT' ) THEN
         WRITE (9, FMT='(1X/A)') ' Incorrect CONDAT file: ignored! '
         MESS = MESS + 1
         GOTO 300
         ENDIF
      IF (LIT(2) .EQ. ' ') GOTO 100
      IF (CCODE .NE. ' ' .AND. LIT(2) .EQ. CCODE)  GOTO 100
      WRITE (24, FMT='(/A)')
     *    ' Incorrect CCODE on CONDAT file: ignored! '
      MESS = MESS + 1
      GOTO 300
  200 CONTINUE
      IF (LIT(1) .EQ. 'TITLE') THEN
         WRITE (9, FMT='(1X,'' CONDAT: '', A61)') CHIN(1:61)
         MESS = MESS + 1
         GOTO 100
         ENDIF
      IF (LIT(1) .EQ. 'REMARK') GOTO 100
      ISKIP = 0
      IF ( LITJ1.EQ.'PATTY'  .OR. LITJ2 .EQ. 'PATTY' ) ISKIP = 1
      IF ( LITJ1.EQ.'ORIENT' .OR. LITJ2 .EQ. 'ORIENT' .OR.
     *     LITJ1.EQ.'TRACOR' .OR. LITJ2 .EQ. 'TRACOR' ) ISKIP = 2
      DO 290 K = 1, KEND
      CALL KERING (CONDA(K), N, KTOT)
      IF (N .LE. 0) GOTO 290
      GOTO (1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20), K
    1 CONTINUE
      IF (FNUM(N) .GT. 0.01) THEN
         STLMAX = FNUM(N)
         WRITE (9, FMT='('' CONDAT: STLMAX ='', F10.5)') STLMAX
         MESS = MESS + 1
         ENDIF
      GOTO 290
    2 CONTINUE
      IF (KTOT .LT. 3) THEN
         WRITE (9, FMT='('' CONDAT error: HKLMAX needs 3 numbers !'')')
         MESS = MESS + 1
         GOTO 290
         ENDIF
      CALL KERNAB (FNUM(N), HKLMAX, 3)
      WRITE (9, FMT='('' CONDAT: HKLMAX ='', 3F5.0)') HKLMAX
      MESS = MESS + 1
      GOTO 290
    3 CONTINUE
      IF (FNUM(N) .GT. 0.00001) THEN
         SCALE = FNUM(N)
         WRITE (9, FMT='('' CONDAT: SCALE  ='', F10.5)') SCALE
         MESS = MESS + 1
         ENDIF
      GOTO 290
    4 CONTINUE
      IF (FNUM(N) .GT. 0.001) THEN
         BOV = FNUM(N)
         WRITE (9, FMT='('' CONDAT: BOV  ='', F8.4)') BOV
         MESS = MESS + 1
         ENDIF
      GOTO 290
    5 CONTINUE
      IF (ISKIP .EQ. 2) GOTO 290
      IF (FNUM(N) .GT. 0.001) THEN
         BP = FNUM(N)
         WRITE (9, FMT='('' CONDAT: BP   ='', F8.4)') BP
         IF (ISKIP .EQ. 1) WRITE (9,
     *         FMT='(''      note: BP   = BPatt used for sharpening'')')
         MESS = MESS + 1
         ENDIF
      GOTO 290
    6 CONTINUE
      IF (ISKIP .GE. 1) GOTO 290
      IF (FNUM(N) .GT. 0.001) THEN
         BR = FNUM(N)
         WRITE (9, FMT='('' CONDAT: BR   ='', F8.4)') BR
         MESS = MESS + 1
         ENDIF
      GOTO 290
    7 CONTINUE
      GOTO 290
    8 CONTINUE
      GOTO 290
    9 CONTINUE
      GOTO 290
   10 CONTINUE
      GOTO 290
   11 CONTINUE
      LEVEL = NINT(FNUM(1))
      IF (LEVEL .EQ. 0) GOTO 290
      WRITE (9, FMT='('' CONDAT: PRINT LEVEL ='', I2)') LEVEL
      MESS = MESS + 1
      LEV6 = 9
      IF (LEVEL .EQ. 1) GOTO 290
      LEV8 = 8
      IF (LEVEL .EQ. 2) GOTO 290
      LEV7 = 24
      GOTO 290
   12 CONTINUE
      GOTO 290
   13 CONTINUE
      GOTO 290
   14 CONTINUE
      GOTO 290
   15 CONTINUE
      GOTO 290
   16 CONTINUE
      GOTO 290
   17 CONTINUE
      GOTO 290
   18 CONTINUE
      GOTO 290
   19 CONTINUE
      GOTO 290
   20 CONTINUE
  290 CONTINUE
      GOTO 100
  300 CONTINUE
      IF (MESS .GT. 0) WRITE (9, FMT='('' --------------------''/ 1X )')
      CALL FILCLO (13, 'KEEP')
      CALL WR24
  400 CONTINUE
      OPEN (UNIT = 27, FORM = 'FORMATTED', STATUS = 'SCRATCH')
      RETURN
      END
      SUBROUTINE FILINX (FNAME)
      CHARACTER *64 FNAME
      INCLUDE 'Zsyst.inc'
      CHARACTER *6 CCCC, CA, CB
      CA = FNAME(1:6)
      CB = '  '
      CALL KERC2L (CA, CB, 6)
      FNAME = CB
      IF (FNAME.NE.'res' .AND. FNAME.NE.'ins' .AND. FNAME.NE.'hkl' .AND.
     *    FNAME.NE.'cif' .AND. FNAME.NE.'spf' ) RETURN
      IF (  CCODE .EQ. ' ' ) RETURN
      CCCC = '  '
      CALL KERC2L (CCODE, CCCC, 6)
      L = 0
      DO 10 I = 1, 6
         IF ( CCODE(I:I) .EQ. ' ' ) GOTO 20
         L = L + 1
   10 CONTINUE
   20 CONTINUE
      FNAME = CCCC(1:L) // '.' // CB
      RETURN
      END
      SUBROUTINE KERASE (FNAMEX)
      CHARACTER FNAMEX*(*), FNAME*64
      FNAME = FNAMEX
      CALL FILTES (FNAMEX, KINQ)
      IF (KINQ .LT. 0) RETURN
      IF (KINQ .GT. 0) THEN
         CALL FILCLO (KINQ, 'DELETE')
      ELSE
         CALL FILCLO (19, 'KEEP')
         CALL FILINX (FNAME)
         OPEN (UNIT=19, FILE=FNAME, STATUS='OLD')
         CALL FILCLO (19, 'DELETE')
         ENDIF
      RETURN
      END
      SUBROUTINE WR24
      INCLUDE 'Zsyst.inc'
      CHARACTER CH*72
      SAVE NCALL, NBL
      DATA NCALL, NBL /0, 0/
      DATA LIS3 /25/
      IF (NCALL .EQ. 0) THEN
         NCALL = 1
         OPEN (UNIT = 9, FORM = 'FORMATTED', STATUS = 'SCRATCH')
         OPEN (UNIT = 24, FORM = 'FORMATTED', STATUS = 'SCRATCH')
         OPEN (UNIT = 7, FORM = 'FORMATTED', STATUS = 'SCRATCH')
         OPEN (UNIT = 8, FORM = 'FORMATTED', STATUS = 'SCRATCH')
         WRITE (9, FMT='('' '')')
         WRITE (24, FMT='('' '')')
         WRITE (7, FMT='('' '')')
         WRITE (8, FMT='('' '')')
         CH = ' '
         CALL WINOUT (CH)
         WRITE (CH, 1175)  DATUM
 1175 FORMAT (' ========== DIRDIF ==========     ', A36)
         CALL WINOUT (CH)
         CH = ' '
         CALL WINOUT (CH)
         CALL KERASE ('LIS3')
         OPEN (UNIT = 25,FORM = 'FORMATTED', FILE='lis3',STATUS = 'NEW')
         WRITE (LIS3,FMT='(/'' File LIS3 = selected DIRDIF testresults''
     *    // '' This file will be overwritten at each DIRDIF call''//)')
         RETURN
         ENDIF
      WRITE (24, FMT='(''$PTB$   unit 24'')')
      REWIND 24
  123 CONTINUE
      CH = ' '
      READ (24, FMT='(A)') CH
      IF (CH(1:5) .EQ. '$PTB$') GOTO 199
      WRITE (7, FMT='(A)') CH
      WRITE (8, FMT='(A)') CH
      GOTO 123
  199 CONTINUE
      REWIND 24
      WRITE (9, FMT='(''$PTB$   unit 9 '')')
      REWIND 9
  223 CONTINUE
      CH = ' '
      READ (9, FMT='(A)') CH
      IF (CH(1:5) .EQ. '$PTB$') GOTO 299
      IF (CH .EQ. ' ') THEN
         NBL = NBL + 1
         IF (NBL .GE. 2) GOTO 223
      ELSE
         NBL = 0
         ENDIF
      CALL WINOUT (CH)
      WRITE (7, FMT='(''! '', A72)') CH
      WRITE (8, FMT='(''! '', A72)') CH
      GOTO 223
  299 CONTINUE
      REWIND 9
      END
      SUBROUTINE WININP (CH)
      CHARACTER CH*80
      CALL WR24
      INCLUDE 'Zwini.inc'
      SUBROUTINE WINOUT (CH)
      INCLUDE 'Zwino.inc'
      SUBROUTINE KERNAB (A, B, N)
      DIMENSION A(N), B(N)
      DO 100 I=1,N
  100 B(I) = A(I)
      RETURN
      END
      SUBROUTINE KERNAI (IA, IB, N)
      DIMENSION IA(N), IB(N)
      DO 100 I=1,N
  100 IB(I) = IA(I)
      RETURN
      END
      SUBROUTINE KERNAC (CHA, CHB, N)
      CHARACTER *6 CHA(N), CHB(N)
      DO 100 I=1,N
  100 CHB(I) = CHA(I)
      RETURN
      END
      SUBROUTINE KERNZA (X, A, N)
      DIMENSION A(N)
      DO 100 I=1,N
  100 A(I) = X
      RETURN
      END
      SUBROUTINE KERNZI (IX, IA, N)
      DIMENSION IA(N)
      DO 100 I=1,N
  100 IA(I) = IX
      RETURN
      END
      SUBROUTINE KERNZ1 (CH, CHA, N)
      CHARACTER * 1  CH, CHA(N)
      DO 100 I=1,N
  100 CHA(I) = CH
      RETURN
      END
      SUBROUTINE KERNZ6 (CH, CHA, N)
      CHARACTER *6  CH, CHA(N)
      DO 100 I=1,N
  100 CHA(I) = CH
      RETURN
      END
      SUBROUTINE KEREQ1 (L, LL, N, KEND)
      CHARACTER *1  LL(N), L
      DO 100 KEND=1,N
      IF (LL(KEND).EQ.L) GOTO 110
  100 CONTINUE
      KEND = -1
  110 RETURN
      END
      SUBROUTINE KEREQ6 (L6, LL6, N, KEND)
      CHARACTER * 6  L6, LL6(N)
      DO 110 KEND=1,N
      IF (L6.NE.LL6(KEND)) GOTO 110
      RETURN
  110 CONTINUE
      KEND = -1
      RETURN
      END
      SUBROUTINE KERC2I (L, KEND)
      CHARACTER * 1 L, LLL(49), LLC(26)
      DATA LLL / '1','2','3','4','5', '6','7','8','9',' ',
     +           'A','B','C','D','E', 'F','G','H','I','J',
     +           'K','L','M','N','O', 'P','Q','R','S','T',
     +           'U','V','W','X','Y', 'Z','+','-','.',',',
     +           '*','/','=','$','''','(',')','?',':'      /
      DATA LLC / 'a','b','c','d','e', 'f','g','h','i','j',
     +           'k','l','m','n','o', 'p','q','r','s','t',
     +           'u','v','w','x','y', 'z'                  /
      KEND = 0
      IF (L.EQ.'0') RETURN
      CALL KEREQ1 (L, LLL, 49, KEND)
      IF (KEND.GT.0) RETURN
      CALL KEREQ1 (L, LLC,  26, KEND)
      IF (KEND.GT.0) KEND = KEND + 10
      RETURN
      END
      SUBROUTINE KERI2C (I, CCC, N)
      CHARACTER * 6  CCC
      CHARACTER * 1  N10(10)
      DATA N10 / '1', '2', '3', '4', '5', '6', '7', '8', '9', '0' /
      CCC = ' '
      JNUM = IABS(I)
      NN = N
      IF (NN .GT. 6) NN = 6
      K = 10**NN
      IF (JNUM .GE. K) JNUM = K-1
      J = K / 10
      DO 100 L=1,NN
      IF (JNUM.GE.J) GOTO 110
      NN = NN- 1
      J = J / 10
  100 CONTINUE
  110 DO 120 L=1,NN
      K = JNUM / J
      IF (K.EQ.0) THEN
         CCC(L:L) = N10(10)
      ELSE
         CCC(L:L) = N10(K)
         ENDIF
      JNUM = JNUM - K*J
  120 J = J / 10
      RETURN
      END
      SUBROUTINE KERI2F (IA, FA, N)
      DIMENSION IA(N), FA(N)
      DO 100 I=1,N
  100 FA(I) = IA(I)
      RETURN
      END
      SUBROUTINE KERF2I (FA, IA, N)
      DIMENSION FA(N), IA(N)
      DO 100 I=1,N
  100 IA(I) = NINT (FA(I))
      RETURN
      END
      SUBROUTINE KERC2U (CA, CB, N)
      CHARACTER CA *(*), CB *(*)
      CHARACTER * 1  LUC(26), LLC(26), Z
      DATA LUC / 'A','B','C','D','E', 'F','G','H','I','J',
     +           'K','L','M','N','O', 'P','Q','R','S','T',
     +           'U','V','W','X','Y', 'Z'                  /
      DATA LLC / 'a','b','c','d','e', 'f','g','h','i','j',
     +           'k','l','m','n','o', 'p','q','r','s','t',
     +           'u','v','w','x','y', 'z'                  /
      DO 120 I = 1, N
      CB(I:I) = CA(I:I)
      IF (CB(I:I) .EQ. ' ') GOTO 120
      Z = CB(I:I)
      CALL KEREQ1 (Z, LLC, 26, KEND)
      IF (KEND .LE. 0) GOTO 120
      CB(I:I) = LUC(KEND)
  120 CONTINUE
      RETURN
      END
      SUBROUTINE KERC2L (CA, CB, N)
      CHARACTER CA *(*), CB *(*)
      CHARACTER * 1  LUC(26), LLC(26), Z
      DATA LUC / 'A','B','C','D','E', 'F','G','H','I','J',
     +           'K','L','M','N','O', 'P','Q','R','S','T',
     +           'U','V','W','X','Y', 'Z'                  /
      DATA LLC / 'a','b','c','d','e', 'f','g','h','i','j',
     +           'k','l','m','n','o', 'p','q','r','s','t',
     +           'u','v','w','x','y', 'z'                  /
      DO 120 I = 1, N
      CB(I:I) = CA(I:I)
      IF (CB(I:I) .EQ. ' ') GOTO 120
      Z  = CB(I:)
      CALL KEREQ1 (Z, LUC, 26, KEND)
      IF (KEND .LE. 0) GOTO 120
      CB(I:I) = LLC(KEND)
  120 CONTINUE
      RETURN
      END
      SUBROUTINE KERICH (I, CH, KEND)
      CHARACTER * 1 CH, LLL(50), LLC(26)
      DATA LLL / '1','2','3','4','5', '6','7','8','9',' ',
     +           'A','B','C','D','E', 'F','G','H','I','J',
     +           'K','L','M','N','O', 'P','Q','R','S','T',
     +           'U','V','W','X','Y', 'Z','+','-','.',',',
     +           '*','/','=','$','''','(',')','?',':','@'  /
      DATA LLC / 'a','b','c','d','e', 'f','g','h','i','j',
     +           'k','l','m','n','o', 'p','q','r','s','t',
     +           'u','v','w','x','y', 'z'                  /
      IF (I .GT. 99) GOTO 100
      IF (I .EQ. 0) THEN
         CH = '0'
      ELSEIF (I .LT. 0 .OR. I .GT. 76) THEN
         CH = ' '
      ELSEIF (I .LE. 50) THEN
         CH = LLL(I)
      ELSE
         CH = LLC (I - 50)
         ENDIF
      RETURN
  100 CONTINUE
      KEND = 0
      IF (CH .EQ. '0') RETURN
      CALL KEREQ1 (CH, LLL, 50, KEND)
      IF (KEND.GT.0) RETURN
      CALL KEREQ1 (CH, LLC,  26, KEND)
      IF (KEND.GT.0) KEND = KEND + 50
      IF (KEND.LE.0) KEND = 97
      RETURN
      END
      SUBROUTINE KEPROG (NAME)
      CHARACTER NAME *(*)
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zch80.inc'
      PROGNM = NAME
      PROSNM = ' '
      CALL KERNZI (0, KEYS, 28)
      DO 101 I=10,28
  101 SWITCH(I) = .FALSE.
      CALL WR24
      WRITE (8, FMT='(1X)')
      IF (NRECYR .EQ. 0) THEN
         WRITE (24, 105)  PROGNM
  105    FORMAT (1X/1X/' ============ Program ', A8)
         IF (PROGNM .EQ. 'ORIENT' .OR. PROGNM .EQ. 'TRACOR' .OR.
     *       PROGNM .EQ. 'TRAVEC') THEN
             WRITE (24, FMT='('' ===========================''/1X)')
             ENDIF
      ELSE
         WRITE (24, 106) PROGNM, IPAT, NRECYR, NRECYS, NRECYT
  106    FORMAT (1X/1X/' ============ Program ', A8, 8X, 'IPAT=', I2,
     *       4X, '[cycle', I3, ' /', I2,I2, ']'/1X)
         ENDIF
      CALL WR24
      WRITE (8, FMT='(1X/1X/1X)')
      CALL FILCLO (2, 'KEEP')
      CALL FILINQ (2, 'DDSYST', 'FORMATTED', 'INPUT', KIDDS)
      IF (KIDDS .EQ. -1) CALL KERROR ('No DDSYST file', 152, 'KEPROG')
      CALL KERINA (2, LIT, 1, LEND)
      IF (LIT(1) .NE. PROGNM(1:6))
     *     CALL KERROR (' Incorrect DDSYST file', 152, 'KEPROG')
      NCH = 0
  201 CALL KERINA (2, LIT, 1, LEND)
      IF (LEND .EQ. -1) GOTO 207
      NCH = NCH + 1
      CH80(NCH) = CHIN
      GOTO 201
  207 REWIND 2
      DO 208 I = 1, NCH
  208 WRITE (2, FMT = '(A80) ') CH80(I)
      REWIND 2
      CALL FILCLO (2, 'KEEP')
      RETURN
      END
      SUBROUTINE KEPROX
      INCLUDE 'Zsyst.inc'
      EQUIVALENCE (IDOKA, KEYS(10))
      CHARACTER * 2  IISO
      DATA IISO   / '==' /
      WRITE (8, 111)  PROGNM, (IISO, I=1,23)
  111 FORMAT (/' End of program ' , A8 / ' ' , 23A2  // )
      DO 200 I=1,20
      IF (I.GE.6 .AND. I.LE.8) GOTO 200
      CALL FILCLO (I, 'KEEP')
  200 CONTINUE
      IF (IDOKA .EQ. -17) CALL DDEXIT
      IDOKA = 17
      RETURN
      END
      SUBROUTINE KERNER (KEY, NAME)
      CHARACTER NAME *(*), NAMEX *8
      INCLUDE 'Zsyst.inc'
      EQUIVALENCE (IRUN, KSTAT(13))
      CHARACTER * 6  SUBPGM
      DATA SUBPGM /'SUBPGM'/
      NAMEX = NAME
      IF (PROSNM.EQ.' ') SUBPGM=' '
      CALL WR24
      CALL FILCLO (20, 'KEEP')
      CALL FILINQ (20, 'DDSTOP', 'FORMATTED', 'OUTPUT', KINQ)
      IF (KINQ .LT. 0) THEN
         WRITE (20, FMT= '(''DDSTOP  error stop in RUN'', I4,
     *      ''  for CCODE = '', A6)') IRUN, CCODE
         WRITE (20, FMT= '(''ERROR MESSAGE:'')')
      ELSE
         READ (20, END=99, FMT='(1X)')
         READ (20, END=99, FMT='(1X)')
         READ (20, END=99, FMT='(1X)')
         ENDIF
   99 CONTINUE
      WRITE (9, 100) PROGNM, SUBPGM, PROSNM, NAMEX
      WRITE (20, 100) PROGNM, SUBPGM, PROSNM, NAMEX
  100 FORMAT (' ERROR STOP IN ' ,A8, 3X,A6,1X,A6,' MODULE ',A8)
      IF (KEY.EQ.0) GOTO 190
      IF (KEY.LT.0) GOTO 120
  110 WRITE (CHOUT, 111) KEY
  111 FORMAT (' ERROR NUMBER',I6)
      IF (KEY.EQ.-99) CHOUT(20:41) = '?? impossible error ??'
      GOTO 190
  120 WRITE (CHOUT, 130) KEY
  130 FORMAT (' ERROR NUMBER', I5)
      IF (KEY .LT. -6 .OR. KEY .EQ. -4) GOTO 110
      WRITE (9, FMT='(A72)') CHOUT
      WRITE (20, FMT='(A72)') CHOUT
      IF (KEY.EQ.-1) THEN
         CHOUT = ' ERROR : INPUT DATA INCORRECT'
      ELSEIF (KEY.EQ.-2) THEN
         CHOUT = ' ERROR : INPUT DATA FILE(S) INCORRECT'
      ELSEIF (KEY.EQ.-3) THEN
         CHOUT = ' ERROR : SORRY, DATA IS INCONSISTENT'
      ELSEIF (KEY.EQ.-5) THEN
         CHOUT = ' ERROR ... SEE MANUAL FOR DETAILS....'
      ELSEIF (KEY.EQ.-6) THEN
         WRITE (9, 188)
         WRITE (20, 188)
  188 FORMAT (' ERROR : INPUT DATA INCORRECT'/
     *        ' ERROR : LAST INPUT RECORD WAS:')
         CHOUT = CHIN(1:72)
         ENDIF
  190 CONTINUE
      WRITE (9, FMT='(A72)') CHOUT
      WRITE (20, FMT='(A72)') CHOUT
      WRITE (24, 200)
      WRITE (20,200)
  200 FORMAT (1X/' ERROR ! '/
     * ' The present error-stop  is the result of an internal test'/
     * ' which could refer to a user- or to a programmers-error. '/
     * ' If the present error message is not clear to you,  please, '/
     * ' tell us about it: we would like to know what can go wrong. '/
     * ' Thank you for your help.   Paul T. Beurskens.'/
     * '                   email:   PTBeurskens[at]hetnet.nl'/1X)
      CALL WR24
      WRITE (20, FMT='(''STOP'')')
      CALL FILCLO ( 20, 'KEEP')
      CALL KERASE ('MERCUR')
      WRITE (7, FMT='(/''$FINISH'')')
      WRITE (8, FMT='(/''$FINISH'')')
      CALL DDEXIT
      END
      SUBROUTINE KERROR (MESGE, KEY, NAME)
      CHARACTER MESGE *(*) , MESGEX *70
      CHARACTER NAME  *(*)
      INCLUDE 'Zsyst.inc'
      PARAMETER (ISTOP=20)
      EQUIVALENCE (IRUN, KSTAT(13))
      MESGEX = MESGE
      CALL WR24
      WRITE (9, 100) MESGEX
  100 FORMAT (1X/' ERROR : ', A70)
      CLOSE (UNIT = ISTOP)
      CALL FILINQ (ISTOP, 'DDSTOP', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (ISTOP, FMT=   '(''DDSTOP  error stop in RUN'',
     *   I4, ''  for CCODE = '', A6)') IRUN, CCODE
      WRITE (ISTOP, FMT='(''ERROR MESSAGE:'')')
      WRITE (ISTOP, 100) MESGEX
      WRITE (ISTOP, FMT='(''END'')')
      CALL KERNER (KEY, NAME)
      END
      SUBROUTINE KERINA (IRD, L, LMAX, LEND)
      CHARACTER * 6  L(LMAX)
      INCLUDE 'Zsyst.inc'
      LEND = 0
      IF (IRD .LE. 0) STOP 27
      IF (IRD .EQ. 5) THEN
         CALL WININP(CHIN)
         IF (CHIN .EQ. ' ') GOTO 120
         GOTO 130
         ENDIF
      CHIN = ' '
      READ (IRD, 110, ERR = 199, END = 120, IOSTAT = NINQ) CHIN
  110 FORMAT (A)
      IF (NINQ .EQ. 0) GOTO 130
  120 LEND = -1
      CHIN = ' '
  130 CALL KERINB (L, LMAX)
      IF (LEND.LE.-1) RETURN
      IF (LIT(1).EQ.'END   ') LEND = 4
      IF (LIT(1).EQ.'FINISH') LEND = 5
      IF (LIT(1).EQ.'STOP  ') LEND = 6
      RETURN
  199 CONTINUE
      WRITE (CHOUT, FMT='('' QUEST: '', A6, '' ? '')') L(1)
      CALL KERROR (CHOUT(1:16), 199, 'KERINA')
      END
      SUBROUTINE KERINB (LUSER, LUMAX)
      INCLUDE 'Zsyst.inc'
      CHARACTER * 6  LUSER(LUMAX)
      CHARACTER * 1  CH1
      CHARACTER * 6  CHLIT, IBL, LBOS
      DATA IDMAX  / 32 /
      DATA IBL    /'  '/
      DATA MCOL   / 80 /
      CALL KERNZ6 (IBL,  LIT, IDMAX)
      CALL KERNZA (0.0, FNUM, IDMAX)
      CALL KERNZI (0,  NCOLN, IDMAX)
      CALL KERNZI (0,  NCOLL, IDMAX)
      CALL KERNZI (0,  NFDOT, IDMAX)
      CALL KERNZI (0,  NFDOL, IDMAX)
      CALL KERNZI (0, NLUSER, IDMAX)
      LUMA = LUMAX
      IF (LUMA.EQ.1 .AND. LUSER(1).EQ.' ') LUMA = 0
      NFNUM = 0
      NLIT  = 0
      ITEM  = 0
      KEND  = 0
      NEND  = 0
      I = 1
  110 IF (I.GT.MCOL) GOTO 270
      DO 120 K=I,MCOL
      CH1 = CHIN(K:K)
      IF (CH1.NE.' ' .AND. CH1.NE.',') GOTO 130
  120 CONTINUE
      GOTO 270
  130 NONUM  = 0
      NONUM2 = 0
      NSIG = 0
      NDOT = 0
      I = K
      DO 170 K=I,MCOL
      CH1 = CHIN(K:K)
      CALL KERC2I (CH1, J)
      IF (J.GE.0 .AND. J.LE.9) GOTO 140
      IF (CH1.EQ.'.') GOTO 150
      IF (J.LT.0 .OR. J.GE.41) GOTO 240
      IF (J.GE.11 .AND. J.LE.36) GOTO 240
      IF (NDOT.EQ.1  .AND. NONUM.EQ.0) GOTO 240
      IF (CH1.EQ.',' .AND. NONUM.EQ.0) GOTO 240
      IF (CH1.EQ.',') GOTO 180
      IF (CH1.EQ.'+'.OR. CH1.EQ.'-') GOTO 160
      IF (NONUM2.EQ.1) GOTO 240
      IF (NSIG.EQ.1) GOTO 170
      IF (NONUM.EQ.0) GOTO 240
      GOTO 180
  140 NONUM  = 1
      NONUM2 = 0
      NSIG = 0
      GOTO 170
  150 NDOT = NDOT + 1
      IF (NDOT.EQ.2) GOTO 240
      GOTO 170
  160 IF (NSIG.EQ.1) GOTO 240
      IF (NDOT.EQ.1 .AND. NONUM.EQ.0) GOTO 240
      NSIG = 1
      NONUM2 = NONUM
      NONUM  = 0
      NDOT = 0
  170 CONTINUE
      IF (NONUM.EQ.0) GOTO 240
  180 ITEM  = ITEM  + 1
      NFNUM = NFNUM + 1
      IF (NFNUM.LE.IDMAX) NCOLN(NFNUM) = I
      IF (NFNUM.GT.IDMAX) NCOLN(IDMAX) = - IABS(NCOLN(IDMAX))
      NONUM = 0
      NSIG  = 0
      NDOT  = 0
      DO 220 K=I,MCOL
      CH1 = CHIN(K:K)
      CALL KERC2I (CH1, J)
      IF (J.GE.0 .AND. J.LE.9) GOTO 190
      IF (CH1.EQ.'.') GOTO 200
      IF (CH1.EQ.',') GOTO 230
      IF (CH1.EQ.'+' .OR. CH1.EQ.'-') GOTO 210
      IF (J.NE.10) CALL KERNER (-4, 'KERINB')
      IF (NSIG.EQ.1) GOTO 220
      IF (NONUM.EQ.1) GOTO 230
      CALL KERNER (-4, 'KERINB')
  190 CONTINUE
      NONUM = 1
      NSIG  = 0
      GOTO 220
  200 NDOT = 1
      GOTO 220
  210 IF (NONUM.EQ.1) GOTO 230
      NSIG  = 1
      NONUM = 0
  220 CONTINUE
      KEND = 999
  230 CONTINUE
      CALL KERINF (CHIN, I, K-1, A, NEND)
      I = K
      IF (NFNUM.LE.IDMAX) FNUM(NFNUM)  = A
      IF (NFNUM.LE.IDMAX) NFDOT(NFNUM) = NDOT+1
      IF (NFNUM.GT.IDMAX) NFNUM = IDMAX
      IF (ITEM.LE.IDMAX)  NFDOL(ITEM) = NDOT+1
      GOTO 110
  240 ITEM = ITEM + 1
      NLIT = NLIT + 1
      IF (NLIT.LE.IDMAX) NCOLL(NLIT)  = I
      IF (NLIT.GT.IDMAX) NCOLL(IDMAX) = - IABS(NCOLL(IDMAX))
      L = 1
      CHLIT = ' '
      DO 250 K=I,MCOL
      CH1 = CHIN(K:K)
      IF (CH1.EQ.' ' .OR. CH1.EQ.',') GOTO 260
      IF (L.LE.6) CHLIT(L:L) = CH1
  250 L = L + 1
      KEND = 999
      L = MCOL - I + 2
  260 I = K
      IF (NLIT.LE.IDMAX) LIT(NLIT) = CHLIT
      IF (NLIT.GT.IDMAX) NLIT = IDMAX
      IF (ITEM.LE.IDMAX) NFDOL(ITEM) = 1 - L
      IF (NLIT.GT.IDMAX) GOTO 270
      CALL KERC2U (LIT(NLIT), LBOS, 6)
      LIT(NLIT) = LBOS
      IF (LUMA.GT.0) CALL KEREQ6 (LIT(NLIT), LUSER, LUMA, NLUSER(NLIT))
      IF (KEND.EQ.999) I = KEND
      GOTO 110
  270 RETURN
      END
      SUBROUTINE KERINC (IPRX, LEND)
      INCLUDE 'Zsyst.inc'
      LOGICAL SWPRI
      EQUIVALENCE (SWPRI, SWITCH(10))
      CHARACTER * 6  L(9)
      DATA  L     / '    ', 'REMARK', 'TITLE', 'END', 'FINISH',
     +              'STOP', 'BATCH',  '     ', 'PRINT' /
      DATA LMAX / 9 /
      CALL KEREQ6 (LIT(1), L, LMAX, LEND)
      IF (LEND.LE.0) GOTO 100
      GOTO (1,2,3,4,4,4,7,1,9), LEND
    1 IF (NFNUM.LE.0) GOTO 4
  100 LEND = 0
      RETURN
    2 IF (IPRX .GT. 0) WRITE (IPRX, 110) CHIN(1:72)
  110 FORMAT (1X, 72A )
      GOTO 4
    3 CONTINUE
    4 RETURN
    7 CONTINUE
      GOTO 150
    9 SWPRI = .TRUE.
  150 IF (SWPRI) WRITE (8, 110)  CHIN(1:72)
      RETURN
      END
      SUBROUTINE KERINF (CHIN, I, K, FF, KEND)
      CHARACTER * 80 CHIN
      CHARACTER * 6  LL
      CHARACTER * 8  CHFMT
      M = K - I + 1
      KEND = 0
      CALL KERI2C (M, LL, 6)
      CHFMT = '(F'//LL(1:3)//'.0)'
      READ (CHIN(I:K), FMT = CHFMT, ERR = 99) FF
      RETURN
   99 KEND = -1
      RETURN
      END
      SUBROUTINE KERIFF (IRD, L, LMAX, LEND)
      INCLUDE 'Zsyst.inc'
      LOGICAL      SWPRI
      EQUIVALENCE (SWPRI, SWITCH(10))
      CHARACTER * 6  L(LMAX)
      IPRX = 0
      IF (SWPRI) IPRX = 8
  100 CALL KERINA (IRD, L, LMAX, LEND)
      IF (LEND.LE.-1) RETURN
      CALL KERINC (IPRX, LEND)
      IF (LEND.EQ.0) RETURN
      IF (LEND.LT.3 .OR. LEND.GT.7) GOTO 100
      RETURN
      END
      SUBROUTINE KETERM (KNUM, KLIT, KEND)
      INCLUDE 'Zsyst.inc'
      CHARACTER Z *1
      DATA I / 0 /
      IF (KNUM.EQ.0 .AND. KLIT.EQ.0) CALL KERNER (-4, 'KETERM')
      CALL WR24
      CHIN = ' '
      CALL WININP (CHIN)
      IF (CHIN .EQ. ' ') THEN
         WRITE (9, 110)
  110    FORMAT (' Your input line is empty' )
         KEND = -1
         RETURN
         ENDIF
      CALL KERINB (LIT, 1)
      IF ((KNUM.GE.0 .AND. NFNUM.NE.KNUM) .OR.
     *    (KLIT.GE.0 .AND. NLIT .NE.KLIT))    THEN
         WRITE (9, 142) KLIT, KNUM, NLIT, NFNUM
  142    FORMAT (' Program requested', I3, ' literal(s) and',
     +   I3, ' number(s)' / ' but you supplied:', I3,
     +   ' literal(s) and', I3, ' number(s). Please, try again'  /1X)
         KEND = -3
         RETURN
         ENDIF
      KEND = 99
      IF (NFDOL(2).NE.0) RETURN
      IF (NLIT.EQ.1)  I = NCOLL(1)
      IF (NFNUM.EQ.1) I = NCOLN(1)
      IF (CHIN(I+1:I+1).NE.' ') RETURN
      Z = CHIN(I:I)
      CALL KERC2I (Z, KEND)
      IF (KEND.LT.0) KEND = 99
      RETURN
      END
      SUBROUTINE FILINQ (IUNIT, FNAMEX, FFORMX, FKEYX, KINQ)
      CHARACTER FNAMEX *(*), FFORMX *(*), FKEYX *(*),
     *          FNAME  *64,  FFORM  *11,  FKEY  *7
      INCLUDE 'Zsyst.inc'
      CHARACTER FORMIN *11, FULNAM *255, POSFMT *7, POSUNF *7, FULNA *63
      LOGICAL   OPN, EXS, NMD
      FNAME = '  '
      FNAME = FNAMEX
      CALL FILINX (FNAME)
      FFORM = FFORMX
      FKEY  = FKEYX
      KINQ = 0
      IF ((FKEY.NE.'SCRATCH' .AND. FKEY.NE.'INPUT'
     *    .AND. FKEY.NE.'OUTPUT') .OR. IUNIT.LE.0 .OR. IUNIT.GT.29) THEN
         WRITE (9, 148) IUNIT, FNAME, FKEY
  148    FORMAT (1X/' ERROR in call FILINQ (',I3, 1X, A6, 1X, A6, ')')
         CALL KERROR('Programmers error in call params', 148, 'FILINQ')
         ENDIF
      CALL FILCLO (IUNIT, 'KEEP')
      CALL FILTES (FNAMEX, KINQQ)
      IF (KINQQ .GT. 0 .AND. KINQQ .NE. IUNIT) THEN
         WRITE (CHOUT, 149) FNAMEX, KINQQ, IUNIT
  149    FORMAT (' File error: file, KINQQ, IUNIT = ', A6, 2I3)
         CALL KERROR (CHOUT, -4, 'FILINQ')
         ENDIF
      INQUIRE (FILE = FNAME, ERR  = 900, IOSTAT = KINQ, EXIST = EXS,
     *         OPENED = OPN, FORM = FORMIN, NUMBER = NUM,
     *         NAMED  = NMD, NAME = FULNAM,
     *         FORMATTED = POSFMT, UNFORMATTED = POSUNF)
      IF ( EXS ) THEN
         IF ( OPN ) CALL KERROR (' 2007 ? impossible!', -4, 'FILINQ')
         IF (FFORM .EQ. '  FORMATTED' .AND. POSFMT .EQ. 'NO') GOTO 930
         IF (FFORM .EQ. 'FORMATTED'   .AND. POSFMT .EQ. 'NO') GOTO 930
         IF (FFORM .EQ. 'UNFORMATTED' .AND. POSUNF .EQ. 'NO') GOTO 932
         IF (FKEY .EQ. 'SCRATCH') THEN
            OPEN (UNIT = IUNIT, ERR = 940, IOSTAT = KINQ,
     *            FORM = FFORM, STATUS = 'SCRATCH')
            REWIND IUNIT
            KINQ = 0
            RETURN
            ENDIF
         OPEN (UNIT = IUNIT, ERR = 940, IOSTAT = KINQ, FILE = FNAME,
     *         FORM = FFORM, STATUS = 'OLD')
         REWIND IUNIT
         KINQ = 0
         RETURN
      ELSE
         IF (FKEY .EQ. 'SCRATCH') THEN
            OPEN (UNIT = IUNIT, ERR = 950, IOSTAT = KINQ,
     *            FORM = FFORM, STATUS = 'SCRATCH')
         ELSEIF (FKEY .EQ. 'OUTPUT') THEN
            OPEN (UNIT = IUNIT, ERR = 950, IOSTAT = KINQ, FILE = FNAME,
     *            FORM = FFORM, STATUS = 'NEW')
            ENDIF
         KINQ = -1
         ENDIF
      RETURN
  900 WRITE (7, 901) IUNIT, FNAME, KINQ
  901 FORMAT (
     *' ERROR Transmission error during execution of INQUIRE statement'/
     * 'ERROR ? Unit number:',I3,' File name: ', A24,' Error code:',I4)
      GOTO 990
  912 WRITE (7, 913)
  913 FORMAT (' ERROR :',
     *    ' Full file name not returned by INQUIRE, unnamed file!')
      GOTO 990
  917 FULNA = FULNAM(1:63)
      WRITE (7, 918) FULNA
  918 FORMAT (' ERROR : Full file name: ',A63)
      GOTO 990
  930 WRITE (7, 931) FNAME, IUNIT, FFORM, POSFMT
  931 FORMAT (' ERROR :',
     * ' The requested I/O-access mode for an already existing file' /
     * ' ERROR !',
     * ' does not match the allowed I/O-access mode for this file as' /
     * ' ERROR !',
     * ' found by INQUIRE for filenm: ',A24, 'Unit nr: ', I2 /
     * ' ERROR !',
     * ' Requested mode: ', A11, 5X, 'FORMATTED mode allowed: ', A7)
      IF ( NMD ) GOTO 917
      GOTO 912
  932 WRITE (7, 933) FNAME, IUNIT, FFORM, POSUNF
  933 FORMAT (' ERROR :',
     * ' The requested I/O-access mode for an already existing file' /
     * ' ERROR !',
     * ' does not match the allowed I/O-access mode for this file as' /
     * ' ERROR !',
     * ' found by INQUIRE for filenm: ',A24, 'Unit nr: ', I2 /
     * ' ERROR !',
     * ' Requested mode: ', A11, 5X, 'UNFORMATTED mode allowed: ', A7)
      IF ( NMD ) GOTO 917
      GOTO 912
  940 WRITE (7, 941) FKEY, IUNIT, FNAME, KINQ
  941 FORMAT (' ERROR :',
     * ' Transmission error during execution of OPEN statement' /
     * ' ERROR ! on an already existing file, option ', A7 /
     * ' ERROR !',
     * ' Unit nr: ',I2, 4X, 'Filenm: ', A24, ' Error code: ',I4)
      GOTO 990
  950 WRITE (7, 951) FKEY, IUNIT, FNAME, KINQ
  951 FORMAT (' ERROR :',
     * ' Transmission error during execution of OPEN statement' /
     * ' ERROR ! for a new file, option ', A7 /
     * ' ERROR !',
     * ' Unit nr: ',I2, 4X, 'Filenm: ', A24, ' Error code: ',I4)
  990 WRITE (CHOUT, 992) FNAME(1:13)
  992 FORMAT (' File error concerning file (name): ', A13)
      CALL KERROR (CHOUT, 0, 'FILINQ')
      END
      SUBROUTINE FILTES (FNAMEX, KINQ)
      CHARACTER FNAMEX *(*), FNAME  *64
      LOGICAL   OPN, EXS
      FNAME = ' '
      FNAME = FNAMEX
      CALL FILINX (FNAME)
      INQUIRE (FILE=FNAME, EXIST=EXS, OPENED=OPN, NUMBER=NUM)
      KINQ = -1
      IF ( .NOT. EXS ) RETURN
      KINQ = 0
      IF ( .NOT. OPN ) RETURN
      KINQ = NUM
      RETURN
      END
      SUBROUTINE FILCLO (IUNIT, FKEYX)
      CHARACTER  FKEYX *(*), FKEY *7
      INCLUDE 'Zsyst.inc'
      LOGICAL  OPN
      IF (IUNIT.EQ.5 .OR. IUNIT.EQ.6 .OR. IUNIT.EQ.9) RETURN
      FKEY = FKEYX
      IF (FKEY.NE.'KEEP'.AND.FKEY.NE.'DELETE') GOTO 999
      INQUIRE (UNIT = IUNIT, ERR = 201, OPENED = OPN)
      IF (.NOT. OPN) RETURN
      CLOSE (UNIT = IUNIT, ERR = 202, IOSTAT = KCLO, STATUS = FKEY)
      IF (KCLO.LE.0) RETURN
  201 WRITE (9, FMT='('' inquire error in FILCLO'')')
      GOTO 999
  202 WRITE (9, FMT='('' CLOSE error in FILCLO'')')
  999 WRITE (9, FMT='('' CLOSE IUNIT'',I3,'' FKEY  '',A7)') IUNIT,FKEY
      CALL WR24
      STOP 35
      END
      SUBROUTINE RDCRYS (ICRYS)
      INCLUDE 'Zsyst.inc'
      INCLUDE 'Zcrys.inc'
      CHARACTER CONT*1
      CHARACTER * 6  XTEST
      CHARACTER * 6  LLIT(30)
      CHARACTER * 6  NAME
      SAVE NPRI
      DATA NAME    / 'RDCRYS' /
      DATA LLMAX   / 27 /
      DATA LLIT   / 'CRYSDA', 'CELL  ', 'CELLSD', 'SPGR  ', 'RCELL ',
     +              'VOLUM ', 'WAVE  ', 'FORMUL', 'MOLW  ', 'Z     ',
     +              'NELEC ', 'F000  ', 'MU    ', 'ICENT ', 'ILATT ',
     +              'ISYST ', 'ILAUE ', 'IMULT ', 'IUNIQ ', 'IPOLA ',
     +              'NTYPE ', 'NSYMM ', 'NLATT ', 'FRAC2C', 'CART2F',
     +              'RRMAT ', 'SSMAT ', '      ', '      ', '      ' /
      DATA NPRI / 0 /
      CALL FILINQ (ICRYS, 'CRYSDA', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.EQ.-1) THEN
         WRITE (CHOUT, 100) CCODE
  100    FORMAT (' ERROR no CRYSDA file found for ', A6)
         CALL KERROR (CHOUT, 0, 'RDCRYS')
         ENDIF
      NPRI = NPRI + 1
      DO 7101 I = 1,10
 7101 CELATY(I) = '  '
      DO 170 I=1,LLMAX
      CALL RDCRYB (ICRYS, LLIT(I), KEND)
      IF (KEND.LT.0) THEN
         WRITE (9, 917) LLIT(I)
  917    FORMAT (' ERROR : search for keyword ', A6,
     *           ' on CRYSDA file failed')
         GOTO 990
         ENDIF
      GOTO  (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
     *      16,17,18,19,20,21,22,23,24, 25, 26, 27,170,170,170), I
    1 IF (NPRI .EQ. 1) WRITE (8, 101)
  101 FORMAT (' Input crystal data file  CRYSDA')
      CALL KERINB (LIT,1)
      IF (CCODE .EQ. ' ' .OR. CCODE .EQ. 'CCODE') CCODE = LIT(2)
      IF (CCODE .EQ. LIT(2)) GOTO 170
      WRITE (24, 102) LIT(2), CCODE
  102 FORMAT (' Error: compound code on CRYSDA file is: ', A6,
     * ' expected: ', A6)
      GOTO 990
    2 READ (CHIN, 130) CELL
      GOTO 170
    3 READ (CHIN, 130) CELLSD
      GOTO 170
    4 CONTINUE
      SPGR = CHIN(11:26)
      GOTO 170
    5 READ (CHIN, 130) RCELL
      GOTO 170
    6 READ (CHIN, 130) VOLUM
      GOTO 170
    7 READ (CHIN, 107) WAVEAT, WAVE
  107 FORMAT (10X, A2, 8X, F10.6)
      GOTO 170
    8 READ (CHIN, 108) (CELATY(J), CELALL(J), J=1,5), CONT
  108 FORMAT (10X, 5(A2, F9.2, 1X), 1X, A1)
      IF (CONT.EQ.'=') READ (ICRYS,108) (CELATY(J), CELALL(J), J=6,10)
      GOTO 170
    9 READ (CHIN, 130) AMOLW
      GOTO 170
   10 READ (CHIN, 140) IZ
      ZET = IZ
      GOTO 170
   11 READ (CHIN, 140) NELEC
      GOTO 170
   12 READ (CHIN, 130) F000
      GOTO 170
   13 READ (CHIN, 130) ABSMU
      GOTO 170
   14 READ (CHIN, 140) ICENT
      GOTO 170
   15 READ (CHIN, 140) ILATT
      GOTO 170
   16 READ (CHIN, 140) ISYST
      GOTO 170
   17 READ (CHIN, 140) ILAUE
      GOTO 170
   18 READ (CHIN, 140) IMULT
      GOTO 170
   19 READ (CHIN, 140) IUNIQ
      GOTO 170
   20 READ (CHIN, 140) IPOLA
      GOTO 170
   21 READ (CHIN, 140) NTYPE
      DO 121 J=1,NTYPE
  121 CELALL(J) = CELALL(J) * ZET
      GOTO 170
   22 READ (CHIN, 140) NSYMM
      DO 122 M=1,NSYMM
  122 READ (ICRYS,1122) XTEST, ((IRSYMM(J,K,M),K=1,3),TSYMM(J,M),J=1,3)
 1122 FORMAT (A6, 4X, 3(3I3,1X,F10.7))
      IF (XTEST .NE. 'SYMMAT') GOTO 990
      GOTO 170
   23 READ (CHIN, 140) NLATT
      DO 123 M=1,NLATT
  123 READ (ICRYS, 1123) XTEST, (TLATT(J,M), J=1,3)
 1123 FORMAT (A6, 4X, 3(F10.7))
      IF (XTEST .NE. 'CENVEC') GOTO 990
      GOTO 170
   24 BACKSPACE ICRYS
      READ (ICRYS, 150) ((FRAC2C(J,K), K=1,3), J=1,3)
      GOTO 170
   25 BACKSPACE ICRYS
      READ (ICRYS, 150) ((CART2F(J,K), K=1,3), J=1,3)
      GOTO 170
   26 BACKSPACE ICRYS
      READ (ICRYS, 150) ((RRMAT(J,K), K=1,3), J=1,3)
      GOTO 170
   27 BACKSPACE ICRYS
      READ (ICRYS, 150) ((SSMAT(J,K), K=1,3), J=1,3)
  130 FORMAT (10X, 6F10.5)
  140 FORMAT (10X, I10)
  150 FORMAT (10X, 3F15.6 / 10X, 3F15.6 / 10X, 3F15.6 )
  170 CONTINUE
      AMULT = FLOAT (IMULT)
      ASYMM = FLOAT (NSYMM)
      ALATT = FLOAT (NLATT)
      ASYMCL= FLOAT (ICENT*NLATT)
      NSYMC = NSYMM * ICENT
      ASYMC = FLOAT (NSYMC)
      CALL KERNZI (0, IZTYPE, 10)
      DO 233 J=1,NTYPE
      CALL ATOMIZ (CELATY(J), NLET, IZ)
      IZTYPE(J) = IZ
  233 CONTINUE
      NATSYM = 0
      DO 244 IT = 1, NTYPE
      IF (IZTYPE(IT).NE.1) NATSYM = NATSYM + NINT ( CELALL(IT) )
  244 CONTINUE
      NATSYM = NATSYM / IMULT
      IF (NPRI .NE. 1) RETURN
      WRITE (8, 371) CELL, SPGR
  371 FORMAT (' Cell', 3F8.3, 3F7.2, '  SpGr ', A16/1X)
      IF (PROGNM .EQ. 'DDSTART' .OR. PROGNM .EQ. 'FFT')
     *   WRITE (24, 371) CELL, SPGR
      CALL WR24
      RETURN
  990 WRITE (24,991) LLIT(I)
  991 FORMAT (' ERROR : CONTENTS OF CRYSDA FILE INCORRECT: '/
     *        ' ERROR ! TRYING TO READ RECORD: ', A6)
      CALL KERNER (-6, NAME)
      RETURN
      END
      SUBROUTINE RDCRYB (ICRYS, LLITX, KEND)
      CHARACTER LLITX *(*), LLIT *6
      INCLUDE 'Zsyst.inc'
      LLIT = LLITX
      KEND = -3
  100 CHIN = ' '
      READ (ICRYS, 110, END=120) CHIN
  110 FORMAT (A)
      IF (CHIN(1:4).EQ.'END')  GOTO 120
      IF (CHIN(1:6).EQ.LLIT) GOTO 130
      GOTO 100
  120 KEND = KEND + 1
      REWIND ICRYS
      IF (KEND.LT.-1) GOTO 100
      RETURN
  130 KEND = 1
      RETURN
      END
      SUBROUTINE RDCRYX (ICRYS, LLITX, F, N)
      CHARACTER LLITX *(*), LLIT *6
      DIMENSION F(N)
      INCLUDE 'Zsyst.inc'
      CHARACTER * 6  NAME
      DATA NAME   / 'RDCRYX' /
      LLIT = LLITX
      CALL RDCRYB (ICRYS, LLIT, KEND)
      IF (KEND.LT.0) GOTO 990
      M = MIN0 (6, N)
      READ (CHIN, 100) (F(I), I=1,M)
  100 FORMAT (10X, 6F10.5)
      IF (N.LE.6) RETURN
      IF (LLIT.NE.'SFAC') GOTO 990
      READ (ICRYS, 110) (F(I), I=7,N)
  110 FORMAT (10X, 3F10.5, 2F7.3, F11.3, F5.2)
      RETURN
  990 CALL KERNER (-2, NAME)
      RETURN
      END
      SUBROUTINE RCELLR (CELL, V, RCELL)
      DIMENSION CELL(6), RCELL(6), AC(6)
      EQUIVALENCE (AC(1),      A), (AC(2),      B),  (AC(3),      C)
      EQUIVALENCE (AC(4),  ALPHA), (AC(5),   BETA),  (AC(6),  GAMMA)
      R2D = 45. / ATAN(1.0)
      CALL KERNAB (CELL, AC, 6)
      CA = COS(ALPHA / R2D)
      CB = COS(BETA  / R2D)
      CC = COS(GAMMA / R2D)
      SA = SQRT(1.0-CA**2)
      SB = SQRT(1.0-CB**2)
      SC = SQRT(1.0-CC**2)
      CASTR = (CB*CC-CA) / (SB*SC)
      CBSTR = (CA*CC-CB) / (SA*SC)
      CCSTR = (CA*CB-CC) / (SA*SB)
      SASTR = SQRT(1.0-CASTR**2)
      SBSTR = SQRT(1.0-CBSTR**2)
      SCSTR = SQRT(1.0-CCSTR**2)
      V = A*B*C * SQRT (1.0-CA*CA-CB*CB-CC*CC+2.0*CA*CB*CC)
      RCELL(1) = B*C*SA / V
      RCELL(2) = A*C*SB / V
      RCELL(3) = A*B*SC / V
      RCELL(4) = ASIN(SASTR) * R2D
      RCELL(5) = ASIN(SBSTR) * R2D
      RCELL(6) = ASIN(SCSTR) * R2D
      IF (CASTR .LT. 0.0) RCELL(4) = 180.0 - RCELL(4)
      IF (CBSTR .LT. 0.0) RCELL(5) = 180.0 - RCELL(5)
      IF (CCSTR .LT. 0.0) RCELL(6) = 180.0 - RCELL(6)
      RETURN
      END
      SUBROUTINE CELLRR (CELL, RR)
      DIMENSION CELL(6), RR(3,3)
      R2D = 45. / ATAN(1.0)
      CA = COS(CELL(4) / R2D)
      CB = COS(CELL(5) / R2D)
      CC = COS(CELL(6) / R2D)
      RR(1,1) = CELL(1) * CELL(1)
      RR(1,2) = CELL(1) * CELL(2) * CC
      RR(1,3) = CELL(1) * CELL(3) * CB
      RR(2,1) = RR(1,2)
      RR(2,2) = CELL(2) * CELL(2)
      RR(2,3) = CELL(2) * CELL(3) * CA
      RR(3,1) = RR(1,3)
      RR(3,2) = RR(2,3)
      RR(3,3) = CELL(3) * CELL(3)
      RETURN
      END
      SUBROUTINE CELZAT (ACELTY, NCELTY, NCELLZ)
      DIMENSION ACELTY(10), NCELTY(10), NCELLZ(10)
      CHARACTER ACELTY *2
      INCLUDE 'Zsyst.inc'
      INCLUDE 'Zcrys.inc'
      DIMENSION JCELLZ(10)
      DO 160 N = 1, NTYPE
  160 CALL ATOMIZ(CELATY(N), K, JCELLZ(N))
      DO 180 N = 1, 10
      NCELLZ(N) = 0
      NCELTY(N) = 0
  180 ACELTY(N) = ' '
      LZ = 999
      DO 580 N = 1, NTYPE
      DO 570 J = 1, NTYPE
      IF (JCELLZ(J) .GE. LZ) GOTO 570
      IF (JCELLZ(J) .EQ. NCELLZ(N))
     *   NCELTY(N) = NCELTY(N) + NINT(CELALL(J))
      IF (JCELLZ(J) .GT. NCELLZ(N)) THEN
         NCELLZ(N) = JCELLZ(J)
         NCELTY(N) = NINT(CELALL(J))
         ACELTY(N) = CELATY(J)
         ENDIF
  570 CONTINUE
  580 LZ = NCELLZ(N)
      WRITE (8, 611) (ACELTY(I), I=1,NTYPE)
  611 FORMAT (' Cell contents.  Atoms:  ', 10(3X, A2))
      WRITE (8, 612) (NCELLZ(I), I=1,NTYPE)
  612 FORMAT (17X, 'Z =  : ', 10I5)
      WRITE (8, 613) (NCELTY(I), I=1,NTYPE)
  613 FORMAT (' Total number of atoms: ', 10I5)
      RETURN
      END
      SUBROUTINE BINIFF (KEY, IFI, FILENM, FITEMS, NIT, BUF, NEND)
      CHARACTER FILENM *(*), FILEN *6
      DIMENSION BUF(60)
      INCLUDE 'Zsyst.inc'
      DIMENSION FITEMS (NIT)
      PARAMETER (MAXBUF = 60)
      DATA FSTOP / -66.9E06 /
      IF (IFI.LE.0 .OR. IFI.GT.20) CALL KERROR (' IFI?',-4,'BINIFF')
      FILEN = FILENM
      IF (KEY) 140, 110, 100
  100 CONTINUE
      CALL FILCLO (IFI, 'KEEP')
      CALL FILINQ (IFI, FILEN, 'UNFORMATTED', 'INPUT', KINQ)
      IF (KINQ.LT.0) THEN
         WRITE (CHOUT, FMT='(''Binary input file '',
     *         A6, '' not found'')') FILEN
         CALL KERROR (CHOUT, 0, 'BINIFF')
         ENDIF
      NEND = -1
      RETURN
  110 IF (NEND.LT.0) GOTO 115
      IF (NEND.LE.MAXBUF-NIT) GOTO 120
  115 READ (IFI, ERR=148, END=149, IOSTAT=NINQ) BUF
      IF (NINQ .NE. 0) GOTO 150
      NEND = 0
  120 IF (BUF(NEND+1).LE.FSTOP) GOTO 130
      CALL KERNAB (BUF(NEND+1), FITEMS, NIT)
      NEND = NEND + NIT
      RETURN
  130 NEND = -1
  140 RETURN
  148 WRITE (7, FMT='('' ---- lable 148 --- '')')
      GOTO 150
  149 WRITE (7, FMT='('' ---- EOF --- '')')
  150 WRITE (CHOUT, 160) FILEN, IFI
  160 FORMAT (' Error reading input file ', A6, ', unit number ', I3)
      CALL KERROR (CHOUT, 0, 'BINIFF')
      END
      SUBROUTINE BINOFF (KEY, IFO, FILENM, FITEMS, NIT, BUF, NEND)
      CHARACTER FILENM *(*), FILEN *6
      PARAMETER (MAXBUF = 60)
      DIMENSION BUF(60)
      INCLUDE 'Zsyst.inc'
      DIMENSION FITEMS (NIT)
      DATA FSTOP / -67.0E06 /
      IF (IFO.LE.0 .OR. IFO.GT.20) CALL KERROR (' IFO?',-4,'BINOFF')
      FILEN = FILENM
      IF (KEY) 120, 110, 100
  100 CONTINUE
      CALL FILINQ (IFO, FILEN, 'UNFORMATTED', 'OUTPUT', KINQ)
      CALL KERNZA (0., BUF, 60)
      NEND = 0
      RETURN
  110 CALL KERNAB (FITEMS, BUF(NEND+1), NIT)
      NEND = NEND + NIT
      IF (NEND .LE. MAXBUF-NIT) RETURN
      GOTO 130
  120 BUF(NEND+1) = FSTOP
      CALL KERNZA (0.0, BUF(NEND+2), MAXBUF-NEND-1)
  130 CONTINUE
      WRITE (IFO, ERR=150, IOSTAT=NINQ) BUF
      NEND = 0
      RETURN
  150 WRITE (CHOUT, 160) FILEN, IFO
  160 FORMAT (' Error writing output file ', A6, ', unit number ', I3)
      CALL KERROR (CHOUT, 0, 'BINOFF')
      RETURN
      END
      SUBROUTINE ATOMIZ (LM, NLET, IZ)
      CHARACTER * 2 LM, L, LL, LLC, LLLC
      DIMENSION L(100), LLC(100), LLLC(100)
      CHARACTER Z *1
      DATA L    / 'H ', 'HE', 'LI', 'BE', 'B ', 'C ', 'N ', 'O ', 'F ',
     *      'NE', 'NA', 'MG', 'AL', 'SI', 'P ', 'S ', 'CL', 'AR', 'K ',
     *      'CA', 'SC', 'TI', 'V ', 'CR', 'MN', 'FE', 'CO', 'NI', 'CU',
     *      'ZN', 'GA', 'GE', 'AS', 'SE', 'BR', 'KR', 'RB', 'SR', 'Y ',
     *      'ZR', 'NB', 'MO', 'TC', 'RU', 'RH', 'PD', 'AG', 'CD', 'IN',
     *      'SN', 'SB', 'TE', 'I ', 'XE', 'CS', 'BA', 'LA', 'CE', 'PR',
     *      'ND', 'PM', 'SM', 'EU', 'GD', 'TB', 'DY', 'HO', 'ER', 'TM',
     *      'YB', 'LU', 'HF', 'TA', 'W ', 'RE', 'OS', 'IR', 'PT', 'AU',
     *      'HG', 'TL', 'PB', 'BI', 'PO', 'AT', 'RN', 'FR', 'RA', 'AC',
     *      'TH', 'PA', 'U ', 'NP', 'PU', 'AM', 'CM', 'BK', 'CF', 'ES',
     *      'FM' /
      DATA LLC  / 'H ', 'He', 'Li', 'Be', 'B ', 'C ', 'N ', 'O ', 'F ',
     *      'Ne', 'Na', 'Mg', 'Al', 'Si', 'P ', 'S ', 'Cl', 'Ar', 'K ',
     *      'Ca', 'Sc', 'Ti', 'V ', 'Cr', 'Mn', 'Fe', 'Co', 'Ni', 'Cu',
     *      'Zn', 'Ga', 'Ge', 'As', 'Se', 'Br', 'Kr', 'Rb', 'Sr', 'Y ',
     *      'Zr', 'Nb', 'Mo', 'Tc', 'Ru', 'Rh', 'Pd', 'Ag', 'Cd', 'In',
     *      'Sn', 'Sb', 'Te', 'I ', 'Xe', 'Cs', 'Ba', 'La', 'Ce', 'Pr',
     *      'Nd', 'Pm', 'Sm', 'Eu', 'Gd', 'Tb', 'Dy', 'Ho', 'Er', 'Tm',
     *      'Yb', 'Lu', 'Hf', 'Ta', 'W ', 'Re', 'Os', 'Ir', 'Pt', 'Au',
     *      'Hg', 'Tl', 'Pb', 'Bi', 'Po', 'At', 'Rn', 'Fr', 'Ra', 'Ac',
     *      'Th', 'Pa', 'U ', 'Np', 'Pu', 'Am', 'Cm', 'Bk', 'Cf', 'Es',
     *      'Fm' /
      DATA LLLC / 'h ', 'he', 'li', 'be', 'b ', 'c ', 'n ', 'o ', 'f ',
     *      'ne', 'na', 'mg', 'al', 'si', 'p ', 's ', 'cl', 'ar', 'k ',
     *      'ca', 'sc', 'ti', 'v ', 'cr', 'mn', 'fe', 'co', 'ni', 'cu',
     *      'zn', 'ga', 'ge', 'as', 'se', 'br', 'kr', 'rb', 'sr', 'y ',
     *      'zr', 'nb', 'mo', 'tc', 'ru', 'rh', 'pd', 'ag', 'cd', 'in',
     *      'sn', 'sb', 'te', 'i ', 'xe', 'cs', 'ba', 'la', 'ce', 'pr',
     *      'nd', 'pm', 'sm', 'eu', 'gd', 'tb', 'dy', 'ho', 'er', 'tm',
     *      'yb', 'lu', 'hf', 'ta', 'w ', 're', 'os', 'ir', 'pt', 'au',
     *      'hg', 'tl', 'pb', 'bi', 'po', 'at', 'rn', 'fr', 'ra', 'ac',
     *      'th', 'pa', 'u ', 'np', 'pu', 'am', 'cm', 'bk', 'cf', 'es',
     *      'fm' /
      IZ = -1
      Z = LM(2:2)
      CALL KERC2I (Z, KEND1)
      NLET = 1
      IF (KEND1.GT.10 .AND. KEND1.LT.37) NLET = 2
      LL = LM(1:NLET)
      IF (LL .EQ. 'Q' .OR. LL .EQ. 'q') LL = 'H'
      IF (LL.EQ.'D' .OR. LL.EQ.'T') LL = 'H'
      IF (LL.EQ.'d' .OR. LL.EQ.'t') LL = 'H'
      DO 100 I=1,100
      IF (LL.EQ.L(I) .OR. LL.EQ.LLC(I) .OR. LL.EQ.LLLC(I)) GOTO 110
  100 CONTINUE
      RETURN
  110 IZ = I
      RETURN
      END
      SUBROUTINE ATOMCH (IZ)
      INCLUDE 'Zsyst.inc'
      CHARACTER Z *1
      CHARACTER ZZ *2
      IF (NFDOL(2).GE.0) GOTO 150
      I = NCOLL(2)
      ZZ = CHIN(I:I+1)
      CALL ATOMIZ (ZZ, NLET, IZ)
      IF (IZ .LE. 0) GOTO 150
      I = I + NLET
      IF (CHIN(I:I).NE.' ') GOTO 110
      IF (NFDOL(3).EQ.2) RETURN
      IF (NFDOL(3).LE.0) GOTO 150
      K = NCOLN(1)
      IF (CHIN(K:K).EQ.'+' .OR. CHIN(K:K).EQ.'-') RETURN
      IF (K-I.GT.4) GOTO 150
      IF (NFNUM .EQ. 3) RETURN
      CHOUT(I:NCOLN(2)-1) = CHIN(K:NCOLN(2)-1)
      CHIN(I:NCOLN(2)-1) = CHOUT(I:NCOLN(2)-1)
      CHOUT = ' '
      CALL KERINB (LIT,1)
      RETURN
  110 Z = CHIN(I:I)
      CALL KERC2I (Z, NEN)
      IF (NEN.EQ.37 .OR. NEN.EQ.38) NEN = 0
      IF (NEN.EQ.45 .OR. NEN.EQ.46) NEN = 0
      IF (NEN.LT.0 .OR. NEN.GT.9) GOTO 150
      RETURN
  150 CALL KERROR (' Incorrect atomic symbol', -6, 'ATOMCH')
      END
      SUBROUTINE ATOMIN (IFAT, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      DIMENSION ATXYZ(10,MAXAT), IZAT(MAXAT)
      CHARACTER * 6 ATNAME(MAXAT)
      INCLUDE 'Zsyst.inc'
      CHARACTER      CHIN2 *80
   99 FORMAT (/' DIRDIF cannot proceed:'/
     *         ' the input ATOMS or ATMOD file is incorrect')
      IF (IFAT.LE.0 .OR. IFAT.GT.20) CALL KERROR (' IFAT?',-4,'ATOMIN')
      KEYS(1) = 0
      READ (IFAT, 105, ERR = 940, END = 940, IOSTAT = NINQ) CHIN(1:72)
  105 FORMAT (A72)
      CHIN2 = CHIN
      CALL KERINB (LIT, 1)
      IF (LIT(1) .NE. 'ATMOD' .AND. LIT(1) .NE. 'ATOMS'
     *   .AND. LIT(1) .NE. 'ATLIT' ) GOTO 951
      IF (LIT(1) .EQ. 'ATOMS' .AND. LIT(2) .NE.  CCODE) GOTO 953
      IF (LIT(1) .EQ. 'ATLIT' .AND. LIT(2) .NE.  CCODE) GOTO 953
      LEND = 999
      NAT = 1
  107 CALL ATOMIA (IFAT, ATXYZ, ATNAME, IZAT, MAXAT, NAT, LEND)
      IF (LEND.NE.0) GOTO 200
      NAT = NAT + 1
      IF (NAT .EQ. MAXAT) CALL KERROR ('Too many atoms', -6, 'ATOMIN')
      GOTO 107
  200 CONTINUE
      KEYS(1) = LEND
      NAT = NAT - 1
      IF (NAT .LE. 0) GOTO 955
      IF (LEND .LT. 0) WRITE (9, *)
     *  ' Warning ATOMS or ATMOD file: END card missing'
      CALL ATOMST (0, ATXYZ, NAT, KEYT)
      DO 302 I = 1, NAT
      IF (ATNAME(I) (1:1) .EQ. 'Q') THEN
         ATXYZ(4,I) = 0.0
         ATXYZ(5,I) = 0.0
         ENDIF
  302 CONTINUE
      CHIN = CHIN2
      CALL KERINB (LIT, 1)
      RETURN
  940 WRITE (9, 99)
      CALL KERROR('File error reading ATOMS or ATMOD file', 0,'ATOMIN')
  951 WRITE (9, 99)
      CALL KERROR
     *   ('No file identification on ATOMS or ATMOD file', -6,'ATOMIN')
  953 WRITE (9, 99)
      CALL KERROR ('Incorrect CCODE on ATOMS file', -6,'ATOMIN')
  955 WRITE (9, 99)
      CALL KERROR
     *   ('No atoms found on ATOMS or ATMOD file', -6, 'ATOMIN')
      END
      SUBROUTINE ATOMIA (IFAT, ATXYZ, ATNAME, IZAT, MAXAT, NAT, LEND)
      DIMENSION ATXYZ(10,MAXAT),   IZAT(MAXAT)
      CHARACTER * 6 ATNAME(MAXAT)
      INCLUDE 'Zsyst.inc'
      CHARACTER CHIN2 *80 ,  LITA(4) *6
      SAVE LEND2
      DATA LITA /'ATOM', 'BIJ', 'ATESD', 'BIJESD' /
      DATA LEND2 / 0 /
      IF (LEND .EQ. 999) THEN
         CALL KERIFF (IFAT, LITA, 4, LEND)
         IF (LIT(1).NE.'ATOM') CALL KERROR
     *   ('First atom on ATOMS or ATMOD file not: ATOM', -6, 'ATOMIA')
      ELSE
         CHIN = CHIN2
         LEND = LEND2
         CALL KERINB (LIT, 1)
         ENDIF
      IF (LEND.NE.0) RETURN
      CALL ATOMCH (IZAT(NAT))
      ATNAME(NAT) = LIT(2)
      DO 110 I = 1, 10
      IF (I.LE.3 .AND. NCOLN(I).LE.0) CALL KERROR
     *   ('Data on atoms card not correct', -6, 'ATOMIA')
  110 ATXYZ(I,NAT) = FNUM(I)
  117 CALL KERIFF (IFAT, LITA, 4, LEND)
      IF (LEND .NE. 0) GOTO 201
      GOTO (201, 202, 203, 204), NLUSER(1)
      CALL KERROR
     *   ('Record on ATOMS or ATMOD file not recognised', -6, 'ATOMIA')
  201 CHIN2 = CHIN
      LEND2 = LEND
      LEND = 0
      RETURN
  202 CALL KERNAB (FNUM, ATXYZ(5,NAT), 6)
      GOTO 117
  203 CALL KERNAB (FNUM, ATXYZ(1,NAT+1), 5)
      GOTO 117
  204 CALL KERNAB (FNUM, ATXYZ(5,NAT+1), 6)
      GOTO 117
      END
      SUBROUTINE ATOMPR (IPRX, NAPR, ATXYZ, ATNAME, IZAT, NAT)
      DIMENSION ATXYZ(10,NAT), IZAT(NAT), ATNAME(NAT)
      CHARACTER *6 ATNAME
      NATX = (NAPR * 5 + 1) / 2
      IF (NATX .GT. NAT) NATX = NAT
      IF (NATX .LT. NAT) NATX = NAPR
      IF (NATX .LE. 0) NATX = MIN0 (3, NAT)
      WRITE (IPRX, FMT='('' Number of atoms stored:'', I4)') NAT
      KEYT = 1
      DO 102 I=1,NATX
      IF (ATXYZ(4,I) .LT. 0.999 .OR. ATXYZ(5,I) .GT. 0.0001) KEYT = 2
      IF (ATXYZ(6,I) .GT. 0.000001) GOTO 103
  102 CONTINUE
      IF (KEYT .EQ. 1) WRITE (IPRX, FMT='
     *   ('' Atom name    x        y        z'', 8X,''Z'')')
      IF (KEYT .EQ. 2) WRITE (IPRX, FMT=' ('' Atom name    x'',
     *    ''        y        z'', 8X,''Z   occ.f.      B'')')
      GOTO 104
  103 WRITE (IPRX, FMT=' ('' Atom name    x'',
     *    ''        y        z'', 8X,''Z   occ.f.      B.equiv.'')')
  104 DO 109 I=1,NATX
      IF (ATXYZ(4,I) .LT. 0.999 .OR. ATXYZ(5,I) .GT. 0.0001) THEN
         WRITE (IPRX, 106)  ATNAME(I), (ATXYZ(J,I),J=1,3), IZAT(I),
     *      (ATXYZ(J,I),J=4,5)
  106    FORMAT (3X, A6, 2X, 3F9.5, I4, 2F9.4)
      ELSE
         WRITE (IPRX, 106)  ATNAME(I), (ATXYZ(J,I),J=1,3), IZAT(I)
         ENDIF
  109 CONTINUE
      IF (NAT .GT. NATX) WRITE (IPRX, FMT='('' Printing of remaining'',
     *                                    '' atoms supressed.'')')
      RETURN
      END
      SUBROUTINE ATOMWR (IATOMS, ATXYZ, ATNAME, NAT)
      DIMENSION ATXYZ(10,NAT), ATNAME(NAT)
      CHARACTER *6 ATNAME
      INCLUDE 'Zsyst.inc'
      CHARACTER FATOMX * 6
      FATOMX = 'ATOMS'
      IF (SWITCH(25)) FATOMX = 'ATMOD'
      CALL ATOMWA (IATOMS)
      DO 109 NATR = 1, NAT
  109 CALL ATOMWB (IATOMS, ATXYZ, ATNAME, NATR)
      WRITE (8, 120) FATOMX, NAT
  120 FORMAT (' Number of atoms written to ', A6, 'file:', I4)
      WRITE (IATOMS, FMT = '(''END'')')
      RETURN
      END
      SUBROUTINE ATOMWA (IATOMS)
      INCLUDE 'Zsyst.inc'
      IF (SWITCH(25)) THEN
         WRITE (IATOMS, 101) PROGNM, KSTAT(13)
  101    FORMAT ('ATMOD  CART   generated by program ',
     *            A8, '  0   RUN', I4)
      ELSEIF (FNUM(32) .LT. 0.0001) THEN
         WRITE (IATOMS, 102) CCODE, PROGNM,  KSTAT(13)
  102    FORMAT ('ATOMS  ', A6, ' generated by program ',
     *            A8, '  0   RUN', I4)
      ELSE
         WRITE (IATOMS, 103) CCODE, PROGNM, KSTAT(13), FNUM(32)
  103    FORMAT ('ATOMS  ', A6, ' gener. progr. ',
     *            A8, '  0  RUN', I4, ' SC=', F12.7)
         FNUM(32) = 0.0
         ENDIF
      IF (CHOUT .NE. ' ') THEN
         WRITE (IATOMS, FMT = '(''REMARK '', A65)') CHOUT(1:65)
         CHOUT = ' '
         ENDIF
      RETURN
      END
      SUBROUTINE ATOMWB (IATOMS, ATXYZ, ATNAME, NATR)
      DIMENSION ATXYZ(10,NATR), ATNAME(NATR)
      CHARACTER *6 ATNAME
      INCLUDE 'Zsyst.inc'
      DIMENSION BEQ(1)
      BEQ(1) = ATXYZ(5,NATR)
      IF (ATXYZ(5,NATR) .GT. 0.00001 .AND. ATXYZ(6,NATR) .GT. 0.00001)
     *   CALL ATBEQ (ATXYZ(1,NATR), BEQ, 1)
      IF ((ATXYZ(4,NATR) .GT. 0.00001 .AND. ABS(ATXYZ(4,NATR)-1.)
     *   .GT. 0.00001) .OR. ATXYZ(5,NATR) .GT. 0.00001) THEN
         WRITE (IATOMS, 104) ATNAME(NATR), (ATXYZ(J,NATR), J=1,4), BEQ
  104    FORMAT ('ATOM  ', A6, 2X, 3F9.5, 2F8.4)
      ELSE
         WRITE (IATOMS, 104) ATNAME(NATR), (ATXYZ(J,NATR), J=1,3)
         ENDIF
      IF (ATXYZ(5,NATR) .GT. 0.00001 .AND. ATXYZ(6,NATR) .GT. 0.00001)
     *   WRITE (IATOMS, 108)  ATNAME(NATR), (ATXYZ(J,NATR), J = 5,10)
  108 FORMAT ('BIJ   ', A6, 2X, 6F9.5)
      RETURN
      END
      SUBROUTINE ATOMST (KEY, ATXYZ, NAT, KEYT)
      DIMENSION ATXYZ(10,NAT)
      PARAMETER (U2B = 8. * 3.141593 **2)
      FAC = U2B
      IF (KEY .EQ. 1) FAC = 1. / U2B
      KEYT = 1
      DO 200 I=1,NAT
      IF (ABS(ATXYZ(4,I)).LT.0.000001) ATXYZ(4,I) = 1.0
      IF (ATXYZ(5,I).LT.0.000001) THEN
         ATXYZ(5,I) = 0.0
         ATXYZ(6,I) = -0.000001
         GOTO 150
         ENDIF
      IF (ATXYZ(6,I).GT.0.000001) THEN
         KEYT = 3
      ELSE
         ATXYZ(6,I) = -0.000001
         ENDIF
      IF (KEYT.EQ.1) KEYT = 2
  150 IF (KEY .EQ. 0) GOTO 200
      IF (ABS(ATXYZ(5,I)) .LT. 0.000001) GOTO 200
      ATXYZ(5,I) = ATXYZ(5,I) * FAC
      IF (ATXYZ(6,I) .LE. 0.) GOTO 200
      DO 180 J=6, 10
  180 ATXYZ(J,I) = ATXYZ(J,I) * FAC
  200 CONTINUE
      RETURN
      END
      SUBROUTINE ATOMOC (KEY, ATXYZ, MSELF, NAT)
      DIMENSION ATXYZ(10,NAT), MSELF(NAT)
      INCLUDE 'Zcrys.inc'
      DIMENSION  XYZ(3)
      DO 150 I=1,NAT
      N = 0
      DO 140 IL=1,NLATT
      DO 140 J=1,NSYMM
      DO 120 K=1,3
  120 XYZ(K) = TSYMM(K,J) + TLATT(K,IL)
     *       + ATXYZ(1,I) * IRSYMM(K,1,J)
     *       + ATXYZ(2,I) * IRSYMM(K,2,J)
     *       + ATXYZ(3,I) * IRSYMM(K,3,J)
      N = N + ISELFD (ATXYZ(1,I), XYZ, 0.04)
      IF (ICENT.EQ.1)  GOTO 140
      DO 130 IC=1,3
  130 XYZ(IC) = -XYZ(IC)
      N = N + ISELFD (ATXYZ(1,I), XYZ, 0.04)
  140 CONTINUE
      IF (KEY .EQ. 0) MSELF(I) = N
      IF (KEY .EQ. 1) ATXYZ(4,I) = ATXYZ(4,I) / FLOAT(N)
      IF (KEY .LE. 1) GOTO 150
      ATXYZ(4,I) = ATXYZ(4,I) * FLOAT(N)
      IF (ABS (ATXYZ(4,I) - 1.0) .LT. 0.0001) ATXYZ(4,I) = 1.0
  150 CONTINUE
      RETURN
      END
      SUBROUTINE ATBEQ (ATXYZ, BEQ, NAT)
      DIMENSION ATXYZ(10,NAT), BEQ(NAT)
      INCLUDE 'Zcrys.inc'
      DIMENSION SI(3), CO(3), SISI(6)
      LOGICAL CONT
      DATA CONT /.FALSE./
      DATA R4 / 0.0 /
      IF (NAT .GT. 1) CONT = .FALSE.
      IF (CONT) GOTO 133
      CONT = .TRUE.
      WRITE (7, FMT='( '' ATBEQ ....  NAT= '', I4)') NAT
      RAD = 57.295789
      DO 100  I=4,6
      SI(I-3) = SIN(CELL(I)/RAD)
      CO(I-3) = COS(CELL(I)/RAD)
      IF (ABS(CELL(I)-90.).LT.0.0001)  CO(I-3)=0.0
  100 CONTINUE
      R4 = 1.0
      DO 110  I=1,3
  110 R4 = R4 - CO(I)**2
      R4 = (R4 + (2. * CO(1) * CO(2) * CO(3))) * 3.
      DO 130  I=1,3
      SISI(I) = SI(I)**2
      DO 130  J=1,3
      IF (J - I)   130, 130, 120
  120 SISI(9-I-J) = SI(I) * SI(J) * 2.0 * CO(6-I-J)
  130 CONTINUE
  133 DO 150  M=1,NAT
      B = 0.0
      DO 140  I=1,6
  140 B = B + SISI (I) * ATXYZ(I+4,M)
  150 BEQ(M) = B / R4
      RETURN
      END
      SUBROUTINE ATBETA (ATXYZ, NAT)
      DIMENSION ATXYZ(10,NAT)
      INCLUDE 'Zcrys.inc'
      DIMENSION RLP(3), RLP2(6)
      DO 200 K=1,3
      RLP(K)  = SQRT(SSMAT(K,K))
  200 RLP2(K) = SSMAT(K,K)
      RLP2(4) = RLP(2) * RLP(3) * 2.
      RLP2(5) = RLP(1) * RLP(3) * 2.
      RLP2(6) = RLP(1) * RLP(2) * 2.
      DO 220 I=1,NAT
      IF (ATXYZ(6,I).LE.0.0) GOTO 220
      DO 210 J=5,10
  210 ATXYZ(J,I) = ATXYZ(J,I) * RLP2(J-4)
  220 CONTINUE
      RETURN
      END
      SUBROUTINE CELZIN (ATXYZ, IZAT, NAT, NCELLZ, NCELIN)
      DIMENSION ATXYZ(10,NAT),  IZAT(NAT), NCELLZ(10), NCELIN(10)
      INCLUDE 'Zsyst.inc'
      INCLUDE 'Zcrys.inc'
      DIMENSION IOCC(1)
      CALL KERNZI (0, NCELIN, 10)
      DO 590 I = 1, NAT
      CALL ATOMOC (0, ATXYZ(1,I), IOCC(1), 1)
      NN = NINT (ATXYZ(4,I) * FLOAT (IMULT/IOCC(1)))
      DO 585 N = 1, NTYPE
      IF (NCELLZ(N) .NE. IZAT(I)) GOTO 585
      NCELIN(N) = NCELIN(N) + NN
      GOTO 590
  585 CONTINUE
      IF (IZAT(I) .LE. 1) GOTO 590
      CALL KERROR
     *   (' Input atom type not defined by CRYSDA', 585, 'CELZIN')
  590 CONTINUE
      WRITE (8, 614) (NCELIN(I), I=1,NTYPE)
  614 FORMAT (' Number of atoms input: ', 10I5)
      RETURN
      END
      SUBROUTINE RDCOND (IRDX, L, LMAX, KEND)
      CHARACTER * 6  L(LMAX)
      INCLUDE 'Zsyst.inc'
      INCLUDE 'Zch80.inc'
      CHARACTER * 6  PROLD
      SAVE PROLD, KDAT
      DATA PROLD / '      ' /
      DATA NCH, NCHA, KDAT  / 0, 0, 0 /
      DATA N295 /0/
      KEND = -2
      IF (PROLD .NE. ' ') GOTO 300
      CALL FILINQ (IRDX, 'CONDA', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.EQ.-1) THEN
         WRITE (8, 190) CCODE
  190    FORMAT (' Control data file: ', A6,' CONDA not present')
         RETURN
         ENDIF
      CALL KERINA (IRDX, LIT, 1, LEND)
      IF (LEND.NE.0 .OR. LIT(1).NE.'CONDA' .OR. LIT(2).EQ.' ')
     * CALL KERROR ('ERROR on first record of CONDA file', 0, 'RDCOND')
      IF (CCODE .EQ. ' ') CCODE = LIT(2)
      WRITE (8, 230)
  230 FORMAT (/' Input control data file  CONDA')
      IF (CCODE .NE. LIT(2)) THEN
         WRITE (CHOUT, 250) CCODE, LIT(2)
  250    FORMAT ('ERROR: CCODE = ', A6,' but on CONDA file it is ', A6)
         CALL KERROR (CHOUT, 0, 'RDCOND')
         ENDIF
      NCH = 1
      NCHA = 1
      CH80(NCH) = CHIN
      CALL KERINA (IRDX, LIT, 1, LEND)
      IF (LEND.LT.0 .OR. LEND.GE.5) THEN
         WRITE (9, FMT='('' Empty CONDA file ...... '')')
         CALL FILCLO (IRDX, 'DELETE')
         RETURN
         ENDIF
      PROLD = '$DUMMY'
      IF (LIT(1) .NE. 'TITLE') BACKSPACE IRDX
  290 CALL KERINA (IRDX, L, LMAX, LEND)
      IF (LEND .LT. 0 .OR. LEND .GE. 5) THEN
         N295 = N295 + 1
         IF (N295 .LE. 2) WRITE (24, 295) L(1)
  295    FORMAT (' Requested record: PROGRAM ', A6 /
     *            ' not found in CONDA file ' )
         PROLD = ' '
         KEND = -1
         CALL FILCLO (IRDX, 'KEEP')
         RETURN
         ENDIF
      IF   (LIT(1).NE.'PROGRA' .OR. LIT(2).NE.L(1)) GOTO 290
      KDAT = 0
      KEND = 1
      RETURN
  300 KEND = 0
      CALL KERIFF (IRDX, L, LMAX, KSTOP)
      IF (KSTOP .LT. 0) GOTO 807
      IF (KSTOP .GE. 5) GOTO 803
      IF (KSTOP .NE. 0) GOTO 801
      IF (LIT(1).EQ.'PROGRA') GOTO 803
      IF (KDAT .EQ. 0) THEN
         WRITE (8, 320) CCODE
  320 FORMAT (' Input from control data file CONDA for compound ', A6)
         KDAT = 1
         ENDIF
      WRITE (8, 322) CHIN(1:65)
  322 FORMAT (' Input: ' , A65)
      IF (NLUSER(1).LE.0) CALL KERROR (' Unidentified control card',
     *    0, 'RDCOND')
      KEND = NLUSER(1)
      RETURN
  801 CALL KERINA (IRDX, LIT, 1, LEND)
      IF (LEND .EQ. -1) GOTO 807
  803 NCH = NCH + 1
      IF (LIT(1) .EQ. 'STOP' .OR. LIT(1) .EQ. 'FINISH') NCHA = NCHA+1
      IF (NCH .GE. MCH80) CALL KERROR ('CONDA too big', 801, 'RDCOND')
      CH80(NCH) = CHIN
      IF (LIT(1) .NE. 'STOP' .AND. LIT(1) .NE. 'FINISH') GOTO 801
  807 REWIND IRDX
      DO 808 I = 1, NCH
  808 WRITE (IRDX, FMT = '(A80)') CH80(I)
      REWIND IRDX
      IF (NCHA .GE. NCH) CALL FILCLO (IRDX, 'DELETE')
      PROLD =' '
      RETURN
      END
      SUBROUTINE LOGWR (IDDL)
      INCLUDE 'Zsyst.inc'
      EQUIVALENCE (IRUN, KSTAT(13))
      LOGICAL FULAUT
      EQUIVALENCE (FULAUT, SWITCH(12))
      CHARACTER*60 CHOUT2
      SAVE NCALL
      DATA NCALL / 0 /
      IF (CCODE .EQ. ' ') RETURN
      CHOUT2 = CHOUT(1:60)
      CALL FILINQ (IDDL, 'DDLOG', 'FORMATTED', 'OUTPUT', KINQ)
      IF (KINQ.EQ.0) GOTO 220
      WRITE (IDDL, 200) CCODE
  200 FORMAT ('DDLOG ', A6, '  DATA FILE    DO NOT DESTROY')
      WRITE (9, FMT='('' Welcome to DIRDIF Wonderland'' )')
      CHOUT = 'RUN   1'
      WRITE (IDDL, 217) PROGNM, CHOUT(1:60)
  217 FORMAT (A8, ' 0  ', A60)
      CHOUT = ' '
      IRUN = 1
      IF (CHOUT2 .EQ. ' ') RETURN
      GOTO 250
  220 READ (IDDL, FMT='(A3)', END=230) CHIN(1:3)
      IF (CHIN(1:3).NE.'END') GOTO 220
      GOTO 245
  230 WRITE (7, FMT='(A)')
     * ' Warning: no END record found on the DDLOG file'
  245 BACKSPACE IDDL
  250 CONTINUE
      IF (NCALL .EQ. 0) THEN
         NCALL = 1
         WRITE (IDDL, *) '-'
         ENDIF
      WRITE (IDDL, 260) PROGNM, CHOUT2
  260 FORMAT (A8, ' 0  ', A60 / 'END' / 'END')
      CHOUT = ' '
      RETURN
      END
      SUBROUTINE LOGRD (IDDL, LITX, KLOG)
      CHARACTER LITX *(*)
      INCLUDE 'Zsyst.inc'
      CHARACTER CHINX *72
      CHARACTER LITS(1) *6
      LITS(1) = LITX
      CALL FILCLO (IDDL, 'KEEP')
      CALL FILINQ (IDDL, 'DDLOG', 'FORMATTED', 'INPUT', KLOG)
      IF (KLOG.EQ.-1) RETURN
      ICOUNT = 0
      IREGEL = 0
  200 CALL KERINA (IDDL, LITS, 1, LEND)
      IF (ICOUNT .EQ. 0 .AND. LIT(1) .NE. 'DDLOG') THEN
         WRITE (9, FMT='('' DDLOG searching for '', A6)') LITS
         WRITE (9, FMT='('' Requested DDLOG incorrect; unit,'',
     *      '' name= '',I4,A6,'' ?? '',A6/1X)') IDDL, LIT(1), LIT(2)
         CALL KERNER (-4, 'LOGRD')
         ENDIF
      ICOUNT = ICOUNT + 1
      IF (LEND .EQ. -1) WRITE (7,
     *    FMT='('' Warning: no END marker on the DDLOG file'')' )
      IF (LEND .NE. 0) GOTO 230
      DO 210 I=1,NLIT
      IF (NLUSER(I).EQ.1) GOTO 220
  210 CONTINUE
      GOTO 200
  220 KLOG = I
      IREGEL = ICOUNT
      CHINX = CHIN(1:72)
      GOTO 200
  230 IF (KLOG .EQ. 0) RETURN
      CHIN = CHINX
      CALL KERINB (LITS, 1)
      REWIND (IDDL)
      DO 300 I=1,IREGEL
  300 READ (IDDL,FMT='(A1)')
      RETURN
      END
      SUBROUTINE COPY80 (IIN, FIN, IOUT, FOUT)
      CHARACTER FIN *(*), FOUT *(*), FINX *7, FOUTX *7
      INCLUDE 'Zsyst.inc'
      EQUIVALENCE (KSTAT(13), IRUN)
      CHARACTER LAST *6
      DATA IPATX /0/
      FINX  = FIN
      FOUTX = FOUT
      LAST = ' '
      IF (IIN.LE.0 .OR. IIN.GT.29 .OR. FIN.EQ.' ') STOP 62
      IF (IOUT.LE.0 .OR. IOUT.GT.29 .OR. FOUT.EQ.' ') STOP 62
      IF (IIN.EQ.5 .OR. IIN.EQ.6 .OR.
     *    IOUT.EQ.5 .OR. IOUT.EQ.6) STOP 62
      CALL FILCLO (IIN, 'KEEP')
      CALL FILCLO (IOUT, 'KEEP')
      CALL FILINQ (IIN, FINX, 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .NE. 0) RETURN
      CALL FILINQ (IOUT, FOUTX, 'FORMATTED', 'OUTPUT', KINQ)
      IF (KINQ .EQ. -1) THEN
         IF (FOUT .EQ. 'ATRES' .OR. FOUT .EQ. 'ATOMS' .OR.
     *       FOUT .EQ. 'ATPAT' .OR. FOUT .EQ. 'ATORI' .OR.
     *       FOUT .EQ. 'ATTRA' .OR. FOUT .EQ. 'ATVEC' )  GOTO 200
         IF (FOUT .EQ. 'ATOLD') THEN
            WRITE (IOUT, 142) CCODE, CCODE, PROGNM, IRUN
  142       FORMAT ('ATOLD ', A6, ' back-up file (= ATOMS OLD) '/1X/
     *        '    Note: for proper reuse of old atomic parameters:'/
     *        '    select wanted header record (ATOMS ', A6, '), and'/
     *        '    copy it with following records up to (incl.) END'/
     *        '    to the ATOMS file'/1X/
     *        'First set appended by program ', A8, ' RUN', I4 /1X)
         ELSEIF (FOUT .EQ. 'ATTEM') THEN
            WRITE (IOUT, 143) CCODE, IRUN
  143       FORMAT ('ATTEM ', A6, ' file ( TEMPRY ATOMS ) created at',
     *         ' RUN', I4 /
     *       '   Note: these parameters are recycling intermediates'/1X)
         ELSEIF (FOUT .EQ. 'ATPATX') THEN
            IPATX = 0
            WRITE (IOUT, 144) FOUT, CCODE
  144       FORMAT ( A6, 1X, A6, ' PATTY sets expanded' )
            GOTO 195
         ELSE
            WRITE (IOUT, 149) FOUT, CCODE, IRUN
  149       FORMAT ( A6, 1X, A6, ' file created at RUN', I4 /1X)
            ENDIF
         GOTO 200
         ENDIF
      NR = 0
  150 READ (IOUT, 202, END=180, ERR=250) CHIN
      NR = NR + 1
      IF (CHIN(1:6) .NE. 'FINISH') THEN
         LAST = CHIN(1:6)
         GOTO 150
         ENDIF
      BACKSPACE IOUT
      GOTO 190
  180 REWIND IOUT
      DO 182 I = 1, NR
  182 READ (IOUT, 202)
  190 IF (LAST .NE. 'END   ') WRITE (IOUT, FMT='(''END'')')
      IF (FOUT .EQ. 'ATTRA') GOTO 200
  195 IF (FOUT .EQ. 'ATPATX') THEN
         IPATX = IPATX + 1
         WRITE (IOUT, 196) IRUN, IPATX
  196       FORMAT (/'PATTY set expanded: RUN=', I4, ' IPAT=', I3 /1X)
      ELSE
         WRITE (IOUT, 197) PROGNM, IRUN
  197    FORMAT (/'Next file appended by program ', A8, ' RUN', I4 /1X)
         ENDIF
  200 CONTINUE
      N = 0
      READ (IIN, 202, END=210, ERR=270) CHIN
  202 FORMAT (A80)
      N = N + 1
      WRITE (IOUT, 202) CHIN
      IF (CHIN(1:6) .NE. 'FINISH') GOTO 200
  210 IF (CHIN(1:6) .NE. 'FINISH') WRITE (IOUT, FMT='(''FINISH'')')
      REWIND IIN
      CALL FILCLO (IOUT, 'KEEP')
      RETURN
  250 WRITE (CHOUT, 280) FOUTX, IOUT
      GOTO 282
  270 WRITE (CHOUT, 280) FINX, IIN
  280 FORMAT (' Error reading file ', A7, ', unit number ', I3)
  282 CALL KERROR (CHOUT, 0, 'COPY80')
      RETURN
      END
      SUBROUTINE VALDIS (KEY, V1, V2, KARR, KM, KEND)
      SAVE
      DIMENSION KARR(KM)
      DATA VINC, VBOT, VTOP, VSUB, VMIN / 0.0, 0.0, 0.0, 0.0, 0.0 /
      IF (KEY) 100, 110, 140
  100 KEND = 0
      CALL KERNZI (0, KARR, KM)
      VMIN = V1
      VINC = (V2 - V1) / (KM - 2)
      VSUB = VMIN - VINC - VINC
      GOTO 130
  110 KEND = KEND + 1
      IF (KEND.GT.1) GOTO 120
      VBOT = V1
      VTOP = V1
  120 IF (V1.GT.VTOP) VTOP = V1
      IF (V1.LT.VBOT) VBOT = V1
      KAD = IFIX( (V1 - VSUB) / VINC )
      IF (KAD.LE.0)  KAD = 1
      IF (KAD.GT.KM) KAD = KM
      KARR(KAD) = KARR(KAD) + 1
  130 RETURN
  140 IF (VINC.GT.0.) GOTO 150
      VSUB = VBOT
      VBOT = VTOP
      VTOP = VSUB
  150 KE = KEND - KEY
      V1 = VBOT
      IF (KE.LE.0) GOTO 130
      KSOM = 0
      DO 160 KAD=1,KM
      KSOM = KSOM + KARR(KAD)
      IF (KSOM.GE.KE) GOTO 170
  160 CONTINUE
  170 A2 = VMIN + KAD*VINC - VINC
      A1 = A2 - VINC
      IF (KAD.EQ.1)  A1 = VBOT
      IF (KAD.EQ.KM) A2 = VTOP
      V1 = A1 + ((A2-A1) * (KE-KSOM+KARR(KAD))) / KARR(KAD)
      GOTO 130
      END
      SUBROUTINE LINPRI (KEY, FITEMS, NIT)
      DIMENSION FITEMS(*)
      SAVE
      INCLUDE 'Zsyst.inc'
      CHARACTER PRFORM *72
      PARAMETER (MAXBUF = 100)
      DIMENSION BUF(MAXBUF)
      DATA NUMNIT, NITMAX, IPR  / 0, 0, 0 /
      IF (NIT.GT.MAXBUF .OR. NIT.LE.0) CALL KERROR
     *    (' Incorrect number of items send to LINPRI', 0, 'LINPRI')
      IF (KEY) 240, 220, 200
  200 IPR = KEY
      PRFORM = CHOUT
      CHOUT = ' '
      NITMAX = NIT
  210 CALL KERNZA (0., BUF, NITMAX)
      NUMNIT = 0
      RETURN
  220 IF (NUMNIT+NIT.GT.NITMAX) THEN
          WRITE (IPR, FMT=PRFORM) (BUF(IBUF),IBUF=1,NUMNIT)
          CALL KERNZA (0., BUF, NITMAX)
          NUMNIT = 0
      ENDIF
      DO 230 I=1,NIT
  230 BUF(NUMNIT+I) = FITEMS(I)
      NUMNIT = NUMNIT + NIT
      RETURN
  240 IF (NUMNIT.GT.0) WRITE (IPR, FMT=PRFORM) (BUF(IBUF),IBUF=1,NUMNIT)
      GOTO 210
      END
      SUBROUTINE XHELP
      CHARACTER*64 CH(549)
      DATA (CH(I), I=1, 9)
     1/'+101 Usually DIRDIF is started by typing ',
     2'DIRDIF CCODE    (CCODE means: give the true compound code) or:',
     3'DIRDIF CCODE PARAMS  (PARAMS: give one or more parameters) or:',
     4'DIRDIF H   (H means: help                                     ',
     5'==> in some implementations, type <dirdif>  (lower case) C$   ',
     6'+102 The HELP option can be activated by entering: DIRDIF H   ',
     7'but any second parameter then is ignored!   C$                ',
     8'+103 The HELP option is activated by entering DIRDIF H ',
     9'NOTE: it is also be activated by entering the letter H       '/
      DATA (CH(I), I=  10,  19)
     * /'as an answer to various questions. Help now is available for:',
     1'+103.01 CCODE CONDA DIRDIF PROG FILES START AUTO TEST H R Q   ',
     2'Please, enter one of these HELP options.                      ',
     3'+A CCODE 103.1 CONDA 103.2 H 103.4 R 103.5 Q 103.6            ',
     4'+A DIRDIF 103.7                                               ',
     5'+A PROG 103.75 FILES 103.8 START 103.9 AUTO 103.91 TEST 103.92',
     6'+103.1                                                        ',
     7'The DIRDIF command file is activated with parameters,         ',
     8'denoted &1, &2, &3... If there is no parameter, or if &1 = H  ',
     9'(for Help), the present help option is invoked.  '/
      DATA (CH(I), I=  20,  29)
     * /'. For normal use: the first parameter &1 is a compound code ',
     1'to be denoted CCODE : CCODE stands for an alphanummeric word  ',
     2'(up to 6 characters, of which the first one must be a letter) ',
     3'which identifies the structure under investigation, and       ',
     4'which is used to define the files in use for this structure.  ',
     5'. Usually no more parameters are needed.                      ',
     6'. Control will be given to the program DDSTART for an online  ',
     7'(interactive) preparation of the JOB stream control data.     ',
     8'. When the second parameter is a program name, it refers to a ',
     9'special option or a fully automatic run (see primer ).        '/
      DATA (CH(I), I=  30,  39)
     * /'+103.11 -------                                             ',
     1'We repeat the present help options: 103.01$                   ',
     2'+103.2 Most calculations are controled by the CONDA  file:    ',
     3'usually it is generated automatically, and erased at the end. ',
     4'The CONDA option allows the CONDA file to be saved.           ',
     5'To gain experience, do try out different options. 103.11$     ',
     6'+103.4 H stands for : please, enter H for (more) help.        ',
     7'Usually, H is not mentioned as one of the options, but you    ',
     8'may always enter H to see if there is any help.               ',
     9'Note: when a question is asked by the DIRDIF system,          '/
      DATA (CH(I), I=  40,  49)
     * /'it is followed by                                           ',
     1'- a list of possible answers, names, etc., or                 ',
     2'- a list of choices (usually abreviated, in parentheses,      ',
     3'for instance: (Y / N / Q) for Yes, No or Quit, repectively.   ',
     4'Dont hesitate to try one or more of the answers or choices:   ',
     5'more info will become available, and usually there is a way to',
     6'go back. If in doubt, try: H for Help. H never does any harm. ',
     7'Now help is available for:  Q$                                ',
     8'+103.5 R stands for: Repeat                                   ',
     9'If R is entered, we will repeat the question or the list of   '/
      DATA (CH(I), I=  50,  59)
     * /'possible options. (R is never shown in the list of options, ',
     1'except in the present call for DIRDIF H) 103.11$              ',
     2'+103.6 Q stands for: Quit = return to preceding level of      ',
     3'interrogation. Note: sometimes you must re-enter: Q           ',
     4'To enter Q is always allowed, but usually it is not           ',
     5'shown in the list of options.                                 ',
     6'So Quit this HELP session ----- C$                            ',
     7'+103.7 The new DIRDIF program is a unification of programs    ',
     8'for the ab-initio solution of structures by Patterson methods ',
     9'[ using Heavy Atom- as well as Vector Search techniques ]     '/
      DATA (CH(I), I=  60,  69)
     * /'and for partial structure expansion by direct methods,      ',
     1'and for R2-driven Fourier recycling techniques.               ',
     2'. The main programs ORIENT, TRACOR, PHASEX, FOUR, .... will be',
     3'activated by the control and supervisor program DDSTART,      ',
     4'as soon as you have entered: DIRDIF CCODE (true compound code)',
     5'and have answered the appropriate questions about what to do. ',
     6'. Note about ORIENT : you need to prepare a file CCODE ATMOD  ',
     7'with atomic parameters of the known (rigid) molecular fragment',
     8'before using vector search methods to find the orientation of ',
     9'the fragment; further calculations (calls for sub-programs)   '/
      DATA (CH(I), I=  70,  79)
     * /'are done automatically.                                     ',
     1'. Note about PHASEX : within the DIRDIF system the name PHASEX',
     2'refers to the phase refinement and phase expasion procedure   ',
     3'using DIRect methods applied to DIFference structure factors. ',
     4'When atomic coordinates have not been generated by foregoing  ',
     5'Patterson methods, an input ATOMS file is needed.             ',
     6'. More details about the main programs or options will become ',
     7'available on running DIRDIF for your compound. 103.11$        ',
     8'+103.75 PROG : summary of main programs:                      ',
     9'DDSTART supervisor program (interactive starting up)          '/
      DATA (CH(I), I=  80,  89)
     * /'DDMAIN  various calculations  (not to be called by the user)',
     1'CRYSDA  prepare the CRYSDA file (usually done automatically)  ',
     2'                                                              ',
     3'ORIENT  Vector search orientation: called by option ORIENT    ',
     4'TRACOR  translations by correlation  (automat. after ORIENT)  ',
     5'TRAVEC  select from multiple TRACOR results  (Vector Search)  ',
     6'PHASEX  phase expansion using DIR. meth. on DIFference strf.  ',
     7'. Note: option PHASEX means: programs DDMAIN + PHASEX + FOUR  ',
     8'FOUR    Fourier program  (automatically called  when needed)  ',
     9'NUTS    Nijmegen UTility System:  a collection of utilities:  '/
      DATA (CH(I), I=  90,  99)
     * /'.    e.g. the options : AT2X, X2AT, BIJVOET ... etc.',
     1'.    For more details, just try:  DIRDIF CCODE NUTS  103.11$  ',
     2'+103.8 The DIRDIF system uses many files which you do not     ',
     3'need to know.  However some of them are of importance:        ',
     4'.  Input reflection data: FREF SHELX SHELXL HKL etc;          ',
     5'.  - to be prepared automatically by your local system.       ',
     6'                                                              ',
     7'.                                                             ',
     8'. Input primary crystal data: CRYSIN . This should also       ',
     9'. - automatically be prepared by the loal computing system.   '/
      DATA (CH(I), I= 100, 109)
     * /'. Atomic parameters: see test examples and PRIMER: they are ',
     1'ATMOD : fractional or Cartesian coords.: model for ORIENT,    ',
     2'ATOMS : fractional coords.: input for TRACOR, PHASEX, FOUR,   ',
     3'ATOMS : also final output of the Fourier program FOUR,        ',
     4'ATOLD : some input or intermediate atomic params  (= back up) ',
     5'ORUSER: your private collection of search models for ORIENT   ',
     6'.  Listing files: may or may not be printed:                  ',
     7'LIS1 = CCODE LISTING = main prints for inspection, results,   ',
     8'LIS2 = auxiliar LISTING : more data to check when problems.   ',
     9'.   Other files (DDLOG, CONDA, etc.)                        '/
      DATA (CH(I), I= 110, 119)
     * /'. may sometimes be of importance for the experienced user.  ',
     1'+103.801 For a summary,                                       ',
     2'enter: SHELX, CRYSIN, ATMOD, or ATOMS. Else: Q                ',
     3'+A SHELX 103.81 CRYSIN 103.82 ATMOD 103.83 ATOMS 103.84       ',
     4'+A H 103.8 Q 103.11                                           ',
     5'+103.81 SHELX write-up ...                                    ',
     6'the file names SHELX or SHEXL or HKL refer to the             ',
     7'SHELX reflection data file with either F or F-squared!        ',
     8'No default: a HKLF record is needed with: HKLF 3 or HKLF 4.   ',
     9'This record may be present in the SHELXL RES or - INS file,   '/
      DATA (CH(I), I= 120, 129)
     * /'or it may be inserted as a leading record in the file.      ',
     1'SHELX data records are: (3I4,2F8.2)                           ',
     2'for h k l F-or-F**2 Sigma 103.801$                            ',
     3'+103.82 CRYSIN : an example for CCODE = MONOX                 ',
     4'CRYSIN MONOX                                                  ',
     5'CELL 8.166 11.405 15.936 90 90 90                             ',
     6'CELLSD 0.004 0.003 0.004 0 0 0                                ',
     7'SPGR P 21 21 21                                               ',
     8'WAVE CU                                                       ',
     9'REMARK : the contents of he entire unit cell is: FORMUL * Z   '/
      DATA (CH(I), I= 130, 139)
     * /'FORMUL C 15.00 H 16.00 N 2 O 2 S 1                          ',
     1'Z 4                                                           ',
     2'END                                                           ',
     3'        103.801$                                              ',
     4'+103.83 ATMOD write-up ...                                    ',
     5'        103.801$                                              ',
     6'+103.84 ATOMS write-up ...                                    ',
     7'        103.801$                                              ',
     8'+103.9 DIRDIF should be imbedded in your local system:        ',
     9'see the PRIMER about the reflection data files, etc.          '/
      DATA (CH(I), I= 140, 149)
     * /'By entering at the terminal:                                ',
     1'DIRDIF CCODE (where CCODE is your true compound code name)    ',
     2'you will be prompted to tell what you want to do.             ',
     3'For ORIENT you must have prepared in advance an ATMOD file    ',
     4'-   (or you know that a model is present in the ORBASE),      ',
     5'for PHASEX or TRACOR or FOUR you must have an ATOMS file,     ',
     6'-   or be ready to supply the atomic params at the terminal.  ',
     7'The automatic procedure is called by entering at the terminal:',
     8'DIRDIF CCODE PROG (=> ORIENT, TRACOR, PATTY, PHASEX or FOUR)  ',
     9'If this is your first DIRDIF experience, please, do try it out'/
      DATA (CH(I), I= 150, 159)
     * /'on the MONOS test example as described in the PRIMER.       ',
     1'In this help-session you may enter now: TEST 103.11$          ',
     2'+103.91 AUTO : fully automatic runs are most useful if your   ',
     3'local system automatically prepares a CRYSIN file (with space ',
     4'group, etc.) and for ORIENT, PHASEX, FOUR prepares (with your ',
     5'help) the ATMOD or ATOMS file.                                ',
     6'Possible starting-up calls are: DIRDIF CCODE PROG             ',
     7'- where CCODE is your true compound code                      ',
     8'- and PROG is: ORIENT, TRACOR, PHASEX, FOUR or PATTY          ',
     9'NOTE: if you do not want automatic recycling, you can add     '/
      DATA (CH(I), I= 160, 169)
     * /'NORECY as an extra parameter,                               ',
     1'i.e. enter: DIRDIF CCODE PROG NORECY (with proper CCODE       ',
     2'and PROG). This is adviced only if you know that you          ',
     3'can do better than the automatic recycling procedure! 103.11$ ',
     4'+103.92 TEST : CCODE = MONOS. Data are supplied with the      ',
     5'DIRDIF system, including the CRYSIN file (with space group,   ',
     6'etc.) and the FREF file.                                      ',
     7'Note: the total number of indepndnt non-hydrogen atoms is 20. ',
     8'Test interactive procedures.                                  ',
     9'Test ORIENT: enter: DIRDIF MONOS                              '/
      DATA (CH(I), I= 170, 179)
     * /'- ask for ORIENT, select ATMOD from ORBASE, model code: MONOS',
     1'Test PHASEX: enter: DIRDIF MONOS                              ',
     2'- ask for PHASEX, supply one S atom now: S 0.000 0.097 0.146  ',
     3'- or the same without enantiomer problem: S 0.017 0.097 0.146 ',
     4'ADVICED GENERAL STRATEGIES FOR SOLVING YOUR STRUCTURE         ',
     5'1. To solve MONOS as a heavy atom structure,                  ',
     6'.  enter: DIRDIF MONOS PATTY                                  ',
     7'2. To use Vector Search: make ATMOD file first,               ',
     8'.  e.g. for MONOS, enter:                                     ',
     9': DIRDIF MONOS ORBASE : ask for model code MONOS, then enter: '/
      DATA (CH(I), I= 180, 189)
     * /': DIRDIF MONOS ORIENT: have the structure solved using ATMOD.',
     1'To get some experience: try everything and read all output !  ',
     2'103.11$                                                       ',
     3'+104 The call: DIRDIF ? or HELP or END means: DIRDIF H C$     ',
     4'+105 Sorry...., the string CCODE                              ',
     5'is not accepted as a possible name for a compound.            ',
     6'CCODE is a mnemonic for a string with                         ',
     7'up to 6 characters, the first being a letter. 106.1$          ',
     8'+106 Sorry...., the string BATCH is not accepted              ',
     9'as a possible  name for a compound.                           '/
      DATA (CH(I), I= 190, 199)
     * /'+106.1 Please try some other help options. C$               ',
     1'+109 Remember:                                                ',
     2'- you can always answer any question with H or R or Q         ',
     3'- (for Help, Repeat or Quit, resp.) C$                        ',
     4'+110 Please select one of the following options:              ',
     5'ORIENT, TRACOR, PHASEX, DIRP1, FOUR, PATTY, U, X              ',
     6'+A X 110.1 U 110.2 H 110.01  N 0                              ',
     7'+A ORIENT 0 TRACOR 0  PHASEX 0  DIRP1 0 FOUR 0                ',
     8'+A PATTY 0 PATTER 0                                           ',
     9'+A FCALC 0 DDMAIN 0  FOUR 0  NUTS 0                           '/
      DATA (CH(I), I= 200, 209)
     * /'+A AT2X 0 X2AT 0  CRYSDA 0  MERBIN 0                        ',
     1'                                                              ',
     2'+A EDAT 0 SHAT 0  EULER 0  INVERT 0                           ',
     3'+A BIJVOE 0 SHELIN 0                                          ',
     4'                                                              ',
     5'+110.01 Short summary of these options:                       ',
     6'ORIENT Vector search ORIENTation:                             ',
     7'.   input file ATMOD = geom.known fragment                    ',
     8'TRACOR TRAnslations by CORrelation:                           ',
     9'.   input ATOMS = misplaced fragment                          '/
      DATA (CH(I), I= 210, 219)
     * /'PHASEX PHASe EXpansion and -refinement:                     ',
     1'.   input ATOMS = partial structure                           ',
     2'DIRP1 PHASEX with (autom) expansion to P1 for troubles with   ',
     3'.   Heavy.At.                                                 ',
     4'FOUR Fourier methods (various options)                        ',
     5'PATTY Heavy Atom Patterson Interpretation .                   ',
     6'U    : Utility programs                          Q$           ',
     7'+110.1                                                        ',
     8'                                                              ',
     9'                                                              '/
      DATA (CH(I), I= 220, 229)
     * /'                                                            ',
     1'                                                              ',
     2'                                                              ',
     3'                                                              ',
     4'+110.2 Note: U stands for some utility programs.              ',
     5'Next time, do not enter U, but enter the correct program name,',
     6'as you can do now; please choose:                             ',
     7'+110.21 CRYSDA, MERBIN, NUTS, AT2X, X2AT,                     ',
     8'SHAT, EULER, INVERT, BIJVOET, FCALC, DDMAIN,                  ',
     9'FFT, PATTER, SHELIN, R2                                       '/
      DATA (CH(I), I= 230, 239)
     * /'+A FCALC 0 DDMAIN 0 FFT 0 PATTER 0                          ',
     1'+A AT2X 0 X2AT 0 CRYSDA 0 MERBIN 0 H 110.3                    ',
     2'                                                              ',
     3'+A SHAT 0 EULER 0 INVERT 0 NUTS 0                             ',
     4'+A SHELIN 0 BIJVOE 0 R2 0                                     ',
     5'+110.3 Short summary of some of these options:                ',
     6'CRYSDA and MERBIN : call for a rerun of these programs        ',
     7'NUTS : call for interactive use of                            ',
     8'one of the following utilities:                               ',
     9'AT2X, X2AT : transform ATOMS into SHELX XYZN file, and v.v.   '/
      DATA (CH(I), I= 240, 249)
     * /'                                                            ',
     1'                                                              ',
     2'                                                              ',
     3'SHAT, EULER and INVERT : shift, rotate or invert ATOMS        ',
     4'BIJVOET : calculate the Bijvoet coefficients etc.             ',
     5'FCALC, DDMAIN, FOUR : single run options for expert users     ',
     6'PATTER : calculation of a sharpened Patterson (no interpr.)   ',
     7'SHELIN : set up of SHELX input cards    Q$                    ',
     8'+201.3 Do you want to use (and maybe update) this file? (Y/N) ',
     9'+A Y 0 N 201.31 Q 201.33 H 0                                  '/
      DATA (CH(I), I= 250, 259)
     * /'+201.31 New file ATMOD is to be created. C$                 ',
     1'+201.32 Use local facilities to inspect your file.            ',
     2'Use Q to exit. C$                                             ',
     3'+201.33 Quit: full stop now, inspect ATMOD file. C$           ',
     4'+201.34 Is all OK?                                            ',
     5'Can we use (and maybe edit) this file? (Y/N)                  ',
     6'+A Y 0 N 201.32 Q 201.32 H 0                                  ',
     7'+201.4 No file ATMOD with positional parameters of the search ',
     8'model is available. C$                                        ',
     9'+201.41 Can you supply the atomic parameters now (at the      '/
      DATA (CH(I), I= 260, 269)
     * /'Terminal (T) or Select or Suggest an item from ORBASE (S) ? ',
     1'+A T 0 S 201.433 Q 201.42 H 201.43                            ',
     2'+201.42 Sorry! Without a model (molecular fragment) ORIENT    ',
     3'can not run.  Please, do get an ATMOD parameter file.         ',
     4'Bye bye. C$                                                   ',
     5'+201.43 If you have a search fragment (set of atomic          ',
     6'parameters which  defines a part of the molecule in arbitrary ',
     7'orientation), given either as Cartesian or as fractional      ',
     8'coordinates (in any unit cell),  you can either enter these   ',
     9'coordinates now (enter: T)                                    '/
      DATA (CH(I), I= 270, 279)
     * /'or select an entry from the small data base ORBASE (enter: S)',
     1'or quit (meaning full stop, enter: Q) and                     ',
     2'. use local editing facilities to prepare the ATMOD file.     ',
     3'. Information about the format is given in the handout. Q$    ',
     4'+201.433 We will now read ORBASE to find your model C$        ',
     5'+201.44 or are the parameters given in a different cell?      ',
     6'If Y you will be prompted to supply the model cell. (Y/N)     ',
     7'+A Y 0 N 0 H 201.46 Q 201.47                                  ',
     8'+201.45 Give the unit cell of the model. Supply six numbers   ',
     9'(A, B, C in Angstrom, alpha, beta, gamma in degrees):         '/
      DATA (CH(I), I= 280, 289)
     * /'+D MCELL 6 0                                                ',
     1'+201.46 We must know the unit cell (if parameters come from   ',
     2'an other  structure): A, B, C in Angstrom, angles in degrees, ',
     3'so is it the present cell Q$                                  ',
     4'+201.47 We must know the unit cell ... C$                     ',
     5'+201.5 Do you need (more) special control data to execute     ',
     6'ORIENT?  (N PARAMS VMAX MIN PRINT PRIMAP H Q)                 ',
     7'+A H 201.51 PARAMS 201.52 VMAX 201.53 MIN 201.54 PRINT -1     ',
     8'+A PRIMAP 201.56 N 0 Q 0                                      ',
     9'+201.51 Possible control data entries are:                    '/
      DATA (CH(I), I= 290, 299)
     * /'PARAMS for ABC-scan parameters for angular ranges           ',
     1'.   (angles in degrees)                                       ',
     2'- You may supply many sets of PARAMS                          ',
     3'.   for consecutive calculations                              ',
     4'VMAX for maximum vector length                                ',
     5'.   (to be used in fine scan, default 7.5)                    ',
     6'MIN for minimum functions MIN(N), N = ? (max. 3 numbers)      ',
     7'PRINT for printing additional intermediate results            ',
     8'. (for instance atoms, vectors) on your output listing        ',
     9'PRIMAP for bulk listing of the maps PATIN, DEK and MAPSIG     '/
      DATA (CH(I), I= 300, 309)
     * /'. (the files are not automatically printed by the program)  ',
     1'Q to quit (also use Q to escape). Q$                          ',
     2'+201.52 PARAMS for ABC scan (begin, increment, nr.of points,  ',
     3'.   for A,B,C),  enter nine numbers, in this order:           ',
     4'  ==>  Abeg Aincr Nr. Bbeg Bincr Nr. Cbeg Cincr Nr.           ',
     5'+D PARAMS 9 0                                                 ',
     6'+201.53 VMAX for max vectorlength to be used. Enter one number',
     7'+D VMAX 1 0                                                   ',
     8'+201.54 .                                                     ',
     9'ORIENT calculates the minimum functions MIN(N), N = ... ?     '/
      DATA (CH(I), I= 310, 319)
     * /'Enter 1, 2 or 3 numbers (in the order of increasing value)  ',
     1'+D MIN -4 0                                                   ',
     2'+201.56 PRIMAP for bulk listing of the Patterson map (PATIN)  ',
     3'and/or the input map for the search (DEK)                     ',
     4'and/or the output maps of the scan ranges (MAPSIG).           ',
     5'. Enter 1, 2 or 3 keywords (PATIN, DEK, MAPSIG)               ',
     6'+D PRIMAP 0 -3                                                ',
     7'+202                                                          ',
     8'Do you need (more) special control data to execute TRACOR?    ',
     9'(N EMIN SCSG BHSG DAMP SMM PRINT PRIMAP STLMAX PSQMAX H Q)    '/
      DATA (CH(I), I= 320, 329)
     * /'+A H 202.05 EMIN 202.1 SCSG 202.2 BHSG 202.3 DAMP 202.4     ',
     1'+A SMM 202.5                                                  ',
     2'+A PRINT -1 PRIMAP -1 STLMAX 202.8 PSQMAX 202.9 N 0 Q 0       ',
     3'+202.05 Possible control data entries are:                    ',
     4'EMIN for minimum E value                                      ',
     5'SCSG additional scale factor (must be around 1.0)             ',
     6'BHSG additional temp.factor for model (Bp := Bp + BHSG)       ',
     7'DAMP damping factor (anything better than default???)         ',
     8'STLMAX limitations on reflections (if not given with FCALC)   ',
     9'PSQMAX value of PSQ after symmetry application                '/
      DATA (CH(I), I= 330, 339)
     * /'.   (only for use if a                                      ',
     1'- heavy atom of the model is expected to lie on a symm.elem.  ',
     2'Q to quit (also use Q to escape). Q$                          ',
     3'+202.1 enter EMIN (minimum E value) :                         ',
     4'+D EMIN 1 0                                                   ',
     5'+202.2 enter SCSG additional scale factor                     ',
     6'.   (must be around 1.0):                                     ',
     7'+D SCSG 1 0                                                   ',
     8'+202.3 enter BHSG additional temp.factor for model            ',
     9'.   (Bp := Bp + BHSG):                                        '/
      DATA (CH(I), I= 340, 349)
     * /'+D BHSG 1 0                                                 ',
     1'+202.4 enter DAMP damping factor (suggested range 1. - 10.):  ',
     2'+D DAMP 1 0                                                   ',
     3'+202.5 enter SMM weet ik niet: doe maar Q ?                   ',
     4'+D SMM 1 0                                                    ',
     5'+202.8 enter STLMAX limitations on reflections to be used:    ',
     6'+D STLMAX 1 0                                                 ',
     7'+202.9 enter PSQMAX value of PSQ after symmetry application:  ',
     8'+D PSQMAX 1 0                                                 ',
     9'+203 Do you need (more) special control data to run PHASEX?   '/
      DATA (CH(I), I= 350, 359)
     * /'(N STLMAX MAXHKL LOCCEN NCEST ACCEPT PRINT H Q)             ',
     1'+A H 203.05 STLMAX 203.1 MAXHKL 203.2 LOCCEN 203.3            ',
     2'+A NCEST 203.4                                                ',
     3'+A ACCEPT 203.5 PRINT -1 N 0 Q 0                              ',
     4'+203.05 Possible control data entries are:                    ',
     5'STLMAX for maximum value of sin(theta)/lambda                 ',
     6'MAXHKL for maximum value of hkl. Enter 0 for those indices    ',
     7'- on which you do not want to impose a limit.                 ',
     8'LOCCEN approximate center of symmetry in model structure      ',
     9'- (a center of symmetry will be found by the program,         '/
      DATA (CH(I), I= 360, 369)
     * /'- but if the deviations are too large the user can force    ',
     1'- the execution of the enantiomorph-fixation procedure)       ',
     2'NCEST number of cycles for tangent refinement (max. 5)        ',
     3'- and five E-start values. Enter 0 for NCEST and for the      ',
     4'- first E-start value if default values should be used.       ',
     5'ACCEPT min. value of alpha / beta (= QEET) and max. number    ',
     6'- of reflections accepted for secondary set of symbolic       ',
     7'- reflections (= MAXT). Enter 0 for those indices on which    ',
     8'_ you do not want to impose a limit.                          ',
     9'PRINT bulk print requested (when you have a problem)          '/
      DATA (CH(I), I= 370, 379)
     * /'Q to quit (also use Q to escape). Q$                        ',
     1'+203.1 STLMAX for maximum value of sin(theta)/lambda.         ',
     2'.   Enter one number.                                         ',
     3'+D STLMAX 1 0                                                 ',
     4'+203.2 MAXHKL for maximum value of hkl. Enter three numbers.  ',
     5'.   Enter 0 for those indices                                 ',
     6'.   on which you do not want to impose a limit.               ',
     7'+D MAXHKL 3 0                                                 ',
     8'+203.3 LOCCEN if the model structure has an approximate       ',
     9'center of symmetry. Enter the fractional coords x, y and z    '/
      DATA (CH(I), I= 380, 389)
     * /'of the (pseudo) center of symmetry (three numbers):         ',
     1'+D LOCCEN 3 0                                                 ',
     2'+203.4 NCEST: number of cycles of tangent refinement (max. 5) ',
     3'and five E-start values. Enter 0 for NCEST and for the        ',
     4'first E-start value if default values should be used.         ',
     5'+D NCEST 6 0                                                  ',
     6'+203.5 ACCEPT for min. value of alpha / beta (= QEET) and     ',
     7'max. number  of reflections accepted for secondary set of     ',
     8'symbolic  reflections (= MAXT).  Enter 0 for those indices on ',
     9'which you do not want to impose a limit.                      '/
      DATA (CH(I), I= 390, 399)
     * /'+D ACCEPT 2 0                                               ',
     1'+204 Utility program: prepare file and stop.                  ',
     2'Supply an option number for the execution of DDMAIN:          ',
     3'OPTION 0 : call FCALC and prepare BINFC or BINFC2 file        ',
     4'OPTION 1 : call FCALC and prepare input (= BINDUA file) for   ',
     5'- phase expansion and phase refinement (PHASEX)               ',
     6'OPTION 2 : prepare input (= BINFFT file) for a DIRDIF-Fourier ',
     7'- (the program PHASEX must precede to obtain the BINDIF file) ',
     8'OPTION 3 : prepare input (= BINFFT file) for a Fourier map    ',
     9'- (sub-options WFOUR, WDELF, AFOUR, DELF, 2FO-FC, FCALC)      '/
      DATA (CH(I), I= 400, 409)
     * /'OPTION 4 : prepare input (= BINFFT file) for a Patterson map',
     1'- (sub-options PATOR, PATTY, EF, FOBS2)                       ',
     2'OPTION 7 : call FCALC, R2-calculation for all sets of ATOMS   ',
     3'- on the ATOMS file                                           ',
     4'Please give option number:                                    ',
     5'+D OPTION 1 0                                                 ',
     6'+204.02 Select one of the options for a Fourier synthesis:    ',
     7'WFOUR 2FO-FC WDELF AFOUR DELF FCALC                           ',
     8'+A WFOUR 0 2FO-FC 0 WDELF 0 AFOUR 0 DELF 0 FCALC 0 Q 204.03   ',
     9'+A H 204.04                                                   '/
      DATA (CH(I), I= 410, 419)
     * /'+204.03 .                                                   ',
     1'Quit not accepted: Keyword needed by the calling program!     ',
     2'You are able to escape later. (If in doubt, try H) 204.02$    ',
     3'+204.04 The keywords have the following meaning:              ',
     4'WFOUR : default: conventional Sim-weighted Fourier synthesis  ',
     5'- with (for large fragments) partly (2FO-FC)-contribution     ',
     6'2FO-FC: 2 Fobs - Fcalc synthesis                              ',
     7'WDELF : weighted difference Fourier synthesis                 ',
     8'AFOUR : unweighted Fourier synthesis                          ',
     9'DELF : unweighted difference synthesis                        '/
      DATA (CH(I), I= 420, 429)
     * /'FCALC : Fourier synthesis with Fcalc as coefficients Q$     ',
     1'+204.05 Please select one of the options for a Patterson map: ',
     2'PATOR EF FOBS2                                                ',
     3'+A PATOR 0 PATTY 0 EF 0 FOBS2 0 Q 204.06 H 204.07             ',
     4'+204.06 Quit not accepted:                                    ',
     5'Keyword needed by the calling program!                        ',
     6'You are able to escape later. (If in doubt, try H) 204.05$    ',
     7'+204.07 The keywords have the following meaning:              ',
     8'PATOR : Patterson synthesis for ORIENT                        ',
     9'EF : Patterson synthesis with coefficients: |E * F|           '/
      DATA (CH(I), I= 430, 439)
     * /'FOBS2 : unsharpened Patterson synthesis   204.05$           ',
     1'+205 EXPAND (Y/N/H/Q)?                                        ',
     2'+A Y 205.02 N 0 H 205.01 Q 0                                  ',
     3'+205.01 .                                                     ',
     4'EXPAND: expand data to P1 symmetry (or centered equivalent),  ',
     5'only possible if selected program is FCALC or DDMAIN. 205$    ',
     6'+205.02 Enter EXPAND (to confirm) or Q (to quit):             ',
     7'+A EXPAND 0 Q 0                                               ',
     8'+205.1 Do you need (more) special control data for FCALC?     ',
     9'(N STLMAX MAXHKL SCALE BBB WILSON PRINT H Q)                  '/
      DATA (CH(I), I= 440, 449)
     * /'+A STLMAX 205.21 MAXHKL 205.22 SCALE 205.23 BBB 205.24      ',
     1'+A WILSON 205.25                                              ',
     2'+A N 0 H 205.11 Q 0 PRINT -1                                  ',
     3'+205.11 Possible control data entries are:                    ',
     4'STLMAX for max. value of sin (theta)/lambda                   ',
     5'MAXHKL for max. values of H, K, L                             ',
     6'SCALE for scale factor (Fcalc == Scale * Fobs)                ',
     7'BBB for temperture factors: Bov, Bp, Br                       ',
     8'- Bov = overall temperature factor calculated by              ',
     9'-  WILSON-PARTHASARATY plot                                   '/
      DATA (CH(I), I= 450, 459)
     * /'- Bp = temperature factor of partial structure (= input)    ',
     1'-  calculated by WILSON-BpBr-plot                             ',
     2'- Br = temperature factor of rest structure (= output)        ',
     3'-  calculated by WILSON-BpBr-plot                             ',
     4'WILSON for WILSON-PARTHASARATY plot and WILSON-BpBr-plot      ',
     5'PRINT if you wish to see more intermediate data printed       ',
     6'and give Q to quit (also use Q to escape). Q$                 ',
     7'+205.21 .                                                     ',
     8'STLMAX for max. value of sin (theta)/lambda. Enter one number:',
     9'+D STLMAX 1 0                                                 '/
      DATA (CH(I), I= 460, 469)
     * /'+205.22 .                                                   ',
     1'MAXHKL for max. values of H, K, L (if 0, retain original data)',
     2'+D MAXHKL 3 0                                                 ',
     3'+205.23 Supply the value of the scale factor:                 ',
     4'+D SCALE 1 0                                                  ',
     5'+205.24 BBB for three temp. factors: Bov, Bp, Br              ',
     6'(if .0, default calc.):                                       ',
     7'Enter three numbers:                                          ',
     8'+D BBB 3 0                                                    ',
     9'+205.25 .                                                     '/
      DATA (CH(I), I= 470, 479)
     * /'WILSON for WILSON-PARTHASARATY plot and WILSON-BpBr-plot    ',
     1'Please select one of the following numbers (or Q to quit):    ',
     2'0 = all paramters (Bov, Bp, Br) free                          ',
     3'1 = fix temperature factor for the partial structure (BP)     ',
     4'2 = fix temperature factor for the rest structure (BR)        ',
     5'3 = fix temp. fact. for partial and rest structure (BP,BR)    ',
     6'4 = no WILSON-PARTHASARATY plot and no WILSON-BpBr-plot       ',
     7'5 = no WILSON-BpBr-plot, only WILSON-PARTHASARATY plot        ',
     8'+D WILSON 1 0                                                 ',
     9'+205.3 Do you want to use this file? (Y/N)                    '/
      DATA (CH(I), I= 480, 489)
     * /'+A Y 0 N 205.31 Q 205.33 H 0                                ',
     1'+205.31 New file ATOMS is to be created. C$                   ',
     2'+205.32 Use local facilities to inspect your file.            ',
     3'Use Q to exit. C$                                             ',
     4'+205.34 Is all OK? Can we use this file? (Y/N)                ',
     5'+A Y 0 N 205.35 Q 205.35 H 0                                  ',
     6'+205.35 Quit: stop now, inspect ATOMS file. C$                ',
     7'+205.4 .                                                      ',
     8'No file ATOMS with positional parameters is available. C$     ',
     9'+205.41 Can you supply the atomic parameters now? (Y/N)       '/
      DATA (CH(I), I= 490, 499)
     * /'+A Y 0 N 205.42 Q 205.42 H 205.43                           ',
     1'+205.42 Please, get an ATOMS file. Bye bye. C$                ',
     2'+205.43 If you have a set of atomic parameters (given         ',
     3'either as Cartesian or as fractional coordinates)             ',
     4'you can either enter these coordinates now or quit and        ',
     5'use local editing facilities to prepare the ATOMS file.       ',
     6'Information about the format is obtained by just trying out:  ',
     7'supply some arbitrary atoms in an arbitrary format, quit and  ',
     8'inspect the created ATOMS file. Q$                            ',
     9'+206 Do you need (more) special control data to execute FOUR? '/
      DATA (CH(I), I= 500, 509)
     * /'(N GRID MAXXYZ MAXHKL GRIDMO PRIMAP PEAKS DMAX NORECY PRINT ',
     1'+A H 206.05 GRID 206.1 MAXXYZ 206.2 MAXHKL 206.3 GRIDMO 206.4 ',
     2'+A PRIMAP -1 PEAKS 206.6 DMAX 206.7 PRINT -1 N 0 Q 0 NORECY -1',
     3'+206.05 Possible control data entries are:                    ',
     4'GRID grid spacing in Angstrom (the grid on which the Fourier  ',
     5'- function is evaluated will have a default spacing of        ',
     6'- approximately 0.3 A)                                        ',
     7'MAXXYZ maximum x,y,z on printed map (if PRIMAP) (from origin) ',
     8'GRIDMO for values of MODULO Nx, Ny, Nz (default 1, 1, 2)      ',
     9'PRIMAP print of the Fourier map                               '/
      DATA (CH(I), I= 510, 519)
     * /'PEAKS number of peaks to be sought on the Fourier map       ',
     1'DMAX maximum distance to be considered as bonding distance    ',
     2'NORECY to suppress recycling: write ATOMS and STOP after FOUR ',
     3'PRINT for extra information to be printed                     ',
     4'Q to quit (also use Q to escape). Q$                          ',
     5'+206.1 GRID for grid spacing in Angstrom. Give one number     ',
     6'+D GRID 1 0                                                   ',
     7'+206.2 if PRIMAP: MAXXYZ for maximum x, y, z on printed map   ',
     8'+D MAXXYZ 3 0                                                 ',
     9'+206.3 MAXHKL for maximum h, k, l. Enter three numbers        '/
      DATA (CH(I), I= 520, 529)
     * /'+D MAXHKL 3 0                                               ',
     1'+206.4 GRIDMO for values of MODULO Nx, Ny, Nz.                ',
     2'Enter three numbers                                           ',
     3'+D GRIDMO 3 0                                                 ',
     4'+206.6 PEAKS for number of peaks. Enter one number            ',
     5'+D PEAKS 1 0                                                  ',
     6'+206.7 DMAX maximum distance for bonding. Enter one number    ',
     7'+D DMAX 1 0                                                   ',
     8'+207 No special control data to execute PATTY needed. Q$      ',
     9'+208 No special control data to execute PATTERSON needed. Q$  '/
      DATA (CH(I), I= 530, 539)
     * /'+212                    C$                                  ',
     1'                                                              ',
     2'                                                              ',
     3'                                                              ',
     4'                                                              ',
     5'                                                              ',
     6'                                                              ',
     7'                                                              ',
     8'                                                              ',
     9'                                                              '/
      DATA (CH(I), I= 540, 549)
     * /'                                                            ',
     1'                                                              ',
     2'                                                              ',
     3'                                                              ',
     4'                                                              ',
     5'                                                              ',
     6'                                                              ',
     7'                                                              ',
     8'+999                                                          ',
     9'+999 END OF DDHELP LIST                                       '/
      IHELP = 18
      CALL FILCLO (IHELP, 'KEEP')
      CALL FILINQ (IHELP, 'DDHELP', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (IHELP, 111)
  111 FORMAT ( '     file DDHELP     Sept. 2006 '/1X)
      DO 999 K = 1, 549
      WRITE (IHELP, 222) CH(K)
  222 FORMAT (A64, 8X)
  999 CONTINUE
      CALL FILCLO (IHELP, 'KEEP')
      END
      FUNCTION ISELFD (X, Y, DMAX)
      DIMENSION X(3), Y(3)
      SAVE
      INCLUDE 'Zcrys.inc'
      DIMENSION DM(3), D(3)
      DATA DMOLD /-999.0/
      DATA DMAXSQ / 0.0 /
      IF (ABS (DMOLD - DMAX) .GT. 0.0001) THEN
         DO 100 I=1, 3
  100    DM(I) = DMAX * RCELL(I)
         DMOLD = DMAX
         DMAXSQ = DMAX * DMAX
         ENDIF
      ISELFD=0
      DO 120 I=1, 3
      D(I) = X(I) - Y(I) - ANINT (X(I)-Y(I))
      IF (ABS (D(I)) .GT. DM(I)) RETURN
  120 CONTINUE
      CALL VMATV1 (D, RRMAT, D, DIST2)
      IF (DIST2 .LE. DMAXSQ) ISELFD = 1
      RETURN
      END
      SUBROUTINE DISTSQ (X, Y, DMAX, Z, DIST2)
      DIMENSION X(3), Y(3), Z(3)
      SAVE
      INCLUDE 'Zcrys.inc'
      DIMENSION DM(3)
      DATA DMOLD /-9999.9/
      IF (ABS (DMOLD - DMAX) .GT. 0.0001) THEN
         DO 100 I=1, 3
  100    DM(I) = DMAX * RCELL(I)
         DMOLD=DMAX
         ENDIF
      DIST2 = 9999.9
      DO 120 I=1, 3
      Z(I) = Y(I) - X(I) - ANINT (Y(I)-X(I))
      IF (ABS (Z(I)) .GT. DM(I)) RETURN
  120 CONTINUE
      CALL VMATV1 (Z, RRMAT, Z, DIST2)
      RETURN
      END
      SUBROUTINE SYMOP1 (IS, X, XS)
      DIMENSION X(3), XS(3)
      INCLUDE 'Zcrys.inc'
      DIMENSION RSYMM(3,3,24)
      LOGICAL CONT
      SAVE CONT
      DATA CONT / .FALSE. /
      IF (CONT) GOTO 200
      CONT = .TRUE.
      CALL KERI2F (IRSYMM, RSYMM, 9 * NSYMM)
  200 IF (IS .EQ. 1) THEN
         CALL KERNAB (X, XS, 3)
      ELSE
         CALL MATXV3 (RSYMM(1,1,IS), X, XS)
         XS(1) = XS(1) + TSYMM(1,IS)
         XS(2) = XS(2) + TSYMM(2,IS)
         XS(3) = XS(3) + TSYMM(3,IS)
         ENDIF
      END
      SUBROUTINE SYMOP2 (IC, IL, XS, XST)
      DIMENSION XS(3), XST(3)
      INCLUDE 'Zcrys.inc'
      IF (IC .EQ. 1) THEN
         XST(1) = TLATT(1,IL) + XS(1)
         XST(2) = TLATT(2,IL) + XS(2)
         XST(3) = TLATT(3,IL) + XS(3)
      ELSE
         XST(1) = TLATT(1,IL) - XS(1)
         XST(2) = TLATT(2,IL) - XS(2)
         XST(3) = TLATT(3,IL) - XS(3)
         ENDIF
      END
      FUNCTION ISELFX (X, Y, DMAX)
      DIMENSION X(3), Y(3)
      SAVE
      INCLUDE 'Zcrys.inc'
      DIMENSION DM(3), D(3)
      DATA DMOLD /-999.0/
      DATA DMAXSQ / 0.0 /
      IF (ABS (DMOLD - DMAX) .GT. 0.0001) THEN
         DO 100 I=1, 3
  100    DM(I) = DMAX * RCELL(I)
         DMOLD = DMAX
         DMAXSQ = DMAX * DMAX
         ENDIF
      ISELFX=0
      DO 120 I=1, 3
      D(I) = X(I) - Y(I) - ANINT (X(I)-Y(I))
      IF (ABS (D(I)).GT.DM(I)) RETURN
  120 CONTINUE
      CALL VMATV1 (D, RRMAT, D, DISTSQ)
      IF (DISTSQ .LE. DMAXSQ) THEN
         DO 130 I = 1,3
  130    Y(I) = Y(I) + ANINT( X(I)-Y(I) )
         ISELFX = 1
         ENDIF
      RETURN
      END
      SUBROUTINE LOCKIN (ATIN, DMAX, ATOUT, DIST, NPOS)
      DIMENSION ATIN(3), ATOUT(3), D(3)
      INCLUDE 'Zcrys.inc'
      DIMENSION  XYZ(3), XYZC(3), TPOS(3,48)
      LOGICAL CENTRO, AGAIN
      DATA CENTRO / .FALSE. /
      DATA DELTA  / 0.0001  /
      AGAIN = .FALSE.
      IF ( ICENT .EQ. 2 ) CENTRO = .TRUE.
      CALL KERNZA ( 0.0, ATOUT, 3 )
      CALL KERNAB (ATIN, TPOS, 3)
      NPOS = 1
      NADD = 0
  120 DO 200 I = 1,NPOS
      DO 190 JT = 1,NLATT
      DO 190 J  = 1,NSYMM
      IF ( CENTRO ) AGAIN = .TRUE.
      DO 130 K = 1,3
      XYZ(K) = TSYMM(K,J) + TLATT(K,JT) +
     *   TPOS(1,I) * IRSYMM(K,1,J) +
     *   TPOS(2,I) * IRSYMM(K,2,J) +
     *   TPOS(3,I) * IRSYMM(K,3,J)
  130 XYZC(K) = -XYZ(K)
  140 IF ( ISELFX (ATIN, XYZ, DMAX) .EQ. 1 ) THEN
         DO 150 L = 1,NPOS+NADD
         IF ( ( ABS(XYZ(1)-TPOS(1,L)) .LT. DELTA ) .AND.
     *      ( ABS(XYZ(2)-TPOS(2,L)) .LT. DELTA ) .AND.
     *      ( ABS(XYZ(3)-TPOS(3,L)) .LT. DELTA ) ) GOTO 170
  150    CONTINUE
         NADD = NADD + 1
         IF ( NPOS+NADD .GT. 48 ) CALL KERROR
     *      ('Program symm. error?', 150, 'LOCKIN')
         DO 160 K = 1,3
  160    TPOS(K,NPOS+NADD) = XYZ(K)
         ENDIF
  170 IF ( .NOT. CENTRO )  GOTO 190
      IF ( AGAIN ) THEN
         DO 180 K = 1,3
  180    XYZ(K) = XYZC(K)
         AGAIN = .FALSE.
         GOTO 140
         ENDIF
  190 CONTINUE
  200 CONTINUE
      IF ( NADD .EQ. 0 ) GOTO 220
      NPOS = NPOS + NADD
      NADD = 0
      GOTO 120
  220 DIST = 0.0
      FNPOS = FLOAT(NPOS)
      DO 240 I = 1,3
      DO 230 K = 1,NPOS
  230 ATOUT(I) = ATOUT(I) + TPOS(I,K)
  240 ATOUT(I) = ATOUT(I) / FNPOS
      IF ( NPOS .LE. 1 ) GOTO 260
      DO 250 I = 1,3
  250 D(I) = ATIN(I) - ATOUT(I)
      CALL VMATV1( D, RRMAT, D, DIST )
      DIST = SQRT( DIST )
  260 RETURN
      END
      SUBROUTINE HKLSTL (HKL, STL, STL2)
      INCLUDE 'Zcrys.inc'
      DIMENSION HKL(3)
      STL2 = 0.0
      DO 100 I =1,3
      DO 100 J =1,3
  100 STL2 = STL2 + HKL(I) * SSMAT(I,J) * HKL(J)
      STL2 = STL2 / 4.0
      STL = SQRT(STL2)
      RETURN
      END
      SUBROUTINE HKLEXS (SWITCH, HKL, HCODE)
      LOGICAL SWITCH
      DIMENSION HKL(3)
      INCLUDE 'Zcrys.inc'
      DIMENSION RSYMM(3,3,24), HHH(3)
      LOGICAL IRSW
      SAVE IRSW
      DATA IRSW / .FALSE. /
      IF (IRSW) GOTO 110
      IRSW = .TRUE.
      CALL KERI2F (IRSYMM, RSYMM, 9*NSYMM)
  110 DO 200 J = 1,NSYMM
      DO 120 K = 1,3
      HHH(K) = HKL(1) * RSYMM(1,K,J)
     *       + HKL(2) * RSYMM(2,K,J)
     *       + HKL(3) * RSYMM(3,K,J)
  120 CONTINUE
      CALL HKLC1 (HHH, HC)
      IF (SWITCH) HC = ABS(HC)
      IF (J.EQ.1) HCODE = HC
      HCODE = AMAX1 (HC, HCODE)
  200 CONTINUE
      RETURN
      END
      SUBROUTINE HKLEXT (HKL, KEND)
      DIMENSION HKL(3)
      SAVE
      INCLUDE 'Zcrys.inc'
      DIMENSION KSYMM(3,3,24), TT(3,24), III(3), KKK(3)
      LOGICAL IRSW, SKIP
      DATA IRSW , SKIP / .FALSE. , .FALSE. /
      DATA NST / 0 /
      IF (SKIP) GOTO 102
      IF (IRSW) GOTO 110
      IF (NSYMM.GT.1) GOTO 103
  101 SKIP = .TRUE.
  102 KEND = 0
      RETURN
  103 IRSW = .TRUE.
      NST = 0
      DO 104 J = 2,NSYMM
      IF (ABS(TSYMM(1,J)) .LT. 0.01 .AND.
     *    ABS(TSYMM(2,J)) .LT. 0.01 .AND.
     *    ABS(TSYMM(3,J)) .LT. 0.01) GOTO 104
      NST = NST + 1
      CALL KERNAI (IRSYMM(1,1,J), KSYMM(1,1,NST), 9)
      CALL KERNAB (TSYMM(1,J), TT(1,NST), 3)
  104 CONTINUE
      IF (NST.EQ.0) GOTO 101
  110 CALL KERF2I (HKL, III, 3)
      DO 200 J = 1,NST
      TEST = 0.
      DO 120 K = 1,3
      KKK(K) = III(1) * KSYMM(1,K,J)
     *       + III(2) * KSYMM(2,K,J)
     *       + III(3) * KSYMM(3,K,J)
  120 CONTINUE
      IF (III(1).EQ.KKK(1) .AND. III(2).EQ.KKK(2) .AND.
     *    III(3).EQ.KKK(3) ) GOTO 130
      IF (ICENT.EQ.1) GOTO 200
      IF (III(1).NE.-KKK(1) .OR. III(2).NE.-KKK(2) .OR.
     *    III(3).NE.-KKK(3) ) GOTO 200
  130 TEST = TT(1,J) * HKL(1) + TT(2,J) * HKL(2) + TT(3,J) * HKL(3)
      IF (AMOD (ABS(TEST)+0.01, 1.0) .LT. 0.02) GOTO 200
      KEND = -1
      RETURN
  200 CONTINUE
      KEND = 0
      RETURN
      END
      SUBROUTINE HKLEX1 (HKL, HKLX)
      DIMENSION HKL(3), HKLX(3,24)
      SAVE
      INCLUDE 'Zcrys.inc'
      DIMENSION RSYMM(3,3,24)
      LOGICAL IRSW
      DATA IRSW / .FALSE. /
      IF (IRSW) GOTO 110
      IRSW = .TRUE.
      CALL KERI2F (IRSYMM, RSYMM, 9*NSYMM)
  110 CALL KERNAB (HKL, HKLX, 3)
      IF (NSYMM.EQ.1) RETURN
      DO 120 J = 2,NSYMM
      DO 120 K = 1,3
  120 HKLX(K,J) = HKL(1) * RSYMM(1,K,J)
     *          + HKL(2) * RSYMM(2,K,J)
     *          + HKL(3) * RSYMM(3,K,J)
      RETURN
      END
      SUBROUTINE HKLEX2 (HKL, IDHKL, IEPS, IEPS2)
      DIMENSION HKL(3,24), IDHKL(24)
      INCLUDE 'Zcrys.inc'
      IDHKL(1) = 0
      IF (NSYMM.EQ.1) THEN
         IEPS  = 1
         IEPS2 = 1
         RETURN
         ENDIF
      IEPS  = 0
      IEPS2 = 0
      DO 300 J=2,NSYMM
      IDHKL(J) = 0
      DO 200 K=1,J-1
      IF (ABS(HKL(1,K)-HKL(1,J)) .GT. 0.1) GOTO 180
      IF (ABS(HKL(2,K)-HKL(2,J)) .GT. 0.1) GOTO 180
      IF (ABS(HKL(3,K)-HKL(3,J)) .GT. 0.1) GOTO 180
      IDHKL(J) = K
      IEPS = IEPS + 1
      GOTO 300
  180 CONTINUE
      IF (ABS(HKL(1,K)+HKL(1,J)) .GT. 0.1) GOTO 200
      IF (ABS(HKL(2,K)+HKL(2,J)) .GT. 0.1) GOTO 200
      IF (ABS(HKL(3,K)+HKL(3,J)) .GT. 0.1) GOTO 200
      IDHKL(J) = - K
      IEPS2 = IEPS2 + 1
      GOTO 300
  200 CONTINUE
  300 CONTINUE
      IEPS2 = NSYMM / (NSYMM - IEPS - IEPS2)
      IF (ICENT .EQ. 1) THEN
         IEPS  = NSYMM / (NSYMM - IEPS)
      ELSE
         IEPS = IEPS2
         ENDIF
      RETURN
      END
      SUBROUTINE HKLEX3 (HKL, IDHKL, PSHIFT)
      DIMENSION HKL(3), IDHKL(24), PSHIFT(24)
      INCLUDE 'Zcrys.inc'
      CALL KERNZA (0., PSHIFT, NSYMM)
      IF (NSYMM .EQ. 1) RETURN
      DO 220 I=1,NSYMM
      IF (IDHKL(I) .NE. 0) GOTO 210
      XTEST = 0.0
      DO 200 J=1,3
  200 XTEST  = XTEST - HKL(J) * TSYMM(J,I)
      XTEST  = AMOD(XTEST,1.0)
      IF (XTEST .LT. -0.01) XTEST = XTEST + 1.
      PSHIFT(I) = XTEST * 360.
      GOTO 220
  210 ITEST = IABS(IDHKL(I))
      PSHIFT(I) = PSHIFT(ITEST)
  220 CONTINUE
      RETURN
      END
      SUBROUTINE HKLAXT (HKL, KEND)
      DIMENSION HKL(3)
      INCLUDE 'Zcrys.inc'
      DIMENSION IH(3)
      CALL KERF2I (HKL, IH, 3)
      GOTO (200, 2, 3, 4, 5, 6, 7), ILATT
  2   I = IH(2) + IH(3)
      GOTO 100
  3   I = IH(1) + IH(3)
      GOTO 100
  4   I = IH(1) + IH(2)
      GOTO 100
  5   I = IH(1) + IH(2) + IH(3)
  100 IF (MOD(I,2) .EQ. 0) GOTO 200
      GOTO 150
  6   IF (MOD (IH(1)+IH(2),2) .EQ. 0 .AND.
     *    MOD (IH(1)+IH(3),2) .EQ. 0) GOTO 200
      GOTO 150
  7   IF (MOD (-IH(1)+IH(2)+IH(3),3) .EQ. 0) GOTO 200
  150 KEND = -1
      RETURN
  200 CONTINUE
      KEND = 0
      RETURN
      END
      SUBROUTINE HKLC1 (HKL, HCODE)
      DIMENSION HKL(3), HKL1(3)
      PARAMETER (ADD   = -99.,  SPANL = 200., SPANKL = 200. * 200.,
     *                          LSPAN = 200 , KLSPAN = 200  * 200,
     *          IDDHKL =  99 * (KLSPAN + LSPAN + 1) )
      HCODE = HKL(1) * SPANKL + HKL(2) * SPANL + HKL(3)
      RETURN
      ENTRY HKLC1U (HCODE1, HKL1)
      KCODE  =  NINT (HCODE1) + IDDHKL
      I = KCODE / KLSPAN
      HKL1(1) = FLOAT (I) + ADD
      M = MOD(KCODE,KLSPAN)
      I = M / LSPAN
      HKL1(2) = FLOAT (I) + ADD
      M = MOD(KCODE, LSPAN)
      HKL1(3) = FLOAT (M) + ADD
      RETURN
      END
      SUBROUTINE HKLC2 (HKL, ACODE)
      DIMENSION HKL(3), HKL1(3), HMIN(3), HMAX(3)
      DIMENSION ADD(3)
      SAVE
      DATA SPANL, SPANKL, LSPAN, KLSPAN, IDDHKL  / 0.0, 0.0, 0, 0, 0 /
      ACODE = HKL(1) * SPANKL + HKL(2) * SPANL + HKL(3)
      RETURN
      ENTRY HKLC2U (ACODE1, HKL1)
      KCODE   = IFIX  (ACODE1) + IDDHKL
      HKL1(1) = FLOAT (     KCODE         /KLSPAN) + ADD(1)
      HKL1(2) = FLOAT ( MOD(KCODE,KLSPAN) / LSPAN) + ADD(2)
      HKL1(3) = FLOAT ( MOD(KCODE, LSPAN)        ) + ADD(3)
      RETURN
      ENTRY HKLC2I (HMIN, HMAX)
      CALL KERNAB (HMIN, ADD, 3)
      SPANL  = HMAX(3) - HMIN(3) + 1.
      SPANKL = SPANL * (HMAX(2) - HMIN(2) + 1.)
      LSPAN  = IFIX (SPANL  + 0.1)
      KLSPAN = IFIX (SPANKL + 0.1)
      ADDHKL = - HMIN(1) * SPANKL
     *         - HMIN(2) * SPANL - HMIN(3)
      IDDHKL = NINT (ADDHKL)
      RETURN
      END
      SUBROUTINE FCALCI (ATXYZ, IZAT, ITAT, NAT7)
      DIMENSION ATXYZ(10,NAT7), IZAT(NAT7), ITAT(NAT7)
      SAVE
      INCLUDE 'Zaaaa.inc'
      INCLUDE 'Zcrys.inc'
      INCLUDE 'Zfcalx.inc'
      INCLUDE 'Zfcala.inc'
      EQUIVALENCE (ICRYS, IFILE(3))
      LOGICAL EXPAND
      EQUIVALENCE (EXPAND, SWITCH(23))
      CALL KERNZI (0, IZTYPE, 10)
      DO 130 I=1,NTYPE
      CALL RDCRYB (ICRYS, 'ELEM' , KEND)
      IF (KEND.LE.0) THEN
        WRITE (CHOUT, 110) I
  110   FORMAT (' CRYSDA file: ELEM for atom TYPE no. ',I2,' not found')
        CALL KERROR (CHOUT, 0, 'FCALCI')
        ENDIF
      READ (CHIN, 120) IZTYPE(I)
  120 FORMAT (10X, 2X, I8)
  130 CALL RDCRYX (ICRYS, 'SFAC' , SFAC(1,I), 13)
      DO 150 I=1,NSYMM
      IF (ABS(TSYMM(1,I)).GT.0.001 .OR.
     *    ABS(TSYMM(2,I)).GT.0.001 .OR.
     *    ABS(TSYMM(3,I)).GT.0.001 ) THEN
         ITRS(I) = 1
         ELSE
         ITRS(I) = 0
         ENDIF
  150 CONTINUE
      IF (.NOT. EXPAND) CALL ATOMOC (1, ATXYZ, ITAT, NAT)
      CALL KERNZA (0.0, CELPAR, NTYPE)
      AAMULT = AMULT
      IF (EXPAND) AAMULT = ALATT
      DO 161 I=1,NAT
      DO 160 J=1,NTYPE
      IF (IZAT(I).NE.IZTYPE(J)) GOTO 160
      ITAT(I) = J
      CELPAR(J) = CELPAR(J) + ATXYZ(4,I) * AAMULT
  160 CONTINUE
  161 CONTINUE
      IF (KEYT.EQ.3) CALL ATBETA (ATXYZ, NAT)
      CALL SICOT (SICO, 12500)
      ISMAX = IFIX (STLMAX * 400. +0.04) + 2
      IF (ISMAX.LE.500) GOTO 200
      WRITE (CHOUT, 198) STLMAX
  198 FORMAT (' Found max. sin(th/lam) = STLMAX =', F7.3,
     *        ' Max = 1.249 . ??DATA ERROR?? ')
      CALL KERROR (CHOUT, 0, 'FCALCI')
  200 CONTINUE
      BPAV = 0.
      IF (KEYT .GT. 1) THEN
         IZATT = 0
         DO 174 I = 1, NAT
         BPAV = BPAV + ATXYZ(5,I) * IZAT(I) **2
  174    IZATT = IZATT + IZAT(I) ** 2
         BPAV = BPAV / FLOAT(IZATT)
         WRITE (8, 173) BPAV
  173    FORMAT (1X/' FCALCI: Averaged value of Bp for known atoms:',
     *      ' Bp = ', F8.3/1X)
         BP = BPAV
         ENDIF
      DO 260 IS=1,ISMAX
      STL = FLOAT(IS-1) * 0.0025
      STL2 = STL * STL
      EXPBP(IS) = EXP(-BP * STL2)
      EXPBR(IS) = EXP(-BR * STL2)
      SUMF2(IS)  = 0.0
      SUMF2P(IS) = 0.0
      DO 260 I=1,NTYPE
      SFAC6 = AMIN1 (SFAC(6,I) * STL2, 99.99)
      SFAC8 = AMIN1 (SFAC(8,I) * STL2, 99.99)
      FF(IS,I) = SFAC(9,I) + SFAC(10,I)
     * + SFAC(1,I) * EXP (-SFAC(2,I) * STL2)
     * + SFAC(3,I) * EXP (-SFAC(4,I) * STL2)
     * + SFAC(5,I) * EXP (-SFAC6)    + SFAC(7,I) * EXP (-SFAC8)
      SUMF2(IS)  = SUMF2(IS) + FF(IS,I) * FF(IS,I) * CELALL(I)
  260 SUMF2P(IS) = SUMF2P(IS)+ FF(IS,I) * FF(IS,I) * CELPAR(I)
      PSQ = SUMF2P(2)/SUMF2(2)
      P1SQ = PSQ / ASYMC
      IF (.NOT. EXPAND) RETURN
      P1SQ = PSQ
      PSQ = AMIN1 (0.999 , P1SQ * ASYMC)
      RETURN
      END
      SUBROUTINE SICOT (SICO, M)
      DIMENSION SICO(M)
      PARAMETER (PI2 = 2.0 * 3.14159265 )
      M1 = M  / 5
      M2 = M1 * 2
      M4 = M2 * 2
      F = PI2 / FLOAT(M4)
      DO 240 I=1,M1
      AI = SIN (FLOAT(I) * F)
      SICO(I)    = AI
      SICO(M2-I) = AI
      SICO(M2+I) =-AI
      SICO(M4-I) =-AI
  240 SICO(M4+I) = AI
      SICO(M2)   = 0.0
      SICO(M4)   = 0.0
      RETURN
      END
      SUBROUTINE MACOL(A)
      DIMENSION A(3,3)
      N=1
  105 K=2
  110 T=A(K,N)
      A(K,N)=A(N,K)
      A(N,K)=T
      IF (N.EQ.3) RETURN
      K=K+1
      IF (K.LE.3) GOTO 110
      N=3
      GOTO 105
      END
      SUBROUTINE MATINV(A,B,D,KEND)
      DIMENSION A(3,3),B(3,3)
      PARAMETER (DETMAX = 10.E-15)
      KEND=0
      CALL VECAXB (A(1,2),A(1,3),B(1,1))
      CALL VECAXB (A(1,3),A(1,1),B(1,2))
      CALL VECAXB (A(1,1),A(1,2),B(1,3))
      D=A(1,1)*B(1,1)+A(2,1)*B(2,1)+A(3,1)*B(3,1)
      IF (D.LT.DETMAX .AND. D.GT.-DETMAX) KEND = -99
      IF (KEND.EQ.-99) RETURN
      DO 15 N=1,3
      DO 15 K=1,3
   15 B(K,N)=B(K,N)/D
      CALL MACOL(B)
      RETURN
      END
      FUNCTION ERFU (X)
      DIMENSION E(31)
      DATA E / .00000, .11246, .22270, .32863, .42839,
     *         .52050, .60386, .67780, .74210, .79691,
     *         .84270, .88021, .91031, .93401, .95229,
     *         .96611, .97635, .98379, .98909, .99279,
     *         .99532, .99702, .99814, .99886, .99931,
     *         .99959, .99976, .99987, .99992, .99996, .99998 /
      X10 = X*10. + 1.00001
      IX = X10
      IF (IX.GT.30) GOTO 100
      ERFU = E(IX) + (X10-IX) * (E(IX+1)-E(IX))
      RETURN
  100 ERFU = 1.
      RETURN
      END
      FUNCTION IPHFIX (HKL)
      DIMENSION HKL(3)
      INCLUDE 'Zcrys.inc'
      DIMENSION ICODE(13), LTEST(3), IHKL(3)
      DATA ICODE / 2, -1, 9, 8, 7, -1, 6, -1, 5, 4, 3, -1, 2 /
      CALL KERF2I (HKL, IHKL, 3)
      IF(ICENT.EQ.1) GOTO 150
      IPHFIX = 2
      RETURN
  150 IPHFIX = 1
      IOLD = -1
      DO 180 I=2,NSYMM
      XTEST = 0.0
      KTEST = 0
      DO 170 J=1,3
      LTEST(J) = 0
      DO 160 L=1,3
  160 LTEST(J) = LTEST(J) + IHKL(L)*IRSYMM(L,J,I)
      KTEST = KTEST + IHKL(J) + LTEST(J)
      IF (KTEST.NE.0) GOTO 180
  170 XTEST = XTEST - (HKL(J) * TSYMM(J,I))
      XTEST = XTEST - IFIX(XTEST)
      IF (XTEST.LT.-0.01) XTEST = XTEST + 1.0
      IPHS = IFIX(12.*XTEST+0.1) + 1
      IPHFIX = ICODE(IPHS)
      IF (IOLD.EQ.-1) IOLD = IPHFIX
      IF (IPHFIX.NE.IOLD) GOTO 190
  180 CONTINUE
      IF (IPHFIX.GE.1) RETURN
  190 IPHFIX = -1
      RETURN
      END
      FUNCTION E2EXP (ITYP, E1, E2)
      EX1 = E1 * E1
      EX2 = E2 * E2
      IF (ITYP.NE.0) GOTO 100
      Q = (EX2-EX1) / 2.0
      E2EXP = EX1 + Q * (1. - SIMW(Q))
      RETURN
  100 EXX1 = EXP(-EX1*.5)
      EX3 = EXX1 / (EXX1 + EXP(-EX2*.5) )
      E2EXP = EX1*EX3 + (1.0 - EX3)*EX2
      RETURN
      END
      FUNCTION SIMW (Q)
      SIMW = ((0.0106 * Q - 0.1304) * Q + 0.5658) * Q
      IF (Q.GT.5.) SIMW=0.8565 + 0.0075*Q
      RETURN
      END
      SUBROUTINE MATC2F (CELL, CX)
      DIMENSION CELL(6), CX(3,3)
      DIMENSION CELLT(6)
      EQUIVALENCE (A   ,CELLT(1)),  (B   ,CELLT(2))
      EQUIVALENCE (C   ,CELLT(3)),  (ALPH,CELLT(4))
      EQUIVALENCE (BET ,CELLT(5)),  (GAMM,CELLT(6))
      CALL KERNAB (CELL, CELLT, 6)
      D2R = ATAN(1.0) / 45.0
      ALPHA = ALPH * D2R
      BETA = BET * D2R
      GAMMA = GAMM * D2R
      COSA = COS(ALPHA)
      COSB = COS(BETA)
      COSC = COS(GAMMA)
      SINC = SIN(GAMMA)
      S = 0.5*(ALPHA+BETA+GAMMA)
      V = A*B*C *2. *SQRT(SIN(S)*SIN(S-ALPHA)*SIN(S-BETA)*SIN(S-GAMMA))
      CX(1,1) = 1./A
      CX(1,2) = -COSC/(A*SINC)
      CX(1,3) = B*C*(COSC*COSA-COSB)/(V*SINC)
      CX(2,1) = 0.
      CX(2,2) = 1./(B*SINC)
      CX(2,3) = A*C*(COSB*COSC-COSA)/(V*SINC)
      CX(3,1) = 0.
      CX(3,2) = 0.
      CX(3,3) = A*B*SINC/V
      RETURN
      END
      SUBROUTINE MATF2C (CELL, XC)
      DIMENSION CELL(6), XC(3,3)
      DIMENSION CELLT(6)
      EQUIVALENCE (A   ,CELLT(1)),  (B   ,CELLT(2))
      EQUIVALENCE (C   ,CELLT(3)),  (ALPH,CELLT(4))
      EQUIVALENCE (BET ,CELLT(5)),  (GAMM,CELLT(6))
      CALL KERNAB (CELL, CELLT, 6)
      D2R = ATAN(1.0) / 45.0
      ALPHA = ALPH * D2R
      BETA = BET * D2R
      GAMMA = GAMM * D2R
      COSA = COS(ALPHA)
      COSB = COS(BETA)
      COSC = COS(GAMMA)
      SINC = SIN(GAMMA)
      S = 0.5*(ALPHA+BETA+GAMMA)
      V = A*B*C *2. *SQRT(SIN(S)*SIN(S-ALPHA)*SIN(S-BETA)*SIN(S-GAMMA))
      XC(1,1) = A
      XC(1,2) = B*COSC
      XC(1,3) = C*COSB
      XC(2,1) = 0.
      XC(2,2) = B*SINC
      XC(2,3) = -C*(COSB*COSC-COSA)/SINC
      XC(3,1) = 0.
      XC(3,2) = 0.
      XC(3,3) = V/(A*B*SINC)
      RETURN
      END
      SUBROUTINE VECAXB (A, B, V)
      DIMENSION A(3), B(3), V(3)
      T1   = A(2) * B(3) - A(3) * B(2)
      T2   = A(3) * B(1) - A(1) * B(3)
      V(3) = A(1) * B(2) - A(2) * B(1)
      V(1) = T1
      V(2) = T2
      RETURN
      END
      SUBROUTINE MATAXB (A, B, P)
      DIMENSION A(3,3), B(3,3), P(3,3)
      DO 112 K = 1, 3
      DO 111 L = 1, 3
      P(K,L) = A(K,1) * B(1,L) + A(K,2) * B(2,L) + A(K,3) * B(3,L)
  111 CONTINUE
  112 CONTINUE
      RETURN
      END
      SUBROUTINE MATAXI (IA, IB, IP)
      DIMENSION IA(3,3), IB(3,3), IP(3,3)
      DO 112 I = 1, 3
      DO 111 J = 1, 3
      IP(I,J) = IA(I,1) * IB(1,J) +IA(I,2) * IB(2,J) +IA(I,3) * IB(3,J)
  111 CONTINUE
  112 CONTINUE
      RETURN
      END
      SUBROUTINE MAT6XV (XC, X, C)
      DIMENSION XC(3,3), X(3), C(3)
      C(1) = X(1)*XC(1,1) + X(2)*XC(1,2) + X(3)*XC(1,3)
      C(2) =                X(2)*XC(2,2) + X(3)*XC(2,3)
      C(3) =                               X(3)*XC(3,3)
      RETURN
      END
      SUBROUTINE MATXV3 (RR, A, B)
      DIMENSION RR(3,3), A(3), B(3)
      T1   = RR(1,1) * A(1) + RR(1,2) * A(2) + RR(1,3) * A(3)
      T2   = RR(2,1) * A(1) + RR(2,2) * A(2) + RR(2,3) * A(3)
      B(3) = RR(3,1) * A(1) + RR(3,2) * A(2) + RR(3,3) * A(3)
      B(1) = T1
      B(2) = T2
      RETURN
      END
      SUBROUTINE VXMATI (K, IR, L)
      DIMENSION K(3), IR(3,3), L(3)
      L1   = K(1) * IR(1,1)  + K(2) * IR(2,1)  + K(3) * IR(3,1)
      L2   = K(1) * IR(1,2)  + K(2) * IR(2,2)  + K(3) * IR(3,2)
      L(3) = K(1) * IR(1,3)  + K(2) * IR(2,3)  + K(3) * IR(3,3)
      L(1) = L1
      L(2) = L2
      RETURN
      END
      SUBROUTINE VMATV1 (A, R, B, Q)
      DIMENSION  A(3), R(3,3), B(3)
      Q=A(1) * (R(1,1) * B(1) + R(1,2) * B(2) + R(1,3) * B(3)) +
     *  A(2) * (R(2,1) * B(1) + R(2,2) * B(2) + R(2,3) * B(3)) +
     *  A(3) * (R(3,1) * B(1) + R(3,2) * B(2) + R(3,3) * B(3))
      RETURN
      END
      SUBROUTINE MATABC (AE, BE, CE, R)
      DIMENSION  R(3,3)
      D2R = ATAN(1.0) / 45.0
      CA = COS (AE * D2R)
      CB = COS (BE * D2R)
      CC = COS (CE * D2R)
      SA = SIN (AE * D2R)
      SB = SIN (BE * D2R)
      SC = SIN (CE * D2R)
      CALL MATEUL (CA, CB, CC, SA, SB, SC, R)
      RETURN
      END
      SUBROUTINE MATEUL (CA, CB, CC, SA, SB, SC, R)
      DIMENSION  R(3,3)
      R(1,1) = CB
      R(1,2) = SB * SC
      R(1,3) = -SB * CC
      R(2,1) = SA * SB
      R(2,2) = CA * CC - SA * CB * SC
      R(2,3) = SA * CB * CC + CA * SC
      R(3,1) = CA * SB
      R(3,2) =-CA * CB * SC - SA * CC
      R(3,3) = CA * CB * CC - SA * SC
      RETURN
      END
      SUBROUTINE SYMM (X, Y, Z)
      INCLUDE 'Zsyst.inc'
      EQUIVALENCE (KLAUE, KEYS(6))
      IF (KLAUE.LT.0) THEN
        IF (Y.LT.0.0) THEN
            X=-X
            Y=-Y
            Z=-Z
        ENDIF
        IF (X.LT.0.0) X=1.+X
        IF (Z.LT.0.0) Z=1.+Z
        RETURN
      ENDIF
      GOTO (5, 15, 25, 35), KLAUE
   5  IF (X.GE.0.0) RETURN
      X = -X
      Y = -Y
      Z = -Z
      RETURN
   15 Y = ABS(Y)
      IF (X.GE.0.0) RETURN
      X = -X
      Z = -Z
      RETURN
   25 X = ABS(X)
      Y = ABS(Y)
      Z = ABS(Z)
      RETURN
   35 Z = ABS(Z)
      IF (X.GE.0.0) RETURN
      X = -X
      Y = -Y
      RETURN
      END
      SUBROUTINE NULL5 (IX, I1, I2, I3, I4, I5)
      I1 = IX
      I2 = IX
      I3 = IX
      I4 = IX
      I5 = IX
      RETURN
      END
      SUBROUTINE ZERO5 (FX, F1, F2, F3, F4, F5)
      F1 = FX
      F2 = FX
      F3 = FX
      F4 = FX
      F5 = FX
      RETURN
      END
      SUBROUTINE DDEXIT
      INCLUDE 'Zsyst.inc'
      DIMENSION FIL(15)
      CHARACTER FIL*6
      DATA FIL /'MSDOS',  'DDJOB',  'DDSYST', 'CONDA',  'ORBASE',
     *          'BINFC',  'DDHELP', '$XPTB$', '$XPTB$', '$XPTB$',
     *          '$XPTB$', '$XPTB$', '$XPTB$', '$XPTB$', '$XPTB$'/
      CALL WR24
      IF (CCODE .EQ. ' ') THEN
         WRITE (9, 433)
  433    FORMAT (1X/' End of DIRDIF  -  bye-bye'/1X)
      ELSE
         WRITE (9, 434) CCODE
  434    FORMAT (1X/' End of DIRDIF for ', A6, ' -  bye-bye'/1X)
         ENDIF
      CALL WR24
      CALL FILCLO (4, 'KEEP')
      CALL KERASE ('LIS4')
      OPEN (UNIT = 4, FORM = 'FORMATTED', FILE='lis4',STATUS = 'NEW')
      WRITE (4, FMT='(''LIS4 '', A6 /1X/
     *   '' File lis4 = copy of console (=screen) output''/1X/
     *   '' This file will be overwritten at each DIRDIF call''/1X/1X)')
     *   CCODE
      REWIND 7
  103 CHIN = '  '
      READ (7, END = 105, FMT='(A)') CHIN
      IF ( CHIN(1:2) .EQ. '! ') WRITE (4, FMT='(A)') CHIN
      GOTO 103
  105 CONTINUE
      CALL FILCLO (4, 'KEEP')
      CALL KERASE ('LIS5')
      OPEN (UNIT = 4, FORM = 'FORMATTED', FILE='lis5',STATUS = 'NEW')
      WRITE (4, FMT='(''LIS5 '', A6 /1X/
     *   '' File lis5 = copy of test => $TE records from LIS2''/1X/
     *   '' This file will be overwritten at each DIRDIF call''/1X/
     *   '' =================================================''/1X)')
     *   CCODE
      CALL WRLIS5
      DO 144 I = 1, 20
      IF (I.EQ.5 .OR. I.EQ.6 .OR. I.EQ.9) GOTO 144
      CALL FILCLO (I, 'KEEP')
  144 CONTINUE
      DO 200 I = 1, 15
      CALL KERASE (FIL(I))
  200 CONTINUE
      IF (LITJ2 .NE. 'CRYSDA') CALL KERASE ('CRYSDA')
      STOP
      END
