/*
 * terminals.c -- part of the C sources generated from the CDL3 sources,
 *              used to bootstrap CDL3
 * Copyright (C) 2000  C.H.A. Koster
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "cdl3rts.h"
#include "predef.h"


static char* module_name = "terminals";

/*
** GLOBALS
*/

	static long undefined[] = {1023};
long G_terminals_HASHEDTERMINALS_NR0B = 0;
value G_terminals_HASHEDTERMINALS_NR0 = &G_terminals_HASHEDTERMINALS_NR0B;
long G_terminals_TERMINALS_NR1B = 0;
value G_terminals_TERMINALS_NR1 = &G_terminals_TERMINALS_NR1B;
long G_terminals_NR_OF_TERMINALS_NR2 = 0;
long G_terminals_TERMINALNRLIST_NR2896[] = {Tag(1,1)};

/*
** ATTACH/DETACH/EQUAL
*/
/****TERMINALNRLIST(terminals)****/

int EQ_Mterminals_T11(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return (Part(x,1) == Part(y,1))&&EQ_Mterminals_T11(Part(x,2),Part(y,2));
       case 1:
         return 1;
    };
  return 0;
}

int W_Mterminals_T11(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
W_INT(Part(x,1));
WRITE(" ");
W_Mterminals_T11(Part(x,2));
WRITE(" ");
       case 1:
WRITE("end ");
    };
  return 0;
}

int XD_Mterminals_T11(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_Mterminals_T11(Part(x,2));
            Free(x,3);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Mterminals_T11(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mterminals_T11(x);
}


/*
** PROTOTYPES
*/

_PROTOTYPE(int Mterminals_P_convert_TERMINAL_TERMINALNR,(value P0,value *P1));
_PROTOTYPE(int Mterminals_P_get_TERMINALNR_TERMINAL,(value P0,value *P1));
_PROTOTYPE(int Mterminals_P_error_terminal_TERMINALNR,(value P0));
_PROTOTYPE(int Mterminals_P_init_terminal_table,());
_PROTOTYPE(int Mterminals_P_hash_TERMINAL_INDEX,(value P0,value *P1));
_PROTOTYPE(int Mterminals_P_init_hash_table_INDEX,(value P0));
_PROTOTYPE(int Mterminals_P_exists_TERMINAL_TERMINALNRLIST_TERMINALNR,(value P0,value P1,value *P2));


/*
**EXTERNAL PROTOTYPES**
*/

_PROTOTYPE(extern int E1_open_input_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E2_open_output_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E3_open_standard_output_FILE,(value *P0));
_PROTOTYPE(extern int E4_open_standard_error_FILE,(value *P0));
_PROTOTYPE(extern int E5_open_standard_input_FILE,(value *P0));
_PROTOTYPE(extern int E8_pipe_to_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E28_pipe_from_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E9_close_pipe_FILE,(value P0));
_PROTOTYPE(extern int E6_close_FILE,(value P0));
_PROTOTYPE(extern int E7_seek_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E10_write_TEXT,(value P0));
_PROTOTYPE(extern int E11_write_INT,(value P0));
_PROTOTYPE(extern int E12_write_FILE_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E13_write_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E14_formatted_write_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E15_write_char_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E16_write_char_INT,(value P0));
_PROTOTYPE(extern int E20_trace_TEXT,(value P0));
_PROTOTYPE(extern int E21_trace_INT,(value P0));
_PROTOTYPE(extern int E22_formatted_trace_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E30_read_line_TEXT,(value *P0));
_PROTOTYPE(extern int E31_read_line_FILE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E32_read_char_FILE_INT,(value P0,value *P1));
_PROTOTYPE(extern int E33_read_char_INT,(value *P0));
_PROTOTYPE(extern int E40_less_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E41_lesseq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E42_greater_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E43_greatereq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E58_length_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E51_extract_TEXT_INT_INT_TEXT,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int E52_is_subtext_TEXT_INT_TEXT,(value P0,value *P1,value P2));
_PROTOTYPE(extern int E53_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E54_not_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E55_before_TEXT_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E56_is_prefix_TEXT_TEXT_TEXT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E57_prefix_TEXT_INT_TEXT_TEXT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int E59_asciicode_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E60_bindec_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E61_decbin_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E70_hash_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E80_command_arg_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E81_exit_INT,(value P0));
_PROTOTYPE(extern int E82_get_from_environment_TEXT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E83_time_INT,(value *P0));
_PROTOTYPE(extern int E85_file_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E84_execute_TEXT,(value P0));
_PROTOTYPE(extern int E200_get_key_TEXT,(value *P0));
_PROTOTYPE(extern int Merrors_P_status_message_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_status_message_MODULENR,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_int_INT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_error_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_int_INT,(value P0));
_PROTOTYPE(extern int Mnodes_P_new_NODENR,(value *P0));
_PROTOTYPE(extern int Mnodes_P_store_NODENR_LINENR_NODE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mnodes_P_get_NODENR_LINENR_NODE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mnodes_P_append_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_append_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_pass_two_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_error_SUBEXPRESSION,(value P0));
_PROTOTYPE(extern int Mnodes_P_error_EXPRESSION,(value P0));
_PROTOTYPE(extern int Mcode_P_start_coding,());
_PROTOTYPE(extern int Mcode_P_new_LABEL,(value *P0));
_PROTOTYPE(extern int Mcode_P_error_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_error_MONADIC_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_store_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_append_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_overwrite_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_move_LOCATION_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_current_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_set_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_get_LOCATION_INSTRUCTION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_next_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_is_end_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_first_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_next_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_is_associative_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS,(value P0));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_alias_LABEL_LABEL,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_absorb_goto_LABEL_INSTRUCTION_INT_INT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int Mcode_P_called_once_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_get_label_LABEL_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_no_effect_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_write_ADDRESS,(value P0));
_PROTOTYPE(extern int Mcode_P_get_ADDRESS_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_get_ADDRESSES_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_dump_code_MODULENR_TEXT,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_dump_instruction_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_dump_code_TEXT_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_make_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mcode_P_request_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mrules_P_propagate_rules,());
_PROTOTYPE(extern int Mrules_P_convert_MODULENR_RULENAME_ARITY_RULEID,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_syntax_rule_RULEID_RULETYPE_PARAMETERS_NODENR_RULENR,(value P0,value P1,value P2,value *P3,value *P4));
_PROTOTYPE(extern int Mrules_P_export_rule_RULEID_RULETYPE_PARAMETERS_RULENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_external_rule_RULEID_RULETYPE_PARAMETERS_EXTNR_NODENR_RULENR,(value P0,value P1,value P2,value P3,value *P4,value *P5));
_PROTOTYPE(extern int Mrules_P_is_external_RULENR_EXTNR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_in_interface_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_is_fixed_RULENR_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_NODENR,(value P0,value *P1,value *P2,value *P3,value *P4,value *P5,value *P6));
_PROTOTYPE(extern int Mrules_P_get_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULETYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_PARAMETERS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_set_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mrules_P_get_preludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_postludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_interludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_error_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_error_RULENAME,(value P0));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENAME_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_definition_errors,());
_PROTOTYPE(extern int Mrules_P_set_root_error_handler_HANDLER,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_error_handler_HANDLER,(value *P0));
_PROTOTYPE(extern int Mrules_P_set_root_rule_ROOT,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_rule_ROOT,(value *P0));
_PROTOTYPE(extern int Mvariables_P_convert_PASS_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value P4,value *P5));
_PROTOTYPE(extern int Mvariables_P_store_global_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int Mvariables_P_parameter_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_temporary_MODULENR_RULENR_TYPENR_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_constant_MODULENR_TYPENR_VALUE_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value *P1,value *P2,value *P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_set_VARIABLENR_OFFSET,(value P0,value P1));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_OFFSET,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_not_local_VARIABLENR,(value P0));
_PROTOTYPE(extern int Mvariables_P_is_constant_VARIABLENR_VALUE,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_global_VARIABLENR_REFNO,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_first_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_next_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_error_INSTANCE,(value P0));
_PROTOTYPE(extern int Mvariables_P_build_instance_INSTANCE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_propagate_types,());
_PROTOTYPE(extern int Mtypes_P_convert_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_abstract_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_external_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_synonym_MODULENR_TYPENAME_TYPENR_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_export_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_is_imported_abstract_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_abstract_type_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_special_type_TYPENR_STYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_external_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_integer_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_undefined_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_exported_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_same_TYPE_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_same_TYPENR_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_integer_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_is_text_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_text_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_equal_types_TYPENR_TYPENR,(value P0,value P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPENAME_MODULENR,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_first_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_next_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_error_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_build_type_TYPENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_type_errors,());
_PROTOTYPE(extern int Mmodules_P_init_modules,());
_PROTOTYPE(extern int Mmodules_P_is_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_set_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_new_id_MODULENR_ID,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_order_MODULENR_MODULEORDER,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_convert_MODULE_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_add_import_for_module_MODULENR_MODULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_store_versionid_MODULENR_VERSIONTEXT,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_module_exports_rule_MODULENR_RULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_get_exported_rules_from_module_MODULENR_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_MODULE,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_module_name_MODULENR_MODULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_VERSIONTEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_EXPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_IMPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_first_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_next_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_error_MODULENR,(value P0));
_PROTOTYPE(extern int Mscanner_P_syntax_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Mscanner_P_current_line_LINENR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_open_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_close,());
_PROTOTYPE(extern int Mscanner_P_end_of_file,());
_PROTOTYPE(extern int Mscanner_P_is_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_ahead_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_should_be_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME_INSTANCE,(value *P0,value *P1));
_PROTOTYPE(extern int Mscanner_P_is_placeholder_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TERMINAL,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_MODULE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_SIZE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_EXTNR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_NUMBER,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_STRING,(value *P0));
_PROTOTYPE(extern int Manalyzer_P_semantic_errors,());
_PROTOTYPE(extern int Manalyzer_P_analyse_main_MODULENR_ROOT,(value P0,value P1));
_PROTOTYPE(extern int Manalyzer_P_analyse_rules_MODULENR,(value P0));
_PROTOTYPE(extern int Manalyzer_P_resolve_call_ahead_NODENR_RULENR,(value P0,value *P1));
_PROTOTYPE(extern int Manalyzer_P_warnings_on,());
_PROTOTYPE(extern int Minline_P_declare_rule_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_register_call_RULENR_NODENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_inline_TEXT,(value P0));
_PROTOTYPE(extern int Minline_P_inline_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_disable_inlining,());
_PROTOTYPE(extern int Minline_P_ignore_unreachable_code,());
_PROTOTYPE(extern int Minline_P_rule_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_call_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_resolve_call_graph_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_is_recursive_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_rule_is_reachable_RULENR,(value P0));
_PROTOTYPE(extern int Mcoder_P_no_code,());
_PROTOTYPE(extern int Mcoder_P_no_gc,());
_PROTOTYPE(extern int Mcoder_P_trace_on,());
_PROTOTYPE(extern int Mcoder_P_produce_statistics,());
_PROTOTYPE(extern int Mcoder_P_profile_on,());
_PROTOTYPE(extern int Mcoder_P_just_compile_and_no_object,());
_PROTOTYPE(extern int Mcoder_P_extension_TEXT,(value *P0));
_PROTOTYPE(extern int Mcoder_P_external_names_do_not_start_with_underscore,());
_PROTOTYPE(extern int Mcoder_P_optimize_array_references,());
_PROTOTYPE(extern int Mcoder_P_code_MODULENR,(value P0));
_PROTOTYPE(extern int Mfiles_P_paths_PATHS,(value *P0));
_PROTOTYPE(extern int Mfiles_P_init_files,());
_PROTOTYPE(extern int Mfiles_P_strip_path_TEXT_TEXT_TEXT,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mfiles_P_set_lib_path_TEXT,(value P0));
_PROTOTYPE(extern int Mfiles_P_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mfiles_P_open_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int Mbitmap_P_new_BITMAP,(value *P0));
_PROTOTYPE(extern int Mbitmap_P_new_INT_BITMAP,(value P0,value *P1));
_PROTOTYPE(extern int Mbitmap_P_new_INT_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_exclude_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_or_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_and_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_equal_BITMAP_BITMAP,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_set_BITMAP_INT,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_empty_BITMAP,(value P0));
_PROTOTYPE(extern int Mbitmap_P_clear_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_set_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_write_BITMAP,(value P0));
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion,());
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion_RULENR_LOCATION,(value P0,value P1));

/*
** CODE
*/

int Mterminals_P_convert_TERMINAL_TERMINALNR(P0,P1)
value P0;
value *P1;
{
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L3 = L0;
  Mterminals_P_hash_TERMINAL_INDEX(L3,&L4);
  L5 = (value) Addr((value*)&G_terminals_HASHEDTERMINALS_NR0,Int(L4));
  L6 = *((value*)L5);
  L8 = L3;
  L9 = L6;
LAB25:
  switch (Alternative(L9)) {
  case 0: goto LAB26;
  default: goto LAB1;
  };
LAB26:
  L10 = (value)(L9[1]);
  L11 = (value)(L9[2]);
  L12 = (value) Addr((value*)&G_terminals_TERMINALS_NR1,Int(L10));
  L13 = *((value*)L12);
  if (!EQ_TEXT(L13,L8)) goto LAB31;
  L7 = L10;
LAB29:
  L1 = L7;
LAB24:
  *P1 = L1;
  return 1;
LAB31:
  L9 = L11;
  goto LAB25;
LAB1:
  L15 = L0;
  Mterminals_P_hash_TERMINAL_INDEX(L15,&L16);
  L17 = (value)G_terminals_NR_OF_TERMINALS_NR2;
  L18 = (value)G_terminals_NR_OF_TERMINALS_NR2;
  L19 = C_INT(1);
  L20 = C_INT(Int(L18) + Int(L19));
  G_terminals_NR_OF_TERMINALS_NR2 = (long)L20;
  L21 = (value) Addr((value*)&G_terminals_TERMINALS_NR1,Int(L17));
  ATTACH(L15);
D_TEXT(*((value*)L21));
  *((value *)L21) = L15;
  Create(&L22,0,2);
  *(value *)(L22+1) = L17;
  L23 = (value) Addr((value*)&G_terminals_HASHEDTERMINALS_NR0,Int(L16));
  L24 = *((value*)L23);
  ATTACH(L24);
  *(value *)(L22+2) = L24;
if(DecrRefs(*((value*)L23))<0)
XD_Mterminals_T11(*((value*)L23));
  *((value *)L23) = L22;
  L2 = L17;
LAB36:
  *P1 = L2;
  return 1;
}

int Mterminals_P_get_TERMINALNR_TERMINAL(P0,P1)
value P0;
value *P1;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_terminals_TERMINALS_NR1,Int(L0));
  L2 = *((value*)L1);
  *P1 = L2;
  ATTACH(L2);
  return 1;
}

int Mterminals_P_error_terminal_TERMINALNR(P0)
value P0;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value) Addr((value*)&G_terminals_TERMINALS_NR1,Int(L0));
  L2 = *((value*)L1);
  Merrors_P_error_text_TEXT(L2);
  return 1;
}

int Mterminals_P_init_terminal_table()
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = C_INT(0);
  G_terminals_NR_OF_TERMINALS_NR2 = (long)L0;
  L1 = C_INT(1024);
  L2 = L1;
LAB39:
  switch (Int(L2)) {
  case 0: goto LAB38;
  default: goto LAB42;
  };
LAB42:
  L3 = C_INT(1);
  L4 = C_INT(Int(L2) - Int(L3));
  L5 = G_terminals_TERMINALNRLIST_NR2896;
  L6 = (value) Addr((value*)&G_terminals_HASHEDTERMINALS_NR0,Int(L4));
  ATTACH(L5);
if(DecrRefs(*((value*)L6))<0)
XD_Mterminals_T11(*((value*)L6));
  *((value *)L6) = L5;
  L2 = L4;
  goto LAB39;
LAB38:
  return 1;
}

int Mterminals_P_hash_TERMINAL_INDEX(P0,P1)
value P0;
value *P1;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = C_INT(1024);
  E70_hash_TEXT_INT_INT(L0,L1,&L2);
  *P1 = L2;
  return 1;
}

int Mterminals_P_init_hash_table_INDEX(P0)
value P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB37:
  switch (Int(L0)) {
  case 0: goto LAB2;
  default: goto LAB4;
  };
LAB2:
  return 1;
LAB4:
  L1 = C_INT(1);
  L2 = C_INT(Int(L0) - Int(L1));
  L3 = G_terminals_TERMINALNRLIST_NR2896;
  L4 = (value) Addr((value*)&G_terminals_HASHEDTERMINALS_NR0,Int(L2));
  ATTACH(L3);
if(DecrRefs(*((value*)L4))<0)
XD_Mterminals_T11(*((value*)L4));
  *((value *)L4) = L3;
  L0 = L2;
  goto LAB37;
}

int Mterminals_P_exists_TERMINAL_TERMINALNRLIST_TERMINALNR(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB14:
  switch (Alternative(L1)) {
  case 0: goto LAB5;
  default: goto LAB7;
  };
LAB5:
  L2 = (value)(L1[1]);
  L3 = (value)(L1[2]);
  L4 = (value) Addr((value*)&G_terminals_TERMINALS_NR1,Int(L2));
  L5 = *((value*)L4);
  if (!EQ_TEXT(L5,L0)) goto LAB9;
  *P2 = L2;
  return 1;
LAB9:
  L1 = L3;
  goto LAB14;
  return 0;
LAB7:
  return 0;
}

